/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeeper;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.CollectionStringBuffer;

@UriParams
public class ZooKeeperConfiguration
implements Cloneable {
    @UriPath
    @Metadata(required=true)
    private String serverUrls;
    private List<String> servers;
    @UriPath
    @Metadata(required=true)
    private String path;
    @UriParam(defaultValue="5000")
    private int timeout = 5000;
    @UriParam(label="consumer", defaultValue="5000")
    private long backoff = 5000L;
    @UriParam(label="consumer")
    private boolean repeat;
    @UriParam
    private boolean listChildren;
    @UriParam(label="producer")
    private boolean create;
    @UriParam(label="producer", enums="PERSISTENT,PERSISTENT_SEQUENTIAL,EPHEMERAL,EPHEMERAL_SEQUENTIAL", defaultValue="EPHEMERAL")
    private String createMode;
    @UriParam(label="consumer", defaultValue="true")
    private boolean sendEmptyMessageOnDelete = true;

    public void addZookeeperServer(String server) {
        if (this.servers == null) {
            this.servers = new ArrayList<String>();
        }
        this.servers.add(server);
    }

    public ZooKeeperConfiguration copy() {
        try {
            return (ZooKeeperConfiguration)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public List<String> getServers() {
        return this.servers;
    }

    public String getServerUrls() {
        if (this.servers != null) {
            CollectionStringBuffer csb = new CollectionStringBuffer(",");
            for (String server : this.servers) {
                csb.append((Object)server);
            }
            return csb.toString();
        }
        return null;
    }

    public void setServers(List<String> servers) {
        this.servers = servers;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean isListChildren() {
        return this.listChildren;
    }

    public void setListChildren(boolean listChildren) {
        this.listChildren = listChildren;
    }

    public String getConnectString() {
        StringBuilder b = new StringBuilder();
        for (String server : this.servers) {
            b.append(server).append(",");
        }
        b.setLength(b.length() - 1);
        return b.toString();
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isRepeat() {
        return this.repeat;
    }

    public void setRepeat(boolean repeat) {
        this.repeat = repeat;
    }

    public long getBackoff() {
        return this.backoff;
    }

    public void setBackoff(long backoff) {
        this.backoff = backoff;
    }

    public boolean isCreate() {
        return this.create;
    }

    public void setCreate(boolean shouldCreate) {
        this.create = shouldCreate;
    }

    public String getCreateMode() {
        return this.createMode;
    }

    public void setCreateMode(String createMode) {
        this.createMode = createMode;
    }

    public boolean isSendEmptyMessageOnDelete() {
        return this.sendEmptyMessageOnDelete;
    }

    public void setSendEmptyMessageOnDelete(boolean sendEmptyMessageOnDelete) {
        this.sendEmptyMessageOnDelete = sendEmptyMessageOnDelete;
    }
}

