/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tools.apt.helper;

public final class Strings {
    private Strings() {
    }

    public static boolean isNullOrEmpty(String text) {
        return text == null || text.length() == 0 || "null".equals(text);
    }

    public static String safeNull(String text) {
        if (Strings.isNullOrEmpty(text)) {
            return "";
        }
        return text;
    }

    public static String getOrElse(String text, String defaultValue) {
        return text != null ? text : defaultValue;
    }

    public static String after(String text, String after) {
        if (!text.contains(after)) {
            return null;
        }
        return text.substring(text.indexOf(after) + after.length());
    }

    public static String canonicalClassName(String className) {
        int pos = className.indexOf(60);
        if (pos != -1) {
            return className.substring(0, pos);
        }
        return className;
    }

    public static String doubleQuote(String text) {
        return Strings.quote(text, "\"");
    }

    public static String singleQuote(String text) {
        return Strings.quote(text, "'");
    }

    public static String quote(String text, String quote) {
        return quote + text + quote;
    }

    public static String between(String text, String start, String end) {
        int pos2;
        int pos = text.indexOf(start);
        if (pos > 0) {
            text = text.substring(pos + 1);
        }
        if ((pos2 = text.lastIndexOf(end)) > 0) {
            text = text.substring(0, pos2);
        }
        return text;
    }

    public static String asTitle(String name) {
        StringBuilder sb = new StringBuilder();
        for (char c : name.toCharArray()) {
            boolean first;
            boolean upper = Character.isUpperCase(c);
            boolean bl = first = sb.length() == 0;
            if (first) {
                sb.append(Character.toUpperCase(c));
                continue;
            }
            if (upper) {
                char prev = sb.charAt(sb.length() - 1);
                if (!Character.isUpperCase(prev)) {
                    sb.append(' ');
                }
                sb.append(c);
                continue;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString().trim();
    }
}

