/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tools.apt;

import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.apache.camel.tools.apt.AbstractCamelAnnotationProcessor;

public abstract class AbstractTypeConverterGenerator
extends AbstractCamelAnnotationProcessor {
    @Override
    protected void doProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) throws Exception {
        TreeMap<String, ClassConverters> converters = new TreeMap<String, ClassConverters>();
        Comparator comparator = (o1, o2) -> this.processingEnv.getTypeUtils().isAssignable((TypeMirror)o1, (TypeMirror)o2) ? -1 : (this.processingEnv.getTypeUtils().isAssignable((TypeMirror)o2, (TypeMirror)o1) ? 1 : o1.toString().compareTo(o2.toString()));
        TypeElement converterAnnotationType = this.processingEnv.getElementUtils().getTypeElement("org.apache.camel.Converter");
        String currentClass = null;
        boolean ignoreOnLoadError = false;
        for (Element element : roundEnv.getElementsAnnotatedWith(converterAnnotationType)) {
            if (element.getKind() == ElementKind.CLASS) {
                TypeElement te = (TypeElement)element;
                if (te.getNestingKind().isNested() || !this.acceptClass(te)) continue;
                currentClass = te.getQualifiedName().toString();
                ignoreOnLoadError = AbstractTypeConverterGenerator.isIgnoreOnLoadError(element);
                continue;
            }
            if (currentClass == null || element.getKind() != ElementKind.METHOD) continue;
            String key = this.convertersKey(currentClass);
            ExecutableElement ee = (ExecutableElement)element;
            if (AbstractTypeConverterGenerator.isFallbackConverter(ee)) {
                converters.computeIfAbsent(key, c -> new ClassConverters(comparator)).addFallbackTypeConverter(ee);
                if (!converters.containsKey(key)) continue;
                ((ClassConverters)converters.get(key)).setIgnoreOnLoadError(ignoreOnLoadError);
                continue;
            }
            TypeMirror to = ee.getReturnType();
            TypeMirror from = ee.getParameters().get(0).asType();
            String fromStr = this.toString(from);
            if (!fromStr.endsWith("[]")) {
                TypeElement e = this.processingEnv.getElementUtils().getTypeElement(fromStr);
                if (e != null) {
                    from = e.asType();
                } else {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Could not retrieve type element for " + fromStr);
                }
            }
            converters.computeIfAbsent(key, c -> new ClassConverters(comparator)).addTypeConverter(to, from, ee);
            if (!converters.containsKey(key)) continue;
            ((ClassConverters)converters.get(key)).setIgnoreOnLoadError(ignoreOnLoadError);
        }
        this.writeConverters(converters);
    }

    abstract String convertersKey(String var1);

    abstract void writeConverters(Map<String, ClassConverters> var1) throws Exception;

    abstract boolean acceptClass(Element var1);

    private static boolean isIgnoreOnLoadError(Element element) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!"ignoreOnLoadError".equals(entry.getKey().getSimpleName().toString())) continue;
                return (Boolean)entry.getValue().getValue();
            }
        }
        return false;
    }

    private static boolean isFallbackCanPromote(Element element) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!"fallbackCanPromote".equals(entry.getKey().getSimpleName().toString())) continue;
                return (Boolean)entry.getValue().getValue();
            }
        }
        return false;
    }

    private static boolean isAllowNull(Element element) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!"allowNull".equals(entry.getKey().getSimpleName().toString())) continue;
                return (Boolean)entry.getValue().getValue();
            }
        }
        return false;
    }

    private static boolean isFallbackConverter(ExecutableElement element) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!"fallback".equals(entry.getKey().getSimpleName().toString())) continue;
                return (Boolean)entry.getValue().getValue();
            }
        }
        return false;
    }

    void writeConverters(String fqn, String suffix, ClassConverters converters) throws Exception {
        int pos = fqn.lastIndexOf(46);
        String p = fqn.substring(0, pos);
        String c = fqn.substring(pos + 1) + (suffix != null ? suffix : "");
        JavaFileObject jfo = this.processingEnv.getFiler().createSourceFile(p + "." + c, new Element[0]);
        LinkedHashSet<String> converterClasses = new LinkedHashSet<String>();
        try (Writer writer = jfo.openWriter();){
            writer.append("/* Generated by org.apache.camel:apt */\n");
            writer.append("package ").append(p).append(";\n");
            writer.append("\n");
            writer.append("import org.apache.camel.Exchange;\n");
            writer.append("import org.apache.camel.TypeConversionException;\n");
            writer.append("import org.apache.camel.TypeConverterLoaderException;\n");
            writer.append("import org.apache.camel.spi.TypeConverterLoader;\n");
            writer.append("import org.apache.camel.spi.TypeConverterRegistry;\n");
            writer.append("import org.apache.camel.support.SimpleTypeConverter;\n");
            writer.append("import org.apache.camel.support.TypeConverterSupport;\n");
            writer.append("import org.apache.camel.util.DoubleMap;\n");
            writer.append("\n");
            writer.append("/**\n");
            writer.append(" * Source code generated by org.apache.camel:apt\n");
            writer.append(" */\n");
            writer.append("@SuppressWarnings(\"unchecked\")\n");
            writer.append("public final class ").append(c).append(" implements TypeConverterLoader {\n");
            writer.append("\n");
            writer.append("    ").append("public ").append(c).append("() {\n");
            writer.append("    }\n");
            writer.append("\n");
            writer.append("    @Override\n");
            writer.append("    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {\n");
            if (converters.size() > 0L) {
                if (converters.isIgnoreOnLoadError()) {
                    writer.append("        try {\n");
                    writer.append("            registerConverters(registry);\n");
                    writer.append("        } catch (Throwable e) {\n");
                    writer.append("            // ignore on load error\n");
                    writer.append("        }\n");
                } else {
                    writer.append("        registerConverters(registry);\n");
                }
            }
            if (converters.sizeFallback() > 0L) {
                writer.append("        registerFallbackConverters(registry);\n");
            }
            writer.append("    }\n");
            writer.append("\n");
            if (converters.size() > 0L) {
                writer.append("    private void registerConverters(TypeConverterRegistry registry) {\n");
                for (Map.Entry entry : converters.getConverters().entrySet()) {
                    for (Map.Entry from : ((Map)entry.getValue()).entrySet()) {
                        boolean allowNull = AbstractTypeConverterGenerator.isAllowNull((Element)from.getValue());
                        writer.append("        addTypeConverter(registry, ").append((CharSequence)entry.getKey()).append(".class").append(", ").append(this.toString((TypeMirror)from.getKey())).append(".class, ").append(Boolean.toString(allowNull)).append(",\n");
                        writer.append("            (type, exchange, value) -> ").append(this.toJava((ExecutableElement)from.getValue(), converterClasses)).append(");\n");
                    }
                }
                writer.append("    }\n");
                writer.append("\n");
                writer.append("    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) { \n");
                writer.append("        registry.addTypeConverter(toType, fromType, new SimpleTypeConverter(allowNull, method));\n");
                writer.append("    }\n");
                writer.append("\n");
            }
            if (converters.sizeFallback() > 0L) {
                writer.append("    private void registerFallbackConverters(TypeConverterRegistry registry) {\n");
                for (ExecutableElement executableElement : converters.getFallbackConverters()) {
                    boolean allowNull = AbstractTypeConverterGenerator.isAllowNull(executableElement);
                    boolean canPromote = AbstractTypeConverterGenerator.isFallbackCanPromote(executableElement);
                    writer.append("        addFallbackTypeConverter(registry, ").append(Boolean.toString(allowNull)).append(", ").append(Boolean.toString(canPromote)).append(", ").append("(type, exchange, value) -> ").append(this.toJavaFallback(executableElement, converterClasses)).append(");\n");
                }
                writer.append("    }\n");
                writer.append("\n");
                writer.append("    private static void addFallbackTypeConverter(TypeConverterRegistry registry, boolean allowNull, boolean canPromote, SimpleTypeConverter.ConversionMethod method) { \n");
                writer.append("        registry.addFallbackTypeConverter(new SimpleTypeConverter(allowNull, method), canPromote);\n");
                writer.append("    }\n");
                writer.append("\n");
            }
            for (String string : converterClasses) {
                String s = string.substring(string.lastIndexOf(46) + 1);
                String v = s.substring(0, 1).toLowerCase() + s.substring(1);
                writer.append("    private volatile ").append(string).append(" ").append(v).append(";\n");
                writer.append("    private ").append(string).append(" get").append(s).append("() {\n");
                writer.append("        if (").append(v).append(" == null) {\n");
                writer.append("            ").append(v).append(" = new ").append(string).append("();\n");
                writer.append("        }\n");
                writer.append("        return ").append(v).append(";\n");
                writer.append("    }\n");
            }
            writer.append("}\n");
            writer.flush();
        }
    }

    private String toString(TypeMirror type) {
        return type.toString().replaceAll("<.*>", "");
    }

    private String toJava(ExecutableElement converter, Set<String> converterClasses) {
        String pfx;
        if (converter.getModifiers().contains((Object)Modifier.STATIC)) {
            pfx = converter.getEnclosingElement().toString() + "." + converter.getSimpleName();
        } else {
            converterClasses.add(converter.getEnclosingElement().toString());
            pfx = "get" + converter.getEnclosingElement().getSimpleName() + "()." + converter.getSimpleName();
        }
        String type = this.toString(converter.getParameters().get(0).asType());
        String cast = type.equals("java.lang.Object") ? "" : "(" + type + ") ";
        return pfx + "(" + cast + "value" + (converter.getParameters().size() == 2 ? ", exchange" : "") + ")";
    }

    private String toJavaFallback(ExecutableElement converter, Set<String> converterClasses) {
        String pfx;
        if (converter.getModifiers().contains((Object)Modifier.STATIC)) {
            pfx = converter.getEnclosingElement().toString() + "." + converter.getSimpleName();
        } else {
            converterClasses.add(converter.getEnclosingElement().toString());
            pfx = "get" + converter.getEnclosingElement().getSimpleName() + "()." + converter.getSimpleName();
        }
        String type = this.toString(converter.getParameters().get(converter.getParameters().size() - 2).asType());
        String cast = type.equals("java.lang.Object") ? "" : "(" + type + ") ";
        return pfx + "(type, " + (converter.getParameters().size() == 4 ? "exchange, " : "") + cast + "value, registry)";
    }

    public static final class ClassConverters {
        private final Comparator<TypeMirror> comparator;
        private final Map<String, Map<TypeMirror, ExecutableElement>> converters = new TreeMap<String, Map<TypeMirror, ExecutableElement>>();
        private final List<ExecutableElement> fallbackConverters = new ArrayList<ExecutableElement>();
        private int size;
        private int sizeFallback;
        private boolean ignoreOnLoadError;

        ClassConverters(Comparator<TypeMirror> comparator) {
            this.comparator = comparator;
        }

        public boolean isIgnoreOnLoadError() {
            return this.ignoreOnLoadError;
        }

        void setIgnoreOnLoadError(boolean ignoreOnLoadError) {
            this.ignoreOnLoadError = ignoreOnLoadError;
        }

        void addTypeConverter(TypeMirror to, TypeMirror from, ExecutableElement ee) {
            this.converters.computeIfAbsent(ClassConverters.toString(to), c -> new TreeMap(this.comparator)).put(from, ee);
            ++this.size;
        }

        void addFallbackTypeConverter(ExecutableElement ee) {
            this.fallbackConverters.add(ee);
            ++this.sizeFallback;
        }

        public Map<String, Map<TypeMirror, ExecutableElement>> getConverters() {
            return this.converters;
        }

        public List<ExecutableElement> getFallbackConverters() {
            return this.fallbackConverters;
        }

        public long size() {
            return this.size;
        }

        public long sizeFallback() {
            return this.sizeFallback;
        }

        public boolean isEmpty() {
            return this.size == 0 && this.sizeFallback == 0;
        }

        private static String toString(TypeMirror type) {
            return type.toString().replaceAll("<.*>", "");
        }
    }
}

