/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.wordpress.producer;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.wordpress.WordpressComponentConfiguration;
import org.apache.camel.component.wordpress.WordpressEndpoint;
import org.apache.camel.component.wordpress.api.WordpressServiceProvider;
import org.apache.camel.component.wordpress.producer.WordpressPostProducer;
import org.apache.camel.support.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWordpressProducer<T>
extends DefaultProducer {
    protected static final Logger LOG = LoggerFactory.getLogger(WordpressPostProducer.class);
    private WordpressComponentConfiguration configuration;

    public AbstractWordpressProducer(WordpressEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.configuration = endpoint.getConfiguration();
        if (!WordpressServiceProvider.getInstance().hasAuthentication()) {
            LOG.warn("Wordpress Producer hasn't authentication. This may lead to errors during route execution. Wordpress writing operations need authentication.");
        }
    }

    public WordpressComponentConfiguration getConfiguration() {
        return this.configuration;
    }

    public WordpressEndpoint getEndpoint() {
        return (WordpressEndpoint)super.getEndpoint();
    }

    public final void process(Exchange exchange) throws Exception {
        if (this.getConfiguration().getId() == null) {
            exchange.getMessage().setBody(this.processInsert(exchange));
        } else if (this.getEndpoint().getOperationDetail() == null) {
            exchange.getMessage().setBody(this.processUpdate(exchange));
        } else {
            exchange.getMessage().setBody(this.processDelete(exchange));
        }
    }

    protected abstract T processInsert(Exchange var1);

    protected abstract T processUpdate(Exchange var1);

    protected abstract T processDelete(Exchange var1);
}

