/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.snmp;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.snmp.SnmpEndpoint;
import org.apache.camel.support.DefaultConsumer;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.MessageException;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.TransportMapping;
import org.snmp4j.mp.StateReference;
import org.snmp4j.mp.StatusInformation;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.transport.DefaultTcpTransportMapping;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class SnmpTrapConsumer
extends DefaultConsumer
implements CommandResponder {
    private SnmpEndpoint endpoint;
    private Address listenGenericAddress;
    private Snmp snmp;
    private TransportMapping<? extends Address> transport;

    public SnmpTrapConsumer(SnmpEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.log.isInfoEnabled()) {
            this.log.info("Starting trap consumer on {}", (Object)this.endpoint.getAddress());
        }
        this.listenGenericAddress = GenericAddress.parse((String)this.endpoint.getAddress());
        if ("tcp".equals(this.endpoint.getProtocol())) {
            this.transport = new DefaultTcpTransportMapping((TcpAddress)this.listenGenericAddress);
        } else if ("udp".equals(this.endpoint.getProtocol())) {
            this.transport = new DefaultUdpTransportMapping((UdpAddress)this.listenGenericAddress);
        } else {
            throw new IllegalArgumentException("Unknown protocol: " + this.endpoint.getProtocol());
        }
        this.snmp = new Snmp(this.transport);
        this.snmp.addCommandResponder((CommandResponder)this);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Starting trap consumer on {} using {} protocol", (Object)this.endpoint.getAddress(), (Object)this.endpoint.getProtocol());
        }
        this.transport.listen();
        if (this.log.isInfoEnabled()) {
            this.log.info("Started trap consumer on {} using {} protocol", (Object)this.endpoint.getAddress(), (Object)this.endpoint.getProtocol());
        }
    }

    protected void doStop() throws Exception {
        if (this.transport != null && this.transport.isListening()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Stopping trap consumer on {}", (Object)this.endpoint.getAddress());
            }
            this.transport.close();
            this.log.info("Stopped trap consumer on {}", (Object)this.endpoint.getAddress());
        }
        super.doStop();
    }

    public void processPdu(CommandResponderEvent event) {
        PDU pdu = event.getPDU();
        if (pdu != null) {
            if (pdu.getType() != -89 && pdu.getType() != -92 && pdu.getType() != -88 && pdu.getType() != -94) {
                pdu.setErrorIndex(0);
                pdu.setErrorStatus(0);
                pdu.setType(-94);
                StatusInformation statusInformation = new StatusInformation();
                StateReference ref = event.getStateReference();
                try {
                    event.getMessageDispatcher().returnResponsePdu(event.getMessageProcessingModel(), event.getSecurityModel(), event.getSecurityName(), event.getSecurityLevel(), pdu, event.getMaxSizeResponsePDU(), ref, statusInformation);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("response to INFORM sent");
                    }
                }
                catch (MessageException ex) {
                    this.getExceptionHandler().handleException((Throwable)ex);
                }
            }
            this.processPDU(pdu, event);
        } else {
            this.log.debug("Received invalid trap PDU");
        }
    }

    public void processPDU(PDU pdu, CommandResponderEvent event) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received trap event for {} : {}", (Object)this.endpoint.getAddress(), (Object)pdu);
        }
        Exchange exchange = this.endpoint.createExchange(pdu, event);
        try {
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        if (exchange.getException() != null) {
            this.getExceptionHandler().handleException((Throwable)exchange.getException());
        }
    }
}

