/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.snmp;

import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.snmp.SnmpActionType;
import org.apache.camel.component.snmp.SnmpEndpoint;
import org.apache.camel.support.ScheduledPollConsumer;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Session;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.UserTarget;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.event.ResponseListener;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.AuthMD5;
import org.snmp4j.security.AuthSHA;
import org.snmp4j.security.Priv3DES;
import org.snmp4j.security.PrivAES128;
import org.snmp4j.security.PrivAES192;
import org.snmp4j.security.PrivAES256;
import org.snmp4j.security.PrivDES;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultTcpTransportMapping;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.util.DefaultPDUFactory;
import org.snmp4j.util.PDUFactory;
import org.snmp4j.util.TreeEvent;
import org.snmp4j.util.TreeUtils;

public class SnmpOIDPoller
extends ScheduledPollConsumer
implements ResponseListener {
    private Address targetAddress;
    private TransportMapping<? extends Address> transport;
    private Snmp snmp;
    private Target target;
    private PDU pdu;
    private SnmpEndpoint endpoint;

    public SnmpOIDPoller(SnmpEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.targetAddress = GenericAddress.parse((String)this.endpoint.getAddress());
        if ("tcp".equals(this.endpoint.getProtocol())) {
            this.transport = new DefaultTcpTransportMapping();
        } else if ("udp".equals(this.endpoint.getProtocol())) {
            this.transport = new DefaultUdpTransportMapping();
        } else {
            throw new IllegalArgumentException("Unknown protocol: " + this.endpoint.getProtocol());
        }
        this.snmp = new Snmp(this.transport);
        if (3 == this.endpoint.getSnmpVersion()) {
            UserTarget userTarget = new UserTarget();
            userTarget.setSecurityLevel(this.endpoint.getSecurityLevel());
            userTarget.setSecurityName(this.convertToOctetString(this.endpoint.getSecurityName()));
            userTarget.setAddress(this.targetAddress);
            userTarget.setRetries(this.endpoint.getRetries());
            userTarget.setTimeout((long)this.endpoint.getTimeout());
            userTarget.setVersion(this.endpoint.getSnmpVersion());
            this.target = userTarget;
            USM usm = new USM(SecurityProtocols.getInstance(), new OctetString(MPv3.createLocalEngineID()), 0);
            SecurityModels.getInstance().addSecurityModel((SecurityModel)usm);
            OID authProtocol = this.convertAuthenticationProtocol(this.endpoint.getAuthenticationProtocol());
            OctetString authPwd = this.convertToOctetString(this.endpoint.getAuthenticationPassphrase());
            OID privProtocol = this.convertPrivacyProtocol(this.endpoint.getPrivacyProtocol());
            OctetString privPwd = this.convertToOctetString(this.endpoint.getPrivacyPassphrase());
            UsmUser user = new UsmUser(this.convertToOctetString(this.endpoint.getSecurityName()), authProtocol, authPwd, privProtocol, privPwd);
            usm.addUser(this.convertToOctetString(this.endpoint.getSecurityName()), user);
            ScopedPDU scopedPDU = new ScopedPDU();
            if (this.endpoint.getSnmpContextEngineId() != null) {
                scopedPDU.setContextEngineID(new OctetString(this.endpoint.getSnmpContextEngineId()));
            }
            if (this.endpoint.getSnmpContextName() != null) {
                scopedPDU.setContextName(new OctetString(this.endpoint.getSnmpContextName()));
            }
            this.pdu = scopedPDU;
        } else {
            CommunityTarget communityTarget = new CommunityTarget();
            communityTarget.setCommunity(this.convertToOctetString(this.endpoint.getSnmpCommunity()));
            communityTarget.setAddress(this.targetAddress);
            communityTarget.setRetries(this.endpoint.getRetries());
            communityTarget.setTimeout((long)this.endpoint.getTimeout());
            communityTarget.setVersion(this.endpoint.getSnmpVersion());
            this.target = communityTarget;
            this.pdu = new PDU();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Starting OID poller on {} using {} protocol", (Object)this.endpoint.getAddress(), (Object)this.endpoint.getProtocol());
        }
        this.transport.listen();
        if (this.log.isInfoEnabled()) {
            this.log.info("Started OID poller on {} using {} protocol", (Object)this.endpoint.getAddress(), (Object)this.endpoint.getProtocol());
        }
    }

    protected void doStop() throws Exception {
        if (this.transport != null && this.transport.isListening()) {
            this.log.info("Stopping OID poller on {}", (Object)this.targetAddress);
            this.transport.close();
            this.log.info("Stopped OID poller on {}", (Object)this.targetAddress);
        }
        super.doStop();
    }

    protected int poll() throws Exception {
        this.pdu.clear();
        int type = this.getPduType(this.endpoint.getType());
        this.pdu.setType(type);
        if (!this.endpoint.isTreeList()) {
            for (OID oid : this.endpoint.getOids()) {
                this.pdu.add(new VariableBinding(oid));
            }
        } else {
            TreeUtils treeUtils = new TreeUtils((Session)this.snmp, (PDUFactory)new DefaultPDUFactory());
            for (OID oid : this.endpoint.getOids()) {
                List events = treeUtils.getSubtree(this.target, new OID(oid));
                for (Object eventObj : events) {
                    TreeEvent event = (TreeEvent)eventObj;
                    if (event == null) {
                        this.log.warn("Event is null");
                        continue;
                    }
                    if (event.isError()) {
                        this.log.error("Error in event: {}", (Object)event.getErrorMessage());
                        continue;
                    }
                    VariableBinding[] varBindings = event.getVariableBindings();
                    if (varBindings == null || varBindings.length == 0) continue;
                    for (VariableBinding varBinding : varBindings) {
                        if (varBinding == null) continue;
                        this.pdu.add(varBinding);
                    }
                }
            }
        }
        this.snmp.send(this.pdu, this.target, null, (ResponseListener)this);
        return 1;
    }

    public void onResponse(ResponseEvent event) {
        ((Snmp)event.getSource()).cancel(event.getRequest(), (ResponseListener)this);
        if (event.getRequest() == null || event.getResponse() == null) {
            this.log.debug("Received invalid SNMP event. Request: " + event.getRequest() + " / Response: " + event.getResponse());
            return;
        }
        PDU pdu = event.getResponse();
        this.processPDU(pdu);
    }

    public void processPDU(PDU pdu) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received response event for {} : {}", (Object)this.endpoint.getAddress(), (Object)pdu);
        }
        Exchange exchange = this.endpoint.createExchange(pdu);
        try {
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            this.getExceptionHandler().handleException((Throwable)e);
        }
    }

    public Target getTarget() {
        return this.target;
    }

    public void setTarget(Target target) {
        this.target = target;
    }

    private OctetString convertToOctetString(String value) {
        if (value == null) {
            return null;
        }
        return new OctetString(value);
    }

    private OID convertAuthenticationProtocol(String authenticationProtocol) {
        if (authenticationProtocol == null) {
            return null;
        }
        if ("MD5".equals(authenticationProtocol)) {
            return AuthMD5.ID;
        }
        if ("SHA1".equals(authenticationProtocol)) {
            return AuthSHA.ID;
        }
        throw new IllegalArgumentException("Unknown authentication protocol: " + authenticationProtocol);
    }

    private OID convertPrivacyProtocol(String privacyProtocol) {
        if (privacyProtocol == null) {
            return null;
        }
        if ("DES".equals(privacyProtocol)) {
            return PrivDES.ID;
        }
        if ("TRIDES".equals(privacyProtocol)) {
            return Priv3DES.ID;
        }
        if ("AES128".equals(privacyProtocol)) {
            return PrivAES128.ID;
        }
        if ("AES192".equals(privacyProtocol)) {
            return PrivAES192.ID;
        }
        if ("AES256".equals(privacyProtocol)) {
            return PrivAES256.ID;
        }
        throw new IllegalArgumentException("Unknown privacy protocol: " + privacyProtocol);
    }

    private int getPduType(SnmpActionType type) {
        if (SnmpActionType.GET_NEXT == type) {
            return -95;
        }
        return -96;
    }
}

