/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.snmp;

import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.component.snmp.OIDList;
import org.apache.camel.component.snmp.SnmpConverters;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;
import org.snmp4j.PDU;

public final class SnmpConvertersLoader
implements TypeConverterLoader {
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerConverters(registry);
    }

    private void registerConverters(TypeConverterRegistry registry) {
        SnmpConvertersLoader.addTypeConverter(registry, String.class, PDU.class, false, (type, exchange, value) -> SnmpConverters.toString((PDU)value));
        SnmpConvertersLoader.addTypeConverter(registry, OIDList.class, String.class, false, (type, exchange, value) -> SnmpConverters.toOIDList((String)value, exchange));
    }

    private static void addTypeConverter(TypeConverterRegistry registry, Class<?> toType, Class<?> fromType, boolean allowNull, SimpleTypeConverter.ConversionMethod method) {
        registry.addTypeConverter(toType, fromType, (TypeConverter)new SimpleTypeConverter(allowNull, method));
    }
}

