/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.spel.springboot;

import java.util.HashMap;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.language.spel.SpelLanguage;
import org.apache.camel.language.spel.springboot.SpelLanguageConfiguration;
import org.apache.camel.spi.HasId;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.LanguageCustomizer;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.LanguageConfigurationProperties;
import org.apache.camel.spring.boot.util.CamelPropertiesHelper;
import org.apache.camel.spring.boot.util.ConditionalOnCamelContextAndAutoConfigurationBeans;
import org.apache.camel.spring.boot.util.GroupCondition;
import org.apache.camel.spring.boot.util.HierarchicalPropertiesEvaluator;
import org.apache.camel.support.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.core.env.Environment;

@Configuration
@Conditional(value={ConditionalOnCamelContextAndAutoConfigurationBeans.class, GroupConditions.class})
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
@EnableConfigurationProperties(value={LanguageConfigurationProperties.class, SpelLanguageConfiguration.class})
public class SpelLanguageAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpelLanguageAutoConfiguration.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private CamelContext camelContext;
    @Autowired
    private SpelLanguageConfiguration configuration;
    @Autowired(required=false)
    private List<LanguageCustomizer<SpelLanguage>> customizers;

    @Bean(name={"spel-language"})
    @Scope(value="prototype")
    @ConditionalOnMissingBean(value={SpelLanguage.class})
    public SpelLanguage configureSpelLanguage() throws Exception {
        CamelContextAware contextAware;
        SpelLanguage language = new SpelLanguage();
        if (CamelContextAware.class.isAssignableFrom(SpelLanguage.class) && (contextAware = (CamelContextAware)CamelContextAware.class.cast(language)) != null) {
            contextAware.setCamelContext(this.camelContext);
        }
        HashMap parameters = new HashMap();
        IntrospectionSupport.getProperties((Object)((Object)this.configuration), parameters, null, (boolean)false);
        CamelPropertiesHelper.setCamelProperties((CamelContext)this.camelContext, (Object)language, parameters, (boolean)false);
        if (ObjectHelper.isNotEmpty(this.customizers)) {
            for (LanguageCustomizer<SpelLanguage> customizer : this.customizers) {
                boolean useCustomizer = customizer instanceof HasId ? HierarchicalPropertiesEvaluator.evaluate((Environment)this.applicationContext.getEnvironment(), (String[])new String[]{"camel.language.customizer", "camel.language.spel.customizer", ((HasId)customizer).getId()}) : HierarchicalPropertiesEvaluator.evaluate((Environment)this.applicationContext.getEnvironment(), (String[])new String[]{"camel.language.customizer", "camel.language.spel.customizer"});
                if (!useCustomizer) continue;
                LOGGER.debug("Configure language {}, with customizer {}", (Object)language, customizer);
                customizer.customize((Language)language);
            }
        }
        return language;
    }

    static class GroupConditions
    extends GroupCondition {
        public GroupConditions() {
            super("camel.component", "camel.component.spel");
        }
    }
}

