/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ipfs;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.ipfs.IPFSConfiguration;
import org.apache.camel.component.ipfs.IPFSEndpoint;
import org.apache.camel.support.DefaultProducer;

public class IPFSProducer
extends DefaultProducer {
    public IPFSProducer(IPFSEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public IPFSEndpoint getEndpoint() {
        return (IPFSEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        IPFSEndpoint endpoint = this.getEndpoint();
        IPFSConfiguration.IPFSCommand cmd = endpoint.getCommand();
        if (IPFSConfiguration.IPFSCommand.version == cmd) {
            String resp = endpoint.ipfsVersion();
            exchange.getMessage().setBody((Object)resp);
        } else if (IPFSConfiguration.IPFSCommand.add == cmd) {
            List<String> cids;
            Path path = this.pathFromBody(exchange);
            List<String> resp = cids = endpoint.ipfsAdd(path);
            if (path.toFile().isFile()) {
                resp = cids.size() > 0 ? cids.get(0) : null;
            }
            exchange.getMessage().setBody(resp);
        } else if (IPFSConfiguration.IPFSCommand.cat == cmd) {
            String cid = (String)exchange.getMessage().getBody(String.class);
            InputStream resp = endpoint.ipfsCat(cid);
            exchange.getMessage().setBody((Object)resp);
        } else if (IPFSConfiguration.IPFSCommand.get == cmd) {
            Path outdir = endpoint.getConfiguration().getOutdir();
            String cid = (String)exchange.getMessage().getBody(String.class);
            Path resp = endpoint.ipfsGet(cid, outdir);
            exchange.getMessage().setBody((Object)resp);
        } else {
            throw new UnsupportedOperationException(cmd.toString());
        }
    }

    private Path pathFromBody(Exchange exchange) {
        Object body = exchange.getMessage().getBody();
        if (body instanceof Path) {
            return (Path)body;
        }
        if (body instanceof String) {
            return Paths.get((String)body, new String[0]);
        }
        if (body instanceof File) {
            return ((File)body).toPath();
        }
        throw new IllegalArgumentException("Invalid path: " + body);
    }
}

