/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.linkedin.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.ext.Provider;
import org.apache.camel.component.linkedin.api.OAuthParams;
import org.apache.camel.component.linkedin.api.OAuthScope;
import org.apache.camel.component.linkedin.api.OAuthSecureStorage;
import org.apache.camel.component.linkedin.api.OAuthToken;
import org.apache.http.HttpHost;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.FormElement;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=1000)
public final class LinkedInOAuthRequestFilter
implements ClientRequestFilter {
    public static final String BASE_ADDRESS = "https://api.linkedin.com/v1";
    private static final int SC_OK = 200;
    private static final int SC_MOVED_TEMPORARILY = 302;
    private static final int SC_SEE_OTHER = 303;
    private static final String HEADER_LOCATION = "location";
    private static final Logger LOG = LoggerFactory.getLogger(LinkedInOAuthRequestFilter.class);
    private static final String AUTHORIZATION_URL_PREFIX = "https://www.linkedin.com";
    private static final String AUTHORIZATION_URL = "https://www.linkedin.com/uas/oauth2/authorization?response_type=code&client_id=%s&state=%s&redirect_uri=%s";
    private static final String AUTHORIZATION_URL_WITH_SCOPE = "https://www.linkedin.com/uas/oauth2/authorization?response_type=code&client_id=%s&state=%s&scope=%s&redirect_uri=%s";
    private static final String ACCESS_TOKEN_URL = "https://www.linkedin.com/uas/oauth2/accessToken?grant_type=authorization_code&code=%s&redirect_uri=%s&client_id=%s&client_secret=%s";
    private static final Pattern QUERY_PARAM_PATTERN = Pattern.compile("&?([^=]+)=([^&]+)");
    private final OAuthParams oAuthParams;
    private OAuthToken oAuthToken;
    private Proxy proxy;

    public LinkedInOAuthRequestFilter(OAuthParams oAuthParams, Map<String, Object> httpParams, boolean lazyAuth, String[] enabledProtocols) {
        this.oAuthParams = oAuthParams;
        this.oAuthToken = oAuthParams.getSecureStorage() != null ? oAuthParams.getSecureStorage().getOAuthToken() : null;
        if (httpParams != null && httpParams.get("http.route.default-proxy") != null) {
            HttpHost proxyHost = (HttpHost)httpParams.get("http.route.default-proxy");
            Boolean socksProxy = (Boolean)httpParams.get("http.route.socks-proxy");
            InetSocketAddress proxyAddr = new InetSocketAddress(proxyHost.getHostName(), proxyHost.getPort());
            this.proxy = socksProxy != null && socksProxy.booleanValue() ? new Proxy(Proxy.Type.SOCKS, proxyAddr) : new Proxy(Proxy.Type.HTTP, proxyAddr);
        } else {
            this.proxy = null;
        }
        if (!lazyAuth) {
            try {
                this.updateOAuthToken();
            }
            catch (IOException e) {
                throw new IllegalArgumentException(String.format("Error authorizing user %s: %s", oAuthParams.getUserName(), e.getMessage()), e);
            }
        }
    }

    private String getRefreshToken() {
        try {
            String redirectQuery;
            String csrfId = String.valueOf(new SecureRandom().nextLong());
            String encodedRedirectUri = URLEncoder.encode(this.oAuthParams.getRedirectUri(), "UTF-8");
            OAuthScope[] scopes = this.oAuthParams.getScopes();
            HashMap<String, String> cookies = new HashMap<String, String>();
            String authorizationUrl = this.authorizationUrl(csrfId, encodedRedirectUri, scopes);
            Connection.Response loginPageResponse = LinkedInOAuthRequestFilter.addProxy(Jsoup.connect((String)authorizationUrl), this.proxy).followRedirects(false).method(Connection.Method.GET).execute();
            Connection.Response loginPageRedirectedResponse = this.followRedirection(loginPageResponse, cookies);
            Document loginPage = loginPageRedirectedResponse.parse();
            this.validatePage(loginPage);
            FormElement loginForm = (FormElement)loginPage.select("form").first();
            Element loginField = loginForm.select("input[name=session_key]").first();
            loginField.val(this.oAuthParams.getUserName());
            Element passwordField = loginForm.select("input[name=session_password]").first();
            passwordField.val(this.oAuthParams.getUserPassword());
            Connection.Response afterLoginResponse = LinkedInOAuthRequestFilter.addProxy(loginForm.submit(), this.proxy).followRedirects(false).cookies(cookies).execute();
            cookies.putAll(afterLoginResponse.cookies());
            Connection.Response afterLoginRedirectedResponse = this.followRedirection(afterLoginResponse, cookies);
            URL redirectionUrl = this.getRedirectLocationAndValidate(afterLoginRedirectedResponse);
            if (redirectionUrl != null) {
                redirectQuery = redirectionUrl.getQuery();
            } else if (afterLoginRedirectedResponse.statusCode() == 200) {
                Document allowPage = afterLoginRedirectedResponse.parse();
                this.validatePage(allowPage);
                FormElement allowForm = (FormElement)allowPage.select("form").get(1);
                Connection.Response allowRedirectResponse = LinkedInOAuthRequestFilter.addProxy(allowForm.submit(), this.proxy).followRedirects(false).cookies(cookies).execute();
                URL allowUrl = this.getRedirectLocationAndValidate(allowRedirectResponse);
                redirectQuery = allowUrl.getQuery();
            } else {
                throw new IllegalArgumentException("Redirect response query is null, check username, password and permissions");
            }
            HashMap<String, String> params = new HashMap<String, String>();
            Matcher matcher = QUERY_PARAM_PATTERN.matcher(redirectQuery);
            while (matcher.find()) {
                params.put(matcher.group(1), matcher.group(2));
            }
            if (params.get("challengeId") != null) {
                throw new SecurityException("Unable to login due to CAPTCHA, use with a valid accessToken instead!");
            }
            String state = (String)params.get("state");
            if (!csrfId.equals(state)) {
                throw new SecurityException("Invalid CSRF code!");
            }
            return (String)params.get("code");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error authorizing application: " + e.getMessage(), e);
        }
    }

    private void validatePage(Document loginPage) {
        Elements errorDivs = loginPage.select("body[class=error]");
        if (errorDivs.isEmpty()) {
            errorDivs = loginPage.select("div[role=alert]:not([class*=hidden])");
        }
        if (!errorDivs.isEmpty()) {
            String errorMessage = errorDivs.first().text();
            throw new IllegalArgumentException("Error authorizing application: " + errorMessage);
        }
    }

    private String authorizationUrl(String csrfId, String encodedRedirectUri, OAuthScope[] scopes) {
        String url;
        if (scopes == null || scopes.length == 0) {
            url = String.format(AUTHORIZATION_URL, this.oAuthParams.getClientId(), csrfId, encodedRedirectUri);
        } else {
            int nScopes = scopes.length;
            StringBuilder builder = new StringBuilder();
            int i = 0;
            for (OAuthScope scope : scopes) {
                builder.append(scope.getValue());
                if (++i >= nScopes) continue;
                builder.append("%20");
            }
            url = String.format(AUTHORIZATION_URL_WITH_SCOPE, this.oAuthParams.getClientId(), csrfId, builder.toString(), encodedRedirectUri);
        }
        return url;
    }

    private Connection.Response followRedirection(Connection.Response response, Map<String, String> cookies) throws IOException {
        return this.followRedirection(response, cookies, 0);
    }

    private Connection.Response followRedirection(Connection.Response response, Map<String, String> cookies, int deep) throws IOException {
        if (deep > 5) {
            throw new IllegalArgumentException("Error authorizing application. Redirection goes still on and on.");
        }
        URL url = this.getRedirectLocationAndValidate(response);
        if (url != null) {
            if (url.getQuery().contains("code=")) {
                return response;
            }
            if (url.toString().contains("error=") || url.toString().contains("errorKey=")) {
                throw new IOException(URLDecoder.decode(url.toString()).replaceAll("&", ", "));
            }
            Connection.Response resp = LinkedInOAuthRequestFilter.addProxy(Jsoup.connect((String)url.toString()), this.proxy).followRedirects(false).method(Connection.Method.GET).cookies(cookies).execute();
            return this.followRedirection(resp, cookies, deep++);
        }
        cookies.putAll(response.cookies());
        return response;
    }

    private URL getRedirectLocationAndValidate(Connection.Response response) throws IOException {
        if (response.statusCode() == 302 || response.statusCode() == 303) {
            URL location;
            try {
                location = new URL(response.header(HEADER_LOCATION));
            }
            catch (MalformedURLException e) {
                location = new URL(AUTHORIZATION_URL_PREFIX + response.header(HEADER_LOCATION));
            }
            String locationQuery = location.getQuery();
            if (locationQuery != null && (locationQuery.contains("error=") || locationQuery.contains("errorKey="))) {
                throw new IOException(URLDecoder.decode(locationQuery).replaceAll("&", ", "));
            }
            return location;
        }
        return null;
    }

    private static Connection addProxy(Connection connection, Proxy proxy) {
        if (proxy != null) {
            return connection.proxy(proxy);
        }
        return connection;
    }

    private OAuthToken getAccessToken(String refreshToken) throws IOException {
        String tokenUrl = String.format(ACCESS_TOKEN_URL, refreshToken, this.oAuthParams.getRedirectUri(), this.oAuthParams.getClientId(), this.oAuthParams.getClientSecret());
        Connection.Response response = LinkedInOAuthRequestFilter.addProxy(Jsoup.connect((String)tokenUrl), this.proxy).ignoreContentType(true).method(Connection.Method.POST).execute();
        if (response.statusCode() != 200) {
            throw new IOException(String.format("Error getting access token: [%s: %s]", response.statusCode(), response.statusMessage()));
        }
        long currentTime = System.currentTimeMillis();
        ObjectMapper mapper = new ObjectMapper();
        Map map = (Map)mapper.readValue(response.body(), Map.class);
        String accessToken = map.get("access_token").toString();
        Integer expiresIn = Integer.valueOf(map.get("expires_in").toString());
        return new OAuthToken(refreshToken, accessToken, currentTime + TimeUnit.MILLISECONDS.convert(expiresIn.intValue(), TimeUnit.SECONDS));
    }

    public synchronized OAuthToken getOAuthToken() {
        return this.oAuthToken;
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        this.updateOAuthToken();
        String requestUri = requestContext.getUri().toString();
        StringBuilder builder = new StringBuilder(requestUri);
        if (requestUri.contains("?")) {
            builder.append('&');
        } else {
            builder.append('?');
        }
        builder.append("oauth2_access_token=").append(this.oAuthToken.getAccessToken());
        requestContext.setUri(URI.create(builder.toString()));
    }

    private synchronized void updateOAuthToken() throws IOException {
        long currentTime = System.currentTimeMillis();
        if (this.oAuthToken == null || this.oAuthToken.getExpiryTime() < currentTime) {
            LOG.info("OAuth token doesn't exist or has expired");
            OAuthSecureStorage secureStorage = this.oAuthParams.getSecureStorage();
            if (secureStorage != null) {
                this.oAuthToken = secureStorage.getOAuthToken();
                if (this.oAuthToken != null && this.oAuthToken.getExpiryTime() > currentTime) {
                    return;
                }
                LOG.info("OAuth secure storage returned a null or expired token, creating a new token...");
            }
            String refreshToken = this.getRefreshToken();
            this.oAuthToken = this.getAccessToken(refreshToken);
            LOG.info("OAuth token created!");
            if (secureStorage != null) {
                secureStorage.saveOAuthToken(this.oAuthToken);
            }
        }
    }
}

