/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2;

import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.as2.AS2Configuration;
import org.apache.camel.component.as2.AS2Endpoint;
import org.apache.camel.component.as2.api.AS2CompressionAlgorithm;
import org.apache.camel.component.as2.api.AS2EncryptionAlgorithm;
import org.apache.camel.component.as2.api.AS2MessageStructure;
import org.apache.camel.component.as2.api.AS2SignatureAlgorithm;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.http.entity.ContentType;

public class AS2EndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer {
    public boolean configure(CamelContext camelContext, Object endpoint, String name, Object value, boolean ignoreCase) {
        if (ignoreCase) {
            return AS2EndpointConfigurer.doConfigureIgnoreCase(camelContext, endpoint, name, value);
        }
        return AS2EndpointConfigurer.doConfigure(camelContext, endpoint, name, value);
    }

    private static boolean doConfigure(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name) {
            case "as2Version": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setAs2Version((String)AS2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "userAgent": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setUserAgent((String)AS2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "server": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setServer((String)AS2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "serverFqdn": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setServerFqdn((String)AS2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "targetHostname": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setTargetHostname((String)AS2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "targetPortNumber": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setTargetPortNumber((Integer)AS2EndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "clientFqdn": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setClientFqdn((String)AS2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "serverPortNumber": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setServerPortNumber((Integer)AS2EndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "requestUri": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setRequestUri((String)AS2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "ediMessageType": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setEdiMessageType((ContentType)AS2EndpointConfigurer.property((CamelContext)camelContext, ContentType.class, (Object)value));
                return true;
            }
            case "ediMessageTransferEncoding": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setEdiMessageTransferEncoding((String)AS2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "as2MessageStructure": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setAs2MessageStructure((AS2MessageStructure)AS2EndpointConfigurer.property((CamelContext)camelContext, AS2MessageStructure.class, (Object)value));
                return true;
            }
            case "subject": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setSubject((String)AS2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "from": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setFrom((String)AS2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "as2From": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setAs2From((String)AS2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "as2To": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setAs2To((String)AS2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "signingAlgorithm": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setSigningAlgorithm((AS2SignatureAlgorithm)AS2EndpointConfigurer.property((CamelContext)camelContext, AS2SignatureAlgorithm.class, (Object)value));
                return true;
            }
            case "signingCertificateChain": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setSigningCertificateChain((Certificate[])AS2EndpointConfigurer.property((CamelContext)camelContext, Certificate[].class, (Object)value));
                return true;
            }
            case "signingPrivateKey": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setSigningPrivateKey((PrivateKey)AS2EndpointConfigurer.property((CamelContext)camelContext, PrivateKey.class, (Object)value));
                return true;
            }
            case "compressionAlgorithm": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setCompressionAlgorithm((AS2CompressionAlgorithm)AS2EndpointConfigurer.property((CamelContext)camelContext, AS2CompressionAlgorithm.class, (Object)value));
                return true;
            }
            case "dispositionNotificationTo": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setDispositionNotificationTo((String)AS2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "signedReceiptMicAlgorithms": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setSignedReceiptMicAlgorithms((String[])AS2EndpointConfigurer.property((CamelContext)camelContext, String[].class, (Object)value));
                return true;
            }
            case "encryptingAlgorithm": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setEncryptingAlgorithm((AS2EncryptionAlgorithm)AS2EndpointConfigurer.property((CamelContext)camelContext, AS2EncryptionAlgorithm.class, (Object)value));
                return true;
            }
            case "encryptingCertificateChain": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setEncryptingCertificateChain((Certificate[])AS2EndpointConfigurer.property((CamelContext)camelContext, Certificate[].class, (Object)value));
                return true;
            }
            case "decryptingPrivateKey": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setDecryptingPrivateKey((PrivateKey)AS2EndpointConfigurer.property((CamelContext)camelContext, PrivateKey.class, (Object)value));
                return true;
            }
            case "mdnMessageTemplate": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setMdnMessageTemplate((String)AS2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "inBody": {
                ((AS2Endpoint)((Object)endpoint)).setInBody((String)AS2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "startScheduler": {
                ((AS2Endpoint)((Object)endpoint)).setStartScheduler((Boolean)AS2EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "initialDelay": {
                ((AS2Endpoint)((Object)endpoint)).setInitialDelay((Long)AS2EndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "delay": {
                ((AS2Endpoint)((Object)endpoint)).setDelay((Long)AS2EndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "timeUnit": {
                ((AS2Endpoint)((Object)endpoint)).setTimeUnit((TimeUnit)((Object)AS2EndpointConfigurer.property((CamelContext)camelContext, TimeUnit.class, (Object)value)));
                return true;
            }
            case "useFixedDelay": {
                ((AS2Endpoint)((Object)endpoint)).setUseFixedDelay((Boolean)AS2EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "pollStrategy": {
                ((AS2Endpoint)((Object)endpoint)).setPollStrategy((PollingConsumerPollStrategy)AS2EndpointConfigurer.property((CamelContext)camelContext, PollingConsumerPollStrategy.class, (Object)value));
                return true;
            }
            case "runLoggingLevel": {
                ((AS2Endpoint)((Object)endpoint)).setRunLoggingLevel((LoggingLevel)AS2EndpointConfigurer.property((CamelContext)camelContext, LoggingLevel.class, (Object)value));
                return true;
            }
            case "sendEmptyMessageWhenIdle": {
                ((AS2Endpoint)((Object)endpoint)).setSendEmptyMessageWhenIdle((Boolean)AS2EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "greedy": {
                ((AS2Endpoint)((Object)endpoint)).setGreedy((Boolean)AS2EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "scheduler": {
                ((AS2Endpoint)((Object)endpoint)).setScheduler((String)AS2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "schedulerProperties": {
                ((AS2Endpoint)((Object)endpoint)).setSchedulerProperties((Map)AS2EndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "scheduledExecutorService": {
                ((AS2Endpoint)((Object)endpoint)).setScheduledExecutorService((ScheduledExecutorService)AS2EndpointConfigurer.property((CamelContext)camelContext, ScheduledExecutorService.class, (Object)value));
                return true;
            }
            case "backoffMultiplier": {
                ((AS2Endpoint)((Object)endpoint)).setBackoffMultiplier((Integer)AS2EndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffIdleThreshold": {
                ((AS2Endpoint)((Object)endpoint)).setBackoffIdleThreshold((Integer)AS2EndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffErrorThreshold": {
                ((AS2Endpoint)((Object)endpoint)).setBackoffErrorThreshold((Integer)AS2EndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "lazyStartProducer": {
                ((AS2Endpoint)((Object)endpoint)).setLazyStartProducer((Boolean)AS2EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeErrorHandler": {
                ((AS2Endpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)AS2EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionHandler": {
                ((AS2Endpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)AS2EndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangePattern": {
                ((AS2Endpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)AS2EndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((AS2Endpoint)((Object)endpoint)).setSynchronous((Boolean)AS2EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicPropertyBinding": {
                ((AS2Endpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)AS2EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    private static boolean doConfigureIgnoreCase(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name.toLowerCase()) {
            case "as2version": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setAs2Version((String)AS2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "useragent": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setUserAgent((String)AS2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "server": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setServer((String)AS2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "serverfqdn": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setServerFqdn((String)AS2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "targethostname": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setTargetHostname((String)AS2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "targetportnumber": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setTargetPortNumber((Integer)AS2EndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "clientfqdn": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setClientFqdn((String)AS2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "serverportnumber": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setServerPortNumber((Integer)AS2EndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "requesturi": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setRequestUri((String)AS2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "edimessagetype": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setEdiMessageType((ContentType)AS2EndpointConfigurer.property((CamelContext)camelContext, ContentType.class, (Object)value));
                return true;
            }
            case "edimessagetransferencoding": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setEdiMessageTransferEncoding((String)AS2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "as2messagestructure": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setAs2MessageStructure((AS2MessageStructure)AS2EndpointConfigurer.property((CamelContext)camelContext, AS2MessageStructure.class, (Object)value));
                return true;
            }
            case "subject": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setSubject((String)AS2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "from": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setFrom((String)AS2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "as2from": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setAs2From((String)AS2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "as2to": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setAs2To((String)AS2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "signingalgorithm": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setSigningAlgorithm((AS2SignatureAlgorithm)AS2EndpointConfigurer.property((CamelContext)camelContext, AS2SignatureAlgorithm.class, (Object)value));
                return true;
            }
            case "signingcertificatechain": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setSigningCertificateChain((Certificate[])AS2EndpointConfigurer.property((CamelContext)camelContext, Certificate[].class, (Object)value));
                return true;
            }
            case "signingprivatekey": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setSigningPrivateKey((PrivateKey)AS2EndpointConfigurer.property((CamelContext)camelContext, PrivateKey.class, (Object)value));
                return true;
            }
            case "compressionalgorithm": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setCompressionAlgorithm((AS2CompressionAlgorithm)AS2EndpointConfigurer.property((CamelContext)camelContext, AS2CompressionAlgorithm.class, (Object)value));
                return true;
            }
            case "dispositionnotificationto": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setDispositionNotificationTo((String)AS2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "signedreceiptmicalgorithms": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setSignedReceiptMicAlgorithms((String[])AS2EndpointConfigurer.property((CamelContext)camelContext, String[].class, (Object)value));
                return true;
            }
            case "encryptingalgorithm": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setEncryptingAlgorithm((AS2EncryptionAlgorithm)AS2EndpointConfigurer.property((CamelContext)camelContext, AS2EncryptionAlgorithm.class, (Object)value));
                return true;
            }
            case "encryptingcertificatechain": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setEncryptingCertificateChain((Certificate[])AS2EndpointConfigurer.property((CamelContext)camelContext, Certificate[].class, (Object)value));
                return true;
            }
            case "decryptingprivatekey": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setDecryptingPrivateKey((PrivateKey)AS2EndpointConfigurer.property((CamelContext)camelContext, PrivateKey.class, (Object)value));
                return true;
            }
            case "mdnmessagetemplate": {
                ((AS2Configuration)((AS2Endpoint)((Object)endpoint)).getConfiguration()).setMdnMessageTemplate((String)AS2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "inbody": {
                ((AS2Endpoint)((Object)endpoint)).setInBody((String)AS2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "startscheduler": {
                ((AS2Endpoint)((Object)endpoint)).setStartScheduler((Boolean)AS2EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "initialdelay": {
                ((AS2Endpoint)((Object)endpoint)).setInitialDelay((Long)AS2EndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "delay": {
                ((AS2Endpoint)((Object)endpoint)).setDelay((Long)AS2EndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "timeunit": {
                ((AS2Endpoint)((Object)endpoint)).setTimeUnit((TimeUnit)((Object)AS2EndpointConfigurer.property((CamelContext)camelContext, TimeUnit.class, (Object)value)));
                return true;
            }
            case "usefixeddelay": {
                ((AS2Endpoint)((Object)endpoint)).setUseFixedDelay((Boolean)AS2EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "pollstrategy": {
                ((AS2Endpoint)((Object)endpoint)).setPollStrategy((PollingConsumerPollStrategy)AS2EndpointConfigurer.property((CamelContext)camelContext, PollingConsumerPollStrategy.class, (Object)value));
                return true;
            }
            case "runlogginglevel": {
                ((AS2Endpoint)((Object)endpoint)).setRunLoggingLevel((LoggingLevel)AS2EndpointConfigurer.property((CamelContext)camelContext, LoggingLevel.class, (Object)value));
                return true;
            }
            case "sendemptymessagewhenidle": {
                ((AS2Endpoint)((Object)endpoint)).setSendEmptyMessageWhenIdle((Boolean)AS2EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "greedy": {
                ((AS2Endpoint)((Object)endpoint)).setGreedy((Boolean)AS2EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "scheduler": {
                ((AS2Endpoint)((Object)endpoint)).setScheduler((String)AS2EndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "schedulerproperties": {
                ((AS2Endpoint)((Object)endpoint)).setSchedulerProperties((Map)AS2EndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "scheduledexecutorservice": {
                ((AS2Endpoint)((Object)endpoint)).setScheduledExecutorService((ScheduledExecutorService)AS2EndpointConfigurer.property((CamelContext)camelContext, ScheduledExecutorService.class, (Object)value));
                return true;
            }
            case "backoffmultiplier": {
                ((AS2Endpoint)((Object)endpoint)).setBackoffMultiplier((Integer)AS2EndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffidlethreshold": {
                ((AS2Endpoint)((Object)endpoint)).setBackoffIdleThreshold((Integer)AS2EndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backofferrorthreshold": {
                ((AS2Endpoint)((Object)endpoint)).setBackoffErrorThreshold((Integer)AS2EndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "lazystartproducer": {
                ((AS2Endpoint)((Object)endpoint)).setLazyStartProducer((Boolean)AS2EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": {
                ((AS2Endpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)AS2EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionhandler": {
                ((AS2Endpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)AS2EndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": {
                ((AS2Endpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)AS2EndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((AS2Endpoint)((Object)endpoint)).setSynchronous((Boolean)AS2EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": {
                ((AS2Endpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)AS2EndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }
}

