/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms.tx;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.Exchange;
import org.apache.camel.component.sjms.TransactionCommitStrategy;

public class BatchTransactionCommitStrategy
implements TransactionCommitStrategy {
    private final AtomicInteger current = new AtomicInteger(0);
    private final int count;

    public BatchTransactionCommitStrategy(int count) {
        this.count = count;
    }

    @Override
    public boolean commit(Exchange exchange) throws Exception {
        boolean answer = false;
        int currentVal = this.current.incrementAndGet();
        if (currentVal >= this.count) {
            answer = true;
            this.current.set(0);
        }
        return answer;
    }

    @Override
    public boolean rollback(Exchange exchange) throws Exception {
        this.current.set(0);
        return true;
    }

    public void reset() {
        this.current.set(0);
    }
}

