/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.openstack.neutron;

import org.apache.camel.Component;
import org.apache.camel.Producer;
import org.apache.camel.component.openstack.common.AbstractOpenstackEndpoint;
import org.apache.camel.component.openstack.neutron.NeutronComponent;
import org.apache.camel.component.openstack.neutron.producer.NetworkProducer;
import org.apache.camel.component.openstack.neutron.producer.PortProducer;
import org.apache.camel.component.openstack.neutron.producer.RouterProducer;
import org.apache.camel.component.openstack.neutron.producer.SubnetProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.openstack4j.core.transport.Config;

@UriEndpoint(firstVersion="2.19.0", scheme="openstack-neutron", title="OpenStack Neutron", syntax="openstack-neutron:host", label="cloud,paas", producerOnly=true)
public class NeutronEndpoint
extends AbstractOpenstackEndpoint {
    @UriParam(enums="networks,subnets,ports,routers")
    @Metadata(required=true)
    String subsystem;
    @UriPath
    @Metadata(required=true)
    private String host;
    @UriParam(defaultValue="default")
    private String domain = "default";
    @UriParam
    @Metadata(required=true)
    private String project;
    @UriParam
    private String operation;
    @UriParam
    @Metadata(required=true, secret=true)
    private String username;
    @UriParam
    @Metadata(required=true, secret=true)
    private String password;
    @UriParam
    private Config config;
    @UriParam(defaultValue="V3", enums="V2,V3")
    private String apiVersion = "V3";

    public NeutronEndpoint(String uri, NeutronComponent component) {
        super(uri, (Component)component);
    }

    public Producer createProducer() throws Exception {
        switch (this.getSubsystem()) {
            case "networks": {
                return new NetworkProducer(this, this.createClient());
            }
            case "subnets": {
                return new SubnetProducer(this, this.createClient());
            }
            case "ports": {
                return new PortProducer(this, this.createClient());
            }
            case "routers": {
                return new RouterProducer(this, this.createClient());
            }
        }
        throw new IllegalArgumentException("Can't create producer with subsystem " + this.subsystem);
    }

    public String getSubsystem() {
        return this.subsystem;
    }

    public void setSubsystem(String subsystem) {
        this.subsystem = subsystem;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Override
    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    @Override
    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }
}

