/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.linkedin;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.linkedin.LinkedInConfiguration;
import org.apache.camel.component.linkedin.LinkedInEndpoint;
import org.apache.camel.component.linkedin.api.LinkedInException;
import org.apache.camel.component.linkedin.api.model.Error;
import org.apache.camel.component.linkedin.internal.LinkedInApiName;
import org.apache.camel.support.component.AbstractApiConsumer;
import org.apache.camel.support.component.AbstractApiEndpoint;
import org.apache.camel.support.component.ApiMethod;

public class LinkedInConsumer
extends AbstractApiConsumer<LinkedInApiName, LinkedInConfiguration> {
    public LinkedInConsumer(LinkedInEndpoint endpoint, Processor processor) {
        super((AbstractApiEndpoint)endpoint, processor);
    }

    public void interceptPropertyNames(Set<String> propertyNames) {
        if (!propertyNames.contains("fields")) {
            List candidates = this.endpoint.getCandidates();
            for (ApiMethod method : candidates) {
                if (method.getArgNames().contains("fields")) continue;
                return;
            }
            propertyNames.add("fields");
        }
    }

    protected Object doInvokeMethod(Map<String, Object> args) {
        try {
            return super.doInvokeMethod(args);
        }
        catch (RuntimeCamelException e) {
            WebApplicationException cause;
            Response response;
            if (e.getCause() instanceof WebApplicationException && (response = (cause = (WebApplicationException)e.getCause()).getResponse()).hasEntity()) {
                Error error = (Error)response.readEntity(Error.class);
                throw new RuntimeCamelException(String.format("Error invoking %s: %s", this.method.getName(), error.getMessage()), (Throwable)new LinkedInException(error, response));
            }
            throw e;
        }
    }
}

