/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pgevent;

import com.impossibl.postgres.api.jdbc.PGConnection;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.pgevent.InvalidStateException;
import org.apache.camel.component.pgevent.PgEventEndpoint;
import org.apache.camel.support.DefaultProducer;

public class PgEventProducer
extends DefaultProducer {
    private final PgEventEndpoint endpoint;
    private PGConnection dbConnection;

    public PgEventProducer(PgEventEndpoint endpoint) throws Exception {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        try {
            if (this.dbConnection.isClosed()) {
                this.dbConnection = this.endpoint.initJdbc();
            }
        }
        catch (Exception e) {
            throw new InvalidStateException("Database connection closed and could not be re-opened.", e);
        }
        String payload = (String)exchange.getIn().getBody(String.class);
        if (this.dbConnection.isServerMinimumVersion(9, 0)) {
            try (CallableStatement statement = this.dbConnection.prepareCall("{call pg_notify(?, ?)}");){
                statement.setString(1, this.endpoint.getChannel());
                statement.setString(2, payload);
                statement.execute();
            }
        }
        String sql = String.format("NOTIFY %s, '%s'", this.endpoint.getChannel(), payload);
        try (PreparedStatement statement = this.dbConnection.prepareStatement(sql);){
            statement.execute();
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.dbConnection = this.endpoint.initJdbc();
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.dbConnection != null) {
            this.dbConnection.close();
        }
    }
}

