/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.apns;

import com.notnoop.apns.ApnsService;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.apns.ApnsComponent;
import org.apache.camel.component.apns.ApnsConsumer;
import org.apache.camel.component.apns.ApnsProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.ScheduledPollEndpoint;

@UriEndpoint(firstVersion="2.8.0", scheme="apns", title="APNS", syntax="apns:name", label="eventbus,mobile")
public class ApnsEndpoint
extends ScheduledPollEndpoint {
    private final CopyOnWriteArraySet<DefaultConsumer> consumers = new CopyOnWriteArraySet();
    @UriPath(description="Name of the endpoint")
    private String name;
    @UriParam
    private String tokens;

    public ApnsEndpoint(String uri, ApnsComponent component) {
        super(uri, (Component)component);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTokens() {
        return this.tokens;
    }

    public void setTokens(String tokens) {
        this.tokens = tokens;
    }

    private ApnsComponent getApnsComponent() {
        return (ApnsComponent)this.getComponent();
    }

    public ApnsService getApnsService() {
        return this.getApnsComponent().getApnsService();
    }

    protected Set<DefaultConsumer> getConsumers() {
        return this.consumers;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        ApnsConsumer apnsConsumer = new ApnsConsumer(this, processor);
        this.configureConsumer((Consumer)apnsConsumer);
        return apnsConsumer;
    }

    public Producer createProducer() throws Exception {
        return new ApnsProducer(this);
    }
}

