/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.eventbus.EventBus;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadRuntimeException;
import org.apache.camel.Message;
import org.apache.camel.component.vertx.VertxEndpoint;
import org.apache.camel.component.vertx.VertxHelper;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.MessageHelper;

public class VertxProducer
extends DefaultAsyncProducer {
    public VertxProducer(VertxEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public VertxEndpoint getEndpoint() {
        return (VertxEndpoint)super.getEndpoint();
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        EventBus eventBus = this.getEndpoint().getEventBus();
        if (eventBus == null) {
            exchange.setException((Throwable)new IllegalStateException("EventBus is not started or not configured"));
            callback.done(true);
            return true;
        }
        String address = this.getEndpoint().getAddress();
        boolean reply = ExchangeHelper.isOutCapable((Exchange)exchange);
        boolean pubSub = this.getEndpoint().isPubSub();
        Object body = VertxHelper.getVertxBody(exchange);
        if (body != null) {
            if (reply) {
                this.log.debug("Sending to: {} with body: {}", (Object)address, body);
                eventBus.send(address, body, (Handler)new CamelReplyHandler(exchange, callback));
                return false;
            }
            if (pubSub) {
                this.log.debug("Publishing to: {} with body: {}", (Object)address, body);
                eventBus.publish(address, body);
            } else {
                this.log.debug("Sending to: {} with body: {}", (Object)address, body);
                eventBus.send(address, body);
            }
            callback.done(true);
            return true;
        }
        exchange.setException((Throwable)new InvalidPayloadRuntimeException(exchange, String.class));
        callback.done(true);
        return true;
    }

    private static final class CamelReplyHandler
    implements Handler<AsyncResult<io.vertx.core.eventbus.Message<Object>>> {
        private final Exchange exchange;
        private final AsyncCallback callback;

        private CamelReplyHandler(Exchange exchange, AsyncCallback callback) {
            this.exchange = exchange;
            this.callback = callback;
        }

        public void handle(AsyncResult<io.vertx.core.eventbus.Message<Object>> event) {
            try {
                MessageHelper.copyHeaders((Message)this.exchange.getIn(), (Message)this.exchange.getOut(), (boolean)false);
                Throwable e = event.cause();
                if (e != null) {
                    this.exchange.setException(e);
                } else {
                    this.exchange.getOut().setBody(((io.vertx.core.eventbus.Message)event.result()).body());
                }
            }
            finally {
                this.callback.done(false);
            }
        }
    }
}

