/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi;

import java.util.Objects;
import java.util.function.Function;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.CreationException;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.camel.Processor;
import org.apache.camel.builder.DefaultErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.cdi.BeanManagerHelper;
import org.apache.camel.cdi.SyntheticAnnotated;
import org.apache.camel.cdi.SyntheticBean;
import org.apache.camel.cdi.xml.ErrorHandlerDefinition;
import org.apache.camel.cdi.xml.RedeliveryPolicyFactoryBean;
import org.apache.camel.processor.errorhandler.RedeliveryPolicy;
import org.apache.camel.util.ObjectHelper;

final class XmlErrorHandlerFactoryBean
extends SyntheticBean<ErrorHandlerBuilder> {
    private final BeanManager manager;
    private final ErrorHandlerDefinition handler;

    XmlErrorHandlerFactoryBean(BeanManager manager, SyntheticAnnotated annotated, Class<?> type, Function<Bean<ErrorHandlerBuilder>, String> toString, ErrorHandlerDefinition handler) {
        super(manager, annotated, type, null, toString);
        this.manager = manager;
        this.handler = handler;
    }

    @Override
    public ErrorHandlerBuilder create(CreationalContext<ErrorHandlerBuilder> creationalContext) {
        try {
            ErrorHandlerBuilder builder = this.handler.getType().getTypeAsClass().newInstance();
            switch (this.handler.getType()) {
                case DefaultErrorHandler: 
                case DeadLetterChannel: {
                    this.setProperties((DefaultErrorHandlerBuilder)builder);
                    break;
                }
                case NoErrorHandler: {
                    break;
                }
                case TransactionErrorHandler: {
                    break;
                }
            }
            return builder;
        }
        catch (Exception cause) {
            throw new CreationException("Error while creating instance for " + this, (Throwable)cause);
        }
    }

    @Override
    public void destroy(ErrorHandlerBuilder instance, CreationalContext<ErrorHandlerBuilder> creationalContext) {
    }

    private void setProperties(DefaultErrorHandlerBuilder builder) throws Exception {
        RedeliveryPolicyFactoryBean policy;
        Processor processor;
        if (Objects.nonNull(this.handler.getDeadLetterHandleNewException())) {
            builder.setDeadLetterHandleNewException(this.handler.getDeadLetterHandleNewException().booleanValue());
        }
        builder.setDeadLetterUri(this.handler.getDeadLetterUri());
        builder.setExecutorServiceRef(this.handler.getExecutorServiceRef());
        builder.setRetryWhileRef(this.handler.getRetryWhileRef());
        if (Objects.nonNull(this.handler.getUseOriginalMessage())) {
            builder.setUseOriginalMessage(this.handler.getUseOriginalMessage().booleanValue());
        }
        if (Objects.nonNull(this.handler.getUseOriginalBody())) {
            builder.setUseOriginalBody(this.handler.getUseOriginalBody().booleanValue());
        }
        if (ObjectHelper.isNotEmpty((Object)this.handler.getOnExceptionOccurredRef())) {
            processor = BeanManagerHelper.getReferenceByName(this.manager, this.handler.getOnExceptionOccurredRef(), Processor.class).orElseThrow(() -> new UnsatisfiedResolutionException(String.format("No bean with name [%s] to satisfy attribute [%s]", this.handler.getOnPrepareFailureRef(), "onExceptionOccurredRef")));
            builder.setOnExceptionOccurred(processor);
        }
        if (ObjectHelper.isNotEmpty((Object)this.handler.getOnPrepareFailureRef())) {
            processor = BeanManagerHelper.getReferenceByName(this.manager, this.handler.getOnPrepareFailureRef(), Processor.class).orElseThrow(() -> new UnsatisfiedResolutionException(String.format("No bean with name [%s] to satisfy attribute [%s]", this.handler.getOnPrepareFailureRef(), "onPrepareFailureRef")));
            builder.setOnPrepareFailure(processor);
        }
        if (ObjectHelper.isNotEmpty((Object)this.handler.getOnRedeliveryRef())) {
            processor = BeanManagerHelper.getReferenceByName(this.manager, this.handler.getOnRedeliveryRef(), Processor.class).orElseThrow(() -> new UnsatisfiedResolutionException(String.format("No bean with name [%s] to satisfy attribute [%s]", this.handler.getOnPrepareFailureRef(), "onRedeliveryRef")));
            builder.setOnRedelivery(processor);
        }
        if (Objects.nonNull(this.handler.getRedeliveryPolicy())) {
            policy = this.handler.getRedeliveryPolicy();
            policy.setBeanManager(this.manager);
            builder.setRedeliveryPolicy(policy.getObject());
        }
        if (ObjectHelper.isNotEmpty((Object)this.handler.getRedeliveryPolicyRef())) {
            policy = BeanManagerHelper.getReferenceByName(this.manager, this.handler.getRedeliveryPolicyRef(), RedeliveryPolicy.class).orElseThrow(() -> new UnsatisfiedResolutionException(String.format("No bean with name [%s] to satisfy attribute [%s]", this.handler.getRedeliveryPolicyRef(), "redeliveryPolicyRef")));
            builder.setRedeliveryPolicy((RedeliveryPolicy)policy);
        }
    }
}

