/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.cdi.AnyLiteral;
import org.apache.camel.cdi.BeanManagerHelper;
import org.apache.camel.cdi.Vetoed;
import org.apache.camel.main.MainSupport;
import org.apache.deltaspike.cdise.api.CdiContainer;
import org.apache.deltaspike.cdise.api.CdiContainerLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Vetoed
public class Main
extends MainSupport {
    private static final Logger LOG;
    private static Main instance;
    private CdiContainer cdiContainer;

    public static void main(String ... args) throws Exception {
        Main main;
        instance = main = new Main();
        main.run(args);
    }

    public static Main getInstance() {
        return instance;
    }

    protected ProducerTemplate findOrCreateCamelTemplate() {
        if (this.getCamelContext() == null) {
            throw new IllegalArgumentException("No CamelContext are available so cannot create a ProducerTemplate!");
        }
        return this.getCamelContext().createProducerTemplate();
    }

    protected CamelContext createCamelContext() {
        BeanManager manager = this.cdiContainer.getBeanManager();
        Map camels = manager.getBeans(CamelContext.class, new Annotation[]{AnyLiteral.ANY}).stream().map(bean -> BeanManagerHelper.getReference(manager, CamelContext.class, bean)).collect(Collectors.toMap(CamelContext::getName, Function.identity()));
        if (camels.size() > 1) {
            throw new IllegalArgumentException("Multiple CamelContext detected. This Main class only supports single CamelContext");
        }
        if (camels.size() == 1) {
            return (CamelContext)camels.values().iterator().next();
        }
        return null;
    }

    protected void doStart() throws Exception {
        CdiContainer container = CdiContainerLoader.getCdiContainer();
        container.boot();
        container.getContextControl().startContexts();
        this.cdiContainer = container;
        super.doStart();
        this.initCamelContext();
        this.warnIfNoCamelFound();
    }

    private void warnIfNoCamelFound() {
        BeanManager manager = this.cdiContainer.getBeanManager();
        Set contexts = manager.getBeans(CamelContext.class, new Annotation[]{AnyLiteral.ANY});
        if (contexts.isEmpty()) {
            LOG.warn("Camel CDI main has started with no Camel context!");
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.cdiContainer != null) {
            this.cdiContainer.shutdown();
        }
    }

    static {
        System.setProperty("org.jboss.weld.se.shutdownHook", String.valueOf(Boolean.FALSE));
        LOG = LoggerFactory.getLogger(Main.class);
    }
}

