/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.restlet;

import java.util.Map;
import org.apache.camel.AsyncEndpoint;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.restlet.DefaultRestletBinding;
import org.apache.camel.component.restlet.RestletBinding;
import org.apache.camel.component.restlet.RestletComponent;
import org.apache.camel.component.restlet.RestletConsumer;
import org.apache.camel.component.restlet.RestletHeaderFilterStrategy;
import org.apache.camel.component.restlet.RestletProducer;
import org.apache.camel.http.common.cookie.CookieHandler;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.restlet.data.Method;

@UriEndpoint(firstVersion="2.0.0", scheme="restlet", title="Restlet", syntax="restlet:protocol:host:port/uriPattern", label="rest", lenientProperties=true)
public class RestletEndpoint
extends DefaultEndpoint
implements AsyncEndpoint,
HeaderFilterStrategyAware {
    private static final int DEFAULT_PORT = 80;
    private static final String DEFAULT_PROTOCOL = "http";
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_SOCKET_TIMEOUT = 30000;
    private static final int DEFAULT_CONNECT_TIMEOUT = 30000;
    @UriPath(enums="http,https")
    @Metadata(required=true)
    private String protocol = "http";
    @UriPath
    @Metadata(required=true)
    private String host = "localhost";
    @UriPath(defaultValue="80")
    @Metadata(required=true)
    private int port = 80;
    @UriPath
    private String uriPattern;
    @UriParam(label="producer", defaultValue="30000")
    private int socketTimeout = 30000;
    @UriParam(label="producer", defaultValue="30000")
    private int connectTimeout = 30000;
    @UriParam(defaultValue="GET", enums="ALL,CONNECT,DELETE,GET,HEAD,OPTIONS,PATCH,POST,PUT,TRACE")
    private Method restletMethod = Method.GET;
    @UriParam(label="consumer")
    private String restletMethods;
    @UriParam(label="security")
    private Map<String, String> restletRealm;
    @UriParam(label="advanced")
    private HeaderFilterStrategy headerFilterStrategy;
    @UriParam(label="advanced")
    private RestletBinding restletBinding;
    @UriParam(label="producer", defaultValue="true")
    private boolean throwExceptionOnFailure = true;
    @UriParam(label="consumer,advanced")
    private boolean disableStreamCache;
    @UriParam(label="security")
    private SSLContextParameters sslContextParameters;
    @UriParam(label="producer,advanced")
    private boolean streamRepresentation;
    @UriParam(label="producer,advanced")
    private boolean autoCloseStream;
    @UriParam(label="producer")
    private CookieHandler cookieHandler;
    private transient Map<String, Object> queryParameters;

    public RestletEndpoint(RestletComponent component, String remaining) throws Exception {
        super(remaining, (Component)component);
    }

    public void setCompleteEndpointUri(String uri) {
        this.setEndpointUri(uri);
    }

    public boolean isLenientProperties() {
        return true;
    }

    public Exchange createExchange() {
        Exchange exchange = super.createExchange();
        if (this.isDisableStreamCache()) {
            exchange.setProperty("CamelDisableHttpStreamCache", (Object)Boolean.TRUE);
        }
        return exchange;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        RestletConsumer answer = new RestletConsumer((Endpoint)this, processor);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public Producer createProducer() throws Exception {
        return new RestletProducer(this);
    }

    public void connect(RestletConsumer restletConsumer) throws Exception {
        ((RestletComponent)this.getComponent()).connect(restletConsumer);
    }

    public void disconnect(RestletConsumer restletConsumer) throws Exception {
        ((RestletComponent)this.getComponent()).disconnect(restletConsumer);
    }

    public Method getRestletMethod() {
        return this.restletMethod;
    }

    public void setRestletMethod(Method restletMethod) {
        this.restletMethod = restletMethod;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public String getUriPattern() {
        return this.uriPattern;
    }

    public void setUriPattern(String uriPattern) {
        this.uriPattern = uriPattern;
    }

    public RestletBinding getRestletBinding() {
        return this.restletBinding;
    }

    public void setRestletBinding(RestletBinding restletBinding) {
        this.restletBinding = restletBinding;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
        if (this.restletBinding instanceof HeaderFilterStrategyAware) {
            ((HeaderFilterStrategyAware)this.restletBinding).setHeaderFilterStrategy(headerFilterStrategy);
        }
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setRestletRealm(Map<String, String> restletRealm) {
        this.restletRealm = restletRealm;
    }

    public Map<String, String> getRestletRealm() {
        return this.restletRealm;
    }

    public ExchangePattern getExchangePattern() {
        return ExchangePattern.InOut;
    }

    public void setRestletMethods(String restletMethods) {
        this.restletMethods = restletMethods;
    }

    public String getRestletMethods() {
        return this.restletMethods;
    }

    public boolean isThrowExceptionOnFailure() {
        return this.throwExceptionOnFailure;
    }

    public void setThrowExceptionOnFailure(boolean throwExceptionOnFailure) {
        this.throwExceptionOnFailure = throwExceptionOnFailure;
    }

    public boolean isDisableStreamCache() {
        return this.disableStreamCache;
    }

    public void setDisableStreamCache(boolean disableStreamCache) {
        this.disableStreamCache = disableStreamCache;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters scp) {
        this.sslContextParameters = scp;
    }

    public boolean isStreamRepresentation() {
        return this.streamRepresentation;
    }

    public void setStreamRepresentation(boolean streamRepresentation) {
        this.streamRepresentation = streamRepresentation;
    }

    public boolean isAutoCloseStream() {
        return this.autoCloseStream;
    }

    public void setAutoCloseStream(boolean autoCloseStream) {
        this.autoCloseStream = autoCloseStream;
    }

    public CookieHandler getCookieHandler() {
        return this.cookieHandler;
    }

    public void setCookieHandler(CookieHandler cookieHandler) {
        this.cookieHandler = cookieHandler;
    }

    public Map<String, Object> getQueryParameters() {
        return this.queryParameters;
    }

    public void setQueryParameters(Map<String, Object> queryParameters) {
        this.queryParameters = queryParameters;
    }

    protected void doStart() throws Exception {
        if (this.headerFilterStrategy == null) {
            this.headerFilterStrategy = new RestletHeaderFilterStrategy();
        }
        if (this.restletBinding == null) {
            this.restletBinding = new DefaultRestletBinding();
        }
        if (this.restletBinding instanceof HeaderFilterStrategyAware) {
            ((HeaderFilterStrategyAware)this.restletBinding).setHeaderFilterStrategy(this.getHeaderFilterStrategy());
        }
        if (this.restletBinding instanceof DefaultRestletBinding) {
            ((DefaultRestletBinding)this.restletBinding).setStreamRepresentation(this.isStreamRepresentation());
            ((DefaultRestletBinding)this.restletBinding).setAutoCloseStream(this.isAutoCloseStream());
        }
    }

    protected void doStop() throws Exception {
    }
}

