/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spark;

import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.spark.DataFrameCallback;
import org.apache.camel.component.spark.RddCallback;
import org.apache.camel.component.spark.SparkEndpoint;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.spark.api.java.JavaRDDLike;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class SparkEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer {
    public boolean configure(CamelContext camelContext, Object endpoint, String name, Object value, boolean ignoreCase) {
        if (ignoreCase) {
            return SparkEndpointConfigurer.doConfigureIgnoreCase(camelContext, endpoint, name, value);
        }
        return SparkEndpointConfigurer.doConfigure(camelContext, endpoint, name, value);
    }

    private static boolean doConfigure(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name) {
            case "rdd": {
                ((SparkEndpoint)((Object)endpoint)).setRdd((JavaRDDLike)SparkEndpointConfigurer.property((CamelContext)camelContext, JavaRDDLike.class, (Object)value));
                return true;
            }
            case "rddCallback": {
                ((SparkEndpoint)((Object)endpoint)).setRddCallback((RddCallback)SparkEndpointConfigurer.property((CamelContext)camelContext, RddCallback.class, (Object)value));
                return true;
            }
            case "dataFrame": {
                ((SparkEndpoint)((Object)endpoint)).setDataFrame((Dataset<Row>)((Dataset)SparkEndpointConfigurer.property((CamelContext)camelContext, Dataset.class, (Object)value)));
                return true;
            }
            case "dataFrameCallback": {
                ((SparkEndpoint)((Object)endpoint)).setDataFrameCallback((DataFrameCallback)SparkEndpointConfigurer.property((CamelContext)camelContext, DataFrameCallback.class, (Object)value));
                return true;
            }
            case "collect": {
                ((SparkEndpoint)((Object)endpoint)).setCollect((Boolean)SparkEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "lazyStartProducer": {
                ((SparkEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)SparkEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeErrorHandler": {
                ((SparkEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)SparkEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionHandler": {
                ((SparkEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)SparkEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangePattern": {
                ((SparkEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)SparkEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((SparkEndpoint)((Object)endpoint)).setSynchronous((Boolean)SparkEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicPropertyBinding": {
                ((SparkEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)SparkEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    private static boolean doConfigureIgnoreCase(CamelContext camelContext, Object endpoint, String name, Object value) {
        switch (name.toLowerCase()) {
            case "rdd": {
                ((SparkEndpoint)((Object)endpoint)).setRdd((JavaRDDLike)SparkEndpointConfigurer.property((CamelContext)camelContext, JavaRDDLike.class, (Object)value));
                return true;
            }
            case "rddcallback": {
                ((SparkEndpoint)((Object)endpoint)).setRddCallback((RddCallback)SparkEndpointConfigurer.property((CamelContext)camelContext, RddCallback.class, (Object)value));
                return true;
            }
            case "dataframe": {
                ((SparkEndpoint)((Object)endpoint)).setDataFrame((Dataset<Row>)((Dataset)SparkEndpointConfigurer.property((CamelContext)camelContext, Dataset.class, (Object)value)));
                return true;
            }
            case "dataframecallback": {
                ((SparkEndpoint)((Object)endpoint)).setDataFrameCallback((DataFrameCallback)SparkEndpointConfigurer.property((CamelContext)camelContext, DataFrameCallback.class, (Object)value));
                return true;
            }
            case "collect": {
                ((SparkEndpoint)((Object)endpoint)).setCollect((Boolean)SparkEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "lazystartproducer": {
                ((SparkEndpoint)((Object)endpoint)).setLazyStartProducer((Boolean)SparkEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": {
                ((SparkEndpoint)((Object)endpoint)).setBridgeErrorHandler((Boolean)SparkEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionhandler": {
                ((SparkEndpoint)((Object)endpoint)).setExceptionHandler((ExceptionHandler)SparkEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": {
                ((SparkEndpoint)((Object)endpoint)).setExchangePattern((ExchangePattern)SparkEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "synchronous": {
                ((SparkEndpoint)((Object)endpoint)).setSynchronous((Boolean)SparkEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": {
                ((SparkEndpoint)((Object)endpoint)).setBasicPropertyBinding((Boolean)SparkEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }
}

