/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.Map;
import java.util.Set;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.HeaderFilterStrategy;

/**
 * The undertow component provides HTTP and WebSocket based endpoints for
 * consuming and producing HTTP/WebSocket requests.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface UndertowEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Undertow component.
     */
    public interface UndertowEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedUndertowEndpointConsumerBuilder advanced() {
            return (AdvancedUndertowEndpointConsumerBuilder) this;
        }
        /**
         * For HTTP endpoint: if true, text and binary messages will be wrapped
         * as java.io.InputStream before they are passed to an Exchange;
         * otherwise they will be passed as byte. For WebSocket endpoint: if
         * true, text and binary messages will be wrapped as java.io.Reader and
         * java.io.InputStream respectively before they are passed to an
         * Exchange; otherwise they will be passed as String and byte
         * respectively.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default UndertowEndpointConsumerBuilder useStreaming(
                boolean useStreaming) {
            doSetProperty("useStreaming", useStreaming);
            return this;
        }
        /**
         * For HTTP endpoint: if true, text and binary messages will be wrapped
         * as java.io.InputStream before they are passed to an Exchange;
         * otherwise they will be passed as byte. For WebSocket endpoint: if
         * true, text and binary messages will be wrapped as java.io.Reader and
         * java.io.InputStream respectively before they are passed to an
         * Exchange; otherwise they will be passed as String and byte
         * respectively.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default UndertowEndpointConsumerBuilder useStreaming(String useStreaming) {
            doSetProperty("useStreaming", useStreaming);
            return this;
        }
        /**
         * Whether or not the consumer should write access log.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: consumer
         */
        default UndertowEndpointConsumerBuilder accessLog(Boolean accessLog) {
            doSetProperty("accessLog", accessLog);
            return this;
        }
        /**
         * Whether or not the consumer should write access log.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: consumer
         */
        default UndertowEndpointConsumerBuilder accessLog(String accessLog) {
            doSetProperty("accessLog", accessLog);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default UndertowEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default UndertowEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Used to only allow consuming if the HttpMethod matches, such as
         * GET/POST/PUT etc. Multiple methods can be specified separated by
         * comma.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default UndertowEndpointConsumerBuilder httpMethodRestrict(
                String httpMethodRestrict) {
            doSetProperty("httpMethodRestrict", httpMethodRestrict);
            return this;
        }
        /**
         * Whether or not the consumer should try to find a target consumer by
         * matching the URI prefix if no exact match is found.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: consumer
         */
        default UndertowEndpointConsumerBuilder matchOnUriPrefix(
                Boolean matchOnUriPrefix) {
            doSetProperty("matchOnUriPrefix", matchOnUriPrefix);
            return this;
        }
        /**
         * Whether or not the consumer should try to find a target consumer by
         * matching the URI prefix if no exact match is found.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: consumer
         */
        default UndertowEndpointConsumerBuilder matchOnUriPrefix(
                String matchOnUriPrefix) {
            doSetProperty("matchOnUriPrefix", matchOnUriPrefix);
            return this;
        }
        /**
         * Specifies whether to enable HTTP OPTIONS for this Servlet consumer.
         * By default OPTIONS is turned off.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default UndertowEndpointConsumerBuilder optionsEnabled(
                boolean optionsEnabled) {
            doSetProperty("optionsEnabled", optionsEnabled);
            return this;
        }
        /**
         * Specifies whether to enable HTTP OPTIONS for this Servlet consumer.
         * By default OPTIONS is turned off.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default UndertowEndpointConsumerBuilder optionsEnabled(
                String optionsEnabled) {
            doSetProperty("optionsEnabled", optionsEnabled);
            return this;
        }
        /**
         * if true, the consumer will post notifications to the route when a new
         * WebSocket peer connects, disconnects, etc. See
         * UndertowConstants.EVENT_TYPE and EventType.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: websocket
         */
        default UndertowEndpointConsumerBuilder fireWebSocketChannelEvents(
                boolean fireWebSocketChannelEvents) {
            doSetProperty("fireWebSocketChannelEvents", fireWebSocketChannelEvents);
            return this;
        }
        /**
         * if true, the consumer will post notifications to the route when a new
         * WebSocket peer connects, disconnects, etc. See
         * UndertowConstants.EVENT_TYPE and EventType.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: websocket
         */
        default UndertowEndpointConsumerBuilder fireWebSocketChannelEvents(
                String fireWebSocketChannelEvents) {
            doSetProperty("fireWebSocketChannelEvents", fireWebSocketChannelEvents);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default UndertowEndpointConsumerBuilder sslContextParameters(
                Object sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default UndertowEndpointConsumerBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Undertow component.
     */
    public interface AdvancedUndertowEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default UndertowEndpointConsumerBuilder basic() {
            return (UndertowEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedUndertowEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedUndertowEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedUndertowEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedUndertowEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Specifies a comma-delimited set of io.undertow.server.HttpHandler
         * instances in your Registry (such as your Spring ApplicationContext).
         * These handlers are added to the Undertow handler chain (for example,
         * to add security). Important: You can not use different handlers with
         * different Undertow endpoints using the same port number. The handlers
         * is associated to the port number. If you need different handlers,
         * then use different port numbers.
         * 
         * The option is a:
         * <code>java.util.Set&lt;org.apache.camel.component.undertow.HttpHandlerRegistrationInfo&gt;</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedUndertowEndpointConsumerBuilder handlers(
                Set<Object> handlers) {
            doSetProperty("handlers", handlers);
            return this;
        }
        /**
         * Specifies a comma-delimited set of io.undertow.server.HttpHandler
         * instances in your Registry (such as your Spring ApplicationContext).
         * These handlers are added to the Undertow handler chain (for example,
         * to add security). Important: You can not use different handlers with
         * different Undertow endpoints using the same port number. The handlers
         * is associated to the port number. If you need different handlers,
         * then use different port numbers.
         * 
         * The option will be converted to a
         * <code>java.util.Set&lt;org.apache.camel.component.undertow.HttpHandlerRegistrationInfo&gt;</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedUndertowEndpointConsumerBuilder handlers(String handlers) {
            doSetProperty("handlers", handlers);
            return this;
        }
        /**
         * Which Undertow AccessLogReciever should be used Will use
         * JBossLoggingAccessLogReceiver if not specifid.
         * 
         * The option is a:
         * <code>io.undertow.server.handlers.accesslog.AccessLogReceiver</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedUndertowEndpointConsumerBuilder accessLogReceiver(
                Object accessLogReceiver) {
            doSetProperty("accessLogReceiver", accessLogReceiver);
            return this;
        }
        /**
         * Which Undertow AccessLogReciever should be used Will use
         * JBossLoggingAccessLogReceiver if not specifid.
         * 
         * The option will be converted to a
         * <code>io.undertow.server.handlers.accesslog.AccessLogReceiver</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedUndertowEndpointConsumerBuilder accessLogReceiver(
                String accessLogReceiver) {
            doSetProperty("accessLogReceiver", accessLogReceiver);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedUndertowEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedUndertowEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedUndertowEndpointConsumerBuilder headerFilterStrategy(
                HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedUndertowEndpointConsumerBuilder headerFilterStrategy(
                String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedUndertowEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedUndertowEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * To use a custom UndertowHttpBinding to control the mapping between
         * Camel message and undertow.
         * 
         * The option is a:
         * <code>org.apache.camel.component.undertow.UndertowHttpBinding</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedUndertowEndpointConsumerBuilder undertowHttpBinding(
                Object undertowHttpBinding) {
            doSetProperty("undertowHttpBinding", undertowHttpBinding);
            return this;
        }
        /**
         * To use a custom UndertowHttpBinding to control the mapping between
         * Camel message and undertow.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.undertow.UndertowHttpBinding</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedUndertowEndpointConsumerBuilder undertowHttpBinding(
                String undertowHttpBinding) {
            doSetProperty("undertowHttpBinding", undertowHttpBinding);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Undertow component.
     */
    public interface UndertowEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedUndertowEndpointProducerBuilder advanced() {
            return (AdvancedUndertowEndpointProducerBuilder) this;
        }
        /**
         * For HTTP endpoint: if true, text and binary messages will be wrapped
         * as java.io.InputStream before they are passed to an Exchange;
         * otherwise they will be passed as byte. For WebSocket endpoint: if
         * true, text and binary messages will be wrapped as java.io.Reader and
         * java.io.InputStream respectively before they are passed to an
         * Exchange; otherwise they will be passed as String and byte
         * respectively.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default UndertowEndpointProducerBuilder useStreaming(
                boolean useStreaming) {
            doSetProperty("useStreaming", useStreaming);
            return this;
        }
        /**
         * For HTTP endpoint: if true, text and binary messages will be wrapped
         * as java.io.InputStream before they are passed to an Exchange;
         * otherwise they will be passed as byte. For WebSocket endpoint: if
         * true, text and binary messages will be wrapped as java.io.Reader and
         * java.io.InputStream respectively before they are passed to an
         * Exchange; otherwise they will be passed as String and byte
         * respectively.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default UndertowEndpointProducerBuilder useStreaming(String useStreaming) {
            doSetProperty("useStreaming", useStreaming);
            return this;
        }
        /**
         * Configure a cookie handler to maintain a HTTP session.
         * 
         * The option is a:
         * <code>org.apache.camel.http.common.cookie.CookieHandler</code> type.
         * 
         * Group: producer
         */
        default UndertowEndpointProducerBuilder cookieHandler(
                Object cookieHandler) {
            doSetProperty("cookieHandler", cookieHandler);
            return this;
        }
        /**
         * Configure a cookie handler to maintain a HTTP session.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.http.common.cookie.CookieHandler</code> type.
         * 
         * Group: producer
         */
        default UndertowEndpointProducerBuilder cookieHandler(
                String cookieHandler) {
            doSetProperty("cookieHandler", cookieHandler);
            return this;
        }
        /**
         * Setting to ensure socket is not closed due to inactivity.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: producer
         */
        default UndertowEndpointProducerBuilder keepAlive(Boolean keepAlive) {
            doSetProperty("keepAlive", keepAlive);
            return this;
        }
        /**
         * Setting to ensure socket is not closed due to inactivity.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: producer
         */
        default UndertowEndpointProducerBuilder keepAlive(String keepAlive) {
            doSetProperty("keepAlive", keepAlive);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default UndertowEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default UndertowEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Sets additional channel options. The options that can be used are
         * defined in org.xnio.Options. To configure from endpoint uri, then
         * prefix each option with option., such as
         * option.close-abort=true&option.send-buffer=8192.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: producer
         */
        default UndertowEndpointProducerBuilder options(
                Map<String, Object> options) {
            doSetProperty("options", options);
            return this;
        }
        /**
         * Sets additional channel options. The options that can be used are
         * defined in org.xnio.Options. To configure from endpoint uri, then
         * prefix each option with option., such as
         * option.close-abort=true&option.send-buffer=8192.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: producer
         */
        default UndertowEndpointProducerBuilder options(String options) {
            doSetProperty("options", options);
            return this;
        }
        /**
         * Setting to facilitate socket multiplexing.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: producer
         */
        default UndertowEndpointProducerBuilder reuseAddresses(
                Boolean reuseAddresses) {
            doSetProperty("reuseAddresses", reuseAddresses);
            return this;
        }
        /**
         * Setting to facilitate socket multiplexing.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: producer
         */
        default UndertowEndpointProducerBuilder reuseAddresses(
                String reuseAddresses) {
            doSetProperty("reuseAddresses", reuseAddresses);
            return this;
        }
        /**
         * Setting to improve TCP protocol performance.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: producer
         */
        default UndertowEndpointProducerBuilder tcpNoDelay(Boolean tcpNoDelay) {
            doSetProperty("tcpNoDelay", tcpNoDelay);
            return this;
        }
        /**
         * Setting to improve TCP protocol performance.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: producer
         */
        default UndertowEndpointProducerBuilder tcpNoDelay(String tcpNoDelay) {
            doSetProperty("tcpNoDelay", tcpNoDelay);
            return this;
        }
        /**
         * Option to disable throwing the HttpOperationFailedException in case
         * of failed responses from the remote server. This allows you to get
         * all responses regardless of the HTTP status code.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: producer
         */
        default UndertowEndpointProducerBuilder throwExceptionOnFailure(
                Boolean throwExceptionOnFailure) {
            doSetProperty("throwExceptionOnFailure", throwExceptionOnFailure);
            return this;
        }
        /**
         * Option to disable throwing the HttpOperationFailedException in case
         * of failed responses from the remote server. This allows you to get
         * all responses regardless of the HTTP status code.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: producer
         */
        default UndertowEndpointProducerBuilder throwExceptionOnFailure(
                String throwExceptionOnFailure) {
            doSetProperty("throwExceptionOnFailure", throwExceptionOnFailure);
            return this;
        }
        /**
         * If enabled and an Exchange failed processing on the consumer side and
         * if the caused Exception was send back serialized in the response as a
         * application/x-java-serialized-object content type. On the producer
         * side the exception will be deserialized and thrown as is instead of
         * the HttpOperationFailedException. The caused exception is required to
         * be serialized. This is by default turned off. If you enable this then
         * be aware that Java will deserialize the incoming data from the
         * request to Java and that can be a potential security risk.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: producer
         */
        default UndertowEndpointProducerBuilder transferException(
                Boolean transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
        /**
         * If enabled and an Exchange failed processing on the consumer side and
         * if the caused Exception was send back serialized in the response as a
         * application/x-java-serialized-object content type. On the producer
         * side the exception will be deserialized and thrown as is instead of
         * the HttpOperationFailedException. The caused exception is required to
         * be serialized. This is by default turned off. If you enable this then
         * be aware that Java will deserialize the incoming data from the
         * request to Java and that can be a potential security risk.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: producer
         */
        default UndertowEndpointProducerBuilder transferException(
                String transferException) {
            doSetProperty("transferException", transferException);
            return this;
        }
        /**
         * Timeout in milliseconds when sending to a websocket channel. The
         * default timeout is 30000 (30 seconds).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: websocket
         */
        default UndertowEndpointProducerBuilder sendTimeout(Integer sendTimeout) {
            doSetProperty("sendTimeout", sendTimeout);
            return this;
        }
        /**
         * Timeout in milliseconds when sending to a websocket channel. The
         * default timeout is 30000 (30 seconds).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: websocket
         */
        default UndertowEndpointProducerBuilder sendTimeout(String sendTimeout) {
            doSetProperty("sendTimeout", sendTimeout);
            return this;
        }
        /**
         * To send to all websocket subscribers. Can be used to configure on
         * endpoint level, instead of having to use the
         * UndertowConstants.SEND_TO_ALL header on the message.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: websocket
         */
        default UndertowEndpointProducerBuilder sendToAll(Boolean sendToAll) {
            doSetProperty("sendToAll", sendToAll);
            return this;
        }
        /**
         * To send to all websocket subscribers. Can be used to configure on
         * endpoint level, instead of having to use the
         * UndertowConstants.SEND_TO_ALL header on the message.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: websocket
         */
        default UndertowEndpointProducerBuilder sendToAll(String sendToAll) {
            doSetProperty("sendToAll", sendToAll);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default UndertowEndpointProducerBuilder sslContextParameters(
                Object sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default UndertowEndpointProducerBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Undertow component.
     */
    public interface AdvancedUndertowEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default UndertowEndpointProducerBuilder basic() {
            return (UndertowEndpointProducerBuilder) this;
        }
        /**
         * Which Undertow AccessLogReciever should be used Will use
         * JBossLoggingAccessLogReceiver if not specifid.
         * 
         * The option is a:
         * <code>io.undertow.server.handlers.accesslog.AccessLogReceiver</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedUndertowEndpointProducerBuilder accessLogReceiver(
                Object accessLogReceiver) {
            doSetProperty("accessLogReceiver", accessLogReceiver);
            return this;
        }
        /**
         * Which Undertow AccessLogReciever should be used Will use
         * JBossLoggingAccessLogReceiver if not specifid.
         * 
         * The option will be converted to a
         * <code>io.undertow.server.handlers.accesslog.AccessLogReceiver</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedUndertowEndpointProducerBuilder accessLogReceiver(
                String accessLogReceiver) {
            doSetProperty("accessLogReceiver", accessLogReceiver);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedUndertowEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedUndertowEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedUndertowEndpointProducerBuilder headerFilterStrategy(
                HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedUndertowEndpointProducerBuilder headerFilterStrategy(
                String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedUndertowEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedUndertowEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * To use a custom UndertowHttpBinding to control the mapping between
         * Camel message and undertow.
         * 
         * The option is a:
         * <code>org.apache.camel.component.undertow.UndertowHttpBinding</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedUndertowEndpointProducerBuilder undertowHttpBinding(
                Object undertowHttpBinding) {
            doSetProperty("undertowHttpBinding", undertowHttpBinding);
            return this;
        }
        /**
         * To use a custom UndertowHttpBinding to control the mapping between
         * Camel message and undertow.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.undertow.UndertowHttpBinding</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedUndertowEndpointProducerBuilder undertowHttpBinding(
                String undertowHttpBinding) {
            doSetProperty("undertowHttpBinding", undertowHttpBinding);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Undertow component.
     */
    public interface UndertowEndpointBuilder
            extends
                UndertowEndpointConsumerBuilder, UndertowEndpointProducerBuilder {
        default AdvancedUndertowEndpointBuilder advanced() {
            return (AdvancedUndertowEndpointBuilder) this;
        }
        /**
         * For HTTP endpoint: if true, text and binary messages will be wrapped
         * as java.io.InputStream before they are passed to an Exchange;
         * otherwise they will be passed as byte. For WebSocket endpoint: if
         * true, text and binary messages will be wrapped as java.io.Reader and
         * java.io.InputStream respectively before they are passed to an
         * Exchange; otherwise they will be passed as String and byte
         * respectively.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default UndertowEndpointBuilder useStreaming(boolean useStreaming) {
            doSetProperty("useStreaming", useStreaming);
            return this;
        }
        /**
         * For HTTP endpoint: if true, text and binary messages will be wrapped
         * as java.io.InputStream before they are passed to an Exchange;
         * otherwise they will be passed as byte. For WebSocket endpoint: if
         * true, text and binary messages will be wrapped as java.io.Reader and
         * java.io.InputStream respectively before they are passed to an
         * Exchange; otherwise they will be passed as String and byte
         * respectively.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default UndertowEndpointBuilder useStreaming(String useStreaming) {
            doSetProperty("useStreaming", useStreaming);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default UndertowEndpointBuilder sslContextParameters(
                Object sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default UndertowEndpointBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Undertow component.
     */
    public interface AdvancedUndertowEndpointBuilder
            extends
                AdvancedUndertowEndpointConsumerBuilder, AdvancedUndertowEndpointProducerBuilder {
        default UndertowEndpointBuilder basic() {
            return (UndertowEndpointBuilder) this;
        }
        /**
         * Which Undertow AccessLogReciever should be used Will use
         * JBossLoggingAccessLogReceiver if not specifid.
         * 
         * The option is a:
         * <code>io.undertow.server.handlers.accesslog.AccessLogReceiver</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedUndertowEndpointBuilder accessLogReceiver(
                Object accessLogReceiver) {
            doSetProperty("accessLogReceiver", accessLogReceiver);
            return this;
        }
        /**
         * Which Undertow AccessLogReciever should be used Will use
         * JBossLoggingAccessLogReceiver if not specifid.
         * 
         * The option will be converted to a
         * <code>io.undertow.server.handlers.accesslog.AccessLogReceiver</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedUndertowEndpointBuilder accessLogReceiver(
                String accessLogReceiver) {
            doSetProperty("accessLogReceiver", accessLogReceiver);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedUndertowEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedUndertowEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedUndertowEndpointBuilder headerFilterStrategy(
                HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedUndertowEndpointBuilder headerFilterStrategy(
                String headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedUndertowEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedUndertowEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * To use a custom UndertowHttpBinding to control the mapping between
         * Camel message and undertow.
         * 
         * The option is a:
         * <code>org.apache.camel.component.undertow.UndertowHttpBinding</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedUndertowEndpointBuilder undertowHttpBinding(
                Object undertowHttpBinding) {
            doSetProperty("undertowHttpBinding", undertowHttpBinding);
            return this;
        }
        /**
         * To use a custom UndertowHttpBinding to control the mapping between
         * Camel message and undertow.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.undertow.UndertowHttpBinding</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedUndertowEndpointBuilder undertowHttpBinding(
                String undertowHttpBinding) {
            doSetProperty("undertowHttpBinding", undertowHttpBinding);
            return this;
        }
    }
    /**
     * Undertow (camel-undertow)
     * The undertow component provides HTTP and WebSocket based endpoints for
     * consuming and producing HTTP/WebSocket requests.
     * 
     * Category: http,websocket
     * Available as of version: 2.16
     * Maven coordinates: org.apache.camel:camel-undertow
     * 
     * Syntax: <code>undertow:httpURI</code>
     * 
     * Path parameter: httpURI (required)
     * The url of the HTTP endpoint to use.
     */
    default UndertowEndpointBuilder undertow(String path) {
        class UndertowEndpointBuilderImpl extends AbstractEndpointBuilder implements UndertowEndpointBuilder, AdvancedUndertowEndpointBuilder {
            public UndertowEndpointBuilderImpl(String path) {
                super("undertow", path);
            }
        }
        return new UndertowEndpointBuilderImpl(path);
    }
}