/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * The Thrift component allows to call and expose remote procedures (RPC) with
 * Apache Thrift data format and serialization mechanism
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface ThriftEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Thrift component.
     */
    public interface ThriftEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedThriftEndpointConsumerBuilder advanced() {
            return (AdvancedThriftEndpointConsumerBuilder) this;
        }
        /**
         * Protocol compression mechanism type.
         * 
         * The option is a:
         * <code>org.apache.camel.component.thrift.ThriftCompressionType</code>
         * type.
         * 
         * Group: common
         */
        default ThriftEndpointConsumerBuilder compressionType(
                ThriftCompressionType compressionType) {
            doSetProperty("compressionType", compressionType);
            return this;
        }
        /**
         * Protocol compression mechanism type.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.thrift.ThriftCompressionType</code>
         * type.
         * 
         * Group: common
         */
        default ThriftEndpointConsumerBuilder compressionType(
                String compressionType) {
            doSetProperty("compressionType", compressionType);
            return this;
        }
        /**
         * Exchange protocol serialization type.
         * 
         * The option is a:
         * <code>org.apache.camel.component.thrift.ThriftExchangeProtocol</code>
         * type.
         * 
         * Group: common
         */
        default ThriftEndpointConsumerBuilder exchangeProtocol(
                ThriftExchangeProtocol exchangeProtocol) {
            doSetProperty("exchangeProtocol", exchangeProtocol);
            return this;
        }
        /**
         * Exchange protocol serialization type.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.thrift.ThriftExchangeProtocol</code>
         * type.
         * 
         * Group: common
         */
        default ThriftEndpointConsumerBuilder exchangeProtocol(
                String exchangeProtocol) {
            doSetProperty("exchangeProtocol", exchangeProtocol);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default ThriftEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default ThriftEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Client timeout for consumers.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: consumer
         */
        default ThriftEndpointConsumerBuilder clientTimeout(int clientTimeout) {
            doSetProperty("clientTimeout", clientTimeout);
            return this;
        }
        /**
         * Client timeout for consumers.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: consumer
         */
        default ThriftEndpointConsumerBuilder clientTimeout(String clientTimeout) {
            doSetProperty("clientTimeout", clientTimeout);
            return this;
        }
        /**
         * The Thrift server consumer max thread pool size.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: consumer
         */
        default ThriftEndpointConsumerBuilder maxPoolSize(int maxPoolSize) {
            doSetProperty("maxPoolSize", maxPoolSize);
            return this;
        }
        /**
         * The Thrift server consumer max thread pool size.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: consumer
         */
        default ThriftEndpointConsumerBuilder maxPoolSize(String maxPoolSize) {
            doSetProperty("maxPoolSize", maxPoolSize);
            return this;
        }
        /**
         * The Thrift server consumer initial thread pool size.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: consumer
         */
        default ThriftEndpointConsumerBuilder poolSize(int poolSize) {
            doSetProperty("poolSize", poolSize);
            return this;
        }
        /**
         * The Thrift server consumer initial thread pool size.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: consumer
         */
        default ThriftEndpointConsumerBuilder poolSize(String poolSize) {
            doSetProperty("poolSize", poolSize);
            return this;
        }
        /**
         * Security negotiation type.
         * 
         * The option is a:
         * <code>org.apache.camel.component.thrift.ThriftNegotiationType</code>
         * type.
         * 
         * Group: security
         */
        default ThriftEndpointConsumerBuilder negotiationType(
                ThriftNegotiationType negotiationType) {
            doSetProperty("negotiationType", negotiationType);
            return this;
        }
        /**
         * Security negotiation type.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.thrift.ThriftNegotiationType</code>
         * type.
         * 
         * Group: security
         */
        default ThriftEndpointConsumerBuilder negotiationType(
                String negotiationType) {
            doSetProperty("negotiationType", negotiationType);
            return this;
        }
        /**
         * Configuration parameters for SSL/TLS security negotiation.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default ThriftEndpointConsumerBuilder sslParameters(Object sslParameters) {
            doSetProperty("sslParameters", sslParameters);
            return this;
        }
        /**
         * Configuration parameters for SSL/TLS security negotiation.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default ThriftEndpointConsumerBuilder sslParameters(String sslParameters) {
            doSetProperty("sslParameters", sslParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Thrift component.
     */
    public interface AdvancedThriftEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default ThriftEndpointConsumerBuilder basic() {
            return (ThriftEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedThriftEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedThriftEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedThriftEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedThriftEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedThriftEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedThriftEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedThriftEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedThriftEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Thrift component.
     */
    public interface ThriftEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedThriftEndpointProducerBuilder advanced() {
            return (AdvancedThriftEndpointProducerBuilder) this;
        }
        /**
         * Protocol compression mechanism type.
         * 
         * The option is a:
         * <code>org.apache.camel.component.thrift.ThriftCompressionType</code>
         * type.
         * 
         * Group: common
         */
        default ThriftEndpointProducerBuilder compressionType(
                ThriftCompressionType compressionType) {
            doSetProperty("compressionType", compressionType);
            return this;
        }
        /**
         * Protocol compression mechanism type.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.thrift.ThriftCompressionType</code>
         * type.
         * 
         * Group: common
         */
        default ThriftEndpointProducerBuilder compressionType(
                String compressionType) {
            doSetProperty("compressionType", compressionType);
            return this;
        }
        /**
         * Exchange protocol serialization type.
         * 
         * The option is a:
         * <code>org.apache.camel.component.thrift.ThriftExchangeProtocol</code>
         * type.
         * 
         * Group: common
         */
        default ThriftEndpointProducerBuilder exchangeProtocol(
                ThriftExchangeProtocol exchangeProtocol) {
            doSetProperty("exchangeProtocol", exchangeProtocol);
            return this;
        }
        /**
         * Exchange protocol serialization type.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.thrift.ThriftExchangeProtocol</code>
         * type.
         * 
         * Group: common
         */
        default ThriftEndpointProducerBuilder exchangeProtocol(
                String exchangeProtocol) {
            doSetProperty("exchangeProtocol", exchangeProtocol);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default ThriftEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default ThriftEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * The Thrift invoked method name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default ThriftEndpointProducerBuilder method(String method) {
            doSetProperty("method", method);
            return this;
        }
        /**
         * Security negotiation type.
         * 
         * The option is a:
         * <code>org.apache.camel.component.thrift.ThriftNegotiationType</code>
         * type.
         * 
         * Group: security
         */
        default ThriftEndpointProducerBuilder negotiationType(
                ThriftNegotiationType negotiationType) {
            doSetProperty("negotiationType", negotiationType);
            return this;
        }
        /**
         * Security negotiation type.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.thrift.ThriftNegotiationType</code>
         * type.
         * 
         * Group: security
         */
        default ThriftEndpointProducerBuilder negotiationType(
                String negotiationType) {
            doSetProperty("negotiationType", negotiationType);
            return this;
        }
        /**
         * Configuration parameters for SSL/TLS security negotiation.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default ThriftEndpointProducerBuilder sslParameters(Object sslParameters) {
            doSetProperty("sslParameters", sslParameters);
            return this;
        }
        /**
         * Configuration parameters for SSL/TLS security negotiation.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default ThriftEndpointProducerBuilder sslParameters(String sslParameters) {
            doSetProperty("sslParameters", sslParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Thrift component.
     */
    public interface AdvancedThriftEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default ThriftEndpointProducerBuilder basic() {
            return (ThriftEndpointProducerBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedThriftEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedThriftEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedThriftEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedThriftEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Thrift component.
     */
    public interface ThriftEndpointBuilder
            extends
                ThriftEndpointConsumerBuilder, ThriftEndpointProducerBuilder {
        default AdvancedThriftEndpointBuilder advanced() {
            return (AdvancedThriftEndpointBuilder) this;
        }
        /**
         * Protocol compression mechanism type.
         * 
         * The option is a:
         * <code>org.apache.camel.component.thrift.ThriftCompressionType</code>
         * type.
         * 
         * Group: common
         */
        default ThriftEndpointBuilder compressionType(
                ThriftCompressionType compressionType) {
            doSetProperty("compressionType", compressionType);
            return this;
        }
        /**
         * Protocol compression mechanism type.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.thrift.ThriftCompressionType</code>
         * type.
         * 
         * Group: common
         */
        default ThriftEndpointBuilder compressionType(String compressionType) {
            doSetProperty("compressionType", compressionType);
            return this;
        }
        /**
         * Exchange protocol serialization type.
         * 
         * The option is a:
         * <code>org.apache.camel.component.thrift.ThriftExchangeProtocol</code>
         * type.
         * 
         * Group: common
         */
        default ThriftEndpointBuilder exchangeProtocol(
                ThriftExchangeProtocol exchangeProtocol) {
            doSetProperty("exchangeProtocol", exchangeProtocol);
            return this;
        }
        /**
         * Exchange protocol serialization type.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.thrift.ThriftExchangeProtocol</code>
         * type.
         * 
         * Group: common
         */
        default ThriftEndpointBuilder exchangeProtocol(String exchangeProtocol) {
            doSetProperty("exchangeProtocol", exchangeProtocol);
            return this;
        }
        /**
         * Security negotiation type.
         * 
         * The option is a:
         * <code>org.apache.camel.component.thrift.ThriftNegotiationType</code>
         * type.
         * 
         * Group: security
         */
        default ThriftEndpointBuilder negotiationType(
                ThriftNegotiationType negotiationType) {
            doSetProperty("negotiationType", negotiationType);
            return this;
        }
        /**
         * Security negotiation type.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.thrift.ThriftNegotiationType</code>
         * type.
         * 
         * Group: security
         */
        default ThriftEndpointBuilder negotiationType(String negotiationType) {
            doSetProperty("negotiationType", negotiationType);
            return this;
        }
        /**
         * Configuration parameters for SSL/TLS security negotiation.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default ThriftEndpointBuilder sslParameters(Object sslParameters) {
            doSetProperty("sslParameters", sslParameters);
            return this;
        }
        /**
         * Configuration parameters for SSL/TLS security negotiation.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default ThriftEndpointBuilder sslParameters(String sslParameters) {
            doSetProperty("sslParameters", sslParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Thrift component.
     */
    public interface AdvancedThriftEndpointBuilder
            extends
                AdvancedThriftEndpointConsumerBuilder, AdvancedThriftEndpointProducerBuilder {
        default ThriftEndpointBuilder basic() {
            return (ThriftEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedThriftEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedThriftEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedThriftEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedThriftEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.thrift.ThriftCompressionType</code>
     * enum.
     */
    enum ThriftCompressionType {
        NONE,
        ZLIB;
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.thrift.ThriftExchangeProtocol</code>
     * enum.
     */
    enum ThriftExchangeProtocol {
        BINARY,
        JSON,
        SJSON,
        COMPACT;
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.thrift.ThriftNegotiationType</code>
     * enum.
     */
    enum ThriftNegotiationType {
        PLAINTEXT,
        SSL,
        SASL;
    }
    /**
     * Thrift (camel-thrift)
     * The Thrift component allows to call and expose remote procedures (RPC)
     * with Apache Thrift data format and serialization mechanism
     * 
     * Category: rpc
     * Available as of version: 2.20
     * Maven coordinates: org.apache.camel:camel-thrift
     * 
     * Syntax: <code>thrift:host:port/service</code>
     * 
     * Path parameter: host
     * The Thrift server host name. This is localhost or 0.0.0.0 (if not
     * defined) when being a consumer or remote server host name when using
     * producer.
     * 
     * Path parameter: port (required)
     * The Thrift server port
     * 
     * Path parameter: service (required)
     * Fully qualified service name from the thrift descriptor file (package dot
     * service definition name)
     */
    default ThriftEndpointBuilder thrift(String path) {
        class ThriftEndpointBuilderImpl extends AbstractEndpointBuilder implements ThriftEndpointBuilder, AdvancedThriftEndpointBuilder {
            public ThriftEndpointBuilderImpl(String path) {
                super("thrift", path);
            }
        }
        return new ThriftEndpointBuilderImpl(path);
    }
}