/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.io.File;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.PollingConsumerPollStrategy;

/**
 * Represents a RobotFramework endpoint.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface RobotFrameworkEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Robot Framework component.
     */
    public interface RobotFrameworkEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedRobotFrameworkEndpointConsumerBuilder advanced() {
            return (AdvancedRobotFrameworkEndpointConsumerBuilder) this;
        }
        /**
         * A text file to read more arguments from.
         * 
         * The option is a: <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder argumentFile(
                File argumentFile) {
            doSetProperty("argumentFile", argumentFile);
            return this;
        }
        /**
         * A text file to read more arguments from.
         * 
         * The option will be converted to a <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder argumentFile(
                String argumentFile) {
            doSetProperty("argumentFile", argumentFile);
            return this;
        }
        /**
         * Creates combined statistics based on tags. Use the format tags:title
         * List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder combinedTagStats(
                String combinedTagStats) {
            doSetProperty("combinedTagStats", combinedTagStats);
            return this;
        }
        /**
         * Sets whether to use resource content cache or not.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder contentCache(
                boolean contentCache) {
            doSetProperty("contentCache", contentCache);
            return this;
        }
        /**
         * Sets whether to use resource content cache or not.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder contentCache(
                String contentCache) {
            doSetProperty("contentCache", contentCache);
            return this;
        }
        /**
         * Tests that have the given tags are considered critical. List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder criticalTags(
                String criticalTags) {
            doSetProperty("criticalTags", criticalTags);
            return this;
        }
        /**
         * A debug file that is written during execution.
         * 
         * The option is a: <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder debugFile(File debugFile) {
            doSetProperty("debugFile", debugFile);
            return this;
        }
        /**
         * A debug file that is written during execution.
         * 
         * The option will be converted to a <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder debugFile(String debugFile) {
            doSetProperty("debugFile", debugFile);
            return this;
        }
        /**
         * Sets the documentation of the top-level tests suites.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder document(String document) {
            doSetProperty("document", document);
            return this;
        }
        /**
         * Sets dryrun mode on use. In the dry run mode tests are run without
         * executing keywords originating from test libraries. Useful for
         * validating test data syntax.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder dryrun(boolean dryrun) {
            doSetProperty("dryrun", dryrun);
            return this;
        }
        /**
         * Sets dryrun mode on use. In the dry run mode tests are run without
         * executing keywords originating from test libraries. Useful for
         * validating test data syntax.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder dryrun(String dryrun) {
            doSetProperty("dryrun", dryrun);
            return this;
        }
        /**
         * Selects the tests cases by tags. List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder excludes(String excludes) {
            doSetProperty("excludes", excludes);
            return this;
        }
        /**
         * Sets robot to stop execution immediately if a critical test fails.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder exitOnFailure(
                boolean exitOnFailure) {
            doSetProperty("exitOnFailure", exitOnFailure);
            return this;
        }
        /**
         * Sets robot to stop execution immediately if a critical test fails.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder exitOnFailure(
                String exitOnFailure) {
            doSetProperty("exitOnFailure", exitOnFailure);
            return this;
        }
        /**
         * Selects the tests cases by tags. List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder includes(String includes) {
            doSetProperty("includes", includes);
            return this;
        }
        /**
         * Sets a single listener for monitoring tests execution.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder listener(String listener) {
            doSetProperty("listener", listener);
            return this;
        }
        /**
         * Sets multiple listeners for monitoring tests execution. Use the
         * format ListenerWithArgs:arg1:arg2 or simply ListenerWithoutArgs List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder listeners(String listeners) {
            doSetProperty("listeners", listeners);
            return this;
        }
        /**
         * Sets the path to the generated log file.
         * 
         * The option is a: <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder log(File log) {
            doSetProperty("log", log);
            return this;
        }
        /**
         * Sets the path to the generated log file.
         * 
         * The option will be converted to a <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder log(String log) {
            doSetProperty("log", log);
            return this;
        }
        /**
         * Sets the threshold level for logging.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder logLevel(String logLevel) {
            doSetProperty("logLevel", logLevel);
            return this;
        }
        /**
         * Sets a title for the generated tests log.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder logTitle(String logTitle) {
            doSetProperty("logTitle", logTitle);
            return this;
        }
        /**
         * Sets free metadata for the top level tests suites. comma seperated
         * list of string resulting as List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder metadata(String metadata) {
            doSetProperty("metadata", metadata);
            return this;
        }
        /**
         * Using ANSI colors in console. Normally colors work in unixes but not
         * in Windows. Default is 'on'. 'on' - use colors in unixes but not in
         * Windows 'off' - never use colors 'force' - always use colors (also in
         * Windows).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder monitorColors(
                String monitorColors) {
            doSetProperty("monitorColors", monitorColors);
            return this;
        }
        /**
         * Width of the monitor output. Default is 78.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder monitorWidth(
                String monitorWidth) {
            doSetProperty("monitorWidth", monitorWidth);
            return this;
        }
        /**
         * Sets the name of the top-level tests suites.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder name(String name) {
            doSetProperty("name", name);
            return this;
        }
        /**
         * Tests that have the given tags are not critical. List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder nonCriticalTags(
                String nonCriticalTags) {
            doSetProperty("nonCriticalTags", nonCriticalTags);
            return this;
        }
        /**
         * If true, sets the return code to zero regardless of failures in test
         * cases. Error codes are returned normally.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder noStatusReturnCode(
                boolean noStatusReturnCode) {
            doSetProperty("noStatusReturnCode", noStatusReturnCode);
            return this;
        }
        /**
         * If true, sets the return code to zero regardless of failures in test
         * cases. Error codes are returned normally.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder noStatusReturnCode(
                String noStatusReturnCode) {
            doSetProperty("noStatusReturnCode", noStatusReturnCode);
            return this;
        }
        /**
         * Sets the path to the generated output file.
         * 
         * The option is a: <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder output(File output) {
            doSetProperty("output", output);
            return this;
        }
        /**
         * Sets the path to the generated output file.
         * 
         * The option will be converted to a <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder output(String output) {
            doSetProperty("output", output);
            return this;
        }
        /**
         * Configures where generated reports are to be placed.
         * 
         * The option is a: <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder outputDirectory(
                File outputDirectory) {
            doSetProperty("outputDirectory", outputDirectory);
            return this;
        }
        /**
         * Configures where generated reports are to be placed.
         * 
         * The option will be converted to a <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder outputDirectory(
                String outputDirectory) {
            doSetProperty("outputDirectory", outputDirectory);
            return this;
        }
        /**
         * Sets the test execution order to be randomized. Valid values are all,
         * suite, and test.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder randomize(String randomize) {
            doSetProperty("randomize", randomize);
            return this;
        }
        /**
         * Sets the path to the generated report file.
         * 
         * The option is a: <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder report(File report) {
            doSetProperty("report", report);
            return this;
        }
        /**
         * Sets the path to the generated report file.
         * 
         * The option will be converted to a <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder report(String report) {
            doSetProperty("report", report);
            return this;
        }
        /**
         * Sets background colors for the generated report and summary.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder reportBackground(
                String reportBackground) {
            doSetProperty("reportBackground", reportBackground);
            return this;
        }
        /**
         * Sets a title for the generated tests report.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder reportTitle(
                String reportTitle) {
            doSetProperty("reportTitle", reportTitle);
            return this;
        }
        /**
         * Executes tests also if the top level test suite is empty. Useful e.g.
         * with --include/--exclude when it is not an error that no test matches
         * the condition.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder runEmptySuite(
                boolean runEmptySuite) {
            doSetProperty("runEmptySuite", runEmptySuite);
            return this;
        }
        /**
         * Executes tests also if the top level test suite is empty. Useful e.g.
         * with --include/--exclude when it is not an error that no test matches
         * the condition.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder runEmptySuite(
                String runEmptySuite) {
            doSetProperty("runEmptySuite", runEmptySuite);
            return this;
        }
        /**
         * Re-run failed tests, based on output.xml file.
         * 
         * The option is a: <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder runFailed(File runFailed) {
            doSetProperty("runFailed", runFailed);
            return this;
        }
        /**
         * Re-run failed tests, based on output.xml file.
         * 
         * The option will be converted to a <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder runFailed(String runFailed) {
            doSetProperty("runFailed", runFailed);
            return this;
        }
        /**
         * Sets the execution mode for this tests run. Note that this setting
         * has been deprecated in Robot Framework 2.8. Use separate dryryn,
         * skipTeardownOnExit, exitOnFailure, and randomize settings instead.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder runMode(String runMode) {
            doSetProperty("runMode", runMode);
            return this;
        }
        /**
         * Sets whether the teardowns are skipped if the test execution is
         * prematurely stopped.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder skipTeardownOnExit(
                boolean skipTeardownOnExit) {
            doSetProperty("skipTeardownOnExit", skipTeardownOnExit);
            return this;
        }
        /**
         * Sets whether the teardowns are skipped if the test execution is
         * prematurely stopped.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder skipTeardownOnExit(
                String skipTeardownOnExit) {
            doSetProperty("skipTeardownOnExit", skipTeardownOnExit);
            return this;
        }
        /**
         * Splits output and log files.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder splitOutputs(
                String splitOutputs) {
            doSetProperty("splitOutputs", splitOutputs);
            return this;
        }
        /**
         * Selects the tests suites by name. List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder suites(String suites) {
            doSetProperty("suites", suites);
            return this;
        }
        /**
         * Defines how many levels to show in the Statistics by Suite table in
         * outputs.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder suiteStatLevel(
                String suiteStatLevel) {
            doSetProperty("suiteStatLevel", suiteStatLevel);
            return this;
        }
        /**
         * Sets a title for the generated summary report.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder summaryTitle(
                String summaryTitle) {
            doSetProperty("summaryTitle", summaryTitle);
            return this;
        }
        /**
         * Adds documentation to the specified tags. List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder tagDocs(String tagDocs) {
            doSetProperty("tagDocs", tagDocs);
            return this;
        }
        /**
         * Sets the tags(s) to all executed tests cases. List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder tags(String tags) {
            doSetProperty("tags", tags);
            return this;
        }
        /**
         * Excludes these tags from the Statistics by Tag and Test Details by
         * Tag tables in outputs. List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder tagStatExcludes(
                String tagStatExcludes) {
            doSetProperty("tagStatExcludes", tagStatExcludes);
            return this;
        }
        /**
         * Includes only these tags in the Statistics by Tag and Test Details by
         * Tag tables in outputs. List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder tagStatIncludes(
                String tagStatIncludes) {
            doSetProperty("tagStatIncludes", tagStatIncludes);
            return this;
        }
        /**
         * Adds external links to the Statistics by Tag table in outputs. Use
         * the format pattern:link:title List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder tagStatLinks(
                String tagStatLinks) {
            doSetProperty("tagStatLinks", tagStatLinks);
            return this;
        }
        /**
         * Selects the tests cases by name. List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder tests(String tests) {
            doSetProperty("tests", tests);
            return this;
        }
        /**
         * Adds a timestamp to all output files.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder timestampOutputs(
                boolean timestampOutputs) {
            doSetProperty("timestampOutputs", timestampOutputs);
            return this;
        }
        /**
         * Adds a timestamp to all output files.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder timestampOutputs(
                String timestampOutputs) {
            doSetProperty("timestampOutputs", timestampOutputs);
            return this;
        }
        /**
         * Sets variables using variables files. Use the format path:args List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder variableFiles(
                String variableFiles) {
            doSetProperty("variableFiles", variableFiles);
            return this;
        }
        /**
         * Sets individual variables. Use the format name:value List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder variables(String variables) {
            doSetProperty("variables", variables);
            return this;
        }
        /**
         * Show a warning when an invalid file is skipped.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder warnOnSkippedFiles(
                boolean warnOnSkippedFiles) {
            doSetProperty("warnOnSkippedFiles", warnOnSkippedFiles);
            return this;
        }
        /**
         * Show a warning when an invalid file is skipped.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder warnOnSkippedFiles(
                String warnOnSkippedFiles) {
            doSetProperty("warnOnSkippedFiles", warnOnSkippedFiles);
            return this;
        }
        /**
         * Sets the path to the generated XUnit compatible result file, relative
         * to outputDirectory. The file is in xml format. By default, the file
         * name is derived from the testCasesDirectory parameter, replacing
         * blanks in the directory name by underscores.
         * 
         * The option is a: <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder xunitFile(File xunitFile) {
            doSetProperty("xunitFile", xunitFile);
            return this;
        }
        /**
         * Sets the path to the generated XUnit compatible result file, relative
         * to outputDirectory. The file is in xml format. By default, the file
         * name is derived from the testCasesDirectory parameter, replacing
         * blanks in the directory name by underscores.
         * 
         * The option will be converted to a <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointConsumerBuilder xunitFile(String xunitFile) {
            doSetProperty("xunitFile", xunitFile);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default RobotFrameworkEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default RobotFrameworkEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default RobotFrameworkEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                boolean sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default RobotFrameworkEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                String sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default RobotFrameworkEndpointConsumerBuilder backoffErrorThreshold(
                int backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default RobotFrameworkEndpointConsumerBuilder backoffErrorThreshold(
                String backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default RobotFrameworkEndpointConsumerBuilder backoffIdleThreshold(
                int backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default RobotFrameworkEndpointConsumerBuilder backoffIdleThreshold(
                String backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default RobotFrameworkEndpointConsumerBuilder backoffMultiplier(
                int backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default RobotFrameworkEndpointConsumerBuilder backoffMultiplier(
                String backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * Milliseconds before the next poll. You can also specify time values
         * using units, such as 60s (60 seconds), 5m30s (5 minutes and 30
         * seconds), and 1h (1 hour).
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: scheduler
         */
        default RobotFrameworkEndpointConsumerBuilder delay(long delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * Milliseconds before the next poll. You can also specify time values
         * using units, such as 60s (60 seconds), 5m30s (5 minutes and 30
         * seconds), and 1h (1 hour).
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: scheduler
         */
        default RobotFrameworkEndpointConsumerBuilder delay(String delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default RobotFrameworkEndpointConsumerBuilder greedy(boolean greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default RobotFrameworkEndpointConsumerBuilder greedy(String greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * Milliseconds before the first poll starts. You can also specify time
         * values using units, such as 60s (60 seconds), 5m30s (5 minutes and 30
         * seconds), and 1h (1 hour).
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: scheduler
         */
        default RobotFrameworkEndpointConsumerBuilder initialDelay(
                long initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Milliseconds before the first poll starts. You can also specify time
         * values using units, such as 60s (60 seconds), 5m30s (5 minutes and 30
         * seconds), and 1h (1 hour).
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: scheduler
         */
        default RobotFrameworkEndpointConsumerBuilder initialDelay(
                String initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option is a: <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Group: scheduler
         */
        default RobotFrameworkEndpointConsumerBuilder runLoggingLevel(
                LoggingLevel runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Group: scheduler
         */
        default RobotFrameworkEndpointConsumerBuilder runLoggingLevel(
                String runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option is a:
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         */
        default RobotFrameworkEndpointConsumerBuilder scheduledExecutorService(
                ScheduledExecutorService scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         */
        default RobotFrameworkEndpointConsumerBuilder scheduledExecutorService(
                String scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: scheduler
         */
        default RobotFrameworkEndpointConsumerBuilder scheduler(String scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: scheduler
         */
        default RobotFrameworkEndpointConsumerBuilder schedulerProperties(
                Map<String, Object> schedulerProperties) {
            doSetProperty("schedulerProperties", schedulerProperties);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: scheduler
         */
        default RobotFrameworkEndpointConsumerBuilder schedulerProperties(
                String schedulerProperties) {
            doSetProperty("schedulerProperties", schedulerProperties);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default RobotFrameworkEndpointConsumerBuilder startScheduler(
                boolean startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default RobotFrameworkEndpointConsumerBuilder startScheduler(
                String startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option is a: <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Group: scheduler
         */
        default RobotFrameworkEndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Group: scheduler
         */
        default RobotFrameworkEndpointConsumerBuilder timeUnit(String timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default RobotFrameworkEndpointConsumerBuilder useFixedDelay(
                boolean useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default RobotFrameworkEndpointConsumerBuilder useFixedDelay(
                String useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Robot Framework
     * component.
     */
    public interface AdvancedRobotFrameworkEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default RobotFrameworkEndpointConsumerBuilder basic() {
            return (RobotFrameworkEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedRobotFrameworkEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedRobotFrameworkEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedRobotFrameworkEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedRobotFrameworkEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedRobotFrameworkEndpointConsumerBuilder pollStrategy(
                PollingConsumerPollStrategy pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedRobotFrameworkEndpointConsumerBuilder pollStrategy(
                String pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRobotFrameworkEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRobotFrameworkEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRobotFrameworkEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRobotFrameworkEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Robot Framework component.
     */
    public interface RobotFrameworkEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedRobotFrameworkEndpointProducerBuilder advanced() {
            return (AdvancedRobotFrameworkEndpointProducerBuilder) this;
        }
        /**
         * A text file to read more arguments from.
         * 
         * The option is a: <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder argumentFile(
                File argumentFile) {
            doSetProperty("argumentFile", argumentFile);
            return this;
        }
        /**
         * A text file to read more arguments from.
         * 
         * The option will be converted to a <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder argumentFile(
                String argumentFile) {
            doSetProperty("argumentFile", argumentFile);
            return this;
        }
        /**
         * Creates combined statistics based on tags. Use the format tags:title
         * List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder combinedTagStats(
                String combinedTagStats) {
            doSetProperty("combinedTagStats", combinedTagStats);
            return this;
        }
        /**
         * Sets whether to use resource content cache or not.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder contentCache(
                boolean contentCache) {
            doSetProperty("contentCache", contentCache);
            return this;
        }
        /**
         * Sets whether to use resource content cache or not.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder contentCache(
                String contentCache) {
            doSetProperty("contentCache", contentCache);
            return this;
        }
        /**
         * Tests that have the given tags are considered critical. List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder criticalTags(
                String criticalTags) {
            doSetProperty("criticalTags", criticalTags);
            return this;
        }
        /**
         * A debug file that is written during execution.
         * 
         * The option is a: <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder debugFile(File debugFile) {
            doSetProperty("debugFile", debugFile);
            return this;
        }
        /**
         * A debug file that is written during execution.
         * 
         * The option will be converted to a <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder debugFile(String debugFile) {
            doSetProperty("debugFile", debugFile);
            return this;
        }
        /**
         * Sets the documentation of the top-level tests suites.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder document(String document) {
            doSetProperty("document", document);
            return this;
        }
        /**
         * Sets dryrun mode on use. In the dry run mode tests are run without
         * executing keywords originating from test libraries. Useful for
         * validating test data syntax.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder dryrun(boolean dryrun) {
            doSetProperty("dryrun", dryrun);
            return this;
        }
        /**
         * Sets dryrun mode on use. In the dry run mode tests are run without
         * executing keywords originating from test libraries. Useful for
         * validating test data syntax.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder dryrun(String dryrun) {
            doSetProperty("dryrun", dryrun);
            return this;
        }
        /**
         * Selects the tests cases by tags. List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder excludes(String excludes) {
            doSetProperty("excludes", excludes);
            return this;
        }
        /**
         * Sets robot to stop execution immediately if a critical test fails.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder exitOnFailure(
                boolean exitOnFailure) {
            doSetProperty("exitOnFailure", exitOnFailure);
            return this;
        }
        /**
         * Sets robot to stop execution immediately if a critical test fails.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder exitOnFailure(
                String exitOnFailure) {
            doSetProperty("exitOnFailure", exitOnFailure);
            return this;
        }
        /**
         * Selects the tests cases by tags. List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder includes(String includes) {
            doSetProperty("includes", includes);
            return this;
        }
        /**
         * Sets a single listener for monitoring tests execution.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder listener(String listener) {
            doSetProperty("listener", listener);
            return this;
        }
        /**
         * Sets multiple listeners for monitoring tests execution. Use the
         * format ListenerWithArgs:arg1:arg2 or simply ListenerWithoutArgs List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder listeners(String listeners) {
            doSetProperty("listeners", listeners);
            return this;
        }
        /**
         * Sets the path to the generated log file.
         * 
         * The option is a: <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder log(File log) {
            doSetProperty("log", log);
            return this;
        }
        /**
         * Sets the path to the generated log file.
         * 
         * The option will be converted to a <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder log(String log) {
            doSetProperty("log", log);
            return this;
        }
        /**
         * Sets the threshold level for logging.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder logLevel(String logLevel) {
            doSetProperty("logLevel", logLevel);
            return this;
        }
        /**
         * Sets a title for the generated tests log.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder logTitle(String logTitle) {
            doSetProperty("logTitle", logTitle);
            return this;
        }
        /**
         * Sets free metadata for the top level tests suites. comma seperated
         * list of string resulting as List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder metadata(String metadata) {
            doSetProperty("metadata", metadata);
            return this;
        }
        /**
         * Using ANSI colors in console. Normally colors work in unixes but not
         * in Windows. Default is 'on'. 'on' - use colors in unixes but not in
         * Windows 'off' - never use colors 'force' - always use colors (also in
         * Windows).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder monitorColors(
                String monitorColors) {
            doSetProperty("monitorColors", monitorColors);
            return this;
        }
        /**
         * Width of the monitor output. Default is 78.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder monitorWidth(
                String monitorWidth) {
            doSetProperty("monitorWidth", monitorWidth);
            return this;
        }
        /**
         * Sets the name of the top-level tests suites.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder name(String name) {
            doSetProperty("name", name);
            return this;
        }
        /**
         * Tests that have the given tags are not critical. List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder nonCriticalTags(
                String nonCriticalTags) {
            doSetProperty("nonCriticalTags", nonCriticalTags);
            return this;
        }
        /**
         * If true, sets the return code to zero regardless of failures in test
         * cases. Error codes are returned normally.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder noStatusReturnCode(
                boolean noStatusReturnCode) {
            doSetProperty("noStatusReturnCode", noStatusReturnCode);
            return this;
        }
        /**
         * If true, sets the return code to zero regardless of failures in test
         * cases. Error codes are returned normally.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder noStatusReturnCode(
                String noStatusReturnCode) {
            doSetProperty("noStatusReturnCode", noStatusReturnCode);
            return this;
        }
        /**
         * Sets the path to the generated output file.
         * 
         * The option is a: <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder output(File output) {
            doSetProperty("output", output);
            return this;
        }
        /**
         * Sets the path to the generated output file.
         * 
         * The option will be converted to a <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder output(String output) {
            doSetProperty("output", output);
            return this;
        }
        /**
         * Configures where generated reports are to be placed.
         * 
         * The option is a: <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder outputDirectory(
                File outputDirectory) {
            doSetProperty("outputDirectory", outputDirectory);
            return this;
        }
        /**
         * Configures where generated reports are to be placed.
         * 
         * The option will be converted to a <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder outputDirectory(
                String outputDirectory) {
            doSetProperty("outputDirectory", outputDirectory);
            return this;
        }
        /**
         * Sets the test execution order to be randomized. Valid values are all,
         * suite, and test.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder randomize(String randomize) {
            doSetProperty("randomize", randomize);
            return this;
        }
        /**
         * Sets the path to the generated report file.
         * 
         * The option is a: <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder report(File report) {
            doSetProperty("report", report);
            return this;
        }
        /**
         * Sets the path to the generated report file.
         * 
         * The option will be converted to a <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder report(String report) {
            doSetProperty("report", report);
            return this;
        }
        /**
         * Sets background colors for the generated report and summary.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder reportBackground(
                String reportBackground) {
            doSetProperty("reportBackground", reportBackground);
            return this;
        }
        /**
         * Sets a title for the generated tests report.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder reportTitle(
                String reportTitle) {
            doSetProperty("reportTitle", reportTitle);
            return this;
        }
        /**
         * Executes tests also if the top level test suite is empty. Useful e.g.
         * with --include/--exclude when it is not an error that no test matches
         * the condition.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder runEmptySuite(
                boolean runEmptySuite) {
            doSetProperty("runEmptySuite", runEmptySuite);
            return this;
        }
        /**
         * Executes tests also if the top level test suite is empty. Useful e.g.
         * with --include/--exclude when it is not an error that no test matches
         * the condition.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder runEmptySuite(
                String runEmptySuite) {
            doSetProperty("runEmptySuite", runEmptySuite);
            return this;
        }
        /**
         * Re-run failed tests, based on output.xml file.
         * 
         * The option is a: <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder runFailed(File runFailed) {
            doSetProperty("runFailed", runFailed);
            return this;
        }
        /**
         * Re-run failed tests, based on output.xml file.
         * 
         * The option will be converted to a <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder runFailed(String runFailed) {
            doSetProperty("runFailed", runFailed);
            return this;
        }
        /**
         * Sets the execution mode for this tests run. Note that this setting
         * has been deprecated in Robot Framework 2.8. Use separate dryryn,
         * skipTeardownOnExit, exitOnFailure, and randomize settings instead.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder runMode(String runMode) {
            doSetProperty("runMode", runMode);
            return this;
        }
        /**
         * Sets whether the teardowns are skipped if the test execution is
         * prematurely stopped.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder skipTeardownOnExit(
                boolean skipTeardownOnExit) {
            doSetProperty("skipTeardownOnExit", skipTeardownOnExit);
            return this;
        }
        /**
         * Sets whether the teardowns are skipped if the test execution is
         * prematurely stopped.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder skipTeardownOnExit(
                String skipTeardownOnExit) {
            doSetProperty("skipTeardownOnExit", skipTeardownOnExit);
            return this;
        }
        /**
         * Splits output and log files.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder splitOutputs(
                String splitOutputs) {
            doSetProperty("splitOutputs", splitOutputs);
            return this;
        }
        /**
         * Selects the tests suites by name. List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder suites(String suites) {
            doSetProperty("suites", suites);
            return this;
        }
        /**
         * Defines how many levels to show in the Statistics by Suite table in
         * outputs.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder suiteStatLevel(
                String suiteStatLevel) {
            doSetProperty("suiteStatLevel", suiteStatLevel);
            return this;
        }
        /**
         * Sets a title for the generated summary report.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder summaryTitle(
                String summaryTitle) {
            doSetProperty("summaryTitle", summaryTitle);
            return this;
        }
        /**
         * Adds documentation to the specified tags. List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder tagDocs(String tagDocs) {
            doSetProperty("tagDocs", tagDocs);
            return this;
        }
        /**
         * Sets the tags(s) to all executed tests cases. List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder tags(String tags) {
            doSetProperty("tags", tags);
            return this;
        }
        /**
         * Excludes these tags from the Statistics by Tag and Test Details by
         * Tag tables in outputs. List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder tagStatExcludes(
                String tagStatExcludes) {
            doSetProperty("tagStatExcludes", tagStatExcludes);
            return this;
        }
        /**
         * Includes only these tags in the Statistics by Tag and Test Details by
         * Tag tables in outputs. List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder tagStatIncludes(
                String tagStatIncludes) {
            doSetProperty("tagStatIncludes", tagStatIncludes);
            return this;
        }
        /**
         * Adds external links to the Statistics by Tag table in outputs. Use
         * the format pattern:link:title List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder tagStatLinks(
                String tagStatLinks) {
            doSetProperty("tagStatLinks", tagStatLinks);
            return this;
        }
        /**
         * Selects the tests cases by name. List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder tests(String tests) {
            doSetProperty("tests", tests);
            return this;
        }
        /**
         * Adds a timestamp to all output files.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder timestampOutputs(
                boolean timestampOutputs) {
            doSetProperty("timestampOutputs", timestampOutputs);
            return this;
        }
        /**
         * Adds a timestamp to all output files.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder timestampOutputs(
                String timestampOutputs) {
            doSetProperty("timestampOutputs", timestampOutputs);
            return this;
        }
        /**
         * Sets variables using variables files. Use the format path:args List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder variableFiles(
                String variableFiles) {
            doSetProperty("variableFiles", variableFiles);
            return this;
        }
        /**
         * Sets individual variables. Use the format name:value List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder variables(String variables) {
            doSetProperty("variables", variables);
            return this;
        }
        /**
         * Show a warning when an invalid file is skipped.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder warnOnSkippedFiles(
                boolean warnOnSkippedFiles) {
            doSetProperty("warnOnSkippedFiles", warnOnSkippedFiles);
            return this;
        }
        /**
         * Show a warning when an invalid file is skipped.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder warnOnSkippedFiles(
                String warnOnSkippedFiles) {
            doSetProperty("warnOnSkippedFiles", warnOnSkippedFiles);
            return this;
        }
        /**
         * Sets the path to the generated XUnit compatible result file, relative
         * to outputDirectory. The file is in xml format. By default, the file
         * name is derived from the testCasesDirectory parameter, replacing
         * blanks in the directory name by underscores.
         * 
         * The option is a: <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder xunitFile(File xunitFile) {
            doSetProperty("xunitFile", xunitFile);
            return this;
        }
        /**
         * Sets the path to the generated XUnit compatible result file, relative
         * to outputDirectory. The file is in xml format. By default, the file
         * name is derived from the testCasesDirectory parameter, replacing
         * blanks in the directory name by underscores.
         * 
         * The option will be converted to a <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointProducerBuilder xunitFile(String xunitFile) {
            doSetProperty("xunitFile", xunitFile);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default RobotFrameworkEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default RobotFrameworkEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Robot Framework
     * component.
     */
    public interface AdvancedRobotFrameworkEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default RobotFrameworkEndpointProducerBuilder basic() {
            return (RobotFrameworkEndpointProducerBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRobotFrameworkEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRobotFrameworkEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRobotFrameworkEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRobotFrameworkEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Robot Framework component.
     */
    public interface RobotFrameworkEndpointBuilder
            extends
                RobotFrameworkEndpointConsumerBuilder, RobotFrameworkEndpointProducerBuilder {
        default AdvancedRobotFrameworkEndpointBuilder advanced() {
            return (AdvancedRobotFrameworkEndpointBuilder) this;
        }
        /**
         * A text file to read more arguments from.
         * 
         * The option is a: <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder argumentFile(File argumentFile) {
            doSetProperty("argumentFile", argumentFile);
            return this;
        }
        /**
         * A text file to read more arguments from.
         * 
         * The option will be converted to a <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder argumentFile(String argumentFile) {
            doSetProperty("argumentFile", argumentFile);
            return this;
        }
        /**
         * Creates combined statistics based on tags. Use the format tags:title
         * List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder combinedTagStats(
                String combinedTagStats) {
            doSetProperty("combinedTagStats", combinedTagStats);
            return this;
        }
        /**
         * Sets whether to use resource content cache or not.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder contentCache(boolean contentCache) {
            doSetProperty("contentCache", contentCache);
            return this;
        }
        /**
         * Sets whether to use resource content cache or not.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder contentCache(String contentCache) {
            doSetProperty("contentCache", contentCache);
            return this;
        }
        /**
         * Tests that have the given tags are considered critical. List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder criticalTags(String criticalTags) {
            doSetProperty("criticalTags", criticalTags);
            return this;
        }
        /**
         * A debug file that is written during execution.
         * 
         * The option is a: <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder debugFile(File debugFile) {
            doSetProperty("debugFile", debugFile);
            return this;
        }
        /**
         * A debug file that is written during execution.
         * 
         * The option will be converted to a <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder debugFile(String debugFile) {
            doSetProperty("debugFile", debugFile);
            return this;
        }
        /**
         * Sets the documentation of the top-level tests suites.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder document(String document) {
            doSetProperty("document", document);
            return this;
        }
        /**
         * Sets dryrun mode on use. In the dry run mode tests are run without
         * executing keywords originating from test libraries. Useful for
         * validating test data syntax.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder dryrun(boolean dryrun) {
            doSetProperty("dryrun", dryrun);
            return this;
        }
        /**
         * Sets dryrun mode on use. In the dry run mode tests are run without
         * executing keywords originating from test libraries. Useful for
         * validating test data syntax.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder dryrun(String dryrun) {
            doSetProperty("dryrun", dryrun);
            return this;
        }
        /**
         * Selects the tests cases by tags. List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder excludes(String excludes) {
            doSetProperty("excludes", excludes);
            return this;
        }
        /**
         * Sets robot to stop execution immediately if a critical test fails.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder exitOnFailure(
                boolean exitOnFailure) {
            doSetProperty("exitOnFailure", exitOnFailure);
            return this;
        }
        /**
         * Sets robot to stop execution immediately if a critical test fails.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder exitOnFailure(String exitOnFailure) {
            doSetProperty("exitOnFailure", exitOnFailure);
            return this;
        }
        /**
         * Selects the tests cases by tags. List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder includes(String includes) {
            doSetProperty("includes", includes);
            return this;
        }
        /**
         * Sets a single listener for monitoring tests execution.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder listener(String listener) {
            doSetProperty("listener", listener);
            return this;
        }
        /**
         * Sets multiple listeners for monitoring tests execution. Use the
         * format ListenerWithArgs:arg1:arg2 or simply ListenerWithoutArgs List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder listeners(String listeners) {
            doSetProperty("listeners", listeners);
            return this;
        }
        /**
         * Sets the path to the generated log file.
         * 
         * The option is a: <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder log(File log) {
            doSetProperty("log", log);
            return this;
        }
        /**
         * Sets the path to the generated log file.
         * 
         * The option will be converted to a <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder log(String log) {
            doSetProperty("log", log);
            return this;
        }
        /**
         * Sets the threshold level for logging.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder logLevel(String logLevel) {
            doSetProperty("logLevel", logLevel);
            return this;
        }
        /**
         * Sets a title for the generated tests log.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder logTitle(String logTitle) {
            doSetProperty("logTitle", logTitle);
            return this;
        }
        /**
         * Sets free metadata for the top level tests suites. comma seperated
         * list of string resulting as List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder metadata(String metadata) {
            doSetProperty("metadata", metadata);
            return this;
        }
        /**
         * Using ANSI colors in console. Normally colors work in unixes but not
         * in Windows. Default is 'on'. 'on' - use colors in unixes but not in
         * Windows 'off' - never use colors 'force' - always use colors (also in
         * Windows).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder monitorColors(String monitorColors) {
            doSetProperty("monitorColors", monitorColors);
            return this;
        }
        /**
         * Width of the monitor output. Default is 78.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder monitorWidth(String monitorWidth) {
            doSetProperty("monitorWidth", monitorWidth);
            return this;
        }
        /**
         * Sets the name of the top-level tests suites.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder name(String name) {
            doSetProperty("name", name);
            return this;
        }
        /**
         * Tests that have the given tags are not critical. List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder nonCriticalTags(
                String nonCriticalTags) {
            doSetProperty("nonCriticalTags", nonCriticalTags);
            return this;
        }
        /**
         * If true, sets the return code to zero regardless of failures in test
         * cases. Error codes are returned normally.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder noStatusReturnCode(
                boolean noStatusReturnCode) {
            doSetProperty("noStatusReturnCode", noStatusReturnCode);
            return this;
        }
        /**
         * If true, sets the return code to zero regardless of failures in test
         * cases. Error codes are returned normally.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder noStatusReturnCode(
                String noStatusReturnCode) {
            doSetProperty("noStatusReturnCode", noStatusReturnCode);
            return this;
        }
        /**
         * Sets the path to the generated output file.
         * 
         * The option is a: <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder output(File output) {
            doSetProperty("output", output);
            return this;
        }
        /**
         * Sets the path to the generated output file.
         * 
         * The option will be converted to a <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder output(String output) {
            doSetProperty("output", output);
            return this;
        }
        /**
         * Configures where generated reports are to be placed.
         * 
         * The option is a: <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder outputDirectory(
                File outputDirectory) {
            doSetProperty("outputDirectory", outputDirectory);
            return this;
        }
        /**
         * Configures where generated reports are to be placed.
         * 
         * The option will be converted to a <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder outputDirectory(
                String outputDirectory) {
            doSetProperty("outputDirectory", outputDirectory);
            return this;
        }
        /**
         * Sets the test execution order to be randomized. Valid values are all,
         * suite, and test.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder randomize(String randomize) {
            doSetProperty("randomize", randomize);
            return this;
        }
        /**
         * Sets the path to the generated report file.
         * 
         * The option is a: <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder report(File report) {
            doSetProperty("report", report);
            return this;
        }
        /**
         * Sets the path to the generated report file.
         * 
         * The option will be converted to a <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder report(String report) {
            doSetProperty("report", report);
            return this;
        }
        /**
         * Sets background colors for the generated report and summary.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder reportBackground(
                String reportBackground) {
            doSetProperty("reportBackground", reportBackground);
            return this;
        }
        /**
         * Sets a title for the generated tests report.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder reportTitle(String reportTitle) {
            doSetProperty("reportTitle", reportTitle);
            return this;
        }
        /**
         * Executes tests also if the top level test suite is empty. Useful e.g.
         * with --include/--exclude when it is not an error that no test matches
         * the condition.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder runEmptySuite(
                boolean runEmptySuite) {
            doSetProperty("runEmptySuite", runEmptySuite);
            return this;
        }
        /**
         * Executes tests also if the top level test suite is empty. Useful e.g.
         * with --include/--exclude when it is not an error that no test matches
         * the condition.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder runEmptySuite(String runEmptySuite) {
            doSetProperty("runEmptySuite", runEmptySuite);
            return this;
        }
        /**
         * Re-run failed tests, based on output.xml file.
         * 
         * The option is a: <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder runFailed(File runFailed) {
            doSetProperty("runFailed", runFailed);
            return this;
        }
        /**
         * Re-run failed tests, based on output.xml file.
         * 
         * The option will be converted to a <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder runFailed(String runFailed) {
            doSetProperty("runFailed", runFailed);
            return this;
        }
        /**
         * Sets the execution mode for this tests run. Note that this setting
         * has been deprecated in Robot Framework 2.8. Use separate dryryn,
         * skipTeardownOnExit, exitOnFailure, and randomize settings instead.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder runMode(String runMode) {
            doSetProperty("runMode", runMode);
            return this;
        }
        /**
         * Sets whether the teardowns are skipped if the test execution is
         * prematurely stopped.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder skipTeardownOnExit(
                boolean skipTeardownOnExit) {
            doSetProperty("skipTeardownOnExit", skipTeardownOnExit);
            return this;
        }
        /**
         * Sets whether the teardowns are skipped if the test execution is
         * prematurely stopped.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder skipTeardownOnExit(
                String skipTeardownOnExit) {
            doSetProperty("skipTeardownOnExit", skipTeardownOnExit);
            return this;
        }
        /**
         * Splits output and log files.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder splitOutputs(String splitOutputs) {
            doSetProperty("splitOutputs", splitOutputs);
            return this;
        }
        /**
         * Selects the tests suites by name. List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder suites(String suites) {
            doSetProperty("suites", suites);
            return this;
        }
        /**
         * Defines how many levels to show in the Statistics by Suite table in
         * outputs.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder suiteStatLevel(
                String suiteStatLevel) {
            doSetProperty("suiteStatLevel", suiteStatLevel);
            return this;
        }
        /**
         * Sets a title for the generated summary report.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder summaryTitle(String summaryTitle) {
            doSetProperty("summaryTitle", summaryTitle);
            return this;
        }
        /**
         * Adds documentation to the specified tags. List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder tagDocs(String tagDocs) {
            doSetProperty("tagDocs", tagDocs);
            return this;
        }
        /**
         * Sets the tags(s) to all executed tests cases. List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder tags(String tags) {
            doSetProperty("tags", tags);
            return this;
        }
        /**
         * Excludes these tags from the Statistics by Tag and Test Details by
         * Tag tables in outputs. List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder tagStatExcludes(
                String tagStatExcludes) {
            doSetProperty("tagStatExcludes", tagStatExcludes);
            return this;
        }
        /**
         * Includes only these tags in the Statistics by Tag and Test Details by
         * Tag tables in outputs. List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder tagStatIncludes(
                String tagStatIncludes) {
            doSetProperty("tagStatIncludes", tagStatIncludes);
            return this;
        }
        /**
         * Adds external links to the Statistics by Tag table in outputs. Use
         * the format pattern:link:title List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder tagStatLinks(String tagStatLinks) {
            doSetProperty("tagStatLinks", tagStatLinks);
            return this;
        }
        /**
         * Selects the tests cases by name. List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder tests(String tests) {
            doSetProperty("tests", tests);
            return this;
        }
        /**
         * Adds a timestamp to all output files.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder timestampOutputs(
                boolean timestampOutputs) {
            doSetProperty("timestampOutputs", timestampOutputs);
            return this;
        }
        /**
         * Adds a timestamp to all output files.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder timestampOutputs(
                String timestampOutputs) {
            doSetProperty("timestampOutputs", timestampOutputs);
            return this;
        }
        /**
         * Sets variables using variables files. Use the format path:args List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder variableFiles(String variableFiles) {
            doSetProperty("variableFiles", variableFiles);
            return this;
        }
        /**
         * Sets individual variables. Use the format name:value List.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder variables(String variables) {
            doSetProperty("variables", variables);
            return this;
        }
        /**
         * Show a warning when an invalid file is skipped.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder warnOnSkippedFiles(
                boolean warnOnSkippedFiles) {
            doSetProperty("warnOnSkippedFiles", warnOnSkippedFiles);
            return this;
        }
        /**
         * Show a warning when an invalid file is skipped.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder warnOnSkippedFiles(
                String warnOnSkippedFiles) {
            doSetProperty("warnOnSkippedFiles", warnOnSkippedFiles);
            return this;
        }
        /**
         * Sets the path to the generated XUnit compatible result file, relative
         * to outputDirectory. The file is in xml format. By default, the file
         * name is derived from the testCasesDirectory parameter, replacing
         * blanks in the directory name by underscores.
         * 
         * The option is a: <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder xunitFile(File xunitFile) {
            doSetProperty("xunitFile", xunitFile);
            return this;
        }
        /**
         * Sets the path to the generated XUnit compatible result file, relative
         * to outputDirectory. The file is in xml format. By default, the file
         * name is derived from the testCasesDirectory parameter, replacing
         * blanks in the directory name by underscores.
         * 
         * The option will be converted to a <code>java.io.File</code> type.
         * 
         * Group: common
         */
        default RobotFrameworkEndpointBuilder xunitFile(String xunitFile) {
            doSetProperty("xunitFile", xunitFile);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Robot Framework component.
     */
    public interface AdvancedRobotFrameworkEndpointBuilder
            extends
                AdvancedRobotFrameworkEndpointConsumerBuilder, AdvancedRobotFrameworkEndpointProducerBuilder {
        default RobotFrameworkEndpointBuilder basic() {
            return (RobotFrameworkEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRobotFrameworkEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRobotFrameworkEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRobotFrameworkEndpointBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRobotFrameworkEndpointBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }
    /**
     * Robot Framework (camel-robotframework)
     * Represents a RobotFramework endpoint.
     * 
     * Category: testing
     * Available as of version: 3.0
     * Maven coordinates: org.apache.camel:camel-robotframework
     * 
     * Syntax: <code>robotframework:resourceUri</code>
     * 
     * Path parameter: resourceUri (required)
     * Path to the resource. You can prefix with: classpath, file, http, ref, or
     * bean. classpath, file and http loads the resource using these protocols
     * (classpath is default). ref will lookup the resource in the registry.
     * bean will call a method on a bean to be used as the resource. For bean
     * you can specify the method name after dot, eg bean:myBean.myMethod.
     */
    default RobotFrameworkEndpointBuilder robotframework(String path) {
        class RobotFrameworkEndpointBuilderImpl extends AbstractEndpointBuilder implements RobotFrameworkEndpointBuilder, AdvancedRobotFrameworkEndpointBuilder {
            public RobotFrameworkEndpointBuilderImpl(String path) {
                super("robotframework", path);
            }
        }
        return new RobotFrameworkEndpointBuilderImpl(path);
    }
}