/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * Provides functionality required by Healthcare providers to communicate with
 * other systems using the MLLP protocol.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface MllpEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the MLLP component.
     */
    public interface MllpEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedMllpEndpointConsumerBuilder advanced() {
            return (AdvancedMllpEndpointConsumerBuilder) this;
        }
        /**
         * Enable/Disable the automatic generation of a MLLP Acknowledgement
         * MLLP Consumers only.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default MllpEndpointConsumerBuilder autoAck(boolean autoAck) {
            doSetProperty("autoAck", autoAck);
            return this;
        }
        /**
         * Enable/Disable the automatic generation of a MLLP Acknowledgement
         * MLLP Consumers only.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default MllpEndpointConsumerBuilder autoAck(String autoAck) {
            doSetProperty("autoAck", autoAck);
            return this;
        }
        /**
         * Enable/Disable the buffering of HL7 payloads before writing to the
         * socket.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        @Deprecated
        default MllpEndpointConsumerBuilder bufferWrites(boolean bufferWrites) {
            doSetProperty("bufferWrites", bufferWrites);
            return this;
        }
        /**
         * Enable/Disable the buffering of HL7 payloads before writing to the
         * socket.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        @Deprecated
        default MllpEndpointConsumerBuilder bufferWrites(String bufferWrites) {
            doSetProperty("bufferWrites", bufferWrites);
            return this;
        }
        /**
         * Enable/Disable the automatic generation of message headers from the
         * HL7 Message MLLP Consumers only.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default MllpEndpointConsumerBuilder hl7Headers(boolean hl7Headers) {
            doSetProperty("hl7Headers", hl7Headers);
            return this;
        }
        /**
         * Enable/Disable the automatic generation of message headers from the
         * HL7 Message MLLP Consumers only.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default MllpEndpointConsumerBuilder hl7Headers(String hl7Headers) {
            doSetProperty("hl7Headers", hl7Headers);
            return this;
        }
        /**
         * Enable/Disable strict compliance to the MLLP standard. The MLLP
         * standard specifies START_OF_BLOCKhl7 payloadEND_OF_BLOCKEND_OF_DATA,
         * however, some systems do not send the final END_OF_DATA byte. This
         * setting controls whether or not the final END_OF_DATA byte is
         * required or optional.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default MllpEndpointConsumerBuilder requireEndOfData(
                boolean requireEndOfData) {
            doSetProperty("requireEndOfData", requireEndOfData);
            return this;
        }
        /**
         * Enable/Disable strict compliance to the MLLP standard. The MLLP
         * standard specifies START_OF_BLOCKhl7 payloadEND_OF_BLOCKEND_OF_DATA,
         * however, some systems do not send the final END_OF_DATA byte. This
         * setting controls whether or not the final END_OF_DATA byte is
         * required or optional.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default MllpEndpointConsumerBuilder requireEndOfData(
                String requireEndOfData) {
            doSetProperty("requireEndOfData", requireEndOfData);
            return this;
        }
        /**
         * Enable/Disable converting the payload to a String. If enabled, HL7
         * Payloads received from external systems will be validated converted
         * to a String. If the charsetName property is set, that character set
         * will be used for the conversion. If the charsetName property is not
         * set, the value of MSH-18 will be used to determine th appropriate
         * character set. If MSH-18 is not set, then the default ISO-8859-1
         * character set will be use.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default MllpEndpointConsumerBuilder stringPayload(boolean stringPayload) {
            doSetProperty("stringPayload", stringPayload);
            return this;
        }
        /**
         * Enable/Disable converting the payload to a String. If enabled, HL7
         * Payloads received from external systems will be validated converted
         * to a String. If the charsetName property is set, that character set
         * will be used for the conversion. If the charsetName property is not
         * set, the value of MSH-18 will be used to determine th appropriate
         * character set. If MSH-18 is not set, then the default ISO-8859-1
         * character set will be use.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default MllpEndpointConsumerBuilder stringPayload(String stringPayload) {
            doSetProperty("stringPayload", stringPayload);
            return this;
        }
        /**
         * Enable/Disable the validation of HL7 Payloads If enabled, HL7
         * Payloads received from external systems will be validated (see
         * Hl7Util.generateInvalidPayloadExceptionMessage for details on the
         * validation). If and invalid payload is detected, a
         * MllpInvalidMessageException (for consumers) or a
         * MllpInvalidAcknowledgementException will be thrown.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default MllpEndpointConsumerBuilder validatePayload(
                boolean validatePayload) {
            doSetProperty("validatePayload", validatePayload);
            return this;
        }
        /**
         * Enable/Disable the validation of HL7 Payloads If enabled, HL7
         * Payloads received from external systems will be validated (see
         * Hl7Util.generateInvalidPayloadExceptionMessage for details on the
         * validation). If and invalid payload is detected, a
         * MllpInvalidMessageException (for consumers) or a
         * MllpInvalidAcknowledgementException will be thrown.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default MllpEndpointConsumerBuilder validatePayload(
                String validatePayload) {
            doSetProperty("validatePayload", validatePayload);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * receive incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. If disabled, the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions by logging them at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default MllpEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * receive incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. If disabled, the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions by logging them at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default MllpEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Set the CamelCharsetName property on the exchange.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: codec
         */
        default MllpEndpointConsumerBuilder charsetName(String charsetName) {
            doSetProperty("charsetName", charsetName);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the MLLP component.
     */
    public interface AdvancedMllpEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default MllpEndpointConsumerBuilder basic() {
            return (MllpEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedMllpEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedMllpEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedMllpEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedMllpEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMllpEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMllpEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used (this
         * component only supports synchronous operations).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMllpEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used (this
         * component only supports synchronous operations).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMllpEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * The maximum queue length for incoming connection indications (a
         * request to connect) is set to the backlog parameter. If a connection
         * indication arrives when the queue is full, the connection is refused.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: tcp
         */
        default AdvancedMllpEndpointConsumerBuilder backlog(Integer backlog) {
            doSetProperty("backlog", backlog);
            return this;
        }
        /**
         * The maximum queue length for incoming connection indications (a
         * request to connect) is set to the backlog parameter. If a connection
         * indication arrives when the queue is full, the connection is refused.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: tcp
         */
        default AdvancedMllpEndpointConsumerBuilder backlog(String backlog) {
            doSetProperty("backlog", backlog);
            return this;
        }
        /**
         * TCP Server Only - Allow the endpoint to start before the TCP
         * ServerSocket is bound. In some environments, it may be desirable to
         * allow the endpoint to start before the TCP ServerSocket is bound.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: tcp
         */
        default AdvancedMllpEndpointConsumerBuilder lenientBind(
                boolean lenientBind) {
            doSetProperty("lenientBind", lenientBind);
            return this;
        }
        /**
         * TCP Server Only - Allow the endpoint to start before the TCP
         * ServerSocket is bound. In some environments, it may be desirable to
         * allow the endpoint to start before the TCP ServerSocket is bound.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: tcp
         */
        default AdvancedMllpEndpointConsumerBuilder lenientBind(
                String lenientBind) {
            doSetProperty("lenientBind", lenientBind);
            return this;
        }
        /**
         * The maximum number of concurrent MLLP Consumer connections that will
         * be allowed. If a new connection is received and the maximum is number
         * are already established, the new connection will be reset
         * immediately.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: tcp
         */
        default AdvancedMllpEndpointConsumerBuilder maxConcurrentConsumers(
                int maxConcurrentConsumers) {
            doSetProperty("maxConcurrentConsumers", maxConcurrentConsumers);
            return this;
        }
        /**
         * The maximum number of concurrent MLLP Consumer connections that will
         * be allowed. If a new connection is received and the maximum is number
         * are already established, the new connection will be reset
         * immediately.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: tcp
         */
        default AdvancedMllpEndpointConsumerBuilder maxConcurrentConsumers(
                String maxConcurrentConsumers) {
            doSetProperty("maxConcurrentConsumers", maxConcurrentConsumers);
            return this;
        }
        /**
         * Enable/disable the SO_REUSEADDR socket option.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: tcp
         */
        default AdvancedMllpEndpointConsumerBuilder reuseAddress(
                Boolean reuseAddress) {
            doSetProperty("reuseAddress", reuseAddress);
            return this;
        }
        /**
         * Enable/disable the SO_REUSEADDR socket option.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: tcp
         */
        default AdvancedMllpEndpointConsumerBuilder reuseAddress(
                String reuseAddress) {
            doSetProperty("reuseAddress", reuseAddress);
            return this;
        }
        /**
         * Timeout (in milliseconds) while waiting for a TCP connection TCP
         * Server Only.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: timeout
         */
        default AdvancedMllpEndpointConsumerBuilder acceptTimeout(
                int acceptTimeout) {
            doSetProperty("acceptTimeout", acceptTimeout);
            return this;
        }
        /**
         * Timeout (in milliseconds) while waiting for a TCP connection TCP
         * Server Only.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: timeout
         */
        default AdvancedMllpEndpointConsumerBuilder acceptTimeout(
                String acceptTimeout) {
            doSetProperty("acceptTimeout", acceptTimeout);
            return this;
        }
        /**
         * TCP Server Only - The number of milliseconds to wait between bind
         * attempts.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: timeout
         */
        default AdvancedMllpEndpointConsumerBuilder bindRetryInterval(
                int bindRetryInterval) {
            doSetProperty("bindRetryInterval", bindRetryInterval);
            return this;
        }
        /**
         * TCP Server Only - The number of milliseconds to wait between bind
         * attempts.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: timeout
         */
        default AdvancedMllpEndpointConsumerBuilder bindRetryInterval(
                String bindRetryInterval) {
            doSetProperty("bindRetryInterval", bindRetryInterval);
            return this;
        }
        /**
         * TCP Server Only - The number of milliseconds to retry binding to a
         * server port.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: timeout
         */
        default AdvancedMllpEndpointConsumerBuilder bindTimeout(int bindTimeout) {
            doSetProperty("bindTimeout", bindTimeout);
            return this;
        }
        /**
         * TCP Server Only - The number of milliseconds to retry binding to a
         * server port.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: timeout
         */
        default AdvancedMllpEndpointConsumerBuilder bindTimeout(
                String bindTimeout) {
            doSetProperty("bindTimeout", bindTimeout);
            return this;
        }
        /**
         * The approximate idle time allowed before the Client TCP Connection
         * will be reset. A null value or a value less than or equal to zero
         * will disable the idle timeout.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: timeout
         */
        default AdvancedMllpEndpointConsumerBuilder idleTimeout(
                Integer idleTimeout) {
            doSetProperty("idleTimeout", idleTimeout);
            return this;
        }
        /**
         * The approximate idle time allowed before the Client TCP Connection
         * will be reset. A null value or a value less than or equal to zero
         * will disable the idle timeout.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: timeout
         */
        default AdvancedMllpEndpointConsumerBuilder idleTimeout(
                String idleTimeout) {
            doSetProperty("idleTimeout", idleTimeout);
            return this;
        }
        /**
         * The maximum number of timeouts (specified by receiveTimeout) allowed
         * before the TCP Connection will be reset.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: timeout
         */
        @Deprecated
        default AdvancedMllpEndpointConsumerBuilder maxReceiveTimeouts(
                Integer maxReceiveTimeouts) {
            doSetProperty("maxReceiveTimeouts", maxReceiveTimeouts);
            return this;
        }
        /**
         * The maximum number of timeouts (specified by receiveTimeout) allowed
         * before the TCP Connection will be reset.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: timeout
         */
        @Deprecated
        default AdvancedMllpEndpointConsumerBuilder maxReceiveTimeouts(
                String maxReceiveTimeouts) {
            doSetProperty("maxReceiveTimeouts", maxReceiveTimeouts);
            return this;
        }
        /**
         * Sets the SO_RCVBUF option to the specified value (in bytes).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: tcp
         */
        default AdvancedMllpEndpointConsumerBuilder receiveBufferSize(
                Integer receiveBufferSize) {
            doSetProperty("receiveBufferSize", receiveBufferSize);
            return this;
        }
        /**
         * Sets the SO_RCVBUF option to the specified value (in bytes).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: tcp
         */
        default AdvancedMllpEndpointConsumerBuilder receiveBufferSize(
                String receiveBufferSize) {
            doSetProperty("receiveBufferSize", receiveBufferSize);
            return this;
        }
        /**
         * Sets the SO_SNDBUF option to the specified value (in bytes).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: tcp
         */
        default AdvancedMllpEndpointConsumerBuilder sendBufferSize(
                Integer sendBufferSize) {
            doSetProperty("sendBufferSize", sendBufferSize);
            return this;
        }
        /**
         * Sets the SO_SNDBUF option to the specified value (in bytes).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: tcp
         */
        default AdvancedMllpEndpointConsumerBuilder sendBufferSize(
                String sendBufferSize) {
            doSetProperty("sendBufferSize", sendBufferSize);
            return this;
        }
        /**
         * The SO_TIMEOUT value (in milliseconds) used after the start of an
         * MLLP frame has been received.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: timeout
         */
        default AdvancedMllpEndpointConsumerBuilder readTimeout(int readTimeout) {
            doSetProperty("readTimeout", readTimeout);
            return this;
        }
        /**
         * The SO_TIMEOUT value (in milliseconds) used after the start of an
         * MLLP frame has been received.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: timeout
         */
        default AdvancedMllpEndpointConsumerBuilder readTimeout(
                String readTimeout) {
            doSetProperty("readTimeout", readTimeout);
            return this;
        }
        /**
         * The SO_TIMEOUT value (in milliseconds) used when waiting for the
         * start of an MLLP frame.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: timeout
         */
        default AdvancedMllpEndpointConsumerBuilder receiveTimeout(
                int receiveTimeout) {
            doSetProperty("receiveTimeout", receiveTimeout);
            return this;
        }
        /**
         * The SO_TIMEOUT value (in milliseconds) used when waiting for the
         * start of an MLLP frame.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: timeout
         */
        default AdvancedMllpEndpointConsumerBuilder receiveTimeout(
                String receiveTimeout) {
            doSetProperty("receiveTimeout", receiveTimeout);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the MLLP component.
     */
    public interface MllpEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedMllpEndpointProducerBuilder advanced() {
            return (AdvancedMllpEndpointProducerBuilder) this;
        }
        /**
         * Enable/Disable the automatic generation of a MLLP Acknowledgement
         * MLLP Consumers only.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default MllpEndpointProducerBuilder autoAck(boolean autoAck) {
            doSetProperty("autoAck", autoAck);
            return this;
        }
        /**
         * Enable/Disable the automatic generation of a MLLP Acknowledgement
         * MLLP Consumers only.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default MllpEndpointProducerBuilder autoAck(String autoAck) {
            doSetProperty("autoAck", autoAck);
            return this;
        }
        /**
         * Enable/Disable the buffering of HL7 payloads before writing to the
         * socket.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        @Deprecated
        default MllpEndpointProducerBuilder bufferWrites(boolean bufferWrites) {
            doSetProperty("bufferWrites", bufferWrites);
            return this;
        }
        /**
         * Enable/Disable the buffering of HL7 payloads before writing to the
         * socket.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        @Deprecated
        default MllpEndpointProducerBuilder bufferWrites(String bufferWrites) {
            doSetProperty("bufferWrites", bufferWrites);
            return this;
        }
        /**
         * Enable/Disable the automatic generation of message headers from the
         * HL7 Message MLLP Consumers only.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default MllpEndpointProducerBuilder hl7Headers(boolean hl7Headers) {
            doSetProperty("hl7Headers", hl7Headers);
            return this;
        }
        /**
         * Enable/Disable the automatic generation of message headers from the
         * HL7 Message MLLP Consumers only.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default MllpEndpointProducerBuilder hl7Headers(String hl7Headers) {
            doSetProperty("hl7Headers", hl7Headers);
            return this;
        }
        /**
         * Enable/Disable strict compliance to the MLLP standard. The MLLP
         * standard specifies START_OF_BLOCKhl7 payloadEND_OF_BLOCKEND_OF_DATA,
         * however, some systems do not send the final END_OF_DATA byte. This
         * setting controls whether or not the final END_OF_DATA byte is
         * required or optional.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default MllpEndpointProducerBuilder requireEndOfData(
                boolean requireEndOfData) {
            doSetProperty("requireEndOfData", requireEndOfData);
            return this;
        }
        /**
         * Enable/Disable strict compliance to the MLLP standard. The MLLP
         * standard specifies START_OF_BLOCKhl7 payloadEND_OF_BLOCKEND_OF_DATA,
         * however, some systems do not send the final END_OF_DATA byte. This
         * setting controls whether or not the final END_OF_DATA byte is
         * required or optional.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default MllpEndpointProducerBuilder requireEndOfData(
                String requireEndOfData) {
            doSetProperty("requireEndOfData", requireEndOfData);
            return this;
        }
        /**
         * Enable/Disable converting the payload to a String. If enabled, HL7
         * Payloads received from external systems will be validated converted
         * to a String. If the charsetName property is set, that character set
         * will be used for the conversion. If the charsetName property is not
         * set, the value of MSH-18 will be used to determine th appropriate
         * character set. If MSH-18 is not set, then the default ISO-8859-1
         * character set will be use.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default MllpEndpointProducerBuilder stringPayload(boolean stringPayload) {
            doSetProperty("stringPayload", stringPayload);
            return this;
        }
        /**
         * Enable/Disable converting the payload to a String. If enabled, HL7
         * Payloads received from external systems will be validated converted
         * to a String. If the charsetName property is set, that character set
         * will be used for the conversion. If the charsetName property is not
         * set, the value of MSH-18 will be used to determine th appropriate
         * character set. If MSH-18 is not set, then the default ISO-8859-1
         * character set will be use.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default MllpEndpointProducerBuilder stringPayload(String stringPayload) {
            doSetProperty("stringPayload", stringPayload);
            return this;
        }
        /**
         * Enable/Disable the validation of HL7 Payloads If enabled, HL7
         * Payloads received from external systems will be validated (see
         * Hl7Util.generateInvalidPayloadExceptionMessage for details on the
         * validation). If and invalid payload is detected, a
         * MllpInvalidMessageException (for consumers) or a
         * MllpInvalidAcknowledgementException will be thrown.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default MllpEndpointProducerBuilder validatePayload(
                boolean validatePayload) {
            doSetProperty("validatePayload", validatePayload);
            return this;
        }
        /**
         * Enable/Disable the validation of HL7 Payloads If enabled, HL7
         * Payloads received from external systems will be validated (see
         * Hl7Util.generateInvalidPayloadExceptionMessage for details on the
         * validation). If and invalid payload is detected, a
         * MllpInvalidMessageException (for consumers) or a
         * MllpInvalidAcknowledgementException will be thrown.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default MllpEndpointProducerBuilder validatePayload(
                String validatePayload) {
            doSetProperty("validatePayload", validatePayload);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default MllpEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default MllpEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Set the CamelCharsetName property on the exchange.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: codec
         */
        default MllpEndpointProducerBuilder charsetName(String charsetName) {
            doSetProperty("charsetName", charsetName);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the MLLP component.
     */
    public interface AdvancedMllpEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default MllpEndpointProducerBuilder basic() {
            return (MllpEndpointProducerBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMllpEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMllpEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used (this
         * component only supports synchronous operations).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMllpEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used (this
         * component only supports synchronous operations).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMllpEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Timeout (in milliseconds) for establishing for a TCP connection TCP
         * Client only.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: timeout
         */
        default AdvancedMllpEndpointProducerBuilder connectTimeout(
                int connectTimeout) {
            doSetProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * Timeout (in milliseconds) for establishing for a TCP connection TCP
         * Client only.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: timeout
         */
        default AdvancedMllpEndpointProducerBuilder connectTimeout(
                String connectTimeout) {
            doSetProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * The approximate idle time allowed before the Client TCP Connection
         * will be reset. A null value or a value less than or equal to zero
         * will disable the idle timeout.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: timeout
         */
        default AdvancedMllpEndpointProducerBuilder idleTimeout(
                Integer idleTimeout) {
            doSetProperty("idleTimeout", idleTimeout);
            return this;
        }
        /**
         * The approximate idle time allowed before the Client TCP Connection
         * will be reset. A null value or a value less than or equal to zero
         * will disable the idle timeout.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: timeout
         */
        default AdvancedMllpEndpointProducerBuilder idleTimeout(
                String idleTimeout) {
            doSetProperty("idleTimeout", idleTimeout);
            return this;
        }
        /**
         * Enable/disable the SO_KEEPALIVE socket option.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: tcp
         */
        default AdvancedMllpEndpointProducerBuilder keepAlive(Boolean keepAlive) {
            doSetProperty("keepAlive", keepAlive);
            return this;
        }
        /**
         * Enable/disable the SO_KEEPALIVE socket option.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: tcp
         */
        default AdvancedMllpEndpointProducerBuilder keepAlive(String keepAlive) {
            doSetProperty("keepAlive", keepAlive);
            return this;
        }
        /**
         * Sets the SO_RCVBUF option to the specified value (in bytes).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: tcp
         */
        default AdvancedMllpEndpointProducerBuilder receiveBufferSize(
                Integer receiveBufferSize) {
            doSetProperty("receiveBufferSize", receiveBufferSize);
            return this;
        }
        /**
         * Sets the SO_RCVBUF option to the specified value (in bytes).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: tcp
         */
        default AdvancedMllpEndpointProducerBuilder receiveBufferSize(
                String receiveBufferSize) {
            doSetProperty("receiveBufferSize", receiveBufferSize);
            return this;
        }
        /**
         * Sets the SO_SNDBUF option to the specified value (in bytes).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: tcp
         */
        default AdvancedMllpEndpointProducerBuilder sendBufferSize(
                Integer sendBufferSize) {
            doSetProperty("sendBufferSize", sendBufferSize);
            return this;
        }
        /**
         * Sets the SO_SNDBUF option to the specified value (in bytes).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: tcp
         */
        default AdvancedMllpEndpointProducerBuilder sendBufferSize(
                String sendBufferSize) {
            doSetProperty("sendBufferSize", sendBufferSize);
            return this;
        }
        /**
         * Enable/disable the TCP_NODELAY socket option.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: tcp
         */
        default AdvancedMllpEndpointProducerBuilder tcpNoDelay(
                Boolean tcpNoDelay) {
            doSetProperty("tcpNoDelay", tcpNoDelay);
            return this;
        }
        /**
         * Enable/disable the TCP_NODELAY socket option.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: tcp
         */
        default AdvancedMllpEndpointProducerBuilder tcpNoDelay(String tcpNoDelay) {
            doSetProperty("tcpNoDelay", tcpNoDelay);
            return this;
        }
        /**
         * The SO_TIMEOUT value (in milliseconds) used after the start of an
         * MLLP frame has been received.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: timeout
         */
        default AdvancedMllpEndpointProducerBuilder readTimeout(int readTimeout) {
            doSetProperty("readTimeout", readTimeout);
            return this;
        }
        /**
         * The SO_TIMEOUT value (in milliseconds) used after the start of an
         * MLLP frame has been received.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: timeout
         */
        default AdvancedMllpEndpointProducerBuilder readTimeout(
                String readTimeout) {
            doSetProperty("readTimeout", readTimeout);
            return this;
        }
        /**
         * The SO_TIMEOUT value (in milliseconds) used when waiting for the
         * start of an MLLP frame.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: timeout
         */
        default AdvancedMllpEndpointProducerBuilder receiveTimeout(
                int receiveTimeout) {
            doSetProperty("receiveTimeout", receiveTimeout);
            return this;
        }
        /**
         * The SO_TIMEOUT value (in milliseconds) used when waiting for the
         * start of an MLLP frame.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: timeout
         */
        default AdvancedMllpEndpointProducerBuilder receiveTimeout(
                String receiveTimeout) {
            doSetProperty("receiveTimeout", receiveTimeout);
            return this;
        }
    }

    /**
     * Builder for endpoint for the MLLP component.
     */
    public interface MllpEndpointBuilder
            extends
                MllpEndpointConsumerBuilder, MllpEndpointProducerBuilder {
        default AdvancedMllpEndpointBuilder advanced() {
            return (AdvancedMllpEndpointBuilder) this;
        }
        /**
         * Enable/Disable the automatic generation of a MLLP Acknowledgement
         * MLLP Consumers only.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default MllpEndpointBuilder autoAck(boolean autoAck) {
            doSetProperty("autoAck", autoAck);
            return this;
        }
        /**
         * Enable/Disable the automatic generation of a MLLP Acknowledgement
         * MLLP Consumers only.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default MllpEndpointBuilder autoAck(String autoAck) {
            doSetProperty("autoAck", autoAck);
            return this;
        }
        /**
         * Enable/Disable the buffering of HL7 payloads before writing to the
         * socket.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        @Deprecated
        default MllpEndpointBuilder bufferWrites(boolean bufferWrites) {
            doSetProperty("bufferWrites", bufferWrites);
            return this;
        }
        /**
         * Enable/Disable the buffering of HL7 payloads before writing to the
         * socket.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        @Deprecated
        default MllpEndpointBuilder bufferWrites(String bufferWrites) {
            doSetProperty("bufferWrites", bufferWrites);
            return this;
        }
        /**
         * Enable/Disable the automatic generation of message headers from the
         * HL7 Message MLLP Consumers only.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default MllpEndpointBuilder hl7Headers(boolean hl7Headers) {
            doSetProperty("hl7Headers", hl7Headers);
            return this;
        }
        /**
         * Enable/Disable the automatic generation of message headers from the
         * HL7 Message MLLP Consumers only.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default MllpEndpointBuilder hl7Headers(String hl7Headers) {
            doSetProperty("hl7Headers", hl7Headers);
            return this;
        }
        /**
         * Enable/Disable strict compliance to the MLLP standard. The MLLP
         * standard specifies START_OF_BLOCKhl7 payloadEND_OF_BLOCKEND_OF_DATA,
         * however, some systems do not send the final END_OF_DATA byte. This
         * setting controls whether or not the final END_OF_DATA byte is
         * required or optional.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default MllpEndpointBuilder requireEndOfData(boolean requireEndOfData) {
            doSetProperty("requireEndOfData", requireEndOfData);
            return this;
        }
        /**
         * Enable/Disable strict compliance to the MLLP standard. The MLLP
         * standard specifies START_OF_BLOCKhl7 payloadEND_OF_BLOCKEND_OF_DATA,
         * however, some systems do not send the final END_OF_DATA byte. This
         * setting controls whether or not the final END_OF_DATA byte is
         * required or optional.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default MllpEndpointBuilder requireEndOfData(String requireEndOfData) {
            doSetProperty("requireEndOfData", requireEndOfData);
            return this;
        }
        /**
         * Enable/Disable converting the payload to a String. If enabled, HL7
         * Payloads received from external systems will be validated converted
         * to a String. If the charsetName property is set, that character set
         * will be used for the conversion. If the charsetName property is not
         * set, the value of MSH-18 will be used to determine th appropriate
         * character set. If MSH-18 is not set, then the default ISO-8859-1
         * character set will be use.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default MllpEndpointBuilder stringPayload(boolean stringPayload) {
            doSetProperty("stringPayload", stringPayload);
            return this;
        }
        /**
         * Enable/Disable converting the payload to a String. If enabled, HL7
         * Payloads received from external systems will be validated converted
         * to a String. If the charsetName property is set, that character set
         * will be used for the conversion. If the charsetName property is not
         * set, the value of MSH-18 will be used to determine th appropriate
         * character set. If MSH-18 is not set, then the default ISO-8859-1
         * character set will be use.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default MllpEndpointBuilder stringPayload(String stringPayload) {
            doSetProperty("stringPayload", stringPayload);
            return this;
        }
        /**
         * Enable/Disable the validation of HL7 Payloads If enabled, HL7
         * Payloads received from external systems will be validated (see
         * Hl7Util.generateInvalidPayloadExceptionMessage for details on the
         * validation). If and invalid payload is detected, a
         * MllpInvalidMessageException (for consumers) or a
         * MllpInvalidAcknowledgementException will be thrown.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default MllpEndpointBuilder validatePayload(boolean validatePayload) {
            doSetProperty("validatePayload", validatePayload);
            return this;
        }
        /**
         * Enable/Disable the validation of HL7 Payloads If enabled, HL7
         * Payloads received from external systems will be validated (see
         * Hl7Util.generateInvalidPayloadExceptionMessage for details on the
         * validation). If and invalid payload is detected, a
         * MllpInvalidMessageException (for consumers) or a
         * MllpInvalidAcknowledgementException will be thrown.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default MllpEndpointBuilder validatePayload(String validatePayload) {
            doSetProperty("validatePayload", validatePayload);
            return this;
        }
        /**
         * Set the CamelCharsetName property on the exchange.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: codec
         */
        default MllpEndpointBuilder charsetName(String charsetName) {
            doSetProperty("charsetName", charsetName);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the MLLP component.
     */
    public interface AdvancedMllpEndpointBuilder
            extends
                AdvancedMllpEndpointConsumerBuilder, AdvancedMllpEndpointProducerBuilder {
        default MllpEndpointBuilder basic() {
            return (MllpEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMllpEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMllpEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used (this
         * component only supports synchronous operations).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMllpEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used (this
         * component only supports synchronous operations).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMllpEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * The approximate idle time allowed before the Client TCP Connection
         * will be reset. A null value or a value less than or equal to zero
         * will disable the idle timeout.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: timeout
         */
        default AdvancedMllpEndpointBuilder idleTimeout(Integer idleTimeout) {
            doSetProperty("idleTimeout", idleTimeout);
            return this;
        }
        /**
         * The approximate idle time allowed before the Client TCP Connection
         * will be reset. A null value or a value less than or equal to zero
         * will disable the idle timeout.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: timeout
         */
        default AdvancedMllpEndpointBuilder idleTimeout(String idleTimeout) {
            doSetProperty("idleTimeout", idleTimeout);
            return this;
        }
        /**
         * Sets the SO_RCVBUF option to the specified value (in bytes).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: tcp
         */
        default AdvancedMllpEndpointBuilder receiveBufferSize(
                Integer receiveBufferSize) {
            doSetProperty("receiveBufferSize", receiveBufferSize);
            return this;
        }
        /**
         * Sets the SO_RCVBUF option to the specified value (in bytes).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: tcp
         */
        default AdvancedMllpEndpointBuilder receiveBufferSize(
                String receiveBufferSize) {
            doSetProperty("receiveBufferSize", receiveBufferSize);
            return this;
        }
        /**
         * Sets the SO_SNDBUF option to the specified value (in bytes).
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: tcp
         */
        default AdvancedMllpEndpointBuilder sendBufferSize(
                Integer sendBufferSize) {
            doSetProperty("sendBufferSize", sendBufferSize);
            return this;
        }
        /**
         * Sets the SO_SNDBUF option to the specified value (in bytes).
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: tcp
         */
        default AdvancedMllpEndpointBuilder sendBufferSize(String sendBufferSize) {
            doSetProperty("sendBufferSize", sendBufferSize);
            return this;
        }
        /**
         * The SO_TIMEOUT value (in milliseconds) used after the start of an
         * MLLP frame has been received.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: timeout
         */
        default AdvancedMllpEndpointBuilder readTimeout(int readTimeout) {
            doSetProperty("readTimeout", readTimeout);
            return this;
        }
        /**
         * The SO_TIMEOUT value (in milliseconds) used after the start of an
         * MLLP frame has been received.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: timeout
         */
        default AdvancedMllpEndpointBuilder readTimeout(String readTimeout) {
            doSetProperty("readTimeout", readTimeout);
            return this;
        }
        /**
         * The SO_TIMEOUT value (in milliseconds) used when waiting for the
         * start of an MLLP frame.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: timeout
         */
        default AdvancedMllpEndpointBuilder receiveTimeout(int receiveTimeout) {
            doSetProperty("receiveTimeout", receiveTimeout);
            return this;
        }
        /**
         * The SO_TIMEOUT value (in milliseconds) used when waiting for the
         * start of an MLLP frame.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: timeout
         */
        default AdvancedMllpEndpointBuilder receiveTimeout(String receiveTimeout) {
            doSetProperty("receiveTimeout", receiveTimeout);
            return this;
        }
    }
    /**
     * MLLP (camel-mllp)
     * Provides functionality required by Healthcare providers to communicate
     * with other systems using the MLLP protocol.
     * 
     * Category: mllp
     * Available as of version: 2.17
     * Maven coordinates: org.apache.camel:camel-mllp
     * 
     * Syntax: <code>mllp:hostname:port</code>
     * 
     * Path parameter: hostname (required)
     * Hostname or IP for connection for the TCP connection. The default value
     * is null, which means any local IP address
     * 
     * Path parameter: port (required)
     * Port number for the TCP connection
     */
    default MllpEndpointBuilder mllp(String path) {
        class MllpEndpointBuilderImpl extends AbstractEndpointBuilder implements MllpEndpointBuilder, AdvancedMllpEndpointBuilder {
            public MllpEndpointBuilderImpl(String path) {
                super("mllp", path);
            }
        }
        return new MllpEndpointBuilderImpl(path);
    }
}