/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.net.URI;
import java.util.concurrent.Executor;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * Component for communicating with MQTT M2M message brokers using FuseSource
 * MQTT Client.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface MQTTEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the MQTT component.
     */
    public interface MQTTEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedMQTTEndpointConsumerBuilder advanced() {
            return (AdvancedMQTTEndpointConsumerBuilder) this;
        }
        /**
         * SSL connections perform blocking operations against internal thread
         * pool unless you call the setBlockingExecutor method to configure that
         * executor they will use instead.
         * 
         * The option is a: <code>java.util.concurrent.Executor</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder blockingExecutor(
                Executor blockingExecutor) {
            doSetProperty("blockingExecutor", blockingExecutor);
            return this;
        }
        /**
         * SSL connections perform blocking operations against internal thread
         * pool unless you call the setBlockingExecutor method to configure that
         * executor they will use instead.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.Executor</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder blockingExecutor(
                String blockingExecutor) {
            doSetProperty("blockingExecutor", blockingExecutor);
            return this;
        }
        /**
         * The default retain policy to be used on messages sent to the MQTT
         * broker.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder byDefaultRetain(
                boolean byDefaultRetain) {
            doSetProperty("byDefaultRetain", byDefaultRetain);
            return this;
        }
        /**
         * The default retain policy to be used on messages sent to the MQTT
         * broker.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder byDefaultRetain(
                String byDefaultRetain) {
            doSetProperty("byDefaultRetain", byDefaultRetain);
            return this;
        }
        /**
         * Set to false if you want the MQTT server to persist topic
         * subscriptions and ack positions across client sessions. Defaults to
         * true.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder cleanSession(boolean cleanSession) {
            doSetProperty("cleanSession", cleanSession);
            return this;
        }
        /**
         * Set to false if you want the MQTT server to persist topic
         * subscriptions and ack positions across client sessions. Defaults to
         * true.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder cleanSession(String cleanSession) {
            doSetProperty("cleanSession", cleanSession);
            return this;
        }
        /**
         * Use to set the client Id of the session. This is what an MQTT server
         * uses to identify a session where setCleanSession(false); is being
         * used. The id must be 23 characters or less. Defaults to auto
         * generated id (based on your socket address, port and timestamp).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder clientId(String clientId) {
            doSetProperty("clientId", clientId);
            return this;
        }
        /**
         * The maximum number of reconnect attempts before an error is reported
         * back to the client on the first attempt by the client to connect to a
         * server. Set to -1 to use unlimited attempts. Defaults to -1.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder connectAttemptsMax(
                long connectAttemptsMax) {
            doSetProperty("connectAttemptsMax", connectAttemptsMax);
            return this;
        }
        /**
         * The maximum number of reconnect attempts before an error is reported
         * back to the client on the first attempt by the client to connect to a
         * server. Set to -1 to use unlimited attempts. Defaults to -1.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder connectAttemptsMax(
                String connectAttemptsMax) {
            doSetProperty("connectAttemptsMax", connectAttemptsMax);
            return this;
        }
        /**
         * Delay in seconds the Component will wait for a connection to be
         * established to the MQTT broker.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder connectWaitInSeconds(
                int connectWaitInSeconds) {
            doSetProperty("connectWaitInSeconds", connectWaitInSeconds);
            return this;
        }
        /**
         * Delay in seconds the Component will wait for a connection to be
         * established to the MQTT broker.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder connectWaitInSeconds(
                String connectWaitInSeconds) {
            doSetProperty("connectWaitInSeconds", connectWaitInSeconds);
            return this;
        }
        /**
         * The number of seconds the Component will wait for a valid disconnect
         * on stop() from the MQTT broker.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder disconnectWaitInSeconds(
                int disconnectWaitInSeconds) {
            doSetProperty("disconnectWaitInSeconds", disconnectWaitInSeconds);
            return this;
        }
        /**
         * The number of seconds the Component will wait for a valid disconnect
         * on stop() from the MQTT broker.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder disconnectWaitInSeconds(
                String disconnectWaitInSeconds) {
            doSetProperty("disconnectWaitInSeconds", disconnectWaitInSeconds);
            return this;
        }
        /**
         * A HawtDispatch dispatch queue is used to synchronize access to the
         * connection. If an explicit queue is not configured via the
         * setDispatchQueue method, then a new queue will be created for the
         * connection. Setting an explicit queue might be handy if you want
         * multiple connection to share the same queue for synchronization.
         * 
         * The option is a:
         * <code>org.fusesource.hawtdispatch.DispatchQueue</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder dispatchQueue(Object dispatchQueue) {
            doSetProperty("dispatchQueue", dispatchQueue);
            return this;
        }
        /**
         * A HawtDispatch dispatch queue is used to synchronize access to the
         * connection. If an explicit queue is not configured via the
         * setDispatchQueue method, then a new queue will be created for the
         * connection. Setting an explicit queue might be handy if you want
         * multiple connection to share the same queue for synchronization.
         * 
         * The option will be converted to a
         * <code>org.fusesource.hawtdispatch.DispatchQueue</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder dispatchQueue(String dispatchQueue) {
            doSetProperty("dispatchQueue", dispatchQueue);
            return this;
        }
        /**
         * The URI of the MQTT broker to connect too - this component also
         * supports SSL - e.g. ssl://127.0.0.1:8883.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder host(String host) {
            doSetProperty("host", host);
            return this;
        }
        /**
         * Configures the Keep Alive timer in seconds. Defines the maximum time
         * interval between messages received from a client. It enables the
         * server to detect that the network connection to a client has dropped,
         * without having to wait for the long TCP/IP timeout.
         * 
         * The option is a: <code>short</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder keepAlive(short keepAlive) {
            doSetProperty("keepAlive", keepAlive);
            return this;
        }
        /**
         * Configures the Keep Alive timer in seconds. Defines the maximum time
         * interval between messages received from a client. It enables the
         * server to detect that the network connection to a client has dropped,
         * without having to wait for the long TCP/IP timeout.
         * 
         * The option will be converted to a <code>short</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder keepAlive(String keepAlive) {
            doSetProperty("keepAlive", keepAlive);
            return this;
        }
        /**
         * The local InetAddress and port to use.
         * 
         * The option is a: <code>java.net.URI</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder localAddress(URI localAddress) {
            doSetProperty("localAddress", localAddress);
            return this;
        }
        /**
         * The local InetAddress and port to use.
         * 
         * The option will be converted to a <code>java.net.URI</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder localAddress(String localAddress) {
            doSetProperty("localAddress", localAddress);
            return this;
        }
        /**
         * Sets the maximum bytes per second that this transport will receive
         * data at. This setting throttles reads so that the rate is not
         * exceeded. Defaults to 0 which disables throttling.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder maxReadRate(int maxReadRate) {
            doSetProperty("maxReadRate", maxReadRate);
            return this;
        }
        /**
         * Sets the maximum bytes per second that this transport will receive
         * data at. This setting throttles reads so that the rate is not
         * exceeded. Defaults to 0 which disables throttling.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder maxReadRate(String maxReadRate) {
            doSetProperty("maxReadRate", maxReadRate);
            return this;
        }
        /**
         * Sets the maximum bytes per second that this transport will send data
         * at. This setting throttles writes so that the rate is not exceeded.
         * Defaults to 0 which disables throttling.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder maxWriteRate(int maxWriteRate) {
            doSetProperty("maxWriteRate", maxWriteRate);
            return this;
        }
        /**
         * Sets the maximum bytes per second that this transport will send data
         * at. This setting throttles writes so that the rate is not exceeded.
         * Defaults to 0 which disables throttling.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder maxWriteRate(String maxWriteRate) {
            doSetProperty("maxWriteRate", maxWriteRate);
            return this;
        }
        /**
         * The property name to look for on an Exchange for an individual
         * published message. If this is set (one of AtMostOnce, AtLeastOnce or
         * ExactlyOnce ) - then that QoS will be set on the message sent to the
         * MQTT message broker.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder mqttQosPropertyName(
                String mqttQosPropertyName) {
            doSetProperty("mqttQosPropertyName", mqttQosPropertyName);
            return this;
        }
        /**
         * The property name to look for on an Exchange for an individual
         * published message. If this is set (expects a Boolean value) - then
         * the retain property will be set on the message sent to the MQTT
         * message broker.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder mqttRetainPropertyName(
                String mqttRetainPropertyName) {
            doSetProperty("mqttRetainPropertyName", mqttRetainPropertyName);
            return this;
        }
        /**
         * These a properties that are looked for in an Exchange - to publish
         * to.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder mqttTopicPropertyName(
                String mqttTopicPropertyName) {
            doSetProperty("mqttTopicPropertyName", mqttTopicPropertyName);
            return this;
        }
        /**
         * The default Topic to publish messages on.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder publishTopicName(
                String publishTopicName) {
            doSetProperty("publishTopicName", publishTopicName);
            return this;
        }
        /**
         * Quality of service level to use for topics.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder qualityOfService(
                String qualityOfService) {
            doSetProperty("qualityOfService", qualityOfService);
            return this;
        }
        /**
         * Sets the size of the internal socket receive buffer. Defaults to
         * 65536 (64k).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder receiveBufferSize(
                int receiveBufferSize) {
            doSetProperty("receiveBufferSize", receiveBufferSize);
            return this;
        }
        /**
         * Sets the size of the internal socket receive buffer. Defaults to
         * 65536 (64k).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder receiveBufferSize(
                String receiveBufferSize) {
            doSetProperty("receiveBufferSize", receiveBufferSize);
            return this;
        }
        /**
         * The maximum number of reconnect attempts before an error is reported
         * back to the client after a server connection had previously been
         * established. Set to -1 to use unlimited attempts. Defaults to -1.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder reconnectAttemptsMax(
                long reconnectAttemptsMax) {
            doSetProperty("reconnectAttemptsMax", reconnectAttemptsMax);
            return this;
        }
        /**
         * The maximum number of reconnect attempts before an error is reported
         * back to the client after a server connection had previously been
         * established. Set to -1 to use unlimited attempts. Defaults to -1.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder reconnectAttemptsMax(
                String reconnectAttemptsMax) {
            doSetProperty("reconnectAttemptsMax", reconnectAttemptsMax);
            return this;
        }
        /**
         * The Exponential backoff be used between reconnect attempts. Set to 1
         * to disable exponential backoff. Defaults to 2.
         * 
         * The option is a: <code>double</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder reconnectBackOffMultiplier(
                double reconnectBackOffMultiplier) {
            doSetProperty("reconnectBackOffMultiplier", reconnectBackOffMultiplier);
            return this;
        }
        /**
         * The Exponential backoff be used between reconnect attempts. Set to 1
         * to disable exponential backoff. Defaults to 2.
         * 
         * The option will be converted to a <code>double</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder reconnectBackOffMultiplier(
                String reconnectBackOffMultiplier) {
            doSetProperty("reconnectBackOffMultiplier", reconnectBackOffMultiplier);
            return this;
        }
        /**
         * How long to wait in ms before the first reconnect attempt. Defaults
         * to 10.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder reconnectDelay(long reconnectDelay) {
            doSetProperty("reconnectDelay", reconnectDelay);
            return this;
        }
        /**
         * How long to wait in ms before the first reconnect attempt. Defaults
         * to 10.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder reconnectDelay(String reconnectDelay) {
            doSetProperty("reconnectDelay", reconnectDelay);
            return this;
        }
        /**
         * The maximum amount of time in ms to wait between reconnect attempts.
         * Defaults to 30,000.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder reconnectDelayMax(
                long reconnectDelayMax) {
            doSetProperty("reconnectDelayMax", reconnectDelayMax);
            return this;
        }
        /**
         * The maximum amount of time in ms to wait between reconnect attempts.
         * Defaults to 30,000.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder reconnectDelayMax(
                String reconnectDelayMax) {
            doSetProperty("reconnectDelayMax", reconnectDelayMax);
            return this;
        }
        /**
         * Sets the size of the internal socket send buffer. Defaults to 65536
         * (64k).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder sendBufferSize(int sendBufferSize) {
            doSetProperty("sendBufferSize", sendBufferSize);
            return this;
        }
        /**
         * Sets the size of the internal socket send buffer. Defaults to 65536
         * (64k).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder sendBufferSize(String sendBufferSize) {
            doSetProperty("sendBufferSize", sendBufferSize);
            return this;
        }
        /**
         * The maximum time the Component will wait for a receipt from the MQTT
         * broker to acknowledge a published message before throwing an
         * exception.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder sendWaitInSeconds(
                int sendWaitInSeconds) {
            doSetProperty("sendWaitInSeconds", sendWaitInSeconds);
            return this;
        }
        /**
         * The maximum time the Component will wait for a receipt from the MQTT
         * broker to acknowledge a published message before throwing an
         * exception.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder sendWaitInSeconds(
                String sendWaitInSeconds) {
            doSetProperty("sendWaitInSeconds", sendWaitInSeconds);
            return this;
        }
        /**
         * To configure security using SSLContext configuration.
         * 
         * The option is a: <code>javax.net.ssl.SSLContext</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder sslContext(Object sslContext) {
            doSetProperty("sslContext", sslContext);
            return this;
        }
        /**
         * To configure security using SSLContext configuration.
         * 
         * The option will be converted to a
         * <code>javax.net.ssl.SSLContext</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder sslContext(String sslContext) {
            doSetProperty("sslContext", sslContext);
            return this;
        }
        /**
         * These are set on the Endpoint - together with properties inherited
         * from MQTT.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        @Deprecated
        default MQTTEndpointConsumerBuilder subscribeTopicName(
                String subscribeTopicName) {
            doSetProperty("subscribeTopicName", subscribeTopicName);
            return this;
        }
        /**
         * A comma-delimited list of Topics to subscribe to for messages. Note
         * that each item of this list can contain MQTT wildcards ( and/or #),
         * in order to subscribe to topics matching a certain pattern within a
         * hierarchy. For example, is a wildcard for all topics at a level
         * within the hierarchy, so if a broker has topics topics/one and
         * topics/two, then topics/ can be used to subscribe to both. A caveat
         * to consider here is that if the broker adds topics/three, the route
         * would also begin to receive messages from that topic.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder subscribeTopicNames(
                String subscribeTopicNames) {
            doSetProperty("subscribeTopicNames", subscribeTopicNames);
            return this;
        }
        /**
         * Sets traffic class or type-of-service octet in the IP header for
         * packets sent from the transport. Defaults to 8 which means the
         * traffic should be optimized for throughput.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder trafficClass(int trafficClass) {
            doSetProperty("trafficClass", trafficClass);
            return this;
        }
        /**
         * Sets traffic class or type-of-service octet in the IP header for
         * packets sent from the transport. Defaults to 8 which means the
         * traffic should be optimized for throughput.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder trafficClass(String trafficClass) {
            doSetProperty("trafficClass", trafficClass);
            return this;
        }
        /**
         * Set to 3.1.1 to use MQTT version 3.1.1. Otherwise defaults to the 3.1
         * protocol version.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder version(String version) {
            doSetProperty("version", version);
            return this;
        }
        /**
         * The Will message to send. Defaults to a zero length message.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder willMessage(String willMessage) {
            doSetProperty("willMessage", willMessage);
            return this;
        }
        /**
         * Sets the quality of service to use for the Will message. Defaults to
         * AT_MOST_ONCE.
         * 
         * The option is a: <code>org.fusesource.mqtt.client.QoS</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder willQos(QoS willQos) {
            doSetProperty("willQos", willQos);
            return this;
        }
        /**
         * Sets the quality of service to use for the Will message. Defaults to
         * AT_MOST_ONCE.
         * 
         * The option will be converted to a
         * <code>org.fusesource.mqtt.client.QoS</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder willQos(String willQos) {
            doSetProperty("willQos", willQos);
            return this;
        }
        /**
         * Set to true if you want the Will to be published with the retain
         * option.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder willRetain(boolean willRetain) {
            doSetProperty("willRetain", willRetain);
            return this;
        }
        /**
         * Set to true if you want the Will to be published with the retain
         * option.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder willRetain(String willRetain) {
            doSetProperty("willRetain", willRetain);
            return this;
        }
        /**
         * If set the server will publish the client's Will message to the
         * specified topics if the client has an unexpected disconnection.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointConsumerBuilder willTopic(String willTopic) {
            doSetProperty("willTopic", willTopic);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default MQTTEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default MQTTEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the MQTT component.
     */
    public interface AdvancedMQTTEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default MQTTEndpointConsumerBuilder basic() {
            return (MQTTEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedMQTTEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedMQTTEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedMQTTEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedMQTTEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMQTTEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMQTTEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMQTTEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMQTTEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the MQTT component.
     */
    public interface MQTTEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedMQTTEndpointProducerBuilder advanced() {
            return (AdvancedMQTTEndpointProducerBuilder) this;
        }
        /**
         * SSL connections perform blocking operations against internal thread
         * pool unless you call the setBlockingExecutor method to configure that
         * executor they will use instead.
         * 
         * The option is a: <code>java.util.concurrent.Executor</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder blockingExecutor(
                Executor blockingExecutor) {
            doSetProperty("blockingExecutor", blockingExecutor);
            return this;
        }
        /**
         * SSL connections perform blocking operations against internal thread
         * pool unless you call the setBlockingExecutor method to configure that
         * executor they will use instead.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.Executor</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder blockingExecutor(
                String blockingExecutor) {
            doSetProperty("blockingExecutor", blockingExecutor);
            return this;
        }
        /**
         * The default retain policy to be used on messages sent to the MQTT
         * broker.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder byDefaultRetain(
                boolean byDefaultRetain) {
            doSetProperty("byDefaultRetain", byDefaultRetain);
            return this;
        }
        /**
         * The default retain policy to be used on messages sent to the MQTT
         * broker.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder byDefaultRetain(
                String byDefaultRetain) {
            doSetProperty("byDefaultRetain", byDefaultRetain);
            return this;
        }
        /**
         * Set to false if you want the MQTT server to persist topic
         * subscriptions and ack positions across client sessions. Defaults to
         * true.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder cleanSession(boolean cleanSession) {
            doSetProperty("cleanSession", cleanSession);
            return this;
        }
        /**
         * Set to false if you want the MQTT server to persist topic
         * subscriptions and ack positions across client sessions. Defaults to
         * true.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder cleanSession(String cleanSession) {
            doSetProperty("cleanSession", cleanSession);
            return this;
        }
        /**
         * Use to set the client Id of the session. This is what an MQTT server
         * uses to identify a session where setCleanSession(false); is being
         * used. The id must be 23 characters or less. Defaults to auto
         * generated id (based on your socket address, port and timestamp).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder clientId(String clientId) {
            doSetProperty("clientId", clientId);
            return this;
        }
        /**
         * The maximum number of reconnect attempts before an error is reported
         * back to the client on the first attempt by the client to connect to a
         * server. Set to -1 to use unlimited attempts. Defaults to -1.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder connectAttemptsMax(
                long connectAttemptsMax) {
            doSetProperty("connectAttemptsMax", connectAttemptsMax);
            return this;
        }
        /**
         * The maximum number of reconnect attempts before an error is reported
         * back to the client on the first attempt by the client to connect to a
         * server. Set to -1 to use unlimited attempts. Defaults to -1.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder connectAttemptsMax(
                String connectAttemptsMax) {
            doSetProperty("connectAttemptsMax", connectAttemptsMax);
            return this;
        }
        /**
         * Delay in seconds the Component will wait for a connection to be
         * established to the MQTT broker.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder connectWaitInSeconds(
                int connectWaitInSeconds) {
            doSetProperty("connectWaitInSeconds", connectWaitInSeconds);
            return this;
        }
        /**
         * Delay in seconds the Component will wait for a connection to be
         * established to the MQTT broker.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder connectWaitInSeconds(
                String connectWaitInSeconds) {
            doSetProperty("connectWaitInSeconds", connectWaitInSeconds);
            return this;
        }
        /**
         * The number of seconds the Component will wait for a valid disconnect
         * on stop() from the MQTT broker.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder disconnectWaitInSeconds(
                int disconnectWaitInSeconds) {
            doSetProperty("disconnectWaitInSeconds", disconnectWaitInSeconds);
            return this;
        }
        /**
         * The number of seconds the Component will wait for a valid disconnect
         * on stop() from the MQTT broker.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder disconnectWaitInSeconds(
                String disconnectWaitInSeconds) {
            doSetProperty("disconnectWaitInSeconds", disconnectWaitInSeconds);
            return this;
        }
        /**
         * A HawtDispatch dispatch queue is used to synchronize access to the
         * connection. If an explicit queue is not configured via the
         * setDispatchQueue method, then a new queue will be created for the
         * connection. Setting an explicit queue might be handy if you want
         * multiple connection to share the same queue for synchronization.
         * 
         * The option is a:
         * <code>org.fusesource.hawtdispatch.DispatchQueue</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder dispatchQueue(Object dispatchQueue) {
            doSetProperty("dispatchQueue", dispatchQueue);
            return this;
        }
        /**
         * A HawtDispatch dispatch queue is used to synchronize access to the
         * connection. If an explicit queue is not configured via the
         * setDispatchQueue method, then a new queue will be created for the
         * connection. Setting an explicit queue might be handy if you want
         * multiple connection to share the same queue for synchronization.
         * 
         * The option will be converted to a
         * <code>org.fusesource.hawtdispatch.DispatchQueue</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder dispatchQueue(String dispatchQueue) {
            doSetProperty("dispatchQueue", dispatchQueue);
            return this;
        }
        /**
         * The URI of the MQTT broker to connect too - this component also
         * supports SSL - e.g. ssl://127.0.0.1:8883.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder host(String host) {
            doSetProperty("host", host);
            return this;
        }
        /**
         * Configures the Keep Alive timer in seconds. Defines the maximum time
         * interval between messages received from a client. It enables the
         * server to detect that the network connection to a client has dropped,
         * without having to wait for the long TCP/IP timeout.
         * 
         * The option is a: <code>short</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder keepAlive(short keepAlive) {
            doSetProperty("keepAlive", keepAlive);
            return this;
        }
        /**
         * Configures the Keep Alive timer in seconds. Defines the maximum time
         * interval between messages received from a client. It enables the
         * server to detect that the network connection to a client has dropped,
         * without having to wait for the long TCP/IP timeout.
         * 
         * The option will be converted to a <code>short</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder keepAlive(String keepAlive) {
            doSetProperty("keepAlive", keepAlive);
            return this;
        }
        /**
         * The local InetAddress and port to use.
         * 
         * The option is a: <code>java.net.URI</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder localAddress(URI localAddress) {
            doSetProperty("localAddress", localAddress);
            return this;
        }
        /**
         * The local InetAddress and port to use.
         * 
         * The option will be converted to a <code>java.net.URI</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder localAddress(String localAddress) {
            doSetProperty("localAddress", localAddress);
            return this;
        }
        /**
         * Sets the maximum bytes per second that this transport will receive
         * data at. This setting throttles reads so that the rate is not
         * exceeded. Defaults to 0 which disables throttling.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder maxReadRate(int maxReadRate) {
            doSetProperty("maxReadRate", maxReadRate);
            return this;
        }
        /**
         * Sets the maximum bytes per second that this transport will receive
         * data at. This setting throttles reads so that the rate is not
         * exceeded. Defaults to 0 which disables throttling.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder maxReadRate(String maxReadRate) {
            doSetProperty("maxReadRate", maxReadRate);
            return this;
        }
        /**
         * Sets the maximum bytes per second that this transport will send data
         * at. This setting throttles writes so that the rate is not exceeded.
         * Defaults to 0 which disables throttling.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder maxWriteRate(int maxWriteRate) {
            doSetProperty("maxWriteRate", maxWriteRate);
            return this;
        }
        /**
         * Sets the maximum bytes per second that this transport will send data
         * at. This setting throttles writes so that the rate is not exceeded.
         * Defaults to 0 which disables throttling.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder maxWriteRate(String maxWriteRate) {
            doSetProperty("maxWriteRate", maxWriteRate);
            return this;
        }
        /**
         * The property name to look for on an Exchange for an individual
         * published message. If this is set (one of AtMostOnce, AtLeastOnce or
         * ExactlyOnce ) - then that QoS will be set on the message sent to the
         * MQTT message broker.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder mqttQosPropertyName(
                String mqttQosPropertyName) {
            doSetProperty("mqttQosPropertyName", mqttQosPropertyName);
            return this;
        }
        /**
         * The property name to look for on an Exchange for an individual
         * published message. If this is set (expects a Boolean value) - then
         * the retain property will be set on the message sent to the MQTT
         * message broker.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder mqttRetainPropertyName(
                String mqttRetainPropertyName) {
            doSetProperty("mqttRetainPropertyName", mqttRetainPropertyName);
            return this;
        }
        /**
         * These a properties that are looked for in an Exchange - to publish
         * to.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder mqttTopicPropertyName(
                String mqttTopicPropertyName) {
            doSetProperty("mqttTopicPropertyName", mqttTopicPropertyName);
            return this;
        }
        /**
         * The default Topic to publish messages on.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder publishTopicName(
                String publishTopicName) {
            doSetProperty("publishTopicName", publishTopicName);
            return this;
        }
        /**
         * Quality of service level to use for topics.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder qualityOfService(
                String qualityOfService) {
            doSetProperty("qualityOfService", qualityOfService);
            return this;
        }
        /**
         * Sets the size of the internal socket receive buffer. Defaults to
         * 65536 (64k).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder receiveBufferSize(
                int receiveBufferSize) {
            doSetProperty("receiveBufferSize", receiveBufferSize);
            return this;
        }
        /**
         * Sets the size of the internal socket receive buffer. Defaults to
         * 65536 (64k).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder receiveBufferSize(
                String receiveBufferSize) {
            doSetProperty("receiveBufferSize", receiveBufferSize);
            return this;
        }
        /**
         * The maximum number of reconnect attempts before an error is reported
         * back to the client after a server connection had previously been
         * established. Set to -1 to use unlimited attempts. Defaults to -1.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder reconnectAttemptsMax(
                long reconnectAttemptsMax) {
            doSetProperty("reconnectAttemptsMax", reconnectAttemptsMax);
            return this;
        }
        /**
         * The maximum number of reconnect attempts before an error is reported
         * back to the client after a server connection had previously been
         * established. Set to -1 to use unlimited attempts. Defaults to -1.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder reconnectAttemptsMax(
                String reconnectAttemptsMax) {
            doSetProperty("reconnectAttemptsMax", reconnectAttemptsMax);
            return this;
        }
        /**
         * The Exponential backoff be used between reconnect attempts. Set to 1
         * to disable exponential backoff. Defaults to 2.
         * 
         * The option is a: <code>double</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder reconnectBackOffMultiplier(
                double reconnectBackOffMultiplier) {
            doSetProperty("reconnectBackOffMultiplier", reconnectBackOffMultiplier);
            return this;
        }
        /**
         * The Exponential backoff be used between reconnect attempts. Set to 1
         * to disable exponential backoff. Defaults to 2.
         * 
         * The option will be converted to a <code>double</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder reconnectBackOffMultiplier(
                String reconnectBackOffMultiplier) {
            doSetProperty("reconnectBackOffMultiplier", reconnectBackOffMultiplier);
            return this;
        }
        /**
         * How long to wait in ms before the first reconnect attempt. Defaults
         * to 10.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder reconnectDelay(long reconnectDelay) {
            doSetProperty("reconnectDelay", reconnectDelay);
            return this;
        }
        /**
         * How long to wait in ms before the first reconnect attempt. Defaults
         * to 10.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder reconnectDelay(String reconnectDelay) {
            doSetProperty("reconnectDelay", reconnectDelay);
            return this;
        }
        /**
         * The maximum amount of time in ms to wait between reconnect attempts.
         * Defaults to 30,000.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder reconnectDelayMax(
                long reconnectDelayMax) {
            doSetProperty("reconnectDelayMax", reconnectDelayMax);
            return this;
        }
        /**
         * The maximum amount of time in ms to wait between reconnect attempts.
         * Defaults to 30,000.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder reconnectDelayMax(
                String reconnectDelayMax) {
            doSetProperty("reconnectDelayMax", reconnectDelayMax);
            return this;
        }
        /**
         * Sets the size of the internal socket send buffer. Defaults to 65536
         * (64k).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder sendBufferSize(int sendBufferSize) {
            doSetProperty("sendBufferSize", sendBufferSize);
            return this;
        }
        /**
         * Sets the size of the internal socket send buffer. Defaults to 65536
         * (64k).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder sendBufferSize(String sendBufferSize) {
            doSetProperty("sendBufferSize", sendBufferSize);
            return this;
        }
        /**
         * The maximum time the Component will wait for a receipt from the MQTT
         * broker to acknowledge a published message before throwing an
         * exception.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder sendWaitInSeconds(
                int sendWaitInSeconds) {
            doSetProperty("sendWaitInSeconds", sendWaitInSeconds);
            return this;
        }
        /**
         * The maximum time the Component will wait for a receipt from the MQTT
         * broker to acknowledge a published message before throwing an
         * exception.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder sendWaitInSeconds(
                String sendWaitInSeconds) {
            doSetProperty("sendWaitInSeconds", sendWaitInSeconds);
            return this;
        }
        /**
         * To configure security using SSLContext configuration.
         * 
         * The option is a: <code>javax.net.ssl.SSLContext</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder sslContext(Object sslContext) {
            doSetProperty("sslContext", sslContext);
            return this;
        }
        /**
         * To configure security using SSLContext configuration.
         * 
         * The option will be converted to a
         * <code>javax.net.ssl.SSLContext</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder sslContext(String sslContext) {
            doSetProperty("sslContext", sslContext);
            return this;
        }
        /**
         * These are set on the Endpoint - together with properties inherited
         * from MQTT.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        @Deprecated
        default MQTTEndpointProducerBuilder subscribeTopicName(
                String subscribeTopicName) {
            doSetProperty("subscribeTopicName", subscribeTopicName);
            return this;
        }
        /**
         * A comma-delimited list of Topics to subscribe to for messages. Note
         * that each item of this list can contain MQTT wildcards ( and/or #),
         * in order to subscribe to topics matching a certain pattern within a
         * hierarchy. For example, is a wildcard for all topics at a level
         * within the hierarchy, so if a broker has topics topics/one and
         * topics/two, then topics/ can be used to subscribe to both. A caveat
         * to consider here is that if the broker adds topics/three, the route
         * would also begin to receive messages from that topic.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder subscribeTopicNames(
                String subscribeTopicNames) {
            doSetProperty("subscribeTopicNames", subscribeTopicNames);
            return this;
        }
        /**
         * Sets traffic class or type-of-service octet in the IP header for
         * packets sent from the transport. Defaults to 8 which means the
         * traffic should be optimized for throughput.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder trafficClass(int trafficClass) {
            doSetProperty("trafficClass", trafficClass);
            return this;
        }
        /**
         * Sets traffic class or type-of-service octet in the IP header for
         * packets sent from the transport. Defaults to 8 which means the
         * traffic should be optimized for throughput.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder trafficClass(String trafficClass) {
            doSetProperty("trafficClass", trafficClass);
            return this;
        }
        /**
         * Set to 3.1.1 to use MQTT version 3.1.1. Otherwise defaults to the 3.1
         * protocol version.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder version(String version) {
            doSetProperty("version", version);
            return this;
        }
        /**
         * The Will message to send. Defaults to a zero length message.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder willMessage(String willMessage) {
            doSetProperty("willMessage", willMessage);
            return this;
        }
        /**
         * Sets the quality of service to use for the Will message. Defaults to
         * AT_MOST_ONCE.
         * 
         * The option is a: <code>org.fusesource.mqtt.client.QoS</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder willQos(QoS willQos) {
            doSetProperty("willQos", willQos);
            return this;
        }
        /**
         * Sets the quality of service to use for the Will message. Defaults to
         * AT_MOST_ONCE.
         * 
         * The option will be converted to a
         * <code>org.fusesource.mqtt.client.QoS</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder willQos(String willQos) {
            doSetProperty("willQos", willQos);
            return this;
        }
        /**
         * Set to true if you want the Will to be published with the retain
         * option.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder willRetain(boolean willRetain) {
            doSetProperty("willRetain", willRetain);
            return this;
        }
        /**
         * Set to true if you want the Will to be published with the retain
         * option.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder willRetain(String willRetain) {
            doSetProperty("willRetain", willRetain);
            return this;
        }
        /**
         * If set the server will publish the client's Will message to the
         * specified topics if the client has an unexpected disconnection.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointProducerBuilder willTopic(String willTopic) {
            doSetProperty("willTopic", willTopic);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default MQTTEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default MQTTEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the MQTT component.
     */
    public interface AdvancedMQTTEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default MQTTEndpointProducerBuilder basic() {
            return (MQTTEndpointProducerBuilder) this;
        }
        /**
         * Sessions can be lazily created to avoid exceptions, if the remote
         * server is not up and running when the Camel producer is started.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer (advanced)
         */
        default AdvancedMQTTEndpointProducerBuilder lazySessionCreation(
                boolean lazySessionCreation) {
            doSetProperty("lazySessionCreation", lazySessionCreation);
            return this;
        }
        /**
         * Sessions can be lazily created to avoid exceptions, if the remote
         * server is not up and running when the Camel producer is started.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer (advanced)
         */
        default AdvancedMQTTEndpointProducerBuilder lazySessionCreation(
                String lazySessionCreation) {
            doSetProperty("lazySessionCreation", lazySessionCreation);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMQTTEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMQTTEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMQTTEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMQTTEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the MQTT component.
     */
    public interface MQTTEndpointBuilder
            extends
                MQTTEndpointConsumerBuilder, MQTTEndpointProducerBuilder {
        default AdvancedMQTTEndpointBuilder advanced() {
            return (AdvancedMQTTEndpointBuilder) this;
        }
        /**
         * SSL connections perform blocking operations against internal thread
         * pool unless you call the setBlockingExecutor method to configure that
         * executor they will use instead.
         * 
         * The option is a: <code>java.util.concurrent.Executor</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder blockingExecutor(Executor blockingExecutor) {
            doSetProperty("blockingExecutor", blockingExecutor);
            return this;
        }
        /**
         * SSL connections perform blocking operations against internal thread
         * pool unless you call the setBlockingExecutor method to configure that
         * executor they will use instead.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.Executor</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder blockingExecutor(String blockingExecutor) {
            doSetProperty("blockingExecutor", blockingExecutor);
            return this;
        }
        /**
         * The default retain policy to be used on messages sent to the MQTT
         * broker.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder byDefaultRetain(boolean byDefaultRetain) {
            doSetProperty("byDefaultRetain", byDefaultRetain);
            return this;
        }
        /**
         * The default retain policy to be used on messages sent to the MQTT
         * broker.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder byDefaultRetain(String byDefaultRetain) {
            doSetProperty("byDefaultRetain", byDefaultRetain);
            return this;
        }
        /**
         * Set to false if you want the MQTT server to persist topic
         * subscriptions and ack positions across client sessions. Defaults to
         * true.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder cleanSession(boolean cleanSession) {
            doSetProperty("cleanSession", cleanSession);
            return this;
        }
        /**
         * Set to false if you want the MQTT server to persist topic
         * subscriptions and ack positions across client sessions. Defaults to
         * true.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder cleanSession(String cleanSession) {
            doSetProperty("cleanSession", cleanSession);
            return this;
        }
        /**
         * Use to set the client Id of the session. This is what an MQTT server
         * uses to identify a session where setCleanSession(false); is being
         * used. The id must be 23 characters or less. Defaults to auto
         * generated id (based on your socket address, port and timestamp).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder clientId(String clientId) {
            doSetProperty("clientId", clientId);
            return this;
        }
        /**
         * The maximum number of reconnect attempts before an error is reported
         * back to the client on the first attempt by the client to connect to a
         * server. Set to -1 to use unlimited attempts. Defaults to -1.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder connectAttemptsMax(long connectAttemptsMax) {
            doSetProperty("connectAttemptsMax", connectAttemptsMax);
            return this;
        }
        /**
         * The maximum number of reconnect attempts before an error is reported
         * back to the client on the first attempt by the client to connect to a
         * server. Set to -1 to use unlimited attempts. Defaults to -1.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder connectAttemptsMax(String connectAttemptsMax) {
            doSetProperty("connectAttemptsMax", connectAttemptsMax);
            return this;
        }
        /**
         * Delay in seconds the Component will wait for a connection to be
         * established to the MQTT broker.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder connectWaitInSeconds(
                int connectWaitInSeconds) {
            doSetProperty("connectWaitInSeconds", connectWaitInSeconds);
            return this;
        }
        /**
         * Delay in seconds the Component will wait for a connection to be
         * established to the MQTT broker.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder connectWaitInSeconds(
                String connectWaitInSeconds) {
            doSetProperty("connectWaitInSeconds", connectWaitInSeconds);
            return this;
        }
        /**
         * The number of seconds the Component will wait for a valid disconnect
         * on stop() from the MQTT broker.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder disconnectWaitInSeconds(
                int disconnectWaitInSeconds) {
            doSetProperty("disconnectWaitInSeconds", disconnectWaitInSeconds);
            return this;
        }
        /**
         * The number of seconds the Component will wait for a valid disconnect
         * on stop() from the MQTT broker.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder disconnectWaitInSeconds(
                String disconnectWaitInSeconds) {
            doSetProperty("disconnectWaitInSeconds", disconnectWaitInSeconds);
            return this;
        }
        /**
         * A HawtDispatch dispatch queue is used to synchronize access to the
         * connection. If an explicit queue is not configured via the
         * setDispatchQueue method, then a new queue will be created for the
         * connection. Setting an explicit queue might be handy if you want
         * multiple connection to share the same queue for synchronization.
         * 
         * The option is a:
         * <code>org.fusesource.hawtdispatch.DispatchQueue</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder dispatchQueue(Object dispatchQueue) {
            doSetProperty("dispatchQueue", dispatchQueue);
            return this;
        }
        /**
         * A HawtDispatch dispatch queue is used to synchronize access to the
         * connection. If an explicit queue is not configured via the
         * setDispatchQueue method, then a new queue will be created for the
         * connection. Setting an explicit queue might be handy if you want
         * multiple connection to share the same queue for synchronization.
         * 
         * The option will be converted to a
         * <code>org.fusesource.hawtdispatch.DispatchQueue</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder dispatchQueue(String dispatchQueue) {
            doSetProperty("dispatchQueue", dispatchQueue);
            return this;
        }
        /**
         * The URI of the MQTT broker to connect too - this component also
         * supports SSL - e.g. ssl://127.0.0.1:8883.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder host(String host) {
            doSetProperty("host", host);
            return this;
        }
        /**
         * Configures the Keep Alive timer in seconds. Defines the maximum time
         * interval between messages received from a client. It enables the
         * server to detect that the network connection to a client has dropped,
         * without having to wait for the long TCP/IP timeout.
         * 
         * The option is a: <code>short</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder keepAlive(short keepAlive) {
            doSetProperty("keepAlive", keepAlive);
            return this;
        }
        /**
         * Configures the Keep Alive timer in seconds. Defines the maximum time
         * interval between messages received from a client. It enables the
         * server to detect that the network connection to a client has dropped,
         * without having to wait for the long TCP/IP timeout.
         * 
         * The option will be converted to a <code>short</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder keepAlive(String keepAlive) {
            doSetProperty("keepAlive", keepAlive);
            return this;
        }
        /**
         * The local InetAddress and port to use.
         * 
         * The option is a: <code>java.net.URI</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder localAddress(URI localAddress) {
            doSetProperty("localAddress", localAddress);
            return this;
        }
        /**
         * The local InetAddress and port to use.
         * 
         * The option will be converted to a <code>java.net.URI</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder localAddress(String localAddress) {
            doSetProperty("localAddress", localAddress);
            return this;
        }
        /**
         * Sets the maximum bytes per second that this transport will receive
         * data at. This setting throttles reads so that the rate is not
         * exceeded. Defaults to 0 which disables throttling.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder maxReadRate(int maxReadRate) {
            doSetProperty("maxReadRate", maxReadRate);
            return this;
        }
        /**
         * Sets the maximum bytes per second that this transport will receive
         * data at. This setting throttles reads so that the rate is not
         * exceeded. Defaults to 0 which disables throttling.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder maxReadRate(String maxReadRate) {
            doSetProperty("maxReadRate", maxReadRate);
            return this;
        }
        /**
         * Sets the maximum bytes per second that this transport will send data
         * at. This setting throttles writes so that the rate is not exceeded.
         * Defaults to 0 which disables throttling.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder maxWriteRate(int maxWriteRate) {
            doSetProperty("maxWriteRate", maxWriteRate);
            return this;
        }
        /**
         * Sets the maximum bytes per second that this transport will send data
         * at. This setting throttles writes so that the rate is not exceeded.
         * Defaults to 0 which disables throttling.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder maxWriteRate(String maxWriteRate) {
            doSetProperty("maxWriteRate", maxWriteRate);
            return this;
        }
        /**
         * The property name to look for on an Exchange for an individual
         * published message. If this is set (one of AtMostOnce, AtLeastOnce or
         * ExactlyOnce ) - then that QoS will be set on the message sent to the
         * MQTT message broker.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder mqttQosPropertyName(
                String mqttQosPropertyName) {
            doSetProperty("mqttQosPropertyName", mqttQosPropertyName);
            return this;
        }
        /**
         * The property name to look for on an Exchange for an individual
         * published message. If this is set (expects a Boolean value) - then
         * the retain property will be set on the message sent to the MQTT
         * message broker.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder mqttRetainPropertyName(
                String mqttRetainPropertyName) {
            doSetProperty("mqttRetainPropertyName", mqttRetainPropertyName);
            return this;
        }
        /**
         * These a properties that are looked for in an Exchange - to publish
         * to.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder mqttTopicPropertyName(
                String mqttTopicPropertyName) {
            doSetProperty("mqttTopicPropertyName", mqttTopicPropertyName);
            return this;
        }
        /**
         * The default Topic to publish messages on.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder publishTopicName(String publishTopicName) {
            doSetProperty("publishTopicName", publishTopicName);
            return this;
        }
        /**
         * Quality of service level to use for topics.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder qualityOfService(String qualityOfService) {
            doSetProperty("qualityOfService", qualityOfService);
            return this;
        }
        /**
         * Sets the size of the internal socket receive buffer. Defaults to
         * 65536 (64k).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder receiveBufferSize(int receiveBufferSize) {
            doSetProperty("receiveBufferSize", receiveBufferSize);
            return this;
        }
        /**
         * Sets the size of the internal socket receive buffer. Defaults to
         * 65536 (64k).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder receiveBufferSize(String receiveBufferSize) {
            doSetProperty("receiveBufferSize", receiveBufferSize);
            return this;
        }
        /**
         * The maximum number of reconnect attempts before an error is reported
         * back to the client after a server connection had previously been
         * established. Set to -1 to use unlimited attempts. Defaults to -1.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder reconnectAttemptsMax(
                long reconnectAttemptsMax) {
            doSetProperty("reconnectAttemptsMax", reconnectAttemptsMax);
            return this;
        }
        /**
         * The maximum number of reconnect attempts before an error is reported
         * back to the client after a server connection had previously been
         * established. Set to -1 to use unlimited attempts. Defaults to -1.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder reconnectAttemptsMax(
                String reconnectAttemptsMax) {
            doSetProperty("reconnectAttemptsMax", reconnectAttemptsMax);
            return this;
        }
        /**
         * The Exponential backoff be used between reconnect attempts. Set to 1
         * to disable exponential backoff. Defaults to 2.
         * 
         * The option is a: <code>double</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder reconnectBackOffMultiplier(
                double reconnectBackOffMultiplier) {
            doSetProperty("reconnectBackOffMultiplier", reconnectBackOffMultiplier);
            return this;
        }
        /**
         * The Exponential backoff be used between reconnect attempts. Set to 1
         * to disable exponential backoff. Defaults to 2.
         * 
         * The option will be converted to a <code>double</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder reconnectBackOffMultiplier(
                String reconnectBackOffMultiplier) {
            doSetProperty("reconnectBackOffMultiplier", reconnectBackOffMultiplier);
            return this;
        }
        /**
         * How long to wait in ms before the first reconnect attempt. Defaults
         * to 10.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder reconnectDelay(long reconnectDelay) {
            doSetProperty("reconnectDelay", reconnectDelay);
            return this;
        }
        /**
         * How long to wait in ms before the first reconnect attempt. Defaults
         * to 10.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder reconnectDelay(String reconnectDelay) {
            doSetProperty("reconnectDelay", reconnectDelay);
            return this;
        }
        /**
         * The maximum amount of time in ms to wait between reconnect attempts.
         * Defaults to 30,000.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder reconnectDelayMax(long reconnectDelayMax) {
            doSetProperty("reconnectDelayMax", reconnectDelayMax);
            return this;
        }
        /**
         * The maximum amount of time in ms to wait between reconnect attempts.
         * Defaults to 30,000.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder reconnectDelayMax(String reconnectDelayMax) {
            doSetProperty("reconnectDelayMax", reconnectDelayMax);
            return this;
        }
        /**
         * Sets the size of the internal socket send buffer. Defaults to 65536
         * (64k).
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder sendBufferSize(int sendBufferSize) {
            doSetProperty("sendBufferSize", sendBufferSize);
            return this;
        }
        /**
         * Sets the size of the internal socket send buffer. Defaults to 65536
         * (64k).
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder sendBufferSize(String sendBufferSize) {
            doSetProperty("sendBufferSize", sendBufferSize);
            return this;
        }
        /**
         * The maximum time the Component will wait for a receipt from the MQTT
         * broker to acknowledge a published message before throwing an
         * exception.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder sendWaitInSeconds(int sendWaitInSeconds) {
            doSetProperty("sendWaitInSeconds", sendWaitInSeconds);
            return this;
        }
        /**
         * The maximum time the Component will wait for a receipt from the MQTT
         * broker to acknowledge a published message before throwing an
         * exception.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder sendWaitInSeconds(String sendWaitInSeconds) {
            doSetProperty("sendWaitInSeconds", sendWaitInSeconds);
            return this;
        }
        /**
         * To configure security using SSLContext configuration.
         * 
         * The option is a: <code>javax.net.ssl.SSLContext</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder sslContext(Object sslContext) {
            doSetProperty("sslContext", sslContext);
            return this;
        }
        /**
         * To configure security using SSLContext configuration.
         * 
         * The option will be converted to a
         * <code>javax.net.ssl.SSLContext</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder sslContext(String sslContext) {
            doSetProperty("sslContext", sslContext);
            return this;
        }
        /**
         * These are set on the Endpoint - together with properties inherited
         * from MQTT.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        @Deprecated
        default MQTTEndpointBuilder subscribeTopicName(String subscribeTopicName) {
            doSetProperty("subscribeTopicName", subscribeTopicName);
            return this;
        }
        /**
         * A comma-delimited list of Topics to subscribe to for messages. Note
         * that each item of this list can contain MQTT wildcards ( and/or #),
         * in order to subscribe to topics matching a certain pattern within a
         * hierarchy. For example, is a wildcard for all topics at a level
         * within the hierarchy, so if a broker has topics topics/one and
         * topics/two, then topics/ can be used to subscribe to both. A caveat
         * to consider here is that if the broker adds topics/three, the route
         * would also begin to receive messages from that topic.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder subscribeTopicNames(
                String subscribeTopicNames) {
            doSetProperty("subscribeTopicNames", subscribeTopicNames);
            return this;
        }
        /**
         * Sets traffic class or type-of-service octet in the IP header for
         * packets sent from the transport. Defaults to 8 which means the
         * traffic should be optimized for throughput.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder trafficClass(int trafficClass) {
            doSetProperty("trafficClass", trafficClass);
            return this;
        }
        /**
         * Sets traffic class or type-of-service octet in the IP header for
         * packets sent from the transport. Defaults to 8 which means the
         * traffic should be optimized for throughput.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder trafficClass(String trafficClass) {
            doSetProperty("trafficClass", trafficClass);
            return this;
        }
        /**
         * Set to 3.1.1 to use MQTT version 3.1.1. Otherwise defaults to the 3.1
         * protocol version.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder version(String version) {
            doSetProperty("version", version);
            return this;
        }
        /**
         * The Will message to send. Defaults to a zero length message.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder willMessage(String willMessage) {
            doSetProperty("willMessage", willMessage);
            return this;
        }
        /**
         * Sets the quality of service to use for the Will message. Defaults to
         * AT_MOST_ONCE.
         * 
         * The option is a: <code>org.fusesource.mqtt.client.QoS</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder willQos(QoS willQos) {
            doSetProperty("willQos", willQos);
            return this;
        }
        /**
         * Sets the quality of service to use for the Will message. Defaults to
         * AT_MOST_ONCE.
         * 
         * The option will be converted to a
         * <code>org.fusesource.mqtt.client.QoS</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder willQos(String willQos) {
            doSetProperty("willQos", willQos);
            return this;
        }
        /**
         * Set to true if you want the Will to be published with the retain
         * option.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder willRetain(boolean willRetain) {
            doSetProperty("willRetain", willRetain);
            return this;
        }
        /**
         * Set to true if you want the Will to be published with the retain
         * option.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder willRetain(String willRetain) {
            doSetProperty("willRetain", willRetain);
            return this;
        }
        /**
         * If set the server will publish the client's Will message to the
         * specified topics if the client has an unexpected disconnection.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default MQTTEndpointBuilder willTopic(String willTopic) {
            doSetProperty("willTopic", willTopic);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the MQTT component.
     */
    public interface AdvancedMQTTEndpointBuilder
            extends
                AdvancedMQTTEndpointConsumerBuilder, AdvancedMQTTEndpointProducerBuilder {
        default MQTTEndpointBuilder basic() {
            return (MQTTEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMQTTEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMQTTEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMQTTEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedMQTTEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Proxy enum for <code>org.fusesource.mqtt.client.QoS</code> enum.
     */
    enum QoS {
        AT_MOST_ONCE,
        AT_LEAST_ONCE,
        EXACTLY_ONCE;
    }
    /**
     * MQTT (camel-mqtt)
     * Component for communicating with MQTT M2M message brokers using
     * FuseSource MQTT Client.
     * 
     * Category: messaging,iot
     * Available as of version: 2.10
     * Maven coordinates: org.apache.camel:camel-mqtt
     * 
     * Syntax: <code>mqtt:name</code>
     * 
     * Path parameter: name (required)
     * A logical name to use which is not the topic name.
     */
    default MQTTEndpointBuilder mqtt(String path) {
        class MQTTEndpointBuilderImpl extends AbstractEndpointBuilder implements MQTTEndpointBuilder, AdvancedMQTTEndpointBuilder {
            public MQTTEndpointBuilderImpl(String path) {
                super("mqtt", path);
            }
        }
        return new MQTTEndpointBuilderImpl(path);
    }
}