/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.PollingConsumerPollStrategy;

/**
 * The jpa component enables you to store and retrieve Java objects from
 * databases using JPA.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface JpaEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the JPA component.
     */
    public interface JpaEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedJpaEndpointConsumerBuilder advanced() {
            return (AdvancedJpaEndpointConsumerBuilder) this;
        }
        /**
         * The camel-jpa component will join transaction by default. You can use
         * this option to turn this off, for example if you use LOCAL_RESOURCE
         * and join transaction doesn't work with your JPA provider. This option
         * can also be set globally on the JpaComponent, instead of having to
         * set it on all endpoints.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default JpaEndpointConsumerBuilder joinTransaction(
                boolean joinTransaction) {
            doSetProperty("joinTransaction", joinTransaction);
            return this;
        }
        /**
         * The camel-jpa component will join transaction by default. You can use
         * this option to turn this off, for example if you use LOCAL_RESOURCE
         * and join transaction doesn't work with your JPA provider. This option
         * can also be set globally on the JpaComponent, instead of having to
         * set it on all endpoints.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default JpaEndpointConsumerBuilder joinTransaction(
                String joinTransaction) {
            doSetProperty("joinTransaction", joinTransaction);
            return this;
        }
        /**
         * Set the maximum number of results to retrieve on the Query.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default JpaEndpointConsumerBuilder maximumResults(int maximumResults) {
            doSetProperty("maximumResults", maximumResults);
            return this;
        }
        /**
         * Set the maximum number of results to retrieve on the Query.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default JpaEndpointConsumerBuilder maximumResults(String maximumResults) {
            doSetProperty("maximumResults", maximumResults);
            return this;
        }
        /**
         * To use a named query.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default JpaEndpointConsumerBuilder namedQuery(String namedQuery) {
            doSetProperty("namedQuery", namedQuery);
            return this;
        }
        /**
         * To use a custom native query. You may want to use the option
         * resultClass also when using native queries.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default JpaEndpointConsumerBuilder nativeQuery(String nativeQuery) {
            doSetProperty("nativeQuery", nativeQuery);
            return this;
        }
        /**
         * The JPA persistence unit used by default.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: common
         */
        default JpaEndpointConsumerBuilder persistenceUnit(
                String persistenceUnit) {
            doSetProperty("persistenceUnit", persistenceUnit);
            return this;
        }
        /**
         * To use a custom query.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default JpaEndpointConsumerBuilder query(String query) {
            doSetProperty("query", query);
            return this;
        }
        /**
         * Defines the type of the returned payload (we will call
         * entityManager.createNativeQuery(nativeQuery, resultClass) instead of
         * entityManager.createNativeQuery(nativeQuery)). Without this option,
         * we will return an object array. Only has an affect when using in
         * conjunction with native query when consuming data.
         * 
         * The option is a: <code>java.lang.Class&lt;java.lang.Object&gt;</code>
         * type.
         * 
         * Group: common
         */
        default JpaEndpointConsumerBuilder resultClass(Class<Object> resultClass) {
            doSetProperty("resultClass", resultClass);
            return this;
        }
        /**
         * Defines the type of the returned payload (we will call
         * entityManager.createNativeQuery(nativeQuery, resultClass) instead of
         * entityManager.createNativeQuery(nativeQuery)). Without this option,
         * we will return an object array. Only has an affect when using in
         * conjunction with native query when consuming data.
         * 
         * The option will be converted to a
         * <code>java.lang.Class&lt;java.lang.Object&gt;</code> type.
         * 
         * Group: common
         */
        default JpaEndpointConsumerBuilder resultClass(String resultClass) {
            doSetProperty("resultClass", resultClass);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default JpaEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default JpaEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * If true, the entity is deleted after it is consumed; if false, the
         * entity is not deleted.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default JpaEndpointConsumerBuilder consumeDelete(boolean consumeDelete) {
            doSetProperty("consumeDelete", consumeDelete);
            return this;
        }
        /**
         * If true, the entity is deleted after it is consumed; if false, the
         * entity is not deleted.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default JpaEndpointConsumerBuilder consumeDelete(String consumeDelete) {
            doSetProperty("consumeDelete", consumeDelete);
            return this;
        }
        /**
         * Specifies whether or not to set an exclusive lock on each entity bean
         * while processing the results from polling.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default JpaEndpointConsumerBuilder consumeLockEntity(
                boolean consumeLockEntity) {
            doSetProperty("consumeLockEntity", consumeLockEntity);
            return this;
        }
        /**
         * Specifies whether or not to set an exclusive lock on each entity bean
         * while processing the results from polling.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default JpaEndpointConsumerBuilder consumeLockEntity(
                String consumeLockEntity) {
            doSetProperty("consumeLockEntity", consumeLockEntity);
            return this;
        }
        /**
         * To use a custom DeleteHandler to delete the row after the consumer is
         * done processing the exchange.
         * 
         * The option is a:
         * <code>org.apache.camel.component.jpa.DeleteHandler&lt;java.lang.Object&gt;</code> type.
         * 
         * Group: consumer
         */
        default JpaEndpointConsumerBuilder deleteHandler(Object deleteHandler) {
            doSetProperty("deleteHandler", deleteHandler);
            return this;
        }
        /**
         * To use a custom DeleteHandler to delete the row after the consumer is
         * done processing the exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.jpa.DeleteHandler&lt;java.lang.Object&gt;</code> type.
         * 
         * Group: consumer
         */
        default JpaEndpointConsumerBuilder deleteHandler(String deleteHandler) {
            doSetProperty("deleteHandler", deleteHandler);
            return this;
        }
        /**
         * To configure the lock mode on the consumer.
         * 
         * The option is a: <code>javax.persistence.LockModeType</code> type.
         * 
         * Group: consumer
         */
        default JpaEndpointConsumerBuilder lockModeType(
                LockModeType lockModeType) {
            doSetProperty("lockModeType", lockModeType);
            return this;
        }
        /**
         * To configure the lock mode on the consumer.
         * 
         * The option will be converted to a
         * <code>javax.persistence.LockModeType</code> type.
         * 
         * Group: consumer
         */
        default JpaEndpointConsumerBuilder lockModeType(String lockModeType) {
            doSetProperty("lockModeType", lockModeType);
            return this;
        }
        /**
         * An integer value to define the maximum number of messages to gather
         * per poll. By default, no maximum is set. Can be used to avoid polling
         * many thousands of messages when starting up the server. Set a value
         * of 0 or negative to disable.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: consumer
         */
        default JpaEndpointConsumerBuilder maxMessagesPerPoll(
                int maxMessagesPerPoll) {
            doSetProperty("maxMessagesPerPoll", maxMessagesPerPoll);
            return this;
        }
        /**
         * An integer value to define the maximum number of messages to gather
         * per poll. By default, no maximum is set. Can be used to avoid polling
         * many thousands of messages when starting up the server. Set a value
         * of 0 or negative to disable.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: consumer
         */
        default JpaEndpointConsumerBuilder maxMessagesPerPoll(
                String maxMessagesPerPoll) {
            doSetProperty("maxMessagesPerPoll", maxMessagesPerPoll);
            return this;
        }
        /**
         * To use a custom Pre-DeleteHandler to delete the row after the
         * consumer has read the entity.
         * 
         * The option is a:
         * <code>org.apache.camel.component.jpa.DeleteHandler&lt;java.lang.Object&gt;</code> type.
         * 
         * Group: consumer
         */
        default JpaEndpointConsumerBuilder preDeleteHandler(
                Object preDeleteHandler) {
            doSetProperty("preDeleteHandler", preDeleteHandler);
            return this;
        }
        /**
         * To use a custom Pre-DeleteHandler to delete the row after the
         * consumer has read the entity.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.jpa.DeleteHandler&lt;java.lang.Object&gt;</code> type.
         * 
         * Group: consumer
         */
        default JpaEndpointConsumerBuilder preDeleteHandler(
                String preDeleteHandler) {
            doSetProperty("preDeleteHandler", preDeleteHandler);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default JpaEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                boolean sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default JpaEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                String sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * To configure whether to use NOWAIT on lock and silently skip the
         * entity.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default JpaEndpointConsumerBuilder skipLockedEntity(
                boolean skipLockedEntity) {
            doSetProperty("skipLockedEntity", skipLockedEntity);
            return this;
        }
        /**
         * To configure whether to use NOWAIT on lock and silently skip the
         * entity.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default JpaEndpointConsumerBuilder skipLockedEntity(
                String skipLockedEntity) {
            doSetProperty("skipLockedEntity", skipLockedEntity);
            return this;
        }
        /**
         * Whether to run the consumer in transacted mode, by which all messages
         * will either commit or rollback, when the entire batch has been
         * processed. The default behavior (false) is to commit all the
         * previously successfully processed messages, and only rollback the
         * last failed message.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default JpaEndpointConsumerBuilder transacted(boolean transacted) {
            doSetProperty("transacted", transacted);
            return this;
        }
        /**
         * Whether to run the consumer in transacted mode, by which all messages
         * will either commit or rollback, when the entire batch has been
         * processed. The default behavior (false) is to commit all the
         * previously successfully processed messages, and only rollback the
         * last failed message.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default JpaEndpointConsumerBuilder transacted(String transacted) {
            doSetProperty("transacted", transacted);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default JpaEndpointConsumerBuilder backoffErrorThreshold(
                int backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default JpaEndpointConsumerBuilder backoffErrorThreshold(
                String backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default JpaEndpointConsumerBuilder backoffIdleThreshold(
                int backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default JpaEndpointConsumerBuilder backoffIdleThreshold(
                String backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default JpaEndpointConsumerBuilder backoffMultiplier(
                int backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default JpaEndpointConsumerBuilder backoffMultiplier(
                String backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * Milliseconds before the next poll. You can also specify time values
         * using units, such as 60s (60 seconds), 5m30s (5 minutes and 30
         * seconds), and 1h (1 hour).
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: scheduler
         */
        default JpaEndpointConsumerBuilder delay(long delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * Milliseconds before the next poll. You can also specify time values
         * using units, such as 60s (60 seconds), 5m30s (5 minutes and 30
         * seconds), and 1h (1 hour).
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: scheduler
         */
        default JpaEndpointConsumerBuilder delay(String delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default JpaEndpointConsumerBuilder greedy(boolean greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default JpaEndpointConsumerBuilder greedy(String greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * Milliseconds before the first poll starts. You can also specify time
         * values using units, such as 60s (60 seconds), 5m30s (5 minutes and 30
         * seconds), and 1h (1 hour).
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: scheduler
         */
        default JpaEndpointConsumerBuilder initialDelay(long initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Milliseconds before the first poll starts. You can also specify time
         * values using units, such as 60s (60 seconds), 5m30s (5 minutes and 30
         * seconds), and 1h (1 hour).
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: scheduler
         */
        default JpaEndpointConsumerBuilder initialDelay(String initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option is a: <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Group: scheduler
         */
        default JpaEndpointConsumerBuilder runLoggingLevel(
                LoggingLevel runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Group: scheduler
         */
        default JpaEndpointConsumerBuilder runLoggingLevel(
                String runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option is a:
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         */
        default JpaEndpointConsumerBuilder scheduledExecutorService(
                ScheduledExecutorService scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         */
        default JpaEndpointConsumerBuilder scheduledExecutorService(
                String scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: scheduler
         */
        default JpaEndpointConsumerBuilder scheduler(String scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: scheduler
         */
        default JpaEndpointConsumerBuilder schedulerProperties(
                Map<String, Object> schedulerProperties) {
            doSetProperty("schedulerProperties", schedulerProperties);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: scheduler
         */
        default JpaEndpointConsumerBuilder schedulerProperties(
                String schedulerProperties) {
            doSetProperty("schedulerProperties", schedulerProperties);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default JpaEndpointConsumerBuilder startScheduler(boolean startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default JpaEndpointConsumerBuilder startScheduler(String startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option is a: <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Group: scheduler
         */
        default JpaEndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Group: scheduler
         */
        default JpaEndpointConsumerBuilder timeUnit(String timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default JpaEndpointConsumerBuilder useFixedDelay(boolean useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default JpaEndpointConsumerBuilder useFixedDelay(String useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the JPA component.
     */
    public interface AdvancedJpaEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default JpaEndpointConsumerBuilder basic() {
            return (JpaEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedJpaEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedJpaEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedJpaEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedJpaEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * This key/value mapping is used for building the query parameters. It
         * is expected to be of the generic type java.util.Map where the keys
         * are the named parameters of a given JPA query and the values are
         * their corresponding effective values you want to select for. When
         * it's used for producer, Simple expression can be used as a parameter
         * value. It allows you to retrieve parameter values from the message
         * body, header and etc.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedJpaEndpointConsumerBuilder parameters(
                Map<String, Object> parameters) {
            doSetProperty("parameters", parameters);
            return this;
        }
        /**
         * This key/value mapping is used for building the query parameters. It
         * is expected to be of the generic type java.util.Map where the keys
         * are the named parameters of a given JPA query and the values are
         * their corresponding effective values you want to select for. When
         * it's used for producer, Simple expression can be used as a parameter
         * value. It allows you to retrieve parameter values from the message
         * body, header and etc.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedJpaEndpointConsumerBuilder parameters(String parameters) {
            doSetProperty("parameters", parameters);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedJpaEndpointConsumerBuilder pollStrategy(
                PollingConsumerPollStrategy pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedJpaEndpointConsumerBuilder pollStrategy(
                String pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJpaEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJpaEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Additional properties for the entity manager to use.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJpaEndpointConsumerBuilder entityManagerProperties(
                Map<String, Object> entityManagerProperties) {
            doSetProperty("entityManagerProperties", entityManagerProperties);
            return this;
        }
        /**
         * Additional properties for the entity manager to use.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedJpaEndpointConsumerBuilder entityManagerProperties(
                String entityManagerProperties) {
            doSetProperty("entityManagerProperties", entityManagerProperties);
            return this;
        }
        /**
         * Whether to use Spring's SharedEntityManager for the
         * consumer/producer. Note in most cases joinTransaction should be set
         * to false as this is not an EXTENDED EntityManager.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJpaEndpointConsumerBuilder sharedEntityManager(
                boolean sharedEntityManager) {
            doSetProperty("sharedEntityManager", sharedEntityManager);
            return this;
        }
        /**
         * Whether to use Spring's SharedEntityManager for the
         * consumer/producer. Note in most cases joinTransaction should be set
         * to false as this is not an EXTENDED EntityManager.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJpaEndpointConsumerBuilder sharedEntityManager(
                String sharedEntityManager) {
            doSetProperty("sharedEntityManager", sharedEntityManager);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJpaEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJpaEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the JPA component.
     */
    public interface JpaEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedJpaEndpointProducerBuilder advanced() {
            return (AdvancedJpaEndpointProducerBuilder) this;
        }
        /**
         * The camel-jpa component will join transaction by default. You can use
         * this option to turn this off, for example if you use LOCAL_RESOURCE
         * and join transaction doesn't work with your JPA provider. This option
         * can also be set globally on the JpaComponent, instead of having to
         * set it on all endpoints.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default JpaEndpointProducerBuilder joinTransaction(
                boolean joinTransaction) {
            doSetProperty("joinTransaction", joinTransaction);
            return this;
        }
        /**
         * The camel-jpa component will join transaction by default. You can use
         * this option to turn this off, for example if you use LOCAL_RESOURCE
         * and join transaction doesn't work with your JPA provider. This option
         * can also be set globally on the JpaComponent, instead of having to
         * set it on all endpoints.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default JpaEndpointProducerBuilder joinTransaction(
                String joinTransaction) {
            doSetProperty("joinTransaction", joinTransaction);
            return this;
        }
        /**
         * Set the maximum number of results to retrieve on the Query.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default JpaEndpointProducerBuilder maximumResults(int maximumResults) {
            doSetProperty("maximumResults", maximumResults);
            return this;
        }
        /**
         * Set the maximum number of results to retrieve on the Query.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default JpaEndpointProducerBuilder maximumResults(String maximumResults) {
            doSetProperty("maximumResults", maximumResults);
            return this;
        }
        /**
         * To use a named query.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default JpaEndpointProducerBuilder namedQuery(String namedQuery) {
            doSetProperty("namedQuery", namedQuery);
            return this;
        }
        /**
         * To use a custom native query. You may want to use the option
         * resultClass also when using native queries.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default JpaEndpointProducerBuilder nativeQuery(String nativeQuery) {
            doSetProperty("nativeQuery", nativeQuery);
            return this;
        }
        /**
         * The JPA persistence unit used by default.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: common
         */
        default JpaEndpointProducerBuilder persistenceUnit(
                String persistenceUnit) {
            doSetProperty("persistenceUnit", persistenceUnit);
            return this;
        }
        /**
         * To use a custom query.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default JpaEndpointProducerBuilder query(String query) {
            doSetProperty("query", query);
            return this;
        }
        /**
         * Defines the type of the returned payload (we will call
         * entityManager.createNativeQuery(nativeQuery, resultClass) instead of
         * entityManager.createNativeQuery(nativeQuery)). Without this option,
         * we will return an object array. Only has an affect when using in
         * conjunction with native query when consuming data.
         * 
         * The option is a: <code>java.lang.Class&lt;java.lang.Object&gt;</code>
         * type.
         * 
         * Group: common
         */
        default JpaEndpointProducerBuilder resultClass(Class<Object> resultClass) {
            doSetProperty("resultClass", resultClass);
            return this;
        }
        /**
         * Defines the type of the returned payload (we will call
         * entityManager.createNativeQuery(nativeQuery, resultClass) instead of
         * entityManager.createNativeQuery(nativeQuery)). Without this option,
         * we will return an object array. Only has an affect when using in
         * conjunction with native query when consuming data.
         * 
         * The option will be converted to a
         * <code>java.lang.Class&lt;java.lang.Object&gt;</code> type.
         * 
         * Group: common
         */
        default JpaEndpointProducerBuilder resultClass(String resultClass) {
            doSetProperty("resultClass", resultClass);
            return this;
        }
        /**
         * If enabled then the producer will find a single entity by using the
         * message body as key and entityType as the class type. This can be
         * used instead of a query to find a single entity.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default JpaEndpointProducerBuilder findEntity(boolean findEntity) {
            doSetProperty("findEntity", findEntity);
            return this;
        }
        /**
         * If enabled then the producer will find a single entity by using the
         * message body as key and entityType as the class type. This can be
         * used instead of a query to find a single entity.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default JpaEndpointProducerBuilder findEntity(String findEntity) {
            doSetProperty("findEntity", findEntity);
            return this;
        }
        /**
         * Flushes the EntityManager after the entity bean has been persisted.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default JpaEndpointProducerBuilder flushOnSend(boolean flushOnSend) {
            doSetProperty("flushOnSend", flushOnSend);
            return this;
        }
        /**
         * Flushes the EntityManager after the entity bean has been persisted.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default JpaEndpointProducerBuilder flushOnSend(String flushOnSend) {
            doSetProperty("flushOnSend", flushOnSend);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default JpaEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default JpaEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Indicates to use entityManager.remove(entity).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default JpaEndpointProducerBuilder remove(boolean remove) {
            doSetProperty("remove", remove);
            return this;
        }
        /**
         * Indicates to use entityManager.remove(entity).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default JpaEndpointProducerBuilder remove(String remove) {
            doSetProperty("remove", remove);
            return this;
        }
        /**
         * To configure whether to use executeUpdate() when producer executes a
         * query. When you use INSERT, UPDATE or DELETE statement as a named
         * query, you need to specify this option to 'true'.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: producer
         */
        default JpaEndpointProducerBuilder useExecuteUpdate(
                Boolean useExecuteUpdate) {
            doSetProperty("useExecuteUpdate", useExecuteUpdate);
            return this;
        }
        /**
         * To configure whether to use executeUpdate() when producer executes a
         * query. When you use INSERT, UPDATE or DELETE statement as a named
         * query, you need to specify this option to 'true'.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: producer
         */
        default JpaEndpointProducerBuilder useExecuteUpdate(
                String useExecuteUpdate) {
            doSetProperty("useExecuteUpdate", useExecuteUpdate);
            return this;
        }
        /**
         * Indicates to use entityManager.persist(entity) instead of
         * entityManager.merge(entity). Note: entityManager.persist(entity)
         * doesn't work for detached entities (where the EntityManager has to
         * execute an UPDATE instead of an INSERT query)!.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default JpaEndpointProducerBuilder usePersist(boolean usePersist) {
            doSetProperty("usePersist", usePersist);
            return this;
        }
        /**
         * Indicates to use entityManager.persist(entity) instead of
         * entityManager.merge(entity). Note: entityManager.persist(entity)
         * doesn't work for detached entities (where the EntityManager has to
         * execute an UPDATE instead of an INSERT query)!.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default JpaEndpointProducerBuilder usePersist(String usePersist) {
            doSetProperty("usePersist", usePersist);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the JPA component.
     */
    public interface AdvancedJpaEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default JpaEndpointProducerBuilder basic() {
            return (JpaEndpointProducerBuilder) this;
        }
        /**
         * If set to true, then Camel will use the EntityManager from the header
         * JpaConstants.ENTITY_MANAGER instead of the configured entity manager
         * on the component/endpoint. This allows end users to control which
         * entity manager will be in use.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer (advanced)
         */
        default AdvancedJpaEndpointProducerBuilder usePassedInEntityManager(
                boolean usePassedInEntityManager) {
            doSetProperty("usePassedInEntityManager", usePassedInEntityManager);
            return this;
        }
        /**
         * If set to true, then Camel will use the EntityManager from the header
         * JpaConstants.ENTITY_MANAGER instead of the configured entity manager
         * on the component/endpoint. This allows end users to control which
         * entity manager will be in use.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer (advanced)
         */
        default AdvancedJpaEndpointProducerBuilder usePassedInEntityManager(
                String usePassedInEntityManager) {
            doSetProperty("usePassedInEntityManager", usePassedInEntityManager);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJpaEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJpaEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Additional properties for the entity manager to use.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJpaEndpointProducerBuilder entityManagerProperties(
                Map<String, Object> entityManagerProperties) {
            doSetProperty("entityManagerProperties", entityManagerProperties);
            return this;
        }
        /**
         * Additional properties for the entity manager to use.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedJpaEndpointProducerBuilder entityManagerProperties(
                String entityManagerProperties) {
            doSetProperty("entityManagerProperties", entityManagerProperties);
            return this;
        }
        /**
         * Whether to use Spring's SharedEntityManager for the
         * consumer/producer. Note in most cases joinTransaction should be set
         * to false as this is not an EXTENDED EntityManager.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJpaEndpointProducerBuilder sharedEntityManager(
                boolean sharedEntityManager) {
            doSetProperty("sharedEntityManager", sharedEntityManager);
            return this;
        }
        /**
         * Whether to use Spring's SharedEntityManager for the
         * consumer/producer. Note in most cases joinTransaction should be set
         * to false as this is not an EXTENDED EntityManager.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJpaEndpointProducerBuilder sharedEntityManager(
                String sharedEntityManager) {
            doSetProperty("sharedEntityManager", sharedEntityManager);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJpaEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJpaEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the JPA component.
     */
    public interface JpaEndpointBuilder
            extends
                JpaEndpointConsumerBuilder, JpaEndpointProducerBuilder {
        default AdvancedJpaEndpointBuilder advanced() {
            return (AdvancedJpaEndpointBuilder) this;
        }
        /**
         * The camel-jpa component will join transaction by default. You can use
         * this option to turn this off, for example if you use LOCAL_RESOURCE
         * and join transaction doesn't work with your JPA provider. This option
         * can also be set globally on the JpaComponent, instead of having to
         * set it on all endpoints.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default JpaEndpointBuilder joinTransaction(boolean joinTransaction) {
            doSetProperty("joinTransaction", joinTransaction);
            return this;
        }
        /**
         * The camel-jpa component will join transaction by default. You can use
         * this option to turn this off, for example if you use LOCAL_RESOURCE
         * and join transaction doesn't work with your JPA provider. This option
         * can also be set globally on the JpaComponent, instead of having to
         * set it on all endpoints.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default JpaEndpointBuilder joinTransaction(String joinTransaction) {
            doSetProperty("joinTransaction", joinTransaction);
            return this;
        }
        /**
         * Set the maximum number of results to retrieve on the Query.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default JpaEndpointBuilder maximumResults(int maximumResults) {
            doSetProperty("maximumResults", maximumResults);
            return this;
        }
        /**
         * Set the maximum number of results to retrieve on the Query.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default JpaEndpointBuilder maximumResults(String maximumResults) {
            doSetProperty("maximumResults", maximumResults);
            return this;
        }
        /**
         * To use a named query.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default JpaEndpointBuilder namedQuery(String namedQuery) {
            doSetProperty("namedQuery", namedQuery);
            return this;
        }
        /**
         * To use a custom native query. You may want to use the option
         * resultClass also when using native queries.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default JpaEndpointBuilder nativeQuery(String nativeQuery) {
            doSetProperty("nativeQuery", nativeQuery);
            return this;
        }
        /**
         * The JPA persistence unit used by default.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: common
         */
        default JpaEndpointBuilder persistenceUnit(String persistenceUnit) {
            doSetProperty("persistenceUnit", persistenceUnit);
            return this;
        }
        /**
         * To use a custom query.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default JpaEndpointBuilder query(String query) {
            doSetProperty("query", query);
            return this;
        }
        /**
         * Defines the type of the returned payload (we will call
         * entityManager.createNativeQuery(nativeQuery, resultClass) instead of
         * entityManager.createNativeQuery(nativeQuery)). Without this option,
         * we will return an object array. Only has an affect when using in
         * conjunction with native query when consuming data.
         * 
         * The option is a: <code>java.lang.Class&lt;java.lang.Object&gt;</code>
         * type.
         * 
         * Group: common
         */
        default JpaEndpointBuilder resultClass(Class<Object> resultClass) {
            doSetProperty("resultClass", resultClass);
            return this;
        }
        /**
         * Defines the type of the returned payload (we will call
         * entityManager.createNativeQuery(nativeQuery, resultClass) instead of
         * entityManager.createNativeQuery(nativeQuery)). Without this option,
         * we will return an object array. Only has an affect when using in
         * conjunction with native query when consuming data.
         * 
         * The option will be converted to a
         * <code>java.lang.Class&lt;java.lang.Object&gt;</code> type.
         * 
         * Group: common
         */
        default JpaEndpointBuilder resultClass(String resultClass) {
            doSetProperty("resultClass", resultClass);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the JPA component.
     */
    public interface AdvancedJpaEndpointBuilder
            extends
                AdvancedJpaEndpointConsumerBuilder, AdvancedJpaEndpointProducerBuilder {
        default JpaEndpointBuilder basic() {
            return (JpaEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJpaEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJpaEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Additional properties for the entity manager to use.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJpaEndpointBuilder entityManagerProperties(
                Map<String, Object> entityManagerProperties) {
            doSetProperty("entityManagerProperties", entityManagerProperties);
            return this;
        }
        /**
         * Additional properties for the entity manager to use.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedJpaEndpointBuilder entityManagerProperties(
                String entityManagerProperties) {
            doSetProperty("entityManagerProperties", entityManagerProperties);
            return this;
        }
        /**
         * Whether to use Spring's SharedEntityManager for the
         * consumer/producer. Note in most cases joinTransaction should be set
         * to false as this is not an EXTENDED EntityManager.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJpaEndpointBuilder sharedEntityManager(
                boolean sharedEntityManager) {
            doSetProperty("sharedEntityManager", sharedEntityManager);
            return this;
        }
        /**
         * Whether to use Spring's SharedEntityManager for the
         * consumer/producer. Note in most cases joinTransaction should be set
         * to false as this is not an EXTENDED EntityManager.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJpaEndpointBuilder sharedEntityManager(
                String sharedEntityManager) {
            doSetProperty("sharedEntityManager", sharedEntityManager);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJpaEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedJpaEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Proxy enum for <code>javax.persistence.LockModeType</code> enum.
     */
    enum LockModeType {
        READ,
        WRITE,
        OPTIMISTIC,
        OPTIMISTIC_FORCE_INCREMENT,
        PESSIMISTIC_READ,
        PESSIMISTIC_WRITE,
        PESSIMISTIC_FORCE_INCREMENT,
        NONE;
    }
    /**
     * JPA (camel-jpa)
     * The jpa component enables you to store and retrieve Java objects from
     * databases using JPA.
     * 
     * Category: database,sql
     * Available as of version: 1.0
     * Maven coordinates: org.apache.camel:camel-jpa
     * 
     * Syntax: <code>jpa:entityType</code>
     * 
     * Path parameter: entityType (required)
     * The JPA annotated class to use as entity.
     */
    default JpaEndpointBuilder jpa(String path) {
        class JpaEndpointBuilderImpl extends AbstractEndpointBuilder implements JpaEndpointBuilder, AdvancedJpaEndpointBuilder {
            public JpaEndpointBuilderImpl(String path) {
                super("jpa", path);
            }
        }
        return new JpaEndpointBuilderImpl(path);
    }
}