/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * The irc component implements an IRC (Internet Relay Chat) transport.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface IrcEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the IRC component.
     */
    public interface IrcEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedIrcEndpointConsumerBuilder advanced() {
            return (AdvancedIrcEndpointConsumerBuilder) this;
        }
        /**
         * Whether to auto re-join when being kicked.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default IrcEndpointConsumerBuilder autoRejoin(boolean autoRejoin) {
            doSetProperty("autoRejoin", autoRejoin);
            return this;
        }
        /**
         * Whether to auto re-join when being kicked.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default IrcEndpointConsumerBuilder autoRejoin(String autoRejoin) {
            doSetProperty("autoRejoin", autoRejoin);
            return this;
        }
        /**
         * Delay in milliseconds before sending commands after the connection is
         * established.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: common
         */
        default IrcEndpointConsumerBuilder commandTimeout(long commandTimeout) {
            doSetProperty("commandTimeout", commandTimeout);
            return this;
        }
        /**
         * Delay in milliseconds before sending commands after the connection is
         * established.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: common
         */
        default IrcEndpointConsumerBuilder commandTimeout(String commandTimeout) {
            doSetProperty("commandTimeout", commandTimeout);
            return this;
        }
        /**
         * Sends NAMES command to channel after joining it. onReply has to be
         * true in order to process the result which will have the header value
         * irc.num = '353'.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default IrcEndpointConsumerBuilder namesOnJoin(boolean namesOnJoin) {
            doSetProperty("namesOnJoin", namesOnJoin);
            return this;
        }
        /**
         * Sends NAMES command to channel after joining it. onReply has to be
         * true in order to process the result which will have the header value
         * irc.num = '353'.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default IrcEndpointConsumerBuilder namesOnJoin(String namesOnJoin) {
            doSetProperty("namesOnJoin", namesOnJoin);
            return this;
        }
        /**
         * The nickname used in chat.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default IrcEndpointConsumerBuilder nickname(String nickname) {
            doSetProperty("nickname", nickname);
            return this;
        }
        /**
         * Use persistent messages.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        @Deprecated
        default IrcEndpointConsumerBuilder persistent(boolean persistent) {
            doSetProperty("persistent", persistent);
            return this;
        }
        /**
         * Use persistent messages.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        @Deprecated
        default IrcEndpointConsumerBuilder persistent(String persistent) {
            doSetProperty("persistent", persistent);
            return this;
        }
        /**
         * The IRC user's actual name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default IrcEndpointConsumerBuilder realname(String realname) {
            doSetProperty("realname", realname);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default IrcEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default IrcEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Handle user join events.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointConsumerBuilder onJoin(boolean onJoin) {
            doSetProperty("onJoin", onJoin);
            return this;
        }
        /**
         * Handle user join events.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointConsumerBuilder onJoin(String onJoin) {
            doSetProperty("onJoin", onJoin);
            return this;
        }
        /**
         * Handle kick events.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointConsumerBuilder onKick(boolean onKick) {
            doSetProperty("onKick", onKick);
            return this;
        }
        /**
         * Handle kick events.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointConsumerBuilder onKick(String onKick) {
            doSetProperty("onKick", onKick);
            return this;
        }
        /**
         * Handle mode change events.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointConsumerBuilder onMode(boolean onMode) {
            doSetProperty("onMode", onMode);
            return this;
        }
        /**
         * Handle mode change events.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointConsumerBuilder onMode(String onMode) {
            doSetProperty("onMode", onMode);
            return this;
        }
        /**
         * Handle nickname change events.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointConsumerBuilder onNick(boolean onNick) {
            doSetProperty("onNick", onNick);
            return this;
        }
        /**
         * Handle nickname change events.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointConsumerBuilder onNick(String onNick) {
            doSetProperty("onNick", onNick);
            return this;
        }
        /**
         * Handle user part events.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointConsumerBuilder onPart(boolean onPart) {
            doSetProperty("onPart", onPart);
            return this;
        }
        /**
         * Handle user part events.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointConsumerBuilder onPart(String onPart) {
            doSetProperty("onPart", onPart);
            return this;
        }
        /**
         * Handle private message events.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointConsumerBuilder onPrivmsg(boolean onPrivmsg) {
            doSetProperty("onPrivmsg", onPrivmsg);
            return this;
        }
        /**
         * Handle private message events.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointConsumerBuilder onPrivmsg(String onPrivmsg) {
            doSetProperty("onPrivmsg", onPrivmsg);
            return this;
        }
        /**
         * Handle user quit events.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointConsumerBuilder onQuit(boolean onQuit) {
            doSetProperty("onQuit", onQuit);
            return this;
        }
        /**
         * Handle user quit events.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointConsumerBuilder onQuit(String onQuit) {
            doSetProperty("onQuit", onQuit);
            return this;
        }
        /**
         * Whether or not to handle general responses to commands or
         * informational messages.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointConsumerBuilder onReply(boolean onReply) {
            doSetProperty("onReply", onReply);
            return this;
        }
        /**
         * Whether or not to handle general responses to commands or
         * informational messages.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointConsumerBuilder onReply(String onReply) {
            doSetProperty("onReply", onReply);
            return this;
        }
        /**
         * Handle topic change events.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointConsumerBuilder onTopic(boolean onTopic) {
            doSetProperty("onTopic", onTopic);
            return this;
        }
        /**
         * Handle topic change events.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointConsumerBuilder onTopic(String onTopic) {
            doSetProperty("onTopic", onTopic);
            return this;
        }
        /**
         * Your IRC server nickname password.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default IrcEndpointConsumerBuilder nickPassword(String nickPassword) {
            doSetProperty("nickPassword", nickPassword);
            return this;
        }
        /**
         * The IRC server password.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default IrcEndpointConsumerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Used for configuring security using SSL. Reference to a
         * org.apache.camel.support.jsse.SSLContextParameters in the Registry.
         * This reference overrides any configured SSLContextParameters at the
         * component level. Note that this setting overrides the trustManager
         * option.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default IrcEndpointConsumerBuilder sslContextParameters(
                Object sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * Used for configuring security using SSL. Reference to a
         * org.apache.camel.support.jsse.SSLContextParameters in the Registry.
         * This reference overrides any configured SSLContextParameters at the
         * component level. Note that this setting overrides the trustManager
         * option.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default IrcEndpointConsumerBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * The trust manager used to verify the SSL server's certificate.
         * 
         * The option is a:
         * <code>org.schwering.irc.lib.ssl.SSLTrustManager</code> type.
         * 
         * Group: security
         */
        default IrcEndpointConsumerBuilder trustManager(Object trustManager) {
            doSetProperty("trustManager", trustManager);
            return this;
        }
        /**
         * The trust manager used to verify the SSL server's certificate.
         * 
         * The option will be converted to a
         * <code>org.schwering.irc.lib.ssl.SSLTrustManager</code> type.
         * 
         * Group: security
         */
        default IrcEndpointConsumerBuilder trustManager(String trustManager) {
            doSetProperty("trustManager", trustManager);
            return this;
        }
        /**
         * The IRC server user name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default IrcEndpointConsumerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the IRC component.
     */
    public interface AdvancedIrcEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default IrcEndpointConsumerBuilder basic() {
            return (IrcEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedIrcEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedIrcEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedIrcEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedIrcEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedIrcEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedIrcEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether or not the server supports color codes.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedIrcEndpointConsumerBuilder colors(boolean colors) {
            doSetProperty("colors", colors);
            return this;
        }
        /**
         * Whether or not the server supports color codes.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedIrcEndpointConsumerBuilder colors(String colors) {
            doSetProperty("colors", colors);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedIrcEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedIrcEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the IRC component.
     */
    public interface IrcEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedIrcEndpointProducerBuilder advanced() {
            return (AdvancedIrcEndpointProducerBuilder) this;
        }
        /**
         * Whether to auto re-join when being kicked.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default IrcEndpointProducerBuilder autoRejoin(boolean autoRejoin) {
            doSetProperty("autoRejoin", autoRejoin);
            return this;
        }
        /**
         * Whether to auto re-join when being kicked.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default IrcEndpointProducerBuilder autoRejoin(String autoRejoin) {
            doSetProperty("autoRejoin", autoRejoin);
            return this;
        }
        /**
         * Delay in milliseconds before sending commands after the connection is
         * established.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: common
         */
        default IrcEndpointProducerBuilder commandTimeout(long commandTimeout) {
            doSetProperty("commandTimeout", commandTimeout);
            return this;
        }
        /**
         * Delay in milliseconds before sending commands after the connection is
         * established.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: common
         */
        default IrcEndpointProducerBuilder commandTimeout(String commandTimeout) {
            doSetProperty("commandTimeout", commandTimeout);
            return this;
        }
        /**
         * Sends NAMES command to channel after joining it. onReply has to be
         * true in order to process the result which will have the header value
         * irc.num = '353'.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default IrcEndpointProducerBuilder namesOnJoin(boolean namesOnJoin) {
            doSetProperty("namesOnJoin", namesOnJoin);
            return this;
        }
        /**
         * Sends NAMES command to channel after joining it. onReply has to be
         * true in order to process the result which will have the header value
         * irc.num = '353'.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default IrcEndpointProducerBuilder namesOnJoin(String namesOnJoin) {
            doSetProperty("namesOnJoin", namesOnJoin);
            return this;
        }
        /**
         * The nickname used in chat.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default IrcEndpointProducerBuilder nickname(String nickname) {
            doSetProperty("nickname", nickname);
            return this;
        }
        /**
         * Use persistent messages.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        @Deprecated
        default IrcEndpointProducerBuilder persistent(boolean persistent) {
            doSetProperty("persistent", persistent);
            return this;
        }
        /**
         * Use persistent messages.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        @Deprecated
        default IrcEndpointProducerBuilder persistent(String persistent) {
            doSetProperty("persistent", persistent);
            return this;
        }
        /**
         * The IRC user's actual name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default IrcEndpointProducerBuilder realname(String realname) {
            doSetProperty("realname", realname);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default IrcEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default IrcEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Handle user join events.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointProducerBuilder onJoin(boolean onJoin) {
            doSetProperty("onJoin", onJoin);
            return this;
        }
        /**
         * Handle user join events.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointProducerBuilder onJoin(String onJoin) {
            doSetProperty("onJoin", onJoin);
            return this;
        }
        /**
         * Handle kick events.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointProducerBuilder onKick(boolean onKick) {
            doSetProperty("onKick", onKick);
            return this;
        }
        /**
         * Handle kick events.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointProducerBuilder onKick(String onKick) {
            doSetProperty("onKick", onKick);
            return this;
        }
        /**
         * Handle mode change events.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointProducerBuilder onMode(boolean onMode) {
            doSetProperty("onMode", onMode);
            return this;
        }
        /**
         * Handle mode change events.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointProducerBuilder onMode(String onMode) {
            doSetProperty("onMode", onMode);
            return this;
        }
        /**
         * Handle nickname change events.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointProducerBuilder onNick(boolean onNick) {
            doSetProperty("onNick", onNick);
            return this;
        }
        /**
         * Handle nickname change events.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointProducerBuilder onNick(String onNick) {
            doSetProperty("onNick", onNick);
            return this;
        }
        /**
         * Handle user part events.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointProducerBuilder onPart(boolean onPart) {
            doSetProperty("onPart", onPart);
            return this;
        }
        /**
         * Handle user part events.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointProducerBuilder onPart(String onPart) {
            doSetProperty("onPart", onPart);
            return this;
        }
        /**
         * Handle private message events.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointProducerBuilder onPrivmsg(boolean onPrivmsg) {
            doSetProperty("onPrivmsg", onPrivmsg);
            return this;
        }
        /**
         * Handle private message events.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointProducerBuilder onPrivmsg(String onPrivmsg) {
            doSetProperty("onPrivmsg", onPrivmsg);
            return this;
        }
        /**
         * Handle user quit events.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointProducerBuilder onQuit(boolean onQuit) {
            doSetProperty("onQuit", onQuit);
            return this;
        }
        /**
         * Handle user quit events.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointProducerBuilder onQuit(String onQuit) {
            doSetProperty("onQuit", onQuit);
            return this;
        }
        /**
         * Whether or not to handle general responses to commands or
         * informational messages.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointProducerBuilder onReply(boolean onReply) {
            doSetProperty("onReply", onReply);
            return this;
        }
        /**
         * Whether or not to handle general responses to commands or
         * informational messages.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointProducerBuilder onReply(String onReply) {
            doSetProperty("onReply", onReply);
            return this;
        }
        /**
         * Handle topic change events.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointProducerBuilder onTopic(boolean onTopic) {
            doSetProperty("onTopic", onTopic);
            return this;
        }
        /**
         * Handle topic change events.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointProducerBuilder onTopic(String onTopic) {
            doSetProperty("onTopic", onTopic);
            return this;
        }
        /**
         * Your IRC server nickname password.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default IrcEndpointProducerBuilder nickPassword(String nickPassword) {
            doSetProperty("nickPassword", nickPassword);
            return this;
        }
        /**
         * The IRC server password.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default IrcEndpointProducerBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Used for configuring security using SSL. Reference to a
         * org.apache.camel.support.jsse.SSLContextParameters in the Registry.
         * This reference overrides any configured SSLContextParameters at the
         * component level. Note that this setting overrides the trustManager
         * option.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default IrcEndpointProducerBuilder sslContextParameters(
                Object sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * Used for configuring security using SSL. Reference to a
         * org.apache.camel.support.jsse.SSLContextParameters in the Registry.
         * This reference overrides any configured SSLContextParameters at the
         * component level. Note that this setting overrides the trustManager
         * option.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default IrcEndpointProducerBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * The trust manager used to verify the SSL server's certificate.
         * 
         * The option is a:
         * <code>org.schwering.irc.lib.ssl.SSLTrustManager</code> type.
         * 
         * Group: security
         */
        default IrcEndpointProducerBuilder trustManager(Object trustManager) {
            doSetProperty("trustManager", trustManager);
            return this;
        }
        /**
         * The trust manager used to verify the SSL server's certificate.
         * 
         * The option will be converted to a
         * <code>org.schwering.irc.lib.ssl.SSLTrustManager</code> type.
         * 
         * Group: security
         */
        default IrcEndpointProducerBuilder trustManager(String trustManager) {
            doSetProperty("trustManager", trustManager);
            return this;
        }
        /**
         * The IRC server user name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default IrcEndpointProducerBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the IRC component.
     */
    public interface AdvancedIrcEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default IrcEndpointProducerBuilder basic() {
            return (IrcEndpointProducerBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedIrcEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedIrcEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether or not the server supports color codes.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedIrcEndpointProducerBuilder colors(boolean colors) {
            doSetProperty("colors", colors);
            return this;
        }
        /**
         * Whether or not the server supports color codes.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedIrcEndpointProducerBuilder colors(String colors) {
            doSetProperty("colors", colors);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedIrcEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedIrcEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the IRC component.
     */
    public interface IrcEndpointBuilder
            extends
                IrcEndpointConsumerBuilder, IrcEndpointProducerBuilder {
        default AdvancedIrcEndpointBuilder advanced() {
            return (AdvancedIrcEndpointBuilder) this;
        }
        /**
         * Whether to auto re-join when being kicked.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default IrcEndpointBuilder autoRejoin(boolean autoRejoin) {
            doSetProperty("autoRejoin", autoRejoin);
            return this;
        }
        /**
         * Whether to auto re-join when being kicked.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default IrcEndpointBuilder autoRejoin(String autoRejoin) {
            doSetProperty("autoRejoin", autoRejoin);
            return this;
        }
        /**
         * Delay in milliseconds before sending commands after the connection is
         * established.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: common
         */
        default IrcEndpointBuilder commandTimeout(long commandTimeout) {
            doSetProperty("commandTimeout", commandTimeout);
            return this;
        }
        /**
         * Delay in milliseconds before sending commands after the connection is
         * established.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: common
         */
        default IrcEndpointBuilder commandTimeout(String commandTimeout) {
            doSetProperty("commandTimeout", commandTimeout);
            return this;
        }
        /**
         * Sends NAMES command to channel after joining it. onReply has to be
         * true in order to process the result which will have the header value
         * irc.num = '353'.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default IrcEndpointBuilder namesOnJoin(boolean namesOnJoin) {
            doSetProperty("namesOnJoin", namesOnJoin);
            return this;
        }
        /**
         * Sends NAMES command to channel after joining it. onReply has to be
         * true in order to process the result which will have the header value
         * irc.num = '353'.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default IrcEndpointBuilder namesOnJoin(String namesOnJoin) {
            doSetProperty("namesOnJoin", namesOnJoin);
            return this;
        }
        /**
         * The nickname used in chat.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default IrcEndpointBuilder nickname(String nickname) {
            doSetProperty("nickname", nickname);
            return this;
        }
        /**
         * Use persistent messages.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        @Deprecated
        default IrcEndpointBuilder persistent(boolean persistent) {
            doSetProperty("persistent", persistent);
            return this;
        }
        /**
         * Use persistent messages.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        @Deprecated
        default IrcEndpointBuilder persistent(String persistent) {
            doSetProperty("persistent", persistent);
            return this;
        }
        /**
         * The IRC user's actual name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default IrcEndpointBuilder realname(String realname) {
            doSetProperty("realname", realname);
            return this;
        }
        /**
         * Handle user join events.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointBuilder onJoin(boolean onJoin) {
            doSetProperty("onJoin", onJoin);
            return this;
        }
        /**
         * Handle user join events.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointBuilder onJoin(String onJoin) {
            doSetProperty("onJoin", onJoin);
            return this;
        }
        /**
         * Handle kick events.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointBuilder onKick(boolean onKick) {
            doSetProperty("onKick", onKick);
            return this;
        }
        /**
         * Handle kick events.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointBuilder onKick(String onKick) {
            doSetProperty("onKick", onKick);
            return this;
        }
        /**
         * Handle mode change events.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointBuilder onMode(boolean onMode) {
            doSetProperty("onMode", onMode);
            return this;
        }
        /**
         * Handle mode change events.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointBuilder onMode(String onMode) {
            doSetProperty("onMode", onMode);
            return this;
        }
        /**
         * Handle nickname change events.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointBuilder onNick(boolean onNick) {
            doSetProperty("onNick", onNick);
            return this;
        }
        /**
         * Handle nickname change events.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointBuilder onNick(String onNick) {
            doSetProperty("onNick", onNick);
            return this;
        }
        /**
         * Handle user part events.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointBuilder onPart(boolean onPart) {
            doSetProperty("onPart", onPart);
            return this;
        }
        /**
         * Handle user part events.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointBuilder onPart(String onPart) {
            doSetProperty("onPart", onPart);
            return this;
        }
        /**
         * Handle private message events.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointBuilder onPrivmsg(boolean onPrivmsg) {
            doSetProperty("onPrivmsg", onPrivmsg);
            return this;
        }
        /**
         * Handle private message events.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointBuilder onPrivmsg(String onPrivmsg) {
            doSetProperty("onPrivmsg", onPrivmsg);
            return this;
        }
        /**
         * Handle user quit events.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointBuilder onQuit(boolean onQuit) {
            doSetProperty("onQuit", onQuit);
            return this;
        }
        /**
         * Handle user quit events.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointBuilder onQuit(String onQuit) {
            doSetProperty("onQuit", onQuit);
            return this;
        }
        /**
         * Whether or not to handle general responses to commands or
         * informational messages.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointBuilder onReply(boolean onReply) {
            doSetProperty("onReply", onReply);
            return this;
        }
        /**
         * Whether or not to handle general responses to commands or
         * informational messages.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointBuilder onReply(String onReply) {
            doSetProperty("onReply", onReply);
            return this;
        }
        /**
         * Handle topic change events.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointBuilder onTopic(boolean onTopic) {
            doSetProperty("onTopic", onTopic);
            return this;
        }
        /**
         * Handle topic change events.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: filter
         */
        default IrcEndpointBuilder onTopic(String onTopic) {
            doSetProperty("onTopic", onTopic);
            return this;
        }
        /**
         * Your IRC server nickname password.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default IrcEndpointBuilder nickPassword(String nickPassword) {
            doSetProperty("nickPassword", nickPassword);
            return this;
        }
        /**
         * The IRC server password.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default IrcEndpointBuilder password(String password) {
            doSetProperty("password", password);
            return this;
        }
        /**
         * Used for configuring security using SSL. Reference to a
         * org.apache.camel.support.jsse.SSLContextParameters in the Registry.
         * This reference overrides any configured SSLContextParameters at the
         * component level. Note that this setting overrides the trustManager
         * option.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default IrcEndpointBuilder sslContextParameters(
                Object sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * Used for configuring security using SSL. Reference to a
         * org.apache.camel.support.jsse.SSLContextParameters in the Registry.
         * This reference overrides any configured SSLContextParameters at the
         * component level. Note that this setting overrides the trustManager
         * option.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default IrcEndpointBuilder sslContextParameters(
                String sslContextParameters) {
            doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * The trust manager used to verify the SSL server's certificate.
         * 
         * The option is a:
         * <code>org.schwering.irc.lib.ssl.SSLTrustManager</code> type.
         * 
         * Group: security
         */
        default IrcEndpointBuilder trustManager(Object trustManager) {
            doSetProperty("trustManager", trustManager);
            return this;
        }
        /**
         * The trust manager used to verify the SSL server's certificate.
         * 
         * The option will be converted to a
         * <code>org.schwering.irc.lib.ssl.SSLTrustManager</code> type.
         * 
         * Group: security
         */
        default IrcEndpointBuilder trustManager(String trustManager) {
            doSetProperty("trustManager", trustManager);
            return this;
        }
        /**
         * The IRC server user name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default IrcEndpointBuilder username(String username) {
            doSetProperty("username", username);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the IRC component.
     */
    public interface AdvancedIrcEndpointBuilder
            extends
                AdvancedIrcEndpointConsumerBuilder, AdvancedIrcEndpointProducerBuilder {
        default IrcEndpointBuilder basic() {
            return (IrcEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedIrcEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedIrcEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether or not the server supports color codes.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedIrcEndpointBuilder colors(boolean colors) {
            doSetProperty("colors", colors);
            return this;
        }
        /**
         * Whether or not the server supports color codes.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedIrcEndpointBuilder colors(String colors) {
            doSetProperty("colors", colors);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedIrcEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedIrcEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }
    /**
     * IRC (camel-irc)
     * The irc component implements an IRC (Internet Relay Chat) transport.
     * 
     * Category: chat
     * Available as of version: 1.1
     * Maven coordinates: org.apache.camel:camel-irc
     * 
     * Syntax: <code>irc:hostname:port</code>
     * 
     * Path parameter: hostname (required)
     * Hostname for the IRC chat server
     * 
     * Path parameter: port
     * Port number for the IRC chat server. If no port is configured then a
     * default port of either 6667, 6668 or 6669 is used.
     */
    default IrcEndpointBuilder irc(String path) {
        class IrcEndpointBuilderImpl extends AbstractEndpointBuilder implements IrcEndpointBuilder, AdvancedIrcEndpointBuilder {
            public IrcEndpointBuilderImpl(String path) {
                super("irc", path);
            }
        }
        return new IrcEndpointBuilderImpl(path);
    }
}