/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import javax.annotation.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * The grape component allows you to fetch, load and manage additional jars when
 * CamelContext is running.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface GrapeEndpointBuilderFactory {


    /**
     * Builder for endpoint for the Grape component.
     */
    public interface GrapeEndpointBuilder extends EndpointProducerBuilder {
        default AdvancedGrapeEndpointBuilder advanced() {
            return (AdvancedGrapeEndpointBuilder) this;
        }
    }

    /**
     * Advanced builder for endpoint for the Grape component.
     */
    public interface AdvancedGrapeEndpointBuilder
            extends
                EndpointProducerBuilder {
        default GrapeEndpointBuilder basic() {
            return (GrapeEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedGrapeEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedGrapeEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedGrapeEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedGrapeEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }
    /**
     * Grape (camel-grape)
     * The grape component allows you to fetch, load and manage additional jars
     * when CamelContext is running.
     * 
     * Category: management,deployment
     * Available as of version: 2.16
     * Maven coordinates: org.apache.camel:camel-grape
     * 
     * Syntax: <code>grape:defaultCoordinates</code>
     * 
     * Path parameter: defaultCoordinates (required)
     * Maven coordinates to use as default to grab if the message body is empty.
     */
    default GrapeEndpointBuilder grape(String path) {
        class GrapeEndpointBuilderImpl extends AbstractEndpointBuilder implements GrapeEndpointBuilder, AdvancedGrapeEndpointBuilder {
            public GrapeEndpointBuilderImpl(String path) {
                super("grape", path);
            }
        }
        return new GrapeEndpointBuilderImpl(path);
    }
}