/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.TimeZone;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * IEC 60870 component used for telecontrol (supervisory control and data
 * acquisition) such as controlling electric power transmission grids and other
 * geographically widespread control systems.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface ClientEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the IEC 60870 Client component.
     */
    public interface ClientEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedClientEndpointConsumerBuilder advanced() {
            return (AdvancedClientEndpointConsumerBuilder) this;
        }
        /**
         * Data module options.
         * 
         * The option is a:
         * <code>org.eclipse.neoscada.protocol.iec60870.client.data.DataModuleOptions</code> type.
         * 
         * Group: common
         */
        default ClientEndpointConsumerBuilder dataModuleOptions(
                Object dataModuleOptions) {
            doSetProperty("dataModuleOptions", dataModuleOptions);
            return this;
        }
        /**
         * Data module options.
         * 
         * The option will be converted to a
         * <code>org.eclipse.neoscada.protocol.iec60870.client.data.DataModuleOptions</code> type.
         * 
         * Group: common
         */
        default ClientEndpointConsumerBuilder dataModuleOptions(
                String dataModuleOptions) {
            doSetProperty("dataModuleOptions", dataModuleOptions);
            return this;
        }
        /**
         * Protocol options.
         * 
         * The option is a:
         * <code>org.eclipse.neoscada.protocol.iec60870.ProtocolOptions</code>
         * type.
         * 
         * Group: common
         */
        default ClientEndpointConsumerBuilder protocolOptions(
                Object protocolOptions) {
            doSetProperty("protocolOptions", protocolOptions);
            return this;
        }
        /**
         * Protocol options.
         * 
         * The option will be converted to a
         * <code>org.eclipse.neoscada.protocol.iec60870.ProtocolOptions</code>
         * type.
         * 
         * Group: common
         */
        default ClientEndpointConsumerBuilder protocolOptions(
                String protocolOptions) {
            doSetProperty("protocolOptions", protocolOptions);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default ClientEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default ClientEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Parameter W - Acknowledgment window.
         * 
         * The option is a: <code>short</code> type.
         * 
         * Group: connection
         */
        default ClientEndpointConsumerBuilder acknowledgeWindow(
                short acknowledgeWindow) {
            doSetProperty("acknowledgeWindow", acknowledgeWindow);
            return this;
        }
        /**
         * Parameter W - Acknowledgment window.
         * 
         * The option will be converted to a <code>short</code> type.
         * 
         * Group: connection
         */
        default ClientEndpointConsumerBuilder acknowledgeWindow(
                String acknowledgeWindow) {
            doSetProperty("acknowledgeWindow", acknowledgeWindow);
            return this;
        }
        /**
         * The common ASDU address size. May be either SIZE_1 or SIZE_2.
         * 
         * The option is a:
         * <code>org.eclipse.neoscada.protocol.iec60870.ASDUAddressType</code>
         * type.
         * 
         * Group: connection
         */
        default ClientEndpointConsumerBuilder adsuAddressType(
                ASDUAddressType adsuAddressType) {
            doSetProperty("adsuAddressType", adsuAddressType);
            return this;
        }
        /**
         * The common ASDU address size. May be either SIZE_1 or SIZE_2.
         * 
         * The option will be converted to a
         * <code>org.eclipse.neoscada.protocol.iec60870.ASDUAddressType</code>
         * type.
         * 
         * Group: connection
         */
        default ClientEndpointConsumerBuilder adsuAddressType(
                String adsuAddressType) {
            doSetProperty("adsuAddressType", adsuAddressType);
            return this;
        }
        /**
         * The cause of transmission type. May be either SIZE_1 or SIZE_2.
         * 
         * The option is a:
         * <code>org.eclipse.neoscada.protocol.iec60870.CauseOfTransmissionType</code> type.
         * 
         * Group: connection
         */
        default ClientEndpointConsumerBuilder causeOfTransmissionType(
                CauseOfTransmissionType causeOfTransmissionType) {
            doSetProperty("causeOfTransmissionType", causeOfTransmissionType);
            return this;
        }
        /**
         * The cause of transmission type. May be either SIZE_1 or SIZE_2.
         * 
         * The option will be converted to a
         * <code>org.eclipse.neoscada.protocol.iec60870.CauseOfTransmissionType</code> type.
         * 
         * Group: connection
         */
        default ClientEndpointConsumerBuilder causeOfTransmissionType(
                String causeOfTransmissionType) {
            doSetProperty("causeOfTransmissionType", causeOfTransmissionType);
            return this;
        }
        /**
         * The information address size. May be either SIZE_1, SIZE_2 or SIZE_3.
         * 
         * The option is a:
         * <code>org.eclipse.neoscada.protocol.iec60870.InformationObjectAddressType</code> type.
         * 
         * Group: connection
         */
        default ClientEndpointConsumerBuilder informationObjectAddressType(
                InformationObjectAddressType informationObjectAddressType) {
            doSetProperty("informationObjectAddressType", informationObjectAddressType);
            return this;
        }
        /**
         * The information address size. May be either SIZE_1, SIZE_2 or SIZE_3.
         * 
         * The option will be converted to a
         * <code>org.eclipse.neoscada.protocol.iec60870.InformationObjectAddressType</code> type.
         * 
         * Group: connection
         */
        default ClientEndpointConsumerBuilder informationObjectAddressType(
                String informationObjectAddressType) {
            doSetProperty("informationObjectAddressType", informationObjectAddressType);
            return this;
        }
        /**
         * Parameter K - Maximum number of un-acknowledged messages.
         * 
         * The option is a: <code>short</code> type.
         * 
         * Group: connection
         */
        default ClientEndpointConsumerBuilder maxUnacknowledged(
                short maxUnacknowledged) {
            doSetProperty("maxUnacknowledged", maxUnacknowledged);
            return this;
        }
        /**
         * Parameter K - Maximum number of un-acknowledged messages.
         * 
         * The option will be converted to a <code>short</code> type.
         * 
         * Group: connection
         */
        default ClientEndpointConsumerBuilder maxUnacknowledged(
                String maxUnacknowledged) {
            doSetProperty("maxUnacknowledged", maxUnacknowledged);
            return this;
        }
        /**
         * Timeout T1 in milliseconds.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: connection
         */
        default ClientEndpointConsumerBuilder timeout1(int timeout1) {
            doSetProperty("timeout1", timeout1);
            return this;
        }
        /**
         * Timeout T1 in milliseconds.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: connection
         */
        default ClientEndpointConsumerBuilder timeout1(String timeout1) {
            doSetProperty("timeout1", timeout1);
            return this;
        }
        /**
         * Timeout T2 in milliseconds.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: connection
         */
        default ClientEndpointConsumerBuilder timeout2(int timeout2) {
            doSetProperty("timeout2", timeout2);
            return this;
        }
        /**
         * Timeout T2 in milliseconds.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: connection
         */
        default ClientEndpointConsumerBuilder timeout2(String timeout2) {
            doSetProperty("timeout2", timeout2);
            return this;
        }
        /**
         * Timeout T3 in milliseconds.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: connection
         */
        default ClientEndpointConsumerBuilder timeout3(int timeout3) {
            doSetProperty("timeout3", timeout3);
            return this;
        }
        /**
         * Timeout T3 in milliseconds.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: connection
         */
        default ClientEndpointConsumerBuilder timeout3(String timeout3) {
            doSetProperty("timeout3", timeout3);
            return this;
        }
        /**
         * Whether to include the source address.
         * 
         * The option is a: <code>byte</code> type.
         * 
         * Group: data
         */
        default ClientEndpointConsumerBuilder causeSourceAddress(
                byte causeSourceAddress) {
            doSetProperty("causeSourceAddress", causeSourceAddress);
            return this;
        }
        /**
         * Whether to include the source address.
         * 
         * The option will be converted to a <code>byte</code> type.
         * 
         * Group: data
         */
        default ClientEndpointConsumerBuilder causeSourceAddress(
                String causeSourceAddress) {
            doSetProperty("causeSourceAddress", causeSourceAddress);
            return this;
        }
        /**
         * Whether background scan transmissions should be ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: data
         */
        default ClientEndpointConsumerBuilder ignoreBackgroundScan(
                boolean ignoreBackgroundScan) {
            doSetProperty("ignoreBackgroundScan", ignoreBackgroundScan);
            return this;
        }
        /**
         * Whether background scan transmissions should be ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: data
         */
        default ClientEndpointConsumerBuilder ignoreBackgroundScan(
                String ignoreBackgroundScan) {
            doSetProperty("ignoreBackgroundScan", ignoreBackgroundScan);
            return this;
        }
        /**
         * Whether to ignore or respect DST.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: data
         */
        default ClientEndpointConsumerBuilder ignoreDaylightSavingTime(
                boolean ignoreDaylightSavingTime) {
            doSetProperty("ignoreDaylightSavingTime", ignoreDaylightSavingTime);
            return this;
        }
        /**
         * Whether to ignore or respect DST.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: data
         */
        default ClientEndpointConsumerBuilder ignoreDaylightSavingTime(
                String ignoreDaylightSavingTime) {
            doSetProperty("ignoreDaylightSavingTime", ignoreDaylightSavingTime);
            return this;
        }
        /**
         * The timezone to use. May be any Java time zone string.
         * 
         * The option is a: <code>java.util.TimeZone</code> type.
         * 
         * Group: data
         */
        default ClientEndpointConsumerBuilder timeZone(TimeZone timeZone) {
            doSetProperty("timeZone", timeZone);
            return this;
        }
        /**
         * The timezone to use. May be any Java time zone string.
         * 
         * The option will be converted to a <code>java.util.TimeZone</code>
         * type.
         * 
         * Group: data
         */
        default ClientEndpointConsumerBuilder timeZone(String timeZone) {
            doSetProperty("timeZone", timeZone);
            return this;
        }
        /**
         * An identifier grouping connection instances.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: id
         */
        default ClientEndpointConsumerBuilder connectionId(String connectionId) {
            doSetProperty("connectionId", connectionId);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the IEC 60870 Client
     * component.
     */
    public interface AdvancedClientEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default ClientEndpointConsumerBuilder basic() {
            return (ClientEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedClientEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedClientEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedClientEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedClientEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedClientEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedClientEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedClientEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedClientEndpointConsumerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the IEC 60870 Client component.
     */
    public interface ClientEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedClientEndpointProducerBuilder advanced() {
            return (AdvancedClientEndpointProducerBuilder) this;
        }
        /**
         * Data module options.
         * 
         * The option is a:
         * <code>org.eclipse.neoscada.protocol.iec60870.client.data.DataModuleOptions</code> type.
         * 
         * Group: common
         */
        default ClientEndpointProducerBuilder dataModuleOptions(
                Object dataModuleOptions) {
            doSetProperty("dataModuleOptions", dataModuleOptions);
            return this;
        }
        /**
         * Data module options.
         * 
         * The option will be converted to a
         * <code>org.eclipse.neoscada.protocol.iec60870.client.data.DataModuleOptions</code> type.
         * 
         * Group: common
         */
        default ClientEndpointProducerBuilder dataModuleOptions(
                String dataModuleOptions) {
            doSetProperty("dataModuleOptions", dataModuleOptions);
            return this;
        }
        /**
         * Protocol options.
         * 
         * The option is a:
         * <code>org.eclipse.neoscada.protocol.iec60870.ProtocolOptions</code>
         * type.
         * 
         * Group: common
         */
        default ClientEndpointProducerBuilder protocolOptions(
                Object protocolOptions) {
            doSetProperty("protocolOptions", protocolOptions);
            return this;
        }
        /**
         * Protocol options.
         * 
         * The option will be converted to a
         * <code>org.eclipse.neoscada.protocol.iec60870.ProtocolOptions</code>
         * type.
         * 
         * Group: common
         */
        default ClientEndpointProducerBuilder protocolOptions(
                String protocolOptions) {
            doSetProperty("protocolOptions", protocolOptions);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default ClientEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default ClientEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Parameter W - Acknowledgment window.
         * 
         * The option is a: <code>short</code> type.
         * 
         * Group: connection
         */
        default ClientEndpointProducerBuilder acknowledgeWindow(
                short acknowledgeWindow) {
            doSetProperty("acknowledgeWindow", acknowledgeWindow);
            return this;
        }
        /**
         * Parameter W - Acknowledgment window.
         * 
         * The option will be converted to a <code>short</code> type.
         * 
         * Group: connection
         */
        default ClientEndpointProducerBuilder acknowledgeWindow(
                String acknowledgeWindow) {
            doSetProperty("acknowledgeWindow", acknowledgeWindow);
            return this;
        }
        /**
         * The common ASDU address size. May be either SIZE_1 or SIZE_2.
         * 
         * The option is a:
         * <code>org.eclipse.neoscada.protocol.iec60870.ASDUAddressType</code>
         * type.
         * 
         * Group: connection
         */
        default ClientEndpointProducerBuilder adsuAddressType(
                ASDUAddressType adsuAddressType) {
            doSetProperty("adsuAddressType", adsuAddressType);
            return this;
        }
        /**
         * The common ASDU address size. May be either SIZE_1 or SIZE_2.
         * 
         * The option will be converted to a
         * <code>org.eclipse.neoscada.protocol.iec60870.ASDUAddressType</code>
         * type.
         * 
         * Group: connection
         */
        default ClientEndpointProducerBuilder adsuAddressType(
                String adsuAddressType) {
            doSetProperty("adsuAddressType", adsuAddressType);
            return this;
        }
        /**
         * The cause of transmission type. May be either SIZE_1 or SIZE_2.
         * 
         * The option is a:
         * <code>org.eclipse.neoscada.protocol.iec60870.CauseOfTransmissionType</code> type.
         * 
         * Group: connection
         */
        default ClientEndpointProducerBuilder causeOfTransmissionType(
                CauseOfTransmissionType causeOfTransmissionType) {
            doSetProperty("causeOfTransmissionType", causeOfTransmissionType);
            return this;
        }
        /**
         * The cause of transmission type. May be either SIZE_1 or SIZE_2.
         * 
         * The option will be converted to a
         * <code>org.eclipse.neoscada.protocol.iec60870.CauseOfTransmissionType</code> type.
         * 
         * Group: connection
         */
        default ClientEndpointProducerBuilder causeOfTransmissionType(
                String causeOfTransmissionType) {
            doSetProperty("causeOfTransmissionType", causeOfTransmissionType);
            return this;
        }
        /**
         * The information address size. May be either SIZE_1, SIZE_2 or SIZE_3.
         * 
         * The option is a:
         * <code>org.eclipse.neoscada.protocol.iec60870.InformationObjectAddressType</code> type.
         * 
         * Group: connection
         */
        default ClientEndpointProducerBuilder informationObjectAddressType(
                InformationObjectAddressType informationObjectAddressType) {
            doSetProperty("informationObjectAddressType", informationObjectAddressType);
            return this;
        }
        /**
         * The information address size. May be either SIZE_1, SIZE_2 or SIZE_3.
         * 
         * The option will be converted to a
         * <code>org.eclipse.neoscada.protocol.iec60870.InformationObjectAddressType</code> type.
         * 
         * Group: connection
         */
        default ClientEndpointProducerBuilder informationObjectAddressType(
                String informationObjectAddressType) {
            doSetProperty("informationObjectAddressType", informationObjectAddressType);
            return this;
        }
        /**
         * Parameter K - Maximum number of un-acknowledged messages.
         * 
         * The option is a: <code>short</code> type.
         * 
         * Group: connection
         */
        default ClientEndpointProducerBuilder maxUnacknowledged(
                short maxUnacknowledged) {
            doSetProperty("maxUnacknowledged", maxUnacknowledged);
            return this;
        }
        /**
         * Parameter K - Maximum number of un-acknowledged messages.
         * 
         * The option will be converted to a <code>short</code> type.
         * 
         * Group: connection
         */
        default ClientEndpointProducerBuilder maxUnacknowledged(
                String maxUnacknowledged) {
            doSetProperty("maxUnacknowledged", maxUnacknowledged);
            return this;
        }
        /**
         * Timeout T1 in milliseconds.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: connection
         */
        default ClientEndpointProducerBuilder timeout1(int timeout1) {
            doSetProperty("timeout1", timeout1);
            return this;
        }
        /**
         * Timeout T1 in milliseconds.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: connection
         */
        default ClientEndpointProducerBuilder timeout1(String timeout1) {
            doSetProperty("timeout1", timeout1);
            return this;
        }
        /**
         * Timeout T2 in milliseconds.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: connection
         */
        default ClientEndpointProducerBuilder timeout2(int timeout2) {
            doSetProperty("timeout2", timeout2);
            return this;
        }
        /**
         * Timeout T2 in milliseconds.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: connection
         */
        default ClientEndpointProducerBuilder timeout2(String timeout2) {
            doSetProperty("timeout2", timeout2);
            return this;
        }
        /**
         * Timeout T3 in milliseconds.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: connection
         */
        default ClientEndpointProducerBuilder timeout3(int timeout3) {
            doSetProperty("timeout3", timeout3);
            return this;
        }
        /**
         * Timeout T3 in milliseconds.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: connection
         */
        default ClientEndpointProducerBuilder timeout3(String timeout3) {
            doSetProperty("timeout3", timeout3);
            return this;
        }
        /**
         * Whether to include the source address.
         * 
         * The option is a: <code>byte</code> type.
         * 
         * Group: data
         */
        default ClientEndpointProducerBuilder causeSourceAddress(
                byte causeSourceAddress) {
            doSetProperty("causeSourceAddress", causeSourceAddress);
            return this;
        }
        /**
         * Whether to include the source address.
         * 
         * The option will be converted to a <code>byte</code> type.
         * 
         * Group: data
         */
        default ClientEndpointProducerBuilder causeSourceAddress(
                String causeSourceAddress) {
            doSetProperty("causeSourceAddress", causeSourceAddress);
            return this;
        }
        /**
         * Whether background scan transmissions should be ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: data
         */
        default ClientEndpointProducerBuilder ignoreBackgroundScan(
                boolean ignoreBackgroundScan) {
            doSetProperty("ignoreBackgroundScan", ignoreBackgroundScan);
            return this;
        }
        /**
         * Whether background scan transmissions should be ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: data
         */
        default ClientEndpointProducerBuilder ignoreBackgroundScan(
                String ignoreBackgroundScan) {
            doSetProperty("ignoreBackgroundScan", ignoreBackgroundScan);
            return this;
        }
        /**
         * Whether to ignore or respect DST.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: data
         */
        default ClientEndpointProducerBuilder ignoreDaylightSavingTime(
                boolean ignoreDaylightSavingTime) {
            doSetProperty("ignoreDaylightSavingTime", ignoreDaylightSavingTime);
            return this;
        }
        /**
         * Whether to ignore or respect DST.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: data
         */
        default ClientEndpointProducerBuilder ignoreDaylightSavingTime(
                String ignoreDaylightSavingTime) {
            doSetProperty("ignoreDaylightSavingTime", ignoreDaylightSavingTime);
            return this;
        }
        /**
         * The timezone to use. May be any Java time zone string.
         * 
         * The option is a: <code>java.util.TimeZone</code> type.
         * 
         * Group: data
         */
        default ClientEndpointProducerBuilder timeZone(TimeZone timeZone) {
            doSetProperty("timeZone", timeZone);
            return this;
        }
        /**
         * The timezone to use. May be any Java time zone string.
         * 
         * The option will be converted to a <code>java.util.TimeZone</code>
         * type.
         * 
         * Group: data
         */
        default ClientEndpointProducerBuilder timeZone(String timeZone) {
            doSetProperty("timeZone", timeZone);
            return this;
        }
        /**
         * An identifier grouping connection instances.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: id
         */
        default ClientEndpointProducerBuilder connectionId(String connectionId) {
            doSetProperty("connectionId", connectionId);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the IEC 60870 Client
     * component.
     */
    public interface AdvancedClientEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default ClientEndpointProducerBuilder basic() {
            return (ClientEndpointProducerBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedClientEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedClientEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedClientEndpointProducerBuilder synchronous(
                boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedClientEndpointProducerBuilder synchronous(
                String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the IEC 60870 Client component.
     */
    public interface ClientEndpointBuilder
            extends
                ClientEndpointConsumerBuilder, ClientEndpointProducerBuilder {
        default AdvancedClientEndpointBuilder advanced() {
            return (AdvancedClientEndpointBuilder) this;
        }
        /**
         * Data module options.
         * 
         * The option is a:
         * <code>org.eclipse.neoscada.protocol.iec60870.client.data.DataModuleOptions</code> type.
         * 
         * Group: common
         */
        default ClientEndpointBuilder dataModuleOptions(Object dataModuleOptions) {
            doSetProperty("dataModuleOptions", dataModuleOptions);
            return this;
        }
        /**
         * Data module options.
         * 
         * The option will be converted to a
         * <code>org.eclipse.neoscada.protocol.iec60870.client.data.DataModuleOptions</code> type.
         * 
         * Group: common
         */
        default ClientEndpointBuilder dataModuleOptions(String dataModuleOptions) {
            doSetProperty("dataModuleOptions", dataModuleOptions);
            return this;
        }
        /**
         * Protocol options.
         * 
         * The option is a:
         * <code>org.eclipse.neoscada.protocol.iec60870.ProtocolOptions</code>
         * type.
         * 
         * Group: common
         */
        default ClientEndpointBuilder protocolOptions(Object protocolOptions) {
            doSetProperty("protocolOptions", protocolOptions);
            return this;
        }
        /**
         * Protocol options.
         * 
         * The option will be converted to a
         * <code>org.eclipse.neoscada.protocol.iec60870.ProtocolOptions</code>
         * type.
         * 
         * Group: common
         */
        default ClientEndpointBuilder protocolOptions(String protocolOptions) {
            doSetProperty("protocolOptions", protocolOptions);
            return this;
        }
        /**
         * Parameter W - Acknowledgment window.
         * 
         * The option is a: <code>short</code> type.
         * 
         * Group: connection
         */
        default ClientEndpointBuilder acknowledgeWindow(short acknowledgeWindow) {
            doSetProperty("acknowledgeWindow", acknowledgeWindow);
            return this;
        }
        /**
         * Parameter W - Acknowledgment window.
         * 
         * The option will be converted to a <code>short</code> type.
         * 
         * Group: connection
         */
        default ClientEndpointBuilder acknowledgeWindow(String acknowledgeWindow) {
            doSetProperty("acknowledgeWindow", acknowledgeWindow);
            return this;
        }
        /**
         * The common ASDU address size. May be either SIZE_1 or SIZE_2.
         * 
         * The option is a:
         * <code>org.eclipse.neoscada.protocol.iec60870.ASDUAddressType</code>
         * type.
         * 
         * Group: connection
         */
        default ClientEndpointBuilder adsuAddressType(
                ASDUAddressType adsuAddressType) {
            doSetProperty("adsuAddressType", adsuAddressType);
            return this;
        }
        /**
         * The common ASDU address size. May be either SIZE_1 or SIZE_2.
         * 
         * The option will be converted to a
         * <code>org.eclipse.neoscada.protocol.iec60870.ASDUAddressType</code>
         * type.
         * 
         * Group: connection
         */
        default ClientEndpointBuilder adsuAddressType(String adsuAddressType) {
            doSetProperty("adsuAddressType", adsuAddressType);
            return this;
        }
        /**
         * The cause of transmission type. May be either SIZE_1 or SIZE_2.
         * 
         * The option is a:
         * <code>org.eclipse.neoscada.protocol.iec60870.CauseOfTransmissionType</code> type.
         * 
         * Group: connection
         */
        default ClientEndpointBuilder causeOfTransmissionType(
                CauseOfTransmissionType causeOfTransmissionType) {
            doSetProperty("causeOfTransmissionType", causeOfTransmissionType);
            return this;
        }
        /**
         * The cause of transmission type. May be either SIZE_1 or SIZE_2.
         * 
         * The option will be converted to a
         * <code>org.eclipse.neoscada.protocol.iec60870.CauseOfTransmissionType</code> type.
         * 
         * Group: connection
         */
        default ClientEndpointBuilder causeOfTransmissionType(
                String causeOfTransmissionType) {
            doSetProperty("causeOfTransmissionType", causeOfTransmissionType);
            return this;
        }
        /**
         * The information address size. May be either SIZE_1, SIZE_2 or SIZE_3.
         * 
         * The option is a:
         * <code>org.eclipse.neoscada.protocol.iec60870.InformationObjectAddressType</code> type.
         * 
         * Group: connection
         */
        default ClientEndpointBuilder informationObjectAddressType(
                InformationObjectAddressType informationObjectAddressType) {
            doSetProperty("informationObjectAddressType", informationObjectAddressType);
            return this;
        }
        /**
         * The information address size. May be either SIZE_1, SIZE_2 or SIZE_3.
         * 
         * The option will be converted to a
         * <code>org.eclipse.neoscada.protocol.iec60870.InformationObjectAddressType</code> type.
         * 
         * Group: connection
         */
        default ClientEndpointBuilder informationObjectAddressType(
                String informationObjectAddressType) {
            doSetProperty("informationObjectAddressType", informationObjectAddressType);
            return this;
        }
        /**
         * Parameter K - Maximum number of un-acknowledged messages.
         * 
         * The option is a: <code>short</code> type.
         * 
         * Group: connection
         */
        default ClientEndpointBuilder maxUnacknowledged(short maxUnacknowledged) {
            doSetProperty("maxUnacknowledged", maxUnacknowledged);
            return this;
        }
        /**
         * Parameter K - Maximum number of un-acknowledged messages.
         * 
         * The option will be converted to a <code>short</code> type.
         * 
         * Group: connection
         */
        default ClientEndpointBuilder maxUnacknowledged(String maxUnacknowledged) {
            doSetProperty("maxUnacknowledged", maxUnacknowledged);
            return this;
        }
        /**
         * Timeout T1 in milliseconds.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: connection
         */
        default ClientEndpointBuilder timeout1(int timeout1) {
            doSetProperty("timeout1", timeout1);
            return this;
        }
        /**
         * Timeout T1 in milliseconds.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: connection
         */
        default ClientEndpointBuilder timeout1(String timeout1) {
            doSetProperty("timeout1", timeout1);
            return this;
        }
        /**
         * Timeout T2 in milliseconds.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: connection
         */
        default ClientEndpointBuilder timeout2(int timeout2) {
            doSetProperty("timeout2", timeout2);
            return this;
        }
        /**
         * Timeout T2 in milliseconds.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: connection
         */
        default ClientEndpointBuilder timeout2(String timeout2) {
            doSetProperty("timeout2", timeout2);
            return this;
        }
        /**
         * Timeout T3 in milliseconds.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: connection
         */
        default ClientEndpointBuilder timeout3(int timeout3) {
            doSetProperty("timeout3", timeout3);
            return this;
        }
        /**
         * Timeout T3 in milliseconds.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: connection
         */
        default ClientEndpointBuilder timeout3(String timeout3) {
            doSetProperty("timeout3", timeout3);
            return this;
        }
        /**
         * Whether to include the source address.
         * 
         * The option is a: <code>byte</code> type.
         * 
         * Group: data
         */
        default ClientEndpointBuilder causeSourceAddress(byte causeSourceAddress) {
            doSetProperty("causeSourceAddress", causeSourceAddress);
            return this;
        }
        /**
         * Whether to include the source address.
         * 
         * The option will be converted to a <code>byte</code> type.
         * 
         * Group: data
         */
        default ClientEndpointBuilder causeSourceAddress(
                String causeSourceAddress) {
            doSetProperty("causeSourceAddress", causeSourceAddress);
            return this;
        }
        /**
         * Whether background scan transmissions should be ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: data
         */
        default ClientEndpointBuilder ignoreBackgroundScan(
                boolean ignoreBackgroundScan) {
            doSetProperty("ignoreBackgroundScan", ignoreBackgroundScan);
            return this;
        }
        /**
         * Whether background scan transmissions should be ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: data
         */
        default ClientEndpointBuilder ignoreBackgroundScan(
                String ignoreBackgroundScan) {
            doSetProperty("ignoreBackgroundScan", ignoreBackgroundScan);
            return this;
        }
        /**
         * Whether to ignore or respect DST.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: data
         */
        default ClientEndpointBuilder ignoreDaylightSavingTime(
                boolean ignoreDaylightSavingTime) {
            doSetProperty("ignoreDaylightSavingTime", ignoreDaylightSavingTime);
            return this;
        }
        /**
         * Whether to ignore or respect DST.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: data
         */
        default ClientEndpointBuilder ignoreDaylightSavingTime(
                String ignoreDaylightSavingTime) {
            doSetProperty("ignoreDaylightSavingTime", ignoreDaylightSavingTime);
            return this;
        }
        /**
         * The timezone to use. May be any Java time zone string.
         * 
         * The option is a: <code>java.util.TimeZone</code> type.
         * 
         * Group: data
         */
        default ClientEndpointBuilder timeZone(TimeZone timeZone) {
            doSetProperty("timeZone", timeZone);
            return this;
        }
        /**
         * The timezone to use. May be any Java time zone string.
         * 
         * The option will be converted to a <code>java.util.TimeZone</code>
         * type.
         * 
         * Group: data
         */
        default ClientEndpointBuilder timeZone(String timeZone) {
            doSetProperty("timeZone", timeZone);
            return this;
        }
        /**
         * An identifier grouping connection instances.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: id
         */
        default ClientEndpointBuilder connectionId(String connectionId) {
            doSetProperty("connectionId", connectionId);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the IEC 60870 Client component.
     */
    public interface AdvancedClientEndpointBuilder
            extends
                AdvancedClientEndpointConsumerBuilder, AdvancedClientEndpointProducerBuilder {
        default ClientEndpointBuilder basic() {
            return (ClientEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedClientEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedClientEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedClientEndpointBuilder synchronous(boolean synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedClientEndpointBuilder synchronous(String synchronous) {
            doSetProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Proxy enum for
     * <code>org.eclipse.neoscada.protocol.iec60870.ASDUAddressType</code> enum.
     */
    enum ASDUAddressType {
        SIZE_1,
        SIZE_2;
    }

    /**
     * Proxy enum for
     * <code>org.eclipse.neoscada.protocol.iec60870.CauseOfTransmissionType</code> enum.
     */
    enum CauseOfTransmissionType {
        SIZE_1,
        SIZE_2;
    }

    /**
     * Proxy enum for
     * <code>org.eclipse.neoscada.protocol.iec60870.InformationObjectAddressType</code> enum.
     */
    enum InformationObjectAddressType {
        SIZE_1,
        SIZE_2,
        SIZE_3;
    }
    /**
     * IEC 60870 Client (camel-iec60870)
     * IEC 60870 component used for telecontrol (supervisory control and data
     * acquisition) such as controlling electric power transmission grids and
     * other geographically widespread control systems.
     * 
     * Category: iot
     * Available as of version: 2.20
     * Maven coordinates: org.apache.camel:camel-iec60870
     * 
     * Syntax: <code>iec60870-client:uriPath</code>
     * 
     * Path parameter: uriPath (required)
     * The object information address
     */
    default ClientEndpointBuilder iec60870Client(String path) {
        class ClientEndpointBuilderImpl extends AbstractEndpointBuilder implements ClientEndpointBuilder, AdvancedClientEndpointBuilder {
            public ClientEndpointBuilderImpl(String path) {
                super("iec60870-client", path);
            }
        }
        return new ClientEndpointBuilderImpl(path);
    }
}