/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.jpa.springboot;

import javax.annotation.Generated;
import org.apache.camel.spring.boot.ComponentConfigurationPropertiesCommon;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * The jpa component enables you to store and retrieve Java objects from
 * databases using JPA.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.SpringBootAutoConfigurationMojo")
@ConfigurationProperties(prefix = "camel.component.jpa")
public class JpaComponentConfiguration
        extends
            ComponentConfigurationPropertiesCommon {

    /**
     * Whether to enable auto configuration of the jpa component. This is
     * enabled by default.
     */
    private Boolean enabled;
    /**
     * To use the EntityManagerFactory. This is strongly recommended to
     * configure. The option is a javax.persistence.EntityManagerFactory type.
     */
    private String entityManagerFactory;
    /**
     * To use the PlatformTransactionManager for managing transactions. The
     * option is a org.springframework.transaction.PlatformTransactionManager
     * type.
     */
    private String transactionManager;
    /**
     * The camel-jpa component will join transaction by default. You can use
     * this option to turn this off, for example if you use LOCAL_RESOURCE and
     * join transaction doesn't work with your JPA provider. This option can
     * also be set globally on the JpaComponent, instead of having to set it on
     * all endpoints.
     */
    private Boolean joinTransaction = true;
    /**
     * Whether to use Spring's SharedEntityManager for the consumer/producer.
     * Note in most cases joinTransaction should be set to false as this is not
     * an EXTENDED EntityManager.
     */
    private Boolean sharedEntityManager = false;
    /**
     * Whether the component should use basic property binding (Camel 2.x) or
     * the newer property binding with additional capabilities
     */
    private Boolean basicPropertyBinding = false;

    public String getEntityManagerFactory() {
        return entityManagerFactory;
    }

    public void setEntityManagerFactory(String entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public String getTransactionManager() {
        return transactionManager;
    }

    public void setTransactionManager(String transactionManager) {
        this.transactionManager = transactionManager;
    }

    public Boolean getJoinTransaction() {
        return joinTransaction;
    }

    public void setJoinTransaction(Boolean joinTransaction) {
        this.joinTransaction = joinTransaction;
    }

    public Boolean getSharedEntityManager() {
        return sharedEntityManager;
    }

    public void setSharedEntityManager(Boolean sharedEntityManager) {
        this.sharedEntityManager = sharedEntityManager;
    }

    public Boolean getBasicPropertyBinding() {
        return basicPropertyBinding;
    }

    public void setBasicPropertyBinding(Boolean basicPropertyBinding) {
        this.basicPropertyBinding = basicPropertyBinding;
    }
}