/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.facebook.springboot;

import javax.annotation.Generated;
import org.apache.camel.spring.boot.ComponentConfigurationPropertiesCommon;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * The Facebook component provides access to all of the Facebook APIs accessible
 * using Facebook4J.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.SpringBootAutoConfigurationMojo")
@ConfigurationProperties(prefix = "camel.component.facebook")
public class FacebookComponentConfiguration
        extends
            ComponentConfigurationPropertiesCommon {

    /**
     * Whether to enable auto configuration of the facebook component. This is
     * enabled by default.
     */
    private Boolean enabled;
    /**
     * To use the shared configuration
     */
    private FacebookConfigurationNestedConfiguration configuration;
    /**
     * Whether the component should use basic property binding (Camel 2.x) or
     * the newer property binding with additional capabilities
     */
    private Boolean basicPropertyBinding = false;

    public FacebookConfigurationNestedConfiguration getConfiguration() {
        return configuration;
    }

    public void setConfiguration(
            FacebookConfigurationNestedConfiguration configuration) {
        this.configuration = configuration;
    }

    public Boolean getBasicPropertyBinding() {
        return basicPropertyBinding;
    }

    public void setBasicPropertyBinding(Boolean basicPropertyBinding) {
        this.basicPropertyBinding = basicPropertyBinding;
    }

    public static class FacebookConfigurationNestedConfiguration {
        public static final Class CAMEL_NESTED_CLASS = org.apache.camel.component.facebook.config.FacebookConfiguration.class;
        /**
         * The user access token
         */
        private String oAuthAccessToken;
        /**
         * OAuth access token URL
         */
        private String oAuthAccessTokenURL = "https://graph.facebook.com/oauth/access_token";
        /**
         * The application Id
         */
        private String oAuthAppId;
        /**
         * The application Secret
         */
        private String oAuthAppSecret;
        /**
         * OAuth authorization URL
         */
        private String oAuthAuthorizationURL = "https://www.facebook.com/dialog/oauth";
        /**
         * Facebook4J API client URL
         */
        private String clientURL;
        /**
         * Facebook4J client API version
         */
        private String clientVersion;
        /**
         * Enables deubg output. Effective only with the embedded logger
         */
        private Boolean debugEnabled = false;
        /**
         * Use Facebook GZIP encoding
         */
        private Boolean gzipEnabled = true;
        /**
         * Http connection timeout in milliseconds
         */
        private Integer httpConnectionTimeout = 20000;
        /**
         * HTTP maximum connections per route
         */
        private Integer httpDefaultMaxPerRoute = 2;
        /**
         * HTTP maximum total connections
         */
        private Integer httpMaxTotalConnections = 20;
        /**
         * HTTP proxy server host name
         */
        private String httpProxyHost;
        /**
         * HTTP proxy server password
         */
        private String httpProxyPassword;
        /**
         * HTTP proxy server port
         */
        private Integer httpProxyPort;
        /**
         * HTTP proxy server user name
         */
        private String httpProxyUser;
        /**
         * Http read timeout in milliseconds
         */
        private Integer httpReadTimeout = 120000;
        /**
         * Number of HTTP retries
         */
        private Integer httpRetryCount = 0;
        /**
         * HTTP retry interval in seconds
         */
        private Integer httpRetryIntervalSeconds = 5;
        /**
         * HTTP streaming read timeout in milliseconds
         */
        private Integer httpStreamingReadTimeout = 40000;
        /**
         * If set to true, raw JSON forms will be stored in DataObjectFactory
         */
        private Boolean jsonStoreEnabled = false;
        /**
         * If set to true, Facebook4J mbean will be registerd
         */
        private Boolean mbeanEnabled = false;
        /**
         * Default OAuth permissions. Comma separated permission names. See
         * https://developers.facebook.com/docs/reference/login/#permissions for
         * the detail
         */
        private String oAuthPermissions;
        /**
         * Prettify JSON debug output if set to true
         */
        private Boolean prettyDebugEnabled = false;
        /**
         * API base URL
         */
        private String restBaseURL = "https://graph.facebook.com/";
        /**
         * Use SSL
         */
        private Boolean useSSL = true;
        /**
         * Video API base URL
         */
        private String videoBaseURL = "https://graph-video.facebook.com/";

        public String getOAuthAccessToken() {
            return oAuthAccessToken;
        }

        public void setOAuthAccessToken(String oAuthAccessToken) {
            this.oAuthAccessToken = oAuthAccessToken;
        }

        public String getOAuthAccessTokenURL() {
            return oAuthAccessTokenURL;
        }

        public void setOAuthAccessTokenURL(String oAuthAccessTokenURL) {
            this.oAuthAccessTokenURL = oAuthAccessTokenURL;
        }

        public String getOAuthAppId() {
            return oAuthAppId;
        }

        public void setOAuthAppId(String oAuthAppId) {
            this.oAuthAppId = oAuthAppId;
        }

        public String getOAuthAppSecret() {
            return oAuthAppSecret;
        }

        public void setOAuthAppSecret(String oAuthAppSecret) {
            this.oAuthAppSecret = oAuthAppSecret;
        }

        public String getOAuthAuthorizationURL() {
            return oAuthAuthorizationURL;
        }

        public void setOAuthAuthorizationURL(String oAuthAuthorizationURL) {
            this.oAuthAuthorizationURL = oAuthAuthorizationURL;
        }

        public String getClientURL() {
            return clientURL;
        }

        public void setClientURL(String clientURL) {
            this.clientURL = clientURL;
        }

        public String getClientVersion() {
            return clientVersion;
        }

        public void setClientVersion(String clientVersion) {
            this.clientVersion = clientVersion;
        }

        public Boolean getDebugEnabled() {
            return debugEnabled;
        }

        public void setDebugEnabled(Boolean debugEnabled) {
            this.debugEnabled = debugEnabled;
        }

        public Boolean getGzipEnabled() {
            return gzipEnabled;
        }

        public void setGzipEnabled(Boolean gzipEnabled) {
            this.gzipEnabled = gzipEnabled;
        }

        public Integer getHttpConnectionTimeout() {
            return httpConnectionTimeout;
        }

        public void setHttpConnectionTimeout(Integer httpConnectionTimeout) {
            this.httpConnectionTimeout = httpConnectionTimeout;
        }

        public Integer getHttpDefaultMaxPerRoute() {
            return httpDefaultMaxPerRoute;
        }

        public void setHttpDefaultMaxPerRoute(Integer httpDefaultMaxPerRoute) {
            this.httpDefaultMaxPerRoute = httpDefaultMaxPerRoute;
        }

        public Integer getHttpMaxTotalConnections() {
            return httpMaxTotalConnections;
        }

        public void setHttpMaxTotalConnections(Integer httpMaxTotalConnections) {
            this.httpMaxTotalConnections = httpMaxTotalConnections;
        }

        public String getHttpProxyHost() {
            return httpProxyHost;
        }

        public void setHttpProxyHost(String httpProxyHost) {
            this.httpProxyHost = httpProxyHost;
        }

        public String getHttpProxyPassword() {
            return httpProxyPassword;
        }

        public void setHttpProxyPassword(String httpProxyPassword) {
            this.httpProxyPassword = httpProxyPassword;
        }

        public Integer getHttpProxyPort() {
            return httpProxyPort;
        }

        public void setHttpProxyPort(Integer httpProxyPort) {
            this.httpProxyPort = httpProxyPort;
        }

        public String getHttpProxyUser() {
            return httpProxyUser;
        }

        public void setHttpProxyUser(String httpProxyUser) {
            this.httpProxyUser = httpProxyUser;
        }

        public Integer getHttpReadTimeout() {
            return httpReadTimeout;
        }

        public void setHttpReadTimeout(Integer httpReadTimeout) {
            this.httpReadTimeout = httpReadTimeout;
        }

        public Integer getHttpRetryCount() {
            return httpRetryCount;
        }

        public void setHttpRetryCount(Integer httpRetryCount) {
            this.httpRetryCount = httpRetryCount;
        }

        public Integer getHttpRetryIntervalSeconds() {
            return httpRetryIntervalSeconds;
        }

        public void setHttpRetryIntervalSeconds(Integer httpRetryIntervalSeconds) {
            this.httpRetryIntervalSeconds = httpRetryIntervalSeconds;
        }

        public Integer getHttpStreamingReadTimeout() {
            return httpStreamingReadTimeout;
        }

        public void setHttpStreamingReadTimeout(Integer httpStreamingReadTimeout) {
            this.httpStreamingReadTimeout = httpStreamingReadTimeout;
        }

        public Boolean getJsonStoreEnabled() {
            return jsonStoreEnabled;
        }

        public void setJsonStoreEnabled(Boolean jsonStoreEnabled) {
            this.jsonStoreEnabled = jsonStoreEnabled;
        }

        public Boolean getMbeanEnabled() {
            return mbeanEnabled;
        }

        public void setMbeanEnabled(Boolean mbeanEnabled) {
            this.mbeanEnabled = mbeanEnabled;
        }

        public String getOAuthPermissions() {
            return oAuthPermissions;
        }

        public void setOAuthPermissions(String oAuthPermissions) {
            this.oAuthPermissions = oAuthPermissions;
        }

        public Boolean getPrettyDebugEnabled() {
            return prettyDebugEnabled;
        }

        public void setPrettyDebugEnabled(Boolean prettyDebugEnabled) {
            this.prettyDebugEnabled = prettyDebugEnabled;
        }

        public String getRestBaseURL() {
            return restBaseURL;
        }

        public void setRestBaseURL(String restBaseURL) {
            this.restBaseURL = restBaseURL;
        }

        public Boolean getUseSSL() {
            return useSSL;
        }

        public void setUseSSL(Boolean useSSL) {
            this.useSSL = useSSL;
        }

        public String getVideoBaseURL() {
            return videoBaseURL;
        }

        public void setVideoBaseURL(String videoBaseURL) {
            this.videoBaseURL = videoBaseURL;
        }
    }
}