/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.PollingConsumerPollStrategy;

/**
 * Polls the weather information from Open Weather Map.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface WeatherEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Weather component.
     */
    public interface WeatherEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedWeatherEndpointConsumerBuilder advanced() {
            return (AdvancedWeatherEndpointConsumerBuilder) this;
        }
        /**
         * APPID ID used to authenticate the user connected to the API Server.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: common
         */
        default WeatherEndpointConsumerBuilder appid(String appid) {
            setProperty("appid", appid);
            return this;
        }
        /**
         * To store the weather result in this header instead of the message
         * body. This is useable if you want to keep current message body as-is.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default WeatherEndpointConsumerBuilder headerName(String headerName) {
            setProperty("headerName", headerName);
            return this;
        }
        /**
         * Language of the response.
         * 
         * The option is a:
         * <code>org.apache.camel.component.weather.WeatherLanguage</code> type.
         * 
         * Group: common
         */
        default WeatherEndpointConsumerBuilder language(WeatherLanguage language) {
            setProperty("language", language);
            return this;
        }
        /**
         * Language of the response.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.weather.WeatherLanguage</code> type.
         * 
         * Group: common
         */
        default WeatherEndpointConsumerBuilder language(String language) {
            setProperty("language", language);
            return this;
        }
        /**
         * The output format of the weather data.
         * 
         * The option is a:
         * <code>org.apache.camel.component.weather.WeatherMode</code> type.
         * 
         * Group: common
         */
        default WeatherEndpointConsumerBuilder mode(WeatherMode mode) {
            setProperty("mode", mode);
            return this;
        }
        /**
         * The output format of the weather data.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.weather.WeatherMode</code> type.
         * 
         * Group: common
         */
        default WeatherEndpointConsumerBuilder mode(String mode) {
            setProperty("mode", mode);
            return this;
        }
        /**
         * If null, the current weather will be returned, else use values of 5,
         * 7, 14 days. Only the numeric value for the forecast period is
         * actually parsed, so spelling, capitalisation of the time period is up
         * to you (its ignored).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default WeatherEndpointConsumerBuilder period(String period) {
            setProperty("period", period);
            return this;
        }
        /**
         * The units for temperature measurement.
         * 
         * The option is a:
         * <code>org.apache.camel.component.weather.WeatherUnits</code> type.
         * 
         * Group: common
         */
        default WeatherEndpointConsumerBuilder units(WeatherUnits units) {
            setProperty("units", units);
            return this;
        }
        /**
         * The units for temperature measurement.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.weather.WeatherUnits</code> type.
         * 
         * Group: common
         */
        default WeatherEndpointConsumerBuilder units(String units) {
            setProperty("units", units);
            return this;
        }
        /**
         * The API to be use (current, forecast/3 hour, forecast daily,
         * station).
         * 
         * The option is a:
         * <code>org.apache.camel.component.weather.WeatherApi</code> type.
         * 
         * Group: common
         */
        default WeatherEndpointConsumerBuilder weatherApi(WeatherApi weatherApi) {
            setProperty("weatherApi", weatherApi);
            return this;
        }
        /**
         * The API to be use (current, forecast/3 hour, forecast daily,
         * station).
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.weather.WeatherApi</code> type.
         * 
         * Group: common
         */
        default WeatherEndpointConsumerBuilder weatherApi(String weatherApi) {
            setProperty("weatherApi", weatherApi);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default WeatherEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            setProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default WeatherEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            setProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default WeatherEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                boolean sendEmptyMessageWhenIdle) {
            setProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default WeatherEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                String sendEmptyMessageWhenIdle) {
            setProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default WeatherEndpointConsumerBuilder backoffErrorThreshold(
                int backoffErrorThreshold) {
            setProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default WeatherEndpointConsumerBuilder backoffErrorThreshold(
                String backoffErrorThreshold) {
            setProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default WeatherEndpointConsumerBuilder backoffIdleThreshold(
                int backoffIdleThreshold) {
            setProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default WeatherEndpointConsumerBuilder backoffIdleThreshold(
                String backoffIdleThreshold) {
            setProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default WeatherEndpointConsumerBuilder backoffMultiplier(
                int backoffMultiplier) {
            setProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default WeatherEndpointConsumerBuilder backoffMultiplier(
                String backoffMultiplier) {
            setProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * Milliseconds before the next poll. You can also specify time values
         * using units, such as 60s (60 seconds), 5m30s (5 minutes and 30
         * seconds), and 1h (1 hour).
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: scheduler
         */
        default WeatherEndpointConsumerBuilder delay(long delay) {
            setProperty("delay", delay);
            return this;
        }
        /**
         * Milliseconds before the next poll. You can also specify time values
         * using units, such as 60s (60 seconds), 5m30s (5 minutes and 30
         * seconds), and 1h (1 hour).
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: scheduler
         */
        default WeatherEndpointConsumerBuilder delay(String delay) {
            setProperty("delay", delay);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default WeatherEndpointConsumerBuilder greedy(boolean greedy) {
            setProperty("greedy", greedy);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default WeatherEndpointConsumerBuilder greedy(String greedy) {
            setProperty("greedy", greedy);
            return this;
        }
        /**
         * Milliseconds before the first poll starts. You can also specify time
         * values using units, such as 60s (60 seconds), 5m30s (5 minutes and 30
         * seconds), and 1h (1 hour).
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: scheduler
         */
        default WeatherEndpointConsumerBuilder initialDelay(long initialDelay) {
            setProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Milliseconds before the first poll starts. You can also specify time
         * values using units, such as 60s (60 seconds), 5m30s (5 minutes and 30
         * seconds), and 1h (1 hour).
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: scheduler
         */
        default WeatherEndpointConsumerBuilder initialDelay(String initialDelay) {
            setProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option is a: <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Group: scheduler
         */
        default WeatherEndpointConsumerBuilder runLoggingLevel(
                LoggingLevel runLoggingLevel) {
            setProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Group: scheduler
         */
        default WeatherEndpointConsumerBuilder runLoggingLevel(
                String runLoggingLevel) {
            setProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option is a:
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         */
        default WeatherEndpointConsumerBuilder scheduledExecutorService(
                ScheduledExecutorService scheduledExecutorService) {
            setProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         */
        default WeatherEndpointConsumerBuilder scheduledExecutorService(
                String scheduledExecutorService) {
            setProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: scheduler
         */
        default WeatherEndpointConsumerBuilder scheduler(String scheduler) {
            setProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: scheduler
         */
        default WeatherEndpointConsumerBuilder schedulerProperties(
                Map<String, Object> schedulerProperties) {
            setProperty("schedulerProperties", schedulerProperties);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: scheduler
         */
        default WeatherEndpointConsumerBuilder schedulerProperties(
                String schedulerProperties) {
            setProperty("schedulerProperties", schedulerProperties);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default WeatherEndpointConsumerBuilder startScheduler(
                boolean startScheduler) {
            setProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default WeatherEndpointConsumerBuilder startScheduler(
                String startScheduler) {
            setProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option is a: <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Group: scheduler
         */
        default WeatherEndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            setProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Group: scheduler
         */
        default WeatherEndpointConsumerBuilder timeUnit(String timeUnit) {
            setProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default WeatherEndpointConsumerBuilder useFixedDelay(
                boolean useFixedDelay) {
            setProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default WeatherEndpointConsumerBuilder useFixedDelay(
                String useFixedDelay) {
            setProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Number of results to be found.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: filter
         */
        default WeatherEndpointConsumerBuilder cnt(Integer cnt) {
            setProperty("cnt", cnt);
            return this;
        }
        /**
         * Number of results to be found.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: filter
         */
        default WeatherEndpointConsumerBuilder cnt(String cnt) {
            setProperty("cnt", cnt);
            return this;
        }
        /**
         * List of id's of city/stations. You can separate multiple ids by
         * comma.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: filter
         */
        default WeatherEndpointConsumerBuilder ids(List<String> ids) {
            setProperty("ids", ids);
            return this;
        }
        /**
         * List of id's of city/stations. You can separate multiple ids by
         * comma.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: filter
         */
        default WeatherEndpointConsumerBuilder ids(String ids) {
            setProperty("ids", ids);
            return this;
        }
        /**
         * Latitude of location. You can use lat and lon options instead of
         * location. For boxed queries this is the bottom latitude.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: filter
         */
        default WeatherEndpointConsumerBuilder lat(String lat) {
            setProperty("lat", lat);
            return this;
        }
        /**
         * If null Camel will try and determine your current location using the
         * geolocation of your ip address, else specify the city,country. For
         * well known city names, Open Weather Map will determine the best fit,
         * but multiple results may be returned. Hence specifying and country as
         * well will return more accurate data. If you specify current as the
         * location then the component will try to get the current latitude and
         * longitude and use that to get the weather details. You can use lat
         * and lon options instead of location.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: filter
         */
        default WeatherEndpointConsumerBuilder location(String location) {
            setProperty("location", location);
            return this;
        }
        /**
         * Longitude of location. You can use lat and lon options instead of
         * location. For boxed queries this is the left longtitude.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: filter
         */
        default WeatherEndpointConsumerBuilder lon(String lon) {
            setProperty("lon", lon);
            return this;
        }
        /**
         * For boxed queries this is the right longtitude. Needs to be used in
         * combination with topLat and zoom.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: filter
         */
        default WeatherEndpointConsumerBuilder rightLon(String rightLon) {
            setProperty("rightLon", rightLon);
            return this;
        }
        /**
         * For boxed queries this is the top latitude. Needs to be used in
         * combination with rightLon and zoom.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: filter
         */
        default WeatherEndpointConsumerBuilder topLat(String topLat) {
            setProperty("topLat", topLat);
            return this;
        }
        /**
         * Zip-code, e.g. 94040,us.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: filter
         */
        default WeatherEndpointConsumerBuilder zip(String zip) {
            setProperty("zip", zip);
            return this;
        }
        /**
         * For boxed queries this is the zoom. Needs to be used in combination
         * with rightLon and topLat.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: filter
         */
        default WeatherEndpointConsumerBuilder zoom(Integer zoom) {
            setProperty("zoom", zoom);
            return this;
        }
        /**
         * For boxed queries this is the zoom. Needs to be used in combination
         * with rightLon and topLat.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: filter
         */
        default WeatherEndpointConsumerBuilder zoom(String zoom) {
            setProperty("zoom", zoom);
            return this;
        }
        /**
         * Domain for proxy NTLM authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default WeatherEndpointConsumerBuilder proxyAuthDomain(
                String proxyAuthDomain) {
            setProperty("proxyAuthDomain", proxyAuthDomain);
            return this;
        }
        /**
         * Optional host for proxy NTLM authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default WeatherEndpointConsumerBuilder proxyAuthHost(
                String proxyAuthHost) {
            setProperty("proxyAuthHost", proxyAuthHost);
            return this;
        }
        /**
         * Authentication method for proxy, either as Basic, Digest or NTLM.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default WeatherEndpointConsumerBuilder proxyAuthMethod(
                String proxyAuthMethod) {
            setProperty("proxyAuthMethod", proxyAuthMethod);
            return this;
        }
        /**
         * Password for proxy authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default WeatherEndpointConsumerBuilder proxyAuthPassword(
                String proxyAuthPassword) {
            setProperty("proxyAuthPassword", proxyAuthPassword);
            return this;
        }
        /**
         * Username for proxy authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default WeatherEndpointConsumerBuilder proxyAuthUsername(
                String proxyAuthUsername) {
            setProperty("proxyAuthUsername", proxyAuthUsername);
            return this;
        }
        /**
         * The proxy host name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default WeatherEndpointConsumerBuilder proxyHost(String proxyHost) {
            setProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * The proxy port number.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: proxy
         */
        default WeatherEndpointConsumerBuilder proxyPort(Integer proxyPort) {
            setProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * The proxy port number.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: proxy
         */
        default WeatherEndpointConsumerBuilder proxyPort(String proxyPort) {
            setProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * The geolocation service now needs an accessKey to be used.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: security
         */
        default WeatherEndpointConsumerBuilder geolocationAccessKey(
                String geolocationAccessKey) {
            setProperty("geolocationAccessKey", geolocationAccessKey);
            return this;
        }
        /**
         * The geolocation service now needs to specify the IP associated to the
         * accessKey you're using.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: security
         */
        default WeatherEndpointConsumerBuilder geolocationRequestHostIP(
                String geolocationRequestHostIP) {
            setProperty("geolocationRequestHostIP", geolocationRequestHostIP);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Weather component.
     */
    public interface AdvancedWeatherEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default WeatherEndpointConsumerBuilder basic() {
            return (WeatherEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedWeatherEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            setProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedWeatherEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            setProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedWeatherEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            setProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedWeatherEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            setProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedWeatherEndpointConsumerBuilder pollStrategy(
                PollingConsumerPollStrategy pollStrategy) {
            setProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedWeatherEndpointConsumerBuilder pollStrategy(
                String pollStrategy) {
            setProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWeatherEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWeatherEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * To use a custom HttpConnectionManager to manage connections.
         * 
         * The option is a:
         * <code>org.apache.commons.httpclient.HttpConnectionManager</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedWeatherEndpointConsumerBuilder httpConnectionManager(
                Object httpConnectionManager) {
            setProperty("httpConnectionManager", httpConnectionManager);
            return this;
        }
        /**
         * To use a custom HttpConnectionManager to manage connections.
         * 
         * The option will be converted to a
         * <code>org.apache.commons.httpclient.HttpConnectionManager</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedWeatherEndpointConsumerBuilder httpConnectionManager(
                String httpConnectionManager) {
            setProperty("httpConnectionManager", httpConnectionManager);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWeatherEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWeatherEndpointConsumerBuilder synchronous(
                String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Weather component.
     */
    public interface WeatherEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedWeatherEndpointProducerBuilder advanced() {
            return (AdvancedWeatherEndpointProducerBuilder) this;
        }
        /**
         * APPID ID used to authenticate the user connected to the API Server.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: common
         */
        default WeatherEndpointProducerBuilder appid(String appid) {
            setProperty("appid", appid);
            return this;
        }
        /**
         * To store the weather result in this header instead of the message
         * body. This is useable if you want to keep current message body as-is.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default WeatherEndpointProducerBuilder headerName(String headerName) {
            setProperty("headerName", headerName);
            return this;
        }
        /**
         * Language of the response.
         * 
         * The option is a:
         * <code>org.apache.camel.component.weather.WeatherLanguage</code> type.
         * 
         * Group: common
         */
        default WeatherEndpointProducerBuilder language(WeatherLanguage language) {
            setProperty("language", language);
            return this;
        }
        /**
         * Language of the response.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.weather.WeatherLanguage</code> type.
         * 
         * Group: common
         */
        default WeatherEndpointProducerBuilder language(String language) {
            setProperty("language", language);
            return this;
        }
        /**
         * The output format of the weather data.
         * 
         * The option is a:
         * <code>org.apache.camel.component.weather.WeatherMode</code> type.
         * 
         * Group: common
         */
        default WeatherEndpointProducerBuilder mode(WeatherMode mode) {
            setProperty("mode", mode);
            return this;
        }
        /**
         * The output format of the weather data.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.weather.WeatherMode</code> type.
         * 
         * Group: common
         */
        default WeatherEndpointProducerBuilder mode(String mode) {
            setProperty("mode", mode);
            return this;
        }
        /**
         * If null, the current weather will be returned, else use values of 5,
         * 7, 14 days. Only the numeric value for the forecast period is
         * actually parsed, so spelling, capitalisation of the time period is up
         * to you (its ignored).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default WeatherEndpointProducerBuilder period(String period) {
            setProperty("period", period);
            return this;
        }
        /**
         * The units for temperature measurement.
         * 
         * The option is a:
         * <code>org.apache.camel.component.weather.WeatherUnits</code> type.
         * 
         * Group: common
         */
        default WeatherEndpointProducerBuilder units(WeatherUnits units) {
            setProperty("units", units);
            return this;
        }
        /**
         * The units for temperature measurement.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.weather.WeatherUnits</code> type.
         * 
         * Group: common
         */
        default WeatherEndpointProducerBuilder units(String units) {
            setProperty("units", units);
            return this;
        }
        /**
         * The API to be use (current, forecast/3 hour, forecast daily,
         * station).
         * 
         * The option is a:
         * <code>org.apache.camel.component.weather.WeatherApi</code> type.
         * 
         * Group: common
         */
        default WeatherEndpointProducerBuilder weatherApi(WeatherApi weatherApi) {
            setProperty("weatherApi", weatherApi);
            return this;
        }
        /**
         * The API to be use (current, forecast/3 hour, forecast daily,
         * station).
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.weather.WeatherApi</code> type.
         * 
         * Group: common
         */
        default WeatherEndpointProducerBuilder weatherApi(String weatherApi) {
            setProperty("weatherApi", weatherApi);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default WeatherEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            setProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default WeatherEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            setProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Number of results to be found.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: filter
         */
        default WeatherEndpointProducerBuilder cnt(Integer cnt) {
            setProperty("cnt", cnt);
            return this;
        }
        /**
         * Number of results to be found.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: filter
         */
        default WeatherEndpointProducerBuilder cnt(String cnt) {
            setProperty("cnt", cnt);
            return this;
        }
        /**
         * List of id's of city/stations. You can separate multiple ids by
         * comma.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: filter
         */
        default WeatherEndpointProducerBuilder ids(List<String> ids) {
            setProperty("ids", ids);
            return this;
        }
        /**
         * List of id's of city/stations. You can separate multiple ids by
         * comma.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: filter
         */
        default WeatherEndpointProducerBuilder ids(String ids) {
            setProperty("ids", ids);
            return this;
        }
        /**
         * Latitude of location. You can use lat and lon options instead of
         * location. For boxed queries this is the bottom latitude.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: filter
         */
        default WeatherEndpointProducerBuilder lat(String lat) {
            setProperty("lat", lat);
            return this;
        }
        /**
         * If null Camel will try and determine your current location using the
         * geolocation of your ip address, else specify the city,country. For
         * well known city names, Open Weather Map will determine the best fit,
         * but multiple results may be returned. Hence specifying and country as
         * well will return more accurate data. If you specify current as the
         * location then the component will try to get the current latitude and
         * longitude and use that to get the weather details. You can use lat
         * and lon options instead of location.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: filter
         */
        default WeatherEndpointProducerBuilder location(String location) {
            setProperty("location", location);
            return this;
        }
        /**
         * Longitude of location. You can use lat and lon options instead of
         * location. For boxed queries this is the left longtitude.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: filter
         */
        default WeatherEndpointProducerBuilder lon(String lon) {
            setProperty("lon", lon);
            return this;
        }
        /**
         * For boxed queries this is the right longtitude. Needs to be used in
         * combination with topLat and zoom.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: filter
         */
        default WeatherEndpointProducerBuilder rightLon(String rightLon) {
            setProperty("rightLon", rightLon);
            return this;
        }
        /**
         * For boxed queries this is the top latitude. Needs to be used in
         * combination with rightLon and zoom.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: filter
         */
        default WeatherEndpointProducerBuilder topLat(String topLat) {
            setProperty("topLat", topLat);
            return this;
        }
        /**
         * Zip-code, e.g. 94040,us.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: filter
         */
        default WeatherEndpointProducerBuilder zip(String zip) {
            setProperty("zip", zip);
            return this;
        }
        /**
         * For boxed queries this is the zoom. Needs to be used in combination
         * with rightLon and topLat.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: filter
         */
        default WeatherEndpointProducerBuilder zoom(Integer zoom) {
            setProperty("zoom", zoom);
            return this;
        }
        /**
         * For boxed queries this is the zoom. Needs to be used in combination
         * with rightLon and topLat.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: filter
         */
        default WeatherEndpointProducerBuilder zoom(String zoom) {
            setProperty("zoom", zoom);
            return this;
        }
        /**
         * Domain for proxy NTLM authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default WeatherEndpointProducerBuilder proxyAuthDomain(
                String proxyAuthDomain) {
            setProperty("proxyAuthDomain", proxyAuthDomain);
            return this;
        }
        /**
         * Optional host for proxy NTLM authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default WeatherEndpointProducerBuilder proxyAuthHost(
                String proxyAuthHost) {
            setProperty("proxyAuthHost", proxyAuthHost);
            return this;
        }
        /**
         * Authentication method for proxy, either as Basic, Digest or NTLM.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default WeatherEndpointProducerBuilder proxyAuthMethod(
                String proxyAuthMethod) {
            setProperty("proxyAuthMethod", proxyAuthMethod);
            return this;
        }
        /**
         * Password for proxy authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default WeatherEndpointProducerBuilder proxyAuthPassword(
                String proxyAuthPassword) {
            setProperty("proxyAuthPassword", proxyAuthPassword);
            return this;
        }
        /**
         * Username for proxy authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default WeatherEndpointProducerBuilder proxyAuthUsername(
                String proxyAuthUsername) {
            setProperty("proxyAuthUsername", proxyAuthUsername);
            return this;
        }
        /**
         * The proxy host name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default WeatherEndpointProducerBuilder proxyHost(String proxyHost) {
            setProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * The proxy port number.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: proxy
         */
        default WeatherEndpointProducerBuilder proxyPort(Integer proxyPort) {
            setProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * The proxy port number.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: proxy
         */
        default WeatherEndpointProducerBuilder proxyPort(String proxyPort) {
            setProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * The geolocation service now needs an accessKey to be used.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: security
         */
        default WeatherEndpointProducerBuilder geolocationAccessKey(
                String geolocationAccessKey) {
            setProperty("geolocationAccessKey", geolocationAccessKey);
            return this;
        }
        /**
         * The geolocation service now needs to specify the IP associated to the
         * accessKey you're using.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: security
         */
        default WeatherEndpointProducerBuilder geolocationRequestHostIP(
                String geolocationRequestHostIP) {
            setProperty("geolocationRequestHostIP", geolocationRequestHostIP);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Weather component.
     */
    public interface AdvancedWeatherEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default WeatherEndpointProducerBuilder basic() {
            return (WeatherEndpointProducerBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWeatherEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWeatherEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * To use a custom HttpConnectionManager to manage connections.
         * 
         * The option is a:
         * <code>org.apache.commons.httpclient.HttpConnectionManager</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedWeatherEndpointProducerBuilder httpConnectionManager(
                Object httpConnectionManager) {
            setProperty("httpConnectionManager", httpConnectionManager);
            return this;
        }
        /**
         * To use a custom HttpConnectionManager to manage connections.
         * 
         * The option will be converted to a
         * <code>org.apache.commons.httpclient.HttpConnectionManager</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedWeatherEndpointProducerBuilder httpConnectionManager(
                String httpConnectionManager) {
            setProperty("httpConnectionManager", httpConnectionManager);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWeatherEndpointProducerBuilder synchronous(
                boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWeatherEndpointProducerBuilder synchronous(
                String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Weather component.
     */
    public interface WeatherEndpointBuilder
            extends
                WeatherEndpointConsumerBuilder, WeatherEndpointProducerBuilder {
        default AdvancedWeatherEndpointBuilder advanced() {
            return (AdvancedWeatherEndpointBuilder) this;
        }
        /**
         * APPID ID used to authenticate the user connected to the API Server.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: common
         */
        default WeatherEndpointBuilder appid(String appid) {
            setProperty("appid", appid);
            return this;
        }
        /**
         * To store the weather result in this header instead of the message
         * body. This is useable if you want to keep current message body as-is.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default WeatherEndpointBuilder headerName(String headerName) {
            setProperty("headerName", headerName);
            return this;
        }
        /**
         * Language of the response.
         * 
         * The option is a:
         * <code>org.apache.camel.component.weather.WeatherLanguage</code> type.
         * 
         * Group: common
         */
        default WeatherEndpointBuilder language(WeatherLanguage language) {
            setProperty("language", language);
            return this;
        }
        /**
         * Language of the response.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.weather.WeatherLanguage</code> type.
         * 
         * Group: common
         */
        default WeatherEndpointBuilder language(String language) {
            setProperty("language", language);
            return this;
        }
        /**
         * The output format of the weather data.
         * 
         * The option is a:
         * <code>org.apache.camel.component.weather.WeatherMode</code> type.
         * 
         * Group: common
         */
        default WeatherEndpointBuilder mode(WeatherMode mode) {
            setProperty("mode", mode);
            return this;
        }
        /**
         * The output format of the weather data.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.weather.WeatherMode</code> type.
         * 
         * Group: common
         */
        default WeatherEndpointBuilder mode(String mode) {
            setProperty("mode", mode);
            return this;
        }
        /**
         * If null, the current weather will be returned, else use values of 5,
         * 7, 14 days. Only the numeric value for the forecast period is
         * actually parsed, so spelling, capitalisation of the time period is up
         * to you (its ignored).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default WeatherEndpointBuilder period(String period) {
            setProperty("period", period);
            return this;
        }
        /**
         * The units for temperature measurement.
         * 
         * The option is a:
         * <code>org.apache.camel.component.weather.WeatherUnits</code> type.
         * 
         * Group: common
         */
        default WeatherEndpointBuilder units(WeatherUnits units) {
            setProperty("units", units);
            return this;
        }
        /**
         * The units for temperature measurement.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.weather.WeatherUnits</code> type.
         * 
         * Group: common
         */
        default WeatherEndpointBuilder units(String units) {
            setProperty("units", units);
            return this;
        }
        /**
         * The API to be use (current, forecast/3 hour, forecast daily,
         * station).
         * 
         * The option is a:
         * <code>org.apache.camel.component.weather.WeatherApi</code> type.
         * 
         * Group: common
         */
        default WeatherEndpointBuilder weatherApi(WeatherApi weatherApi) {
            setProperty("weatherApi", weatherApi);
            return this;
        }
        /**
         * The API to be use (current, forecast/3 hour, forecast daily,
         * station).
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.weather.WeatherApi</code> type.
         * 
         * Group: common
         */
        default WeatherEndpointBuilder weatherApi(String weatherApi) {
            setProperty("weatherApi", weatherApi);
            return this;
        }
        /**
         * Number of results to be found.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: filter
         */
        default WeatherEndpointBuilder cnt(Integer cnt) {
            setProperty("cnt", cnt);
            return this;
        }
        /**
         * Number of results to be found.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: filter
         */
        default WeatherEndpointBuilder cnt(String cnt) {
            setProperty("cnt", cnt);
            return this;
        }
        /**
         * List of id's of city/stations. You can separate multiple ids by
         * comma.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: filter
         */
        default WeatherEndpointBuilder ids(List<String> ids) {
            setProperty("ids", ids);
            return this;
        }
        /**
         * List of id's of city/stations. You can separate multiple ids by
         * comma.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: filter
         */
        default WeatherEndpointBuilder ids(String ids) {
            setProperty("ids", ids);
            return this;
        }
        /**
         * Latitude of location. You can use lat and lon options instead of
         * location. For boxed queries this is the bottom latitude.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: filter
         */
        default WeatherEndpointBuilder lat(String lat) {
            setProperty("lat", lat);
            return this;
        }
        /**
         * If null Camel will try and determine your current location using the
         * geolocation of your ip address, else specify the city,country. For
         * well known city names, Open Weather Map will determine the best fit,
         * but multiple results may be returned. Hence specifying and country as
         * well will return more accurate data. If you specify current as the
         * location then the component will try to get the current latitude and
         * longitude and use that to get the weather details. You can use lat
         * and lon options instead of location.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: filter
         */
        default WeatherEndpointBuilder location(String location) {
            setProperty("location", location);
            return this;
        }
        /**
         * Longitude of location. You can use lat and lon options instead of
         * location. For boxed queries this is the left longtitude.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: filter
         */
        default WeatherEndpointBuilder lon(String lon) {
            setProperty("lon", lon);
            return this;
        }
        /**
         * For boxed queries this is the right longtitude. Needs to be used in
         * combination with topLat and zoom.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: filter
         */
        default WeatherEndpointBuilder rightLon(String rightLon) {
            setProperty("rightLon", rightLon);
            return this;
        }
        /**
         * For boxed queries this is the top latitude. Needs to be used in
         * combination with rightLon and zoom.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: filter
         */
        default WeatherEndpointBuilder topLat(String topLat) {
            setProperty("topLat", topLat);
            return this;
        }
        /**
         * Zip-code, e.g. 94040,us.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: filter
         */
        default WeatherEndpointBuilder zip(String zip) {
            setProperty("zip", zip);
            return this;
        }
        /**
         * For boxed queries this is the zoom. Needs to be used in combination
         * with rightLon and topLat.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: filter
         */
        default WeatherEndpointBuilder zoom(Integer zoom) {
            setProperty("zoom", zoom);
            return this;
        }
        /**
         * For boxed queries this is the zoom. Needs to be used in combination
         * with rightLon and topLat.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: filter
         */
        default WeatherEndpointBuilder zoom(String zoom) {
            setProperty("zoom", zoom);
            return this;
        }
        /**
         * Domain for proxy NTLM authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default WeatherEndpointBuilder proxyAuthDomain(String proxyAuthDomain) {
            setProperty("proxyAuthDomain", proxyAuthDomain);
            return this;
        }
        /**
         * Optional host for proxy NTLM authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default WeatherEndpointBuilder proxyAuthHost(String proxyAuthHost) {
            setProperty("proxyAuthHost", proxyAuthHost);
            return this;
        }
        /**
         * Authentication method for proxy, either as Basic, Digest or NTLM.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default WeatherEndpointBuilder proxyAuthMethod(String proxyAuthMethod) {
            setProperty("proxyAuthMethod", proxyAuthMethod);
            return this;
        }
        /**
         * Password for proxy authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default WeatherEndpointBuilder proxyAuthPassword(
                String proxyAuthPassword) {
            setProperty("proxyAuthPassword", proxyAuthPassword);
            return this;
        }
        /**
         * Username for proxy authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default WeatherEndpointBuilder proxyAuthUsername(
                String proxyAuthUsername) {
            setProperty("proxyAuthUsername", proxyAuthUsername);
            return this;
        }
        /**
         * The proxy host name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default WeatherEndpointBuilder proxyHost(String proxyHost) {
            setProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * The proxy port number.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: proxy
         */
        default WeatherEndpointBuilder proxyPort(Integer proxyPort) {
            setProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * The proxy port number.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: proxy
         */
        default WeatherEndpointBuilder proxyPort(String proxyPort) {
            setProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * The geolocation service now needs an accessKey to be used.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: security
         */
        default WeatherEndpointBuilder geolocationAccessKey(
                String geolocationAccessKey) {
            setProperty("geolocationAccessKey", geolocationAccessKey);
            return this;
        }
        /**
         * The geolocation service now needs to specify the IP associated to the
         * accessKey you're using.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: security
         */
        default WeatherEndpointBuilder geolocationRequestHostIP(
                String geolocationRequestHostIP) {
            setProperty("geolocationRequestHostIP", geolocationRequestHostIP);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Weather component.
     */
    public interface AdvancedWeatherEndpointBuilder
            extends
                AdvancedWeatherEndpointConsumerBuilder, AdvancedWeatherEndpointProducerBuilder {
        default WeatherEndpointBuilder basic() {
            return (WeatherEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWeatherEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWeatherEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * To use a custom HttpConnectionManager to manage connections.
         * 
         * The option is a:
         * <code>org.apache.commons.httpclient.HttpConnectionManager</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedWeatherEndpointBuilder httpConnectionManager(
                Object httpConnectionManager) {
            setProperty("httpConnectionManager", httpConnectionManager);
            return this;
        }
        /**
         * To use a custom HttpConnectionManager to manage connections.
         * 
         * The option will be converted to a
         * <code>org.apache.commons.httpclient.HttpConnectionManager</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedWeatherEndpointBuilder httpConnectionManager(
                String httpConnectionManager) {
            setProperty("httpConnectionManager", httpConnectionManager);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWeatherEndpointBuilder synchronous(boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedWeatherEndpointBuilder synchronous(String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.weather.WeatherLanguage</code> enum.
     */
    enum WeatherLanguage {
        en,
        ru,
        it,
        es,
        sp,
        uk,
        ua,
        de,
        pt,
        ro,
        pl,
        fi,
        nl,
        fr,
        bg,
        sv,
        se,
        zh_tw,
        zh,
        zh_cn,
        tr,
        hr,
        ca;
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.weather.WeatherMode</code> enum.
     */
    enum WeatherMode {
        HTML,
        JSON,
        XML;
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.weather.WeatherUnits</code> enum.
     */
    enum WeatherUnits {
        IMPERIAL,
        METRIC;
    }

    /**
     * Proxy enum for <code>org.apache.camel.component.weather.WeatherApi</code>
     * enum.
     */
    enum WeatherApi {
        Current,
        Station,
        Hourly,
        Daily;
    }
    /**
     * Weather (camel-weather)
     * Polls the weather information from Open Weather Map.
     * 
     * Category: api
     * Available as of version: 2.12
     * Maven coordinates: org.apache.camel:camel-weather
     * 
     * Syntax: <code>weather:name</code>
     * 
     * Path parameter: name (required)
     * The name value is not used.
     */
    default WeatherEndpointBuilder weather(String path) {
        class WeatherEndpointBuilderImpl extends AbstractEndpointBuilder implements WeatherEndpointBuilder, AdvancedWeatherEndpointBuilder {
            public WeatherEndpointBuilderImpl(String path) {
                super("weather", path);
            }
        }
        return new WeatherEndpointBuilderImpl(path);
    }
}