/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.net.URI;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * The spring-ws component is used for SOAP WebServices using Spring
 * WebServices.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface SpringWebserviceEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Spring WebService component.
     */
    public interface SpringWebserviceEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedSpringWebserviceEndpointConsumerBuilder advanced() {
            return (AdvancedSpringWebserviceEndpointConsumerBuilder) this;
        }
        /**
         * Option to provide a custom MessageFilter. For example when you want
         * to process your headers or attachments by your own.
         * 
         * The option is a:
         * <code>org.apache.camel.component.spring.ws.filter.MessageFilter</code> type.
         * 
         * Group: common
         */
        default SpringWebserviceEndpointConsumerBuilder messageFilter(
                Object messageFilter) {
            setProperty("messageFilter", messageFilter);
            return this;
        }
        /**
         * Option to provide a custom MessageFilter. For example when you want
         * to process your headers or attachments by your own.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.spring.ws.filter.MessageFilter</code> type.
         * 
         * Group: common
         */
        default SpringWebserviceEndpointConsumerBuilder messageFilter(
                String messageFilter) {
            setProperty("messageFilter", messageFilter);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default SpringWebserviceEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            setProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default SpringWebserviceEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            setProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Spring org.springframework.ws.server.endpoint.MessageEndpoint for
         * dispatching messages received by Spring-WS to a Camel endpoint, to
         * integrate with existing (legacy) endpoint mappings like
         * PayloadRootQNameEndpointMapping, SoapActionEndpointMapping, etc.
         * 
         * The option is a:
         * <code>org.apache.camel.component.spring.ws.bean.CamelEndpointDispatcher</code> type.
         * 
         * Group: consumer
         */
        default SpringWebserviceEndpointConsumerBuilder endpointDispatcher(
                Object endpointDispatcher) {
            setProperty("endpointDispatcher", endpointDispatcher);
            return this;
        }
        /**
         * Spring org.springframework.ws.server.endpoint.MessageEndpoint for
         * dispatching messages received by Spring-WS to a Camel endpoint, to
         * integrate with existing (legacy) endpoint mappings like
         * PayloadRootQNameEndpointMapping, SoapActionEndpointMapping, etc.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.spring.ws.bean.CamelEndpointDispatcher</code> type.
         * 
         * Group: consumer
         */
        default SpringWebserviceEndpointConsumerBuilder endpointDispatcher(
                String endpointDispatcher) {
            setProperty("endpointDispatcher", endpointDispatcher);
            return this;
        }
        /**
         * Reference to an instance of
         * org.apache.camel.component.spring.ws.bean.CamelEndpointMapping in the
         * Registry/ApplicationContext. Only one bean is required in the
         * registry to serve all Camel/Spring-WS endpoints. This bean is
         * auto-discovered by the MessageDispatcher and used to map requests to
         * Camel endpoints based on characteristics specified on the endpoint
         * (like root QName, SOAP action, etc).
         * 
         * The option is a:
         * <code>org.apache.camel.component.spring.ws.bean.CamelSpringWSEndpointMapping</code> type.
         * 
         * Group: consumer
         */
        default SpringWebserviceEndpointConsumerBuilder endpointMapping(
                Object endpointMapping) {
            setProperty("endpointMapping", endpointMapping);
            return this;
        }
        /**
         * Reference to an instance of
         * org.apache.camel.component.spring.ws.bean.CamelEndpointMapping in the
         * Registry/ApplicationContext. Only one bean is required in the
         * registry to serve all Camel/Spring-WS endpoints. This bean is
         * auto-discovered by the MessageDispatcher and used to map requests to
         * Camel endpoints based on characteristics specified on the endpoint
         * (like root QName, SOAP action, etc).
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.spring.ws.bean.CamelSpringWSEndpointMapping</code> type.
         * 
         * Group: consumer
         */
        default SpringWebserviceEndpointConsumerBuilder endpointMapping(
                String endpointMapping) {
            setProperty("endpointMapping", endpointMapping);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default SpringWebserviceEndpointConsumerBuilder sslContextParameters(
                Object sslContextParameters) {
            setProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default SpringWebserviceEndpointConsumerBuilder sslContextParameters(
                String sslContextParameters) {
            setProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Spring WebService
     * component.
     */
    public interface AdvancedSpringWebserviceEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default SpringWebserviceEndpointConsumerBuilder basic() {
            return (SpringWebserviceEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedSpringWebserviceEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            setProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedSpringWebserviceEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            setProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedSpringWebserviceEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            setProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedSpringWebserviceEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            setProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSpringWebserviceEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSpringWebserviceEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSpringWebserviceEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSpringWebserviceEndpointConsumerBuilder synchronous(
                String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Spring WebService component.
     */
    public interface SpringWebserviceEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedSpringWebserviceEndpointProducerBuilder advanced() {
            return (AdvancedSpringWebserviceEndpointProducerBuilder) this;
        }
        /**
         * Option to provide a custom MessageFilter. For example when you want
         * to process your headers or attachments by your own.
         * 
         * The option is a:
         * <code>org.apache.camel.component.spring.ws.filter.MessageFilter</code> type.
         * 
         * Group: common
         */
        default SpringWebserviceEndpointProducerBuilder messageFilter(
                Object messageFilter) {
            setProperty("messageFilter", messageFilter);
            return this;
        }
        /**
         * Option to provide a custom MessageFilter. For example when you want
         * to process your headers or attachments by your own.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.spring.ws.filter.MessageFilter</code> type.
         * 
         * Group: common
         */
        default SpringWebserviceEndpointProducerBuilder messageFilter(
                String messageFilter) {
            setProperty("messageFilter", messageFilter);
            return this;
        }
        /**
         * Option to override soap response attachments in in/out exchange with
         * attachments from the actual service layer. If the invoked service
         * appends or rewrites the soap attachments this option when set to
         * true, allows the modified soap attachments to be overwritten in
         * in/out message attachments.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default SpringWebserviceEndpointProducerBuilder allowResponseAttachmentOverride(
                boolean allowResponseAttachmentOverride) {
            setProperty("allowResponseAttachmentOverride", allowResponseAttachmentOverride);
            return this;
        }
        /**
         * Option to override soap response attachments in in/out exchange with
         * attachments from the actual service layer. If the invoked service
         * appends or rewrites the soap attachments this option when set to
         * true, allows the modified soap attachments to be overwritten in
         * in/out message attachments.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default SpringWebserviceEndpointProducerBuilder allowResponseAttachmentOverride(
                String allowResponseAttachmentOverride) {
            setProperty("allowResponseAttachmentOverride", allowResponseAttachmentOverride);
            return this;
        }
        /**
         * Option to override soap response header in in/out exchange with
         * header info from the actual service layer. If the invoked service
         * appends or rewrites the soap header this option when set to true,
         * allows the modified soap header to be overwritten in in/out message
         * headers.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default SpringWebserviceEndpointProducerBuilder allowResponseHeaderOverride(
                boolean allowResponseHeaderOverride) {
            setProperty("allowResponseHeaderOverride", allowResponseHeaderOverride);
            return this;
        }
        /**
         * Option to override soap response header in in/out exchange with
         * header info from the actual service layer. If the invoked service
         * appends or rewrites the soap header this option when set to true,
         * allows the modified soap header to be overwritten in in/out message
         * headers.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default SpringWebserviceEndpointProducerBuilder allowResponseHeaderOverride(
                String allowResponseHeaderOverride) {
            setProperty("allowResponseHeaderOverride", allowResponseHeaderOverride);
            return this;
        }
        /**
         * Signifies the value for the faultAction response WS-Addressing Fault
         * Action header that is provided by the method.
         * 
         * The option is a: <code>java.net.URI</code> type.
         * 
         * Group: producer
         */
        default SpringWebserviceEndpointProducerBuilder faultAction(
                URI faultAction) {
            setProperty("faultAction", faultAction);
            return this;
        }
        /**
         * Signifies the value for the faultAction response WS-Addressing Fault
         * Action header that is provided by the method.
         * 
         * The option will be converted to a <code>java.net.URI</code> type.
         * 
         * Group: producer
         */
        default SpringWebserviceEndpointProducerBuilder faultAction(
                String faultAction) {
            setProperty("faultAction", faultAction);
            return this;
        }
        /**
         * Signifies the value for the faultAction response WS-Addressing
         * FaultTo header that is provided by the method.
         * 
         * The option is a: <code>java.net.URI</code> type.
         * 
         * Group: producer
         */
        default SpringWebserviceEndpointProducerBuilder faultTo(URI faultTo) {
            setProperty("faultTo", faultTo);
            return this;
        }
        /**
         * Signifies the value for the faultAction response WS-Addressing
         * FaultTo header that is provided by the method.
         * 
         * The option will be converted to a <code>java.net.URI</code> type.
         * 
         * Group: producer
         */
        default SpringWebserviceEndpointProducerBuilder faultTo(String faultTo) {
            setProperty("faultTo", faultTo);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default SpringWebserviceEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            setProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default SpringWebserviceEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            setProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Option to provide a custom WebServiceMessageFactory. For example when
         * you want Apache Axiom to handle web service messages instead of SAAJ.
         * 
         * The option is a:
         * <code>org.springframework.ws.WebServiceMessageFactory</code> type.
         * 
         * Group: producer
         */
        default SpringWebserviceEndpointProducerBuilder messageFactory(
                Object messageFactory) {
            setProperty("messageFactory", messageFactory);
            return this;
        }
        /**
         * Option to provide a custom WebServiceMessageFactory. For example when
         * you want Apache Axiom to handle web service messages instead of SAAJ.
         * 
         * The option will be converted to a
         * <code>org.springframework.ws.WebServiceMessageFactory</code> type.
         * 
         * Group: producer
         */
        default SpringWebserviceEndpointProducerBuilder messageFactory(
                String messageFactory) {
            setProperty("messageFactory", messageFactory);
            return this;
        }
        /**
         * Option to provide a custom MessageIdStrategy to control generation of
         * unique message ids.
         * 
         * The option is a:
         * <code>org.springframework.ws.soap.addressing.messageid.MessageIdStrategy</code> type.
         * 
         * Group: producer
         */
        default SpringWebserviceEndpointProducerBuilder messageIdStrategy(
                Object messageIdStrategy) {
            setProperty("messageIdStrategy", messageIdStrategy);
            return this;
        }
        /**
         * Option to provide a custom MessageIdStrategy to control generation of
         * unique message ids.
         * 
         * The option will be converted to a
         * <code>org.springframework.ws.soap.addressing.messageid.MessageIdStrategy</code> type.
         * 
         * Group: producer
         */
        default SpringWebserviceEndpointProducerBuilder messageIdStrategy(
                String messageIdStrategy) {
            setProperty("messageIdStrategy", messageIdStrategy);
            return this;
        }
        /**
         * Option to provide a custom WebServiceMessageSender. For example to
         * perform authentication or use alternative transports.
         * 
         * The option is a:
         * <code>org.springframework.ws.transport.WebServiceMessageSender</code>
         * type.
         * 
         * Group: producer
         */
        default SpringWebserviceEndpointProducerBuilder messageSender(
                Object messageSender) {
            setProperty("messageSender", messageSender);
            return this;
        }
        /**
         * Option to provide a custom WebServiceMessageSender. For example to
         * perform authentication or use alternative transports.
         * 
         * The option will be converted to a
         * <code>org.springframework.ws.transport.WebServiceMessageSender</code>
         * type.
         * 
         * Group: producer
         */
        default SpringWebserviceEndpointProducerBuilder messageSender(
                String messageSender) {
            setProperty("messageSender", messageSender);
            return this;
        }
        /**
         * Signifies the value for the response WS-Addressing Action header that
         * is provided by the method.
         * 
         * The option is a: <code>java.net.URI</code> type.
         * 
         * Group: producer
         */
        default SpringWebserviceEndpointProducerBuilder outputAction(
                URI outputAction) {
            setProperty("outputAction", outputAction);
            return this;
        }
        /**
         * Signifies the value for the response WS-Addressing Action header that
         * is provided by the method.
         * 
         * The option will be converted to a <code>java.net.URI</code> type.
         * 
         * Group: producer
         */
        default SpringWebserviceEndpointProducerBuilder outputAction(
                String outputAction) {
            setProperty("outputAction", outputAction);
            return this;
        }
        /**
         * Signifies the value for the replyTo response WS-Addressing ReplyTo
         * header that is provided by the method.
         * 
         * The option is a: <code>java.net.URI</code> type.
         * 
         * Group: producer
         */
        default SpringWebserviceEndpointProducerBuilder replyTo(URI replyTo) {
            setProperty("replyTo", replyTo);
            return this;
        }
        /**
         * Signifies the value for the replyTo response WS-Addressing ReplyTo
         * header that is provided by the method.
         * 
         * The option will be converted to a <code>java.net.URI</code> type.
         * 
         * Group: producer
         */
        default SpringWebserviceEndpointProducerBuilder replyTo(String replyTo) {
            setProperty("replyTo", replyTo);
            return this;
        }
        /**
         * SOAP action to include inside a SOAP request when accessing remote
         * web services.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default SpringWebserviceEndpointProducerBuilder soapAction(
                String soapAction) {
            setProperty("soapAction", soapAction);
            return this;
        }
        /**
         * Sets the socket read timeout (in milliseconds) while invoking a
         * webservice using the producer, see URLConnection.setReadTimeout() and
         * CommonsHttpMessageSender.setReadTimeout(). This option works when
         * using the built-in message sender implementations:
         * CommonsHttpMessageSender and HttpUrlConnectionMessageSender. One of
         * these implementations will be used by default for HTTP based services
         * unless you customize the Spring WS configuration options supplied to
         * the component. If you are using a non-standard sender, it is assumed
         * that you will handle your own timeout configuration. The built-in
         * message sender HttpComponentsMessageSender is considered instead of
         * CommonsHttpMessageSender which has been deprecated, see
         * HttpComponentsMessageSender.setReadTimeout().
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: producer
         */
        default SpringWebserviceEndpointProducerBuilder timeout(int timeout) {
            setProperty("timeout", timeout);
            return this;
        }
        /**
         * Sets the socket read timeout (in milliseconds) while invoking a
         * webservice using the producer, see URLConnection.setReadTimeout() and
         * CommonsHttpMessageSender.setReadTimeout(). This option works when
         * using the built-in message sender implementations:
         * CommonsHttpMessageSender and HttpUrlConnectionMessageSender. One of
         * these implementations will be used by default for HTTP based services
         * unless you customize the Spring WS configuration options supplied to
         * the component. If you are using a non-standard sender, it is assumed
         * that you will handle your own timeout configuration. The built-in
         * message sender HttpComponentsMessageSender is considered instead of
         * CommonsHttpMessageSender which has been deprecated, see
         * HttpComponentsMessageSender.setReadTimeout().
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: producer
         */
        default SpringWebserviceEndpointProducerBuilder timeout(String timeout) {
            setProperty("timeout", timeout);
            return this;
        }
        /**
         * Option to provide a custom WebServiceTemplate. This allows for full
         * control over client-side web services handling; like adding a custom
         * interceptor or specifying a fault resolver, message sender or message
         * factory.
         * 
         * The option is a:
         * <code>org.springframework.ws.client.core.WebServiceTemplate</code>
         * type.
         * 
         * Group: producer
         */
        default SpringWebserviceEndpointProducerBuilder webServiceTemplate(
                Object webServiceTemplate) {
            setProperty("webServiceTemplate", webServiceTemplate);
            return this;
        }
        /**
         * Option to provide a custom WebServiceTemplate. This allows for full
         * control over client-side web services handling; like adding a custom
         * interceptor or specifying a fault resolver, message sender or message
         * factory.
         * 
         * The option will be converted to a
         * <code>org.springframework.ws.client.core.WebServiceTemplate</code>
         * type.
         * 
         * Group: producer
         */
        default SpringWebserviceEndpointProducerBuilder webServiceTemplate(
                String webServiceTemplate) {
            setProperty("webServiceTemplate", webServiceTemplate);
            return this;
        }
        /**
         * WS-Addressing 1.0 action header to include when accessing web
         * services. The To header is set to the address of the web service as
         * specified in the endpoint URI (default Spring-WS behavior).
         * 
         * The option is a: <code>java.net.URI</code> type.
         * 
         * Group: producer
         */
        default SpringWebserviceEndpointProducerBuilder wsAddressingAction(
                URI wsAddressingAction) {
            setProperty("wsAddressingAction", wsAddressingAction);
            return this;
        }
        /**
         * WS-Addressing 1.0 action header to include when accessing web
         * services. The To header is set to the address of the web service as
         * specified in the endpoint URI (default Spring-WS behavior).
         * 
         * The option will be converted to a <code>java.net.URI</code> type.
         * 
         * Group: producer
         */
        default SpringWebserviceEndpointProducerBuilder wsAddressingAction(
                String wsAddressingAction) {
            setProperty("wsAddressingAction", wsAddressingAction);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default SpringWebserviceEndpointProducerBuilder sslContextParameters(
                Object sslContextParameters) {
            setProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default SpringWebserviceEndpointProducerBuilder sslContextParameters(
                String sslContextParameters) {
            setProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Spring WebService
     * component.
     */
    public interface AdvancedSpringWebserviceEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default SpringWebserviceEndpointProducerBuilder basic() {
            return (SpringWebserviceEndpointProducerBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSpringWebserviceEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSpringWebserviceEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSpringWebserviceEndpointProducerBuilder synchronous(
                boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSpringWebserviceEndpointProducerBuilder synchronous(
                String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Spring WebService component.
     */
    public interface SpringWebserviceEndpointBuilder
            extends
                SpringWebserviceEndpointConsumerBuilder, SpringWebserviceEndpointProducerBuilder {
        default AdvancedSpringWebserviceEndpointBuilder advanced() {
            return (AdvancedSpringWebserviceEndpointBuilder) this;
        }
        /**
         * Option to provide a custom MessageFilter. For example when you want
         * to process your headers or attachments by your own.
         * 
         * The option is a:
         * <code>org.apache.camel.component.spring.ws.filter.MessageFilter</code> type.
         * 
         * Group: common
         */
        default SpringWebserviceEndpointBuilder messageFilter(
                Object messageFilter) {
            setProperty("messageFilter", messageFilter);
            return this;
        }
        /**
         * Option to provide a custom MessageFilter. For example when you want
         * to process your headers or attachments by your own.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.spring.ws.filter.MessageFilter</code> type.
         * 
         * Group: common
         */
        default SpringWebserviceEndpointBuilder messageFilter(
                String messageFilter) {
            setProperty("messageFilter", messageFilter);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default SpringWebserviceEndpointBuilder sslContextParameters(
                Object sslContextParameters) {
            setProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default SpringWebserviceEndpointBuilder sslContextParameters(
                String sslContextParameters) {
            setProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Spring WebService component.
     */
    public interface AdvancedSpringWebserviceEndpointBuilder
            extends
                AdvancedSpringWebserviceEndpointConsumerBuilder, AdvancedSpringWebserviceEndpointProducerBuilder {
        default SpringWebserviceEndpointBuilder basic() {
            return (SpringWebserviceEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSpringWebserviceEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSpringWebserviceEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSpringWebserviceEndpointBuilder synchronous(
                boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSpringWebserviceEndpointBuilder synchronous(
                String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }
    /**
     * Spring WebService (camel-spring-ws)
     * The spring-ws component is used for SOAP WebServices using Spring
     * WebServices.
     * 
     * Category: spring,soap,webservice
     * Available as of version: 2.6
     * Maven coordinates: org.apache.camel:camel-spring-ws
     * 
     * Syntax: <code>spring-ws:type:lookupKey:webServiceEndpointUri</code>
     * 
     * Path parameter: type
     * Endpoint mapping type if endpoint mapping is used. rootqname - Offers the
     * option to map web service requests based on the qualified name of the
     * root element contained in the message. soapaction - Used to map web
     * service requests based on the SOAP action specified in the header of the
     * message. uri - In order to map web service requests that target a
     * specific URI. xpathresult - Used to map web service requests based on the
     * evaluation of an XPath expression against the incoming message. The
     * result of the evaluation should match the XPath result specified in the
     * endpoint URI. beanname - Allows you to reference an
     * org.apache.camel.component.spring.ws.bean.CamelEndpointDispatcher object
     * in order to integrate with existing (legacy) endpoint mappings like
     * PayloadRootQNameEndpointMapping, SoapActionEndpointMapping, etc
     * The value can be one of: ROOT_QNAME, ACTION, TO, SOAP_ACTION,
     * XPATHRESULT, URI, URI_PATH, BEANNAME
     * 
     * Path parameter: lookupKey
     * Endpoint mapping key if endpoint mapping is used
     * 
     * Path parameter: webServiceEndpointUri
     * The default Web Service endpoint uri to use for the producer.
     * 
     * Path parameter: expression
     * The XPath expression to use when option type=xpathresult. Then this
     * option is required to be configured.
     */
    default SpringWebserviceEndpointBuilder springWebservice(String path) {
        class SpringWebserviceEndpointBuilderImpl extends AbstractEndpointBuilder implements SpringWebserviceEndpointBuilder, AdvancedSpringWebserviceEndpointBuilder {
            public SpringWebserviceEndpointBuilderImpl(String path) {
                super("spring-ws", path);
            }
        }
        return new SpringWebserviceEndpointBuilderImpl(path);
    }
}