/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.HeaderFilterStrategy;

/**
 * The sjms component (simple jms) allows messages to be sent to (or consumed
 * from) a JMS Queue or Topic (uses JMS 1.x API).
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface SjmsEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Simple JMS component.
     */
    public interface SjmsEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedSjmsEndpointConsumerBuilder advanced() {
            return (AdvancedSjmsEndpointConsumerBuilder) this;
        }
        /**
         * The JMS acknowledgement name, which is one of: SESSION_TRANSACTED,
         * CLIENT_ACKNOWLEDGE, AUTO_ACKNOWLEDGE, DUPS_OK_ACKNOWLEDGE.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sjms.jms.SessionAcknowledgementType</code> type.
         * 
         * Group: common
         */
        default SjmsEndpointConsumerBuilder acknowledgementMode(
                SessionAcknowledgementType acknowledgementMode) {
            setProperty("acknowledgementMode", acknowledgementMode);
            return this;
        }
        /**
         * The JMS acknowledgement name, which is one of: SESSION_TRANSACTED,
         * CLIENT_ACKNOWLEDGE, AUTO_ACKNOWLEDGE, DUPS_OK_ACKNOWLEDGE.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sjms.jms.SessionAcknowledgementType</code> type.
         * 
         * Group: common
         */
        default SjmsEndpointConsumerBuilder acknowledgementMode(
                String acknowledgementMode) {
            setProperty("acknowledgementMode", acknowledgementMode);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default SjmsEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            setProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default SjmsEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            setProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Sets the number of consumer listeners used for this endpoint.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: consumer
         */
        default SjmsEndpointConsumerBuilder consumerCount(int consumerCount) {
            setProperty("consumerCount", consumerCount);
            return this;
        }
        /**
         * Sets the number of consumer listeners used for this endpoint.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: consumer
         */
        default SjmsEndpointConsumerBuilder consumerCount(String consumerCount) {
            setProperty("consumerCount", consumerCount);
            return this;
        }
        /**
         * Sets the durable subscription Id required for durable topics.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default SjmsEndpointConsumerBuilder durableSubscriptionId(
                String durableSubscriptionId) {
            setProperty("durableSubscriptionId", durableSubscriptionId);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default SjmsEndpointConsumerBuilder synchronous(boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default SjmsEndpointConsumerBuilder synchronous(String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Allows to configure the default errorHandler logging level for
         * logging uncaught exceptions.
         * 
         * The option is a: <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Group: logging
         */
        default SjmsEndpointConsumerBuilder errorHandlerLoggingLevel(
                LoggingLevel errorHandlerLoggingLevel) {
            setProperty("errorHandlerLoggingLevel", errorHandlerLoggingLevel);
            return this;
        }
        /**
         * Allows to configure the default errorHandler logging level for
         * logging uncaught exceptions.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Group: logging
         */
        default SjmsEndpointConsumerBuilder errorHandlerLoggingLevel(
                String errorHandlerLoggingLevel) {
            setProperty("errorHandlerLoggingLevel", errorHandlerLoggingLevel);
            return this;
        }
        /**
         * Allows to control whether stacktraces should be logged or not, by the
         * default errorHandler.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: logging
         */
        default SjmsEndpointConsumerBuilder errorHandlerLogStackTrace(
                boolean errorHandlerLogStackTrace) {
            setProperty("errorHandlerLogStackTrace", errorHandlerLogStackTrace);
            return this;
        }
        /**
         * Allows to control whether stacktraces should be logged or not, by the
         * default errorHandler.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: logging
         */
        default SjmsEndpointConsumerBuilder errorHandlerLogStackTrace(
                String errorHandlerLogStackTrace) {
            setProperty("errorHandlerLogStackTrace", errorHandlerLogStackTrace);
            return this;
        }
        /**
         * Specifies whether to use transacted mode.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: transaction
         */
        default SjmsEndpointConsumerBuilder transacted(boolean transacted) {
            setProperty("transacted", transacted);
            return this;
        }
        /**
         * Specifies whether to use transacted mode.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: transaction
         */
        default SjmsEndpointConsumerBuilder transacted(String transacted) {
            setProperty("transacted", transacted);
            return this;
        }
        /**
         * If transacted sets the number of messages to process before
         * committing a transaction.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: transaction
         */
        default SjmsEndpointConsumerBuilder transactionBatchCount(
                int transactionBatchCount) {
            setProperty("transactionBatchCount", transactionBatchCount);
            return this;
        }
        /**
         * If transacted sets the number of messages to process before
         * committing a transaction.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: transaction
         */
        default SjmsEndpointConsumerBuilder transactionBatchCount(
                String transactionBatchCount) {
            setProperty("transactionBatchCount", transactionBatchCount);
            return this;
        }
        /**
         * Sets timeout (in millis) for batch transactions, the value should be
         * 1000 or higher.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: transaction
         */
        default SjmsEndpointConsumerBuilder transactionBatchTimeout(
                long transactionBatchTimeout) {
            setProperty("transactionBatchTimeout", transactionBatchTimeout);
            return this;
        }
        /**
         * Sets timeout (in millis) for batch transactions, the value should be
         * 1000 or higher.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: transaction
         */
        default SjmsEndpointConsumerBuilder transactionBatchTimeout(
                String transactionBatchTimeout) {
            setProperty("transactionBatchTimeout", transactionBatchTimeout);
            return this;
        }
        /**
         * Sets the commit strategy.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sjms.TransactionCommitStrategy</code> type.
         * 
         * Group: transaction
         */
        default SjmsEndpointConsumerBuilder transactionCommitStrategy(
                Object transactionCommitStrategy) {
            setProperty("transactionCommitStrategy", transactionCommitStrategy);
            return this;
        }
        /**
         * Sets the commit strategy.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sjms.TransactionCommitStrategy</code> type.
         * 
         * Group: transaction
         */
        default SjmsEndpointConsumerBuilder transactionCommitStrategy(
                String transactionCommitStrategy) {
            setProperty("transactionCommitStrategy", transactionCommitStrategy);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Simple JMS component.
     */
    public interface AdvancedSjmsEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default SjmsEndpointConsumerBuilder basic() {
            return (SjmsEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedSjmsEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            setProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedSjmsEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            setProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedSjmsEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            setProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedSjmsEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            setProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the JMS Message selector syntax.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedSjmsEndpointConsumerBuilder messageSelector(
                String messageSelector) {
            setProperty("messageSelector", messageSelector);
            return this;
        }
        /**
         * Whether to startup the consumer message listener asynchronously, when
         * starting a route. For example if a JmsConsumer cannot get a
         * connection to a remote JMS broker, then it may block while retrying
         * and/or failover. This will cause Camel to block while starting
         * routes. By setting this option to true, you will let routes startup,
         * while the JmsConsumer connects to the JMS broker using a dedicated
         * thread in asynchronous mode. If this option is used, then beware that
         * if the connection could not be established, then an exception is
         * logged at WARN level, and the consumer will not be able to receive
         * messages; You can then restart the route to retry.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointConsumerBuilder asyncStartListener(
                boolean asyncStartListener) {
            setProperty("asyncStartListener", asyncStartListener);
            return this;
        }
        /**
         * Whether to startup the consumer message listener asynchronously, when
         * starting a route. For example if a JmsConsumer cannot get a
         * connection to a remote JMS broker, then it may block while retrying
         * and/or failover. This will cause Camel to block while starting
         * routes. By setting this option to true, you will let routes startup,
         * while the JmsConsumer connects to the JMS broker using a dedicated
         * thread in asynchronous mode. If this option is used, then beware that
         * if the connection could not be established, then an exception is
         * logged at WARN level, and the consumer will not be able to receive
         * messages; You can then restart the route to retry.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointConsumerBuilder asyncStartListener(
                String asyncStartListener) {
            setProperty("asyncStartListener", asyncStartListener);
            return this;
        }
        /**
         * Whether to stop the consumer message listener asynchronously, when
         * stopping a route.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointConsumerBuilder asyncStopListener(
                boolean asyncStopListener) {
            setProperty("asyncStopListener", asyncStopListener);
            return this;
        }
        /**
         * Whether to stop the consumer message listener asynchronously, when
         * stopping a route.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointConsumerBuilder asyncStopListener(
                String asyncStopListener) {
            setProperty("asyncStopListener", asyncStopListener);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * The maximum number of connections available to this endpoint.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointConsumerBuilder connectionCount(
                Integer connectionCount) {
            setProperty("connectionCount", connectionCount);
            return this;
        }
        /**
         * The maximum number of connections available to this endpoint.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointConsumerBuilder connectionCount(
                String connectionCount) {
            setProperty("connectionCount", connectionCount);
            return this;
        }
        /**
         * Initializes the connectionFactory for the endpoint, which takes
         * precedence over the component's connectionFactory, if any.
         * 
         * The option is a: <code>javax.jms.ConnectionFactory</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointConsumerBuilder connectionFactory(
                Object connectionFactory) {
            setProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * Initializes the connectionFactory for the endpoint, which takes
         * precedence over the component's connectionFactory, if any.
         * 
         * The option will be converted to a
         * <code>javax.jms.ConnectionFactory</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointConsumerBuilder connectionFactory(
                String connectionFactory) {
            setProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * Initializes the connectionResource for the endpoint, which takes
         * precedence over the component's connectionResource, if any.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sjms.jms.ConnectionResource</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointConsumerBuilder connectionResource(
                Object connectionResource) {
            setProperty("connectionResource", connectionResource);
            return this;
        }
        /**
         * Initializes the connectionResource for the endpoint, which takes
         * precedence over the component's connectionResource, if any.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sjms.jms.ConnectionResource</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointConsumerBuilder connectionResource(
                String connectionResource) {
            setProperty("connectionResource", connectionResource);
            return this;
        }
        /**
         * To use a custom DestinationCreationStrategy.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sjms.jms.DestinationCreationStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointConsumerBuilder destinationCreationStrategy(
                Object destinationCreationStrategy) {
            setProperty("destinationCreationStrategy", destinationCreationStrategy);
            return this;
        }
        /**
         * To use a custom DestinationCreationStrategy.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sjms.jms.DestinationCreationStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointConsumerBuilder destinationCreationStrategy(
                String destinationCreationStrategy) {
            setProperty("destinationCreationStrategy", destinationCreationStrategy);
            return this;
        }
        /**
         * Specifies the JMS Exception Listener that is to be notified of any
         * underlying JMS exceptions.
         * 
         * The option is a: <code>javax.jms.ExceptionListener</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointConsumerBuilder exceptionListener(
                Object exceptionListener) {
            setProperty("exceptionListener", exceptionListener);
            return this;
        }
        /**
         * Specifies the JMS Exception Listener that is to be notified of any
         * underlying JMS exceptions.
         * 
         * The option will be converted to a
         * <code>javax.jms.ExceptionListener</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointConsumerBuilder exceptionListener(
                String exceptionListener) {
            setProperty("exceptionListener", exceptionListener);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointConsumerBuilder headerFilterStrategy(
                HeaderFilterStrategy headerFilterStrategy) {
            setProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointConsumerBuilder headerFilterStrategy(
                String headerFilterStrategy) {
            setProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * Whether to include all JMSXxxx properties when mapping from JMS to
         * Camel Message. Setting this to true will include properties such as
         * JMSXAppID, and JMSXUserID etc. Note: If you are using a custom
         * headerFilterStrategy then this option does not apply.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointConsumerBuilder includeAllJMSXProperties(
                boolean includeAllJMSXProperties) {
            setProperty("includeAllJMSXProperties", includeAllJMSXProperties);
            return this;
        }
        /**
         * Whether to include all JMSXxxx properties when mapping from JMS to
         * Camel Message. Setting this to true will include properties such as
         * JMSXAppID, and JMSXUserID etc. Note: If you are using a custom
         * headerFilterStrategy then this option does not apply.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointConsumerBuilder includeAllJMSXProperties(
                String includeAllJMSXProperties) {
            setProperty("includeAllJMSXProperties", includeAllJMSXProperties);
            return this;
        }
        /**
         * Pluggable strategy for encoding and decoding JMS keys so they can be
         * compliant with the JMS specification. Camel provides two
         * implementations out of the box: default and passthrough. The default
         * strategy will safely marshal dots and hyphens (. and -). The
         * passthrough strategy leaves the key as is. Can be used for JMS
         * brokers which do not care whether JMS header keys contain illegal
         * characters. You can provide your own implementation of the
         * org.apache.camel.component.jms.JmsKeyFormatStrategy and refer to it
         * using the # notation.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sjms.jms.JmsKeyFormatStrategy</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointConsumerBuilder jmsKeyFormatStrategy(
                Object jmsKeyFormatStrategy) {
            setProperty("jmsKeyFormatStrategy", jmsKeyFormatStrategy);
            return this;
        }
        /**
         * Pluggable strategy for encoding and decoding JMS keys so they can be
         * compliant with the JMS specification. Camel provides two
         * implementations out of the box: default and passthrough. The default
         * strategy will safely marshal dots and hyphens (. and -). The
         * passthrough strategy leaves the key as is. Can be used for JMS
         * brokers which do not care whether JMS header keys contain illegal
         * characters. You can provide your own implementation of the
         * org.apache.camel.component.jms.JmsKeyFormatStrategy and refer to it
         * using the # notation.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sjms.jms.JmsKeyFormatStrategy</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointConsumerBuilder jmsKeyFormatStrategy(
                String jmsKeyFormatStrategy) {
            setProperty("jmsKeyFormatStrategy", jmsKeyFormatStrategy);
            return this;
        }
        /**
         * Specifies whether Camel should auto map the received JMS message to a
         * suited payload type, such as javax.jms.TextMessage to a String etc.
         * See section about how mapping works below for more details.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointConsumerBuilder mapJmsMessage(
                boolean mapJmsMessage) {
            setProperty("mapJmsMessage", mapJmsMessage);
            return this;
        }
        /**
         * Specifies whether Camel should auto map the received JMS message to a
         * suited payload type, such as javax.jms.TextMessage to a String etc.
         * See section about how mapping works below for more details.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointConsumerBuilder mapJmsMessage(
                String mapJmsMessage) {
            setProperty("mapJmsMessage", mapJmsMessage);
            return this;
        }
        /**
         * To use the given MessageCreatedStrategy which are invoked when Camel
         * creates new instances of javax.jms.Message objects when Camel is
         * sending a JMS message.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sjms.jms.MessageCreatedStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointConsumerBuilder messageCreatedStrategy(
                Object messageCreatedStrategy) {
            setProperty("messageCreatedStrategy", messageCreatedStrategy);
            return this;
        }
        /**
         * To use the given MessageCreatedStrategy which are invoked when Camel
         * creates new instances of javax.jms.Message objects when Camel is
         * sending a JMS message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sjms.jms.MessageCreatedStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointConsumerBuilder messageCreatedStrategy(
                String messageCreatedStrategy) {
            setProperty("messageCreatedStrategy", messageCreatedStrategy);
            return this;
        }
        /**
         * Specifies whether to share JMS session with other SJMS endpoints.
         * Turn this off if your route is accessing to multiple JMS providers.
         * If you need transaction against multiple JMS providers, use jms
         * component to leverage XA transaction.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: transaction (advanced)
         */
        default AdvancedSjmsEndpointConsumerBuilder sharedJMSSession(
                boolean sharedJMSSession) {
            setProperty("sharedJMSSession", sharedJMSSession);
            return this;
        }
        /**
         * Specifies whether to share JMS session with other SJMS endpoints.
         * Turn this off if your route is accessing to multiple JMS providers.
         * If you need transaction against multiple JMS providers, use jms
         * component to leverage XA transaction.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: transaction (advanced)
         */
        default AdvancedSjmsEndpointConsumerBuilder sharedJMSSession(
                String sharedJMSSession) {
            setProperty("sharedJMSSession", sharedJMSSession);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Simple JMS component.
     */
    public interface SjmsEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedSjmsEndpointProducerBuilder advanced() {
            return (AdvancedSjmsEndpointProducerBuilder) this;
        }
        /**
         * The JMS acknowledgement name, which is one of: SESSION_TRANSACTED,
         * CLIENT_ACKNOWLEDGE, AUTO_ACKNOWLEDGE, DUPS_OK_ACKNOWLEDGE.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sjms.jms.SessionAcknowledgementType</code> type.
         * 
         * Group: common
         */
        default SjmsEndpointProducerBuilder acknowledgementMode(
                SessionAcknowledgementType acknowledgementMode) {
            setProperty("acknowledgementMode", acknowledgementMode);
            return this;
        }
        /**
         * The JMS acknowledgement name, which is one of: SESSION_TRANSACTED,
         * CLIENT_ACKNOWLEDGE, AUTO_ACKNOWLEDGE, DUPS_OK_ACKNOWLEDGE.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sjms.jms.SessionAcknowledgementType</code> type.
         * 
         * Group: common
         */
        default SjmsEndpointProducerBuilder acknowledgementMode(
                String acknowledgementMode) {
            setProperty("acknowledgementMode", acknowledgementMode);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default SjmsEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            setProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default SjmsEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            setProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Sets the reply to destination name used for InOut producer endpoints.
         * The type of the reply to destination can be determined by the
         * starting prefix (topic: or queue:) in its name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default SjmsEndpointProducerBuilder namedReplyTo(String namedReplyTo) {
            setProperty("namedReplyTo", namedReplyTo);
            return this;
        }
        /**
         * Flag used to enable/disable message persistence.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default SjmsEndpointProducerBuilder persistent(boolean persistent) {
            setProperty("persistent", persistent);
            return this;
        }
        /**
         * Flag used to enable/disable message persistence.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default SjmsEndpointProducerBuilder persistent(String persistent) {
            setProperty("persistent", persistent);
            return this;
        }
        /**
         * Sets the number of producers used for this endpoint.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: producer
         */
        default SjmsEndpointProducerBuilder producerCount(int producerCount) {
            setProperty("producerCount", producerCount);
            return this;
        }
        /**
         * Sets the number of producers used for this endpoint.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: producer
         */
        default SjmsEndpointProducerBuilder producerCount(String producerCount) {
            setProperty("producerCount", producerCount);
            return this;
        }
        /**
         * Flag used to adjust the Time To Live value of produced messages.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: producer
         */
        default SjmsEndpointProducerBuilder ttl(long ttl) {
            setProperty("ttl", ttl);
            return this;
        }
        /**
         * Flag used to adjust the Time To Live value of produced messages.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: producer
         */
        default SjmsEndpointProducerBuilder ttl(String ttl) {
            setProperty("ttl", ttl);
            return this;
        }
        /**
         * Sets the commit strategy.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sjms.TransactionCommitStrategy</code> type.
         * 
         * Group: transaction
         */
        default SjmsEndpointProducerBuilder transactionCommitStrategy(
                Object transactionCommitStrategy) {
            setProperty("transactionCommitStrategy", transactionCommitStrategy);
            return this;
        }
        /**
         * Sets the commit strategy.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sjms.TransactionCommitStrategy</code> type.
         * 
         * Group: transaction
         */
        default SjmsEndpointProducerBuilder transactionCommitStrategy(
                String transactionCommitStrategy) {
            setProperty("transactionCommitStrategy", transactionCommitStrategy);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Simple JMS component.
     */
    public interface AdvancedSjmsEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default SjmsEndpointProducerBuilder basic() {
            return (SjmsEndpointProducerBuilder) this;
        }
        /**
         * Whether to allow sending messages with no body. If this option is
         * false and the message body is null, then an JMSException is thrown.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer (advanced)
         */
        default AdvancedSjmsEndpointProducerBuilder allowNullBody(
                boolean allowNullBody) {
            setProperty("allowNullBody", allowNullBody);
            return this;
        }
        /**
         * Whether to allow sending messages with no body. If this option is
         * false and the message body is null, then an JMSException is thrown.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer (advanced)
         */
        default AdvancedSjmsEndpointProducerBuilder allowNullBody(
                String allowNullBody) {
            setProperty("allowNullBody", allowNullBody);
            return this;
        }
        /**
         * Whether to prefill the producer connection pool on startup, or create
         * connections lazy when needed.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer (advanced)
         */
        default AdvancedSjmsEndpointProducerBuilder prefillPool(
                boolean prefillPool) {
            setProperty("prefillPool", prefillPool);
            return this;
        }
        /**
         * Whether to prefill the producer connection pool on startup, or create
         * connections lazy when needed.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer (advanced)
         */
        default AdvancedSjmsEndpointProducerBuilder prefillPool(
                String prefillPool) {
            setProperty("prefillPool", prefillPool);
            return this;
        }
        /**
         * Sets the amount of time we should wait before timing out a InOut
         * response.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: producer (advanced)
         */
        default AdvancedSjmsEndpointProducerBuilder responseTimeOut(
                long responseTimeOut) {
            setProperty("responseTimeOut", responseTimeOut);
            return this;
        }
        /**
         * Sets the amount of time we should wait before timing out a InOut
         * response.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: producer (advanced)
         */
        default AdvancedSjmsEndpointProducerBuilder responseTimeOut(
                String responseTimeOut) {
            setProperty("responseTimeOut", responseTimeOut);
            return this;
        }
        /**
         * Whether to startup the consumer message listener asynchronously, when
         * starting a route. For example if a JmsConsumer cannot get a
         * connection to a remote JMS broker, then it may block while retrying
         * and/or failover. This will cause Camel to block while starting
         * routes. By setting this option to true, you will let routes startup,
         * while the JmsConsumer connects to the JMS broker using a dedicated
         * thread in asynchronous mode. If this option is used, then beware that
         * if the connection could not be established, then an exception is
         * logged at WARN level, and the consumer will not be able to receive
         * messages; You can then restart the route to retry.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointProducerBuilder asyncStartListener(
                boolean asyncStartListener) {
            setProperty("asyncStartListener", asyncStartListener);
            return this;
        }
        /**
         * Whether to startup the consumer message listener asynchronously, when
         * starting a route. For example if a JmsConsumer cannot get a
         * connection to a remote JMS broker, then it may block while retrying
         * and/or failover. This will cause Camel to block while starting
         * routes. By setting this option to true, you will let routes startup,
         * while the JmsConsumer connects to the JMS broker using a dedicated
         * thread in asynchronous mode. If this option is used, then beware that
         * if the connection could not be established, then an exception is
         * logged at WARN level, and the consumer will not be able to receive
         * messages; You can then restart the route to retry.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointProducerBuilder asyncStartListener(
                String asyncStartListener) {
            setProperty("asyncStartListener", asyncStartListener);
            return this;
        }
        /**
         * Whether to stop the consumer message listener asynchronously, when
         * stopping a route.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointProducerBuilder asyncStopListener(
                boolean asyncStopListener) {
            setProperty("asyncStopListener", asyncStopListener);
            return this;
        }
        /**
         * Whether to stop the consumer message listener asynchronously, when
         * stopping a route.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointProducerBuilder asyncStopListener(
                String asyncStopListener) {
            setProperty("asyncStopListener", asyncStopListener);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * The maximum number of connections available to this endpoint.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointProducerBuilder connectionCount(
                Integer connectionCount) {
            setProperty("connectionCount", connectionCount);
            return this;
        }
        /**
         * The maximum number of connections available to this endpoint.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointProducerBuilder connectionCount(
                String connectionCount) {
            setProperty("connectionCount", connectionCount);
            return this;
        }
        /**
         * Initializes the connectionFactory for the endpoint, which takes
         * precedence over the component's connectionFactory, if any.
         * 
         * The option is a: <code>javax.jms.ConnectionFactory</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointProducerBuilder connectionFactory(
                Object connectionFactory) {
            setProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * Initializes the connectionFactory for the endpoint, which takes
         * precedence over the component's connectionFactory, if any.
         * 
         * The option will be converted to a
         * <code>javax.jms.ConnectionFactory</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointProducerBuilder connectionFactory(
                String connectionFactory) {
            setProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * Initializes the connectionResource for the endpoint, which takes
         * precedence over the component's connectionResource, if any.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sjms.jms.ConnectionResource</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointProducerBuilder connectionResource(
                Object connectionResource) {
            setProperty("connectionResource", connectionResource);
            return this;
        }
        /**
         * Initializes the connectionResource for the endpoint, which takes
         * precedence over the component's connectionResource, if any.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sjms.jms.ConnectionResource</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointProducerBuilder connectionResource(
                String connectionResource) {
            setProperty("connectionResource", connectionResource);
            return this;
        }
        /**
         * To use a custom DestinationCreationStrategy.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sjms.jms.DestinationCreationStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointProducerBuilder destinationCreationStrategy(
                Object destinationCreationStrategy) {
            setProperty("destinationCreationStrategy", destinationCreationStrategy);
            return this;
        }
        /**
         * To use a custom DestinationCreationStrategy.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sjms.jms.DestinationCreationStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointProducerBuilder destinationCreationStrategy(
                String destinationCreationStrategy) {
            setProperty("destinationCreationStrategy", destinationCreationStrategy);
            return this;
        }
        /**
         * Specifies the JMS Exception Listener that is to be notified of any
         * underlying JMS exceptions.
         * 
         * The option is a: <code>javax.jms.ExceptionListener</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointProducerBuilder exceptionListener(
                Object exceptionListener) {
            setProperty("exceptionListener", exceptionListener);
            return this;
        }
        /**
         * Specifies the JMS Exception Listener that is to be notified of any
         * underlying JMS exceptions.
         * 
         * The option will be converted to a
         * <code>javax.jms.ExceptionListener</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointProducerBuilder exceptionListener(
                String exceptionListener) {
            setProperty("exceptionListener", exceptionListener);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointProducerBuilder headerFilterStrategy(
                HeaderFilterStrategy headerFilterStrategy) {
            setProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointProducerBuilder headerFilterStrategy(
                String headerFilterStrategy) {
            setProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * Whether to include all JMSXxxx properties when mapping from JMS to
         * Camel Message. Setting this to true will include properties such as
         * JMSXAppID, and JMSXUserID etc. Note: If you are using a custom
         * headerFilterStrategy then this option does not apply.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointProducerBuilder includeAllJMSXProperties(
                boolean includeAllJMSXProperties) {
            setProperty("includeAllJMSXProperties", includeAllJMSXProperties);
            return this;
        }
        /**
         * Whether to include all JMSXxxx properties when mapping from JMS to
         * Camel Message. Setting this to true will include properties such as
         * JMSXAppID, and JMSXUserID etc. Note: If you are using a custom
         * headerFilterStrategy then this option does not apply.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointProducerBuilder includeAllJMSXProperties(
                String includeAllJMSXProperties) {
            setProperty("includeAllJMSXProperties", includeAllJMSXProperties);
            return this;
        }
        /**
         * Pluggable strategy for encoding and decoding JMS keys so they can be
         * compliant with the JMS specification. Camel provides two
         * implementations out of the box: default and passthrough. The default
         * strategy will safely marshal dots and hyphens (. and -). The
         * passthrough strategy leaves the key as is. Can be used for JMS
         * brokers which do not care whether JMS header keys contain illegal
         * characters. You can provide your own implementation of the
         * org.apache.camel.component.jms.JmsKeyFormatStrategy and refer to it
         * using the # notation.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sjms.jms.JmsKeyFormatStrategy</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointProducerBuilder jmsKeyFormatStrategy(
                Object jmsKeyFormatStrategy) {
            setProperty("jmsKeyFormatStrategy", jmsKeyFormatStrategy);
            return this;
        }
        /**
         * Pluggable strategy for encoding and decoding JMS keys so they can be
         * compliant with the JMS specification. Camel provides two
         * implementations out of the box: default and passthrough. The default
         * strategy will safely marshal dots and hyphens (. and -). The
         * passthrough strategy leaves the key as is. Can be used for JMS
         * brokers which do not care whether JMS header keys contain illegal
         * characters. You can provide your own implementation of the
         * org.apache.camel.component.jms.JmsKeyFormatStrategy and refer to it
         * using the # notation.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sjms.jms.JmsKeyFormatStrategy</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointProducerBuilder jmsKeyFormatStrategy(
                String jmsKeyFormatStrategy) {
            setProperty("jmsKeyFormatStrategy", jmsKeyFormatStrategy);
            return this;
        }
        /**
         * Specifies whether Camel should auto map the received JMS message to a
         * suited payload type, such as javax.jms.TextMessage to a String etc.
         * See section about how mapping works below for more details.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointProducerBuilder mapJmsMessage(
                boolean mapJmsMessage) {
            setProperty("mapJmsMessage", mapJmsMessage);
            return this;
        }
        /**
         * Specifies whether Camel should auto map the received JMS message to a
         * suited payload type, such as javax.jms.TextMessage to a String etc.
         * See section about how mapping works below for more details.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointProducerBuilder mapJmsMessage(
                String mapJmsMessage) {
            setProperty("mapJmsMessage", mapJmsMessage);
            return this;
        }
        /**
         * To use the given MessageCreatedStrategy which are invoked when Camel
         * creates new instances of javax.jms.Message objects when Camel is
         * sending a JMS message.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sjms.jms.MessageCreatedStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointProducerBuilder messageCreatedStrategy(
                Object messageCreatedStrategy) {
            setProperty("messageCreatedStrategy", messageCreatedStrategy);
            return this;
        }
        /**
         * To use the given MessageCreatedStrategy which are invoked when Camel
         * creates new instances of javax.jms.Message objects when Camel is
         * sending a JMS message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sjms.jms.MessageCreatedStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointProducerBuilder messageCreatedStrategy(
                String messageCreatedStrategy) {
            setProperty("messageCreatedStrategy", messageCreatedStrategy);
            return this;
        }
        /**
         * Specifies whether to share JMS session with other SJMS endpoints.
         * Turn this off if your route is accessing to multiple JMS providers.
         * If you need transaction against multiple JMS providers, use jms
         * component to leverage XA transaction.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: transaction (advanced)
         */
        default AdvancedSjmsEndpointProducerBuilder sharedJMSSession(
                boolean sharedJMSSession) {
            setProperty("sharedJMSSession", sharedJMSSession);
            return this;
        }
        /**
         * Specifies whether to share JMS session with other SJMS endpoints.
         * Turn this off if your route is accessing to multiple JMS providers.
         * If you need transaction against multiple JMS providers, use jms
         * component to leverage XA transaction.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: transaction (advanced)
         */
        default AdvancedSjmsEndpointProducerBuilder sharedJMSSession(
                String sharedJMSSession) {
            setProperty("sharedJMSSession", sharedJMSSession);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Simple JMS component.
     */
    public interface SjmsEndpointBuilder
            extends
                SjmsEndpointConsumerBuilder, SjmsEndpointProducerBuilder {
        default AdvancedSjmsEndpointBuilder advanced() {
            return (AdvancedSjmsEndpointBuilder) this;
        }
        /**
         * The JMS acknowledgement name, which is one of: SESSION_TRANSACTED,
         * CLIENT_ACKNOWLEDGE, AUTO_ACKNOWLEDGE, DUPS_OK_ACKNOWLEDGE.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sjms.jms.SessionAcknowledgementType</code> type.
         * 
         * Group: common
         */
        default SjmsEndpointBuilder acknowledgementMode(
                SessionAcknowledgementType acknowledgementMode) {
            setProperty("acknowledgementMode", acknowledgementMode);
            return this;
        }
        /**
         * The JMS acknowledgement name, which is one of: SESSION_TRANSACTED,
         * CLIENT_ACKNOWLEDGE, AUTO_ACKNOWLEDGE, DUPS_OK_ACKNOWLEDGE.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sjms.jms.SessionAcknowledgementType</code> type.
         * 
         * Group: common
         */
        default SjmsEndpointBuilder acknowledgementMode(
                String acknowledgementMode) {
            setProperty("acknowledgementMode", acknowledgementMode);
            return this;
        }
        /**
         * Sets the commit strategy.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sjms.TransactionCommitStrategy</code> type.
         * 
         * Group: transaction
         */
        default SjmsEndpointBuilder transactionCommitStrategy(
                Object transactionCommitStrategy) {
            setProperty("transactionCommitStrategy", transactionCommitStrategy);
            return this;
        }
        /**
         * Sets the commit strategy.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sjms.TransactionCommitStrategy</code> type.
         * 
         * Group: transaction
         */
        default SjmsEndpointBuilder transactionCommitStrategy(
                String transactionCommitStrategy) {
            setProperty("transactionCommitStrategy", transactionCommitStrategy);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Simple JMS component.
     */
    public interface AdvancedSjmsEndpointBuilder
            extends
                AdvancedSjmsEndpointConsumerBuilder, AdvancedSjmsEndpointProducerBuilder {
        default SjmsEndpointBuilder basic() {
            return (SjmsEndpointBuilder) this;
        }
        /**
         * Whether to startup the consumer message listener asynchronously, when
         * starting a route. For example if a JmsConsumer cannot get a
         * connection to a remote JMS broker, then it may block while retrying
         * and/or failover. This will cause Camel to block while starting
         * routes. By setting this option to true, you will let routes startup,
         * while the JmsConsumer connects to the JMS broker using a dedicated
         * thread in asynchronous mode. If this option is used, then beware that
         * if the connection could not be established, then an exception is
         * logged at WARN level, and the consumer will not be able to receive
         * messages; You can then restart the route to retry.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointBuilder asyncStartListener(
                boolean asyncStartListener) {
            setProperty("asyncStartListener", asyncStartListener);
            return this;
        }
        /**
         * Whether to startup the consumer message listener asynchronously, when
         * starting a route. For example if a JmsConsumer cannot get a
         * connection to a remote JMS broker, then it may block while retrying
         * and/or failover. This will cause Camel to block while starting
         * routes. By setting this option to true, you will let routes startup,
         * while the JmsConsumer connects to the JMS broker using a dedicated
         * thread in asynchronous mode. If this option is used, then beware that
         * if the connection could not be established, then an exception is
         * logged at WARN level, and the consumer will not be able to receive
         * messages; You can then restart the route to retry.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointBuilder asyncStartListener(
                String asyncStartListener) {
            setProperty("asyncStartListener", asyncStartListener);
            return this;
        }
        /**
         * Whether to stop the consumer message listener asynchronously, when
         * stopping a route.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointBuilder asyncStopListener(
                boolean asyncStopListener) {
            setProperty("asyncStopListener", asyncStopListener);
            return this;
        }
        /**
         * Whether to stop the consumer message listener asynchronously, when
         * stopping a route.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointBuilder asyncStopListener(
                String asyncStopListener) {
            setProperty("asyncStopListener", asyncStopListener);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * The maximum number of connections available to this endpoint.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointBuilder connectionCount(
                Integer connectionCount) {
            setProperty("connectionCount", connectionCount);
            return this;
        }
        /**
         * The maximum number of connections available to this endpoint.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointBuilder connectionCount(
                String connectionCount) {
            setProperty("connectionCount", connectionCount);
            return this;
        }
        /**
         * Initializes the connectionFactory for the endpoint, which takes
         * precedence over the component's connectionFactory, if any.
         * 
         * The option is a: <code>javax.jms.ConnectionFactory</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointBuilder connectionFactory(
                Object connectionFactory) {
            setProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * Initializes the connectionFactory for the endpoint, which takes
         * precedence over the component's connectionFactory, if any.
         * 
         * The option will be converted to a
         * <code>javax.jms.ConnectionFactory</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointBuilder connectionFactory(
                String connectionFactory) {
            setProperty("connectionFactory", connectionFactory);
            return this;
        }
        /**
         * Initializes the connectionResource for the endpoint, which takes
         * precedence over the component's connectionResource, if any.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sjms.jms.ConnectionResource</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointBuilder connectionResource(
                Object connectionResource) {
            setProperty("connectionResource", connectionResource);
            return this;
        }
        /**
         * Initializes the connectionResource for the endpoint, which takes
         * precedence over the component's connectionResource, if any.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sjms.jms.ConnectionResource</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointBuilder connectionResource(
                String connectionResource) {
            setProperty("connectionResource", connectionResource);
            return this;
        }
        /**
         * To use a custom DestinationCreationStrategy.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sjms.jms.DestinationCreationStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointBuilder destinationCreationStrategy(
                Object destinationCreationStrategy) {
            setProperty("destinationCreationStrategy", destinationCreationStrategy);
            return this;
        }
        /**
         * To use a custom DestinationCreationStrategy.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sjms.jms.DestinationCreationStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointBuilder destinationCreationStrategy(
                String destinationCreationStrategy) {
            setProperty("destinationCreationStrategy", destinationCreationStrategy);
            return this;
        }
        /**
         * Specifies the JMS Exception Listener that is to be notified of any
         * underlying JMS exceptions.
         * 
         * The option is a: <code>javax.jms.ExceptionListener</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointBuilder exceptionListener(
                Object exceptionListener) {
            setProperty("exceptionListener", exceptionListener);
            return this;
        }
        /**
         * Specifies the JMS Exception Listener that is to be notified of any
         * underlying JMS exceptions.
         * 
         * The option will be converted to a
         * <code>javax.jms.ExceptionListener</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointBuilder exceptionListener(
                String exceptionListener) {
            setProperty("exceptionListener", exceptionListener);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointBuilder headerFilterStrategy(
                HeaderFilterStrategy headerFilterStrategy) {
            setProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointBuilder headerFilterStrategy(
                String headerFilterStrategy) {
            setProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * Whether to include all JMSXxxx properties when mapping from JMS to
         * Camel Message. Setting this to true will include properties such as
         * JMSXAppID, and JMSXUserID etc. Note: If you are using a custom
         * headerFilterStrategy then this option does not apply.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointBuilder includeAllJMSXProperties(
                boolean includeAllJMSXProperties) {
            setProperty("includeAllJMSXProperties", includeAllJMSXProperties);
            return this;
        }
        /**
         * Whether to include all JMSXxxx properties when mapping from JMS to
         * Camel Message. Setting this to true will include properties such as
         * JMSXAppID, and JMSXUserID etc. Note: If you are using a custom
         * headerFilterStrategy then this option does not apply.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointBuilder includeAllJMSXProperties(
                String includeAllJMSXProperties) {
            setProperty("includeAllJMSXProperties", includeAllJMSXProperties);
            return this;
        }
        /**
         * Pluggable strategy for encoding and decoding JMS keys so they can be
         * compliant with the JMS specification. Camel provides two
         * implementations out of the box: default and passthrough. The default
         * strategy will safely marshal dots and hyphens (. and -). The
         * passthrough strategy leaves the key as is. Can be used for JMS
         * brokers which do not care whether JMS header keys contain illegal
         * characters. You can provide your own implementation of the
         * org.apache.camel.component.jms.JmsKeyFormatStrategy and refer to it
         * using the # notation.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sjms.jms.JmsKeyFormatStrategy</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointBuilder jmsKeyFormatStrategy(
                Object jmsKeyFormatStrategy) {
            setProperty("jmsKeyFormatStrategy", jmsKeyFormatStrategy);
            return this;
        }
        /**
         * Pluggable strategy for encoding and decoding JMS keys so they can be
         * compliant with the JMS specification. Camel provides two
         * implementations out of the box: default and passthrough. The default
         * strategy will safely marshal dots and hyphens (. and -). The
         * passthrough strategy leaves the key as is. Can be used for JMS
         * brokers which do not care whether JMS header keys contain illegal
         * characters. You can provide your own implementation of the
         * org.apache.camel.component.jms.JmsKeyFormatStrategy and refer to it
         * using the # notation.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sjms.jms.JmsKeyFormatStrategy</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointBuilder jmsKeyFormatStrategy(
                String jmsKeyFormatStrategy) {
            setProperty("jmsKeyFormatStrategy", jmsKeyFormatStrategy);
            return this;
        }
        /**
         * Specifies whether Camel should auto map the received JMS message to a
         * suited payload type, such as javax.jms.TextMessage to a String etc.
         * See section about how mapping works below for more details.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointBuilder mapJmsMessage(boolean mapJmsMessage) {
            setProperty("mapJmsMessage", mapJmsMessage);
            return this;
        }
        /**
         * Specifies whether Camel should auto map the received JMS message to a
         * suited payload type, such as javax.jms.TextMessage to a String etc.
         * See section about how mapping works below for more details.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointBuilder mapJmsMessage(String mapJmsMessage) {
            setProperty("mapJmsMessage", mapJmsMessage);
            return this;
        }
        /**
         * To use the given MessageCreatedStrategy which are invoked when Camel
         * creates new instances of javax.jms.Message objects when Camel is
         * sending a JMS message.
         * 
         * The option is a:
         * <code>org.apache.camel.component.sjms.jms.MessageCreatedStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointBuilder messageCreatedStrategy(
                Object messageCreatedStrategy) {
            setProperty("messageCreatedStrategy", messageCreatedStrategy);
            return this;
        }
        /**
         * To use the given MessageCreatedStrategy which are invoked when Camel
         * creates new instances of javax.jms.Message objects when Camel is
         * sending a JMS message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.sjms.jms.MessageCreatedStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSjmsEndpointBuilder messageCreatedStrategy(
                String messageCreatedStrategy) {
            setProperty("messageCreatedStrategy", messageCreatedStrategy);
            return this;
        }
        /**
         * Specifies whether to share JMS session with other SJMS endpoints.
         * Turn this off if your route is accessing to multiple JMS providers.
         * If you need transaction against multiple JMS providers, use jms
         * component to leverage XA transaction.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: transaction (advanced)
         */
        default AdvancedSjmsEndpointBuilder sharedJMSSession(
                boolean sharedJMSSession) {
            setProperty("sharedJMSSession", sharedJMSSession);
            return this;
        }
        /**
         * Specifies whether to share JMS session with other SJMS endpoints.
         * Turn this off if your route is accessing to multiple JMS providers.
         * If you need transaction against multiple JMS providers, use jms
         * component to leverage XA transaction.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: transaction (advanced)
         */
        default AdvancedSjmsEndpointBuilder sharedJMSSession(
                String sharedJMSSession) {
            setProperty("sharedJMSSession", sharedJMSSession);
            return this;
        }
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.sjms.jms.SessionAcknowledgementType</code> enum.
     */
    enum SessionAcknowledgementType {
        AUTO_ACKNOWLEDGE,
        CLIENT_ACKNOWLEDGE,
        DUPS_OK_ACKNOWLEDGE,
        SESSION_TRANSACTED;
    }
    /**
     * Simple JMS (camel-sjms)
     * The sjms component (simple jms) allows messages to be sent to (or
     * consumed from) a JMS Queue or Topic (uses JMS 1.x API).
     * 
     * Category: messaging
     * Available as of version: 2.11
     * Maven coordinates: org.apache.camel:camel-sjms
     * 
     * Syntax: <code>sjms:destinationType:destinationName</code>
     * 
     * Path parameter: destinationType
     * The kind of destination to use
     * Default value: queue
     * The value can be one of: queue, topic
     * 
     * Path parameter: destinationName (required)
     * DestinationName is a JMS queue or topic name. By default, the
     * destinationName is interpreted as a queue name.
     */
    default SjmsEndpointBuilder sjms(String path) {
        class SjmsEndpointBuilderImpl extends AbstractEndpointBuilder implements SjmsEndpointBuilder, AdvancedSjmsEndpointBuilder {
            public SjmsEndpointBuilderImpl(String path) {
                super("sjms", path);
            }
        }
        return new SjmsEndpointBuilderImpl(path);
    }
}