/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.TimeZone;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * IEC 60870 component used for telecontrol (supervisory control and data
 * acquisition) such as controlling electric power transmission grids and other
 * geographically widespread control systems.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface ServerEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the IEC 60870 Server component.
     */
    public interface ServerEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedServerEndpointConsumerBuilder advanced() {
            return (AdvancedServerEndpointConsumerBuilder) this;
        }
        /**
         * Data module options.
         * 
         * The option is a:
         * <code>org.eclipse.neoscada.protocol.iec60870.client.data.DataModuleOptions</code> type.
         * 
         * Group: common
         */
        default ServerEndpointConsumerBuilder dataModuleOptions(
                Object dataModuleOptions) {
            setProperty("dataModuleOptions", dataModuleOptions);
            return this;
        }
        /**
         * Data module options.
         * 
         * The option will be converted to a
         * <code>org.eclipse.neoscada.protocol.iec60870.client.data.DataModuleOptions</code> type.
         * 
         * Group: common
         */
        default ServerEndpointConsumerBuilder dataModuleOptions(
                String dataModuleOptions) {
            setProperty("dataModuleOptions", dataModuleOptions);
            return this;
        }
        /**
         * Filter out all requests which don't have the execute bit set.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default ServerEndpointConsumerBuilder filterNonExecute(
                boolean filterNonExecute) {
            setProperty("filterNonExecute", filterNonExecute);
            return this;
        }
        /**
         * Filter out all requests which don't have the execute bit set.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default ServerEndpointConsumerBuilder filterNonExecute(
                String filterNonExecute) {
            setProperty("filterNonExecute", filterNonExecute);
            return this;
        }
        /**
         * Protocol options.
         * 
         * The option is a:
         * <code>org.eclipse.neoscada.protocol.iec60870.ProtocolOptions</code>
         * type.
         * 
         * Group: common
         */
        default ServerEndpointConsumerBuilder protocolOptions(
                Object protocolOptions) {
            setProperty("protocolOptions", protocolOptions);
            return this;
        }
        /**
         * Protocol options.
         * 
         * The option will be converted to a
         * <code>org.eclipse.neoscada.protocol.iec60870.ProtocolOptions</code>
         * type.
         * 
         * Group: common
         */
        default ServerEndpointConsumerBuilder protocolOptions(
                String protocolOptions) {
            setProperty("protocolOptions", protocolOptions);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default ServerEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            setProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default ServerEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            setProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Parameter W - Acknowledgment window.
         * 
         * The option is a: <code>short</code> type.
         * 
         * Group: connection
         */
        default ServerEndpointConsumerBuilder acknowledgeWindow(
                short acknowledgeWindow) {
            setProperty("acknowledgeWindow", acknowledgeWindow);
            return this;
        }
        /**
         * Parameter W - Acknowledgment window.
         * 
         * The option will be converted to a <code>short</code> type.
         * 
         * Group: connection
         */
        default ServerEndpointConsumerBuilder acknowledgeWindow(
                String acknowledgeWindow) {
            setProperty("acknowledgeWindow", acknowledgeWindow);
            return this;
        }
        /**
         * The common ASDU address size. May be either SIZE_1 or SIZE_2.
         * 
         * The option is a:
         * <code>org.eclipse.neoscada.protocol.iec60870.ASDUAddressType</code>
         * type.
         * 
         * Group: connection
         */
        default ServerEndpointConsumerBuilder adsuAddressType(
                ASDUAddressType adsuAddressType) {
            setProperty("adsuAddressType", adsuAddressType);
            return this;
        }
        /**
         * The common ASDU address size. May be either SIZE_1 or SIZE_2.
         * 
         * The option will be converted to a
         * <code>org.eclipse.neoscada.protocol.iec60870.ASDUAddressType</code>
         * type.
         * 
         * Group: connection
         */
        default ServerEndpointConsumerBuilder adsuAddressType(
                String adsuAddressType) {
            setProperty("adsuAddressType", adsuAddressType);
            return this;
        }
        /**
         * The cause of transmission type. May be either SIZE_1 or SIZE_2.
         * 
         * The option is a:
         * <code>org.eclipse.neoscada.protocol.iec60870.CauseOfTransmissionType</code> type.
         * 
         * Group: connection
         */
        default ServerEndpointConsumerBuilder causeOfTransmissionType(
                CauseOfTransmissionType causeOfTransmissionType) {
            setProperty("causeOfTransmissionType", causeOfTransmissionType);
            return this;
        }
        /**
         * The cause of transmission type. May be either SIZE_1 or SIZE_2.
         * 
         * The option will be converted to a
         * <code>org.eclipse.neoscada.protocol.iec60870.CauseOfTransmissionType</code> type.
         * 
         * Group: connection
         */
        default ServerEndpointConsumerBuilder causeOfTransmissionType(
                String causeOfTransmissionType) {
            setProperty("causeOfTransmissionType", causeOfTransmissionType);
            return this;
        }
        /**
         * The information address size. May be either SIZE_1, SIZE_2 or SIZE_3.
         * 
         * The option is a:
         * <code>org.eclipse.neoscada.protocol.iec60870.InformationObjectAddressType</code> type.
         * 
         * Group: connection
         */
        default ServerEndpointConsumerBuilder informationObjectAddressType(
                InformationObjectAddressType informationObjectAddressType) {
            setProperty("informationObjectAddressType", informationObjectAddressType);
            return this;
        }
        /**
         * The information address size. May be either SIZE_1, SIZE_2 or SIZE_3.
         * 
         * The option will be converted to a
         * <code>org.eclipse.neoscada.protocol.iec60870.InformationObjectAddressType</code> type.
         * 
         * Group: connection
         */
        default ServerEndpointConsumerBuilder informationObjectAddressType(
                String informationObjectAddressType) {
            setProperty("informationObjectAddressType", informationObjectAddressType);
            return this;
        }
        /**
         * Parameter K - Maximum number of un-acknowledged messages.
         * 
         * The option is a: <code>short</code> type.
         * 
         * Group: connection
         */
        default ServerEndpointConsumerBuilder maxUnacknowledged(
                short maxUnacknowledged) {
            setProperty("maxUnacknowledged", maxUnacknowledged);
            return this;
        }
        /**
         * Parameter K - Maximum number of un-acknowledged messages.
         * 
         * The option will be converted to a <code>short</code> type.
         * 
         * Group: connection
         */
        default ServerEndpointConsumerBuilder maxUnacknowledged(
                String maxUnacknowledged) {
            setProperty("maxUnacknowledged", maxUnacknowledged);
            return this;
        }
        /**
         * Timeout T1 in milliseconds.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: connection
         */
        default ServerEndpointConsumerBuilder timeout1(int timeout1) {
            setProperty("timeout1", timeout1);
            return this;
        }
        /**
         * Timeout T1 in milliseconds.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: connection
         */
        default ServerEndpointConsumerBuilder timeout1(String timeout1) {
            setProperty("timeout1", timeout1);
            return this;
        }
        /**
         * Timeout T2 in milliseconds.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: connection
         */
        default ServerEndpointConsumerBuilder timeout2(int timeout2) {
            setProperty("timeout2", timeout2);
            return this;
        }
        /**
         * Timeout T2 in milliseconds.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: connection
         */
        default ServerEndpointConsumerBuilder timeout2(String timeout2) {
            setProperty("timeout2", timeout2);
            return this;
        }
        /**
         * Timeout T3 in milliseconds.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: connection
         */
        default ServerEndpointConsumerBuilder timeout3(int timeout3) {
            setProperty("timeout3", timeout3);
            return this;
        }
        /**
         * Timeout T3 in milliseconds.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: connection
         */
        default ServerEndpointConsumerBuilder timeout3(String timeout3) {
            setProperty("timeout3", timeout3);
            return this;
        }
        /**
         * Whether to include the source address.
         * 
         * The option is a: <code>byte</code> type.
         * 
         * Group: data
         */
        default ServerEndpointConsumerBuilder causeSourceAddress(
                byte causeSourceAddress) {
            setProperty("causeSourceAddress", causeSourceAddress);
            return this;
        }
        /**
         * Whether to include the source address.
         * 
         * The option will be converted to a <code>byte</code> type.
         * 
         * Group: data
         */
        default ServerEndpointConsumerBuilder causeSourceAddress(
                String causeSourceAddress) {
            setProperty("causeSourceAddress", causeSourceAddress);
            return this;
        }
        /**
         * Whether background scan transmissions should be ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: data
         */
        default ServerEndpointConsumerBuilder ignoreBackgroundScan(
                boolean ignoreBackgroundScan) {
            setProperty("ignoreBackgroundScan", ignoreBackgroundScan);
            return this;
        }
        /**
         * Whether background scan transmissions should be ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: data
         */
        default ServerEndpointConsumerBuilder ignoreBackgroundScan(
                String ignoreBackgroundScan) {
            setProperty("ignoreBackgroundScan", ignoreBackgroundScan);
            return this;
        }
        /**
         * Whether to ignore or respect DST.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: data
         */
        default ServerEndpointConsumerBuilder ignoreDaylightSavingTime(
                boolean ignoreDaylightSavingTime) {
            setProperty("ignoreDaylightSavingTime", ignoreDaylightSavingTime);
            return this;
        }
        /**
         * Whether to ignore or respect DST.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: data
         */
        default ServerEndpointConsumerBuilder ignoreDaylightSavingTime(
                String ignoreDaylightSavingTime) {
            setProperty("ignoreDaylightSavingTime", ignoreDaylightSavingTime);
            return this;
        }
        /**
         * The timezone to use. May be any Java time zone string.
         * 
         * The option is a: <code>java.util.TimeZone</code> type.
         * 
         * Group: data
         */
        default ServerEndpointConsumerBuilder timeZone(TimeZone timeZone) {
            setProperty("timeZone", timeZone);
            return this;
        }
        /**
         * The timezone to use. May be any Java time zone string.
         * 
         * The option will be converted to a <code>java.util.TimeZone</code>
         * type.
         * 
         * Group: data
         */
        default ServerEndpointConsumerBuilder timeZone(String timeZone) {
            setProperty("timeZone", timeZone);
            return this;
        }
        /**
         * An identifier grouping connection instances.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: id
         */
        default ServerEndpointConsumerBuilder connectionId(String connectionId) {
            setProperty("connectionId", connectionId);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the IEC 60870 Server
     * component.
     */
    public interface AdvancedServerEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default ServerEndpointConsumerBuilder basic() {
            return (ServerEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedServerEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            setProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedServerEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            setProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedServerEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            setProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedServerEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            setProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedServerEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedServerEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedServerEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedServerEndpointConsumerBuilder synchronous(
                String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the IEC 60870 Server component.
     */
    public interface ServerEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedServerEndpointProducerBuilder advanced() {
            return (AdvancedServerEndpointProducerBuilder) this;
        }
        /**
         * Data module options.
         * 
         * The option is a:
         * <code>org.eclipse.neoscada.protocol.iec60870.client.data.DataModuleOptions</code> type.
         * 
         * Group: common
         */
        default ServerEndpointProducerBuilder dataModuleOptions(
                Object dataModuleOptions) {
            setProperty("dataModuleOptions", dataModuleOptions);
            return this;
        }
        /**
         * Data module options.
         * 
         * The option will be converted to a
         * <code>org.eclipse.neoscada.protocol.iec60870.client.data.DataModuleOptions</code> type.
         * 
         * Group: common
         */
        default ServerEndpointProducerBuilder dataModuleOptions(
                String dataModuleOptions) {
            setProperty("dataModuleOptions", dataModuleOptions);
            return this;
        }
        /**
         * Filter out all requests which don't have the execute bit set.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default ServerEndpointProducerBuilder filterNonExecute(
                boolean filterNonExecute) {
            setProperty("filterNonExecute", filterNonExecute);
            return this;
        }
        /**
         * Filter out all requests which don't have the execute bit set.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default ServerEndpointProducerBuilder filterNonExecute(
                String filterNonExecute) {
            setProperty("filterNonExecute", filterNonExecute);
            return this;
        }
        /**
         * Protocol options.
         * 
         * The option is a:
         * <code>org.eclipse.neoscada.protocol.iec60870.ProtocolOptions</code>
         * type.
         * 
         * Group: common
         */
        default ServerEndpointProducerBuilder protocolOptions(
                Object protocolOptions) {
            setProperty("protocolOptions", protocolOptions);
            return this;
        }
        /**
         * Protocol options.
         * 
         * The option will be converted to a
         * <code>org.eclipse.neoscada.protocol.iec60870.ProtocolOptions</code>
         * type.
         * 
         * Group: common
         */
        default ServerEndpointProducerBuilder protocolOptions(
                String protocolOptions) {
            setProperty("protocolOptions", protocolOptions);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default ServerEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            setProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default ServerEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            setProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Parameter W - Acknowledgment window.
         * 
         * The option is a: <code>short</code> type.
         * 
         * Group: connection
         */
        default ServerEndpointProducerBuilder acknowledgeWindow(
                short acknowledgeWindow) {
            setProperty("acknowledgeWindow", acknowledgeWindow);
            return this;
        }
        /**
         * Parameter W - Acknowledgment window.
         * 
         * The option will be converted to a <code>short</code> type.
         * 
         * Group: connection
         */
        default ServerEndpointProducerBuilder acknowledgeWindow(
                String acknowledgeWindow) {
            setProperty("acknowledgeWindow", acknowledgeWindow);
            return this;
        }
        /**
         * The common ASDU address size. May be either SIZE_1 or SIZE_2.
         * 
         * The option is a:
         * <code>org.eclipse.neoscada.protocol.iec60870.ASDUAddressType</code>
         * type.
         * 
         * Group: connection
         */
        default ServerEndpointProducerBuilder adsuAddressType(
                ASDUAddressType adsuAddressType) {
            setProperty("adsuAddressType", adsuAddressType);
            return this;
        }
        /**
         * The common ASDU address size. May be either SIZE_1 or SIZE_2.
         * 
         * The option will be converted to a
         * <code>org.eclipse.neoscada.protocol.iec60870.ASDUAddressType</code>
         * type.
         * 
         * Group: connection
         */
        default ServerEndpointProducerBuilder adsuAddressType(
                String adsuAddressType) {
            setProperty("adsuAddressType", adsuAddressType);
            return this;
        }
        /**
         * The cause of transmission type. May be either SIZE_1 or SIZE_2.
         * 
         * The option is a:
         * <code>org.eclipse.neoscada.protocol.iec60870.CauseOfTransmissionType</code> type.
         * 
         * Group: connection
         */
        default ServerEndpointProducerBuilder causeOfTransmissionType(
                CauseOfTransmissionType causeOfTransmissionType) {
            setProperty("causeOfTransmissionType", causeOfTransmissionType);
            return this;
        }
        /**
         * The cause of transmission type. May be either SIZE_1 or SIZE_2.
         * 
         * The option will be converted to a
         * <code>org.eclipse.neoscada.protocol.iec60870.CauseOfTransmissionType</code> type.
         * 
         * Group: connection
         */
        default ServerEndpointProducerBuilder causeOfTransmissionType(
                String causeOfTransmissionType) {
            setProperty("causeOfTransmissionType", causeOfTransmissionType);
            return this;
        }
        /**
         * The information address size. May be either SIZE_1, SIZE_2 or SIZE_3.
         * 
         * The option is a:
         * <code>org.eclipse.neoscada.protocol.iec60870.InformationObjectAddressType</code> type.
         * 
         * Group: connection
         */
        default ServerEndpointProducerBuilder informationObjectAddressType(
                InformationObjectAddressType informationObjectAddressType) {
            setProperty("informationObjectAddressType", informationObjectAddressType);
            return this;
        }
        /**
         * The information address size. May be either SIZE_1, SIZE_2 or SIZE_3.
         * 
         * The option will be converted to a
         * <code>org.eclipse.neoscada.protocol.iec60870.InformationObjectAddressType</code> type.
         * 
         * Group: connection
         */
        default ServerEndpointProducerBuilder informationObjectAddressType(
                String informationObjectAddressType) {
            setProperty("informationObjectAddressType", informationObjectAddressType);
            return this;
        }
        /**
         * Parameter K - Maximum number of un-acknowledged messages.
         * 
         * The option is a: <code>short</code> type.
         * 
         * Group: connection
         */
        default ServerEndpointProducerBuilder maxUnacknowledged(
                short maxUnacknowledged) {
            setProperty("maxUnacknowledged", maxUnacknowledged);
            return this;
        }
        /**
         * Parameter K - Maximum number of un-acknowledged messages.
         * 
         * The option will be converted to a <code>short</code> type.
         * 
         * Group: connection
         */
        default ServerEndpointProducerBuilder maxUnacknowledged(
                String maxUnacknowledged) {
            setProperty("maxUnacknowledged", maxUnacknowledged);
            return this;
        }
        /**
         * Timeout T1 in milliseconds.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: connection
         */
        default ServerEndpointProducerBuilder timeout1(int timeout1) {
            setProperty("timeout1", timeout1);
            return this;
        }
        /**
         * Timeout T1 in milliseconds.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: connection
         */
        default ServerEndpointProducerBuilder timeout1(String timeout1) {
            setProperty("timeout1", timeout1);
            return this;
        }
        /**
         * Timeout T2 in milliseconds.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: connection
         */
        default ServerEndpointProducerBuilder timeout2(int timeout2) {
            setProperty("timeout2", timeout2);
            return this;
        }
        /**
         * Timeout T2 in milliseconds.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: connection
         */
        default ServerEndpointProducerBuilder timeout2(String timeout2) {
            setProperty("timeout2", timeout2);
            return this;
        }
        /**
         * Timeout T3 in milliseconds.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: connection
         */
        default ServerEndpointProducerBuilder timeout3(int timeout3) {
            setProperty("timeout3", timeout3);
            return this;
        }
        /**
         * Timeout T3 in milliseconds.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: connection
         */
        default ServerEndpointProducerBuilder timeout3(String timeout3) {
            setProperty("timeout3", timeout3);
            return this;
        }
        /**
         * Whether to include the source address.
         * 
         * The option is a: <code>byte</code> type.
         * 
         * Group: data
         */
        default ServerEndpointProducerBuilder causeSourceAddress(
                byte causeSourceAddress) {
            setProperty("causeSourceAddress", causeSourceAddress);
            return this;
        }
        /**
         * Whether to include the source address.
         * 
         * The option will be converted to a <code>byte</code> type.
         * 
         * Group: data
         */
        default ServerEndpointProducerBuilder causeSourceAddress(
                String causeSourceAddress) {
            setProperty("causeSourceAddress", causeSourceAddress);
            return this;
        }
        /**
         * Whether background scan transmissions should be ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: data
         */
        default ServerEndpointProducerBuilder ignoreBackgroundScan(
                boolean ignoreBackgroundScan) {
            setProperty("ignoreBackgroundScan", ignoreBackgroundScan);
            return this;
        }
        /**
         * Whether background scan transmissions should be ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: data
         */
        default ServerEndpointProducerBuilder ignoreBackgroundScan(
                String ignoreBackgroundScan) {
            setProperty("ignoreBackgroundScan", ignoreBackgroundScan);
            return this;
        }
        /**
         * Whether to ignore or respect DST.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: data
         */
        default ServerEndpointProducerBuilder ignoreDaylightSavingTime(
                boolean ignoreDaylightSavingTime) {
            setProperty("ignoreDaylightSavingTime", ignoreDaylightSavingTime);
            return this;
        }
        /**
         * Whether to ignore or respect DST.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: data
         */
        default ServerEndpointProducerBuilder ignoreDaylightSavingTime(
                String ignoreDaylightSavingTime) {
            setProperty("ignoreDaylightSavingTime", ignoreDaylightSavingTime);
            return this;
        }
        /**
         * The timezone to use. May be any Java time zone string.
         * 
         * The option is a: <code>java.util.TimeZone</code> type.
         * 
         * Group: data
         */
        default ServerEndpointProducerBuilder timeZone(TimeZone timeZone) {
            setProperty("timeZone", timeZone);
            return this;
        }
        /**
         * The timezone to use. May be any Java time zone string.
         * 
         * The option will be converted to a <code>java.util.TimeZone</code>
         * type.
         * 
         * Group: data
         */
        default ServerEndpointProducerBuilder timeZone(String timeZone) {
            setProperty("timeZone", timeZone);
            return this;
        }
        /**
         * An identifier grouping connection instances.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: id
         */
        default ServerEndpointProducerBuilder connectionId(String connectionId) {
            setProperty("connectionId", connectionId);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the IEC 60870 Server
     * component.
     */
    public interface AdvancedServerEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default ServerEndpointProducerBuilder basic() {
            return (ServerEndpointProducerBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedServerEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedServerEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedServerEndpointProducerBuilder synchronous(
                boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedServerEndpointProducerBuilder synchronous(
                String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the IEC 60870 Server component.
     */
    public interface ServerEndpointBuilder
            extends
                ServerEndpointConsumerBuilder, ServerEndpointProducerBuilder {
        default AdvancedServerEndpointBuilder advanced() {
            return (AdvancedServerEndpointBuilder) this;
        }
        /**
         * Data module options.
         * 
         * The option is a:
         * <code>org.eclipse.neoscada.protocol.iec60870.client.data.DataModuleOptions</code> type.
         * 
         * Group: common
         */
        default ServerEndpointBuilder dataModuleOptions(Object dataModuleOptions) {
            setProperty("dataModuleOptions", dataModuleOptions);
            return this;
        }
        /**
         * Data module options.
         * 
         * The option will be converted to a
         * <code>org.eclipse.neoscada.protocol.iec60870.client.data.DataModuleOptions</code> type.
         * 
         * Group: common
         */
        default ServerEndpointBuilder dataModuleOptions(String dataModuleOptions) {
            setProperty("dataModuleOptions", dataModuleOptions);
            return this;
        }
        /**
         * Filter out all requests which don't have the execute bit set.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default ServerEndpointBuilder filterNonExecute(boolean filterNonExecute) {
            setProperty("filterNonExecute", filterNonExecute);
            return this;
        }
        /**
         * Filter out all requests which don't have the execute bit set.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default ServerEndpointBuilder filterNonExecute(String filterNonExecute) {
            setProperty("filterNonExecute", filterNonExecute);
            return this;
        }
        /**
         * Protocol options.
         * 
         * The option is a:
         * <code>org.eclipse.neoscada.protocol.iec60870.ProtocolOptions</code>
         * type.
         * 
         * Group: common
         */
        default ServerEndpointBuilder protocolOptions(Object protocolOptions) {
            setProperty("protocolOptions", protocolOptions);
            return this;
        }
        /**
         * Protocol options.
         * 
         * The option will be converted to a
         * <code>org.eclipse.neoscada.protocol.iec60870.ProtocolOptions</code>
         * type.
         * 
         * Group: common
         */
        default ServerEndpointBuilder protocolOptions(String protocolOptions) {
            setProperty("protocolOptions", protocolOptions);
            return this;
        }
        /**
         * Parameter W - Acknowledgment window.
         * 
         * The option is a: <code>short</code> type.
         * 
         * Group: connection
         */
        default ServerEndpointBuilder acknowledgeWindow(short acknowledgeWindow) {
            setProperty("acknowledgeWindow", acknowledgeWindow);
            return this;
        }
        /**
         * Parameter W - Acknowledgment window.
         * 
         * The option will be converted to a <code>short</code> type.
         * 
         * Group: connection
         */
        default ServerEndpointBuilder acknowledgeWindow(String acknowledgeWindow) {
            setProperty("acknowledgeWindow", acknowledgeWindow);
            return this;
        }
        /**
         * The common ASDU address size. May be either SIZE_1 or SIZE_2.
         * 
         * The option is a:
         * <code>org.eclipse.neoscada.protocol.iec60870.ASDUAddressType</code>
         * type.
         * 
         * Group: connection
         */
        default ServerEndpointBuilder adsuAddressType(
                ASDUAddressType adsuAddressType) {
            setProperty("adsuAddressType", adsuAddressType);
            return this;
        }
        /**
         * The common ASDU address size. May be either SIZE_1 or SIZE_2.
         * 
         * The option will be converted to a
         * <code>org.eclipse.neoscada.protocol.iec60870.ASDUAddressType</code>
         * type.
         * 
         * Group: connection
         */
        default ServerEndpointBuilder adsuAddressType(String adsuAddressType) {
            setProperty("adsuAddressType", adsuAddressType);
            return this;
        }
        /**
         * The cause of transmission type. May be either SIZE_1 or SIZE_2.
         * 
         * The option is a:
         * <code>org.eclipse.neoscada.protocol.iec60870.CauseOfTransmissionType</code> type.
         * 
         * Group: connection
         */
        default ServerEndpointBuilder causeOfTransmissionType(
                CauseOfTransmissionType causeOfTransmissionType) {
            setProperty("causeOfTransmissionType", causeOfTransmissionType);
            return this;
        }
        /**
         * The cause of transmission type. May be either SIZE_1 or SIZE_2.
         * 
         * The option will be converted to a
         * <code>org.eclipse.neoscada.protocol.iec60870.CauseOfTransmissionType</code> type.
         * 
         * Group: connection
         */
        default ServerEndpointBuilder causeOfTransmissionType(
                String causeOfTransmissionType) {
            setProperty("causeOfTransmissionType", causeOfTransmissionType);
            return this;
        }
        /**
         * The information address size. May be either SIZE_1, SIZE_2 or SIZE_3.
         * 
         * The option is a:
         * <code>org.eclipse.neoscada.protocol.iec60870.InformationObjectAddressType</code> type.
         * 
         * Group: connection
         */
        default ServerEndpointBuilder informationObjectAddressType(
                InformationObjectAddressType informationObjectAddressType) {
            setProperty("informationObjectAddressType", informationObjectAddressType);
            return this;
        }
        /**
         * The information address size. May be either SIZE_1, SIZE_2 or SIZE_3.
         * 
         * The option will be converted to a
         * <code>org.eclipse.neoscada.protocol.iec60870.InformationObjectAddressType</code> type.
         * 
         * Group: connection
         */
        default ServerEndpointBuilder informationObjectAddressType(
                String informationObjectAddressType) {
            setProperty("informationObjectAddressType", informationObjectAddressType);
            return this;
        }
        /**
         * Parameter K - Maximum number of un-acknowledged messages.
         * 
         * The option is a: <code>short</code> type.
         * 
         * Group: connection
         */
        default ServerEndpointBuilder maxUnacknowledged(short maxUnacknowledged) {
            setProperty("maxUnacknowledged", maxUnacknowledged);
            return this;
        }
        /**
         * Parameter K - Maximum number of un-acknowledged messages.
         * 
         * The option will be converted to a <code>short</code> type.
         * 
         * Group: connection
         */
        default ServerEndpointBuilder maxUnacknowledged(String maxUnacknowledged) {
            setProperty("maxUnacknowledged", maxUnacknowledged);
            return this;
        }
        /**
         * Timeout T1 in milliseconds.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: connection
         */
        default ServerEndpointBuilder timeout1(int timeout1) {
            setProperty("timeout1", timeout1);
            return this;
        }
        /**
         * Timeout T1 in milliseconds.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: connection
         */
        default ServerEndpointBuilder timeout1(String timeout1) {
            setProperty("timeout1", timeout1);
            return this;
        }
        /**
         * Timeout T2 in milliseconds.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: connection
         */
        default ServerEndpointBuilder timeout2(int timeout2) {
            setProperty("timeout2", timeout2);
            return this;
        }
        /**
         * Timeout T2 in milliseconds.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: connection
         */
        default ServerEndpointBuilder timeout2(String timeout2) {
            setProperty("timeout2", timeout2);
            return this;
        }
        /**
         * Timeout T3 in milliseconds.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: connection
         */
        default ServerEndpointBuilder timeout3(int timeout3) {
            setProperty("timeout3", timeout3);
            return this;
        }
        /**
         * Timeout T3 in milliseconds.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: connection
         */
        default ServerEndpointBuilder timeout3(String timeout3) {
            setProperty("timeout3", timeout3);
            return this;
        }
        /**
         * Whether to include the source address.
         * 
         * The option is a: <code>byte</code> type.
         * 
         * Group: data
         */
        default ServerEndpointBuilder causeSourceAddress(byte causeSourceAddress) {
            setProperty("causeSourceAddress", causeSourceAddress);
            return this;
        }
        /**
         * Whether to include the source address.
         * 
         * The option will be converted to a <code>byte</code> type.
         * 
         * Group: data
         */
        default ServerEndpointBuilder causeSourceAddress(
                String causeSourceAddress) {
            setProperty("causeSourceAddress", causeSourceAddress);
            return this;
        }
        /**
         * Whether background scan transmissions should be ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: data
         */
        default ServerEndpointBuilder ignoreBackgroundScan(
                boolean ignoreBackgroundScan) {
            setProperty("ignoreBackgroundScan", ignoreBackgroundScan);
            return this;
        }
        /**
         * Whether background scan transmissions should be ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: data
         */
        default ServerEndpointBuilder ignoreBackgroundScan(
                String ignoreBackgroundScan) {
            setProperty("ignoreBackgroundScan", ignoreBackgroundScan);
            return this;
        }
        /**
         * Whether to ignore or respect DST.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: data
         */
        default ServerEndpointBuilder ignoreDaylightSavingTime(
                boolean ignoreDaylightSavingTime) {
            setProperty("ignoreDaylightSavingTime", ignoreDaylightSavingTime);
            return this;
        }
        /**
         * Whether to ignore or respect DST.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: data
         */
        default ServerEndpointBuilder ignoreDaylightSavingTime(
                String ignoreDaylightSavingTime) {
            setProperty("ignoreDaylightSavingTime", ignoreDaylightSavingTime);
            return this;
        }
        /**
         * The timezone to use. May be any Java time zone string.
         * 
         * The option is a: <code>java.util.TimeZone</code> type.
         * 
         * Group: data
         */
        default ServerEndpointBuilder timeZone(TimeZone timeZone) {
            setProperty("timeZone", timeZone);
            return this;
        }
        /**
         * The timezone to use. May be any Java time zone string.
         * 
         * The option will be converted to a <code>java.util.TimeZone</code>
         * type.
         * 
         * Group: data
         */
        default ServerEndpointBuilder timeZone(String timeZone) {
            setProperty("timeZone", timeZone);
            return this;
        }
        /**
         * An identifier grouping connection instances.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: id
         */
        default ServerEndpointBuilder connectionId(String connectionId) {
            setProperty("connectionId", connectionId);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the IEC 60870 Server component.
     */
    public interface AdvancedServerEndpointBuilder
            extends
                AdvancedServerEndpointConsumerBuilder, AdvancedServerEndpointProducerBuilder {
        default ServerEndpointBuilder basic() {
            return (ServerEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedServerEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedServerEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedServerEndpointBuilder synchronous(boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedServerEndpointBuilder synchronous(String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Proxy enum for
     * <code>org.eclipse.neoscada.protocol.iec60870.ASDUAddressType</code> enum.
     */
    enum ASDUAddressType {
        SIZE_1,
        SIZE_2;
    }

    /**
     * Proxy enum for
     * <code>org.eclipse.neoscada.protocol.iec60870.CauseOfTransmissionType</code> enum.
     */
    enum CauseOfTransmissionType {
        SIZE_1,
        SIZE_2;
    }

    /**
     * Proxy enum for
     * <code>org.eclipse.neoscada.protocol.iec60870.InformationObjectAddressType</code> enum.
     */
    enum InformationObjectAddressType {
        SIZE_1,
        SIZE_2,
        SIZE_3;
    }
    /**
     * IEC 60870 Server (camel-iec60870)
     * IEC 60870 component used for telecontrol (supervisory control and data
     * acquisition) such as controlling electric power transmission grids and
     * other geographically widespread control systems.
     * 
     * Category: iot
     * Available as of version: 2.20
     * Maven coordinates: org.apache.camel:camel-iec60870
     * 
     * Syntax: <code>iec60870-server:uriPath</code>
     * 
     * Path parameter: uriPath (required)
     * The object information address
     */
    default ServerEndpointBuilder server(String path) {
        class ServerEndpointBuilderImpl extends AbstractEndpointBuilder implements ServerEndpointBuilder, AdvancedServerEndpointBuilder {
            public ServerEndpointBuilderImpl(String path) {
                super("iec60870-server", path);
            }
        }
        return new ServerEndpointBuilderImpl(path);
    }
}