/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * The salesforce component is used for integrating Camel with the massive
 * Salesforce API.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface SalesforceEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Salesforce component.
     */
    public interface SalesforceEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedSalesforceEndpointConsumerBuilder advanced() {
            return (AdvancedSalesforceEndpointConsumerBuilder) this;
        }
        /**
         * APEX method name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder apexMethod(String apexMethod) {
            setProperty("apexMethod", apexMethod);
            return this;
        }
        /**
         * Query params for APEX method.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder apexQueryParams(
                Map<String, Object> apexQueryParams) {
            setProperty("apexQueryParams", apexQueryParams);
            return this;
        }
        /**
         * Query params for APEX method.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder apexQueryParams(
                String apexQueryParams) {
            setProperty("apexQueryParams", apexQueryParams);
            return this;
        }
        /**
         * APEX method URL.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder apexUrl(String apexUrl) {
            setProperty("apexUrl", apexUrl);
            return this;
        }
        /**
         * Salesforce API version, defaults to
         * SalesforceEndpointConfig.DEFAULT_VERSION.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder apiVersion(String apiVersion) {
            setProperty("apiVersion", apiVersion);
            return this;
        }
        /**
         * Backoff interval increment for Streaming connection restart attempts
         * for failures beyond CometD auto-reconnect.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder backoffIncrement(
                long backoffIncrement) {
            setProperty("backoffIncrement", backoffIncrement);
            return this;
        }
        /**
         * Backoff interval increment for Streaming connection restart attempts
         * for failures beyond CometD auto-reconnect.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder backoffIncrement(
                String backoffIncrement) {
            setProperty("backoffIncrement", backoffIncrement);
            return this;
        }
        /**
         * Bulk API Batch ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder batchId(String batchId) {
            setProperty("batchId", batchId);
            return this;
        }
        /**
         * Bulk API content type, one of XML, CSV, ZIP_XML, ZIP_CSV.
         * 
         * The option is a:
         * <code>org.apache.camel.component.salesforce.api.dto.bulk.ContentType</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder contentType(
                ContentType contentType) {
            setProperty("contentType", contentType);
            return this;
        }
        /**
         * Bulk API content type, one of XML, CSV, ZIP_XML, ZIP_CSV.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.salesforce.api.dto.bulk.ContentType</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder contentType(String contentType) {
            setProperty("contentType", contentType);
            return this;
        }
        /**
         * Default replayId setting if no value is found in initialReplayIdMap.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder defaultReplayId(
                Long defaultReplayId) {
            setProperty("defaultReplayId", defaultReplayId);
            return this;
        }
        /**
         * Default replayId setting if no value is found in initialReplayIdMap.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder defaultReplayId(
                String defaultReplayId) {
            setProperty("defaultReplayId", defaultReplayId);
            return this;
        }
        /**
         * Payload format to use for Salesforce API calls, either JSON or XML,
         * defaults to JSON.
         * 
         * The option is a:
         * <code>org.apache.camel.component.salesforce.internal.PayloadFormat</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder format(PayloadFormat format) {
            setProperty("format", format);
            return this;
        }
        /**
         * Payload format to use for Salesforce API calls, either JSON or XML,
         * defaults to JSON.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.salesforce.internal.PayloadFormat</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder format(String format) {
            setProperty("format", format);
            return this;
        }
        /**
         * Custom Jetty Http Client to use to connect to Salesforce.
         * 
         * The option is a:
         * <code>org.apache.camel.component.salesforce.SalesforceHttpClient</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder httpClient(Object httpClient) {
            setProperty("httpClient", httpClient);
            return this;
        }
        /**
         * Custom Jetty Http Client to use to connect to Salesforce.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.salesforce.SalesforceHttpClient</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder httpClient(String httpClient) {
            setProperty("httpClient", httpClient);
            return this;
        }
        /**
         * Include details in Salesforce1 Analytics report, defaults to false.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder includeDetails(
                Boolean includeDetails) {
            setProperty("includeDetails", includeDetails);
            return this;
        }
        /**
         * Include details in Salesforce1 Analytics report, defaults to false.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder includeDetails(
                String includeDetails) {
            setProperty("includeDetails", includeDetails);
            return this;
        }
        /**
         * Replay IDs to start from per channel name.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Long&gt;</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder initialReplayIdMap(
                Map<String, Long> initialReplayIdMap) {
            setProperty("initialReplayIdMap", initialReplayIdMap);
            return this;
        }
        /**
         * Replay IDs to start from per channel name.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Long&gt;</code>
         * type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder initialReplayIdMap(
                String initialReplayIdMap) {
            setProperty("initialReplayIdMap", initialReplayIdMap);
            return this;
        }
        /**
         * Salesforce1 Analytics report execution instance ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder instanceId(String instanceId) {
            setProperty("instanceId", instanceId);
            return this;
        }
        /**
         * Bulk API Job ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder jobId(String jobId) {
            setProperty("jobId", jobId);
            return this;
        }
        /**
         * Limit on number of returned records. Applicable to some of the API,
         * check the Salesforce documentation.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder limit(Integer limit) {
            setProperty("limit", limit);
            return this;
        }
        /**
         * Limit on number of returned records. Applicable to some of the API,
         * check the Salesforce documentation.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder limit(String limit) {
            setProperty("limit", limit);
            return this;
        }
        /**
         * Maximum backoff interval for Streaming connection restart attempts
         * for failures beyond CometD auto-reconnect.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder maxBackoff(long maxBackoff) {
            setProperty("maxBackoff", maxBackoff);
            return this;
        }
        /**
         * Maximum backoff interval for Streaming connection restart attempts
         * for failures beyond CometD auto-reconnect.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder maxBackoff(String maxBackoff) {
            setProperty("maxBackoff", maxBackoff);
            return this;
        }
        /**
         * Sets the behaviour of 404 not found status received from Salesforce
         * API. Should the body be set to NULL NotFoundBehaviour#NULL or should
         * a exception be signaled on the exchange NotFoundBehaviour#EXCEPTION -
         * the default.
         * 
         * The option is a:
         * <code>org.apache.camel.component.salesforce.NotFoundBehaviour</code>
         * type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder notFoundBehaviour(
                NotFoundBehaviour notFoundBehaviour) {
            setProperty("notFoundBehaviour", notFoundBehaviour);
            return this;
        }
        /**
         * Sets the behaviour of 404 not found status received from Salesforce
         * API. Should the body be set to NULL NotFoundBehaviour#NULL or should
         * a exception be signaled on the exchange NotFoundBehaviour#EXCEPTION -
         * the default.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.salesforce.NotFoundBehaviour</code>
         * type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder notFoundBehaviour(
                String notFoundBehaviour) {
            setProperty("notFoundBehaviour", notFoundBehaviour);
            return this;
        }
        /**
         * Notify for fields, options are ALL, REFERENCED, SELECT, WHERE.
         * 
         * The option is a:
         * <code>org.apache.camel.component.salesforce.internal.dto.NotifyForFieldsEnum</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder notifyForFields(
                NotifyForFieldsEnum notifyForFields) {
            setProperty("notifyForFields", notifyForFields);
            return this;
        }
        /**
         * Notify for fields, options are ALL, REFERENCED, SELECT, WHERE.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.salesforce.internal.dto.NotifyForFieldsEnum</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder notifyForFields(
                String notifyForFields) {
            setProperty("notifyForFields", notifyForFields);
            return this;
        }
        /**
         * Notify for create operation, defaults to false (API version = 29.0).
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder notifyForOperationCreate(
                Boolean notifyForOperationCreate) {
            setProperty("notifyForOperationCreate", notifyForOperationCreate);
            return this;
        }
        /**
         * Notify for create operation, defaults to false (API version = 29.0).
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder notifyForOperationCreate(
                String notifyForOperationCreate) {
            setProperty("notifyForOperationCreate", notifyForOperationCreate);
            return this;
        }
        /**
         * Notify for delete operation, defaults to false (API version = 29.0).
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder notifyForOperationDelete(
                Boolean notifyForOperationDelete) {
            setProperty("notifyForOperationDelete", notifyForOperationDelete);
            return this;
        }
        /**
         * Notify for delete operation, defaults to false (API version = 29.0).
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder notifyForOperationDelete(
                String notifyForOperationDelete) {
            setProperty("notifyForOperationDelete", notifyForOperationDelete);
            return this;
        }
        /**
         * Notify for operations, options are ALL, CREATE, EXTENDED, UPDATE (API
         * version 29.0).
         * 
         * The option is a:
         * <code>org.apache.camel.component.salesforce.internal.dto.NotifyForOperationsEnum</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder notifyForOperations(
                NotifyForOperationsEnum notifyForOperations) {
            setProperty("notifyForOperations", notifyForOperations);
            return this;
        }
        /**
         * Notify for operations, options are ALL, CREATE, EXTENDED, UPDATE (API
         * version 29.0).
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.salesforce.internal.dto.NotifyForOperationsEnum</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder notifyForOperations(
                String notifyForOperations) {
            setProperty("notifyForOperations", notifyForOperations);
            return this;
        }
        /**
         * Notify for un-delete operation, defaults to false (API version =
         * 29.0).
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder notifyForOperationUndelete(
                Boolean notifyForOperationUndelete) {
            setProperty("notifyForOperationUndelete", notifyForOperationUndelete);
            return this;
        }
        /**
         * Notify for un-delete operation, defaults to false (API version =
         * 29.0).
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder notifyForOperationUndelete(
                String notifyForOperationUndelete) {
            setProperty("notifyForOperationUndelete", notifyForOperationUndelete);
            return this;
        }
        /**
         * Notify for update operation, defaults to false (API version = 29.0).
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder notifyForOperationUpdate(
                Boolean notifyForOperationUpdate) {
            setProperty("notifyForOperationUpdate", notifyForOperationUpdate);
            return this;
        }
        /**
         * Notify for update operation, defaults to false (API version = 29.0).
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder notifyForOperationUpdate(
                String notifyForOperationUpdate) {
            setProperty("notifyForOperationUpdate", notifyForOperationUpdate);
            return this;
        }
        /**
         * Custom Jackson ObjectMapper to use when serializing/deserializing
         * Salesforce objects.
         * 
         * The option is a:
         * <code>com.fasterxml.jackson.databind.ObjectMapper</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder objectMapper(
                Object objectMapper) {
            setProperty("objectMapper", objectMapper);
            return this;
        }
        /**
         * Custom Jackson ObjectMapper to use when serializing/deserializing
         * Salesforce objects.
         * 
         * The option will be converted to a
         * <code>com.fasterxml.jackson.databind.ObjectMapper</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder objectMapper(
                String objectMapper) {
            setProperty("objectMapper", objectMapper);
            return this;
        }
        /**
         * Use raw payload String for request and response (either JSON or XML
         * depending on format), instead of DTOs, false by default.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder rawPayload(boolean rawPayload) {
            setProperty("rawPayload", rawPayload);
            return this;
        }
        /**
         * Use raw payload String for request and response (either JSON or XML
         * depending on format), instead of DTOs, false by default.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder rawPayload(String rawPayload) {
            setProperty("rawPayload", rawPayload);
            return this;
        }
        /**
         * Salesforce1 Analytics report Id.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder reportId(String reportId) {
            setProperty("reportId", reportId);
            return this;
        }
        /**
         * Salesforce1 Analytics report metadata for filtering.
         * 
         * The option is a:
         * <code>org.apache.camel.component.salesforce.api.dto.analytics.reports.ReportMetadata</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder reportMetadata(
                Object reportMetadata) {
            setProperty("reportMetadata", reportMetadata);
            return this;
        }
        /**
         * Salesforce1 Analytics report metadata for filtering.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.salesforce.api.dto.analytics.reports.ReportMetadata</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder reportMetadata(
                String reportMetadata) {
            setProperty("reportMetadata", reportMetadata);
            return this;
        }
        /**
         * Bulk API Result ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder resultId(String resultId) {
            setProperty("resultId", resultId);
            return this;
        }
        /**
         * Should the NULL values of given DTO be serialized with empty (NULL)
         * values. This affects only JSON data format.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder serializeNulls(
                boolean serializeNulls) {
            setProperty("serializeNulls", serializeNulls);
            return this;
        }
        /**
         * Should the NULL values of given DTO be serialized with empty (NULL)
         * values. This affects only JSON data format.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder serializeNulls(
                String serializeNulls) {
            setProperty("serializeNulls", serializeNulls);
            return this;
        }
        /**
         * SObject blob field name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder sObjectBlobFieldName(
                String sObjectBlobFieldName) {
            setProperty("sObjectBlobFieldName", sObjectBlobFieldName);
            return this;
        }
        /**
         * Fully qualified SObject class name, usually generated using
         * camel-salesforce-maven-plugin.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder sObjectClass(
                String sObjectClass) {
            setProperty("sObjectClass", sObjectClass);
            return this;
        }
        /**
         * SObject fields to retrieve.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder sObjectFields(
                String sObjectFields) {
            setProperty("sObjectFields", sObjectFields);
            return this;
        }
        /**
         * SObject ID if required by API.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder sObjectId(String sObjectId) {
            setProperty("sObjectId", sObjectId);
            return this;
        }
        /**
         * SObject external ID field name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder sObjectIdName(
                String sObjectIdName) {
            setProperty("sObjectIdName", sObjectIdName);
            return this;
        }
        /**
         * SObject external ID field value.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder sObjectIdValue(
                String sObjectIdValue) {
            setProperty("sObjectIdValue", sObjectIdValue);
            return this;
        }
        /**
         * SObject name if required or supported by API.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder sObjectName(String sObjectName) {
            setProperty("sObjectName", sObjectName);
            return this;
        }
        /**
         * Salesforce SOQL query string.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder sObjectQuery(
                String sObjectQuery) {
            setProperty("sObjectQuery", sObjectQuery);
            return this;
        }
        /**
         * Salesforce SOSL search string.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder sObjectSearch(
                String sObjectSearch) {
            setProperty("sObjectSearch", sObjectSearch);
            return this;
        }
        /**
         * Whether to update an existing Push Topic when using the Streaming
         * API, defaults to false.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder updateTopic(
                boolean updateTopic) {
            setProperty("updateTopic", updateTopic);
            return this;
        }
        /**
         * Whether to update an existing Push Topic when using the Streaming
         * API, defaults to false.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointConsumerBuilder updateTopic(String updateTopic) {
            setProperty("updateTopic", updateTopic);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default SalesforceEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            setProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default SalesforceEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            setProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * The replayId value to use when subscribing.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: consumer
         */
        default SalesforceEndpointConsumerBuilder replayId(Long replayId) {
            setProperty("replayId", replayId);
            return this;
        }
        /**
         * The replayId value to use when subscribing.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: consumer
         */
        default SalesforceEndpointConsumerBuilder replayId(String replayId) {
            setProperty("replayId", replayId);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Salesforce component.
     */
    public interface AdvancedSalesforceEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default SalesforceEndpointConsumerBuilder basic() {
            return (SalesforceEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedSalesforceEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            setProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedSalesforceEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            setProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedSalesforceEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            setProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedSalesforceEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            setProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSalesforceEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSalesforceEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSalesforceEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSalesforceEndpointConsumerBuilder synchronous(
                String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Salesforce component.
     */
    public interface SalesforceEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedSalesforceEndpointProducerBuilder advanced() {
            return (AdvancedSalesforceEndpointProducerBuilder) this;
        }
        /**
         * APEX method name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder apexMethod(String apexMethod) {
            setProperty("apexMethod", apexMethod);
            return this;
        }
        /**
         * Query params for APEX method.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder apexQueryParams(
                Map<String, Object> apexQueryParams) {
            setProperty("apexQueryParams", apexQueryParams);
            return this;
        }
        /**
         * Query params for APEX method.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder apexQueryParams(
                String apexQueryParams) {
            setProperty("apexQueryParams", apexQueryParams);
            return this;
        }
        /**
         * APEX method URL.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder apexUrl(String apexUrl) {
            setProperty("apexUrl", apexUrl);
            return this;
        }
        /**
         * Salesforce API version, defaults to
         * SalesforceEndpointConfig.DEFAULT_VERSION.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder apiVersion(String apiVersion) {
            setProperty("apiVersion", apiVersion);
            return this;
        }
        /**
         * Backoff interval increment for Streaming connection restart attempts
         * for failures beyond CometD auto-reconnect.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder backoffIncrement(
                long backoffIncrement) {
            setProperty("backoffIncrement", backoffIncrement);
            return this;
        }
        /**
         * Backoff interval increment for Streaming connection restart attempts
         * for failures beyond CometD auto-reconnect.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder backoffIncrement(
                String backoffIncrement) {
            setProperty("backoffIncrement", backoffIncrement);
            return this;
        }
        /**
         * Bulk API Batch ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder batchId(String batchId) {
            setProperty("batchId", batchId);
            return this;
        }
        /**
         * Bulk API content type, one of XML, CSV, ZIP_XML, ZIP_CSV.
         * 
         * The option is a:
         * <code>org.apache.camel.component.salesforce.api.dto.bulk.ContentType</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder contentType(
                ContentType contentType) {
            setProperty("contentType", contentType);
            return this;
        }
        /**
         * Bulk API content type, one of XML, CSV, ZIP_XML, ZIP_CSV.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.salesforce.api.dto.bulk.ContentType</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder contentType(String contentType) {
            setProperty("contentType", contentType);
            return this;
        }
        /**
         * Default replayId setting if no value is found in initialReplayIdMap.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder defaultReplayId(
                Long defaultReplayId) {
            setProperty("defaultReplayId", defaultReplayId);
            return this;
        }
        /**
         * Default replayId setting if no value is found in initialReplayIdMap.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder defaultReplayId(
                String defaultReplayId) {
            setProperty("defaultReplayId", defaultReplayId);
            return this;
        }
        /**
         * Payload format to use for Salesforce API calls, either JSON or XML,
         * defaults to JSON.
         * 
         * The option is a:
         * <code>org.apache.camel.component.salesforce.internal.PayloadFormat</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder format(PayloadFormat format) {
            setProperty("format", format);
            return this;
        }
        /**
         * Payload format to use for Salesforce API calls, either JSON or XML,
         * defaults to JSON.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.salesforce.internal.PayloadFormat</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder format(String format) {
            setProperty("format", format);
            return this;
        }
        /**
         * Custom Jetty Http Client to use to connect to Salesforce.
         * 
         * The option is a:
         * <code>org.apache.camel.component.salesforce.SalesforceHttpClient</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder httpClient(Object httpClient) {
            setProperty("httpClient", httpClient);
            return this;
        }
        /**
         * Custom Jetty Http Client to use to connect to Salesforce.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.salesforce.SalesforceHttpClient</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder httpClient(String httpClient) {
            setProperty("httpClient", httpClient);
            return this;
        }
        /**
         * Include details in Salesforce1 Analytics report, defaults to false.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder includeDetails(
                Boolean includeDetails) {
            setProperty("includeDetails", includeDetails);
            return this;
        }
        /**
         * Include details in Salesforce1 Analytics report, defaults to false.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder includeDetails(
                String includeDetails) {
            setProperty("includeDetails", includeDetails);
            return this;
        }
        /**
         * Replay IDs to start from per channel name.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Long&gt;</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder initialReplayIdMap(
                Map<String, Long> initialReplayIdMap) {
            setProperty("initialReplayIdMap", initialReplayIdMap);
            return this;
        }
        /**
         * Replay IDs to start from per channel name.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Long&gt;</code>
         * type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder initialReplayIdMap(
                String initialReplayIdMap) {
            setProperty("initialReplayIdMap", initialReplayIdMap);
            return this;
        }
        /**
         * Salesforce1 Analytics report execution instance ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder instanceId(String instanceId) {
            setProperty("instanceId", instanceId);
            return this;
        }
        /**
         * Bulk API Job ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder jobId(String jobId) {
            setProperty("jobId", jobId);
            return this;
        }
        /**
         * Limit on number of returned records. Applicable to some of the API,
         * check the Salesforce documentation.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder limit(Integer limit) {
            setProperty("limit", limit);
            return this;
        }
        /**
         * Limit on number of returned records. Applicable to some of the API,
         * check the Salesforce documentation.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder limit(String limit) {
            setProperty("limit", limit);
            return this;
        }
        /**
         * Maximum backoff interval for Streaming connection restart attempts
         * for failures beyond CometD auto-reconnect.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder maxBackoff(long maxBackoff) {
            setProperty("maxBackoff", maxBackoff);
            return this;
        }
        /**
         * Maximum backoff interval for Streaming connection restart attempts
         * for failures beyond CometD auto-reconnect.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder maxBackoff(String maxBackoff) {
            setProperty("maxBackoff", maxBackoff);
            return this;
        }
        /**
         * Sets the behaviour of 404 not found status received from Salesforce
         * API. Should the body be set to NULL NotFoundBehaviour#NULL or should
         * a exception be signaled on the exchange NotFoundBehaviour#EXCEPTION -
         * the default.
         * 
         * The option is a:
         * <code>org.apache.camel.component.salesforce.NotFoundBehaviour</code>
         * type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder notFoundBehaviour(
                NotFoundBehaviour notFoundBehaviour) {
            setProperty("notFoundBehaviour", notFoundBehaviour);
            return this;
        }
        /**
         * Sets the behaviour of 404 not found status received from Salesforce
         * API. Should the body be set to NULL NotFoundBehaviour#NULL or should
         * a exception be signaled on the exchange NotFoundBehaviour#EXCEPTION -
         * the default.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.salesforce.NotFoundBehaviour</code>
         * type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder notFoundBehaviour(
                String notFoundBehaviour) {
            setProperty("notFoundBehaviour", notFoundBehaviour);
            return this;
        }
        /**
         * Notify for fields, options are ALL, REFERENCED, SELECT, WHERE.
         * 
         * The option is a:
         * <code>org.apache.camel.component.salesforce.internal.dto.NotifyForFieldsEnum</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder notifyForFields(
                NotifyForFieldsEnum notifyForFields) {
            setProperty("notifyForFields", notifyForFields);
            return this;
        }
        /**
         * Notify for fields, options are ALL, REFERENCED, SELECT, WHERE.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.salesforce.internal.dto.NotifyForFieldsEnum</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder notifyForFields(
                String notifyForFields) {
            setProperty("notifyForFields", notifyForFields);
            return this;
        }
        /**
         * Notify for create operation, defaults to false (API version = 29.0).
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder notifyForOperationCreate(
                Boolean notifyForOperationCreate) {
            setProperty("notifyForOperationCreate", notifyForOperationCreate);
            return this;
        }
        /**
         * Notify for create operation, defaults to false (API version = 29.0).
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder notifyForOperationCreate(
                String notifyForOperationCreate) {
            setProperty("notifyForOperationCreate", notifyForOperationCreate);
            return this;
        }
        /**
         * Notify for delete operation, defaults to false (API version = 29.0).
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder notifyForOperationDelete(
                Boolean notifyForOperationDelete) {
            setProperty("notifyForOperationDelete", notifyForOperationDelete);
            return this;
        }
        /**
         * Notify for delete operation, defaults to false (API version = 29.0).
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder notifyForOperationDelete(
                String notifyForOperationDelete) {
            setProperty("notifyForOperationDelete", notifyForOperationDelete);
            return this;
        }
        /**
         * Notify for operations, options are ALL, CREATE, EXTENDED, UPDATE (API
         * version 29.0).
         * 
         * The option is a:
         * <code>org.apache.camel.component.salesforce.internal.dto.NotifyForOperationsEnum</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder notifyForOperations(
                NotifyForOperationsEnum notifyForOperations) {
            setProperty("notifyForOperations", notifyForOperations);
            return this;
        }
        /**
         * Notify for operations, options are ALL, CREATE, EXTENDED, UPDATE (API
         * version 29.0).
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.salesforce.internal.dto.NotifyForOperationsEnum</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder notifyForOperations(
                String notifyForOperations) {
            setProperty("notifyForOperations", notifyForOperations);
            return this;
        }
        /**
         * Notify for un-delete operation, defaults to false (API version =
         * 29.0).
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder notifyForOperationUndelete(
                Boolean notifyForOperationUndelete) {
            setProperty("notifyForOperationUndelete", notifyForOperationUndelete);
            return this;
        }
        /**
         * Notify for un-delete operation, defaults to false (API version =
         * 29.0).
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder notifyForOperationUndelete(
                String notifyForOperationUndelete) {
            setProperty("notifyForOperationUndelete", notifyForOperationUndelete);
            return this;
        }
        /**
         * Notify for update operation, defaults to false (API version = 29.0).
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder notifyForOperationUpdate(
                Boolean notifyForOperationUpdate) {
            setProperty("notifyForOperationUpdate", notifyForOperationUpdate);
            return this;
        }
        /**
         * Notify for update operation, defaults to false (API version = 29.0).
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder notifyForOperationUpdate(
                String notifyForOperationUpdate) {
            setProperty("notifyForOperationUpdate", notifyForOperationUpdate);
            return this;
        }
        /**
         * Custom Jackson ObjectMapper to use when serializing/deserializing
         * Salesforce objects.
         * 
         * The option is a:
         * <code>com.fasterxml.jackson.databind.ObjectMapper</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder objectMapper(
                Object objectMapper) {
            setProperty("objectMapper", objectMapper);
            return this;
        }
        /**
         * Custom Jackson ObjectMapper to use when serializing/deserializing
         * Salesforce objects.
         * 
         * The option will be converted to a
         * <code>com.fasterxml.jackson.databind.ObjectMapper</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder objectMapper(
                String objectMapper) {
            setProperty("objectMapper", objectMapper);
            return this;
        }
        /**
         * Use raw payload String for request and response (either JSON or XML
         * depending on format), instead of DTOs, false by default.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder rawPayload(boolean rawPayload) {
            setProperty("rawPayload", rawPayload);
            return this;
        }
        /**
         * Use raw payload String for request and response (either JSON or XML
         * depending on format), instead of DTOs, false by default.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder rawPayload(String rawPayload) {
            setProperty("rawPayload", rawPayload);
            return this;
        }
        /**
         * Salesforce1 Analytics report Id.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder reportId(String reportId) {
            setProperty("reportId", reportId);
            return this;
        }
        /**
         * Salesforce1 Analytics report metadata for filtering.
         * 
         * The option is a:
         * <code>org.apache.camel.component.salesforce.api.dto.analytics.reports.ReportMetadata</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder reportMetadata(
                Object reportMetadata) {
            setProperty("reportMetadata", reportMetadata);
            return this;
        }
        /**
         * Salesforce1 Analytics report metadata for filtering.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.salesforce.api.dto.analytics.reports.ReportMetadata</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder reportMetadata(
                String reportMetadata) {
            setProperty("reportMetadata", reportMetadata);
            return this;
        }
        /**
         * Bulk API Result ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder resultId(String resultId) {
            setProperty("resultId", resultId);
            return this;
        }
        /**
         * Should the NULL values of given DTO be serialized with empty (NULL)
         * values. This affects only JSON data format.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder serializeNulls(
                boolean serializeNulls) {
            setProperty("serializeNulls", serializeNulls);
            return this;
        }
        /**
         * Should the NULL values of given DTO be serialized with empty (NULL)
         * values. This affects only JSON data format.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder serializeNulls(
                String serializeNulls) {
            setProperty("serializeNulls", serializeNulls);
            return this;
        }
        /**
         * SObject blob field name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder sObjectBlobFieldName(
                String sObjectBlobFieldName) {
            setProperty("sObjectBlobFieldName", sObjectBlobFieldName);
            return this;
        }
        /**
         * Fully qualified SObject class name, usually generated using
         * camel-salesforce-maven-plugin.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder sObjectClass(
                String sObjectClass) {
            setProperty("sObjectClass", sObjectClass);
            return this;
        }
        /**
         * SObject fields to retrieve.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder sObjectFields(
                String sObjectFields) {
            setProperty("sObjectFields", sObjectFields);
            return this;
        }
        /**
         * SObject ID if required by API.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder sObjectId(String sObjectId) {
            setProperty("sObjectId", sObjectId);
            return this;
        }
        /**
         * SObject external ID field name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder sObjectIdName(
                String sObjectIdName) {
            setProperty("sObjectIdName", sObjectIdName);
            return this;
        }
        /**
         * SObject external ID field value.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder sObjectIdValue(
                String sObjectIdValue) {
            setProperty("sObjectIdValue", sObjectIdValue);
            return this;
        }
        /**
         * SObject name if required or supported by API.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder sObjectName(String sObjectName) {
            setProperty("sObjectName", sObjectName);
            return this;
        }
        /**
         * Salesforce SOQL query string.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder sObjectQuery(
                String sObjectQuery) {
            setProperty("sObjectQuery", sObjectQuery);
            return this;
        }
        /**
         * Salesforce SOSL search string.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder sObjectSearch(
                String sObjectSearch) {
            setProperty("sObjectSearch", sObjectSearch);
            return this;
        }
        /**
         * Whether to update an existing Push Topic when using the Streaming
         * API, defaults to false.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder updateTopic(
                boolean updateTopic) {
            setProperty("updateTopic", updateTopic);
            return this;
        }
        /**
         * Whether to update an existing Push Topic when using the Streaming
         * API, defaults to false.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointProducerBuilder updateTopic(String updateTopic) {
            setProperty("updateTopic", updateTopic);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default SalesforceEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            setProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default SalesforceEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            setProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Salesforce component.
     */
    public interface AdvancedSalesforceEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default SalesforceEndpointProducerBuilder basic() {
            return (SalesforceEndpointProducerBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSalesforceEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSalesforceEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSalesforceEndpointProducerBuilder synchronous(
                boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSalesforceEndpointProducerBuilder synchronous(
                String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Salesforce component.
     */
    public interface SalesforceEndpointBuilder
            extends
                SalesforceEndpointConsumerBuilder, SalesforceEndpointProducerBuilder {
        default AdvancedSalesforceEndpointBuilder advanced() {
            return (AdvancedSalesforceEndpointBuilder) this;
        }
        /**
         * APEX method name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder apexMethod(String apexMethod) {
            setProperty("apexMethod", apexMethod);
            return this;
        }
        /**
         * Query params for APEX method.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder apexQueryParams(
                Map<String, Object> apexQueryParams) {
            setProperty("apexQueryParams", apexQueryParams);
            return this;
        }
        /**
         * Query params for APEX method.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder apexQueryParams(String apexQueryParams) {
            setProperty("apexQueryParams", apexQueryParams);
            return this;
        }
        /**
         * APEX method URL.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder apexUrl(String apexUrl) {
            setProperty("apexUrl", apexUrl);
            return this;
        }
        /**
         * Salesforce API version, defaults to
         * SalesforceEndpointConfig.DEFAULT_VERSION.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder apiVersion(String apiVersion) {
            setProperty("apiVersion", apiVersion);
            return this;
        }
        /**
         * Backoff interval increment for Streaming connection restart attempts
         * for failures beyond CometD auto-reconnect.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder backoffIncrement(long backoffIncrement) {
            setProperty("backoffIncrement", backoffIncrement);
            return this;
        }
        /**
         * Backoff interval increment for Streaming connection restart attempts
         * for failures beyond CometD auto-reconnect.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder backoffIncrement(
                String backoffIncrement) {
            setProperty("backoffIncrement", backoffIncrement);
            return this;
        }
        /**
         * Bulk API Batch ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder batchId(String batchId) {
            setProperty("batchId", batchId);
            return this;
        }
        /**
         * Bulk API content type, one of XML, CSV, ZIP_XML, ZIP_CSV.
         * 
         * The option is a:
         * <code>org.apache.camel.component.salesforce.api.dto.bulk.ContentType</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder contentType(ContentType contentType) {
            setProperty("contentType", contentType);
            return this;
        }
        /**
         * Bulk API content type, one of XML, CSV, ZIP_XML, ZIP_CSV.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.salesforce.api.dto.bulk.ContentType</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder contentType(String contentType) {
            setProperty("contentType", contentType);
            return this;
        }
        /**
         * Default replayId setting if no value is found in initialReplayIdMap.
         * 
         * The option is a: <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder defaultReplayId(Long defaultReplayId) {
            setProperty("defaultReplayId", defaultReplayId);
            return this;
        }
        /**
         * Default replayId setting if no value is found in initialReplayIdMap.
         * 
         * The option will be converted to a <code>java.lang.Long</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder defaultReplayId(String defaultReplayId) {
            setProperty("defaultReplayId", defaultReplayId);
            return this;
        }
        /**
         * Payload format to use for Salesforce API calls, either JSON or XML,
         * defaults to JSON.
         * 
         * The option is a:
         * <code>org.apache.camel.component.salesforce.internal.PayloadFormat</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder format(PayloadFormat format) {
            setProperty("format", format);
            return this;
        }
        /**
         * Payload format to use for Salesforce API calls, either JSON or XML,
         * defaults to JSON.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.salesforce.internal.PayloadFormat</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder format(String format) {
            setProperty("format", format);
            return this;
        }
        /**
         * Custom Jetty Http Client to use to connect to Salesforce.
         * 
         * The option is a:
         * <code>org.apache.camel.component.salesforce.SalesforceHttpClient</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder httpClient(Object httpClient) {
            setProperty("httpClient", httpClient);
            return this;
        }
        /**
         * Custom Jetty Http Client to use to connect to Salesforce.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.salesforce.SalesforceHttpClient</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder httpClient(String httpClient) {
            setProperty("httpClient", httpClient);
            return this;
        }
        /**
         * Include details in Salesforce1 Analytics report, defaults to false.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder includeDetails(Boolean includeDetails) {
            setProperty("includeDetails", includeDetails);
            return this;
        }
        /**
         * Include details in Salesforce1 Analytics report, defaults to false.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder includeDetails(String includeDetails) {
            setProperty("includeDetails", includeDetails);
            return this;
        }
        /**
         * Replay IDs to start from per channel name.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Long&gt;</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder initialReplayIdMap(
                Map<String, Long> initialReplayIdMap) {
            setProperty("initialReplayIdMap", initialReplayIdMap);
            return this;
        }
        /**
         * Replay IDs to start from per channel name.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Long&gt;</code>
         * type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder initialReplayIdMap(
                String initialReplayIdMap) {
            setProperty("initialReplayIdMap", initialReplayIdMap);
            return this;
        }
        /**
         * Salesforce1 Analytics report execution instance ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder instanceId(String instanceId) {
            setProperty("instanceId", instanceId);
            return this;
        }
        /**
         * Bulk API Job ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder jobId(String jobId) {
            setProperty("jobId", jobId);
            return this;
        }
        /**
         * Limit on number of returned records. Applicable to some of the API,
         * check the Salesforce documentation.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder limit(Integer limit) {
            setProperty("limit", limit);
            return this;
        }
        /**
         * Limit on number of returned records. Applicable to some of the API,
         * check the Salesforce documentation.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder limit(String limit) {
            setProperty("limit", limit);
            return this;
        }
        /**
         * Maximum backoff interval for Streaming connection restart attempts
         * for failures beyond CometD auto-reconnect.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder maxBackoff(long maxBackoff) {
            setProperty("maxBackoff", maxBackoff);
            return this;
        }
        /**
         * Maximum backoff interval for Streaming connection restart attempts
         * for failures beyond CometD auto-reconnect.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder maxBackoff(String maxBackoff) {
            setProperty("maxBackoff", maxBackoff);
            return this;
        }
        /**
         * Sets the behaviour of 404 not found status received from Salesforce
         * API. Should the body be set to NULL NotFoundBehaviour#NULL or should
         * a exception be signaled on the exchange NotFoundBehaviour#EXCEPTION -
         * the default.
         * 
         * The option is a:
         * <code>org.apache.camel.component.salesforce.NotFoundBehaviour</code>
         * type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder notFoundBehaviour(
                NotFoundBehaviour notFoundBehaviour) {
            setProperty("notFoundBehaviour", notFoundBehaviour);
            return this;
        }
        /**
         * Sets the behaviour of 404 not found status received from Salesforce
         * API. Should the body be set to NULL NotFoundBehaviour#NULL or should
         * a exception be signaled on the exchange NotFoundBehaviour#EXCEPTION -
         * the default.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.salesforce.NotFoundBehaviour</code>
         * type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder notFoundBehaviour(
                String notFoundBehaviour) {
            setProperty("notFoundBehaviour", notFoundBehaviour);
            return this;
        }
        /**
         * Notify for fields, options are ALL, REFERENCED, SELECT, WHERE.
         * 
         * The option is a:
         * <code>org.apache.camel.component.salesforce.internal.dto.NotifyForFieldsEnum</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder notifyForFields(
                NotifyForFieldsEnum notifyForFields) {
            setProperty("notifyForFields", notifyForFields);
            return this;
        }
        /**
         * Notify for fields, options are ALL, REFERENCED, SELECT, WHERE.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.salesforce.internal.dto.NotifyForFieldsEnum</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder notifyForFields(String notifyForFields) {
            setProperty("notifyForFields", notifyForFields);
            return this;
        }
        /**
         * Notify for create operation, defaults to false (API version = 29.0).
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder notifyForOperationCreate(
                Boolean notifyForOperationCreate) {
            setProperty("notifyForOperationCreate", notifyForOperationCreate);
            return this;
        }
        /**
         * Notify for create operation, defaults to false (API version = 29.0).
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder notifyForOperationCreate(
                String notifyForOperationCreate) {
            setProperty("notifyForOperationCreate", notifyForOperationCreate);
            return this;
        }
        /**
         * Notify for delete operation, defaults to false (API version = 29.0).
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder notifyForOperationDelete(
                Boolean notifyForOperationDelete) {
            setProperty("notifyForOperationDelete", notifyForOperationDelete);
            return this;
        }
        /**
         * Notify for delete operation, defaults to false (API version = 29.0).
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder notifyForOperationDelete(
                String notifyForOperationDelete) {
            setProperty("notifyForOperationDelete", notifyForOperationDelete);
            return this;
        }
        /**
         * Notify for operations, options are ALL, CREATE, EXTENDED, UPDATE (API
         * version 29.0).
         * 
         * The option is a:
         * <code>org.apache.camel.component.salesforce.internal.dto.NotifyForOperationsEnum</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder notifyForOperations(
                NotifyForOperationsEnum notifyForOperations) {
            setProperty("notifyForOperations", notifyForOperations);
            return this;
        }
        /**
         * Notify for operations, options are ALL, CREATE, EXTENDED, UPDATE (API
         * version 29.0).
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.salesforce.internal.dto.NotifyForOperationsEnum</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder notifyForOperations(
                String notifyForOperations) {
            setProperty("notifyForOperations", notifyForOperations);
            return this;
        }
        /**
         * Notify for un-delete operation, defaults to false (API version =
         * 29.0).
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder notifyForOperationUndelete(
                Boolean notifyForOperationUndelete) {
            setProperty("notifyForOperationUndelete", notifyForOperationUndelete);
            return this;
        }
        /**
         * Notify for un-delete operation, defaults to false (API version =
         * 29.0).
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder notifyForOperationUndelete(
                String notifyForOperationUndelete) {
            setProperty("notifyForOperationUndelete", notifyForOperationUndelete);
            return this;
        }
        /**
         * Notify for update operation, defaults to false (API version = 29.0).
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder notifyForOperationUpdate(
                Boolean notifyForOperationUpdate) {
            setProperty("notifyForOperationUpdate", notifyForOperationUpdate);
            return this;
        }
        /**
         * Notify for update operation, defaults to false (API version = 29.0).
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder notifyForOperationUpdate(
                String notifyForOperationUpdate) {
            setProperty("notifyForOperationUpdate", notifyForOperationUpdate);
            return this;
        }
        /**
         * Custom Jackson ObjectMapper to use when serializing/deserializing
         * Salesforce objects.
         * 
         * The option is a:
         * <code>com.fasterxml.jackson.databind.ObjectMapper</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder objectMapper(Object objectMapper) {
            setProperty("objectMapper", objectMapper);
            return this;
        }
        /**
         * Custom Jackson ObjectMapper to use when serializing/deserializing
         * Salesforce objects.
         * 
         * The option will be converted to a
         * <code>com.fasterxml.jackson.databind.ObjectMapper</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder objectMapper(String objectMapper) {
            setProperty("objectMapper", objectMapper);
            return this;
        }
        /**
         * Use raw payload String for request and response (either JSON or XML
         * depending on format), instead of DTOs, false by default.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder rawPayload(boolean rawPayload) {
            setProperty("rawPayload", rawPayload);
            return this;
        }
        /**
         * Use raw payload String for request and response (either JSON or XML
         * depending on format), instead of DTOs, false by default.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder rawPayload(String rawPayload) {
            setProperty("rawPayload", rawPayload);
            return this;
        }
        /**
         * Salesforce1 Analytics report Id.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder reportId(String reportId) {
            setProperty("reportId", reportId);
            return this;
        }
        /**
         * Salesforce1 Analytics report metadata for filtering.
         * 
         * The option is a:
         * <code>org.apache.camel.component.salesforce.api.dto.analytics.reports.ReportMetadata</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder reportMetadata(Object reportMetadata) {
            setProperty("reportMetadata", reportMetadata);
            return this;
        }
        /**
         * Salesforce1 Analytics report metadata for filtering.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.salesforce.api.dto.analytics.reports.ReportMetadata</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder reportMetadata(String reportMetadata) {
            setProperty("reportMetadata", reportMetadata);
            return this;
        }
        /**
         * Bulk API Result ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder resultId(String resultId) {
            setProperty("resultId", resultId);
            return this;
        }
        /**
         * Should the NULL values of given DTO be serialized with empty (NULL)
         * values. This affects only JSON data format.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder serializeNulls(boolean serializeNulls) {
            setProperty("serializeNulls", serializeNulls);
            return this;
        }
        /**
         * Should the NULL values of given DTO be serialized with empty (NULL)
         * values. This affects only JSON data format.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder serializeNulls(String serializeNulls) {
            setProperty("serializeNulls", serializeNulls);
            return this;
        }
        /**
         * SObject blob field name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder sObjectBlobFieldName(
                String sObjectBlobFieldName) {
            setProperty("sObjectBlobFieldName", sObjectBlobFieldName);
            return this;
        }
        /**
         * Fully qualified SObject class name, usually generated using
         * camel-salesforce-maven-plugin.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder sObjectClass(String sObjectClass) {
            setProperty("sObjectClass", sObjectClass);
            return this;
        }
        /**
         * SObject fields to retrieve.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder sObjectFields(String sObjectFields) {
            setProperty("sObjectFields", sObjectFields);
            return this;
        }
        /**
         * SObject ID if required by API.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder sObjectId(String sObjectId) {
            setProperty("sObjectId", sObjectId);
            return this;
        }
        /**
         * SObject external ID field name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder sObjectIdName(String sObjectIdName) {
            setProperty("sObjectIdName", sObjectIdName);
            return this;
        }
        /**
         * SObject external ID field value.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder sObjectIdValue(String sObjectIdValue) {
            setProperty("sObjectIdValue", sObjectIdValue);
            return this;
        }
        /**
         * SObject name if required or supported by API.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder sObjectName(String sObjectName) {
            setProperty("sObjectName", sObjectName);
            return this;
        }
        /**
         * Salesforce SOQL query string.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder sObjectQuery(String sObjectQuery) {
            setProperty("sObjectQuery", sObjectQuery);
            return this;
        }
        /**
         * Salesforce SOSL search string.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder sObjectSearch(String sObjectSearch) {
            setProperty("sObjectSearch", sObjectSearch);
            return this;
        }
        /**
         * Whether to update an existing Push Topic when using the Streaming
         * API, defaults to false.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder updateTopic(boolean updateTopic) {
            setProperty("updateTopic", updateTopic);
            return this;
        }
        /**
         * Whether to update an existing Push Topic when using the Streaming
         * API, defaults to false.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default SalesforceEndpointBuilder updateTopic(String updateTopic) {
            setProperty("updateTopic", updateTopic);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Salesforce component.
     */
    public interface AdvancedSalesforceEndpointBuilder
            extends
                AdvancedSalesforceEndpointConsumerBuilder, AdvancedSalesforceEndpointProducerBuilder {
        default SalesforceEndpointBuilder basic() {
            return (SalesforceEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSalesforceEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSalesforceEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSalesforceEndpointBuilder synchronous(
                boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSalesforceEndpointBuilder synchronous(String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.salesforce.api.dto.bulk.ContentType</code> enum.
     */
    enum ContentType {
        XML,
        CSV,
        JSON,
        ZIP_XML,
        ZIP_CSV,
        ZIP_JSON;
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.salesforce.internal.PayloadFormat</code>
     * enum.
     */
    enum PayloadFormat {
        JSON,
        XML;
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.salesforce.NotFoundBehaviour</code>
     * enum.
     */
    enum NotFoundBehaviour {
        EXCEPTION,
        NULL;
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.salesforce.internal.dto.NotifyForFieldsEnum</code> enum.
     */
    enum NotifyForFieldsEnum {
        ALL,
        REFERENCED,
        SELECT,
        WHERE;
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.salesforce.internal.dto.NotifyForOperationsEnum</code> enum.
     */
    enum NotifyForOperationsEnum {
        ALL,
        CREATE,
        EXTENDED,
        UPDATE;
    }
    /**
     * Salesforce (camel-salesforce)
     * The salesforce component is used for integrating Camel with the massive
     * Salesforce API.
     * 
     * Category: api,cloud,crm
     * Available as of version: 2.12
     * Maven coordinates: org.apache.camel:camel-salesforce
     * 
     * Syntax: <code>salesforce:operationName:topicName</code>
     * 
     * Path parameter: operationName
     * The operation to use
     * The value can be one of: getVersions, getResources, getGlobalObjects,
     * getBasicInfo, getDescription, getSObject, createSObject, updateSObject,
     * deleteSObject, getSObjectWithId, upsertSObject, deleteSObjectWithId,
     * getBlobField, query, queryMore, queryAll, search, apexCall, recent,
     * createJob, getJob, closeJob, abortJob, createBatch, getBatch,
     * getAllBatches, getRequest, getResults, createBatchQuery,
     * getQueryResultIds, getQueryResult, getRecentReports,
     * getReportDescription, executeSyncReport, executeAsyncReport,
     * getReportInstances, getReportResults, limits, approval, approvals,
     * composite-tree, composite-batch, composite
     * 
     * Path parameter: topicName
     * The name of the topic/channel to use
     */
    default SalesforceEndpointBuilder salesforce(String path) {
        class SalesforceEndpointBuilderImpl extends AbstractEndpointBuilder implements SalesforceEndpointBuilder, AdvancedSalesforceEndpointBuilder {
            public SalesforceEndpointBuilderImpl(String path) {
                super("salesforce", path);
            }
        }
        return new SalesforceEndpointBuilderImpl(path);
    }
}