/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.PollingConsumerPollStrategy;

/**
 * The flatpack component supports fixed width and delimited file parsing via
 * the FlatPack library.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface FlatpackEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Flatpack component.
     */
    public interface FlatpackEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedFlatpackEndpointConsumerBuilder advanced() {
            return (AdvancedFlatpackEndpointConsumerBuilder) this;
        }
        /**
         * Allows for lines to be shorter than expected and ignores the extra
         * characters.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default FlatpackEndpointConsumerBuilder allowShortLines(
                boolean allowShortLines) {
            setProperty("allowShortLines", allowShortLines);
            return this;
        }
        /**
         * Allows for lines to be shorter than expected and ignores the extra
         * characters.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default FlatpackEndpointConsumerBuilder allowShortLines(
                String allowShortLines) {
            setProperty("allowShortLines", allowShortLines);
            return this;
        }
        /**
         * The default character delimiter for delimited files.
         * 
         * The option is a: <code>char</code> type.
         * 
         * Group: common
         */
        default FlatpackEndpointConsumerBuilder delimiter(char delimiter) {
            setProperty("delimiter", delimiter);
            return this;
        }
        /**
         * The default character delimiter for delimited files.
         * 
         * The option will be converted to a <code>char</code> type.
         * 
         * Group: common
         */
        default FlatpackEndpointConsumerBuilder delimiter(String delimiter) {
            setProperty("delimiter", delimiter);
            return this;
        }
        /**
         * Allows for lines to be longer than expected and ignores the extra
         * characters.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default FlatpackEndpointConsumerBuilder ignoreExtraColumns(
                boolean ignoreExtraColumns) {
            setProperty("ignoreExtraColumns", ignoreExtraColumns);
            return this;
        }
        /**
         * Allows for lines to be longer than expected and ignores the extra
         * characters.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default FlatpackEndpointConsumerBuilder ignoreExtraColumns(
                String ignoreExtraColumns) {
            setProperty("ignoreExtraColumns", ignoreExtraColumns);
            return this;
        }
        /**
         * Whether the first line is ignored for delimited files (for the column
         * headers).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default FlatpackEndpointConsumerBuilder ignoreFirstRecord(
                boolean ignoreFirstRecord) {
            setProperty("ignoreFirstRecord", ignoreFirstRecord);
            return this;
        }
        /**
         * Whether the first line is ignored for delimited files (for the column
         * headers).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default FlatpackEndpointConsumerBuilder ignoreFirstRecord(
                String ignoreFirstRecord) {
            setProperty("ignoreFirstRecord", ignoreFirstRecord);
            return this;
        }
        /**
         * Sets the Component to send each row as a separate exchange once
         * parsed.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default FlatpackEndpointConsumerBuilder splitRows(boolean splitRows) {
            setProperty("splitRows", splitRows);
            return this;
        }
        /**
         * Sets the Component to send each row as a separate exchange once
         * parsed.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default FlatpackEndpointConsumerBuilder splitRows(String splitRows) {
            setProperty("splitRows", splitRows);
            return this;
        }
        /**
         * The text qualifier for delimited files.
         * 
         * The option is a: <code>char</code> type.
         * 
         * Group: common
         */
        default FlatpackEndpointConsumerBuilder textQualifier(char textQualifier) {
            setProperty("textQualifier", textQualifier);
            return this;
        }
        /**
         * The text qualifier for delimited files.
         * 
         * The option will be converted to a <code>char</code> type.
         * 
         * Group: common
         */
        default FlatpackEndpointConsumerBuilder textQualifier(
                String textQualifier) {
            setProperty("textQualifier", textQualifier);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default FlatpackEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            setProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default FlatpackEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            setProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default FlatpackEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                boolean sendEmptyMessageWhenIdle) {
            setProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default FlatpackEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                String sendEmptyMessageWhenIdle) {
            setProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default FlatpackEndpointConsumerBuilder backoffErrorThreshold(
                int backoffErrorThreshold) {
            setProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default FlatpackEndpointConsumerBuilder backoffErrorThreshold(
                String backoffErrorThreshold) {
            setProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default FlatpackEndpointConsumerBuilder backoffIdleThreshold(
                int backoffIdleThreshold) {
            setProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default FlatpackEndpointConsumerBuilder backoffIdleThreshold(
                String backoffIdleThreshold) {
            setProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default FlatpackEndpointConsumerBuilder backoffMultiplier(
                int backoffMultiplier) {
            setProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default FlatpackEndpointConsumerBuilder backoffMultiplier(
                String backoffMultiplier) {
            setProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * Milliseconds before the next poll. You can also specify time values
         * using units, such as 60s (60 seconds), 5m30s (5 minutes and 30
         * seconds), and 1h (1 hour).
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: scheduler
         */
        default FlatpackEndpointConsumerBuilder delay(long delay) {
            setProperty("delay", delay);
            return this;
        }
        /**
         * Milliseconds before the next poll. You can also specify time values
         * using units, such as 60s (60 seconds), 5m30s (5 minutes and 30
         * seconds), and 1h (1 hour).
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: scheduler
         */
        default FlatpackEndpointConsumerBuilder delay(String delay) {
            setProperty("delay", delay);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default FlatpackEndpointConsumerBuilder greedy(boolean greedy) {
            setProperty("greedy", greedy);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default FlatpackEndpointConsumerBuilder greedy(String greedy) {
            setProperty("greedy", greedy);
            return this;
        }
        /**
         * Milliseconds before the first poll starts. You can also specify time
         * values using units, such as 60s (60 seconds), 5m30s (5 minutes and 30
         * seconds), and 1h (1 hour).
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: scheduler
         */
        default FlatpackEndpointConsumerBuilder initialDelay(long initialDelay) {
            setProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Milliseconds before the first poll starts. You can also specify time
         * values using units, such as 60s (60 seconds), 5m30s (5 minutes and 30
         * seconds), and 1h (1 hour).
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: scheduler
         */
        default FlatpackEndpointConsumerBuilder initialDelay(String initialDelay) {
            setProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option is a: <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Group: scheduler
         */
        default FlatpackEndpointConsumerBuilder runLoggingLevel(
                LoggingLevel runLoggingLevel) {
            setProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Group: scheduler
         */
        default FlatpackEndpointConsumerBuilder runLoggingLevel(
                String runLoggingLevel) {
            setProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option is a:
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         */
        default FlatpackEndpointConsumerBuilder scheduledExecutorService(
                ScheduledExecutorService scheduledExecutorService) {
            setProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         */
        default FlatpackEndpointConsumerBuilder scheduledExecutorService(
                String scheduledExecutorService) {
            setProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: scheduler
         */
        default FlatpackEndpointConsumerBuilder scheduler(String scheduler) {
            setProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: scheduler
         */
        default FlatpackEndpointConsumerBuilder schedulerProperties(
                Map<String, Object> schedulerProperties) {
            setProperty("schedulerProperties", schedulerProperties);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: scheduler
         */
        default FlatpackEndpointConsumerBuilder schedulerProperties(
                String schedulerProperties) {
            setProperty("schedulerProperties", schedulerProperties);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default FlatpackEndpointConsumerBuilder startScheduler(
                boolean startScheduler) {
            setProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default FlatpackEndpointConsumerBuilder startScheduler(
                String startScheduler) {
            setProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option is a: <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Group: scheduler
         */
        default FlatpackEndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            setProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Group: scheduler
         */
        default FlatpackEndpointConsumerBuilder timeUnit(String timeUnit) {
            setProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default FlatpackEndpointConsumerBuilder useFixedDelay(
                boolean useFixedDelay) {
            setProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default FlatpackEndpointConsumerBuilder useFixedDelay(
                String useFixedDelay) {
            setProperty("useFixedDelay", useFixedDelay);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Flatpack component.
     */
    public interface AdvancedFlatpackEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default FlatpackEndpointConsumerBuilder basic() {
            return (FlatpackEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedFlatpackEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            setProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedFlatpackEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            setProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedFlatpackEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            setProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedFlatpackEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            setProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedFlatpackEndpointConsumerBuilder pollStrategy(
                PollingConsumerPollStrategy pollStrategy) {
            setProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedFlatpackEndpointConsumerBuilder pollStrategy(
                String pollStrategy) {
            setProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFlatpackEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFlatpackEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFlatpackEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFlatpackEndpointConsumerBuilder synchronous(
                String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Flatpack component.
     */
    public interface FlatpackEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedFlatpackEndpointProducerBuilder advanced() {
            return (AdvancedFlatpackEndpointProducerBuilder) this;
        }
        /**
         * Allows for lines to be shorter than expected and ignores the extra
         * characters.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default FlatpackEndpointProducerBuilder allowShortLines(
                boolean allowShortLines) {
            setProperty("allowShortLines", allowShortLines);
            return this;
        }
        /**
         * Allows for lines to be shorter than expected and ignores the extra
         * characters.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default FlatpackEndpointProducerBuilder allowShortLines(
                String allowShortLines) {
            setProperty("allowShortLines", allowShortLines);
            return this;
        }
        /**
         * The default character delimiter for delimited files.
         * 
         * The option is a: <code>char</code> type.
         * 
         * Group: common
         */
        default FlatpackEndpointProducerBuilder delimiter(char delimiter) {
            setProperty("delimiter", delimiter);
            return this;
        }
        /**
         * The default character delimiter for delimited files.
         * 
         * The option will be converted to a <code>char</code> type.
         * 
         * Group: common
         */
        default FlatpackEndpointProducerBuilder delimiter(String delimiter) {
            setProperty("delimiter", delimiter);
            return this;
        }
        /**
         * Allows for lines to be longer than expected and ignores the extra
         * characters.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default FlatpackEndpointProducerBuilder ignoreExtraColumns(
                boolean ignoreExtraColumns) {
            setProperty("ignoreExtraColumns", ignoreExtraColumns);
            return this;
        }
        /**
         * Allows for lines to be longer than expected and ignores the extra
         * characters.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default FlatpackEndpointProducerBuilder ignoreExtraColumns(
                String ignoreExtraColumns) {
            setProperty("ignoreExtraColumns", ignoreExtraColumns);
            return this;
        }
        /**
         * Whether the first line is ignored for delimited files (for the column
         * headers).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default FlatpackEndpointProducerBuilder ignoreFirstRecord(
                boolean ignoreFirstRecord) {
            setProperty("ignoreFirstRecord", ignoreFirstRecord);
            return this;
        }
        /**
         * Whether the first line is ignored for delimited files (for the column
         * headers).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default FlatpackEndpointProducerBuilder ignoreFirstRecord(
                String ignoreFirstRecord) {
            setProperty("ignoreFirstRecord", ignoreFirstRecord);
            return this;
        }
        /**
         * Sets the Component to send each row as a separate exchange once
         * parsed.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default FlatpackEndpointProducerBuilder splitRows(boolean splitRows) {
            setProperty("splitRows", splitRows);
            return this;
        }
        /**
         * Sets the Component to send each row as a separate exchange once
         * parsed.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default FlatpackEndpointProducerBuilder splitRows(String splitRows) {
            setProperty("splitRows", splitRows);
            return this;
        }
        /**
         * The text qualifier for delimited files.
         * 
         * The option is a: <code>char</code> type.
         * 
         * Group: common
         */
        default FlatpackEndpointProducerBuilder textQualifier(char textQualifier) {
            setProperty("textQualifier", textQualifier);
            return this;
        }
        /**
         * The text qualifier for delimited files.
         * 
         * The option will be converted to a <code>char</code> type.
         * 
         * Group: common
         */
        default FlatpackEndpointProducerBuilder textQualifier(
                String textQualifier) {
            setProperty("textQualifier", textQualifier);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default FlatpackEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            setProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default FlatpackEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            setProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Flatpack component.
     */
    public interface AdvancedFlatpackEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default FlatpackEndpointProducerBuilder basic() {
            return (FlatpackEndpointProducerBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFlatpackEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFlatpackEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFlatpackEndpointProducerBuilder synchronous(
                boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFlatpackEndpointProducerBuilder synchronous(
                String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Flatpack component.
     */
    public interface FlatpackEndpointBuilder
            extends
                FlatpackEndpointConsumerBuilder, FlatpackEndpointProducerBuilder {
        default AdvancedFlatpackEndpointBuilder advanced() {
            return (AdvancedFlatpackEndpointBuilder) this;
        }
        /**
         * Allows for lines to be shorter than expected and ignores the extra
         * characters.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default FlatpackEndpointBuilder allowShortLines(boolean allowShortLines) {
            setProperty("allowShortLines", allowShortLines);
            return this;
        }
        /**
         * Allows for lines to be shorter than expected and ignores the extra
         * characters.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default FlatpackEndpointBuilder allowShortLines(String allowShortLines) {
            setProperty("allowShortLines", allowShortLines);
            return this;
        }
        /**
         * The default character delimiter for delimited files.
         * 
         * The option is a: <code>char</code> type.
         * 
         * Group: common
         */
        default FlatpackEndpointBuilder delimiter(char delimiter) {
            setProperty("delimiter", delimiter);
            return this;
        }
        /**
         * The default character delimiter for delimited files.
         * 
         * The option will be converted to a <code>char</code> type.
         * 
         * Group: common
         */
        default FlatpackEndpointBuilder delimiter(String delimiter) {
            setProperty("delimiter", delimiter);
            return this;
        }
        /**
         * Allows for lines to be longer than expected and ignores the extra
         * characters.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default FlatpackEndpointBuilder ignoreExtraColumns(
                boolean ignoreExtraColumns) {
            setProperty("ignoreExtraColumns", ignoreExtraColumns);
            return this;
        }
        /**
         * Allows for lines to be longer than expected and ignores the extra
         * characters.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default FlatpackEndpointBuilder ignoreExtraColumns(
                String ignoreExtraColumns) {
            setProperty("ignoreExtraColumns", ignoreExtraColumns);
            return this;
        }
        /**
         * Whether the first line is ignored for delimited files (for the column
         * headers).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default FlatpackEndpointBuilder ignoreFirstRecord(
                boolean ignoreFirstRecord) {
            setProperty("ignoreFirstRecord", ignoreFirstRecord);
            return this;
        }
        /**
         * Whether the first line is ignored for delimited files (for the column
         * headers).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default FlatpackEndpointBuilder ignoreFirstRecord(
                String ignoreFirstRecord) {
            setProperty("ignoreFirstRecord", ignoreFirstRecord);
            return this;
        }
        /**
         * Sets the Component to send each row as a separate exchange once
         * parsed.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default FlatpackEndpointBuilder splitRows(boolean splitRows) {
            setProperty("splitRows", splitRows);
            return this;
        }
        /**
         * Sets the Component to send each row as a separate exchange once
         * parsed.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default FlatpackEndpointBuilder splitRows(String splitRows) {
            setProperty("splitRows", splitRows);
            return this;
        }
        /**
         * The text qualifier for delimited files.
         * 
         * The option is a: <code>char</code> type.
         * 
         * Group: common
         */
        default FlatpackEndpointBuilder textQualifier(char textQualifier) {
            setProperty("textQualifier", textQualifier);
            return this;
        }
        /**
         * The text qualifier for delimited files.
         * 
         * The option will be converted to a <code>char</code> type.
         * 
         * Group: common
         */
        default FlatpackEndpointBuilder textQualifier(String textQualifier) {
            setProperty("textQualifier", textQualifier);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Flatpack component.
     */
    public interface AdvancedFlatpackEndpointBuilder
            extends
                AdvancedFlatpackEndpointConsumerBuilder, AdvancedFlatpackEndpointProducerBuilder {
        default FlatpackEndpointBuilder basic() {
            return (FlatpackEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFlatpackEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFlatpackEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFlatpackEndpointBuilder synchronous(boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFlatpackEndpointBuilder synchronous(String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }
    /**
     * Flatpack (camel-flatpack)
     * The flatpack component supports fixed width and delimited file parsing
     * via the FlatPack library.
     * 
     * Category: transformation
     * Available as of version: 1.4
     * Maven coordinates: org.apache.camel:camel-flatpack
     * 
     * Syntax: <code>flatpack:type:resourceUri</code>
     * 
     * Path parameter: type
     * Whether to use fixed or delimiter
     * Default value: delim
     * The value can be one of: fixed, delim
     * 
     * Path parameter: resourceUri (required)
     * URL for loading the flatpack mapping file from classpath or file system
     */
    default FlatpackEndpointBuilder flatpack(String path) {
        class FlatpackEndpointBuilderImpl extends AbstractEndpointBuilder implements FlatpackEndpointBuilder, AdvancedFlatpackEndpointBuilder {
            public FlatpackEndpointBuilderImpl(String path) {
                super("flatpack", path);
            }
        }
        return new FlatpackEndpointBuilderImpl(path);
    }
}