/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * The Facebook component provides access to all of the Facebook APIs accessible
 * using Facebook4J.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface FacebookEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Facebook component.
     */
    public interface FacebookEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedFacebookEndpointConsumerBuilder advanced() {
            return (AdvancedFacebookEndpointConsumerBuilder) this;
        }
        /**
         * The unique URL of the achievement.
         * 
         * The option is a: <code>java.net.URL</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder achievementURL(
                URL achievementURL) {
            setProperty("achievementURL", achievementURL);
            return this;
        }
        /**
         * The unique URL of the achievement.
         * 
         * The option will be converted to a <code>java.net.URL</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder achievementURL(
                String achievementURL) {
            setProperty("achievementURL", achievementURL);
            return this;
        }
        /**
         * The album ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder albumId(String albumId) {
            setProperty("albumId", albumId);
            return this;
        }
        /**
         * The facebook Album to be created or updated.
         * 
         * The option is a: <code>facebook4j.AlbumUpdate</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder albumUpdate(Object albumUpdate) {
            setProperty("albumUpdate", albumUpdate);
            return this;
        }
        /**
         * The facebook Album to be created or updated.
         * 
         * The option will be converted to a <code>facebook4j.AlbumUpdate</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder albumUpdate(String albumUpdate) {
            setProperty("albumUpdate", albumUpdate);
            return this;
        }
        /**
         * The ID of the Facebook Application.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder appId(String appId) {
            setProperty("appId", appId);
            return this;
        }
        /**
         * Location latitude and longitude.
         * 
         * The option is a: <code>facebook4j.GeoLocation</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder center(Object center) {
            setProperty("center", center);
            return this;
        }
        /**
         * Location latitude and longitude.
         * 
         * The option will be converted to a <code>facebook4j.GeoLocation</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder center(String center) {
            setProperty("center", center);
            return this;
        }
        /**
         * The checkin ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder checkinId(String checkinId) {
            setProperty("checkinId", checkinId);
            return this;
        }
        /**
         * The checkin to be created. Deprecated, instead create a Post with an
         * attached location.
         * 
         * The option is a: <code>facebook4j.CheckinUpdate</code> type.
         * 
         * Group: common
         */
        @Deprecated
        default FacebookEndpointConsumerBuilder checkinUpdate(
                Object checkinUpdate) {
            setProperty("checkinUpdate", checkinUpdate);
            return this;
        }
        /**
         * The checkin to be created. Deprecated, instead create a Post with an
         * attached location.
         * 
         * The option will be converted to a
         * <code>facebook4j.CheckinUpdate</code> type.
         * 
         * Group: common
         */
        @Deprecated
        default FacebookEndpointConsumerBuilder checkinUpdate(
                String checkinUpdate) {
            setProperty("checkinUpdate", checkinUpdate);
            return this;
        }
        /**
         * Facebook4J API client URL.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder clientURL(String clientURL) {
            setProperty("clientURL", clientURL);
            return this;
        }
        /**
         * Facebook4J client API version.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder clientVersion(
                String clientVersion) {
            setProperty("clientVersion", clientVersion);
            return this;
        }
        /**
         * The comment ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder commentId(String commentId) {
            setProperty("commentId", commentId);
            return this;
        }
        /**
         * The facebook Comment to be created or updated.
         * 
         * The option is a: <code>facebook4j.CommentUpdate</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder commentUpdate(
                Object commentUpdate) {
            setProperty("commentUpdate", commentUpdate);
            return this;
        }
        /**
         * The facebook Comment to be created or updated.
         * 
         * The option will be converted to a
         * <code>facebook4j.CommentUpdate</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder commentUpdate(
                String commentUpdate) {
            setProperty("commentUpdate", commentUpdate);
            return this;
        }
        /**
         * Enables deubg output. Effective only with the embedded logger.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder debugEnabled(
                Boolean debugEnabled) {
            setProperty("debugEnabled", debugEnabled);
            return this;
        }
        /**
         * Enables deubg output. Effective only with the embedded logger.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder debugEnabled(String debugEnabled) {
            setProperty("debugEnabled", debugEnabled);
            return this;
        }
        /**
         * The description text.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder description(String description) {
            setProperty("description", description);
            return this;
        }
        /**
         * Distance in meters.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder distance(Integer distance) {
            setProperty("distance", distance);
            return this;
        }
        /**
         * Distance in meters.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder distance(String distance) {
            setProperty("distance", distance);
            return this;
        }
        /**
         * The domain ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder domainId(String domainId) {
            setProperty("domainId", domainId);
            return this;
        }
        /**
         * The domain name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder domainName(String domainName) {
            setProperty("domainName", domainName);
            return this;
        }
        /**
         * The domain names.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder domainNames(
                List<String> domainNames) {
            setProperty("domainNames", domainNames);
            return this;
        }
        /**
         * The domain names.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder domainNames(String domainNames) {
            setProperty("domainNames", domainNames);
            return this;
        }
        /**
         * The event ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder eventId(String eventId) {
            setProperty("eventId", eventId);
            return this;
        }
        /**
         * The event to be created or updated.
         * 
         * The option is a: <code>facebook4j.EventUpdate</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder eventUpdate(Object eventUpdate) {
            setProperty("eventUpdate", eventUpdate);
            return this;
        }
        /**
         * The event to be created or updated.
         * 
         * The option will be converted to a <code>facebook4j.EventUpdate</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder eventUpdate(String eventUpdate) {
            setProperty("eventUpdate", eventUpdate);
            return this;
        }
        /**
         * The friend ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder friendId(String friendId) {
            setProperty("friendId", friendId);
            return this;
        }
        /**
         * The friend list ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder friendlistId(String friendlistId) {
            setProperty("friendlistId", friendlistId);
            return this;
        }
        /**
         * The friend list Name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder friendlistName(
                String friendlistName) {
            setProperty("friendlistName", friendlistName);
            return this;
        }
        /**
         * The friend user ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder friendUserId(String friendUserId) {
            setProperty("friendUserId", friendUserId);
            return this;
        }
        /**
         * The group ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder groupId(String groupId) {
            setProperty("groupId", groupId);
            return this;
        }
        /**
         * Use Facebook GZIP encoding.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder gzipEnabled(Boolean gzipEnabled) {
            setProperty("gzipEnabled", gzipEnabled);
            return this;
        }
        /**
         * Use Facebook GZIP encoding.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder gzipEnabled(String gzipEnabled) {
            setProperty("gzipEnabled", gzipEnabled);
            return this;
        }
        /**
         * Http connection timeout in milliseconds.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder httpConnectionTimeout(
                Integer httpConnectionTimeout) {
            setProperty("httpConnectionTimeout", httpConnectionTimeout);
            return this;
        }
        /**
         * Http connection timeout in milliseconds.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder httpConnectionTimeout(
                String httpConnectionTimeout) {
            setProperty("httpConnectionTimeout", httpConnectionTimeout);
            return this;
        }
        /**
         * HTTP maximum connections per route.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder httpDefaultMaxPerRoute(
                Integer httpDefaultMaxPerRoute) {
            setProperty("httpDefaultMaxPerRoute", httpDefaultMaxPerRoute);
            return this;
        }
        /**
         * HTTP maximum connections per route.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder httpDefaultMaxPerRoute(
                String httpDefaultMaxPerRoute) {
            setProperty("httpDefaultMaxPerRoute", httpDefaultMaxPerRoute);
            return this;
        }
        /**
         * HTTP maximum total connections.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder httpMaxTotalConnections(
                Integer httpMaxTotalConnections) {
            setProperty("httpMaxTotalConnections", httpMaxTotalConnections);
            return this;
        }
        /**
         * HTTP maximum total connections.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder httpMaxTotalConnections(
                String httpMaxTotalConnections) {
            setProperty("httpMaxTotalConnections", httpMaxTotalConnections);
            return this;
        }
        /**
         * Http read timeout in milliseconds.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder httpReadTimeout(
                Integer httpReadTimeout) {
            setProperty("httpReadTimeout", httpReadTimeout);
            return this;
        }
        /**
         * Http read timeout in milliseconds.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder httpReadTimeout(
                String httpReadTimeout) {
            setProperty("httpReadTimeout", httpReadTimeout);
            return this;
        }
        /**
         * Number of HTTP retries.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder httpRetryCount(
                Integer httpRetryCount) {
            setProperty("httpRetryCount", httpRetryCount);
            return this;
        }
        /**
         * Number of HTTP retries.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder httpRetryCount(
                String httpRetryCount) {
            setProperty("httpRetryCount", httpRetryCount);
            return this;
        }
        /**
         * HTTP retry interval in seconds.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder httpRetryIntervalSeconds(
                Integer httpRetryIntervalSeconds) {
            setProperty("httpRetryIntervalSeconds", httpRetryIntervalSeconds);
            return this;
        }
        /**
         * HTTP retry interval in seconds.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder httpRetryIntervalSeconds(
                String httpRetryIntervalSeconds) {
            setProperty("httpRetryIntervalSeconds", httpRetryIntervalSeconds);
            return this;
        }
        /**
         * HTTP streaming read timeout in milliseconds.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder httpStreamingReadTimeout(
                Integer httpStreamingReadTimeout) {
            setProperty("httpStreamingReadTimeout", httpStreamingReadTimeout);
            return this;
        }
        /**
         * HTTP streaming read timeout in milliseconds.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder httpStreamingReadTimeout(
                String httpStreamingReadTimeout) {
            setProperty("httpStreamingReadTimeout", httpStreamingReadTimeout);
            return this;
        }
        /**
         * The ids of users.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder ids(List<String> ids) {
            setProperty("ids", ids);
            return this;
        }
        /**
         * The ids of users.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder ids(String ids) {
            setProperty("ids", ids);
            return this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder inBody(String inBody) {
            setProperty("inBody", inBody);
            return this;
        }
        /**
         * Enables notifications that the user has already read in addition to
         * unread ones.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder includeRead(Boolean includeRead) {
            setProperty("includeRead", includeRead);
            return this;
        }
        /**
         * Enables notifications that the user has already read in addition to
         * unread ones.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder includeRead(String includeRead) {
            setProperty("includeRead", includeRead);
            return this;
        }
        /**
         * Whether hidden.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder isHidden(Boolean isHidden) {
            setProperty("isHidden", isHidden);
            return this;
        }
        /**
         * Whether hidden.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder isHidden(String isHidden) {
            setProperty("isHidden", isHidden);
            return this;
        }
        /**
         * If set to true, raw JSON forms will be stored in DataObjectFactory.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder jsonStoreEnabled(
                Boolean jsonStoreEnabled) {
            setProperty("jsonStoreEnabled", jsonStoreEnabled);
            return this;
        }
        /**
         * If set to true, raw JSON forms will be stored in DataObjectFactory.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder jsonStoreEnabled(
                String jsonStoreEnabled) {
            setProperty("jsonStoreEnabled", jsonStoreEnabled);
            return this;
        }
        /**
         * Link URL.
         * 
         * The option is a: <code>java.net.URL</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder link(URL link) {
            setProperty("link", link);
            return this;
        }
        /**
         * Link URL.
         * 
         * The option will be converted to a <code>java.net.URL</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder link(String link) {
            setProperty("link", link);
            return this;
        }
        /**
         * Link ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder linkId(String linkId) {
            setProperty("linkId", linkId);
            return this;
        }
        /**
         * Desired FQL locale.
         * 
         * The option is a: <code>java.util.Locale</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder locale(Locale locale) {
            setProperty("locale", locale);
            return this;
        }
        /**
         * Desired FQL locale.
         * 
         * The option will be converted to a <code>java.util.Locale</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder locale(String locale) {
            setProperty("locale", locale);
            return this;
        }
        /**
         * If set to true, Facebook4J mbean will be registerd.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder mbeanEnabled(
                Boolean mbeanEnabled) {
            setProperty("mbeanEnabled", mbeanEnabled);
            return this;
        }
        /**
         * If set to true, Facebook4J mbean will be registerd.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder mbeanEnabled(String mbeanEnabled) {
            setProperty("mbeanEnabled", mbeanEnabled);
            return this;
        }
        /**
         * The message text.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder message(String message) {
            setProperty("message", message);
            return this;
        }
        /**
         * The message ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder messageId(String messageId) {
            setProperty("messageId", messageId);
            return this;
        }
        /**
         * The metric name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder metric(String metric) {
            setProperty("metric", metric);
            return this;
        }
        /**
         * The milestone id.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder milestoneId(String milestoneId) {
            setProperty("milestoneId", milestoneId);
            return this;
        }
        /**
         * Test user name, must be of the form 'first last'.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder name(String name) {
            setProperty("name", name);
            return this;
        }
        /**
         * The note ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder noteId(String noteId) {
            setProperty("noteId", noteId);
            return this;
        }
        /**
         * The notification ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder notificationId(
                String notificationId) {
            setProperty("notificationId", notificationId);
            return this;
        }
        /**
         * The insight object ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder objectId(String objectId) {
            setProperty("objectId", objectId);
            return this;
        }
        /**
         * The offer id.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder offerId(String offerId) {
            setProperty("offerId", offerId);
            return this;
        }
        /**
         * The question's answer option description.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder optionDescription(
                String optionDescription) {
            setProperty("optionDescription", optionDescription);
            return this;
        }
        /**
         * The page id.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder pageId(String pageId) {
            setProperty("pageId", pageId);
            return this;
        }
        /**
         * The permission name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder permissionName(
                String permissionName) {
            setProperty("permissionName", permissionName);
            return this;
        }
        /**
         * Test user permissions in the format perm1,perm2,...
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder permissions(String permissions) {
            setProperty("permissions", permissions);
            return this;
        }
        /**
         * The photo ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder photoId(String photoId) {
            setProperty("photoId", photoId);
            return this;
        }
        /**
         * The picture id.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder pictureId(Integer pictureId) {
            setProperty("pictureId", pictureId);
            return this;
        }
        /**
         * The picture id.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder pictureId(String pictureId) {
            setProperty("pictureId", pictureId);
            return this;
        }
        /**
         * The picture2 id.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder pictureId2(Integer pictureId2) {
            setProperty("pictureId2", pictureId2);
            return this;
        }
        /**
         * The picture2 id.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder pictureId2(String pictureId2) {
            setProperty("pictureId2", pictureId2);
            return this;
        }
        /**
         * The picture size.
         * 
         * The option is a: <code>facebook4j.PictureSize</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder pictureSize(
                PictureSize pictureSize) {
            setProperty("pictureSize", pictureSize);
            return this;
        }
        /**
         * The picture size.
         * 
         * The option will be converted to a <code>facebook4j.PictureSize</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder pictureSize(String pictureSize) {
            setProperty("pictureSize", pictureSize);
            return this;
        }
        /**
         * The place ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder placeId(String placeId) {
            setProperty("placeId", placeId);
            return this;
        }
        /**
         * The post ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder postId(String postId) {
            setProperty("postId", postId);
            return this;
        }
        /**
         * The post to create or update.
         * 
         * The option is a: <code>facebook4j.PostUpdate</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder postUpdate(Object postUpdate) {
            setProperty("postUpdate", postUpdate);
            return this;
        }
        /**
         * The post to create or update.
         * 
         * The option will be converted to a <code>facebook4j.PostUpdate</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder postUpdate(String postUpdate) {
            setProperty("postUpdate", postUpdate);
            return this;
        }
        /**
         * Prettify JSON debug output if set to true.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder prettyDebugEnabled(
                Boolean prettyDebugEnabled) {
            setProperty("prettyDebugEnabled", prettyDebugEnabled);
            return this;
        }
        /**
         * Prettify JSON debug output if set to true.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder prettyDebugEnabled(
                String prettyDebugEnabled) {
            setProperty("prettyDebugEnabled", prettyDebugEnabled);
            return this;
        }
        /**
         * FQL queries.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder queries(
                Map<String, String> queries) {
            setProperty("queries", queries);
            return this;
        }
        /**
         * FQL queries.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder queries(String queries) {
            setProperty("queries", queries);
            return this;
        }
        /**
         * FQL query or search terms for search endpoints.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder query(String query) {
            setProperty("query", query);
            return this;
        }
        /**
         * The question id.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder questionId(String questionId) {
            setProperty("questionId", questionId);
            return this;
        }
        /**
         * Optional reading parameters. See Reading Options(#reading).
         * 
         * The option is a: <code>facebook4j.Reading</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder reading(Object reading) {
            setProperty("reading", reading);
            return this;
        }
        /**
         * Optional reading parameters. See Reading Options(#reading).
         * 
         * The option will be converted to a <code>facebook4j.Reading</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder reading(String reading) {
            setProperty("reading", reading);
            return this;
        }
        /**
         * To configure Reading using key/value pairs from the Map.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder readingOptions(
                Map<String, Object> readingOptions) {
            setProperty("readingOptions", readingOptions);
            return this;
        }
        /**
         * To configure Reading using key/value pairs from the Map.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder readingOptions(
                String readingOptions) {
            setProperty("readingOptions", readingOptions);
            return this;
        }
        /**
         * API base URL.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder restBaseURL(String restBaseURL) {
            setProperty("restBaseURL", restBaseURL);
            return this;
        }
        /**
         * The numeric score with value.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder scoreValue(Integer scoreValue) {
            setProperty("scoreValue", scoreValue);
            return this;
        }
        /**
         * The numeric score with value.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder scoreValue(String scoreValue) {
            setProperty("scoreValue", scoreValue);
            return this;
        }
        /**
         * The picture size, one of large, normal, small or square.
         * 
         * The option is a: <code>facebook4j.PictureSize</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder size(PictureSize size) {
            setProperty("size", size);
            return this;
        }
        /**
         * The picture size, one of large, normal, small or square.
         * 
         * The option will be converted to a <code>facebook4j.PictureSize</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder size(String size) {
            setProperty("size", size);
            return this;
        }
        /**
         * The media content from either a java.io.File or java.io.Inputstream.
         * 
         * The option is a: <code>facebook4j.Media</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder source(Object source) {
            setProperty("source", source);
            return this;
        }
        /**
         * The media content from either a java.io.File or java.io.Inputstream.
         * 
         * The option will be converted to a <code>facebook4j.Media</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder source(String source) {
            setProperty("source", source);
            return this;
        }
        /**
         * The note of the subject.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder subject(String subject) {
            setProperty("subject", subject);
            return this;
        }
        /**
         * The tab id.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder tabId(String tabId) {
            setProperty("tabId", tabId);
            return this;
        }
        /**
         * Photo tag information.
         * 
         * The option is a: <code>facebook4j.TagUpdate</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder tagUpdate(Object tagUpdate) {
            setProperty("tagUpdate", tagUpdate);
            return this;
        }
        /**
         * Photo tag information.
         * 
         * The option will be converted to a <code>facebook4j.TagUpdate</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder tagUpdate(String tagUpdate) {
            setProperty("tagUpdate", tagUpdate);
            return this;
        }
        /**
         * Test user 1.
         * 
         * The option is a: <code>facebook4j.TestUser</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder testUser1(Object testUser1) {
            setProperty("testUser1", testUser1);
            return this;
        }
        /**
         * Test user 1.
         * 
         * The option will be converted to a <code>facebook4j.TestUser</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder testUser1(String testUser1) {
            setProperty("testUser1", testUser1);
            return this;
        }
        /**
         * Test user 2.
         * 
         * The option is a: <code>facebook4j.TestUser</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder testUser2(Object testUser2) {
            setProperty("testUser2", testUser2);
            return this;
        }
        /**
         * Test user 2.
         * 
         * The option will be converted to a <code>facebook4j.TestUser</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder testUser2(String testUser2) {
            setProperty("testUser2", testUser2);
            return this;
        }
        /**
         * The ID of the test user.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder testUserId(String testUserId) {
            setProperty("testUserId", testUserId);
            return this;
        }
        /**
         * The title text.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder title(String title) {
            setProperty("title", title);
            return this;
        }
        /**
         * The ID of the user to tag.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder toUserId(String toUserId) {
            setProperty("toUserId", toUserId);
            return this;
        }
        /**
         * The IDs of the users to tag.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder toUserIds(List<String> toUserIds) {
            setProperty("toUserIds", toUserIds);
            return this;
        }
        /**
         * The IDs of the users to tag.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder toUserIds(String toUserIds) {
            setProperty("toUserIds", toUserIds);
            return this;
        }
        /**
         * The Facebook user ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder userId(String userId) {
            setProperty("userId", userId);
            return this;
        }
        /**
         * The ID of a user 1.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder userId1(String userId1) {
            setProperty("userId1", userId1);
            return this;
        }
        /**
         * The ID of a user 2.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder userId2(String userId2) {
            setProperty("userId2", userId2);
            return this;
        }
        /**
         * The IDs of users to invite to event.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder userIds(List<String> userIds) {
            setProperty("userIds", userIds);
            return this;
        }
        /**
         * The IDs of users to invite to event.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder userIds(String userIds) {
            setProperty("userIds", userIds);
            return this;
        }
        /**
         * The test user locale.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder userLocale(String userLocale) {
            setProperty("userLocale", userLocale);
            return this;
        }
        /**
         * Use SSL.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder useSSL(Boolean useSSL) {
            setProperty("useSSL", useSSL);
            return this;
        }
        /**
         * Use SSL.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder useSSL(String useSSL) {
            setProperty("useSSL", useSSL);
            return this;
        }
        /**
         * Video API base URL.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder videoBaseURL(String videoBaseURL) {
            setProperty("videoBaseURL", videoBaseURL);
            return this;
        }
        /**
         * The video ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointConsumerBuilder videoId(String videoId) {
            setProperty("videoId", videoId);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default FacebookEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            setProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default FacebookEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            setProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * HTTP proxy server host name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default FacebookEndpointConsumerBuilder httpProxyHost(
                String httpProxyHost) {
            setProperty("httpProxyHost", httpProxyHost);
            return this;
        }
        /**
         * HTTP proxy server password.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default FacebookEndpointConsumerBuilder httpProxyPassword(
                String httpProxyPassword) {
            setProperty("httpProxyPassword", httpProxyPassword);
            return this;
        }
        /**
         * HTTP proxy server port.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: proxy
         */
        default FacebookEndpointConsumerBuilder httpProxyPort(
                Integer httpProxyPort) {
            setProperty("httpProxyPort", httpProxyPort);
            return this;
        }
        /**
         * HTTP proxy server port.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: proxy
         */
        default FacebookEndpointConsumerBuilder httpProxyPort(
                String httpProxyPort) {
            setProperty("httpProxyPort", httpProxyPort);
            return this;
        }
        /**
         * HTTP proxy server user name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default FacebookEndpointConsumerBuilder httpProxyUser(
                String httpProxyUser) {
            setProperty("httpProxyUser", httpProxyUser);
            return this;
        }
        /**
         * The user access token.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FacebookEndpointConsumerBuilder oAuthAccessToken(
                String oAuthAccessToken) {
            setProperty("oAuthAccessToken", oAuthAccessToken);
            return this;
        }
        /**
         * OAuth access token URL.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FacebookEndpointConsumerBuilder oAuthAccessTokenURL(
                String oAuthAccessTokenURL) {
            setProperty("oAuthAccessTokenURL", oAuthAccessTokenURL);
            return this;
        }
        /**
         * The application Id.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FacebookEndpointConsumerBuilder oAuthAppId(String oAuthAppId) {
            setProperty("oAuthAppId", oAuthAppId);
            return this;
        }
        /**
         * The application Secret.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FacebookEndpointConsumerBuilder oAuthAppSecret(
                String oAuthAppSecret) {
            setProperty("oAuthAppSecret", oAuthAppSecret);
            return this;
        }
        /**
         * OAuth authorization URL.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FacebookEndpointConsumerBuilder oAuthAuthorizationURL(
                String oAuthAuthorizationURL) {
            setProperty("oAuthAuthorizationURL", oAuthAuthorizationURL);
            return this;
        }
        /**
         * Default OAuth permissions. Comma separated permission names. See
         * https://developers.facebook.com/docs/reference/login/#permissions for
         * the detail.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FacebookEndpointConsumerBuilder oAuthPermissions(
                String oAuthPermissions) {
            setProperty("oAuthPermissions", oAuthPermissions);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Facebook component.
     */
    public interface AdvancedFacebookEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default FacebookEndpointConsumerBuilder basic() {
            return (FacebookEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedFacebookEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            setProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedFacebookEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            setProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedFacebookEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            setProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedFacebookEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            setProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFacebookEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFacebookEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFacebookEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFacebookEndpointConsumerBuilder synchronous(
                String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Facebook component.
     */
    public interface FacebookEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedFacebookEndpointProducerBuilder advanced() {
            return (AdvancedFacebookEndpointProducerBuilder) this;
        }
        /**
         * The unique URL of the achievement.
         * 
         * The option is a: <code>java.net.URL</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder achievementURL(
                URL achievementURL) {
            setProperty("achievementURL", achievementURL);
            return this;
        }
        /**
         * The unique URL of the achievement.
         * 
         * The option will be converted to a <code>java.net.URL</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder achievementURL(
                String achievementURL) {
            setProperty("achievementURL", achievementURL);
            return this;
        }
        /**
         * The album ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder albumId(String albumId) {
            setProperty("albumId", albumId);
            return this;
        }
        /**
         * The facebook Album to be created or updated.
         * 
         * The option is a: <code>facebook4j.AlbumUpdate</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder albumUpdate(Object albumUpdate) {
            setProperty("albumUpdate", albumUpdate);
            return this;
        }
        /**
         * The facebook Album to be created or updated.
         * 
         * The option will be converted to a <code>facebook4j.AlbumUpdate</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder albumUpdate(String albumUpdate) {
            setProperty("albumUpdate", albumUpdate);
            return this;
        }
        /**
         * The ID of the Facebook Application.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder appId(String appId) {
            setProperty("appId", appId);
            return this;
        }
        /**
         * Location latitude and longitude.
         * 
         * The option is a: <code>facebook4j.GeoLocation</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder center(Object center) {
            setProperty("center", center);
            return this;
        }
        /**
         * Location latitude and longitude.
         * 
         * The option will be converted to a <code>facebook4j.GeoLocation</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder center(String center) {
            setProperty("center", center);
            return this;
        }
        /**
         * The checkin ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder checkinId(String checkinId) {
            setProperty("checkinId", checkinId);
            return this;
        }
        /**
         * The checkin to be created. Deprecated, instead create a Post with an
         * attached location.
         * 
         * The option is a: <code>facebook4j.CheckinUpdate</code> type.
         * 
         * Group: common
         */
        @Deprecated
        default FacebookEndpointProducerBuilder checkinUpdate(
                Object checkinUpdate) {
            setProperty("checkinUpdate", checkinUpdate);
            return this;
        }
        /**
         * The checkin to be created. Deprecated, instead create a Post with an
         * attached location.
         * 
         * The option will be converted to a
         * <code>facebook4j.CheckinUpdate</code> type.
         * 
         * Group: common
         */
        @Deprecated
        default FacebookEndpointProducerBuilder checkinUpdate(
                String checkinUpdate) {
            setProperty("checkinUpdate", checkinUpdate);
            return this;
        }
        /**
         * Facebook4J API client URL.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder clientURL(String clientURL) {
            setProperty("clientURL", clientURL);
            return this;
        }
        /**
         * Facebook4J client API version.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder clientVersion(
                String clientVersion) {
            setProperty("clientVersion", clientVersion);
            return this;
        }
        /**
         * The comment ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder commentId(String commentId) {
            setProperty("commentId", commentId);
            return this;
        }
        /**
         * The facebook Comment to be created or updated.
         * 
         * The option is a: <code>facebook4j.CommentUpdate</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder commentUpdate(
                Object commentUpdate) {
            setProperty("commentUpdate", commentUpdate);
            return this;
        }
        /**
         * The facebook Comment to be created or updated.
         * 
         * The option will be converted to a
         * <code>facebook4j.CommentUpdate</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder commentUpdate(
                String commentUpdate) {
            setProperty("commentUpdate", commentUpdate);
            return this;
        }
        /**
         * Enables deubg output. Effective only with the embedded logger.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder debugEnabled(
                Boolean debugEnabled) {
            setProperty("debugEnabled", debugEnabled);
            return this;
        }
        /**
         * Enables deubg output. Effective only with the embedded logger.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder debugEnabled(String debugEnabled) {
            setProperty("debugEnabled", debugEnabled);
            return this;
        }
        /**
         * The description text.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder description(String description) {
            setProperty("description", description);
            return this;
        }
        /**
         * Distance in meters.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder distance(Integer distance) {
            setProperty("distance", distance);
            return this;
        }
        /**
         * Distance in meters.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder distance(String distance) {
            setProperty("distance", distance);
            return this;
        }
        /**
         * The domain ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder domainId(String domainId) {
            setProperty("domainId", domainId);
            return this;
        }
        /**
         * The domain name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder domainName(String domainName) {
            setProperty("domainName", domainName);
            return this;
        }
        /**
         * The domain names.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder domainNames(
                List<String> domainNames) {
            setProperty("domainNames", domainNames);
            return this;
        }
        /**
         * The domain names.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder domainNames(String domainNames) {
            setProperty("domainNames", domainNames);
            return this;
        }
        /**
         * The event ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder eventId(String eventId) {
            setProperty("eventId", eventId);
            return this;
        }
        /**
         * The event to be created or updated.
         * 
         * The option is a: <code>facebook4j.EventUpdate</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder eventUpdate(Object eventUpdate) {
            setProperty("eventUpdate", eventUpdate);
            return this;
        }
        /**
         * The event to be created or updated.
         * 
         * The option will be converted to a <code>facebook4j.EventUpdate</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder eventUpdate(String eventUpdate) {
            setProperty("eventUpdate", eventUpdate);
            return this;
        }
        /**
         * The friend ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder friendId(String friendId) {
            setProperty("friendId", friendId);
            return this;
        }
        /**
         * The friend list ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder friendlistId(String friendlistId) {
            setProperty("friendlistId", friendlistId);
            return this;
        }
        /**
         * The friend list Name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder friendlistName(
                String friendlistName) {
            setProperty("friendlistName", friendlistName);
            return this;
        }
        /**
         * The friend user ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder friendUserId(String friendUserId) {
            setProperty("friendUserId", friendUserId);
            return this;
        }
        /**
         * The group ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder groupId(String groupId) {
            setProperty("groupId", groupId);
            return this;
        }
        /**
         * Use Facebook GZIP encoding.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder gzipEnabled(Boolean gzipEnabled) {
            setProperty("gzipEnabled", gzipEnabled);
            return this;
        }
        /**
         * Use Facebook GZIP encoding.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder gzipEnabled(String gzipEnabled) {
            setProperty("gzipEnabled", gzipEnabled);
            return this;
        }
        /**
         * Http connection timeout in milliseconds.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder httpConnectionTimeout(
                Integer httpConnectionTimeout) {
            setProperty("httpConnectionTimeout", httpConnectionTimeout);
            return this;
        }
        /**
         * Http connection timeout in milliseconds.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder httpConnectionTimeout(
                String httpConnectionTimeout) {
            setProperty("httpConnectionTimeout", httpConnectionTimeout);
            return this;
        }
        /**
         * HTTP maximum connections per route.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder httpDefaultMaxPerRoute(
                Integer httpDefaultMaxPerRoute) {
            setProperty("httpDefaultMaxPerRoute", httpDefaultMaxPerRoute);
            return this;
        }
        /**
         * HTTP maximum connections per route.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder httpDefaultMaxPerRoute(
                String httpDefaultMaxPerRoute) {
            setProperty("httpDefaultMaxPerRoute", httpDefaultMaxPerRoute);
            return this;
        }
        /**
         * HTTP maximum total connections.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder httpMaxTotalConnections(
                Integer httpMaxTotalConnections) {
            setProperty("httpMaxTotalConnections", httpMaxTotalConnections);
            return this;
        }
        /**
         * HTTP maximum total connections.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder httpMaxTotalConnections(
                String httpMaxTotalConnections) {
            setProperty("httpMaxTotalConnections", httpMaxTotalConnections);
            return this;
        }
        /**
         * Http read timeout in milliseconds.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder httpReadTimeout(
                Integer httpReadTimeout) {
            setProperty("httpReadTimeout", httpReadTimeout);
            return this;
        }
        /**
         * Http read timeout in milliseconds.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder httpReadTimeout(
                String httpReadTimeout) {
            setProperty("httpReadTimeout", httpReadTimeout);
            return this;
        }
        /**
         * Number of HTTP retries.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder httpRetryCount(
                Integer httpRetryCount) {
            setProperty("httpRetryCount", httpRetryCount);
            return this;
        }
        /**
         * Number of HTTP retries.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder httpRetryCount(
                String httpRetryCount) {
            setProperty("httpRetryCount", httpRetryCount);
            return this;
        }
        /**
         * HTTP retry interval in seconds.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder httpRetryIntervalSeconds(
                Integer httpRetryIntervalSeconds) {
            setProperty("httpRetryIntervalSeconds", httpRetryIntervalSeconds);
            return this;
        }
        /**
         * HTTP retry interval in seconds.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder httpRetryIntervalSeconds(
                String httpRetryIntervalSeconds) {
            setProperty("httpRetryIntervalSeconds", httpRetryIntervalSeconds);
            return this;
        }
        /**
         * HTTP streaming read timeout in milliseconds.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder httpStreamingReadTimeout(
                Integer httpStreamingReadTimeout) {
            setProperty("httpStreamingReadTimeout", httpStreamingReadTimeout);
            return this;
        }
        /**
         * HTTP streaming read timeout in milliseconds.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder httpStreamingReadTimeout(
                String httpStreamingReadTimeout) {
            setProperty("httpStreamingReadTimeout", httpStreamingReadTimeout);
            return this;
        }
        /**
         * The ids of users.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder ids(List<String> ids) {
            setProperty("ids", ids);
            return this;
        }
        /**
         * The ids of users.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder ids(String ids) {
            setProperty("ids", ids);
            return this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder inBody(String inBody) {
            setProperty("inBody", inBody);
            return this;
        }
        /**
         * Enables notifications that the user has already read in addition to
         * unread ones.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder includeRead(Boolean includeRead) {
            setProperty("includeRead", includeRead);
            return this;
        }
        /**
         * Enables notifications that the user has already read in addition to
         * unread ones.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder includeRead(String includeRead) {
            setProperty("includeRead", includeRead);
            return this;
        }
        /**
         * Whether hidden.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder isHidden(Boolean isHidden) {
            setProperty("isHidden", isHidden);
            return this;
        }
        /**
         * Whether hidden.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder isHidden(String isHidden) {
            setProperty("isHidden", isHidden);
            return this;
        }
        /**
         * If set to true, raw JSON forms will be stored in DataObjectFactory.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder jsonStoreEnabled(
                Boolean jsonStoreEnabled) {
            setProperty("jsonStoreEnabled", jsonStoreEnabled);
            return this;
        }
        /**
         * If set to true, raw JSON forms will be stored in DataObjectFactory.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder jsonStoreEnabled(
                String jsonStoreEnabled) {
            setProperty("jsonStoreEnabled", jsonStoreEnabled);
            return this;
        }
        /**
         * Link URL.
         * 
         * The option is a: <code>java.net.URL</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder link(URL link) {
            setProperty("link", link);
            return this;
        }
        /**
         * Link URL.
         * 
         * The option will be converted to a <code>java.net.URL</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder link(String link) {
            setProperty("link", link);
            return this;
        }
        /**
         * Link ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder linkId(String linkId) {
            setProperty("linkId", linkId);
            return this;
        }
        /**
         * Desired FQL locale.
         * 
         * The option is a: <code>java.util.Locale</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder locale(Locale locale) {
            setProperty("locale", locale);
            return this;
        }
        /**
         * Desired FQL locale.
         * 
         * The option will be converted to a <code>java.util.Locale</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder locale(String locale) {
            setProperty("locale", locale);
            return this;
        }
        /**
         * If set to true, Facebook4J mbean will be registerd.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder mbeanEnabled(
                Boolean mbeanEnabled) {
            setProperty("mbeanEnabled", mbeanEnabled);
            return this;
        }
        /**
         * If set to true, Facebook4J mbean will be registerd.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder mbeanEnabled(String mbeanEnabled) {
            setProperty("mbeanEnabled", mbeanEnabled);
            return this;
        }
        /**
         * The message text.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder message(String message) {
            setProperty("message", message);
            return this;
        }
        /**
         * The message ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder messageId(String messageId) {
            setProperty("messageId", messageId);
            return this;
        }
        /**
         * The metric name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder metric(String metric) {
            setProperty("metric", metric);
            return this;
        }
        /**
         * The milestone id.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder milestoneId(String milestoneId) {
            setProperty("milestoneId", milestoneId);
            return this;
        }
        /**
         * Test user name, must be of the form 'first last'.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder name(String name) {
            setProperty("name", name);
            return this;
        }
        /**
         * The note ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder noteId(String noteId) {
            setProperty("noteId", noteId);
            return this;
        }
        /**
         * The notification ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder notificationId(
                String notificationId) {
            setProperty("notificationId", notificationId);
            return this;
        }
        /**
         * The insight object ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder objectId(String objectId) {
            setProperty("objectId", objectId);
            return this;
        }
        /**
         * The offer id.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder offerId(String offerId) {
            setProperty("offerId", offerId);
            return this;
        }
        /**
         * The question's answer option description.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder optionDescription(
                String optionDescription) {
            setProperty("optionDescription", optionDescription);
            return this;
        }
        /**
         * The page id.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder pageId(String pageId) {
            setProperty("pageId", pageId);
            return this;
        }
        /**
         * The permission name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder permissionName(
                String permissionName) {
            setProperty("permissionName", permissionName);
            return this;
        }
        /**
         * Test user permissions in the format perm1,perm2,...
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder permissions(String permissions) {
            setProperty("permissions", permissions);
            return this;
        }
        /**
         * The photo ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder photoId(String photoId) {
            setProperty("photoId", photoId);
            return this;
        }
        /**
         * The picture id.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder pictureId(Integer pictureId) {
            setProperty("pictureId", pictureId);
            return this;
        }
        /**
         * The picture id.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder pictureId(String pictureId) {
            setProperty("pictureId", pictureId);
            return this;
        }
        /**
         * The picture2 id.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder pictureId2(Integer pictureId2) {
            setProperty("pictureId2", pictureId2);
            return this;
        }
        /**
         * The picture2 id.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder pictureId2(String pictureId2) {
            setProperty("pictureId2", pictureId2);
            return this;
        }
        /**
         * The picture size.
         * 
         * The option is a: <code>facebook4j.PictureSize</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder pictureSize(
                PictureSize pictureSize) {
            setProperty("pictureSize", pictureSize);
            return this;
        }
        /**
         * The picture size.
         * 
         * The option will be converted to a <code>facebook4j.PictureSize</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder pictureSize(String pictureSize) {
            setProperty("pictureSize", pictureSize);
            return this;
        }
        /**
         * The place ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder placeId(String placeId) {
            setProperty("placeId", placeId);
            return this;
        }
        /**
         * The post ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder postId(String postId) {
            setProperty("postId", postId);
            return this;
        }
        /**
         * The post to create or update.
         * 
         * The option is a: <code>facebook4j.PostUpdate</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder postUpdate(Object postUpdate) {
            setProperty("postUpdate", postUpdate);
            return this;
        }
        /**
         * The post to create or update.
         * 
         * The option will be converted to a <code>facebook4j.PostUpdate</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder postUpdate(String postUpdate) {
            setProperty("postUpdate", postUpdate);
            return this;
        }
        /**
         * Prettify JSON debug output if set to true.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder prettyDebugEnabled(
                Boolean prettyDebugEnabled) {
            setProperty("prettyDebugEnabled", prettyDebugEnabled);
            return this;
        }
        /**
         * Prettify JSON debug output if set to true.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder prettyDebugEnabled(
                String prettyDebugEnabled) {
            setProperty("prettyDebugEnabled", prettyDebugEnabled);
            return this;
        }
        /**
         * FQL queries.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder queries(
                Map<String, String> queries) {
            setProperty("queries", queries);
            return this;
        }
        /**
         * FQL queries.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder queries(String queries) {
            setProperty("queries", queries);
            return this;
        }
        /**
         * FQL query or search terms for search endpoints.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder query(String query) {
            setProperty("query", query);
            return this;
        }
        /**
         * The question id.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder questionId(String questionId) {
            setProperty("questionId", questionId);
            return this;
        }
        /**
         * Optional reading parameters. See Reading Options(#reading).
         * 
         * The option is a: <code>facebook4j.Reading</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder reading(Object reading) {
            setProperty("reading", reading);
            return this;
        }
        /**
         * Optional reading parameters. See Reading Options(#reading).
         * 
         * The option will be converted to a <code>facebook4j.Reading</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder reading(String reading) {
            setProperty("reading", reading);
            return this;
        }
        /**
         * To configure Reading using key/value pairs from the Map.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder readingOptions(
                Map<String, Object> readingOptions) {
            setProperty("readingOptions", readingOptions);
            return this;
        }
        /**
         * To configure Reading using key/value pairs from the Map.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder readingOptions(
                String readingOptions) {
            setProperty("readingOptions", readingOptions);
            return this;
        }
        /**
         * API base URL.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder restBaseURL(String restBaseURL) {
            setProperty("restBaseURL", restBaseURL);
            return this;
        }
        /**
         * The numeric score with value.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder scoreValue(Integer scoreValue) {
            setProperty("scoreValue", scoreValue);
            return this;
        }
        /**
         * The numeric score with value.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder scoreValue(String scoreValue) {
            setProperty("scoreValue", scoreValue);
            return this;
        }
        /**
         * The picture size, one of large, normal, small or square.
         * 
         * The option is a: <code>facebook4j.PictureSize</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder size(PictureSize size) {
            setProperty("size", size);
            return this;
        }
        /**
         * The picture size, one of large, normal, small or square.
         * 
         * The option will be converted to a <code>facebook4j.PictureSize</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder size(String size) {
            setProperty("size", size);
            return this;
        }
        /**
         * The media content from either a java.io.File or java.io.Inputstream.
         * 
         * The option is a: <code>facebook4j.Media</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder source(Object source) {
            setProperty("source", source);
            return this;
        }
        /**
         * The media content from either a java.io.File or java.io.Inputstream.
         * 
         * The option will be converted to a <code>facebook4j.Media</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder source(String source) {
            setProperty("source", source);
            return this;
        }
        /**
         * The note of the subject.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder subject(String subject) {
            setProperty("subject", subject);
            return this;
        }
        /**
         * The tab id.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder tabId(String tabId) {
            setProperty("tabId", tabId);
            return this;
        }
        /**
         * Photo tag information.
         * 
         * The option is a: <code>facebook4j.TagUpdate</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder tagUpdate(Object tagUpdate) {
            setProperty("tagUpdate", tagUpdate);
            return this;
        }
        /**
         * Photo tag information.
         * 
         * The option will be converted to a <code>facebook4j.TagUpdate</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder tagUpdate(String tagUpdate) {
            setProperty("tagUpdate", tagUpdate);
            return this;
        }
        /**
         * Test user 1.
         * 
         * The option is a: <code>facebook4j.TestUser</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder testUser1(Object testUser1) {
            setProperty("testUser1", testUser1);
            return this;
        }
        /**
         * Test user 1.
         * 
         * The option will be converted to a <code>facebook4j.TestUser</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder testUser1(String testUser1) {
            setProperty("testUser1", testUser1);
            return this;
        }
        /**
         * Test user 2.
         * 
         * The option is a: <code>facebook4j.TestUser</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder testUser2(Object testUser2) {
            setProperty("testUser2", testUser2);
            return this;
        }
        /**
         * Test user 2.
         * 
         * The option will be converted to a <code>facebook4j.TestUser</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder testUser2(String testUser2) {
            setProperty("testUser2", testUser2);
            return this;
        }
        /**
         * The ID of the test user.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder testUserId(String testUserId) {
            setProperty("testUserId", testUserId);
            return this;
        }
        /**
         * The title text.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder title(String title) {
            setProperty("title", title);
            return this;
        }
        /**
         * The ID of the user to tag.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder toUserId(String toUserId) {
            setProperty("toUserId", toUserId);
            return this;
        }
        /**
         * The IDs of the users to tag.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder toUserIds(List<String> toUserIds) {
            setProperty("toUserIds", toUserIds);
            return this;
        }
        /**
         * The IDs of the users to tag.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder toUserIds(String toUserIds) {
            setProperty("toUserIds", toUserIds);
            return this;
        }
        /**
         * The Facebook user ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder userId(String userId) {
            setProperty("userId", userId);
            return this;
        }
        /**
         * The ID of a user 1.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder userId1(String userId1) {
            setProperty("userId1", userId1);
            return this;
        }
        /**
         * The ID of a user 2.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder userId2(String userId2) {
            setProperty("userId2", userId2);
            return this;
        }
        /**
         * The IDs of users to invite to event.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder userIds(List<String> userIds) {
            setProperty("userIds", userIds);
            return this;
        }
        /**
         * The IDs of users to invite to event.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder userIds(String userIds) {
            setProperty("userIds", userIds);
            return this;
        }
        /**
         * The test user locale.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder userLocale(String userLocale) {
            setProperty("userLocale", userLocale);
            return this;
        }
        /**
         * Use SSL.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder useSSL(Boolean useSSL) {
            setProperty("useSSL", useSSL);
            return this;
        }
        /**
         * Use SSL.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder useSSL(String useSSL) {
            setProperty("useSSL", useSSL);
            return this;
        }
        /**
         * Video API base URL.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder videoBaseURL(String videoBaseURL) {
            setProperty("videoBaseURL", videoBaseURL);
            return this;
        }
        /**
         * The video ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointProducerBuilder videoId(String videoId) {
            setProperty("videoId", videoId);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default FacebookEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            setProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default FacebookEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            setProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * HTTP proxy server host name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default FacebookEndpointProducerBuilder httpProxyHost(
                String httpProxyHost) {
            setProperty("httpProxyHost", httpProxyHost);
            return this;
        }
        /**
         * HTTP proxy server password.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default FacebookEndpointProducerBuilder httpProxyPassword(
                String httpProxyPassword) {
            setProperty("httpProxyPassword", httpProxyPassword);
            return this;
        }
        /**
         * HTTP proxy server port.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: proxy
         */
        default FacebookEndpointProducerBuilder httpProxyPort(
                Integer httpProxyPort) {
            setProperty("httpProxyPort", httpProxyPort);
            return this;
        }
        /**
         * HTTP proxy server port.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: proxy
         */
        default FacebookEndpointProducerBuilder httpProxyPort(
                String httpProxyPort) {
            setProperty("httpProxyPort", httpProxyPort);
            return this;
        }
        /**
         * HTTP proxy server user name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default FacebookEndpointProducerBuilder httpProxyUser(
                String httpProxyUser) {
            setProperty("httpProxyUser", httpProxyUser);
            return this;
        }
        /**
         * The user access token.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FacebookEndpointProducerBuilder oAuthAccessToken(
                String oAuthAccessToken) {
            setProperty("oAuthAccessToken", oAuthAccessToken);
            return this;
        }
        /**
         * OAuth access token URL.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FacebookEndpointProducerBuilder oAuthAccessTokenURL(
                String oAuthAccessTokenURL) {
            setProperty("oAuthAccessTokenURL", oAuthAccessTokenURL);
            return this;
        }
        /**
         * The application Id.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FacebookEndpointProducerBuilder oAuthAppId(String oAuthAppId) {
            setProperty("oAuthAppId", oAuthAppId);
            return this;
        }
        /**
         * The application Secret.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FacebookEndpointProducerBuilder oAuthAppSecret(
                String oAuthAppSecret) {
            setProperty("oAuthAppSecret", oAuthAppSecret);
            return this;
        }
        /**
         * OAuth authorization URL.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FacebookEndpointProducerBuilder oAuthAuthorizationURL(
                String oAuthAuthorizationURL) {
            setProperty("oAuthAuthorizationURL", oAuthAuthorizationURL);
            return this;
        }
        /**
         * Default OAuth permissions. Comma separated permission names. See
         * https://developers.facebook.com/docs/reference/login/#permissions for
         * the detail.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FacebookEndpointProducerBuilder oAuthPermissions(
                String oAuthPermissions) {
            setProperty("oAuthPermissions", oAuthPermissions);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Facebook component.
     */
    public interface AdvancedFacebookEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default FacebookEndpointProducerBuilder basic() {
            return (FacebookEndpointProducerBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFacebookEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFacebookEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFacebookEndpointProducerBuilder synchronous(
                boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFacebookEndpointProducerBuilder synchronous(
                String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Facebook component.
     */
    public interface FacebookEndpointBuilder
            extends
                FacebookEndpointConsumerBuilder, FacebookEndpointProducerBuilder {
        default AdvancedFacebookEndpointBuilder advanced() {
            return (AdvancedFacebookEndpointBuilder) this;
        }
        /**
         * The unique URL of the achievement.
         * 
         * The option is a: <code>java.net.URL</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder achievementURL(URL achievementURL) {
            setProperty("achievementURL", achievementURL);
            return this;
        }
        /**
         * The unique URL of the achievement.
         * 
         * The option will be converted to a <code>java.net.URL</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder achievementURL(String achievementURL) {
            setProperty("achievementURL", achievementURL);
            return this;
        }
        /**
         * The album ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder albumId(String albumId) {
            setProperty("albumId", albumId);
            return this;
        }
        /**
         * The facebook Album to be created or updated.
         * 
         * The option is a: <code>facebook4j.AlbumUpdate</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder albumUpdate(Object albumUpdate) {
            setProperty("albumUpdate", albumUpdate);
            return this;
        }
        /**
         * The facebook Album to be created or updated.
         * 
         * The option will be converted to a <code>facebook4j.AlbumUpdate</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder albumUpdate(String albumUpdate) {
            setProperty("albumUpdate", albumUpdate);
            return this;
        }
        /**
         * The ID of the Facebook Application.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder appId(String appId) {
            setProperty("appId", appId);
            return this;
        }
        /**
         * Location latitude and longitude.
         * 
         * The option is a: <code>facebook4j.GeoLocation</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder center(Object center) {
            setProperty("center", center);
            return this;
        }
        /**
         * Location latitude and longitude.
         * 
         * The option will be converted to a <code>facebook4j.GeoLocation</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder center(String center) {
            setProperty("center", center);
            return this;
        }
        /**
         * The checkin ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder checkinId(String checkinId) {
            setProperty("checkinId", checkinId);
            return this;
        }
        /**
         * The checkin to be created. Deprecated, instead create a Post with an
         * attached location.
         * 
         * The option is a: <code>facebook4j.CheckinUpdate</code> type.
         * 
         * Group: common
         */
        @Deprecated
        default FacebookEndpointBuilder checkinUpdate(Object checkinUpdate) {
            setProperty("checkinUpdate", checkinUpdate);
            return this;
        }
        /**
         * The checkin to be created. Deprecated, instead create a Post with an
         * attached location.
         * 
         * The option will be converted to a
         * <code>facebook4j.CheckinUpdate</code> type.
         * 
         * Group: common
         */
        @Deprecated
        default FacebookEndpointBuilder checkinUpdate(String checkinUpdate) {
            setProperty("checkinUpdate", checkinUpdate);
            return this;
        }
        /**
         * Facebook4J API client URL.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder clientURL(String clientURL) {
            setProperty("clientURL", clientURL);
            return this;
        }
        /**
         * Facebook4J client API version.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder clientVersion(String clientVersion) {
            setProperty("clientVersion", clientVersion);
            return this;
        }
        /**
         * The comment ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder commentId(String commentId) {
            setProperty("commentId", commentId);
            return this;
        }
        /**
         * The facebook Comment to be created or updated.
         * 
         * The option is a: <code>facebook4j.CommentUpdate</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder commentUpdate(Object commentUpdate) {
            setProperty("commentUpdate", commentUpdate);
            return this;
        }
        /**
         * The facebook Comment to be created or updated.
         * 
         * The option will be converted to a
         * <code>facebook4j.CommentUpdate</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder commentUpdate(String commentUpdate) {
            setProperty("commentUpdate", commentUpdate);
            return this;
        }
        /**
         * Enables deubg output. Effective only with the embedded logger.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder debugEnabled(Boolean debugEnabled) {
            setProperty("debugEnabled", debugEnabled);
            return this;
        }
        /**
         * Enables deubg output. Effective only with the embedded logger.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder debugEnabled(String debugEnabled) {
            setProperty("debugEnabled", debugEnabled);
            return this;
        }
        /**
         * The description text.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder description(String description) {
            setProperty("description", description);
            return this;
        }
        /**
         * Distance in meters.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder distance(Integer distance) {
            setProperty("distance", distance);
            return this;
        }
        /**
         * Distance in meters.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder distance(String distance) {
            setProperty("distance", distance);
            return this;
        }
        /**
         * The domain ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder domainId(String domainId) {
            setProperty("domainId", domainId);
            return this;
        }
        /**
         * The domain name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder domainName(String domainName) {
            setProperty("domainName", domainName);
            return this;
        }
        /**
         * The domain names.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder domainNames(List<String> domainNames) {
            setProperty("domainNames", domainNames);
            return this;
        }
        /**
         * The domain names.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder domainNames(String domainNames) {
            setProperty("domainNames", domainNames);
            return this;
        }
        /**
         * The event ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder eventId(String eventId) {
            setProperty("eventId", eventId);
            return this;
        }
        /**
         * The event to be created or updated.
         * 
         * The option is a: <code>facebook4j.EventUpdate</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder eventUpdate(Object eventUpdate) {
            setProperty("eventUpdate", eventUpdate);
            return this;
        }
        /**
         * The event to be created or updated.
         * 
         * The option will be converted to a <code>facebook4j.EventUpdate</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder eventUpdate(String eventUpdate) {
            setProperty("eventUpdate", eventUpdate);
            return this;
        }
        /**
         * The friend ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder friendId(String friendId) {
            setProperty("friendId", friendId);
            return this;
        }
        /**
         * The friend list ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder friendlistId(String friendlistId) {
            setProperty("friendlistId", friendlistId);
            return this;
        }
        /**
         * The friend list Name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder friendlistName(String friendlistName) {
            setProperty("friendlistName", friendlistName);
            return this;
        }
        /**
         * The friend user ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder friendUserId(String friendUserId) {
            setProperty("friendUserId", friendUserId);
            return this;
        }
        /**
         * The group ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder groupId(String groupId) {
            setProperty("groupId", groupId);
            return this;
        }
        /**
         * Use Facebook GZIP encoding.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder gzipEnabled(Boolean gzipEnabled) {
            setProperty("gzipEnabled", gzipEnabled);
            return this;
        }
        /**
         * Use Facebook GZIP encoding.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder gzipEnabled(String gzipEnabled) {
            setProperty("gzipEnabled", gzipEnabled);
            return this;
        }
        /**
         * Http connection timeout in milliseconds.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder httpConnectionTimeout(
                Integer httpConnectionTimeout) {
            setProperty("httpConnectionTimeout", httpConnectionTimeout);
            return this;
        }
        /**
         * Http connection timeout in milliseconds.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder httpConnectionTimeout(
                String httpConnectionTimeout) {
            setProperty("httpConnectionTimeout", httpConnectionTimeout);
            return this;
        }
        /**
         * HTTP maximum connections per route.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder httpDefaultMaxPerRoute(
                Integer httpDefaultMaxPerRoute) {
            setProperty("httpDefaultMaxPerRoute", httpDefaultMaxPerRoute);
            return this;
        }
        /**
         * HTTP maximum connections per route.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder httpDefaultMaxPerRoute(
                String httpDefaultMaxPerRoute) {
            setProperty("httpDefaultMaxPerRoute", httpDefaultMaxPerRoute);
            return this;
        }
        /**
         * HTTP maximum total connections.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder httpMaxTotalConnections(
                Integer httpMaxTotalConnections) {
            setProperty("httpMaxTotalConnections", httpMaxTotalConnections);
            return this;
        }
        /**
         * HTTP maximum total connections.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder httpMaxTotalConnections(
                String httpMaxTotalConnections) {
            setProperty("httpMaxTotalConnections", httpMaxTotalConnections);
            return this;
        }
        /**
         * Http read timeout in milliseconds.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder httpReadTimeout(Integer httpReadTimeout) {
            setProperty("httpReadTimeout", httpReadTimeout);
            return this;
        }
        /**
         * Http read timeout in milliseconds.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder httpReadTimeout(String httpReadTimeout) {
            setProperty("httpReadTimeout", httpReadTimeout);
            return this;
        }
        /**
         * Number of HTTP retries.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder httpRetryCount(Integer httpRetryCount) {
            setProperty("httpRetryCount", httpRetryCount);
            return this;
        }
        /**
         * Number of HTTP retries.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder httpRetryCount(String httpRetryCount) {
            setProperty("httpRetryCount", httpRetryCount);
            return this;
        }
        /**
         * HTTP retry interval in seconds.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder httpRetryIntervalSeconds(
                Integer httpRetryIntervalSeconds) {
            setProperty("httpRetryIntervalSeconds", httpRetryIntervalSeconds);
            return this;
        }
        /**
         * HTTP retry interval in seconds.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder httpRetryIntervalSeconds(
                String httpRetryIntervalSeconds) {
            setProperty("httpRetryIntervalSeconds", httpRetryIntervalSeconds);
            return this;
        }
        /**
         * HTTP streaming read timeout in milliseconds.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder httpStreamingReadTimeout(
                Integer httpStreamingReadTimeout) {
            setProperty("httpStreamingReadTimeout", httpStreamingReadTimeout);
            return this;
        }
        /**
         * HTTP streaming read timeout in milliseconds.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder httpStreamingReadTimeout(
                String httpStreamingReadTimeout) {
            setProperty("httpStreamingReadTimeout", httpStreamingReadTimeout);
            return this;
        }
        /**
         * The ids of users.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder ids(List<String> ids) {
            setProperty("ids", ids);
            return this;
        }
        /**
         * The ids of users.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder ids(String ids) {
            setProperty("ids", ids);
            return this;
        }
        /**
         * Sets the name of a parameter to be passed in the exchange In Body.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder inBody(String inBody) {
            setProperty("inBody", inBody);
            return this;
        }
        /**
         * Enables notifications that the user has already read in addition to
         * unread ones.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder includeRead(Boolean includeRead) {
            setProperty("includeRead", includeRead);
            return this;
        }
        /**
         * Enables notifications that the user has already read in addition to
         * unread ones.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder includeRead(String includeRead) {
            setProperty("includeRead", includeRead);
            return this;
        }
        /**
         * Whether hidden.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder isHidden(Boolean isHidden) {
            setProperty("isHidden", isHidden);
            return this;
        }
        /**
         * Whether hidden.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder isHidden(String isHidden) {
            setProperty("isHidden", isHidden);
            return this;
        }
        /**
         * If set to true, raw JSON forms will be stored in DataObjectFactory.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder jsonStoreEnabled(
                Boolean jsonStoreEnabled) {
            setProperty("jsonStoreEnabled", jsonStoreEnabled);
            return this;
        }
        /**
         * If set to true, raw JSON forms will be stored in DataObjectFactory.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder jsonStoreEnabled(String jsonStoreEnabled) {
            setProperty("jsonStoreEnabled", jsonStoreEnabled);
            return this;
        }
        /**
         * Link URL.
         * 
         * The option is a: <code>java.net.URL</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder link(URL link) {
            setProperty("link", link);
            return this;
        }
        /**
         * Link URL.
         * 
         * The option will be converted to a <code>java.net.URL</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder link(String link) {
            setProperty("link", link);
            return this;
        }
        /**
         * Link ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder linkId(String linkId) {
            setProperty("linkId", linkId);
            return this;
        }
        /**
         * Desired FQL locale.
         * 
         * The option is a: <code>java.util.Locale</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder locale(Locale locale) {
            setProperty("locale", locale);
            return this;
        }
        /**
         * Desired FQL locale.
         * 
         * The option will be converted to a <code>java.util.Locale</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder locale(String locale) {
            setProperty("locale", locale);
            return this;
        }
        /**
         * If set to true, Facebook4J mbean will be registerd.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder mbeanEnabled(Boolean mbeanEnabled) {
            setProperty("mbeanEnabled", mbeanEnabled);
            return this;
        }
        /**
         * If set to true, Facebook4J mbean will be registerd.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder mbeanEnabled(String mbeanEnabled) {
            setProperty("mbeanEnabled", mbeanEnabled);
            return this;
        }
        /**
         * The message text.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder message(String message) {
            setProperty("message", message);
            return this;
        }
        /**
         * The message ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder messageId(String messageId) {
            setProperty("messageId", messageId);
            return this;
        }
        /**
         * The metric name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder metric(String metric) {
            setProperty("metric", metric);
            return this;
        }
        /**
         * The milestone id.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder milestoneId(String milestoneId) {
            setProperty("milestoneId", milestoneId);
            return this;
        }
        /**
         * Test user name, must be of the form 'first last'.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder name(String name) {
            setProperty("name", name);
            return this;
        }
        /**
         * The note ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder noteId(String noteId) {
            setProperty("noteId", noteId);
            return this;
        }
        /**
         * The notification ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder notificationId(String notificationId) {
            setProperty("notificationId", notificationId);
            return this;
        }
        /**
         * The insight object ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder objectId(String objectId) {
            setProperty("objectId", objectId);
            return this;
        }
        /**
         * The offer id.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder offerId(String offerId) {
            setProperty("offerId", offerId);
            return this;
        }
        /**
         * The question's answer option description.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder optionDescription(
                String optionDescription) {
            setProperty("optionDescription", optionDescription);
            return this;
        }
        /**
         * The page id.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder pageId(String pageId) {
            setProperty("pageId", pageId);
            return this;
        }
        /**
         * The permission name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder permissionName(String permissionName) {
            setProperty("permissionName", permissionName);
            return this;
        }
        /**
         * Test user permissions in the format perm1,perm2,...
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder permissions(String permissions) {
            setProperty("permissions", permissions);
            return this;
        }
        /**
         * The photo ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder photoId(String photoId) {
            setProperty("photoId", photoId);
            return this;
        }
        /**
         * The picture id.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder pictureId(Integer pictureId) {
            setProperty("pictureId", pictureId);
            return this;
        }
        /**
         * The picture id.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder pictureId(String pictureId) {
            setProperty("pictureId", pictureId);
            return this;
        }
        /**
         * The picture2 id.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder pictureId2(Integer pictureId2) {
            setProperty("pictureId2", pictureId2);
            return this;
        }
        /**
         * The picture2 id.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder pictureId2(String pictureId2) {
            setProperty("pictureId2", pictureId2);
            return this;
        }
        /**
         * The picture size.
         * 
         * The option is a: <code>facebook4j.PictureSize</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder pictureSize(PictureSize pictureSize) {
            setProperty("pictureSize", pictureSize);
            return this;
        }
        /**
         * The picture size.
         * 
         * The option will be converted to a <code>facebook4j.PictureSize</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder pictureSize(String pictureSize) {
            setProperty("pictureSize", pictureSize);
            return this;
        }
        /**
         * The place ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder placeId(String placeId) {
            setProperty("placeId", placeId);
            return this;
        }
        /**
         * The post ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder postId(String postId) {
            setProperty("postId", postId);
            return this;
        }
        /**
         * The post to create or update.
         * 
         * The option is a: <code>facebook4j.PostUpdate</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder postUpdate(Object postUpdate) {
            setProperty("postUpdate", postUpdate);
            return this;
        }
        /**
         * The post to create or update.
         * 
         * The option will be converted to a <code>facebook4j.PostUpdate</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder postUpdate(String postUpdate) {
            setProperty("postUpdate", postUpdate);
            return this;
        }
        /**
         * Prettify JSON debug output if set to true.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder prettyDebugEnabled(
                Boolean prettyDebugEnabled) {
            setProperty("prettyDebugEnabled", prettyDebugEnabled);
            return this;
        }
        /**
         * Prettify JSON debug output if set to true.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder prettyDebugEnabled(
                String prettyDebugEnabled) {
            setProperty("prettyDebugEnabled", prettyDebugEnabled);
            return this;
        }
        /**
         * FQL queries.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder queries(Map<String, String> queries) {
            setProperty("queries", queries);
            return this;
        }
        /**
         * FQL queries.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder queries(String queries) {
            setProperty("queries", queries);
            return this;
        }
        /**
         * FQL query or search terms for search endpoints.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder query(String query) {
            setProperty("query", query);
            return this;
        }
        /**
         * The question id.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder questionId(String questionId) {
            setProperty("questionId", questionId);
            return this;
        }
        /**
         * Optional reading parameters. See Reading Options(#reading).
         * 
         * The option is a: <code>facebook4j.Reading</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder reading(Object reading) {
            setProperty("reading", reading);
            return this;
        }
        /**
         * Optional reading parameters. See Reading Options(#reading).
         * 
         * The option will be converted to a <code>facebook4j.Reading</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder reading(String reading) {
            setProperty("reading", reading);
            return this;
        }
        /**
         * To configure Reading using key/value pairs from the Map.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder readingOptions(
                Map<String, Object> readingOptions) {
            setProperty("readingOptions", readingOptions);
            return this;
        }
        /**
         * To configure Reading using key/value pairs from the Map.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder readingOptions(String readingOptions) {
            setProperty("readingOptions", readingOptions);
            return this;
        }
        /**
         * API base URL.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder restBaseURL(String restBaseURL) {
            setProperty("restBaseURL", restBaseURL);
            return this;
        }
        /**
         * The numeric score with value.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder scoreValue(Integer scoreValue) {
            setProperty("scoreValue", scoreValue);
            return this;
        }
        /**
         * The numeric score with value.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder scoreValue(String scoreValue) {
            setProperty("scoreValue", scoreValue);
            return this;
        }
        /**
         * The picture size, one of large, normal, small or square.
         * 
         * The option is a: <code>facebook4j.PictureSize</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder size(PictureSize size) {
            setProperty("size", size);
            return this;
        }
        /**
         * The picture size, one of large, normal, small or square.
         * 
         * The option will be converted to a <code>facebook4j.PictureSize</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder size(String size) {
            setProperty("size", size);
            return this;
        }
        /**
         * The media content from either a java.io.File or java.io.Inputstream.
         * 
         * The option is a: <code>facebook4j.Media</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder source(Object source) {
            setProperty("source", source);
            return this;
        }
        /**
         * The media content from either a java.io.File or java.io.Inputstream.
         * 
         * The option will be converted to a <code>facebook4j.Media</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder source(String source) {
            setProperty("source", source);
            return this;
        }
        /**
         * The note of the subject.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder subject(String subject) {
            setProperty("subject", subject);
            return this;
        }
        /**
         * The tab id.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder tabId(String tabId) {
            setProperty("tabId", tabId);
            return this;
        }
        /**
         * Photo tag information.
         * 
         * The option is a: <code>facebook4j.TagUpdate</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder tagUpdate(Object tagUpdate) {
            setProperty("tagUpdate", tagUpdate);
            return this;
        }
        /**
         * Photo tag information.
         * 
         * The option will be converted to a <code>facebook4j.TagUpdate</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder tagUpdate(String tagUpdate) {
            setProperty("tagUpdate", tagUpdate);
            return this;
        }
        /**
         * Test user 1.
         * 
         * The option is a: <code>facebook4j.TestUser</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder testUser1(Object testUser1) {
            setProperty("testUser1", testUser1);
            return this;
        }
        /**
         * Test user 1.
         * 
         * The option will be converted to a <code>facebook4j.TestUser</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder testUser1(String testUser1) {
            setProperty("testUser1", testUser1);
            return this;
        }
        /**
         * Test user 2.
         * 
         * The option is a: <code>facebook4j.TestUser</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder testUser2(Object testUser2) {
            setProperty("testUser2", testUser2);
            return this;
        }
        /**
         * Test user 2.
         * 
         * The option will be converted to a <code>facebook4j.TestUser</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder testUser2(String testUser2) {
            setProperty("testUser2", testUser2);
            return this;
        }
        /**
         * The ID of the test user.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder testUserId(String testUserId) {
            setProperty("testUserId", testUserId);
            return this;
        }
        /**
         * The title text.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder title(String title) {
            setProperty("title", title);
            return this;
        }
        /**
         * The ID of the user to tag.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder toUserId(String toUserId) {
            setProperty("toUserId", toUserId);
            return this;
        }
        /**
         * The IDs of the users to tag.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder toUserIds(List<String> toUserIds) {
            setProperty("toUserIds", toUserIds);
            return this;
        }
        /**
         * The IDs of the users to tag.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder toUserIds(String toUserIds) {
            setProperty("toUserIds", toUserIds);
            return this;
        }
        /**
         * The Facebook user ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder userId(String userId) {
            setProperty("userId", userId);
            return this;
        }
        /**
         * The ID of a user 1.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder userId1(String userId1) {
            setProperty("userId1", userId1);
            return this;
        }
        /**
         * The ID of a user 2.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder userId2(String userId2) {
            setProperty("userId2", userId2);
            return this;
        }
        /**
         * The IDs of users to invite to event.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder userIds(List<String> userIds) {
            setProperty("userIds", userIds);
            return this;
        }
        /**
         * The IDs of users to invite to event.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder userIds(String userIds) {
            setProperty("userIds", userIds);
            return this;
        }
        /**
         * The test user locale.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder userLocale(String userLocale) {
            setProperty("userLocale", userLocale);
            return this;
        }
        /**
         * Use SSL.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder useSSL(Boolean useSSL) {
            setProperty("useSSL", useSSL);
            return this;
        }
        /**
         * Use SSL.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder useSSL(String useSSL) {
            setProperty("useSSL", useSSL);
            return this;
        }
        /**
         * Video API base URL.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder videoBaseURL(String videoBaseURL) {
            setProperty("videoBaseURL", videoBaseURL);
            return this;
        }
        /**
         * The video ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default FacebookEndpointBuilder videoId(String videoId) {
            setProperty("videoId", videoId);
            return this;
        }
        /**
         * HTTP proxy server host name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default FacebookEndpointBuilder httpProxyHost(String httpProxyHost) {
            setProperty("httpProxyHost", httpProxyHost);
            return this;
        }
        /**
         * HTTP proxy server password.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default FacebookEndpointBuilder httpProxyPassword(
                String httpProxyPassword) {
            setProperty("httpProxyPassword", httpProxyPassword);
            return this;
        }
        /**
         * HTTP proxy server port.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: proxy
         */
        default FacebookEndpointBuilder httpProxyPort(Integer httpProxyPort) {
            setProperty("httpProxyPort", httpProxyPort);
            return this;
        }
        /**
         * HTTP proxy server port.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: proxy
         */
        default FacebookEndpointBuilder httpProxyPort(String httpProxyPort) {
            setProperty("httpProxyPort", httpProxyPort);
            return this;
        }
        /**
         * HTTP proxy server user name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default FacebookEndpointBuilder httpProxyUser(String httpProxyUser) {
            setProperty("httpProxyUser", httpProxyUser);
            return this;
        }
        /**
         * The user access token.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FacebookEndpointBuilder oAuthAccessToken(String oAuthAccessToken) {
            setProperty("oAuthAccessToken", oAuthAccessToken);
            return this;
        }
        /**
         * OAuth access token URL.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FacebookEndpointBuilder oAuthAccessTokenURL(
                String oAuthAccessTokenURL) {
            setProperty("oAuthAccessTokenURL", oAuthAccessTokenURL);
            return this;
        }
        /**
         * The application Id.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FacebookEndpointBuilder oAuthAppId(String oAuthAppId) {
            setProperty("oAuthAppId", oAuthAppId);
            return this;
        }
        /**
         * The application Secret.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FacebookEndpointBuilder oAuthAppSecret(String oAuthAppSecret) {
            setProperty("oAuthAppSecret", oAuthAppSecret);
            return this;
        }
        /**
         * OAuth authorization URL.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FacebookEndpointBuilder oAuthAuthorizationURL(
                String oAuthAuthorizationURL) {
            setProperty("oAuthAuthorizationURL", oAuthAuthorizationURL);
            return this;
        }
        /**
         * Default OAuth permissions. Comma separated permission names. See
         * https://developers.facebook.com/docs/reference/login/#permissions for
         * the detail.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default FacebookEndpointBuilder oAuthPermissions(String oAuthPermissions) {
            setProperty("oAuthPermissions", oAuthPermissions);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Facebook component.
     */
    public interface AdvancedFacebookEndpointBuilder
            extends
                AdvancedFacebookEndpointConsumerBuilder, AdvancedFacebookEndpointProducerBuilder {
        default FacebookEndpointBuilder basic() {
            return (FacebookEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFacebookEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFacebookEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFacebookEndpointBuilder synchronous(boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedFacebookEndpointBuilder synchronous(String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Proxy enum for <code>facebook4j.PictureSize</code> enum.
     */
    enum PictureSize {
        square,
        small,
        normal,
        large,
        thumbnail,
        album;
    }
    /**
     * Facebook (camel-facebook)
     * The Facebook component provides access to all of the Facebook APIs
     * accessible using Facebook4J.
     * 
     * Category: social
     * Available as of version: 2.14
     * Maven coordinates: org.apache.camel:camel-facebook
     * 
     * Syntax: <code>facebook:methodName</code>
     * 
     * Path parameter: methodName (required)
     * What operation to perform
     */
    default FacebookEndpointBuilder facebook(String path) {
        class FacebookEndpointBuilderImpl extends AbstractEndpointBuilder implements FacebookEndpointBuilder, AdvancedFacebookEndpointBuilder {
            public FacebookEndpointBuilderImpl(String path) {
                super("facebook", path);
            }
        }
        return new FacebookEndpointBuilderImpl(path);
    }
}