/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.microprofile.metrics.event.notifier.route;

import org.apache.camel.CamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.microprofile.metrics.MicroProfileMetricsTestSupport;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.junit.Test;
import static org.apache.camel.component.microprofile.metrics.MicroProfileMetricsConstants.DEFAULT_CAMEL_ROUTES_ADDED_METRIC_NAME;
import static org.apache.camel.component.microprofile.metrics.MicroProfileMetricsConstants.DEFAULT_CAMEL_ROUTES_RUNNING_METRIC_NAME;

public class MicroProfileMetricsRouteEventNotifierTest extends MicroProfileMetricsTestSupport {

    @Test
    public void testMicroProfileMetricsEventNotifier() throws Exception {
        ConcurrentGauge routesAdded = getConcurrentGauge(DEFAULT_CAMEL_ROUTES_ADDED_METRIC_NAME);
        ConcurrentGauge routesRunning = getConcurrentGauge(DEFAULT_CAMEL_ROUTES_RUNNING_METRIC_NAME);

        assertEquals(1, routesAdded.getCount());
        assertEquals(1, routesRunning.getCount());

        context.addRoutes(new RouteBuilder() {
            @Override
            public void configure() throws Exception {
                from("direct:foo").id("test")
                        .to("mock:bar");
            }
        });

        assertEquals(2, routesAdded.getCount());
        assertEquals(2, routesRunning.getCount());

        context.getRouteController().stopRoute("test");
        assertEquals(2, routesAdded.getCount());
        assertEquals(1, routesRunning.getCount());

        context.removeRoute("test");
        assertEquals(1, routesAdded.getCount());
        assertEquals(1, routesRunning.getCount());
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        MicroProfileMetricsRouteEventNotifier eventNotifier = new MicroProfileMetricsRouteEventNotifier();
        eventNotifier.setMetricRegistry(metricRegistry);

        CamelContext camelContext = super.createCamelContext();
        camelContext.getManagementStrategy().addEventNotifier(eventNotifier);
        return camelContext;
    }

    @Override
    protected RoutesBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder() {
            @Override
            public void configure() throws Exception {
                from("direct:start")
                        .to("mock:result");
            }
        };
    }
}
