/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.aws.sdb;

/**
 * Constants used in Camel AWS SDB component
 */
public interface SdbConstants {
    
    String ATTRIBUTES = "CamelAwsSdbAttributes";
    String ATTRIBUTE_NAMES = "CamelAwsSdbAttributeNames";
    String ATTRIBUTE_NAME_COUNT = "CamelAwsSdbAttributeNameCount";
    String ATTRIBUTE_NAME_SIZE = "CamelAwsSdbAttributeNameSize";
    String ATTRIBUTE_VALUE_COUNT = "CamelAwsSdbAttributeValueCount";
    String ATTRIBUTE_VALUE_SIZE = "CamelAwsSdbAttributeValueSize";
    String CONSISTENT_READ = "CamelAwsSdbConsistentRead";
    String DELETABLE_ITEMS = "CamelAwsSdbDeletableItems";
    String DOMAIN_NAME = "CamelAwsSdbDomainName";
    String DOMAIN_NAMES = "CamelAwsSdbDomainNames";
    String ITEMS = "CamelAwsSdbItems";
    String ITEM_COUNT = "CamelAwsSdbItemCount";
    String ITEM_NAME_SIZE = "CamelAwsSdbItemNameSize";
    String ITEM_NAME = "CamelAwsSdbItemName";
    String MAX_NUMBER_OF_DOMAINS = "CamelAwsSdbMaxNumberOfDomains";
    String MESSAGE_ID = "CamelAwsSdbMessageId";
    String NEXT_TOKEN = "CamelAwsSdbNextToken";
    String OPERATION = "CamelAwsSdbOperation";
    String REPLACEABLE_ATTRIBUTES = "CamelAwsSdbReplaceableAttributes";
    String REPLACEABLE_ITEMS = "CamelAwsSdbReplaceableItems";
    String SELECT_EXPRESSION = "CamelAwsSdbSelectExpression";
    String TIMESTAMP = "CamelAwsSdbTimestamp";
    String UPDATE_CONDITION = "CamelAwsSdbUpdateCondition";
}
