/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Used to sign and verify exchanges using the XML signature specification.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface XmlSignatureEndpointBuilderFactory {


    /**
     * Builder for endpoint for the XML Security component.
     */
    public interface XmlSignatureEndpointBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedXmlSignatureEndpointBuilder advanced() {
            return (AdvancedXmlSignatureEndpointBuilder) this;
        }
        /**
         * You can set a base URI which is used in the URI dereferencing.
         * Relative URIs are then concatenated with the base URI.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default XmlSignatureEndpointBuilder baseUri(String baseUri) {
            setProperty("baseUri", baseUri);
            return this;
        }
        /**
         * Determines if the XML signature specific headers be cleared after
         * signing and verification. Defaults to true.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default XmlSignatureEndpointBuilder clearHeaders(Boolean clearHeaders) {
            setProperty("clearHeaders", clearHeaders);
            return this;
        }
        /**
         * Determines if the XML signature specific headers be cleared after
         * signing and verification. Defaults to true.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default XmlSignatureEndpointBuilder clearHeaders(String clearHeaders) {
            setProperty("clearHeaders", clearHeaders);
            return this;
        }
        /**
         * Sets the crypto context properties. See {link
         * XMLCryptoContext#setProperty(String, Object)}. Possible properties
         * are defined in XMLSignContext an XMLValidateContext (see Supported
         * Properties). The following properties are set by default to the value
         * Boolean#TRUE for the XML validation. If you want to switch these
         * features off you must set the property value to Boolean#FALSE.
         * org.jcp.xml.dsig.validateManifests
         * javax.xml.crypto.dsig.cacheReference.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: common
         */
        default XmlSignatureEndpointBuilder cryptoContextProperties(
                Map<String, Object> cryptoContextProperties) {
            setProperty("cryptoContextProperties", cryptoContextProperties);
            return this;
        }
        /**
         * Sets the crypto context properties. See {link
         * XMLCryptoContext#setProperty(String, Object)}. Possible properties
         * are defined in XMLSignContext an XMLValidateContext (see Supported
         * Properties). The following properties are set by default to the value
         * Boolean#TRUE for the XML validation. If you want to switch these
         * features off you must set the property value to Boolean#FALSE.
         * org.jcp.xml.dsig.validateManifests
         * javax.xml.crypto.dsig.cacheReference.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: common
         */
        default XmlSignatureEndpointBuilder cryptoContextProperties(
                String cryptoContextProperties) {
            setProperty("cryptoContextProperties", cryptoContextProperties);
            return this;
        }
        /**
         * Disallows that the incoming XML document contains DTD DOCTYPE
         * declaration. The default value is Boolean#TRUE.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default XmlSignatureEndpointBuilder disallowDoctypeDecl(
                Boolean disallowDoctypeDecl) {
            setProperty("disallowDoctypeDecl", disallowDoctypeDecl);
            return this;
        }
        /**
         * Disallows that the incoming XML document contains DTD DOCTYPE
         * declaration. The default value is Boolean#TRUE.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default XmlSignatureEndpointBuilder disallowDoctypeDecl(
                String disallowDoctypeDecl) {
            setProperty("disallowDoctypeDecl", disallowDoctypeDecl);
            return this;
        }
        /**
         * Indicator whether the XML declaration in the outgoing message body
         * should be omitted. Default value is false. Can be overwritten by the
         * header XmlSignatureConstants#HEADER_OMIT_XML_DECLARATION.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: common
         */
        default XmlSignatureEndpointBuilder omitXmlDeclaration(
                Boolean omitXmlDeclaration) {
            setProperty("omitXmlDeclaration", omitXmlDeclaration);
            return this;
        }
        /**
         * Indicator whether the XML declaration in the outgoing message body
         * should be omitted. Default value is false. Can be overwritten by the
         * header XmlSignatureConstants#HEADER_OMIT_XML_DECLARATION.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: common
         */
        default XmlSignatureEndpointBuilder omitXmlDeclaration(
                String omitXmlDeclaration) {
            setProperty("omitXmlDeclaration", omitXmlDeclaration);
            return this;
        }
        /**
         * The character encoding of the resulting signed XML document. If null
         * then the encoding of the original XML document is used.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default XmlSignatureEndpointBuilder outputXmlEncoding(
                String outputXmlEncoding) {
            setProperty("outputXmlEncoding", outputXmlEncoding);
            return this;
        }
        /**
         * Classpath to the XML Schema. Must be specified in the detached XML
         * Signature case for determining the ID attributes, might be set in the
         * enveloped and enveloping case. If set, then the XML document is
         * validated with the specified XML schema. The schema resource URI can
         * be overwritten by the header
         * XmlSignatureConstants#HEADER_SCHEMA_RESOURCE_URI.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default XmlSignatureEndpointBuilder schemaResourceUri(
                String schemaResourceUri) {
            setProperty("schemaResourceUri", schemaResourceUri);
            return this;
        }
        /**
         * In order to protect the KeyInfo element from tampering you can add a
         * reference to the signed info element so that it is protected via the
         * signature value. The default value is true. Only relevant when a
         * KeyInfo is returned by KeyAccessor. and KeyInfo#getId() is not null.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: sign
         */
        default XmlSignatureEndpointBuilder addKeyInfoReference(
                Boolean addKeyInfoReference) {
            setProperty("addKeyInfoReference", addKeyInfoReference);
            return this;
        }
        /**
         * In order to protect the KeyInfo element from tampering you can add a
         * reference to the signed info element so that it is protected via the
         * signature value. The default value is true. Only relevant when a
         * KeyInfo is returned by KeyAccessor. and KeyInfo#getId() is not null.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: sign
         */
        default XmlSignatureEndpointBuilder addKeyInfoReference(
                String addKeyInfoReference) {
            setProperty("addKeyInfoReference", addKeyInfoReference);
            return this;
        }
        /**
         * Canonicalization method used to canonicalize the SignedInfo element
         * before the digest is calculated. You can use the helper methods
         * XmlSignatureHelper.getCanonicalizationMethod(String algorithm) or
         * getCanonicalizationMethod(String algorithm, List
         * inclusiveNamespacePrefixes) to create a canonicalization method.
         * 
         * The option is a: <code>javax.xml.crypto.AlgorithmMethod</code> type.
         * 
         * Group: sign
         */
        default XmlSignatureEndpointBuilder canonicalizationMethod(
                Object canonicalizationMethod) {
            setProperty("canonicalizationMethod", canonicalizationMethod);
            return this;
        }
        /**
         * Canonicalization method used to canonicalize the SignedInfo element
         * before the digest is calculated. You can use the helper methods
         * XmlSignatureHelper.getCanonicalizationMethod(String algorithm) or
         * getCanonicalizationMethod(String algorithm, List
         * inclusiveNamespacePrefixes) to create a canonicalization method.
         * 
         * The option will be converted to a
         * <code>javax.xml.crypto.AlgorithmMethod</code> type.
         * 
         * Group: sign
         */
        default XmlSignatureEndpointBuilder canonicalizationMethod(
                String canonicalizationMethod) {
            setProperty("canonicalizationMethod", canonicalizationMethod);
            return this;
        }
        /**
         * Sets the content object Id attribute value. By default a UUID is
         * generated. If you set the null value, then a new UUID will be
         * generated. Only used in the enveloping case.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sign
         */
        default XmlSignatureEndpointBuilder contentObjectId(
                String contentObjectId) {
            setProperty("contentObjectId", contentObjectId);
            return this;
        }
        /**
         * Type of the content reference. The default value is null. This value
         * can be overwritten by the header
         * XmlSignatureConstants#HEADER_CONTENT_REFERENCE_TYPE.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sign
         */
        default XmlSignatureEndpointBuilder contentReferenceType(
                String contentReferenceType) {
            setProperty("contentReferenceType", contentReferenceType);
            return this;
        }
        /**
         * Reference URI for the content to be signed. Only used in the
         * enveloped case. If the reference URI contains an ID attribute value,
         * then the resource schema URI ( setSchemaResourceUri(String)) must
         * also be set because the schema validator will then find out which
         * attributes are ID attributes. Will be ignored in the enveloping or
         * detached case.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sign
         */
        default XmlSignatureEndpointBuilder contentReferenceUri(
                String contentReferenceUri) {
            setProperty("contentReferenceUri", contentReferenceUri);
            return this;
        }
        /**
         * Digest algorithm URI. Optional parameter. This digest algorithm is
         * used for calculating the digest of the input message. If this digest
         * algorithm is not specified then the digest algorithm is calculated
         * from the signature algorithm. Example:
         * http://www.w3.org/2001/04/xmlenc#sha256.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sign
         */
        default XmlSignatureEndpointBuilder digestAlgorithm(
                String digestAlgorithm) {
            setProperty("digestAlgorithm", digestAlgorithm);
            return this;
        }
        /**
         * For the signing process, a private key is necessary. You specify a
         * key accessor bean which provides this private key. The key accessor
         * bean must implement the KeyAccessor interface. The package
         * org.apache.camel.component.xmlsecurity.api contains the default
         * implementation class DefaultKeyAccessor which reads the private key
         * from a Java keystore.
         * 
         * The option is a:
         * <code>org.apache.camel.component.xmlsecurity.api.KeyAccessor</code>
         * type.
         * 
         * Group: sign
         */
        default XmlSignatureEndpointBuilder keyAccessor(Object keyAccessor) {
            setProperty("keyAccessor", keyAccessor);
            return this;
        }
        /**
         * For the signing process, a private key is necessary. You specify a
         * key accessor bean which provides this private key. The key accessor
         * bean must implement the KeyAccessor interface. The package
         * org.apache.camel.component.xmlsecurity.api contains the default
         * implementation class DefaultKeyAccessor which reads the private key
         * from a Java keystore.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.xmlsecurity.api.KeyAccessor</code>
         * type.
         * 
         * Group: sign
         */
        default XmlSignatureEndpointBuilder keyAccessor(String keyAccessor) {
            setProperty("keyAccessor", keyAccessor);
            return this;
        }
        /**
         * Local name of the parent element to which the XML signature element
         * will be added. Only relevant for enveloped XML signature.
         * Alternatively you can also use
         * setParentXpath(XPathFilterParameterSpec). Default value is null. The
         * value must be null for enveloping and detached XML signature. This
         * parameter or the parameter setParentXpath(XPathFilterParameterSpec)
         * for enveloped signature and the parameter
         * setXpathsToIdAttributes(List) for detached signature must not be set
         * in the same configuration. If the parameters parentXpath and
         * parentLocalName are specified in the same configuration then an
         * exception is thrown.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sign
         */
        default XmlSignatureEndpointBuilder parentLocalName(
                String parentLocalName) {
            setProperty("parentLocalName", parentLocalName);
            return this;
        }
        /**
         * Namespace of the parent element to which the XML signature element
         * will be added.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sign
         */
        default XmlSignatureEndpointBuilder parentNamespace(
                String parentNamespace) {
            setProperty("parentNamespace", parentNamespace);
            return this;
        }
        /**
         * Sets the XPath to find the parent node in the enveloped case. Either
         * you specify the parent node via this method or the local name and
         * namespace of the parent with the methods setParentLocalName(String)
         * and setParentNamespace(String). Default value is null. The value must
         * be null for enveloping and detached XML signature. If the parameters
         * parentXpath and parentLocalName are specified in the same
         * configuration then an exception is thrown.
         * 
         * The option is a:
         * <code>javax.xml.crypto.dsig.spec.XPathFilterParameterSpec</code>
         * type.
         * 
         * Group: sign
         */
        default XmlSignatureEndpointBuilder parentXpath(Object parentXpath) {
            setProperty("parentXpath", parentXpath);
            return this;
        }
        /**
         * Sets the XPath to find the parent node in the enveloped case. Either
         * you specify the parent node via this method or the local name and
         * namespace of the parent with the methods setParentLocalName(String)
         * and setParentNamespace(String). Default value is null. The value must
         * be null for enveloping and detached XML signature. If the parameters
         * parentXpath and parentLocalName are specified in the same
         * configuration then an exception is thrown.
         * 
         * The option will be converted to a
         * <code>javax.xml.crypto.dsig.spec.XPathFilterParameterSpec</code>
         * type.
         * 
         * Group: sign
         */
        default XmlSignatureEndpointBuilder parentXpath(String parentXpath) {
            setProperty("parentXpath", parentXpath);
            return this;
        }
        /**
         * Indicator whether the message body contains plain text. The default
         * value is false, indicating that the message body contains XML. The
         * value can be overwritten by the header
         * XmlSignatureConstants#HEADER_MESSAGE_IS_PLAIN_TEXT.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: sign
         */
        default XmlSignatureEndpointBuilder plainText(Boolean plainText) {
            setProperty("plainText", plainText);
            return this;
        }
        /**
         * Indicator whether the message body contains plain text. The default
         * value is false, indicating that the message body contains XML. The
         * value can be overwritten by the header
         * XmlSignatureConstants#HEADER_MESSAGE_IS_PLAIN_TEXT.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: sign
         */
        default XmlSignatureEndpointBuilder plainText(String plainText) {
            setProperty("plainText", plainText);
            return this;
        }
        /**
         * Encoding of the plain text. Only relevant if the message body is
         * plain text (see parameter plainText. Default value is UTF-8.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sign
         */
        default XmlSignatureEndpointBuilder plainTextEncoding(
                String plainTextEncoding) {
            setProperty("plainTextEncoding", plainTextEncoding);
            return this;
        }
        /**
         * Namespace prefix for the XML signature namespace
         * http://www.w3.org/2000/09/xmldsig#. Default value is ds. If null or
         * an empty value is set then no prefix is used for the XML signature
         * namespace. See best practice
         * http://www.w3.org/TR/xmldsig-bestpractices/#signing-xml-
         * without-namespaces.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sign
         */
        default XmlSignatureEndpointBuilder prefixForXmlSignatureNamespace(
                String prefixForXmlSignatureNamespace) {
            setProperty("prefixForXmlSignatureNamespace", prefixForXmlSignatureNamespace);
            return this;
        }
        /**
         * For adding additional References and Objects to the XML signature
         * which contain additional properties, you can provide a bean which
         * implements the XmlSignatureProperties interface.
         * 
         * The option is a:
         * <code>org.apache.camel.component.xmlsecurity.api.XmlSignatureProperties</code> type.
         * 
         * Group: sign
         */
        default XmlSignatureEndpointBuilder properties(Object properties) {
            setProperty("properties", properties);
            return this;
        }
        /**
         * For adding additional References and Objects to the XML signature
         * which contain additional properties, you can provide a bean which
         * implements the XmlSignatureProperties interface.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.xmlsecurity.api.XmlSignatureProperties</code> type.
         * 
         * Group: sign
         */
        default XmlSignatureEndpointBuilder properties(String properties) {
            setProperty("properties", properties);
            return this;
        }
        /**
         * Signature algorithm. Default value is
         * http://www.w3.org/2000/09/xmldsig#rsa-sha1.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sign
         */
        default XmlSignatureEndpointBuilder signatureAlgorithm(
                String signatureAlgorithm) {
            setProperty("signatureAlgorithm", signatureAlgorithm);
            return this;
        }
        /**
         * Sets the signature Id. If this parameter is not set (null value) then
         * a unique ID is generated for the signature ID (default). If this
         * parameter is set to (empty string) then no Id attribute is created in
         * the signature element.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: sign
         */
        default XmlSignatureEndpointBuilder signatureId(String signatureId) {
            setProperty("signatureId", signatureId);
            return this;
        }
        /**
         * Transforms which are executed on the message body before the digest
         * is calculated. By default, C14n is added and in the case of enveloped
         * signature (see option parentLocalName) also
         * http://www.w3.org/2000/09/xmldsig#enveloped-signature is added at
         * position 0 of the list. Use methods in XmlSignatureHelper to create
         * the transform methods.
         * 
         * The option is a:
         * <code>java.util.List&lt;javax.xml.crypto.AlgorithmMethod&gt;</code>
         * type.
         * 
         * Group: sign
         */
        default XmlSignatureEndpointBuilder transformMethods(
                List<Object> transformMethods) {
            setProperty("transformMethods", transformMethods);
            return this;
        }
        /**
         * Transforms which are executed on the message body before the digest
         * is calculated. By default, C14n is added and in the case of enveloped
         * signature (see option parentLocalName) also
         * http://www.w3.org/2000/09/xmldsig#enveloped-signature is added at
         * position 0 of the list. Use methods in XmlSignatureHelper to create
         * the transform methods.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;javax.xml.crypto.AlgorithmMethod&gt;</code>
         * type.
         * 
         * Group: sign
         */
        default XmlSignatureEndpointBuilder transformMethods(
                String transformMethods) {
            setProperty("transformMethods", transformMethods);
            return this;
        }
        /**
         * Define the elements which are signed in the detached case via XPATH
         * expressions to ID attributes (attributes of type ID). For each
         * element found via the XPATH expression a detached signature is
         * created whose reference URI contains the corresponding attribute
         * value (preceded by '#'). The signature becomes the last sibling of
         * the signed element. Elements with deeper hierarchy level are signed
         * first. You can also set the XPATH list dynamically via the header
         * XmlSignatureConstants#HEADER_XPATHS_TO_ID_ATTRIBUTES. The parameter
         * setParentLocalName(String) or
         * setParentXpath(XPathFilterParameterSpec) for enveloped signature and
         * this parameter for detached signature must not be set in the same
         * configuration.
         * 
         * The option is a:
         * <code>java.util.List&lt;javax.xml.crypto.dsig.spec.XPathFilterParameterSpec&gt;</code> type.
         * 
         * Group: sign
         */
        default XmlSignatureEndpointBuilder xpathsToIdAttributes(
                List<Object> xpathsToIdAttributes) {
            setProperty("xpathsToIdAttributes", xpathsToIdAttributes);
            return this;
        }
        /**
         * Define the elements which are signed in the detached case via XPATH
         * expressions to ID attributes (attributes of type ID). For each
         * element found via the XPATH expression a detached signature is
         * created whose reference URI contains the corresponding attribute
         * value (preceded by '#'). The signature becomes the last sibling of
         * the signed element. Elements with deeper hierarchy level are signed
         * first. You can also set the XPATH list dynamically via the header
         * XmlSignatureConstants#HEADER_XPATHS_TO_ID_ATTRIBUTES. The parameter
         * setParentLocalName(String) or
         * setParentXpath(XPathFilterParameterSpec) for enveloped signature and
         * this parameter for detached signature must not be set in the same
         * configuration.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;javax.xml.crypto.dsig.spec.XPathFilterParameterSpec&gt;</code> type.
         * 
         * Group: sign
         */
        default XmlSignatureEndpointBuilder xpathsToIdAttributes(
                String xpathsToIdAttributes) {
            setProperty("xpathsToIdAttributes", xpathsToIdAttributes);
            return this;
        }
        /**
         * Provides the key for validating the XML signature.
         * 
         * The option is a: <code>javax.xml.crypto.KeySelector</code> type.
         * 
         * Group: verify
         */
        default XmlSignatureEndpointBuilder keySelector(Object keySelector) {
            setProperty("keySelector", keySelector);
            return this;
        }
        /**
         * Provides the key for validating the XML signature.
         * 
         * The option will be converted to a
         * <code>javax.xml.crypto.KeySelector</code> type.
         * 
         * Group: verify
         */
        default XmlSignatureEndpointBuilder keySelector(String keySelector) {
            setProperty("keySelector", keySelector);
            return this;
        }
        /**
         * Sets the output node search value for determining the node from the
         * XML signature document which shall be set to the output message body.
         * The class of the value depends on the type of the output node search.
         * The output node search is forwarded to XmlSignature2Message.
         * 
         * The option is a: <code>java.lang.Object</code> type.
         * 
         * Group: verify
         */
        default XmlSignatureEndpointBuilder outputNodeSearch(
                Object outputNodeSearch) {
            setProperty("outputNodeSearch", outputNodeSearch);
            return this;
        }
        /**
         * Sets the output node search value for determining the node from the
         * XML signature document which shall be set to the output message body.
         * The class of the value depends on the type of the output node search.
         * The output node search is forwarded to XmlSignature2Message.
         * 
         * The option will be converted to a <code>java.lang.Object</code> type.
         * 
         * Group: verify
         */
        default XmlSignatureEndpointBuilder outputNodeSearch(
                String outputNodeSearch) {
            setProperty("outputNodeSearch", outputNodeSearch);
            return this;
        }
        /**
         * Determines the search type for determining the output node which is
         * serialized into the output message bodyF. See
         * setOutputNodeSearch(Object). The supported default search types you
         * can find in DefaultXmlSignature2Message.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: verify
         */
        default XmlSignatureEndpointBuilder outputNodeSearchType(
                String outputNodeSearchType) {
            setProperty("outputNodeSearchType", outputNodeSearchType);
            return this;
        }
        /**
         * Indicator whether the XML signature elements (elements with local
         * name Signature and namesapce http://www.w3.org/2000/09/xmldsig#)
         * shall be removed from the document set to the output message.
         * Normally, this is only necessary, if the XML signature is enveloped.
         * The default value is Boolean#FALSE. This parameter is forwarded to
         * XmlSignature2Message. This indicator has no effect if the output node
         * search is of type
         * DefaultXmlSignature2Message#OUTPUT_NODE_SEARCH_TYPE_DEFAULT.F.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: verify
         */
        default XmlSignatureEndpointBuilder removeSignatureElements(
                Boolean removeSignatureElements) {
            setProperty("removeSignatureElements", removeSignatureElements);
            return this;
        }
        /**
         * Indicator whether the XML signature elements (elements with local
         * name Signature and namesapce http://www.w3.org/2000/09/xmldsig#)
         * shall be removed from the document set to the output message.
         * Normally, this is only necessary, if the XML signature is enveloped.
         * The default value is Boolean#FALSE. This parameter is forwarded to
         * XmlSignature2Message. This indicator has no effect if the output node
         * search is of type
         * DefaultXmlSignature2Message#OUTPUT_NODE_SEARCH_TYPE_DEFAULT.F.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: verify
         */
        default XmlSignatureEndpointBuilder removeSignatureElements(
                String removeSignatureElements) {
            setProperty("removeSignatureElements", removeSignatureElements);
            return this;
        }
        /**
         * Enables secure validation. If true then secure validation is enabled.
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: verify
         */
        default XmlSignatureEndpointBuilder secureValidation(
                Boolean secureValidation) {
            setProperty("secureValidation", secureValidation);
            return this;
        }
        /**
         * Enables secure validation. If true then secure validation is enabled.
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: verify
         */
        default XmlSignatureEndpointBuilder secureValidation(
                String secureValidation) {
            setProperty("secureValidation", secureValidation);
            return this;
        }
        /**
         * Handles the different validation failed situations. The default
         * implementation throws specific exceptions for the different
         * situations (All exceptions have the package name
         * org.apache.camel.component.xmlsecurity.api and are a sub-class of
         * XmlSignatureInvalidException. If the signature value validation
         * fails, a XmlSignatureInvalidValueException is thrown. If a reference
         * validation fails, a XmlSignatureInvalidContentHashException is
         * thrown. For more detailed information, see the JavaDoc.
         * 
         * The option is a:
         * <code>org.apache.camel.component.xmlsecurity.api.ValidationFailedHandler</code> type.
         * 
         * Group: verify
         */
        default XmlSignatureEndpointBuilder validationFailedHandler(
                Object validationFailedHandler) {
            setProperty("validationFailedHandler", validationFailedHandler);
            return this;
        }
        /**
         * Handles the different validation failed situations. The default
         * implementation throws specific exceptions for the different
         * situations (All exceptions have the package name
         * org.apache.camel.component.xmlsecurity.api and are a sub-class of
         * XmlSignatureInvalidException. If the signature value validation
         * fails, a XmlSignatureInvalidValueException is thrown. If a reference
         * validation fails, a XmlSignatureInvalidContentHashException is
         * thrown. For more detailed information, see the JavaDoc.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.xmlsecurity.api.ValidationFailedHandler</code> type.
         * 
         * Group: verify
         */
        default XmlSignatureEndpointBuilder validationFailedHandler(
                String validationFailedHandler) {
            setProperty("validationFailedHandler", validationFailedHandler);
            return this;
        }
        /**
         * Bean which maps the XML signature to the output-message after the
         * validation. How this mapping should be done can be configured by the
         * options outputNodeSearchType, outputNodeSearch, and
         * removeSignatureElements. The default implementation offers three
         * possibilities which are related to the three output node search types
         * Default, ElementName, and XPath. The default implementation
         * determines a node which is then serialized and set to the body of the
         * output message If the search type is ElementName then the output node
         * (which must be in this case an element) is determined by the local
         * name and namespace defined in the search value (see option
         * outputNodeSearch). If the search type is XPath then the output node
         * is determined by the XPath specified in the search value (in this
         * case the output node can be of type Element, TextNode or Document).
         * If the output node search type is Default then the following rules
         * apply: In the enveloped XML signature case (there is a reference with
         * URI= and transform
         * http://www.w3.org/2000/09/xmldsig#enveloped-signature), the incoming
         * XML document without the Signature element is set to the output
         * message body. In the non-enveloped XML signature case, the message
         * body is determined from a referenced Object; this is explained in
         * more detail in chapter Output Node Determination in Enveloping XML
         * Signature Case.
         * 
         * The option is a:
         * <code>org.apache.camel.component.xmlsecurity.api.XmlSignature2Message</code> type.
         * 
         * Group: verify
         */
        default XmlSignatureEndpointBuilder xmlSignature2Message(
                Object xmlSignature2Message) {
            setProperty("xmlSignature2Message", xmlSignature2Message);
            return this;
        }
        /**
         * Bean which maps the XML signature to the output-message after the
         * validation. How this mapping should be done can be configured by the
         * options outputNodeSearchType, outputNodeSearch, and
         * removeSignatureElements. The default implementation offers three
         * possibilities which are related to the three output node search types
         * Default, ElementName, and XPath. The default implementation
         * determines a node which is then serialized and set to the body of the
         * output message If the search type is ElementName then the output node
         * (which must be in this case an element) is determined by the local
         * name and namespace defined in the search value (see option
         * outputNodeSearch). If the search type is XPath then the output node
         * is determined by the XPath specified in the search value (in this
         * case the output node can be of type Element, TextNode or Document).
         * If the output node search type is Default then the following rules
         * apply: In the enveloped XML signature case (there is a reference with
         * URI= and transform
         * http://www.w3.org/2000/09/xmldsig#enveloped-signature), the incoming
         * XML document without the Signature element is set to the output
         * message body. In the non-enveloped XML signature case, the message
         * body is determined from a referenced Object; this is explained in
         * more detail in chapter Output Node Determination in Enveloping XML
         * Signature Case.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.xmlsecurity.api.XmlSignature2Message</code> type.
         * 
         * Group: verify
         */
        default XmlSignatureEndpointBuilder xmlSignature2Message(
                String xmlSignature2Message) {
            setProperty("xmlSignature2Message", xmlSignature2Message);
            return this;
        }
        /**
         * This interface allows the application to check the XML signature
         * before the validation is executed. This step is recommended in
         * http://www.w3.org/TR/xmldsig-bestpractices/#check-what-is-signed.
         * 
         * The option is a:
         * <code>org.apache.camel.component.xmlsecurity.api.XmlSignatureChecker</code> type.
         * 
         * Group: verify
         */
        default XmlSignatureEndpointBuilder xmlSignatureChecker(
                Object xmlSignatureChecker) {
            setProperty("xmlSignatureChecker", xmlSignatureChecker);
            return this;
        }
        /**
         * This interface allows the application to check the XML signature
         * before the validation is executed. This step is recommended in
         * http://www.w3.org/TR/xmldsig-bestpractices/#check-what-is-signed.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.xmlsecurity.api.XmlSignatureChecker</code> type.
         * 
         * Group: verify
         */
        default XmlSignatureEndpointBuilder xmlSignatureChecker(
                String xmlSignatureChecker) {
            setProperty("xmlSignatureChecker", xmlSignatureChecker);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the XML Security component.
     */
    public interface AdvancedXmlSignatureEndpointBuilder
            extends
                EndpointProducerBuilder {
        default XmlSignatureEndpointBuilder basic() {
            return (XmlSignatureEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedXmlSignatureEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedXmlSignatureEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedXmlSignatureEndpointBuilder synchronous(
                boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedXmlSignatureEndpointBuilder synchronous(
                String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * If you want to restrict the remote access via reference URIs, you can
         * set an own dereferencer. Optional parameter. If not set the provider
         * default dereferencer is used which can resolve URI fragments, HTTP,
         * file and XPpointer URIs. Attention: The implementation is provider
         * dependent!.
         * 
         * The option is a: <code>javax.xml.crypto.URIDereferencer</code> type.
         * 
         * Group: advanced
         */
        default AdvancedXmlSignatureEndpointBuilder uriDereferencer(
                Object uriDereferencer) {
            setProperty("uriDereferencer", uriDereferencer);
            return this;
        }
        /**
         * If you want to restrict the remote access via reference URIs, you can
         * set an own dereferencer. Optional parameter. If not set the provider
         * default dereferencer is used which can resolve URI fragments, HTTP,
         * file and XPpointer URIs. Attention: The implementation is provider
         * dependent!.
         * 
         * The option will be converted to a
         * <code>javax.xml.crypto.URIDereferencer</code> type.
         * 
         * Group: advanced
         */
        default AdvancedXmlSignatureEndpointBuilder uriDereferencer(
                String uriDereferencer) {
            setProperty("uriDereferencer", uriDereferencer);
            return this;
        }
    }
    /**
     * XML Security (camel-xmlsecurity)
     * Used to sign and verify exchanges using the XML signature specification.
     * 
     * Category: security,transformation
     * Available as of version: 2.12
     * Maven coordinates: org.apache.camel:camel-xmlsecurity
     * 
     * Syntax: <code>xmlsecurity:command:name</code>
     * 
     * Path parameter: command (required)
     * Whether to sign or verify.
     * The value can be one of: sign, verify
     * 
     * Path parameter: name (required)
     * The name part in the URI can be chosen by the user to distinguish between
     * different signer/verifier endpoints within the camel context.
     */
    default XmlSignatureEndpointBuilder xmlSignature(String path) {
        class XmlSignatureEndpointBuilderImpl extends AbstractEndpointBuilder implements XmlSignatureEndpointBuilder, AdvancedXmlSignatureEndpointBuilder {
            public XmlSignatureEndpointBuilderImpl(String path) {
                super("xmlsecurity", path);
            }
        }
        return new XmlSignatureEndpointBuilderImpl(path);
    }
}