/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.spi.ScheduledPollConsumerScheduler;

/**
 * Transforms the message using a XQuery template using Saxon.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface XQueryEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the XQuery component.
     */
    public interface XQueryEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedXQueryEndpointConsumerBuilder advanced() {
            return (AdvancedXQueryEndpointConsumerBuilder) this;
        }
        /**
         * Whether to allow using StAX mode.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default XQueryEndpointConsumerBuilder allowStAX(boolean allowStAX) {
            setProperty("allowStAX", allowStAX);
            return this;
        }
        /**
         * Whether to allow using StAX mode.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default XQueryEndpointConsumerBuilder allowStAX(String allowStAX) {
            setProperty("allowStAX", allowStAX);
            return this;
        }
        /**
         * To use a Camel Message header as the input source instead of Message
         * body.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default XQueryEndpointConsumerBuilder headerName(String headerName) {
            setProperty("headerName", headerName);
            return this;
        }
        /**
         * Allows to control which namespace prefixes to use for a set of
         * namespace mappings.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default XQueryEndpointConsumerBuilder namespacePrefixes(
                Map<String, String> namespacePrefixes) {
            setProperty("namespacePrefixes", namespacePrefixes);
            return this;
        }
        /**
         * Allows to control which namespace prefixes to use for a set of
         * namespace mappings.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default XQueryEndpointConsumerBuilder namespacePrefixes(
                String namespacePrefixes) {
            setProperty("namespacePrefixes", namespacePrefixes);
            return this;
        }
        /**
         * What output result to use.
         * 
         * The option is a:
         * <code>org.apache.camel.component.xquery.ResultFormat</code> type.
         * 
         * Group: common
         */
        default XQueryEndpointConsumerBuilder resultsFormat(
                ResultFormat resultsFormat) {
            setProperty("resultsFormat", resultsFormat);
            return this;
        }
        /**
         * What output result to use.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.xquery.ResultFormat</code> type.
         * 
         * Group: common
         */
        default XQueryEndpointConsumerBuilder resultsFormat(String resultsFormat) {
            setProperty("resultsFormat", resultsFormat);
            return this;
        }
        /**
         * What output result to use defined as a class.
         * 
         * The option is a: <code>java.lang.Class&lt;java.lang.Object&gt;</code>
         * type.
         * 
         * Group: common
         */
        default XQueryEndpointConsumerBuilder resultType(
                Class<Object> resultType) {
            setProperty("resultType", resultType);
            return this;
        }
        /**
         * What output result to use defined as a class.
         * 
         * The option will be converted to a
         * <code>java.lang.Class&lt;java.lang.Object&gt;</code> type.
         * 
         * Group: common
         */
        default XQueryEndpointConsumerBuilder resultType(String resultType) {
            setProperty("resultType", resultType);
            return this;
        }
        /**
         * Whether to strip all whitespaces.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default XQueryEndpointConsumerBuilder stripsAllWhiteSpace(
                boolean stripsAllWhiteSpace) {
            setProperty("stripsAllWhiteSpace", stripsAllWhiteSpace);
            return this;
        }
        /**
         * Whether to strip all whitespaces.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default XQueryEndpointConsumerBuilder stripsAllWhiteSpace(
                String stripsAllWhiteSpace) {
            setProperty("stripsAllWhiteSpace", stripsAllWhiteSpace);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default XQueryEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            setProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default XQueryEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            setProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default XQueryEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                boolean sendEmptyMessageWhenIdle) {
            setProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default XQueryEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                String sendEmptyMessageWhenIdle) {
            setProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default XQueryEndpointConsumerBuilder backoffErrorThreshold(
                int backoffErrorThreshold) {
            setProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default XQueryEndpointConsumerBuilder backoffErrorThreshold(
                String backoffErrorThreshold) {
            setProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default XQueryEndpointConsumerBuilder backoffIdleThreshold(
                int backoffIdleThreshold) {
            setProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default XQueryEndpointConsumerBuilder backoffIdleThreshold(
                String backoffIdleThreshold) {
            setProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default XQueryEndpointConsumerBuilder backoffMultiplier(
                int backoffMultiplier) {
            setProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default XQueryEndpointConsumerBuilder backoffMultiplier(
                String backoffMultiplier) {
            setProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * Milliseconds before the next poll. You can also specify time values
         * using units, such as 60s (60 seconds), 5m30s (5 minutes and 30
         * seconds), and 1h (1 hour).
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: scheduler
         */
        default XQueryEndpointConsumerBuilder delay(long delay) {
            setProperty("delay", delay);
            return this;
        }
        /**
         * Milliseconds before the next poll. You can also specify time values
         * using units, such as 60s (60 seconds), 5m30s (5 minutes and 30
         * seconds), and 1h (1 hour).
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: scheduler
         */
        default XQueryEndpointConsumerBuilder delay(String delay) {
            setProperty("delay", delay);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default XQueryEndpointConsumerBuilder greedy(boolean greedy) {
            setProperty("greedy", greedy);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default XQueryEndpointConsumerBuilder greedy(String greedy) {
            setProperty("greedy", greedy);
            return this;
        }
        /**
         * Milliseconds before the first poll starts. You can also specify time
         * values using units, such as 60s (60 seconds), 5m30s (5 minutes and 30
         * seconds), and 1h (1 hour).
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: scheduler
         */
        default XQueryEndpointConsumerBuilder initialDelay(long initialDelay) {
            setProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Milliseconds before the first poll starts. You can also specify time
         * values using units, such as 60s (60 seconds), 5m30s (5 minutes and 30
         * seconds), and 1h (1 hour).
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: scheduler
         */
        default XQueryEndpointConsumerBuilder initialDelay(String initialDelay) {
            setProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option is a: <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Group: scheduler
         */
        default XQueryEndpointConsumerBuilder runLoggingLevel(
                LoggingLevel runLoggingLevel) {
            setProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Group: scheduler
         */
        default XQueryEndpointConsumerBuilder runLoggingLevel(
                String runLoggingLevel) {
            setProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option is a:
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         */
        default XQueryEndpointConsumerBuilder scheduledExecutorService(
                ScheduledExecutorService scheduledExecutorService) {
            setProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         */
        default XQueryEndpointConsumerBuilder scheduledExecutorService(
                String scheduledExecutorService) {
            setProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz2
         * component.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.ScheduledPollConsumerScheduler</code>
         * type.
         * 
         * Group: scheduler
         */
        default XQueryEndpointConsumerBuilder scheduler(
                ScheduledPollConsumerScheduler scheduler) {
            setProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz2
         * component.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ScheduledPollConsumerScheduler</code>
         * type.
         * 
         * Group: scheduler
         */
        default XQueryEndpointConsumerBuilder scheduler(String scheduler) {
            setProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz2, Spring based scheduler.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: scheduler
         */
        default XQueryEndpointConsumerBuilder schedulerProperties(
                Map<String, Object> schedulerProperties) {
            setProperty("schedulerProperties", schedulerProperties);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz2, Spring based scheduler.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: scheduler
         */
        default XQueryEndpointConsumerBuilder schedulerProperties(
                String schedulerProperties) {
            setProperty("schedulerProperties", schedulerProperties);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default XQueryEndpointConsumerBuilder startScheduler(
                boolean startScheduler) {
            setProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default XQueryEndpointConsumerBuilder startScheduler(
                String startScheduler) {
            setProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option is a: <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Group: scheduler
         */
        default XQueryEndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            setProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Group: scheduler
         */
        default XQueryEndpointConsumerBuilder timeUnit(String timeUnit) {
            setProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default XQueryEndpointConsumerBuilder useFixedDelay(
                boolean useFixedDelay) {
            setProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default XQueryEndpointConsumerBuilder useFixedDelay(String useFixedDelay) {
            setProperty("useFixedDelay", useFixedDelay);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the XQuery component.
     */
    public interface AdvancedXQueryEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default XQueryEndpointConsumerBuilder basic() {
            return (XQueryEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedXQueryEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            setProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedXQueryEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            setProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedXQueryEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            setProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedXQueryEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            setProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedXQueryEndpointConsumerBuilder pollStrategy(
                PollingConsumerPollStrategy pollStrategy) {
            setProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedXQueryEndpointConsumerBuilder pollStrategy(
                String pollStrategy) {
            setProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * To use a custom Saxon configuration.
         * 
         * The option is a: <code>net.sf.saxon.Configuration</code> type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointConsumerBuilder configuration(
                Object configuration) {
            setProperty("configuration", configuration);
            return this;
        }
        /**
         * To use a custom Saxon configuration.
         * 
         * The option will be converted to a
         * <code>net.sf.saxon.Configuration</code> type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointConsumerBuilder configuration(
                String configuration) {
            setProperty("configuration", configuration);
            return this;
        }
        /**
         * To set custom Saxon configuration properties.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointConsumerBuilder configurationProperties(
                Map<String, Object> configurationProperties) {
            setProperty("configurationProperties", configurationProperties);
            return this;
        }
        /**
         * To set custom Saxon configuration properties.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointConsumerBuilder configurationProperties(
                String configurationProperties) {
            setProperty("configurationProperties", configurationProperties);
            return this;
        }
        /**
         * To use the custom ModuleURIResolver.
         * 
         * The option is a: <code>net.sf.saxon.lib.ModuleURIResolver</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointConsumerBuilder moduleURIResolver(
                Object moduleURIResolver) {
            setProperty("moduleURIResolver", moduleURIResolver);
            return this;
        }
        /**
         * To use the custom ModuleURIResolver.
         * 
         * The option will be converted to a
         * <code>net.sf.saxon.lib.ModuleURIResolver</code> type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointConsumerBuilder moduleURIResolver(
                String moduleURIResolver) {
            setProperty("moduleURIResolver", moduleURIResolver);
            return this;
        }
        /**
         * Additional parameters.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointConsumerBuilder parameters(
                Map<String, Object> parameters) {
            setProperty("parameters", parameters);
            return this;
        }
        /**
         * Additional parameters.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointConsumerBuilder parameters(
                String parameters) {
            setProperty("parameters", parameters);
            return this;
        }
        /**
         * Properties to configure the serialization parameters.
         * 
         * The option is a: <code>java.util.Properties</code> type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointConsumerBuilder properties(
                Properties properties) {
            setProperty("properties", properties);
            return this;
        }
        /**
         * Properties to configure the serialization parameters.
         * 
         * The option will be converted to a <code>java.util.Properties</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointConsumerBuilder properties(
                String properties) {
            setProperty("properties", properties);
            return this;
        }
        /**
         * To use a custom Saxon StaticQueryContext.
         * 
         * The option is a: <code>net.sf.saxon.query.StaticQueryContext</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointConsumerBuilder staticQueryContext(
                Object staticQueryContext) {
            setProperty("staticQueryContext", staticQueryContext);
            return this;
        }
        /**
         * To use a custom Saxon StaticQueryContext.
         * 
         * The option will be converted to a
         * <code>net.sf.saxon.query.StaticQueryContext</code> type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointConsumerBuilder staticQueryContext(
                String staticQueryContext) {
            setProperty("staticQueryContext", staticQueryContext);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointConsumerBuilder synchronous(
                String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the XQuery component.
     */
    public interface XQueryEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedXQueryEndpointProducerBuilder advanced() {
            return (AdvancedXQueryEndpointProducerBuilder) this;
        }
        /**
         * Whether to allow using StAX mode.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default XQueryEndpointProducerBuilder allowStAX(boolean allowStAX) {
            setProperty("allowStAX", allowStAX);
            return this;
        }
        /**
         * Whether to allow using StAX mode.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default XQueryEndpointProducerBuilder allowStAX(String allowStAX) {
            setProperty("allowStAX", allowStAX);
            return this;
        }
        /**
         * To use a Camel Message header as the input source instead of Message
         * body.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default XQueryEndpointProducerBuilder headerName(String headerName) {
            setProperty("headerName", headerName);
            return this;
        }
        /**
         * Allows to control which namespace prefixes to use for a set of
         * namespace mappings.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default XQueryEndpointProducerBuilder namespacePrefixes(
                Map<String, String> namespacePrefixes) {
            setProperty("namespacePrefixes", namespacePrefixes);
            return this;
        }
        /**
         * Allows to control which namespace prefixes to use for a set of
         * namespace mappings.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default XQueryEndpointProducerBuilder namespacePrefixes(
                String namespacePrefixes) {
            setProperty("namespacePrefixes", namespacePrefixes);
            return this;
        }
        /**
         * What output result to use.
         * 
         * The option is a:
         * <code>org.apache.camel.component.xquery.ResultFormat</code> type.
         * 
         * Group: common
         */
        default XQueryEndpointProducerBuilder resultsFormat(
                ResultFormat resultsFormat) {
            setProperty("resultsFormat", resultsFormat);
            return this;
        }
        /**
         * What output result to use.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.xquery.ResultFormat</code> type.
         * 
         * Group: common
         */
        default XQueryEndpointProducerBuilder resultsFormat(String resultsFormat) {
            setProperty("resultsFormat", resultsFormat);
            return this;
        }
        /**
         * What output result to use defined as a class.
         * 
         * The option is a: <code>java.lang.Class&lt;java.lang.Object&gt;</code>
         * type.
         * 
         * Group: common
         */
        default XQueryEndpointProducerBuilder resultType(
                Class<Object> resultType) {
            setProperty("resultType", resultType);
            return this;
        }
        /**
         * What output result to use defined as a class.
         * 
         * The option will be converted to a
         * <code>java.lang.Class&lt;java.lang.Object&gt;</code> type.
         * 
         * Group: common
         */
        default XQueryEndpointProducerBuilder resultType(String resultType) {
            setProperty("resultType", resultType);
            return this;
        }
        /**
         * Whether to strip all whitespaces.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default XQueryEndpointProducerBuilder stripsAllWhiteSpace(
                boolean stripsAllWhiteSpace) {
            setProperty("stripsAllWhiteSpace", stripsAllWhiteSpace);
            return this;
        }
        /**
         * Whether to strip all whitespaces.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default XQueryEndpointProducerBuilder stripsAllWhiteSpace(
                String stripsAllWhiteSpace) {
            setProperty("stripsAllWhiteSpace", stripsAllWhiteSpace);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default XQueryEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            setProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default XQueryEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            setProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the XQuery component.
     */
    public interface AdvancedXQueryEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default XQueryEndpointProducerBuilder basic() {
            return (XQueryEndpointProducerBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * To use a custom Saxon configuration.
         * 
         * The option is a: <code>net.sf.saxon.Configuration</code> type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointProducerBuilder configuration(
                Object configuration) {
            setProperty("configuration", configuration);
            return this;
        }
        /**
         * To use a custom Saxon configuration.
         * 
         * The option will be converted to a
         * <code>net.sf.saxon.Configuration</code> type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointProducerBuilder configuration(
                String configuration) {
            setProperty("configuration", configuration);
            return this;
        }
        /**
         * To set custom Saxon configuration properties.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointProducerBuilder configurationProperties(
                Map<String, Object> configurationProperties) {
            setProperty("configurationProperties", configurationProperties);
            return this;
        }
        /**
         * To set custom Saxon configuration properties.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointProducerBuilder configurationProperties(
                String configurationProperties) {
            setProperty("configurationProperties", configurationProperties);
            return this;
        }
        /**
         * To use the custom ModuleURIResolver.
         * 
         * The option is a: <code>net.sf.saxon.lib.ModuleURIResolver</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointProducerBuilder moduleURIResolver(
                Object moduleURIResolver) {
            setProperty("moduleURIResolver", moduleURIResolver);
            return this;
        }
        /**
         * To use the custom ModuleURIResolver.
         * 
         * The option will be converted to a
         * <code>net.sf.saxon.lib.ModuleURIResolver</code> type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointProducerBuilder moduleURIResolver(
                String moduleURIResolver) {
            setProperty("moduleURIResolver", moduleURIResolver);
            return this;
        }
        /**
         * Additional parameters.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointProducerBuilder parameters(
                Map<String, Object> parameters) {
            setProperty("parameters", parameters);
            return this;
        }
        /**
         * Additional parameters.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointProducerBuilder parameters(
                String parameters) {
            setProperty("parameters", parameters);
            return this;
        }
        /**
         * Properties to configure the serialization parameters.
         * 
         * The option is a: <code>java.util.Properties</code> type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointProducerBuilder properties(
                Properties properties) {
            setProperty("properties", properties);
            return this;
        }
        /**
         * Properties to configure the serialization parameters.
         * 
         * The option will be converted to a <code>java.util.Properties</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointProducerBuilder properties(
                String properties) {
            setProperty("properties", properties);
            return this;
        }
        /**
         * To use a custom Saxon StaticQueryContext.
         * 
         * The option is a: <code>net.sf.saxon.query.StaticQueryContext</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointProducerBuilder staticQueryContext(
                Object staticQueryContext) {
            setProperty("staticQueryContext", staticQueryContext);
            return this;
        }
        /**
         * To use a custom Saxon StaticQueryContext.
         * 
         * The option will be converted to a
         * <code>net.sf.saxon.query.StaticQueryContext</code> type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointProducerBuilder staticQueryContext(
                String staticQueryContext) {
            setProperty("staticQueryContext", staticQueryContext);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointProducerBuilder synchronous(
                boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointProducerBuilder synchronous(
                String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the XQuery component.
     */
    public interface XQueryEndpointBuilder
            extends
                XQueryEndpointConsumerBuilder, XQueryEndpointProducerBuilder {
        default AdvancedXQueryEndpointBuilder advanced() {
            return (AdvancedXQueryEndpointBuilder) this;
        }
        /**
         * Whether to allow using StAX mode.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default XQueryEndpointBuilder allowStAX(boolean allowStAX) {
            setProperty("allowStAX", allowStAX);
            return this;
        }
        /**
         * Whether to allow using StAX mode.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default XQueryEndpointBuilder allowStAX(String allowStAX) {
            setProperty("allowStAX", allowStAX);
            return this;
        }
        /**
         * To use a Camel Message header as the input source instead of Message
         * body.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default XQueryEndpointBuilder headerName(String headerName) {
            setProperty("headerName", headerName);
            return this;
        }
        /**
         * Allows to control which namespace prefixes to use for a set of
         * namespace mappings.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.String&gt;</code> type.
         * 
         * Group: common
         */
        default XQueryEndpointBuilder namespacePrefixes(
                Map<String, String> namespacePrefixes) {
            setProperty("namespacePrefixes", namespacePrefixes);
            return this;
        }
        /**
         * Allows to control which namespace prefixes to use for a set of
         * namespace mappings.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         */
        default XQueryEndpointBuilder namespacePrefixes(String namespacePrefixes) {
            setProperty("namespacePrefixes", namespacePrefixes);
            return this;
        }
        /**
         * What output result to use.
         * 
         * The option is a:
         * <code>org.apache.camel.component.xquery.ResultFormat</code> type.
         * 
         * Group: common
         */
        default XQueryEndpointBuilder resultsFormat(ResultFormat resultsFormat) {
            setProperty("resultsFormat", resultsFormat);
            return this;
        }
        /**
         * What output result to use.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.xquery.ResultFormat</code> type.
         * 
         * Group: common
         */
        default XQueryEndpointBuilder resultsFormat(String resultsFormat) {
            setProperty("resultsFormat", resultsFormat);
            return this;
        }
        /**
         * What output result to use defined as a class.
         * 
         * The option is a: <code>java.lang.Class&lt;java.lang.Object&gt;</code>
         * type.
         * 
         * Group: common
         */
        default XQueryEndpointBuilder resultType(Class<Object> resultType) {
            setProperty("resultType", resultType);
            return this;
        }
        /**
         * What output result to use defined as a class.
         * 
         * The option will be converted to a
         * <code>java.lang.Class&lt;java.lang.Object&gt;</code> type.
         * 
         * Group: common
         */
        default XQueryEndpointBuilder resultType(String resultType) {
            setProperty("resultType", resultType);
            return this;
        }
        /**
         * Whether to strip all whitespaces.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default XQueryEndpointBuilder stripsAllWhiteSpace(
                boolean stripsAllWhiteSpace) {
            setProperty("stripsAllWhiteSpace", stripsAllWhiteSpace);
            return this;
        }
        /**
         * Whether to strip all whitespaces.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default XQueryEndpointBuilder stripsAllWhiteSpace(
                String stripsAllWhiteSpace) {
            setProperty("stripsAllWhiteSpace", stripsAllWhiteSpace);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the XQuery component.
     */
    public interface AdvancedXQueryEndpointBuilder
            extends
                AdvancedXQueryEndpointConsumerBuilder, AdvancedXQueryEndpointProducerBuilder {
        default XQueryEndpointBuilder basic() {
            return (XQueryEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * To use a custom Saxon configuration.
         * 
         * The option is a: <code>net.sf.saxon.Configuration</code> type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointBuilder configuration(Object configuration) {
            setProperty("configuration", configuration);
            return this;
        }
        /**
         * To use a custom Saxon configuration.
         * 
         * The option will be converted to a
         * <code>net.sf.saxon.Configuration</code> type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointBuilder configuration(String configuration) {
            setProperty("configuration", configuration);
            return this;
        }
        /**
         * To set custom Saxon configuration properties.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointBuilder configurationProperties(
                Map<String, Object> configurationProperties) {
            setProperty("configurationProperties", configurationProperties);
            return this;
        }
        /**
         * To set custom Saxon configuration properties.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointBuilder configurationProperties(
                String configurationProperties) {
            setProperty("configurationProperties", configurationProperties);
            return this;
        }
        /**
         * To use the custom ModuleURIResolver.
         * 
         * The option is a: <code>net.sf.saxon.lib.ModuleURIResolver</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointBuilder moduleURIResolver(
                Object moduleURIResolver) {
            setProperty("moduleURIResolver", moduleURIResolver);
            return this;
        }
        /**
         * To use the custom ModuleURIResolver.
         * 
         * The option will be converted to a
         * <code>net.sf.saxon.lib.ModuleURIResolver</code> type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointBuilder moduleURIResolver(
                String moduleURIResolver) {
            setProperty("moduleURIResolver", moduleURIResolver);
            return this;
        }
        /**
         * Additional parameters.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointBuilder parameters(
                Map<String, Object> parameters) {
            setProperty("parameters", parameters);
            return this;
        }
        /**
         * Additional parameters.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointBuilder parameters(String parameters) {
            setProperty("parameters", parameters);
            return this;
        }
        /**
         * Properties to configure the serialization parameters.
         * 
         * The option is a: <code>java.util.Properties</code> type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointBuilder properties(Properties properties) {
            setProperty("properties", properties);
            return this;
        }
        /**
         * Properties to configure the serialization parameters.
         * 
         * The option will be converted to a <code>java.util.Properties</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointBuilder properties(String properties) {
            setProperty("properties", properties);
            return this;
        }
        /**
         * To use a custom Saxon StaticQueryContext.
         * 
         * The option is a: <code>net.sf.saxon.query.StaticQueryContext</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointBuilder staticQueryContext(
                Object staticQueryContext) {
            setProperty("staticQueryContext", staticQueryContext);
            return this;
        }
        /**
         * To use a custom Saxon StaticQueryContext.
         * 
         * The option will be converted to a
         * <code>net.sf.saxon.query.StaticQueryContext</code> type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointBuilder staticQueryContext(
                String staticQueryContext) {
            setProperty("staticQueryContext", staticQueryContext);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointBuilder synchronous(boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedXQueryEndpointBuilder synchronous(String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.xquery.ResultFormat</code> enum.
     */
    enum ResultFormat {
        Bytes,
        BytesSource,
        DOM,
        DOMSource,
        List,
        String,
        StringSource;
    }
    /**
     * XQuery (camel-saxon)
     * Transforms the message using a XQuery template using Saxon.
     * 
     * Category: transformation
     * Available as of version: 1.0
     * Maven coordinates: org.apache.camel:camel-saxon
     * 
     * Syntax: <code>xquery:resourceUri</code>
     * 
     * Path parameter: resourceUri (required)
     * The name of the template to load from classpath or file system
     */
    default XQueryEndpointBuilder xQuery(String path) {
        class XQueryEndpointBuilderImpl extends AbstractEndpointBuilder implements XQueryEndpointBuilder, AdvancedXQueryEndpointBuilder {
            public XQueryEndpointBuilderImpl(String path) {
                super("xquery", path);
            }
        }
        return new XQueryEndpointBuilderImpl(path);
    }
}