/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import javax.annotation.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * The camel-xchange component provide access to many bitcoin and altcoin
 * exchanges for trading and accessing market data.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface XChangeEndpointBuilderFactory {


    /**
     * Builder for endpoint for the XChange component.
     */
    public interface XChangeEndpointBuilder extends EndpointProducerBuilder {
        default AdvancedXChangeEndpointBuilder advanced() {
            return (AdvancedXChangeEndpointBuilder) this;
        }
        /**
         * The currency.
         * 
         * The option is a: <code>org.knowm.xchange.currency.Currency</code>
         * type.
         * 
         * Group: producer
         */
        default XChangeEndpointBuilder currency(Object currency) {
            setProperty("currency", currency);
            return this;
        }
        /**
         * The currency.
         * 
         * The option will be converted to a
         * <code>org.knowm.xchange.currency.Currency</code> type.
         * 
         * Group: producer
         */
        default XChangeEndpointBuilder currency(String currency) {
            setProperty("currency", currency);
            return this;
        }
        /**
         * The currency pair.
         * 
         * The option is a: <code>org.knowm.xchange.currency.CurrencyPair</code>
         * type.
         * 
         * Group: producer
         */
        default XChangeEndpointBuilder currencyPair(Object currencyPair) {
            setProperty("currencyPair", currencyPair);
            return this;
        }
        /**
         * The currency pair.
         * 
         * The option will be converted to a
         * <code>org.knowm.xchange.currency.CurrencyPair</code> type.
         * 
         * Group: producer
         */
        default XChangeEndpointBuilder currencyPair(String currencyPair) {
            setProperty("currencyPair", currencyPair);
            return this;
        }
        /**
         * The method to execute.
         * 
         * The option is a:
         * <code>org.apache.camel.component.xchange.XChangeConfiguration$XChangeMethod</code> type.
         * 
         * Required: true
         * Group: producer
         */
        default XChangeEndpointBuilder method(XChangeMethod method) {
            setProperty("method", method);
            return this;
        }
        /**
         * The method to execute.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.xchange.XChangeConfiguration$XChangeMethod</code> type.
         * 
         * Required: true
         * Group: producer
         */
        default XChangeEndpointBuilder method(String method) {
            setProperty("method", method);
            return this;
        }
        /**
         * The service to call.
         * 
         * The option is a:
         * <code>org.apache.camel.component.xchange.XChangeConfiguration$XChangeService</code> type.
         * 
         * Required: true
         * Group: producer
         */
        default XChangeEndpointBuilder service(XChangeService service) {
            setProperty("service", service);
            return this;
        }
        /**
         * The service to call.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.xchange.XChangeConfiguration$XChangeService</code> type.
         * 
         * Required: true
         * Group: producer
         */
        default XChangeEndpointBuilder service(String service) {
            setProperty("service", service);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the XChange component.
     */
    public interface AdvancedXChangeEndpointBuilder
            extends
                EndpointProducerBuilder {
        default XChangeEndpointBuilder basic() {
            return (XChangeEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedXChangeEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedXChangeEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedXChangeEndpointBuilder synchronous(boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedXChangeEndpointBuilder synchronous(String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.xchange.XChangeConfiguration$XChangeMethod</code> enum.
     */
    enum XChangeMethod {
        balances,
        fundingHistory,
        wallets,
        currencies,
        currencyMetaData,
        currencyPairs,
        currencyPairMetaData,
        ticker;
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.xchange.XChangeConfiguration$XChangeService</code> enum.
     */
    enum XChangeService {
        marketdata,
        metadata,
        account;
    }
    /**
     * XChange (camel-xchange)
     * The camel-xchange component provide access to many bitcoin and altcoin
     * exchanges for trading and accessing market data.
     * 
     * Category: bitcoin,blockchain
     * Available as of version: 2.21
     * Maven coordinates: org.apache.camel:camel-xchange
     * 
     * Syntax: <code>xchange:name</code>
     * 
     * Path parameter: name (required)
     * The exchange to connect to
     */
    default XChangeEndpointBuilder xChange(String path) {
        class XChangeEndpointBuilderImpl extends AbstractEndpointBuilder implements XChangeEndpointBuilder, AdvancedXChangeEndpointBuilder {
            public XChangeEndpointBuilderImpl(String path) {
                super("xchange", path);
            }
        }
        return new XChangeEndpointBuilderImpl(path);
    }
}