/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.spi.ScheduledPollConsumerScheduler;

/**
 * The Twitter Search component consumes search results.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface TwitterSearchEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Twitter Search component.
     */
    public interface TwitterSearchEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedTwitterSearchEndpointConsumerBuilder advanced() {
            return (AdvancedTwitterSearchEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default TwitterSearchEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            setProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default TwitterSearchEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            setProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default TwitterSearchEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                boolean sendEmptyMessageWhenIdle) {
            setProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default TwitterSearchEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                String sendEmptyMessageWhenIdle) {
            setProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * Endpoint type to use. Only streaming supports event type.
         * 
         * The option is a:
         * <code>org.apache.camel.component.twitter.data.EndpointType</code>
         * type.
         * 
         * Group: consumer
         */
        default TwitterSearchEndpointConsumerBuilder type(EndpointType type) {
            setProperty("type", type);
            return this;
        }
        /**
         * Endpoint type to use. Only streaming supports event type.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.twitter.data.EndpointType</code>
         * type.
         * 
         * Group: consumer
         */
        default TwitterSearchEndpointConsumerBuilder type(String type) {
            setProperty("type", type);
            return this;
        }
        /**
         * Limiting number of results per page.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: filter
         */
        default TwitterSearchEndpointConsumerBuilder count(Integer count) {
            setProperty("count", count);
            return this;
        }
        /**
         * Limiting number of results per page.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: filter
         */
        default TwitterSearchEndpointConsumerBuilder count(String count) {
            setProperty("count", count);
            return this;
        }
        /**
         * Filter out old tweets, that has previously been polled. This state is
         * stored in memory only, and based on last tweet id.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: filter
         */
        default TwitterSearchEndpointConsumerBuilder filterOld(boolean filterOld) {
            setProperty("filterOld", filterOld);
            return this;
        }
        /**
         * Filter out old tweets, that has previously been polled. This state is
         * stored in memory only, and based on last tweet id.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: filter
         */
        default TwitterSearchEndpointConsumerBuilder filterOld(String filterOld) {
            setProperty("filterOld", filterOld);
            return this;
        }
        /**
         * The lang string ISO_639-1 which will be used for searching.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: filter
         */
        default TwitterSearchEndpointConsumerBuilder lang(String lang) {
            setProperty("lang", lang);
            return this;
        }
        /**
         * The number of pages result which you want camel-twitter to consume.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: filter
         */
        default TwitterSearchEndpointConsumerBuilder numberOfPages(
                Integer numberOfPages) {
            setProperty("numberOfPages", numberOfPages);
            return this;
        }
        /**
         * The number of pages result which you want camel-twitter to consume.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: filter
         */
        default TwitterSearchEndpointConsumerBuilder numberOfPages(
                String numberOfPages) {
            setProperty("numberOfPages", numberOfPages);
            return this;
        }
        /**
         * The last tweet id which will be used for pulling the tweets. It is
         * useful when the camel route is restarted after a long running.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: filter
         */
        default TwitterSearchEndpointConsumerBuilder sinceId(long sinceId) {
            setProperty("sinceId", sinceId);
            return this;
        }
        /**
         * The last tweet id which will be used for pulling the tweets. It is
         * useful when the camel route is restarted after a long running.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: filter
         */
        default TwitterSearchEndpointConsumerBuilder sinceId(String sinceId) {
            setProperty("sinceId", sinceId);
            return this;
        }
        /**
         * To filter by user ids for streaming/filter. Multiple values can be
         * separated by comma.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: filter
         */
        default TwitterSearchEndpointConsumerBuilder userIds(String userIds) {
            setProperty("userIds", userIds);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default TwitterSearchEndpointConsumerBuilder backoffErrorThreshold(
                int backoffErrorThreshold) {
            setProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default TwitterSearchEndpointConsumerBuilder backoffErrorThreshold(
                String backoffErrorThreshold) {
            setProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default TwitterSearchEndpointConsumerBuilder backoffIdleThreshold(
                int backoffIdleThreshold) {
            setProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default TwitterSearchEndpointConsumerBuilder backoffIdleThreshold(
                String backoffIdleThreshold) {
            setProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default TwitterSearchEndpointConsumerBuilder backoffMultiplier(
                int backoffMultiplier) {
            setProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default TwitterSearchEndpointConsumerBuilder backoffMultiplier(
                String backoffMultiplier) {
            setProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: scheduler
         */
        default TwitterSearchEndpointConsumerBuilder delay(long delay) {
            setProperty("delay", delay);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: scheduler
         */
        default TwitterSearchEndpointConsumerBuilder delay(String delay) {
            setProperty("delay", delay);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default TwitterSearchEndpointConsumerBuilder greedy(boolean greedy) {
            setProperty("greedy", greedy);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default TwitterSearchEndpointConsumerBuilder greedy(String greedy) {
            setProperty("greedy", greedy);
            return this;
        }
        /**
         * Milliseconds before the first poll starts. You can also specify time
         * values using units, such as 60s (60 seconds), 5m30s (5 minutes and 30
         * seconds), and 1h (1 hour).
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: scheduler
         */
        default TwitterSearchEndpointConsumerBuilder initialDelay(
                long initialDelay) {
            setProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Milliseconds before the first poll starts. You can also specify time
         * values using units, such as 60s (60 seconds), 5m30s (5 minutes and 30
         * seconds), and 1h (1 hour).
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: scheduler
         */
        default TwitterSearchEndpointConsumerBuilder initialDelay(
                String initialDelay) {
            setProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option is a: <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Group: scheduler
         */
        default TwitterSearchEndpointConsumerBuilder runLoggingLevel(
                LoggingLevel runLoggingLevel) {
            setProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Group: scheduler
         */
        default TwitterSearchEndpointConsumerBuilder runLoggingLevel(
                String runLoggingLevel) {
            setProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option is a:
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         */
        default TwitterSearchEndpointConsumerBuilder scheduledExecutorService(
                ScheduledExecutorService scheduledExecutorService) {
            setProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         */
        default TwitterSearchEndpointConsumerBuilder scheduledExecutorService(
                String scheduledExecutorService) {
            setProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz2
         * component.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.ScheduledPollConsumerScheduler</code>
         * type.
         * 
         * Group: scheduler
         */
        default TwitterSearchEndpointConsumerBuilder scheduler(
                ScheduledPollConsumerScheduler scheduler) {
            setProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz2
         * component.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ScheduledPollConsumerScheduler</code>
         * type.
         * 
         * Group: scheduler
         */
        default TwitterSearchEndpointConsumerBuilder scheduler(String scheduler) {
            setProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz2, Spring based scheduler.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: scheduler
         */
        default TwitterSearchEndpointConsumerBuilder schedulerProperties(
                Map<String, Object> schedulerProperties) {
            setProperty("schedulerProperties", schedulerProperties);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz2, Spring based scheduler.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: scheduler
         */
        default TwitterSearchEndpointConsumerBuilder schedulerProperties(
                String schedulerProperties) {
            setProperty("schedulerProperties", schedulerProperties);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default TwitterSearchEndpointConsumerBuilder startScheduler(
                boolean startScheduler) {
            setProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default TwitterSearchEndpointConsumerBuilder startScheduler(
                String startScheduler) {
            setProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option is a: <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Group: scheduler
         */
        default TwitterSearchEndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            setProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Group: scheduler
         */
        default TwitterSearchEndpointConsumerBuilder timeUnit(String timeUnit) {
            setProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default TwitterSearchEndpointConsumerBuilder useFixedDelay(
                boolean useFixedDelay) {
            setProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default TwitterSearchEndpointConsumerBuilder useFixedDelay(
                String useFixedDelay) {
            setProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Sorts by id, so the oldest are first, and newest last.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: sort
         */
        default TwitterSearchEndpointConsumerBuilder sortById(boolean sortById) {
            setProperty("sortById", sortById);
            return this;
        }
        /**
         * Sorts by id, so the oldest are first, and newest last.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: sort
         */
        default TwitterSearchEndpointConsumerBuilder sortById(String sortById) {
            setProperty("sortById", sortById);
            return this;
        }
        /**
         * The http proxy host which can be used for the camel-twitter. Can also
         * be configured on the TwitterComponent level instead.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default TwitterSearchEndpointConsumerBuilder httpProxyHost(
                String httpProxyHost) {
            setProperty("httpProxyHost", httpProxyHost);
            return this;
        }
        /**
         * The http proxy password which can be used for the camel-twitter. Can
         * also be configured on the TwitterComponent level instead.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default TwitterSearchEndpointConsumerBuilder httpProxyPassword(
                String httpProxyPassword) {
            setProperty("httpProxyPassword", httpProxyPassword);
            return this;
        }
        /**
         * The http proxy port which can be used for the camel-twitter. Can also
         * be configured on the TwitterComponent level instead.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: proxy
         */
        default TwitterSearchEndpointConsumerBuilder httpProxyPort(
                Integer httpProxyPort) {
            setProperty("httpProxyPort", httpProxyPort);
            return this;
        }
        /**
         * The http proxy port which can be used for the camel-twitter. Can also
         * be configured on the TwitterComponent level instead.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: proxy
         */
        default TwitterSearchEndpointConsumerBuilder httpProxyPort(
                String httpProxyPort) {
            setProperty("httpProxyPort", httpProxyPort);
            return this;
        }
        /**
         * The http proxy user which can be used for the camel-twitter. Can also
         * be configured on the TwitterComponent level instead.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default TwitterSearchEndpointConsumerBuilder httpProxyUser(
                String httpProxyUser) {
            setProperty("httpProxyUser", httpProxyUser);
            return this;
        }
        /**
         * The access token. Can also be configured on the TwitterComponent
         * level instead.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default TwitterSearchEndpointConsumerBuilder accessToken(
                String accessToken) {
            setProperty("accessToken", accessToken);
            return this;
        }
        /**
         * The access secret. Can also be configured on the TwitterComponent
         * level instead.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default TwitterSearchEndpointConsumerBuilder accessTokenSecret(
                String accessTokenSecret) {
            setProperty("accessTokenSecret", accessTokenSecret);
            return this;
        }
        /**
         * The consumer key. Can also be configured on the TwitterComponent
         * level instead.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default TwitterSearchEndpointConsumerBuilder consumerKey(
                String consumerKey) {
            setProperty("consumerKey", consumerKey);
            return this;
        }
        /**
         * The consumer secret. Can also be configured on the TwitterComponent
         * level instead.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default TwitterSearchEndpointConsumerBuilder consumerSecret(
                String consumerSecret) {
            setProperty("consumerSecret", consumerSecret);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Twitter Search component.
     */
    public interface AdvancedTwitterSearchEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default TwitterSearchEndpointConsumerBuilder basic() {
            return (TwitterSearchEndpointConsumerBuilder) this;
        }
        /**
         * Used by the non-stream geography search, to search by radius using
         * the configured metrics. The unit can either be mi for miles, or km
         * for kilometers. You need to configure all the following options:
         * longitude, latitude, radius, and distanceMetric.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedTwitterSearchEndpointConsumerBuilder distanceMetric(
                String distanceMetric) {
            setProperty("distanceMetric", distanceMetric);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedTwitterSearchEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            setProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedTwitterSearchEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            setProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedTwitterSearchEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            setProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedTwitterSearchEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            setProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Used for enabling full text from twitter (eg receive tweets that
         * contains more than 140 characters).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedTwitterSearchEndpointConsumerBuilder extendedMode(
                boolean extendedMode) {
            setProperty("extendedMode", extendedMode);
            return this;
        }
        /**
         * Used for enabling full text from twitter (eg receive tweets that
         * contains more than 140 characters).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedTwitterSearchEndpointConsumerBuilder extendedMode(
                String extendedMode) {
            setProperty("extendedMode", extendedMode);
            return this;
        }
        /**
         * Used by the non-stream geography search to search by latitude. You
         * need to configure all the following options: longitude, latitude,
         * radius, and distanceMetric.
         * 
         * The option is a: <code>java.lang.Double</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedTwitterSearchEndpointConsumerBuilder latitude(
                Double latitude) {
            setProperty("latitude", latitude);
            return this;
        }
        /**
         * Used by the non-stream geography search to search by latitude. You
         * need to configure all the following options: longitude, latitude,
         * radius, and distanceMetric.
         * 
         * The option will be converted to a <code>java.lang.Double</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedTwitterSearchEndpointConsumerBuilder latitude(
                String latitude) {
            setProperty("latitude", latitude);
            return this;
        }
        /**
         * Bounding boxes, created by pairs of lat/lons. Can be used for
         * streaming/filter. A pair is defined as lat,lon. And multiple paris
         * can be separated by semi colon.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedTwitterSearchEndpointConsumerBuilder locations(
                String locations) {
            setProperty("locations", locations);
            return this;
        }
        /**
         * Used by the non-stream geography search to search by longitude. You
         * need to configure all the following options: longitude, latitude,
         * radius, and distanceMetric.
         * 
         * The option is a: <code>java.lang.Double</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedTwitterSearchEndpointConsumerBuilder longitude(
                Double longitude) {
            setProperty("longitude", longitude);
            return this;
        }
        /**
         * Used by the non-stream geography search to search by longitude. You
         * need to configure all the following options: longitude, latitude,
         * radius, and distanceMetric.
         * 
         * The option will be converted to a <code>java.lang.Double</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedTwitterSearchEndpointConsumerBuilder longitude(
                String longitude) {
            setProperty("longitude", longitude);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedTwitterSearchEndpointConsumerBuilder pollStrategy(
                PollingConsumerPollStrategy pollStrategy) {
            setProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedTwitterSearchEndpointConsumerBuilder pollStrategy(
                String pollStrategy) {
            setProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * Used by the non-stream geography search to search by radius. You need
         * to configure all the following options: longitude, latitude, radius,
         * and distanceMetric.
         * 
         * The option is a: <code>java.lang.Double</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedTwitterSearchEndpointConsumerBuilder radius(
                Double radius) {
            setProperty("radius", radius);
            return this;
        }
        /**
         * Used by the non-stream geography search to search by radius. You need
         * to configure all the following options: longitude, latitude, radius,
         * and distanceMetric.
         * 
         * The option will be converted to a <code>java.lang.Double</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedTwitterSearchEndpointConsumerBuilder radius(
                String radius) {
            setProperty("radius", radius);
            return this;
        }
        /**
         * To use a custom instance of TwitterStream.
         * 
         * The option is a: <code>twitter4j.TwitterStream</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedTwitterSearchEndpointConsumerBuilder twitterStream(
                Object twitterStream) {
            setProperty("twitterStream", twitterStream);
            return this;
        }
        /**
         * To use a custom instance of TwitterStream.
         * 
         * The option will be converted to a
         * <code>twitter4j.TwitterStream</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedTwitterSearchEndpointConsumerBuilder twitterStream(
                String twitterStream) {
            setProperty("twitterStream", twitterStream);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedTwitterSearchEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedTwitterSearchEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedTwitterSearchEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedTwitterSearchEndpointConsumerBuilder synchronous(
                String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Twitter Search component.
     */
    public interface TwitterSearchEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedTwitterSearchEndpointProducerBuilder advanced() {
            return (AdvancedTwitterSearchEndpointProducerBuilder) this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default TwitterSearchEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            setProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default TwitterSearchEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            setProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * The http proxy host which can be used for the camel-twitter. Can also
         * be configured on the TwitterComponent level instead.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default TwitterSearchEndpointProducerBuilder httpProxyHost(
                String httpProxyHost) {
            setProperty("httpProxyHost", httpProxyHost);
            return this;
        }
        /**
         * The http proxy password which can be used for the camel-twitter. Can
         * also be configured on the TwitterComponent level instead.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default TwitterSearchEndpointProducerBuilder httpProxyPassword(
                String httpProxyPassword) {
            setProperty("httpProxyPassword", httpProxyPassword);
            return this;
        }
        /**
         * The http proxy port which can be used for the camel-twitter. Can also
         * be configured on the TwitterComponent level instead.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: proxy
         */
        default TwitterSearchEndpointProducerBuilder httpProxyPort(
                Integer httpProxyPort) {
            setProperty("httpProxyPort", httpProxyPort);
            return this;
        }
        /**
         * The http proxy port which can be used for the camel-twitter. Can also
         * be configured on the TwitterComponent level instead.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: proxy
         */
        default TwitterSearchEndpointProducerBuilder httpProxyPort(
                String httpProxyPort) {
            setProperty("httpProxyPort", httpProxyPort);
            return this;
        }
        /**
         * The http proxy user which can be used for the camel-twitter. Can also
         * be configured on the TwitterComponent level instead.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default TwitterSearchEndpointProducerBuilder httpProxyUser(
                String httpProxyUser) {
            setProperty("httpProxyUser", httpProxyUser);
            return this;
        }
        /**
         * The access token. Can also be configured on the TwitterComponent
         * level instead.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default TwitterSearchEndpointProducerBuilder accessToken(
                String accessToken) {
            setProperty("accessToken", accessToken);
            return this;
        }
        /**
         * The access secret. Can also be configured on the TwitterComponent
         * level instead.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default TwitterSearchEndpointProducerBuilder accessTokenSecret(
                String accessTokenSecret) {
            setProperty("accessTokenSecret", accessTokenSecret);
            return this;
        }
        /**
         * The consumer key. Can also be configured on the TwitterComponent
         * level instead.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default TwitterSearchEndpointProducerBuilder consumerKey(
                String consumerKey) {
            setProperty("consumerKey", consumerKey);
            return this;
        }
        /**
         * The consumer secret. Can also be configured on the TwitterComponent
         * level instead.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default TwitterSearchEndpointProducerBuilder consumerSecret(
                String consumerSecret) {
            setProperty("consumerSecret", consumerSecret);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Twitter Search component.
     */
    public interface AdvancedTwitterSearchEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default TwitterSearchEndpointProducerBuilder basic() {
            return (TwitterSearchEndpointProducerBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedTwitterSearchEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedTwitterSearchEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedTwitterSearchEndpointProducerBuilder synchronous(
                boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedTwitterSearchEndpointProducerBuilder synchronous(
                String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Twitter Search component.
     */
    public interface TwitterSearchEndpointBuilder
            extends
                TwitterSearchEndpointConsumerBuilder, TwitterSearchEndpointProducerBuilder {
        default AdvancedTwitterSearchEndpointBuilder advanced() {
            return (AdvancedTwitterSearchEndpointBuilder) this;
        }
        /**
         * The http proxy host which can be used for the camel-twitter. Can also
         * be configured on the TwitterComponent level instead.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default TwitterSearchEndpointBuilder httpProxyHost(String httpProxyHost) {
            setProperty("httpProxyHost", httpProxyHost);
            return this;
        }
        /**
         * The http proxy password which can be used for the camel-twitter. Can
         * also be configured on the TwitterComponent level instead.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default TwitterSearchEndpointBuilder httpProxyPassword(
                String httpProxyPassword) {
            setProperty("httpProxyPassword", httpProxyPassword);
            return this;
        }
        /**
         * The http proxy port which can be used for the camel-twitter. Can also
         * be configured on the TwitterComponent level instead.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: proxy
         */
        default TwitterSearchEndpointBuilder httpProxyPort(Integer httpProxyPort) {
            setProperty("httpProxyPort", httpProxyPort);
            return this;
        }
        /**
         * The http proxy port which can be used for the camel-twitter. Can also
         * be configured on the TwitterComponent level instead.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: proxy
         */
        default TwitterSearchEndpointBuilder httpProxyPort(String httpProxyPort) {
            setProperty("httpProxyPort", httpProxyPort);
            return this;
        }
        /**
         * The http proxy user which can be used for the camel-twitter. Can also
         * be configured on the TwitterComponent level instead.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: proxy
         */
        default TwitterSearchEndpointBuilder httpProxyUser(String httpProxyUser) {
            setProperty("httpProxyUser", httpProxyUser);
            return this;
        }
        /**
         * The access token. Can also be configured on the TwitterComponent
         * level instead.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default TwitterSearchEndpointBuilder accessToken(String accessToken) {
            setProperty("accessToken", accessToken);
            return this;
        }
        /**
         * The access secret. Can also be configured on the TwitterComponent
         * level instead.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default TwitterSearchEndpointBuilder accessTokenSecret(
                String accessTokenSecret) {
            setProperty("accessTokenSecret", accessTokenSecret);
            return this;
        }
        /**
         * The consumer key. Can also be configured on the TwitterComponent
         * level instead.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default TwitterSearchEndpointBuilder consumerKey(String consumerKey) {
            setProperty("consumerKey", consumerKey);
            return this;
        }
        /**
         * The consumer secret. Can also be configured on the TwitterComponent
         * level instead.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default TwitterSearchEndpointBuilder consumerSecret(
                String consumerSecret) {
            setProperty("consumerSecret", consumerSecret);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Twitter Search component.
     */
    public interface AdvancedTwitterSearchEndpointBuilder
            extends
                AdvancedTwitterSearchEndpointConsumerBuilder, AdvancedTwitterSearchEndpointProducerBuilder {
        default TwitterSearchEndpointBuilder basic() {
            return (TwitterSearchEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedTwitterSearchEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedTwitterSearchEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedTwitterSearchEndpointBuilder synchronous(
                boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedTwitterSearchEndpointBuilder synchronous(
                String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.twitter.data.EndpointType</code> enum.
     */
    enum EndpointType {
        POLLING,
        DIRECT,
        EVENT;
    }
    /**
     * Twitter Search (camel-twitter)
     * The Twitter Search component consumes search results.
     * 
     * Category: api,social
     * Available as of version: 2.10
     * Maven coordinates: org.apache.camel:camel-twitter
     * 
     * Syntax: <code>twitter-search:keywords</code>
     * 
     * Path parameter: keywords (required)
     * The search query, use the keywords AND, OR, - and () to narrow the search
     * results.
     */
    default TwitterSearchEndpointBuilder twitterSearch(String path) {
        class TwitterSearchEndpointBuilderImpl extends AbstractEndpointBuilder implements TwitterSearchEndpointBuilder, AdvancedTwitterSearchEndpointBuilder {
            public TwitterSearchEndpointBuilderImpl(String path) {
                super("twitter-search", path);
            }
        }
        return new TwitterSearchEndpointBuilderImpl(path);
    }
}