/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.List;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;

/**
 * To send and receive messages using the SIP protocol (used in telco and
 * mobile).
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface SipEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the SIP component.
     */
    public interface SipEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedSipEndpointConsumerBuilder advanced() {
            return (AdvancedSipEndpointConsumerBuilder) this;
        }
        /**
         * Should connections be cached by the SipStack to reduce cost of
         * connection creation. This is useful if the connection is used for
         * long running conversations.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default SipEndpointConsumerBuilder cacheConnections(
                boolean cacheConnections) {
            setProperty("cacheConnections", cacheConnections);
            return this;
        }
        /**
         * Should connections be cached by the SipStack to reduce cost of
         * connection creation. This is useful if the connection is used for
         * long running conversations.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default SipEndpointConsumerBuilder cacheConnections(
                String cacheConnections) {
            setProperty("cacheConnections", cacheConnections);
            return this;
        }
        /**
         * Setting for contentSubType can be set to any valid MimeSubType.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SipEndpointConsumerBuilder contentSubType(String contentSubType) {
            setProperty("contentSubType", contentSubType);
            return this;
        }
        /**
         * Setting for contentType can be set to any valid MimeType.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SipEndpointConsumerBuilder contentType(String contentType) {
            setProperty("contentType", contentType);
            return this;
        }
        /**
         * Setting for a String based event type.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SipEndpointConsumerBuilder eventHeaderName(
                String eventHeaderName) {
            setProperty("eventHeaderName", eventHeaderName);
            return this;
        }
        /**
         * Setting for a String based event Id. Mandatory setting unless a
         * registry based FromHeader is specified.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SipEndpointConsumerBuilder eventId(String eventId) {
            setProperty("eventId", eventId);
            return this;
        }
        /**
         * Hostname of the message originator. Mandatory setting unless a
         * registry based FromHeader is specified.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SipEndpointConsumerBuilder fromHost(String fromHost) {
            setProperty("fromHost", fromHost);
            return this;
        }
        /**
         * Port of the message originator. Mandatory setting unless a registry
         * based FromHeader is specified.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default SipEndpointConsumerBuilder fromPort(int fromPort) {
            setProperty("fromPort", fromPort);
            return this;
        }
        /**
         * Port of the message originator. Mandatory setting unless a registry
         * based FromHeader is specified.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default SipEndpointConsumerBuilder fromPort(String fromPort) {
            setProperty("fromPort", fromPort);
            return this;
        }
        /**
         * Username of the message originator. Mandatory setting unless a
         * registry based custom FromHeader is specified.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SipEndpointConsumerBuilder fromUser(String fromUser) {
            setProperty("fromUser", fromUser);
            return this;
        }
        /**
         * The amount of time a message received at an endpoint is considered
         * valid.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default SipEndpointConsumerBuilder msgExpiration(int msgExpiration) {
            setProperty("msgExpiration", msgExpiration);
            return this;
        }
        /**
         * The amount of time a message received at an endpoint is considered
         * valid.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default SipEndpointConsumerBuilder msgExpiration(String msgExpiration) {
            setProperty("msgExpiration", msgExpiration);
            return this;
        }
        /**
         * Setting for specifying amount of time to wait for a Response and/or
         * Acknowledgement can be received from another SIP stack.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: common
         */
        default SipEndpointConsumerBuilder receiveTimeoutMillis(
                long receiveTimeoutMillis) {
            setProperty("receiveTimeoutMillis", receiveTimeoutMillis);
            return this;
        }
        /**
         * Setting for specifying amount of time to wait for a Response and/or
         * Acknowledgement can be received from another SIP stack.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: common
         */
        default SipEndpointConsumerBuilder receiveTimeoutMillis(
                String receiveTimeoutMillis) {
            setProperty("receiveTimeoutMillis", receiveTimeoutMillis);
            return this;
        }
        /**
         * Name of the SIP Stack instance associated with an SIP Endpoint.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SipEndpointConsumerBuilder stackName(String stackName) {
            setProperty("stackName", stackName);
            return this;
        }
        /**
         * Hostname of the message receiver. Mandatory setting unless a registry
         * based ToHeader is specified.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SipEndpointConsumerBuilder toHost(String toHost) {
            setProperty("toHost", toHost);
            return this;
        }
        /**
         * Portname of the message receiver. Mandatory setting unless a registry
         * based ToHeader is specified.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default SipEndpointConsumerBuilder toPort(int toPort) {
            setProperty("toPort", toPort);
            return this;
        }
        /**
         * Portname of the message receiver. Mandatory setting unless a registry
         * based ToHeader is specified.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default SipEndpointConsumerBuilder toPort(String toPort) {
            setProperty("toPort", toPort);
            return this;
        }
        /**
         * Username of the message receiver. Mandatory setting unless a registry
         * based custom ToHeader is specified.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SipEndpointConsumerBuilder toUser(String toUser) {
            setProperty("toUser", toUser);
            return this;
        }
        /**
         * Setting for choice of transport protocol. Valid choices are tcp or
         * udp.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SipEndpointConsumerBuilder transport(String transport) {
            setProperty("transport", transport);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default SipEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            setProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default SipEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            setProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * This setting is used to determine whether the kind of header
         * (FromHeader,ToHeader etc) that needs to be created for this endpoint.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default SipEndpointConsumerBuilder consumer(boolean consumer) {
            setProperty("consumer", consumer);
            return this;
        }
        /**
         * This setting is used to determine whether the kind of header
         * (FromHeader,ToHeader etc) that needs to be created for this endpoint.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default SipEndpointConsumerBuilder consumer(String consumer) {
            setProperty("consumer", consumer);
            return this;
        }
        /**
         * This setting is used to distinguish between a Presence Agent & a
         * consumer. This is due to the fact that the SIP Camel component ships
         * with a basic Presence Agent (for testing purposes only). Consumers
         * have to set this flag to true.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default SipEndpointConsumerBuilder presenceAgent(boolean presenceAgent) {
            setProperty("presenceAgent", presenceAgent);
            return this;
        }
        /**
         * This setting is used to distinguish between a Presence Agent & a
         * consumer. This is due to the fact that the SIP Camel component ships
         * with a basic Presence Agent (for testing purposes only). Consumers
         * have to set this flag to true.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default SipEndpointConsumerBuilder presenceAgent(String presenceAgent) {
            setProperty("presenceAgent", presenceAgent);
            return this;
        }
        /**
         * Name of client debug log file to use for logging.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: logging
         */
        default SipEndpointConsumerBuilder implementationDebugLogFile(
                String implementationDebugLogFile) {
            setProperty("implementationDebugLogFile", implementationDebugLogFile);
            return this;
        }
        /**
         * Name of server log file to use for logging.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: logging
         */
        default SipEndpointConsumerBuilder implementationServerLogFile(
                String implementationServerLogFile) {
            setProperty("implementationServerLogFile", implementationServerLogFile);
            return this;
        }
        /**
         * Logging level for tracing.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: logging
         */
        default SipEndpointConsumerBuilder implementationTraceLevel(
                String implementationTraceLevel) {
            setProperty("implementationTraceLevel", implementationTraceLevel);
            return this;
        }
        /**
         * Number of maximum proxy forwards.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: proxy
         */
        default SipEndpointConsumerBuilder maxForwards(int maxForwards) {
            setProperty("maxForwards", maxForwards);
            return this;
        }
        /**
         * Number of maximum proxy forwards.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: proxy
         */
        default SipEndpointConsumerBuilder maxForwards(String maxForwards) {
            setProperty("maxForwards", maxForwards);
            return this;
        }
        /**
         * This setting is used when requests are sent to the Presence Agent via
         * a proxy.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: proxy
         */
        default SipEndpointConsumerBuilder useRouterForAllUris(
                boolean useRouterForAllUris) {
            setProperty("useRouterForAllUris", useRouterForAllUris);
            return this;
        }
        /**
         * This setting is used when requests are sent to the Presence Agent via
         * a proxy.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: proxy
         */
        default SipEndpointConsumerBuilder useRouterForAllUris(
                String useRouterForAllUris) {
            setProperty("useRouterForAllUris", useRouterForAllUris);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the SIP component.
     */
    public interface AdvancedSipEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default SipEndpointConsumerBuilder basic() {
            return (SipEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedSipEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            setProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedSipEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            setProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedSipEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            setProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedSipEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            setProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * To use a custom AddressFactory.
         * 
         * The option is a: <code>javax.sip.address.AddressFactory</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointConsumerBuilder addressFactory(
                Object addressFactory) {
            setProperty("addressFactory", addressFactory);
            return this;
        }
        /**
         * To use a custom AddressFactory.
         * 
         * The option will be converted to a
         * <code>javax.sip.address.AddressFactory</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointConsumerBuilder addressFactory(
                String addressFactory) {
            setProperty("addressFactory", addressFactory);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * A custom Header object containing call details. Must implement the
         * type javax.sip.header.CallIdHeader.
         * 
         * The option is a: <code>javax.sip.header.CallIdHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointConsumerBuilder callIdHeader(
                Object callIdHeader) {
            setProperty("callIdHeader", callIdHeader);
            return this;
        }
        /**
         * A custom Header object containing call details. Must implement the
         * type javax.sip.header.CallIdHeader.
         * 
         * The option will be converted to a
         * <code>javax.sip.header.CallIdHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointConsumerBuilder callIdHeader(
                String callIdHeader) {
            setProperty("callIdHeader", callIdHeader);
            return this;
        }
        /**
         * An optional custom Header object containing verbose contact details
         * (email, phone number etc). Must implement the type
         * javax.sip.header.ContactHeader.
         * 
         * The option is a: <code>javax.sip.header.ContactHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointConsumerBuilder contactHeader(
                Object contactHeader) {
            setProperty("contactHeader", contactHeader);
            return this;
        }
        /**
         * An optional custom Header object containing verbose contact details
         * (email, phone number etc). Must implement the type
         * javax.sip.header.ContactHeader.
         * 
         * The option will be converted to a
         * <code>javax.sip.header.ContactHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointConsumerBuilder contactHeader(
                String contactHeader) {
            setProperty("contactHeader", contactHeader);
            return this;
        }
        /**
         * A custom Header object containing message content details. Must
         * implement the type javax.sip.header.ContentTypeHeader.
         * 
         * The option is a: <code>javax.sip.header.ContentTypeHeader</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointConsumerBuilder contentTypeHeader(
                Object contentTypeHeader) {
            setProperty("contentTypeHeader", contentTypeHeader);
            return this;
        }
        /**
         * A custom Header object containing message content details. Must
         * implement the type javax.sip.header.ContentTypeHeader.
         * 
         * The option will be converted to a
         * <code>javax.sip.header.ContentTypeHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointConsumerBuilder contentTypeHeader(
                String contentTypeHeader) {
            setProperty("contentTypeHeader", contentTypeHeader);
            return this;
        }
        /**
         * A custom Header object containing event details. Must implement the
         * type javax.sip.header.EventHeader.
         * 
         * The option is a: <code>javax.sip.header.EventHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointConsumerBuilder eventHeader(
                Object eventHeader) {
            setProperty("eventHeader", eventHeader);
            return this;
        }
        /**
         * A custom Header object containing event details. Must implement the
         * type javax.sip.header.EventHeader.
         * 
         * The option will be converted to a
         * <code>javax.sip.header.EventHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointConsumerBuilder eventHeader(
                String eventHeader) {
            setProperty("eventHeader", eventHeader);
            return this;
        }
        /**
         * A custom Header object containing message expiration details. Must
         * implement the type javax.sip.header.ExpiresHeader.
         * 
         * The option is a: <code>javax.sip.header.ExpiresHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointConsumerBuilder expiresHeader(
                Object expiresHeader) {
            setProperty("expiresHeader", expiresHeader);
            return this;
        }
        /**
         * A custom Header object containing message expiration details. Must
         * implement the type javax.sip.header.ExpiresHeader.
         * 
         * The option will be converted to a
         * <code>javax.sip.header.ExpiresHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointConsumerBuilder expiresHeader(
                String expiresHeader) {
            setProperty("expiresHeader", expiresHeader);
            return this;
        }
        /**
         * A custom Header object containing user/application specific details.
         * Must implement the type javax.sip.header.ExtensionHeader.
         * 
         * The option is a: <code>javax.sip.header.ExtensionHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointConsumerBuilder extensionHeader(
                Object extensionHeader) {
            setProperty("extensionHeader", extensionHeader);
            return this;
        }
        /**
         * A custom Header object containing user/application specific details.
         * Must implement the type javax.sip.header.ExtensionHeader.
         * 
         * The option will be converted to a
         * <code>javax.sip.header.ExtensionHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointConsumerBuilder extensionHeader(
                String extensionHeader) {
            setProperty("extensionHeader", extensionHeader);
            return this;
        }
        /**
         * A custom Header object containing message originator settings. Must
         * implement the type javax.sip.header.FromHeader.
         * 
         * The option is a: <code>javax.sip.header.FromHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointConsumerBuilder fromHeader(Object fromHeader) {
            setProperty("fromHeader", fromHeader);
            return this;
        }
        /**
         * A custom Header object containing message originator settings. Must
         * implement the type javax.sip.header.FromHeader.
         * 
         * The option will be converted to a
         * <code>javax.sip.header.FromHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointConsumerBuilder fromHeader(String fromHeader) {
            setProperty("fromHeader", fromHeader);
            return this;
        }
        /**
         * To use a custom HeaderFactory.
         * 
         * The option is a: <code>javax.sip.header.HeaderFactory</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointConsumerBuilder headerFactory(
                Object headerFactory) {
            setProperty("headerFactory", headerFactory);
            return this;
        }
        /**
         * To use a custom HeaderFactory.
         * 
         * The option will be converted to a
         * <code>javax.sip.header.HeaderFactory</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointConsumerBuilder headerFactory(
                String headerFactory) {
            setProperty("headerFactory", headerFactory);
            return this;
        }
        /**
         * To use a custom ListeningPoint implementation.
         * 
         * The option is a: <code>javax.sip.ListeningPoint</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointConsumerBuilder listeningPoint(
                Object listeningPoint) {
            setProperty("listeningPoint", listeningPoint);
            return this;
        }
        /**
         * To use a custom ListeningPoint implementation.
         * 
         * The option will be converted to a
         * <code>javax.sip.ListeningPoint</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointConsumerBuilder listeningPoint(
                String listeningPoint) {
            setProperty("listeningPoint", listeningPoint);
            return this;
        }
        /**
         * A custom Header object containing details on maximum proxy forwards.
         * This header places a limit on the viaHeaders possible. Must implement
         * the type javax.sip.header.MaxForwardsHeader.
         * 
         * The option is a: <code>javax.sip.header.MaxForwardsHeader</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointConsumerBuilder maxForwardsHeader(
                Object maxForwardsHeader) {
            setProperty("maxForwardsHeader", maxForwardsHeader);
            return this;
        }
        /**
         * A custom Header object containing details on maximum proxy forwards.
         * This header places a limit on the viaHeaders possible. Must implement
         * the type javax.sip.header.MaxForwardsHeader.
         * 
         * The option will be converted to a
         * <code>javax.sip.header.MaxForwardsHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointConsumerBuilder maxForwardsHeader(
                String maxForwardsHeader) {
            setProperty("maxForwardsHeader", maxForwardsHeader);
            return this;
        }
        /**
         * Setting for maximum allowed Message size in bytes.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointConsumerBuilder maxMessageSize(
                int maxMessageSize) {
            setProperty("maxMessageSize", maxMessageSize);
            return this;
        }
        /**
         * Setting for maximum allowed Message size in bytes.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointConsumerBuilder maxMessageSize(
                String maxMessageSize) {
            setProperty("maxMessageSize", maxMessageSize);
            return this;
        }
        /**
         * To use a custom MessageFactory.
         * 
         * The option is a: <code>javax.sip.message.MessageFactory</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointConsumerBuilder messageFactory(
                Object messageFactory) {
            setProperty("messageFactory", messageFactory);
            return this;
        }
        /**
         * To use a custom MessageFactory.
         * 
         * The option will be converted to a
         * <code>javax.sip.message.MessageFactory</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointConsumerBuilder messageFactory(
                String messageFactory) {
            setProperty("messageFactory", messageFactory);
            return this;
        }
        /**
         * To use a custom SipFactory to create the SipStack to be used.
         * 
         * The option is a: <code>javax.sip.SipFactory</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointConsumerBuilder sipFactory(Object sipFactory) {
            setProperty("sipFactory", sipFactory);
            return this;
        }
        /**
         * To use a custom SipFactory to create the SipStack to be used.
         * 
         * The option will be converted to a <code>javax.sip.SipFactory</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointConsumerBuilder sipFactory(String sipFactory) {
            setProperty("sipFactory", sipFactory);
            return this;
        }
        /**
         * To use a custom SipStack.
         * 
         * The option is a: <code>javax.sip.SipStack</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointConsumerBuilder sipStack(Object sipStack) {
            setProperty("sipStack", sipStack);
            return this;
        }
        /**
         * To use a custom SipStack.
         * 
         * The option will be converted to a <code>javax.sip.SipStack</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointConsumerBuilder sipStack(String sipStack) {
            setProperty("sipStack", sipStack);
            return this;
        }
        /**
         * To use a custom SipURI. If none configured, then the SipUri fallback
         * to use the options toUser toHost:toPort.
         * 
         * The option is a: <code>javax.sip.address.SipURI</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointConsumerBuilder sipUri(Object sipUri) {
            setProperty("sipUri", sipUri);
            return this;
        }
        /**
         * To use a custom SipURI. If none configured, then the SipUri fallback
         * to use the options toUser toHost:toPort.
         * 
         * The option will be converted to a
         * <code>javax.sip.address.SipURI</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointConsumerBuilder sipUri(String sipUri) {
            setProperty("sipUri", sipUri);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointConsumerBuilder synchronous(
                boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointConsumerBuilder synchronous(
                String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * A custom Header object containing message receiver settings. Must
         * implement the type javax.sip.header.ToHeader.
         * 
         * The option is a: <code>javax.sip.header.ToHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointConsumerBuilder toHeader(Object toHeader) {
            setProperty("toHeader", toHeader);
            return this;
        }
        /**
         * A custom Header object containing message receiver settings. Must
         * implement the type javax.sip.header.ToHeader.
         * 
         * The option will be converted to a
         * <code>javax.sip.header.ToHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointConsumerBuilder toHeader(String toHeader) {
            setProperty("toHeader", toHeader);
            return this;
        }
        /**
         * List of custom Header objects of the type javax.sip.header.ViaHeader.
         * Each ViaHeader containing a proxy address for request forwarding.
         * (Note this header is automatically updated by each proxy when the
         * request arrives at its listener).
         * 
         * The option is a:
         * <code>java.util.List&lt;javax.sip.header.ViaHeader&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointConsumerBuilder viaHeaders(
                List<Object> viaHeaders) {
            setProperty("viaHeaders", viaHeaders);
            return this;
        }
        /**
         * List of custom Header objects of the type javax.sip.header.ViaHeader.
         * Each ViaHeader containing a proxy address for request forwarding.
         * (Note this header is automatically updated by each proxy when the
         * request arrives at its listener).
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;javax.sip.header.ViaHeader&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointConsumerBuilder viaHeaders(String viaHeaders) {
            setProperty("viaHeaders", viaHeaders);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the SIP component.
     */
    public interface SipEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedSipEndpointProducerBuilder advanced() {
            return (AdvancedSipEndpointProducerBuilder) this;
        }
        /**
         * Should connections be cached by the SipStack to reduce cost of
         * connection creation. This is useful if the connection is used for
         * long running conversations.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default SipEndpointProducerBuilder cacheConnections(
                boolean cacheConnections) {
            setProperty("cacheConnections", cacheConnections);
            return this;
        }
        /**
         * Should connections be cached by the SipStack to reduce cost of
         * connection creation. This is useful if the connection is used for
         * long running conversations.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default SipEndpointProducerBuilder cacheConnections(
                String cacheConnections) {
            setProperty("cacheConnections", cacheConnections);
            return this;
        }
        /**
         * Setting for contentSubType can be set to any valid MimeSubType.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SipEndpointProducerBuilder contentSubType(String contentSubType) {
            setProperty("contentSubType", contentSubType);
            return this;
        }
        /**
         * Setting for contentType can be set to any valid MimeType.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SipEndpointProducerBuilder contentType(String contentType) {
            setProperty("contentType", contentType);
            return this;
        }
        /**
         * Setting for a String based event type.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SipEndpointProducerBuilder eventHeaderName(
                String eventHeaderName) {
            setProperty("eventHeaderName", eventHeaderName);
            return this;
        }
        /**
         * Setting for a String based event Id. Mandatory setting unless a
         * registry based FromHeader is specified.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SipEndpointProducerBuilder eventId(String eventId) {
            setProperty("eventId", eventId);
            return this;
        }
        /**
         * Hostname of the message originator. Mandatory setting unless a
         * registry based FromHeader is specified.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SipEndpointProducerBuilder fromHost(String fromHost) {
            setProperty("fromHost", fromHost);
            return this;
        }
        /**
         * Port of the message originator. Mandatory setting unless a registry
         * based FromHeader is specified.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default SipEndpointProducerBuilder fromPort(int fromPort) {
            setProperty("fromPort", fromPort);
            return this;
        }
        /**
         * Port of the message originator. Mandatory setting unless a registry
         * based FromHeader is specified.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default SipEndpointProducerBuilder fromPort(String fromPort) {
            setProperty("fromPort", fromPort);
            return this;
        }
        /**
         * Username of the message originator. Mandatory setting unless a
         * registry based custom FromHeader is specified.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SipEndpointProducerBuilder fromUser(String fromUser) {
            setProperty("fromUser", fromUser);
            return this;
        }
        /**
         * The amount of time a message received at an endpoint is considered
         * valid.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default SipEndpointProducerBuilder msgExpiration(int msgExpiration) {
            setProperty("msgExpiration", msgExpiration);
            return this;
        }
        /**
         * The amount of time a message received at an endpoint is considered
         * valid.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default SipEndpointProducerBuilder msgExpiration(String msgExpiration) {
            setProperty("msgExpiration", msgExpiration);
            return this;
        }
        /**
         * Setting for specifying amount of time to wait for a Response and/or
         * Acknowledgement can be received from another SIP stack.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: common
         */
        default SipEndpointProducerBuilder receiveTimeoutMillis(
                long receiveTimeoutMillis) {
            setProperty("receiveTimeoutMillis", receiveTimeoutMillis);
            return this;
        }
        /**
         * Setting for specifying amount of time to wait for a Response and/or
         * Acknowledgement can be received from another SIP stack.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: common
         */
        default SipEndpointProducerBuilder receiveTimeoutMillis(
                String receiveTimeoutMillis) {
            setProperty("receiveTimeoutMillis", receiveTimeoutMillis);
            return this;
        }
        /**
         * Name of the SIP Stack instance associated with an SIP Endpoint.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SipEndpointProducerBuilder stackName(String stackName) {
            setProperty("stackName", stackName);
            return this;
        }
        /**
         * Hostname of the message receiver. Mandatory setting unless a registry
         * based ToHeader is specified.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SipEndpointProducerBuilder toHost(String toHost) {
            setProperty("toHost", toHost);
            return this;
        }
        /**
         * Portname of the message receiver. Mandatory setting unless a registry
         * based ToHeader is specified.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default SipEndpointProducerBuilder toPort(int toPort) {
            setProperty("toPort", toPort);
            return this;
        }
        /**
         * Portname of the message receiver. Mandatory setting unless a registry
         * based ToHeader is specified.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default SipEndpointProducerBuilder toPort(String toPort) {
            setProperty("toPort", toPort);
            return this;
        }
        /**
         * Username of the message receiver. Mandatory setting unless a registry
         * based custom ToHeader is specified.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SipEndpointProducerBuilder toUser(String toUser) {
            setProperty("toUser", toUser);
            return this;
        }
        /**
         * Setting for choice of transport protocol. Valid choices are tcp or
         * udp.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SipEndpointProducerBuilder transport(String transport) {
            setProperty("transport", transport);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default SipEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            setProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default SipEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            setProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Name of client debug log file to use for logging.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: logging
         */
        default SipEndpointProducerBuilder implementationDebugLogFile(
                String implementationDebugLogFile) {
            setProperty("implementationDebugLogFile", implementationDebugLogFile);
            return this;
        }
        /**
         * Name of server log file to use for logging.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: logging
         */
        default SipEndpointProducerBuilder implementationServerLogFile(
                String implementationServerLogFile) {
            setProperty("implementationServerLogFile", implementationServerLogFile);
            return this;
        }
        /**
         * Logging level for tracing.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: logging
         */
        default SipEndpointProducerBuilder implementationTraceLevel(
                String implementationTraceLevel) {
            setProperty("implementationTraceLevel", implementationTraceLevel);
            return this;
        }
        /**
         * Number of maximum proxy forwards.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: proxy
         */
        default SipEndpointProducerBuilder maxForwards(int maxForwards) {
            setProperty("maxForwards", maxForwards);
            return this;
        }
        /**
         * Number of maximum proxy forwards.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: proxy
         */
        default SipEndpointProducerBuilder maxForwards(String maxForwards) {
            setProperty("maxForwards", maxForwards);
            return this;
        }
        /**
         * This setting is used when requests are sent to the Presence Agent via
         * a proxy.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: proxy
         */
        default SipEndpointProducerBuilder useRouterForAllUris(
                boolean useRouterForAllUris) {
            setProperty("useRouterForAllUris", useRouterForAllUris);
            return this;
        }
        /**
         * This setting is used when requests are sent to the Presence Agent via
         * a proxy.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: proxy
         */
        default SipEndpointProducerBuilder useRouterForAllUris(
                String useRouterForAllUris) {
            setProperty("useRouterForAllUris", useRouterForAllUris);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the SIP component.
     */
    public interface AdvancedSipEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default SipEndpointProducerBuilder basic() {
            return (SipEndpointProducerBuilder) this;
        }
        /**
         * To use a custom AddressFactory.
         * 
         * The option is a: <code>javax.sip.address.AddressFactory</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointProducerBuilder addressFactory(
                Object addressFactory) {
            setProperty("addressFactory", addressFactory);
            return this;
        }
        /**
         * To use a custom AddressFactory.
         * 
         * The option will be converted to a
         * <code>javax.sip.address.AddressFactory</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointProducerBuilder addressFactory(
                String addressFactory) {
            setProperty("addressFactory", addressFactory);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * A custom Header object containing call details. Must implement the
         * type javax.sip.header.CallIdHeader.
         * 
         * The option is a: <code>javax.sip.header.CallIdHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointProducerBuilder callIdHeader(
                Object callIdHeader) {
            setProperty("callIdHeader", callIdHeader);
            return this;
        }
        /**
         * A custom Header object containing call details. Must implement the
         * type javax.sip.header.CallIdHeader.
         * 
         * The option will be converted to a
         * <code>javax.sip.header.CallIdHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointProducerBuilder callIdHeader(
                String callIdHeader) {
            setProperty("callIdHeader", callIdHeader);
            return this;
        }
        /**
         * An optional custom Header object containing verbose contact details
         * (email, phone number etc). Must implement the type
         * javax.sip.header.ContactHeader.
         * 
         * The option is a: <code>javax.sip.header.ContactHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointProducerBuilder contactHeader(
                Object contactHeader) {
            setProperty("contactHeader", contactHeader);
            return this;
        }
        /**
         * An optional custom Header object containing verbose contact details
         * (email, phone number etc). Must implement the type
         * javax.sip.header.ContactHeader.
         * 
         * The option will be converted to a
         * <code>javax.sip.header.ContactHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointProducerBuilder contactHeader(
                String contactHeader) {
            setProperty("contactHeader", contactHeader);
            return this;
        }
        /**
         * A custom Header object containing message content details. Must
         * implement the type javax.sip.header.ContentTypeHeader.
         * 
         * The option is a: <code>javax.sip.header.ContentTypeHeader</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointProducerBuilder contentTypeHeader(
                Object contentTypeHeader) {
            setProperty("contentTypeHeader", contentTypeHeader);
            return this;
        }
        /**
         * A custom Header object containing message content details. Must
         * implement the type javax.sip.header.ContentTypeHeader.
         * 
         * The option will be converted to a
         * <code>javax.sip.header.ContentTypeHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointProducerBuilder contentTypeHeader(
                String contentTypeHeader) {
            setProperty("contentTypeHeader", contentTypeHeader);
            return this;
        }
        /**
         * A custom Header object containing event details. Must implement the
         * type javax.sip.header.EventHeader.
         * 
         * The option is a: <code>javax.sip.header.EventHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointProducerBuilder eventHeader(
                Object eventHeader) {
            setProperty("eventHeader", eventHeader);
            return this;
        }
        /**
         * A custom Header object containing event details. Must implement the
         * type javax.sip.header.EventHeader.
         * 
         * The option will be converted to a
         * <code>javax.sip.header.EventHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointProducerBuilder eventHeader(
                String eventHeader) {
            setProperty("eventHeader", eventHeader);
            return this;
        }
        /**
         * A custom Header object containing message expiration details. Must
         * implement the type javax.sip.header.ExpiresHeader.
         * 
         * The option is a: <code>javax.sip.header.ExpiresHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointProducerBuilder expiresHeader(
                Object expiresHeader) {
            setProperty("expiresHeader", expiresHeader);
            return this;
        }
        /**
         * A custom Header object containing message expiration details. Must
         * implement the type javax.sip.header.ExpiresHeader.
         * 
         * The option will be converted to a
         * <code>javax.sip.header.ExpiresHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointProducerBuilder expiresHeader(
                String expiresHeader) {
            setProperty("expiresHeader", expiresHeader);
            return this;
        }
        /**
         * A custom Header object containing user/application specific details.
         * Must implement the type javax.sip.header.ExtensionHeader.
         * 
         * The option is a: <code>javax.sip.header.ExtensionHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointProducerBuilder extensionHeader(
                Object extensionHeader) {
            setProperty("extensionHeader", extensionHeader);
            return this;
        }
        /**
         * A custom Header object containing user/application specific details.
         * Must implement the type javax.sip.header.ExtensionHeader.
         * 
         * The option will be converted to a
         * <code>javax.sip.header.ExtensionHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointProducerBuilder extensionHeader(
                String extensionHeader) {
            setProperty("extensionHeader", extensionHeader);
            return this;
        }
        /**
         * A custom Header object containing message originator settings. Must
         * implement the type javax.sip.header.FromHeader.
         * 
         * The option is a: <code>javax.sip.header.FromHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointProducerBuilder fromHeader(Object fromHeader) {
            setProperty("fromHeader", fromHeader);
            return this;
        }
        /**
         * A custom Header object containing message originator settings. Must
         * implement the type javax.sip.header.FromHeader.
         * 
         * The option will be converted to a
         * <code>javax.sip.header.FromHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointProducerBuilder fromHeader(String fromHeader) {
            setProperty("fromHeader", fromHeader);
            return this;
        }
        /**
         * To use a custom HeaderFactory.
         * 
         * The option is a: <code>javax.sip.header.HeaderFactory</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointProducerBuilder headerFactory(
                Object headerFactory) {
            setProperty("headerFactory", headerFactory);
            return this;
        }
        /**
         * To use a custom HeaderFactory.
         * 
         * The option will be converted to a
         * <code>javax.sip.header.HeaderFactory</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointProducerBuilder headerFactory(
                String headerFactory) {
            setProperty("headerFactory", headerFactory);
            return this;
        }
        /**
         * To use a custom ListeningPoint implementation.
         * 
         * The option is a: <code>javax.sip.ListeningPoint</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointProducerBuilder listeningPoint(
                Object listeningPoint) {
            setProperty("listeningPoint", listeningPoint);
            return this;
        }
        /**
         * To use a custom ListeningPoint implementation.
         * 
         * The option will be converted to a
         * <code>javax.sip.ListeningPoint</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointProducerBuilder listeningPoint(
                String listeningPoint) {
            setProperty("listeningPoint", listeningPoint);
            return this;
        }
        /**
         * A custom Header object containing details on maximum proxy forwards.
         * This header places a limit on the viaHeaders possible. Must implement
         * the type javax.sip.header.MaxForwardsHeader.
         * 
         * The option is a: <code>javax.sip.header.MaxForwardsHeader</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointProducerBuilder maxForwardsHeader(
                Object maxForwardsHeader) {
            setProperty("maxForwardsHeader", maxForwardsHeader);
            return this;
        }
        /**
         * A custom Header object containing details on maximum proxy forwards.
         * This header places a limit on the viaHeaders possible. Must implement
         * the type javax.sip.header.MaxForwardsHeader.
         * 
         * The option will be converted to a
         * <code>javax.sip.header.MaxForwardsHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointProducerBuilder maxForwardsHeader(
                String maxForwardsHeader) {
            setProperty("maxForwardsHeader", maxForwardsHeader);
            return this;
        }
        /**
         * Setting for maximum allowed Message size in bytes.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointProducerBuilder maxMessageSize(
                int maxMessageSize) {
            setProperty("maxMessageSize", maxMessageSize);
            return this;
        }
        /**
         * Setting for maximum allowed Message size in bytes.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointProducerBuilder maxMessageSize(
                String maxMessageSize) {
            setProperty("maxMessageSize", maxMessageSize);
            return this;
        }
        /**
         * To use a custom MessageFactory.
         * 
         * The option is a: <code>javax.sip.message.MessageFactory</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointProducerBuilder messageFactory(
                Object messageFactory) {
            setProperty("messageFactory", messageFactory);
            return this;
        }
        /**
         * To use a custom MessageFactory.
         * 
         * The option will be converted to a
         * <code>javax.sip.message.MessageFactory</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointProducerBuilder messageFactory(
                String messageFactory) {
            setProperty("messageFactory", messageFactory);
            return this;
        }
        /**
         * To use a custom SipFactory to create the SipStack to be used.
         * 
         * The option is a: <code>javax.sip.SipFactory</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointProducerBuilder sipFactory(Object sipFactory) {
            setProperty("sipFactory", sipFactory);
            return this;
        }
        /**
         * To use a custom SipFactory to create the SipStack to be used.
         * 
         * The option will be converted to a <code>javax.sip.SipFactory</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointProducerBuilder sipFactory(String sipFactory) {
            setProperty("sipFactory", sipFactory);
            return this;
        }
        /**
         * To use a custom SipStack.
         * 
         * The option is a: <code>javax.sip.SipStack</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointProducerBuilder sipStack(Object sipStack) {
            setProperty("sipStack", sipStack);
            return this;
        }
        /**
         * To use a custom SipStack.
         * 
         * The option will be converted to a <code>javax.sip.SipStack</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointProducerBuilder sipStack(String sipStack) {
            setProperty("sipStack", sipStack);
            return this;
        }
        /**
         * To use a custom SipURI. If none configured, then the SipUri fallback
         * to use the options toUser toHost:toPort.
         * 
         * The option is a: <code>javax.sip.address.SipURI</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointProducerBuilder sipUri(Object sipUri) {
            setProperty("sipUri", sipUri);
            return this;
        }
        /**
         * To use a custom SipURI. If none configured, then the SipUri fallback
         * to use the options toUser toHost:toPort.
         * 
         * The option will be converted to a
         * <code>javax.sip.address.SipURI</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointProducerBuilder sipUri(String sipUri) {
            setProperty("sipUri", sipUri);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointProducerBuilder synchronous(
                boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointProducerBuilder synchronous(
                String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * A custom Header object containing message receiver settings. Must
         * implement the type javax.sip.header.ToHeader.
         * 
         * The option is a: <code>javax.sip.header.ToHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointProducerBuilder toHeader(Object toHeader) {
            setProperty("toHeader", toHeader);
            return this;
        }
        /**
         * A custom Header object containing message receiver settings. Must
         * implement the type javax.sip.header.ToHeader.
         * 
         * The option will be converted to a
         * <code>javax.sip.header.ToHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointProducerBuilder toHeader(String toHeader) {
            setProperty("toHeader", toHeader);
            return this;
        }
        /**
         * List of custom Header objects of the type javax.sip.header.ViaHeader.
         * Each ViaHeader containing a proxy address for request forwarding.
         * (Note this header is automatically updated by each proxy when the
         * request arrives at its listener).
         * 
         * The option is a:
         * <code>java.util.List&lt;javax.sip.header.ViaHeader&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointProducerBuilder viaHeaders(
                List<Object> viaHeaders) {
            setProperty("viaHeaders", viaHeaders);
            return this;
        }
        /**
         * List of custom Header objects of the type javax.sip.header.ViaHeader.
         * Each ViaHeader containing a proxy address for request forwarding.
         * (Note this header is automatically updated by each proxy when the
         * request arrives at its listener).
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;javax.sip.header.ViaHeader&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointProducerBuilder viaHeaders(String viaHeaders) {
            setProperty("viaHeaders", viaHeaders);
            return this;
        }
    }

    /**
     * Builder for endpoint for the SIP component.
     */
    public interface SipEndpointBuilder
            extends
                SipEndpointConsumerBuilder, SipEndpointProducerBuilder {
        default AdvancedSipEndpointBuilder advanced() {
            return (AdvancedSipEndpointBuilder) this;
        }
        /**
         * Should connections be cached by the SipStack to reduce cost of
         * connection creation. This is useful if the connection is used for
         * long running conversations.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default SipEndpointBuilder cacheConnections(boolean cacheConnections) {
            setProperty("cacheConnections", cacheConnections);
            return this;
        }
        /**
         * Should connections be cached by the SipStack to reduce cost of
         * connection creation. This is useful if the connection is used for
         * long running conversations.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default SipEndpointBuilder cacheConnections(String cacheConnections) {
            setProperty("cacheConnections", cacheConnections);
            return this;
        }
        /**
         * Setting for contentSubType can be set to any valid MimeSubType.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SipEndpointBuilder contentSubType(String contentSubType) {
            setProperty("contentSubType", contentSubType);
            return this;
        }
        /**
         * Setting for contentType can be set to any valid MimeType.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SipEndpointBuilder contentType(String contentType) {
            setProperty("contentType", contentType);
            return this;
        }
        /**
         * Setting for a String based event type.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SipEndpointBuilder eventHeaderName(String eventHeaderName) {
            setProperty("eventHeaderName", eventHeaderName);
            return this;
        }
        /**
         * Setting for a String based event Id. Mandatory setting unless a
         * registry based FromHeader is specified.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SipEndpointBuilder eventId(String eventId) {
            setProperty("eventId", eventId);
            return this;
        }
        /**
         * Hostname of the message originator. Mandatory setting unless a
         * registry based FromHeader is specified.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SipEndpointBuilder fromHost(String fromHost) {
            setProperty("fromHost", fromHost);
            return this;
        }
        /**
         * Port of the message originator. Mandatory setting unless a registry
         * based FromHeader is specified.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default SipEndpointBuilder fromPort(int fromPort) {
            setProperty("fromPort", fromPort);
            return this;
        }
        /**
         * Port of the message originator. Mandatory setting unless a registry
         * based FromHeader is specified.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default SipEndpointBuilder fromPort(String fromPort) {
            setProperty("fromPort", fromPort);
            return this;
        }
        /**
         * Username of the message originator. Mandatory setting unless a
         * registry based custom FromHeader is specified.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SipEndpointBuilder fromUser(String fromUser) {
            setProperty("fromUser", fromUser);
            return this;
        }
        /**
         * The amount of time a message received at an endpoint is considered
         * valid.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default SipEndpointBuilder msgExpiration(int msgExpiration) {
            setProperty("msgExpiration", msgExpiration);
            return this;
        }
        /**
         * The amount of time a message received at an endpoint is considered
         * valid.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default SipEndpointBuilder msgExpiration(String msgExpiration) {
            setProperty("msgExpiration", msgExpiration);
            return this;
        }
        /**
         * Setting for specifying amount of time to wait for a Response and/or
         * Acknowledgement can be received from another SIP stack.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: common
         */
        default SipEndpointBuilder receiveTimeoutMillis(
                long receiveTimeoutMillis) {
            setProperty("receiveTimeoutMillis", receiveTimeoutMillis);
            return this;
        }
        /**
         * Setting for specifying amount of time to wait for a Response and/or
         * Acknowledgement can be received from another SIP stack.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: common
         */
        default SipEndpointBuilder receiveTimeoutMillis(
                String receiveTimeoutMillis) {
            setProperty("receiveTimeoutMillis", receiveTimeoutMillis);
            return this;
        }
        /**
         * Name of the SIP Stack instance associated with an SIP Endpoint.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SipEndpointBuilder stackName(String stackName) {
            setProperty("stackName", stackName);
            return this;
        }
        /**
         * Hostname of the message receiver. Mandatory setting unless a registry
         * based ToHeader is specified.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SipEndpointBuilder toHost(String toHost) {
            setProperty("toHost", toHost);
            return this;
        }
        /**
         * Portname of the message receiver. Mandatory setting unless a registry
         * based ToHeader is specified.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: common
         */
        default SipEndpointBuilder toPort(int toPort) {
            setProperty("toPort", toPort);
            return this;
        }
        /**
         * Portname of the message receiver. Mandatory setting unless a registry
         * based ToHeader is specified.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: common
         */
        default SipEndpointBuilder toPort(String toPort) {
            setProperty("toPort", toPort);
            return this;
        }
        /**
         * Username of the message receiver. Mandatory setting unless a registry
         * based custom ToHeader is specified.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SipEndpointBuilder toUser(String toUser) {
            setProperty("toUser", toUser);
            return this;
        }
        /**
         * Setting for choice of transport protocol. Valid choices are tcp or
         * udp.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default SipEndpointBuilder transport(String transport) {
            setProperty("transport", transport);
            return this;
        }
        /**
         * Name of client debug log file to use for logging.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: logging
         */
        default SipEndpointBuilder implementationDebugLogFile(
                String implementationDebugLogFile) {
            setProperty("implementationDebugLogFile", implementationDebugLogFile);
            return this;
        }
        /**
         * Name of server log file to use for logging.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: logging
         */
        default SipEndpointBuilder implementationServerLogFile(
                String implementationServerLogFile) {
            setProperty("implementationServerLogFile", implementationServerLogFile);
            return this;
        }
        /**
         * Logging level for tracing.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: logging
         */
        default SipEndpointBuilder implementationTraceLevel(
                String implementationTraceLevel) {
            setProperty("implementationTraceLevel", implementationTraceLevel);
            return this;
        }
        /**
         * Number of maximum proxy forwards.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: proxy
         */
        default SipEndpointBuilder maxForwards(int maxForwards) {
            setProperty("maxForwards", maxForwards);
            return this;
        }
        /**
         * Number of maximum proxy forwards.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: proxy
         */
        default SipEndpointBuilder maxForwards(String maxForwards) {
            setProperty("maxForwards", maxForwards);
            return this;
        }
        /**
         * This setting is used when requests are sent to the Presence Agent via
         * a proxy.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: proxy
         */
        default SipEndpointBuilder useRouterForAllUris(
                boolean useRouterForAllUris) {
            setProperty("useRouterForAllUris", useRouterForAllUris);
            return this;
        }
        /**
         * This setting is used when requests are sent to the Presence Agent via
         * a proxy.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: proxy
         */
        default SipEndpointBuilder useRouterForAllUris(
                String useRouterForAllUris) {
            setProperty("useRouterForAllUris", useRouterForAllUris);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the SIP component.
     */
    public interface AdvancedSipEndpointBuilder
            extends
                AdvancedSipEndpointConsumerBuilder, AdvancedSipEndpointProducerBuilder {
        default SipEndpointBuilder basic() {
            return (SipEndpointBuilder) this;
        }
        /**
         * To use a custom AddressFactory.
         * 
         * The option is a: <code>javax.sip.address.AddressFactory</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointBuilder addressFactory(Object addressFactory) {
            setProperty("addressFactory", addressFactory);
            return this;
        }
        /**
         * To use a custom AddressFactory.
         * 
         * The option will be converted to a
         * <code>javax.sip.address.AddressFactory</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointBuilder addressFactory(String addressFactory) {
            setProperty("addressFactory", addressFactory);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * A custom Header object containing call details. Must implement the
         * type javax.sip.header.CallIdHeader.
         * 
         * The option is a: <code>javax.sip.header.CallIdHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointBuilder callIdHeader(Object callIdHeader) {
            setProperty("callIdHeader", callIdHeader);
            return this;
        }
        /**
         * A custom Header object containing call details. Must implement the
         * type javax.sip.header.CallIdHeader.
         * 
         * The option will be converted to a
         * <code>javax.sip.header.CallIdHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointBuilder callIdHeader(String callIdHeader) {
            setProperty("callIdHeader", callIdHeader);
            return this;
        }
        /**
         * An optional custom Header object containing verbose contact details
         * (email, phone number etc). Must implement the type
         * javax.sip.header.ContactHeader.
         * 
         * The option is a: <code>javax.sip.header.ContactHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointBuilder contactHeader(Object contactHeader) {
            setProperty("contactHeader", contactHeader);
            return this;
        }
        /**
         * An optional custom Header object containing verbose contact details
         * (email, phone number etc). Must implement the type
         * javax.sip.header.ContactHeader.
         * 
         * The option will be converted to a
         * <code>javax.sip.header.ContactHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointBuilder contactHeader(String contactHeader) {
            setProperty("contactHeader", contactHeader);
            return this;
        }
        /**
         * A custom Header object containing message content details. Must
         * implement the type javax.sip.header.ContentTypeHeader.
         * 
         * The option is a: <code>javax.sip.header.ContentTypeHeader</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointBuilder contentTypeHeader(
                Object contentTypeHeader) {
            setProperty("contentTypeHeader", contentTypeHeader);
            return this;
        }
        /**
         * A custom Header object containing message content details. Must
         * implement the type javax.sip.header.ContentTypeHeader.
         * 
         * The option will be converted to a
         * <code>javax.sip.header.ContentTypeHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointBuilder contentTypeHeader(
                String contentTypeHeader) {
            setProperty("contentTypeHeader", contentTypeHeader);
            return this;
        }
        /**
         * A custom Header object containing event details. Must implement the
         * type javax.sip.header.EventHeader.
         * 
         * The option is a: <code>javax.sip.header.EventHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointBuilder eventHeader(Object eventHeader) {
            setProperty("eventHeader", eventHeader);
            return this;
        }
        /**
         * A custom Header object containing event details. Must implement the
         * type javax.sip.header.EventHeader.
         * 
         * The option will be converted to a
         * <code>javax.sip.header.EventHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointBuilder eventHeader(String eventHeader) {
            setProperty("eventHeader", eventHeader);
            return this;
        }
        /**
         * A custom Header object containing message expiration details. Must
         * implement the type javax.sip.header.ExpiresHeader.
         * 
         * The option is a: <code>javax.sip.header.ExpiresHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointBuilder expiresHeader(Object expiresHeader) {
            setProperty("expiresHeader", expiresHeader);
            return this;
        }
        /**
         * A custom Header object containing message expiration details. Must
         * implement the type javax.sip.header.ExpiresHeader.
         * 
         * The option will be converted to a
         * <code>javax.sip.header.ExpiresHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointBuilder expiresHeader(String expiresHeader) {
            setProperty("expiresHeader", expiresHeader);
            return this;
        }
        /**
         * A custom Header object containing user/application specific details.
         * Must implement the type javax.sip.header.ExtensionHeader.
         * 
         * The option is a: <code>javax.sip.header.ExtensionHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointBuilder extensionHeader(
                Object extensionHeader) {
            setProperty("extensionHeader", extensionHeader);
            return this;
        }
        /**
         * A custom Header object containing user/application specific details.
         * Must implement the type javax.sip.header.ExtensionHeader.
         * 
         * The option will be converted to a
         * <code>javax.sip.header.ExtensionHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointBuilder extensionHeader(
                String extensionHeader) {
            setProperty("extensionHeader", extensionHeader);
            return this;
        }
        /**
         * A custom Header object containing message originator settings. Must
         * implement the type javax.sip.header.FromHeader.
         * 
         * The option is a: <code>javax.sip.header.FromHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointBuilder fromHeader(Object fromHeader) {
            setProperty("fromHeader", fromHeader);
            return this;
        }
        /**
         * A custom Header object containing message originator settings. Must
         * implement the type javax.sip.header.FromHeader.
         * 
         * The option will be converted to a
         * <code>javax.sip.header.FromHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointBuilder fromHeader(String fromHeader) {
            setProperty("fromHeader", fromHeader);
            return this;
        }
        /**
         * To use a custom HeaderFactory.
         * 
         * The option is a: <code>javax.sip.header.HeaderFactory</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointBuilder headerFactory(Object headerFactory) {
            setProperty("headerFactory", headerFactory);
            return this;
        }
        /**
         * To use a custom HeaderFactory.
         * 
         * The option will be converted to a
         * <code>javax.sip.header.HeaderFactory</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointBuilder headerFactory(String headerFactory) {
            setProperty("headerFactory", headerFactory);
            return this;
        }
        /**
         * To use a custom ListeningPoint implementation.
         * 
         * The option is a: <code>javax.sip.ListeningPoint</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointBuilder listeningPoint(Object listeningPoint) {
            setProperty("listeningPoint", listeningPoint);
            return this;
        }
        /**
         * To use a custom ListeningPoint implementation.
         * 
         * The option will be converted to a
         * <code>javax.sip.ListeningPoint</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointBuilder listeningPoint(String listeningPoint) {
            setProperty("listeningPoint", listeningPoint);
            return this;
        }
        /**
         * A custom Header object containing details on maximum proxy forwards.
         * This header places a limit on the viaHeaders possible. Must implement
         * the type javax.sip.header.MaxForwardsHeader.
         * 
         * The option is a: <code>javax.sip.header.MaxForwardsHeader</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointBuilder maxForwardsHeader(
                Object maxForwardsHeader) {
            setProperty("maxForwardsHeader", maxForwardsHeader);
            return this;
        }
        /**
         * A custom Header object containing details on maximum proxy forwards.
         * This header places a limit on the viaHeaders possible. Must implement
         * the type javax.sip.header.MaxForwardsHeader.
         * 
         * The option will be converted to a
         * <code>javax.sip.header.MaxForwardsHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointBuilder maxForwardsHeader(
                String maxForwardsHeader) {
            setProperty("maxForwardsHeader", maxForwardsHeader);
            return this;
        }
        /**
         * Setting for maximum allowed Message size in bytes.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointBuilder maxMessageSize(int maxMessageSize) {
            setProperty("maxMessageSize", maxMessageSize);
            return this;
        }
        /**
         * Setting for maximum allowed Message size in bytes.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointBuilder maxMessageSize(String maxMessageSize) {
            setProperty("maxMessageSize", maxMessageSize);
            return this;
        }
        /**
         * To use a custom MessageFactory.
         * 
         * The option is a: <code>javax.sip.message.MessageFactory</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointBuilder messageFactory(Object messageFactory) {
            setProperty("messageFactory", messageFactory);
            return this;
        }
        /**
         * To use a custom MessageFactory.
         * 
         * The option will be converted to a
         * <code>javax.sip.message.MessageFactory</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointBuilder messageFactory(String messageFactory) {
            setProperty("messageFactory", messageFactory);
            return this;
        }
        /**
         * To use a custom SipFactory to create the SipStack to be used.
         * 
         * The option is a: <code>javax.sip.SipFactory</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointBuilder sipFactory(Object sipFactory) {
            setProperty("sipFactory", sipFactory);
            return this;
        }
        /**
         * To use a custom SipFactory to create the SipStack to be used.
         * 
         * The option will be converted to a <code>javax.sip.SipFactory</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointBuilder sipFactory(String sipFactory) {
            setProperty("sipFactory", sipFactory);
            return this;
        }
        /**
         * To use a custom SipStack.
         * 
         * The option is a: <code>javax.sip.SipStack</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointBuilder sipStack(Object sipStack) {
            setProperty("sipStack", sipStack);
            return this;
        }
        /**
         * To use a custom SipStack.
         * 
         * The option will be converted to a <code>javax.sip.SipStack</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointBuilder sipStack(String sipStack) {
            setProperty("sipStack", sipStack);
            return this;
        }
        /**
         * To use a custom SipURI. If none configured, then the SipUri fallback
         * to use the options toUser toHost:toPort.
         * 
         * The option is a: <code>javax.sip.address.SipURI</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointBuilder sipUri(Object sipUri) {
            setProperty("sipUri", sipUri);
            return this;
        }
        /**
         * To use a custom SipURI. If none configured, then the SipUri fallback
         * to use the options toUser toHost:toPort.
         * 
         * The option will be converted to a
         * <code>javax.sip.address.SipURI</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointBuilder sipUri(String sipUri) {
            setProperty("sipUri", sipUri);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointBuilder synchronous(boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointBuilder synchronous(String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * A custom Header object containing message receiver settings. Must
         * implement the type javax.sip.header.ToHeader.
         * 
         * The option is a: <code>javax.sip.header.ToHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointBuilder toHeader(Object toHeader) {
            setProperty("toHeader", toHeader);
            return this;
        }
        /**
         * A custom Header object containing message receiver settings. Must
         * implement the type javax.sip.header.ToHeader.
         * 
         * The option will be converted to a
         * <code>javax.sip.header.ToHeader</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointBuilder toHeader(String toHeader) {
            setProperty("toHeader", toHeader);
            return this;
        }
        /**
         * List of custom Header objects of the type javax.sip.header.ViaHeader.
         * Each ViaHeader containing a proxy address for request forwarding.
         * (Note this header is automatically updated by each proxy when the
         * request arrives at its listener).
         * 
         * The option is a:
         * <code>java.util.List&lt;javax.sip.header.ViaHeader&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointBuilder viaHeaders(List<Object> viaHeaders) {
            setProperty("viaHeaders", viaHeaders);
            return this;
        }
        /**
         * List of custom Header objects of the type javax.sip.header.ViaHeader.
         * Each ViaHeader containing a proxy address for request forwarding.
         * (Note this header is automatically updated by each proxy when the
         * request arrives at its listener).
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;javax.sip.header.ViaHeader&gt;</code> type.
         * 
         * Group: advanced
         */
        default AdvancedSipEndpointBuilder viaHeaders(String viaHeaders) {
            setProperty("viaHeaders", viaHeaders);
            return this;
        }
    }
    /**
     * SIP (camel-sip)
     * To send and receive messages using the SIP protocol (used in telco and
     * mobile).
     * 
     * Category: mobile
     * Available as of version: 2.5
     * Maven coordinates: org.apache.camel:camel-sip
     * 
     * Syntax: <code>sip:uri</code>
     * 
     * Path parameter: uri (required)
     * URI of the SIP server to connect to (the username and password can be
     * included such as: john:secretmyserver:9999)
     */
    default SipEndpointBuilder sip(String path) {
        class SipEndpointBuilderImpl extends AbstractEndpointBuilder implements SipEndpointBuilder, AdvancedSipEndpointBuilder {
            public SipEndpointBuilderImpl(String path) {
                super("sip", path);
            }
        }
        return new SipEndpointBuilderImpl(path);
    }
}