/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import javax.annotation.Generated;
import org.apache.camel.Expression;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * To copy files using the secure copy protocol (SCP).
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface ScpEndpointBuilderFactory {


    /**
     * Builder for endpoint for the SCP component.
     */
    public interface ScpEndpointBuilder extends EndpointProducerBuilder {
        default AdvancedScpEndpointBuilder advanced() {
            return (AdvancedScpEndpointBuilder) this;
        }
        /**
         * Whether or not to disconnect from remote FTP server right after use.
         * Disconnect will only disconnect the current connection to the FTP
         * server. If you have a consumer which you want to stop, then you need
         * to stop the consumer/route instead.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default ScpEndpointBuilder disconnect(boolean disconnect) {
            setProperty("disconnect", disconnect);
            return this;
        }
        /**
         * Whether or not to disconnect from remote FTP server right after use.
         * Disconnect will only disconnect the current connection to the FTP
         * server. If you have a consumer which you want to stop, then you need
         * to stop the consumer/route instead.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default ScpEndpointBuilder disconnect(String disconnect) {
            setProperty("disconnect", disconnect);
            return this;
        }
        /**
         * Allows you to set chmod on the stored file. For example chmod=664.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default ScpEndpointBuilder chmod(String chmod) {
            setProperty("chmod", chmod);
            return this;
        }
        /**
         * Use Expression such as File Language to dynamically set the filename.
         * For consumers, it's used as a filename filter. For producers, it's
         * used to evaluate the filename to write. If an expression is set, it
         * take precedence over the CamelFileName header. (Note: The header
         * itself can also be an Expression). The expression options support
         * both String and Expression types. If the expression is a String type,
         * it is always evaluated using the File Language. If the expression is
         * an Expression type, the specified Expression type is used - this
         * allows you, for instance, to use OGNL expressions. For the consumer,
         * you can use it to filter filenames, so you can for instance consume
         * today's file using the File Language syntax:
         * mydata-${date:now:yyyyMMdd}.txt. The producers support the
         * CamelOverruleFileName header which takes precedence over any existing
         * CamelFileName header; the CamelOverruleFileName is a header that is
         * used only once, and makes it easier as this avoids to temporary store
         * CamelFileName and have to restore it afterwards.
         * 
         * The option is a: <code>org.apache.camel.Expression</code> type.
         * 
         * Group: producer
         */
        default ScpEndpointBuilder fileName(Expression fileName) {
            setProperty("fileName", fileName);
            return this;
        }
        /**
         * Use Expression such as File Language to dynamically set the filename.
         * For consumers, it's used as a filename filter. For producers, it's
         * used to evaluate the filename to write. If an expression is set, it
         * take precedence over the CamelFileName header. (Note: The header
         * itself can also be an Expression). The expression options support
         * both String and Expression types. If the expression is a String type,
         * it is always evaluated using the File Language. If the expression is
         * an Expression type, the specified Expression type is used - this
         * allows you, for instance, to use OGNL expressions. For the consumer,
         * you can use it to filter filenames, so you can for instance consume
         * today's file using the File Language syntax:
         * mydata-${date:now:yyyyMMdd}.txt. The producers support the
         * CamelOverruleFileName header which takes precedence over any existing
         * CamelFileName header; the CamelOverruleFileName is a header that is
         * used only once, and makes it easier as this avoids to temporary store
         * CamelFileName and have to restore it afterwards.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.Expression</code> type.
         * 
         * Group: producer
         */
        default ScpEndpointBuilder fileName(String fileName) {
            setProperty("fileName", fileName);
            return this;
        }
        /**
         * Sets whether to use strict host key checking. Possible values are:
         * no, yes.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default ScpEndpointBuilder strictHostKeyChecking(
                String strictHostKeyChecking) {
            setProperty("strictHostKeyChecking", strictHostKeyChecking);
            return this;
        }
        /**
         * Sets the known_hosts file, so that the jsch endpoint can do host key
         * verification. You can prefix with classpath: to load the file from
         * classpath instead of file system.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default ScpEndpointBuilder knownHostsFile(String knownHostsFile) {
            setProperty("knownHostsFile", knownHostsFile);
            return this;
        }
        /**
         * Password to use for login.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default ScpEndpointBuilder password(String password) {
            setProperty("password", password);
            return this;
        }
        /**
         * Set a comma separated list of authentications that will be used in
         * order of preference. Possible authentication methods are defined by
         * JCraft JSCH. Some examples include:
         * gssapi-with-mic,publickey,keyboard-interactive,password If not
         * specified the JSCH and/or system defaults will be used.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default ScpEndpointBuilder preferredAuthentications(
                String preferredAuthentications) {
            setProperty("preferredAuthentications", preferredAuthentications);
            return this;
        }
        /**
         * Set the private key bytes to that the endpoint can do private key
         * verification. This must be used only if privateKeyFile wasn't set.
         * Otherwise the file will have the priority.
         * 
         * The option is a: <code>byte[]</code> type.
         * 
         * Group: security
         */
        default ScpEndpointBuilder privateKeyBytes(Byte[] privateKeyBytes) {
            setProperty("privateKeyBytes", privateKeyBytes);
            return this;
        }
        /**
         * Set the private key bytes to that the endpoint can do private key
         * verification. This must be used only if privateKeyFile wasn't set.
         * Otherwise the file will have the priority.
         * 
         * The option will be converted to a <code>byte[]</code> type.
         * 
         * Group: security
         */
        default ScpEndpointBuilder privateKeyBytes(String privateKeyBytes) {
            setProperty("privateKeyBytes", privateKeyBytes);
            return this;
        }
        /**
         * Set the private key file to that the endpoint can do private key
         * verification. You can prefix with classpath: to load the file from
         * classpath instead of file system.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default ScpEndpointBuilder privateKeyFile(String privateKeyFile) {
            setProperty("privateKeyFile", privateKeyFile);
            return this;
        }
        /**
         * Set the private key file passphrase to that the endpoint can do
         * private key verification.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default ScpEndpointBuilder privateKeyFilePassphrase(
                String privateKeyFilePassphrase) {
            setProperty("privateKeyFilePassphrase", privateKeyFilePassphrase);
            return this;
        }
        /**
         * Username to use for login.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default ScpEndpointBuilder username(String username) {
            setProperty("username", username);
            return this;
        }
        /**
         * If knownHostFile has not been explicit configured, then use the host
         * file from System.getProperty(user.home) /.ssh/known_hosts.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: security
         */
        default ScpEndpointBuilder useUserKnownHostsFile(
                boolean useUserKnownHostsFile) {
            setProperty("useUserKnownHostsFile", useUserKnownHostsFile);
            return this;
        }
        /**
         * If knownHostFile has not been explicit configured, then use the host
         * file from System.getProperty(user.home) /.ssh/known_hosts.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: security
         */
        default ScpEndpointBuilder useUserKnownHostsFile(
                String useUserKnownHostsFile) {
            setProperty("useUserKnownHostsFile", useUserKnownHostsFile);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the SCP component.
     */
    public interface AdvancedScpEndpointBuilder
            extends
                EndpointProducerBuilder {
        default ScpEndpointBuilder basic() {
            return (ScpEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedScpEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedScpEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets the connect timeout for waiting for a connection to be
         * established Used by both FTPClient and JSCH.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedScpEndpointBuilder connectTimeout(int connectTimeout) {
            setProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * Sets the connect timeout for waiting for a connection to be
         * established Used by both FTPClient and JSCH.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedScpEndpointBuilder connectTimeout(String connectTimeout) {
            setProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * Sets the so timeout FTP and FTPS Only for Camel 2.4. SFTP for Camel
         * 2.14.3/2.15.3/2.16 onwards. Is the SocketOptions.SO_TIMEOUT value in
         * millis. Recommended option is to set this to 300000 so as not have a
         * hanged connection. On SFTP this option is set as timeout on the JSCH
         * Session instance.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedScpEndpointBuilder soTimeout(int soTimeout) {
            setProperty("soTimeout", soTimeout);
            return this;
        }
        /**
         * Sets the so timeout FTP and FTPS Only for Camel 2.4. SFTP for Camel
         * 2.14.3/2.15.3/2.16 onwards. Is the SocketOptions.SO_TIMEOUT value in
         * millis. Recommended option is to set this to 300000 so as not have a
         * hanged connection. On SFTP this option is set as timeout on the JSCH
         * Session instance.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedScpEndpointBuilder soTimeout(String soTimeout) {
            setProperty("soTimeout", soTimeout);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedScpEndpointBuilder synchronous(boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedScpEndpointBuilder synchronous(String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets the data timeout for waiting for reply Used only by FTPClient.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedScpEndpointBuilder timeout(int timeout) {
            setProperty("timeout", timeout);
            return this;
        }
        /**
         * Sets the data timeout for waiting for reply Used only by FTPClient.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: advanced
         */
        default AdvancedScpEndpointBuilder timeout(String timeout) {
            setProperty("timeout", timeout);
            return this;
        }
        /**
         * Set a comma separated list of ciphers that will be used in order of
         * preference. Possible cipher names are defined by JCraft JSCH. Some
         * examples include:
         * aes128-ctr,aes128-cbc,3des-ctr,3des-cbc,blowfish-cbc,aes192-cbc,aes256-cbc. If not specified the default list from JSCH will be used.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security (advanced)
         */
        default AdvancedScpEndpointBuilder ciphers(String ciphers) {
            setProperty("ciphers", ciphers);
            return this;
        }
    }
    /**
     * SCP (camel-jsch)
     * To copy files using the secure copy protocol (SCP).
     * 
     * Category: file
     * Available as of version: 2.10
     * Maven coordinates: org.apache.camel:camel-jsch
     * 
     * Syntax: <code>scp:host:port/directoryName</code>
     * 
     * Path parameter: host (required)
     * Hostname of the FTP server
     * 
     * Path parameter: port
     * Port of the FTP server
     * 
     * Path parameter: directoryName
     * The starting directory
     */
    default ScpEndpointBuilder scp(String path) {
        class ScpEndpointBuilderImpl extends AbstractEndpointBuilder implements ScpEndpointBuilder, AdvancedScpEndpointBuilder {
            public ScpEndpointBuilderImpl(String path) {
                super("scp", path);
            }
        }
        return new ScpEndpointBuilderImpl(path);
    }
}