/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.spi.ScheduledPollConsumerScheduler;

/**
 * The aws-s3 component is used for storing and retrieving objecct from Amazon
 * S3 Storage Service.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface S3EndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the AWS S3 Storage Service component.
     */
    public interface S3EndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedS3EndpointConsumerBuilder advanced() {
            return (AdvancedS3EndpointConsumerBuilder) this;
        }
        /**
         * Reference to a com.amazonaws.services.s3.AmazonS3 in the registry.
         * 
         * The option is a: <code>com.amazonaws.services.s3.AmazonS3</code>
         * type.
         * 
         * Group: common
         */
        default S3EndpointConsumerBuilder amazonS3Client(Object amazonS3Client) {
            setProperty("amazonS3Client", amazonS3Client);
            return this;
        }
        /**
         * Reference to a com.amazonaws.services.s3.AmazonS3 in the registry.
         * 
         * The option will be converted to a
         * <code>com.amazonaws.services.s3.AmazonS3</code> type.
         * 
         * Group: common
         */
        default S3EndpointConsumerBuilder amazonS3Client(String amazonS3Client) {
            setProperty("amazonS3Client", amazonS3Client);
            return this;
        }
        /**
         * Setting the autocreation of the bucket.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default S3EndpointConsumerBuilder autoCreateBucket(
                boolean autoCreateBucket) {
            setProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }
        /**
         * Setting the autocreation of the bucket.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default S3EndpointConsumerBuilder autoCreateBucket(
                String autoCreateBucket) {
            setProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }
        /**
         * Whether or not the S3 client should use path style access.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default S3EndpointConsumerBuilder pathStyleAccess(
                boolean pathStyleAccess) {
            setProperty("pathStyleAccess", pathStyleAccess);
            return this;
        }
        /**
         * Whether or not the S3 client should use path style access.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default S3EndpointConsumerBuilder pathStyleAccess(String pathStyleAccess) {
            setProperty("pathStyleAccess", pathStyleAccess);
            return this;
        }
        /**
         * The policy for this queue to set in the
         * com.amazonaws.services.s3.AmazonS3#setBucketPolicy() method.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default S3EndpointConsumerBuilder policy(String policy) {
            setProperty("policy", policy);
            return this;
        }
        /**
         * To define a proxy host when instantiating the SQS client.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default S3EndpointConsumerBuilder proxyHost(String proxyHost) {
            setProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * Specify a proxy port to be used inside the client definition.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default S3EndpointConsumerBuilder proxyPort(Integer proxyPort) {
            setProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * Specify a proxy port to be used inside the client definition.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default S3EndpointConsumerBuilder proxyPort(String proxyPort) {
            setProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * The region in which S3 client needs to work. When using this
         * parameter, the configuration will expect the capitalized name of the
         * region (for example AP_EAST_1) You'll need to use the name
         * Regions.EU_WEST_1.name().
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default S3EndpointConsumerBuilder region(String region) {
            setProperty("region", region);
            return this;
        }
        /**
         * Set whether the S3 client should expect to load credentials on an EC2
         * instance or to expect static credentials to be passed in.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default S3EndpointConsumerBuilder useIAMCredentials(
                boolean useIAMCredentials) {
            setProperty("useIAMCredentials", useIAMCredentials);
            return this;
        }
        /**
         * Set whether the S3 client should expect to load credentials on an EC2
         * instance or to expect static credentials to be passed in.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default S3EndpointConsumerBuilder useIAMCredentials(
                String useIAMCredentials) {
            setProperty("useIAMCredentials", useIAMCredentials);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default S3EndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            setProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default S3EndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            setProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Delete objects from S3 after they have been retrieved. The delete is
         * only performed if the Exchange is committed. If a rollback occurs,
         * the object is not deleted. If this option is false, then the same
         * objects will be retrieve over and over again on the polls. Therefore
         * you need to use the Idempotent Consumer EIP in the route to filter
         * out duplicates. You can filter using the S3Constants#BUCKET_NAME and
         * S3Constants#KEY headers, or only the S3Constants#KEY header.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default S3EndpointConsumerBuilder deleteAfterRead(
                boolean deleteAfterRead) {
            setProperty("deleteAfterRead", deleteAfterRead);
            return this;
        }
        /**
         * Delete objects from S3 after they have been retrieved. The delete is
         * only performed if the Exchange is committed. If a rollback occurs,
         * the object is not deleted. If this option is false, then the same
         * objects will be retrieve over and over again on the polls. Therefore
         * you need to use the Idempotent Consumer EIP in the route to filter
         * out duplicates. You can filter using the S3Constants#BUCKET_NAME and
         * S3Constants#KEY headers, or only the S3Constants#KEY header.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default S3EndpointConsumerBuilder deleteAfterRead(String deleteAfterRead) {
            setProperty("deleteAfterRead", deleteAfterRead);
            return this;
        }
        /**
         * The delimiter which is used in the
         * com.amazonaws.services.s3.model.ListObjectsRequest to only consume
         * objects we are interested in.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default S3EndpointConsumerBuilder delimiter(String delimiter) {
            setProperty("delimiter", delimiter);
            return this;
        }
        /**
         * To get the object from the bucket with the given file name.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default S3EndpointConsumerBuilder fileName(String fileName) {
            setProperty("fileName", fileName);
            return this;
        }
        /**
         * If it is true, the exchange body will be set to a stream to the
         * contents of the file. If false, the headers will be set with the S3
         * object metadata, but the body will be null. This option is strongly
         * related to autocloseBody option. In case of setting includeBody to
         * true and autocloseBody to false, it will be up to the caller to close
         * the S3Object stream. Setting autocloseBody to true, will close the
         * S3Object stream automatically.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default S3EndpointConsumerBuilder includeBody(boolean includeBody) {
            setProperty("includeBody", includeBody);
            return this;
        }
        /**
         * If it is true, the exchange body will be set to a stream to the
         * contents of the file. If false, the headers will be set with the S3
         * object metadata, but the body will be null. This option is strongly
         * related to autocloseBody option. In case of setting includeBody to
         * true and autocloseBody to false, it will be up to the caller to close
         * the S3Object stream. Setting autocloseBody to true, will close the
         * S3Object stream automatically.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default S3EndpointConsumerBuilder includeBody(String includeBody) {
            setProperty("includeBody", includeBody);
            return this;
        }
        /**
         * Set the maxConnections parameter in the S3 client configuration.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: consumer
         */
        default S3EndpointConsumerBuilder maxConnections(int maxConnections) {
            setProperty("maxConnections", maxConnections);
            return this;
        }
        /**
         * Set the maxConnections parameter in the S3 client configuration.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: consumer
         */
        default S3EndpointConsumerBuilder maxConnections(String maxConnections) {
            setProperty("maxConnections", maxConnections);
            return this;
        }
        /**
         * Gets the maximum number of messages as a limit to poll at each
         * polling. Is default unlimited, but use 0 or negative number to
         * disable it as unlimited.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: consumer
         */
        default S3EndpointConsumerBuilder maxMessagesPerPoll(
                int maxMessagesPerPoll) {
            setProperty("maxMessagesPerPoll", maxMessagesPerPoll);
            return this;
        }
        /**
         * Gets the maximum number of messages as a limit to poll at each
         * polling. Is default unlimited, but use 0 or negative number to
         * disable it as unlimited.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: consumer
         */
        default S3EndpointConsumerBuilder maxMessagesPerPoll(
                String maxMessagesPerPoll) {
            setProperty("maxMessagesPerPoll", maxMessagesPerPoll);
            return this;
        }
        /**
         * The prefix which is used in the
         * com.amazonaws.services.s3.model.ListObjectsRequest to only consume
         * objects we are interested in.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: consumer
         */
        default S3EndpointConsumerBuilder prefix(String prefix) {
            setProperty("prefix", prefix);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default S3EndpointConsumerBuilder sendEmptyMessageWhenIdle(
                boolean sendEmptyMessageWhenIdle) {
            setProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default S3EndpointConsumerBuilder sendEmptyMessageWhenIdle(
                String sendEmptyMessageWhenIdle) {
            setProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default S3EndpointConsumerBuilder backoffErrorThreshold(
                int backoffErrorThreshold) {
            setProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default S3EndpointConsumerBuilder backoffErrorThreshold(
                String backoffErrorThreshold) {
            setProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default S3EndpointConsumerBuilder backoffIdleThreshold(
                int backoffIdleThreshold) {
            setProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default S3EndpointConsumerBuilder backoffIdleThreshold(
                String backoffIdleThreshold) {
            setProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: scheduler
         */
        default S3EndpointConsumerBuilder backoffMultiplier(
                int backoffMultiplier) {
            setProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: scheduler
         */
        default S3EndpointConsumerBuilder backoffMultiplier(
                String backoffMultiplier) {
            setProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * Milliseconds before the next poll. You can also specify time values
         * using units, such as 60s (60 seconds), 5m30s (5 minutes and 30
         * seconds), and 1h (1 hour).
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: scheduler
         */
        default S3EndpointConsumerBuilder delay(long delay) {
            setProperty("delay", delay);
            return this;
        }
        /**
         * Milliseconds before the next poll. You can also specify time values
         * using units, such as 60s (60 seconds), 5m30s (5 minutes and 30
         * seconds), and 1h (1 hour).
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: scheduler
         */
        default S3EndpointConsumerBuilder delay(String delay) {
            setProperty("delay", delay);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default S3EndpointConsumerBuilder greedy(boolean greedy) {
            setProperty("greedy", greedy);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default S3EndpointConsumerBuilder greedy(String greedy) {
            setProperty("greedy", greedy);
            return this;
        }
        /**
         * Milliseconds before the first poll starts. You can also specify time
         * values using units, such as 60s (60 seconds), 5m30s (5 minutes and 30
         * seconds), and 1h (1 hour).
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: scheduler
         */
        default S3EndpointConsumerBuilder initialDelay(long initialDelay) {
            setProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Milliseconds before the first poll starts. You can also specify time
         * values using units, such as 60s (60 seconds), 5m30s (5 minutes and 30
         * seconds), and 1h (1 hour).
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: scheduler
         */
        default S3EndpointConsumerBuilder initialDelay(String initialDelay) {
            setProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option is a: <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Group: scheduler
         */
        default S3EndpointConsumerBuilder runLoggingLevel(
                LoggingLevel runLoggingLevel) {
            setProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.LoggingLevel</code> type.
         * 
         * Group: scheduler
         */
        default S3EndpointConsumerBuilder runLoggingLevel(String runLoggingLevel) {
            setProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option is a:
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         */
        default S3EndpointConsumerBuilder scheduledExecutorService(
                ScheduledExecutorService scheduledExecutorService) {
            setProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.ScheduledExecutorService</code> type.
         * 
         * Group: scheduler
         */
        default S3EndpointConsumerBuilder scheduledExecutorService(
                String scheduledExecutorService) {
            setProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz2
         * component.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.ScheduledPollConsumerScheduler</code>
         * type.
         * 
         * Group: scheduler
         */
        default S3EndpointConsumerBuilder scheduler(
                ScheduledPollConsumerScheduler scheduler) {
            setProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz2
         * component.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ScheduledPollConsumerScheduler</code>
         * type.
         * 
         * Group: scheduler
         */
        default S3EndpointConsumerBuilder scheduler(String scheduler) {
            setProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz2, Spring based scheduler.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.Object&gt;</code> type.
         * 
         * Group: scheduler
         */
        default S3EndpointConsumerBuilder schedulerProperties(
                Map<String, Object> schedulerProperties) {
            setProperty("schedulerProperties", schedulerProperties);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz2, Spring based scheduler.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.Object&gt;</code>
         * type.
         * 
         * Group: scheduler
         */
        default S3EndpointConsumerBuilder schedulerProperties(
                String schedulerProperties) {
            setProperty("schedulerProperties", schedulerProperties);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default S3EndpointConsumerBuilder startScheduler(boolean startScheduler) {
            setProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default S3EndpointConsumerBuilder startScheduler(String startScheduler) {
            setProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option is a: <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Group: scheduler
         */
        default S3EndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            setProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Group: scheduler
         */
        default S3EndpointConsumerBuilder timeUnit(String timeUnit) {
            setProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default S3EndpointConsumerBuilder useFixedDelay(boolean useFixedDelay) {
            setProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: scheduler
         */
        default S3EndpointConsumerBuilder useFixedDelay(String useFixedDelay) {
            setProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Amazon AWS Access Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default S3EndpointConsumerBuilder accessKey(String accessKey) {
            setProperty("accessKey", accessKey);
            return this;
        }
        /**
         * Amazon AWS Secret Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default S3EndpointConsumerBuilder secretKey(String secretKey) {
            setProperty("secretKey", secretKey);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the AWS S3 Storage Service
     * component.
     */
    public interface AdvancedS3EndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default S3EndpointConsumerBuilder basic() {
            return (S3EndpointConsumerBuilder) this;
        }
        /**
         * The encryption materials to use in case of Symmetric/Asymmetric
         * client usage.
         * 
         * The option is a:
         * <code>com.amazonaws.services.s3.model.EncryptionMaterials</code>
         * type.
         * 
         * Group: common (advanced)
         */
        default AdvancedS3EndpointConsumerBuilder encryptionMaterials(
                Object encryptionMaterials) {
            setProperty("encryptionMaterials", encryptionMaterials);
            return this;
        }
        /**
         * The encryption materials to use in case of Symmetric/Asymmetric
         * client usage.
         * 
         * The option will be converted to a
         * <code>com.amazonaws.services.s3.model.EncryptionMaterials</code>
         * type.
         * 
         * Group: common (advanced)
         */
        default AdvancedS3EndpointConsumerBuilder encryptionMaterials(
                String encryptionMaterials) {
            setProperty("encryptionMaterials", encryptionMaterials);
            return this;
        }
        /**
         * Define if encryption must be used or not.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common (advanced)
         */
        default AdvancedS3EndpointConsumerBuilder useEncryption(
                boolean useEncryption) {
            setProperty("useEncryption", useEncryption);
            return this;
        }
        /**
         * Define if encryption must be used or not.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common (advanced)
         */
        default AdvancedS3EndpointConsumerBuilder useEncryption(
                String useEncryption) {
            setProperty("useEncryption", useEncryption);
            return this;
        }
        /**
         * If this option is true and includeBody is true, then the
         * S3Object.close() method will be called on exchange completion. This
         * option is strongly related to includeBody option. In case of setting
         * includeBody to true and autocloseBody to false, it will be up to the
         * caller to close the S3Object stream. Setting autocloseBody to true,
         * will close the S3Object stream automatically.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedS3EndpointConsumerBuilder autocloseBody(
                boolean autocloseBody) {
            setProperty("autocloseBody", autocloseBody);
            return this;
        }
        /**
         * If this option is true and includeBody is true, then the
         * S3Object.close() method will be called on exchange completion. This
         * option is strongly related to includeBody option. In case of setting
         * includeBody to true and autocloseBody to false, it will be up to the
         * caller to close the S3Object stream. Setting autocloseBody to true,
         * will close the S3Object stream automatically.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedS3EndpointConsumerBuilder autocloseBody(
                String autocloseBody) {
            setProperty("autocloseBody", autocloseBody);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedS3EndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            setProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedS3EndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            setProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedS3EndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            setProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedS3EndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            setProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedS3EndpointConsumerBuilder pollStrategy(
                PollingConsumerPollStrategy pollStrategy) {
            setProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.PollingConsumerPollStrategy</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedS3EndpointConsumerBuilder pollStrategy(
                String pollStrategy) {
            setProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedS3EndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedS3EndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedS3EndpointConsumerBuilder synchronous(
                boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedS3EndpointConsumerBuilder synchronous(String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Define if Accelerate Mode enabled is true or false.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group:  advanced
         */
        default AdvancedS3EndpointConsumerBuilder accelerateModeEnabled(
                boolean accelerateModeEnabled) {
            setProperty("accelerateModeEnabled", accelerateModeEnabled);
            return this;
        }
        /**
         * Define if Accelerate Mode enabled is true or false.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group:  advanced
         */
        default AdvancedS3EndpointConsumerBuilder accelerateModeEnabled(
                String accelerateModeEnabled) {
            setProperty("accelerateModeEnabled", accelerateModeEnabled);
            return this;
        }
        /**
         * Define if disabled Chunked Encoding is true or false.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group:  advanced
         */
        default AdvancedS3EndpointConsumerBuilder chunkedEncodingDisabled(
                boolean chunkedEncodingDisabled) {
            setProperty("chunkedEncodingDisabled", chunkedEncodingDisabled);
            return this;
        }
        /**
         * Define if disabled Chunked Encoding is true or false.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group:  advanced
         */
        default AdvancedS3EndpointConsumerBuilder chunkedEncodingDisabled(
                String chunkedEncodingDisabled) {
            setProperty("chunkedEncodingDisabled", chunkedEncodingDisabled);
            return this;
        }
        /**
         * Define if Dualstack enabled is true or false.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group:  advanced
         */
        default AdvancedS3EndpointConsumerBuilder dualstackEnabled(
                boolean dualstackEnabled) {
            setProperty("dualstackEnabled", dualstackEnabled);
            return this;
        }
        /**
         * Define if Dualstack enabled is true or false.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group:  advanced
         */
        default AdvancedS3EndpointConsumerBuilder dualstackEnabled(
                String dualstackEnabled) {
            setProperty("dualstackEnabled", dualstackEnabled);
            return this;
        }
        /**
         * Define if Force Global Bucket Access enabled is true or false.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group:  advanced
         */
        default AdvancedS3EndpointConsumerBuilder forceGlobalBucketAccessEnabled(
                boolean forceGlobalBucketAccessEnabled) {
            setProperty("forceGlobalBucketAccessEnabled", forceGlobalBucketAccessEnabled);
            return this;
        }
        /**
         * Define if Force Global Bucket Access enabled is true or false.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group:  advanced
         */
        default AdvancedS3EndpointConsumerBuilder forceGlobalBucketAccessEnabled(
                String forceGlobalBucketAccessEnabled) {
            setProperty("forceGlobalBucketAccessEnabled", forceGlobalBucketAccessEnabled);
            return this;
        }
        /**
         * Define if Payload Signing enabled is true or false.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group:  advanced
         */
        default AdvancedS3EndpointConsumerBuilder payloadSigningEnabled(
                boolean payloadSigningEnabled) {
            setProperty("payloadSigningEnabled", payloadSigningEnabled);
            return this;
        }
        /**
         * Define if Payload Signing enabled is true or false.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group:  advanced
         */
        default AdvancedS3EndpointConsumerBuilder payloadSigningEnabled(
                String payloadSigningEnabled) {
            setProperty("payloadSigningEnabled", payloadSigningEnabled);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the AWS S3 Storage Service component.
     */
    public interface S3EndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedS3EndpointProducerBuilder advanced() {
            return (AdvancedS3EndpointProducerBuilder) this;
        }
        /**
         * Reference to a com.amazonaws.services.s3.AmazonS3 in the registry.
         * 
         * The option is a: <code>com.amazonaws.services.s3.AmazonS3</code>
         * type.
         * 
         * Group: common
         */
        default S3EndpointProducerBuilder amazonS3Client(Object amazonS3Client) {
            setProperty("amazonS3Client", amazonS3Client);
            return this;
        }
        /**
         * Reference to a com.amazonaws.services.s3.AmazonS3 in the registry.
         * 
         * The option will be converted to a
         * <code>com.amazonaws.services.s3.AmazonS3</code> type.
         * 
         * Group: common
         */
        default S3EndpointProducerBuilder amazonS3Client(String amazonS3Client) {
            setProperty("amazonS3Client", amazonS3Client);
            return this;
        }
        /**
         * Setting the autocreation of the bucket.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default S3EndpointProducerBuilder autoCreateBucket(
                boolean autoCreateBucket) {
            setProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }
        /**
         * Setting the autocreation of the bucket.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default S3EndpointProducerBuilder autoCreateBucket(
                String autoCreateBucket) {
            setProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }
        /**
         * Whether or not the S3 client should use path style access.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default S3EndpointProducerBuilder pathStyleAccess(
                boolean pathStyleAccess) {
            setProperty("pathStyleAccess", pathStyleAccess);
            return this;
        }
        /**
         * Whether or not the S3 client should use path style access.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default S3EndpointProducerBuilder pathStyleAccess(String pathStyleAccess) {
            setProperty("pathStyleAccess", pathStyleAccess);
            return this;
        }
        /**
         * The policy for this queue to set in the
         * com.amazonaws.services.s3.AmazonS3#setBucketPolicy() method.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default S3EndpointProducerBuilder policy(String policy) {
            setProperty("policy", policy);
            return this;
        }
        /**
         * To define a proxy host when instantiating the SQS client.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default S3EndpointProducerBuilder proxyHost(String proxyHost) {
            setProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * Specify a proxy port to be used inside the client definition.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default S3EndpointProducerBuilder proxyPort(Integer proxyPort) {
            setProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * Specify a proxy port to be used inside the client definition.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default S3EndpointProducerBuilder proxyPort(String proxyPort) {
            setProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * The region in which S3 client needs to work. When using this
         * parameter, the configuration will expect the capitalized name of the
         * region (for example AP_EAST_1) You'll need to use the name
         * Regions.EU_WEST_1.name().
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default S3EndpointProducerBuilder region(String region) {
            setProperty("region", region);
            return this;
        }
        /**
         * Set whether the S3 client should expect to load credentials on an EC2
         * instance or to expect static credentials to be passed in.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default S3EndpointProducerBuilder useIAMCredentials(
                boolean useIAMCredentials) {
            setProperty("useIAMCredentials", useIAMCredentials);
            return this;
        }
        /**
         * Set whether the S3 client should expect to load credentials on an EC2
         * instance or to expect static credentials to be passed in.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default S3EndpointProducerBuilder useIAMCredentials(
                String useIAMCredentials) {
            setProperty("useIAMCredentials", useIAMCredentials);
            return this;
        }
        /**
         * Delete file object after the S3 file has been uploaded.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default S3EndpointProducerBuilder deleteAfterWrite(
                boolean deleteAfterWrite) {
            setProperty("deleteAfterWrite", deleteAfterWrite);
            return this;
        }
        /**
         * Delete file object after the S3 file has been uploaded.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default S3EndpointProducerBuilder deleteAfterWrite(
                String deleteAfterWrite) {
            setProperty("deleteAfterWrite", deleteAfterWrite);
            return this;
        }
        /**
         * Setting the key name for an element in the bucket through endpoint
         * parameter.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default S3EndpointProducerBuilder keyName(String keyName) {
            setProperty("keyName", keyName);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default S3EndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            setProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default S3EndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            setProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * If it is true, camel will upload the file with multi part format, the
         * part size is decided by the option of partSize.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default S3EndpointProducerBuilder multiPartUpload(
                boolean multiPartUpload) {
            setProperty("multiPartUpload", multiPartUpload);
            return this;
        }
        /**
         * If it is true, camel will upload the file with multi part format, the
         * part size is decided by the option of partSize.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default S3EndpointProducerBuilder multiPartUpload(String multiPartUpload) {
            setProperty("multiPartUpload", multiPartUpload);
            return this;
        }
        /**
         * The operation to do in case the user don't want to do only an upload.
         * 
         * The option is a:
         * <code>org.apache.camel.component.aws.s3.S3Operations</code> type.
         * 
         * Group: producer
         */
        default S3EndpointProducerBuilder operation(S3Operations operation) {
            setProperty("operation", operation);
            return this;
        }
        /**
         * The operation to do in case the user don't want to do only an upload.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.aws.s3.S3Operations</code> type.
         * 
         * Group: producer
         */
        default S3EndpointProducerBuilder operation(String operation) {
            setProperty("operation", operation);
            return this;
        }
        /**
         * Setup the partSize which is used in multi part upload, the default
         * size is 25M.
         * 
         * The option is a: <code>long</code> type.
         * 
         * Group: producer
         */
        default S3EndpointProducerBuilder partSize(long partSize) {
            setProperty("partSize", partSize);
            return this;
        }
        /**
         * Setup the partSize which is used in multi part upload, the default
         * size is 25M.
         * 
         * The option will be converted to a <code>long</code> type.
         * 
         * Group: producer
         */
        default S3EndpointProducerBuilder partSize(String partSize) {
            setProperty("partSize", partSize);
            return this;
        }
        /**
         * Sets the server-side encryption algorithm when encrypting the object
         * using AWS-managed keys. For example use AES256.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default S3EndpointProducerBuilder serverSideEncryption(
                String serverSideEncryption) {
            setProperty("serverSideEncryption", serverSideEncryption);
            return this;
        }
        /**
         * The storage class to set in the
         * com.amazonaws.services.s3.model.PutObjectRequest request.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         */
        default S3EndpointProducerBuilder storageClass(String storageClass) {
            setProperty("storageClass", storageClass);
            return this;
        }
        /**
         * Amazon AWS Access Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default S3EndpointProducerBuilder accessKey(String accessKey) {
            setProperty("accessKey", accessKey);
            return this;
        }
        /**
         * Amazon AWS Secret Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default S3EndpointProducerBuilder secretKey(String secretKey) {
            setProperty("secretKey", secretKey);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the AWS S3 Storage Service
     * component.
     */
    public interface AdvancedS3EndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default S3EndpointProducerBuilder basic() {
            return (S3EndpointProducerBuilder) this;
        }
        /**
         * The encryption materials to use in case of Symmetric/Asymmetric
         * client usage.
         * 
         * The option is a:
         * <code>com.amazonaws.services.s3.model.EncryptionMaterials</code>
         * type.
         * 
         * Group: common (advanced)
         */
        default AdvancedS3EndpointProducerBuilder encryptionMaterials(
                Object encryptionMaterials) {
            setProperty("encryptionMaterials", encryptionMaterials);
            return this;
        }
        /**
         * The encryption materials to use in case of Symmetric/Asymmetric
         * client usage.
         * 
         * The option will be converted to a
         * <code>com.amazonaws.services.s3.model.EncryptionMaterials</code>
         * type.
         * 
         * Group: common (advanced)
         */
        default AdvancedS3EndpointProducerBuilder encryptionMaterials(
                String encryptionMaterials) {
            setProperty("encryptionMaterials", encryptionMaterials);
            return this;
        }
        /**
         * Define if encryption must be used or not.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common (advanced)
         */
        default AdvancedS3EndpointProducerBuilder useEncryption(
                boolean useEncryption) {
            setProperty("useEncryption", useEncryption);
            return this;
        }
        /**
         * Define if encryption must be used or not.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common (advanced)
         */
        default AdvancedS3EndpointProducerBuilder useEncryption(
                String useEncryption) {
            setProperty("useEncryption", useEncryption);
            return this;
        }
        /**
         * Define the id of KMS key to use in case KMS is enabled.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer (advanced)
         */
        default AdvancedS3EndpointProducerBuilder awsKMSKeyId(String awsKMSKeyId) {
            setProperty("awsKMSKeyId", awsKMSKeyId);
            return this;
        }
        /**
         * Define if KMS must be used or not.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer (advanced)
         */
        default AdvancedS3EndpointProducerBuilder useAwsKMS(boolean useAwsKMS) {
            setProperty("useAwsKMS", useAwsKMS);
            return this;
        }
        /**
         * Define if KMS must be used or not.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer (advanced)
         */
        default AdvancedS3EndpointProducerBuilder useAwsKMS(String useAwsKMS) {
            setProperty("useAwsKMS", useAwsKMS);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedS3EndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedS3EndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedS3EndpointProducerBuilder synchronous(
                boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedS3EndpointProducerBuilder synchronous(String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Define if Accelerate Mode enabled is true or false.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group:  advanced
         */
        default AdvancedS3EndpointProducerBuilder accelerateModeEnabled(
                boolean accelerateModeEnabled) {
            setProperty("accelerateModeEnabled", accelerateModeEnabled);
            return this;
        }
        /**
         * Define if Accelerate Mode enabled is true or false.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group:  advanced
         */
        default AdvancedS3EndpointProducerBuilder accelerateModeEnabled(
                String accelerateModeEnabled) {
            setProperty("accelerateModeEnabled", accelerateModeEnabled);
            return this;
        }
        /**
         * Define if disabled Chunked Encoding is true or false.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group:  advanced
         */
        default AdvancedS3EndpointProducerBuilder chunkedEncodingDisabled(
                boolean chunkedEncodingDisabled) {
            setProperty("chunkedEncodingDisabled", chunkedEncodingDisabled);
            return this;
        }
        /**
         * Define if disabled Chunked Encoding is true or false.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group:  advanced
         */
        default AdvancedS3EndpointProducerBuilder chunkedEncodingDisabled(
                String chunkedEncodingDisabled) {
            setProperty("chunkedEncodingDisabled", chunkedEncodingDisabled);
            return this;
        }
        /**
         * Define if Dualstack enabled is true or false.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group:  advanced
         */
        default AdvancedS3EndpointProducerBuilder dualstackEnabled(
                boolean dualstackEnabled) {
            setProperty("dualstackEnabled", dualstackEnabled);
            return this;
        }
        /**
         * Define if Dualstack enabled is true or false.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group:  advanced
         */
        default AdvancedS3EndpointProducerBuilder dualstackEnabled(
                String dualstackEnabled) {
            setProperty("dualstackEnabled", dualstackEnabled);
            return this;
        }
        /**
         * Define if Force Global Bucket Access enabled is true or false.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group:  advanced
         */
        default AdvancedS3EndpointProducerBuilder forceGlobalBucketAccessEnabled(
                boolean forceGlobalBucketAccessEnabled) {
            setProperty("forceGlobalBucketAccessEnabled", forceGlobalBucketAccessEnabled);
            return this;
        }
        /**
         * Define if Force Global Bucket Access enabled is true or false.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group:  advanced
         */
        default AdvancedS3EndpointProducerBuilder forceGlobalBucketAccessEnabled(
                String forceGlobalBucketAccessEnabled) {
            setProperty("forceGlobalBucketAccessEnabled", forceGlobalBucketAccessEnabled);
            return this;
        }
        /**
         * Define if Payload Signing enabled is true or false.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group:  advanced
         */
        default AdvancedS3EndpointProducerBuilder payloadSigningEnabled(
                boolean payloadSigningEnabled) {
            setProperty("payloadSigningEnabled", payloadSigningEnabled);
            return this;
        }
        /**
         * Define if Payload Signing enabled is true or false.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group:  advanced
         */
        default AdvancedS3EndpointProducerBuilder payloadSigningEnabled(
                String payloadSigningEnabled) {
            setProperty("payloadSigningEnabled", payloadSigningEnabled);
            return this;
        }
    }

    /**
     * Builder for endpoint for the AWS S3 Storage Service component.
     */
    public interface S3EndpointBuilder
            extends
                S3EndpointConsumerBuilder, S3EndpointProducerBuilder {
        default AdvancedS3EndpointBuilder advanced() {
            return (AdvancedS3EndpointBuilder) this;
        }
        /**
         * Reference to a com.amazonaws.services.s3.AmazonS3 in the registry.
         * 
         * The option is a: <code>com.amazonaws.services.s3.AmazonS3</code>
         * type.
         * 
         * Group: common
         */
        default S3EndpointBuilder amazonS3Client(Object amazonS3Client) {
            setProperty("amazonS3Client", amazonS3Client);
            return this;
        }
        /**
         * Reference to a com.amazonaws.services.s3.AmazonS3 in the registry.
         * 
         * The option will be converted to a
         * <code>com.amazonaws.services.s3.AmazonS3</code> type.
         * 
         * Group: common
         */
        default S3EndpointBuilder amazonS3Client(String amazonS3Client) {
            setProperty("amazonS3Client", amazonS3Client);
            return this;
        }
        /**
         * Setting the autocreation of the bucket.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default S3EndpointBuilder autoCreateBucket(boolean autoCreateBucket) {
            setProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }
        /**
         * Setting the autocreation of the bucket.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default S3EndpointBuilder autoCreateBucket(String autoCreateBucket) {
            setProperty("autoCreateBucket", autoCreateBucket);
            return this;
        }
        /**
         * Whether or not the S3 client should use path style access.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default S3EndpointBuilder pathStyleAccess(boolean pathStyleAccess) {
            setProperty("pathStyleAccess", pathStyleAccess);
            return this;
        }
        /**
         * Whether or not the S3 client should use path style access.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default S3EndpointBuilder pathStyleAccess(String pathStyleAccess) {
            setProperty("pathStyleAccess", pathStyleAccess);
            return this;
        }
        /**
         * The policy for this queue to set in the
         * com.amazonaws.services.s3.AmazonS3#setBucketPolicy() method.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default S3EndpointBuilder policy(String policy) {
            setProperty("policy", policy);
            return this;
        }
        /**
         * To define a proxy host when instantiating the SQS client.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default S3EndpointBuilder proxyHost(String proxyHost) {
            setProperty("proxyHost", proxyHost);
            return this;
        }
        /**
         * Specify a proxy port to be used inside the client definition.
         * 
         * The option is a: <code>java.lang.Integer</code> type.
         * 
         * Group: common
         */
        default S3EndpointBuilder proxyPort(Integer proxyPort) {
            setProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * Specify a proxy port to be used inside the client definition.
         * 
         * The option will be converted to a <code>java.lang.Integer</code>
         * type.
         * 
         * Group: common
         */
        default S3EndpointBuilder proxyPort(String proxyPort) {
            setProperty("proxyPort", proxyPort);
            return this;
        }
        /**
         * The region in which S3 client needs to work. When using this
         * parameter, the configuration will expect the capitalized name of the
         * region (for example AP_EAST_1) You'll need to use the name
         * Regions.EU_WEST_1.name().
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default S3EndpointBuilder region(String region) {
            setProperty("region", region);
            return this;
        }
        /**
         * Set whether the S3 client should expect to load credentials on an EC2
         * instance or to expect static credentials to be passed in.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common
         */
        default S3EndpointBuilder useIAMCredentials(boolean useIAMCredentials) {
            setProperty("useIAMCredentials", useIAMCredentials);
            return this;
        }
        /**
         * Set whether the S3 client should expect to load credentials on an EC2
         * instance or to expect static credentials to be passed in.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common
         */
        default S3EndpointBuilder useIAMCredentials(String useIAMCredentials) {
            setProperty("useIAMCredentials", useIAMCredentials);
            return this;
        }
        /**
         * Amazon AWS Access Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default S3EndpointBuilder accessKey(String accessKey) {
            setProperty("accessKey", accessKey);
            return this;
        }
        /**
         * Amazon AWS Secret Key.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: security
         */
        default S3EndpointBuilder secretKey(String secretKey) {
            setProperty("secretKey", secretKey);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the AWS S3 Storage Service component.
     */
    public interface AdvancedS3EndpointBuilder
            extends
                AdvancedS3EndpointConsumerBuilder, AdvancedS3EndpointProducerBuilder {
        default S3EndpointBuilder basic() {
            return (S3EndpointBuilder) this;
        }
        /**
         * The encryption materials to use in case of Symmetric/Asymmetric
         * client usage.
         * 
         * The option is a:
         * <code>com.amazonaws.services.s3.model.EncryptionMaterials</code>
         * type.
         * 
         * Group: common (advanced)
         */
        default AdvancedS3EndpointBuilder encryptionMaterials(
                Object encryptionMaterials) {
            setProperty("encryptionMaterials", encryptionMaterials);
            return this;
        }
        /**
         * The encryption materials to use in case of Symmetric/Asymmetric
         * client usage.
         * 
         * The option will be converted to a
         * <code>com.amazonaws.services.s3.model.EncryptionMaterials</code>
         * type.
         * 
         * Group: common (advanced)
         */
        default AdvancedS3EndpointBuilder encryptionMaterials(
                String encryptionMaterials) {
            setProperty("encryptionMaterials", encryptionMaterials);
            return this;
        }
        /**
         * Define if encryption must be used or not.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: common (advanced)
         */
        default AdvancedS3EndpointBuilder useEncryption(boolean useEncryption) {
            setProperty("useEncryption", useEncryption);
            return this;
        }
        /**
         * Define if encryption must be used or not.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: common (advanced)
         */
        default AdvancedS3EndpointBuilder useEncryption(String useEncryption) {
            setProperty("useEncryption", useEncryption);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedS3EndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedS3EndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedS3EndpointBuilder synchronous(boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedS3EndpointBuilder synchronous(String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Define if Accelerate Mode enabled is true or false.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group:  advanced
         */
        default AdvancedS3EndpointBuilder accelerateModeEnabled(
                boolean accelerateModeEnabled) {
            setProperty("accelerateModeEnabled", accelerateModeEnabled);
            return this;
        }
        /**
         * Define if Accelerate Mode enabled is true or false.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group:  advanced
         */
        default AdvancedS3EndpointBuilder accelerateModeEnabled(
                String accelerateModeEnabled) {
            setProperty("accelerateModeEnabled", accelerateModeEnabled);
            return this;
        }
        /**
         * Define if disabled Chunked Encoding is true or false.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group:  advanced
         */
        default AdvancedS3EndpointBuilder chunkedEncodingDisabled(
                boolean chunkedEncodingDisabled) {
            setProperty("chunkedEncodingDisabled", chunkedEncodingDisabled);
            return this;
        }
        /**
         * Define if disabled Chunked Encoding is true or false.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group:  advanced
         */
        default AdvancedS3EndpointBuilder chunkedEncodingDisabled(
                String chunkedEncodingDisabled) {
            setProperty("chunkedEncodingDisabled", chunkedEncodingDisabled);
            return this;
        }
        /**
         * Define if Dualstack enabled is true or false.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group:  advanced
         */
        default AdvancedS3EndpointBuilder dualstackEnabled(
                boolean dualstackEnabled) {
            setProperty("dualstackEnabled", dualstackEnabled);
            return this;
        }
        /**
         * Define if Dualstack enabled is true or false.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group:  advanced
         */
        default AdvancedS3EndpointBuilder dualstackEnabled(
                String dualstackEnabled) {
            setProperty("dualstackEnabled", dualstackEnabled);
            return this;
        }
        /**
         * Define if Force Global Bucket Access enabled is true or false.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group:  advanced
         */
        default AdvancedS3EndpointBuilder forceGlobalBucketAccessEnabled(
                boolean forceGlobalBucketAccessEnabled) {
            setProperty("forceGlobalBucketAccessEnabled", forceGlobalBucketAccessEnabled);
            return this;
        }
        /**
         * Define if Force Global Bucket Access enabled is true or false.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group:  advanced
         */
        default AdvancedS3EndpointBuilder forceGlobalBucketAccessEnabled(
                String forceGlobalBucketAccessEnabled) {
            setProperty("forceGlobalBucketAccessEnabled", forceGlobalBucketAccessEnabled);
            return this;
        }
        /**
         * Define if Payload Signing enabled is true or false.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group:  advanced
         */
        default AdvancedS3EndpointBuilder payloadSigningEnabled(
                boolean payloadSigningEnabled) {
            setProperty("payloadSigningEnabled", payloadSigningEnabled);
            return this;
        }
        /**
         * Define if Payload Signing enabled is true or false.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group:  advanced
         */
        default AdvancedS3EndpointBuilder payloadSigningEnabled(
                String payloadSigningEnabled) {
            setProperty("payloadSigningEnabled", payloadSigningEnabled);
            return this;
        }
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.aws.s3.S3Operations</code> enum.
     */
    enum S3Operations {
        copyObject,
        listObjects,
        deleteObject,
        deleteBucket,
        listBuckets,
        downloadLink,
        getObject;
    }
    /**
     * AWS S3 Storage Service (camel-aws-s3)
     * The aws-s3 component is used for storing and retrieving objecct from
     * Amazon S3 Storage Service.
     * 
     * Category: cloud,file
     * Available as of version: 2.8
     * Maven coordinates: org.apache.camel:camel-aws-s3
     * 
     * Syntax: <code>aws-s3:bucketNameOrArn</code>
     * 
     * Path parameter: bucketNameOrArn (required)
     * Bucket name or ARN
     */
    default S3EndpointBuilder s3(String path) {
        class S3EndpointBuilderImpl extends AbstractEndpointBuilder implements S3EndpointBuilder, AdvancedS3EndpointBuilder {
            public S3EndpointBuilderImpl(String path) {
                super("aws-s3", path);
            }
        }
        return new S3EndpointBuilderImpl(path);
    }
}