/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.HeaderFilterStrategy;

/**
 * Component for consuming and producing Restful resources using Restlet.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface RestletEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Restlet component.
     */
    public interface RestletEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedRestletEndpointConsumerBuilder advanced() {
            return (AdvancedRestletEndpointConsumerBuilder) this;
        }
        /**
         * On a producer endpoint, specifies the request method to use. On a
         * consumer endpoint, specifies that the endpoint consumes only
         * restletMethod requests.
         * 
         * The option is a: <code>org.restlet.data.Method</code> type.
         * 
         * Group: common
         */
        default RestletEndpointConsumerBuilder restletMethod(
                Object restletMethod) {
            setProperty("restletMethod", restletMethod);
            return this;
        }
        /**
         * On a producer endpoint, specifies the request method to use. On a
         * consumer endpoint, specifies that the endpoint consumes only
         * restletMethod requests.
         * 
         * The option will be converted to a
         * <code>org.restlet.data.Method</code> type.
         * 
         * Group: common
         */
        default RestletEndpointConsumerBuilder restletMethod(
                String restletMethod) {
            setProperty("restletMethod", restletMethod);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default RestletEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            setProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer
         */
        default RestletEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            setProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Specify one or more methods separated by commas (e.g.
         * restletMethods=post,put) to be serviced by a restlet consumer
         * endpoint. If both restletMethod and restletMethods options are
         * specified, the restletMethod setting is ignored. The possible methods
         * are: ALL,CONNECT,DELETE,GET,HEAD,OPTIONS,PATCH,POST,PUT,TRACE.
         * 
         * The option is a: <code>org.restlet.data.Method[]</code> type.
         * 
         * Group: consumer
         */
        default RestletEndpointConsumerBuilder restletMethods(
                Object[] restletMethods) {
            setProperty("restletMethods", restletMethods);
            return this;
        }
        /**
         * Specify one or more methods separated by commas (e.g.
         * restletMethods=post,put) to be serviced by a restlet consumer
         * endpoint. If both restletMethod and restletMethods options are
         * specified, the restletMethod setting is ignored. The possible methods
         * are: ALL,CONNECT,DELETE,GET,HEAD,OPTIONS,PATCH,POST,PUT,TRACE.
         * 
         * The option will be converted to a
         * <code>org.restlet.data.Method[]</code> type.
         * 
         * Group: consumer
         */
        default RestletEndpointConsumerBuilder restletMethods(
                String restletMethods) {
            setProperty("restletMethods", restletMethods);
            return this;
        }
        /**
         * To configure the security realms of restlet as a map.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.String&gt;</code> type.
         * 
         * Group: security
         */
        default RestletEndpointConsumerBuilder restletRealm(
                Map<String, String> restletRealm) {
            setProperty("restletRealm", restletRealm);
            return this;
        }
        /**
         * To configure the security realms of restlet as a map.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.String&gt;</code>
         * type.
         * 
         * Group: security
         */
        default RestletEndpointConsumerBuilder restletRealm(String restletRealm) {
            setProperty("restletRealm", restletRealm);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default RestletEndpointConsumerBuilder sslContextParameters(
                Object sslContextParameters) {
            setProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default RestletEndpointConsumerBuilder sslContextParameters(
                String sslContextParameters) {
            setProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Restlet component.
     */
    public interface AdvancedRestletEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default RestletEndpointConsumerBuilder basic() {
            return (RestletEndpointConsumerBuilder) this;
        }
        /**
         * Determines whether or not the raw input stream from Restlet is cached
         * or not (Camel will read the stream into a in memory/overflow to file,
         * Stream caching) cache. By default Camel will cache the Restlet input
         * stream to support reading it multiple times to ensure Camel can
         * retrieve all data from the stream. However you can set this option to
         * true when you for example need to access the raw stream, such as
         * streaming it directly to a file or other persistent store.
         * DefaultRestletBinding will copy the request input stream into a
         * stream cache and put it into message body if this option is false to
         * support reading the stream multiple times.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedRestletEndpointConsumerBuilder disableStreamCache(
                boolean disableStreamCache) {
            setProperty("disableStreamCache", disableStreamCache);
            return this;
        }
        /**
         * Determines whether or not the raw input stream from Restlet is cached
         * or not (Camel will read the stream into a in memory/overflow to file,
         * Stream caching) cache. By default Camel will cache the Restlet input
         * stream to support reading it multiple times to ensure Camel can
         * retrieve all data from the stream. However you can set this option to
         * true when you for example need to access the raw stream, such as
         * streaming it directly to a file or other persistent store.
         * DefaultRestletBinding will copy the request input stream into a
         * stream cache and put it into message body if this option is false to
         * support reading the stream multiple times.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedRestletEndpointConsumerBuilder disableStreamCache(
                String disableStreamCache) {
            setProperty("disableStreamCache", disableStreamCache);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedRestletEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            setProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedRestletEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            setProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedRestletEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            setProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         */
        default AdvancedRestletEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            setProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRestletEndpointConsumerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRestletEndpointConsumerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRestletEndpointConsumerBuilder headerFilterStrategy(
                HeaderFilterStrategy headerFilterStrategy) {
            setProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRestletEndpointConsumerBuilder headerFilterStrategy(
                String headerFilterStrategy) {
            setProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom RestletBinding to bind between Restlet and Camel
         * message.
         * 
         * The option is a:
         * <code>org.apache.camel.component.restlet.RestletBinding</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRestletEndpointConsumerBuilder restletBinding(
                Object restletBinding) {
            setProperty("restletBinding", restletBinding);
            return this;
        }
        /**
         * To use a custom RestletBinding to bind between Restlet and Camel
         * message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.restlet.RestletBinding</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRestletEndpointConsumerBuilder restletBinding(
                String restletBinding) {
            setProperty("restletBinding", restletBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRestletEndpointConsumerBuilder synchronous(
                Boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedRestletEndpointConsumerBuilder synchronous(
                String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Restlet component.
     */
    public interface RestletEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedRestletEndpointProducerBuilder advanced() {
            return (AdvancedRestletEndpointProducerBuilder) this;
        }
        /**
         * On a producer endpoint, specifies the request method to use. On a
         * consumer endpoint, specifies that the endpoint consumes only
         * restletMethod requests.
         * 
         * The option is a: <code>org.restlet.data.Method</code> type.
         * 
         * Group: common
         */
        default RestletEndpointProducerBuilder restletMethod(
                Object restletMethod) {
            setProperty("restletMethod", restletMethod);
            return this;
        }
        /**
         * On a producer endpoint, specifies the request method to use. On a
         * consumer endpoint, specifies that the endpoint consumes only
         * restletMethod requests.
         * 
         * The option will be converted to a
         * <code>org.restlet.data.Method</code> type.
         * 
         * Group: common
         */
        default RestletEndpointProducerBuilder restletMethod(
                String restletMethod) {
            setProperty("restletMethod", restletMethod);
            return this;
        }
        /**
         * The Client will give up connection if the connection is timeout, 0
         * for unlimited wait.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: producer
         */
        default RestletEndpointProducerBuilder connectTimeout(int connectTimeout) {
            setProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * The Client will give up connection if the connection is timeout, 0
         * for unlimited wait.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: producer
         */
        default RestletEndpointProducerBuilder connectTimeout(
                String connectTimeout) {
            setProperty("connectTimeout", connectTimeout);
            return this;
        }
        /**
         * Configure a cookie handler to maintain a HTTP session.
         * 
         * The option is a:
         * <code>org.apache.camel.http.common.cookie.CookieHandler</code> type.
         * 
         * Group: producer
         */
        default RestletEndpointProducerBuilder cookieHandler(
                Object cookieHandler) {
            setProperty("cookieHandler", cookieHandler);
            return this;
        }
        /**
         * Configure a cookie handler to maintain a HTTP session.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.http.common.cookie.CookieHandler</code> type.
         * 
         * Group: producer
         */
        default RestletEndpointProducerBuilder cookieHandler(
                String cookieHandler) {
            setProperty("cookieHandler", cookieHandler);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default RestletEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            setProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default RestletEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            setProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * The Client socket receive timeout, 0 for unlimited wait.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: producer
         */
        default RestletEndpointProducerBuilder socketTimeout(int socketTimeout) {
            setProperty("socketTimeout", socketTimeout);
            return this;
        }
        /**
         * The Client socket receive timeout, 0 for unlimited wait.
         * 
         * The option will be converted to a <code>int</code> type.
         * 
         * Group: producer
         */
        default RestletEndpointProducerBuilder socketTimeout(
                String socketTimeout) {
            setProperty("socketTimeout", socketTimeout);
            return this;
        }
        /**
         * Whether to throw exception on a producer failure. If this option is
         * false then the http status code is set as a message header which can
         * be checked if it has an error value.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer
         */
        default RestletEndpointProducerBuilder throwExceptionOnFailure(
                boolean throwExceptionOnFailure) {
            setProperty("throwExceptionOnFailure", throwExceptionOnFailure);
            return this;
        }
        /**
         * Whether to throw exception on a producer failure. If this option is
         * false then the http status code is set as a message header which can
         * be checked if it has an error value.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer
         */
        default RestletEndpointProducerBuilder throwExceptionOnFailure(
                String throwExceptionOnFailure) {
            setProperty("throwExceptionOnFailure", throwExceptionOnFailure);
            return this;
        }
        /**
         * To configure the security realms of restlet as a map.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.String&gt;</code> type.
         * 
         * Group: security
         */
        default RestletEndpointProducerBuilder restletRealm(
                Map<String, String> restletRealm) {
            setProperty("restletRealm", restletRealm);
            return this;
        }
        /**
         * To configure the security realms of restlet as a map.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.String&gt;</code>
         * type.
         * 
         * Group: security
         */
        default RestletEndpointProducerBuilder restletRealm(String restletRealm) {
            setProperty("restletRealm", restletRealm);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default RestletEndpointProducerBuilder sslContextParameters(
                Object sslContextParameters) {
            setProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default RestletEndpointProducerBuilder sslContextParameters(
                String sslContextParameters) {
            setProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Restlet component.
     */
    public interface AdvancedRestletEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default RestletEndpointProducerBuilder basic() {
            return (RestletEndpointProducerBuilder) this;
        }
        /**
         * Whether to auto close the stream representation as response from
         * calling a REST service using the restlet producer. If the response is
         * streaming and the option streamRepresentation is enabled then you may
         * want to auto close the InputStream from the streaming response to
         * ensure the input stream is closed when the Camel Exchange is done
         * being routed. However if you need to read the stream outside a Camel
         * route, you may need to not auto close the stream.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer (advanced)
         */
        default AdvancedRestletEndpointProducerBuilder autoCloseStream(
                boolean autoCloseStream) {
            setProperty("autoCloseStream", autoCloseStream);
            return this;
        }
        /**
         * Whether to auto close the stream representation as response from
         * calling a REST service using the restlet producer. If the response is
         * streaming and the option streamRepresentation is enabled then you may
         * want to auto close the InputStream from the streaming response to
         * ensure the input stream is closed when the Camel Exchange is done
         * being routed. However if you need to read the stream outside a Camel
         * route, you may need to not auto close the stream.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer (advanced)
         */
        default AdvancedRestletEndpointProducerBuilder autoCloseStream(
                String autoCloseStream) {
            setProperty("autoCloseStream", autoCloseStream);
            return this;
        }
        /**
         * Whether to support stream representation as response from calling a
         * REST service using the restlet producer. If the response is streaming
         * then this option can be enabled to use an java.io.InputStream as the
         * message body on the Camel Message body. If using this option you may
         * want to enable the autoCloseStream option as well to ensure the input
         * stream is closed when the Camel Exchange is done being routed.
         * However if you need to read the stream outside a Camel route, you may
         * need to not auto close the stream.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: producer (advanced)
         */
        default AdvancedRestletEndpointProducerBuilder streamRepresentation(
                boolean streamRepresentation) {
            setProperty("streamRepresentation", streamRepresentation);
            return this;
        }
        /**
         * Whether to support stream representation as response from calling a
         * REST service using the restlet producer. If the response is streaming
         * then this option can be enabled to use an java.io.InputStream as the
         * message body on the Camel Message body. If using this option you may
         * want to enable the autoCloseStream option as well to ensure the input
         * stream is closed when the Camel Exchange is done being routed.
         * However if you need to read the stream outside a Camel route, you may
         * need to not auto close the stream.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: producer (advanced)
         */
        default AdvancedRestletEndpointProducerBuilder streamRepresentation(
                String streamRepresentation) {
            setProperty("streamRepresentation", streamRepresentation);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRestletEndpointProducerBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRestletEndpointProducerBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRestletEndpointProducerBuilder headerFilterStrategy(
                HeaderFilterStrategy headerFilterStrategy) {
            setProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRestletEndpointProducerBuilder headerFilterStrategy(
                String headerFilterStrategy) {
            setProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom RestletBinding to bind between Restlet and Camel
         * message.
         * 
         * The option is a:
         * <code>org.apache.camel.component.restlet.RestletBinding</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRestletEndpointProducerBuilder restletBinding(
                Object restletBinding) {
            setProperty("restletBinding", restletBinding);
            return this;
        }
        /**
         * To use a custom RestletBinding to bind between Restlet and Camel
         * message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.restlet.RestletBinding</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRestletEndpointProducerBuilder restletBinding(
                String restletBinding) {
            setProperty("restletBinding", restletBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRestletEndpointProducerBuilder synchronous(
                Boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedRestletEndpointProducerBuilder synchronous(
                String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Restlet component.
     */
    public interface RestletEndpointBuilder
            extends
                RestletEndpointConsumerBuilder, RestletEndpointProducerBuilder {
        default AdvancedRestletEndpointBuilder advanced() {
            return (AdvancedRestletEndpointBuilder) this;
        }
        /**
         * On a producer endpoint, specifies the request method to use. On a
         * consumer endpoint, specifies that the endpoint consumes only
         * restletMethod requests.
         * 
         * The option is a: <code>org.restlet.data.Method</code> type.
         * 
         * Group: common
         */
        default RestletEndpointBuilder restletMethod(Object restletMethod) {
            setProperty("restletMethod", restletMethod);
            return this;
        }
        /**
         * On a producer endpoint, specifies the request method to use. On a
         * consumer endpoint, specifies that the endpoint consumes only
         * restletMethod requests.
         * 
         * The option will be converted to a
         * <code>org.restlet.data.Method</code> type.
         * 
         * Group: common
         */
        default RestletEndpointBuilder restletMethod(String restletMethod) {
            setProperty("restletMethod", restletMethod);
            return this;
        }
        /**
         * To configure the security realms of restlet as a map.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.String&gt;</code> type.
         * 
         * Group: security
         */
        default RestletEndpointBuilder restletRealm(
                Map<String, String> restletRealm) {
            setProperty("restletRealm", restletRealm);
            return this;
        }
        /**
         * To configure the security realms of restlet as a map.
         * 
         * The option will be converted to a
         * <code>java.util.Map&lt;java.lang.String, java.lang.String&gt;</code>
         * type.
         * 
         * Group: security
         */
        default RestletEndpointBuilder restletRealm(String restletRealm) {
            setProperty("restletRealm", restletRealm);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option is a:
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default RestletEndpointBuilder sslContextParameters(
                Object sslContextParameters) {
            setProperty("sslContextParameters", sslContextParameters);
            return this;
        }
        /**
         * To configure security using SSLContextParameters.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.support.jsse.SSLContextParameters</code> type.
         * 
         * Group: security
         */
        default RestletEndpointBuilder sslContextParameters(
                String sslContextParameters) {
            setProperty("sslContextParameters", sslContextParameters);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Restlet component.
     */
    public interface AdvancedRestletEndpointBuilder
            extends
                AdvancedRestletEndpointConsumerBuilder, AdvancedRestletEndpointProducerBuilder {
        default RestletEndpointBuilder basic() {
            return (RestletEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRestletEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRestletEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option is a:
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRestletEndpointBuilder headerFilterStrategy(
                HeaderFilterStrategy headerFilterStrategy) {
            setProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom HeaderFilterStrategy to filter header to and from
         * Camel message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.HeaderFilterStrategy</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRestletEndpointBuilder headerFilterStrategy(
                String headerFilterStrategy) {
            setProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
        /**
         * To use a custom RestletBinding to bind between Restlet and Camel
         * message.
         * 
         * The option is a:
         * <code>org.apache.camel.component.restlet.RestletBinding</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRestletEndpointBuilder restletBinding(
                Object restletBinding) {
            setProperty("restletBinding", restletBinding);
            return this;
        }
        /**
         * To use a custom RestletBinding to bind between Restlet and Camel
         * message.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.restlet.RestletBinding</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRestletEndpointBuilder restletBinding(
                String restletBinding) {
            setProperty("restletBinding", restletBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>java.lang.Boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedRestletEndpointBuilder synchronous(Boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>java.lang.Boolean</code>
         * type.
         * 
         * Group: advanced
         */
        default AdvancedRestletEndpointBuilder synchronous(String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }
    /**
     * Restlet (camel-restlet)
     * Component for consuming and producing Restful resources using Restlet.
     * 
     * Category: rest
     * Available as of version: 2.0
     * Maven coordinates: org.apache.camel:camel-restlet
     * 
     * Syntax: <code>restlet:protocol:host:port/uriPattern</code>
     * 
     * Path parameter: protocol (required)
     * The protocol to use which is http or https
     * The value can be one of: http, https
     * 
     * Path parameter: host (required)
     * The hostname of the restlet service
     * 
     * Path parameter: port (required)
     * The port number of the restlet service
     * Default value: 80
     * 
     * Path parameter: uriPattern
     * The resource pattern such as /customer/{id}
     */
    default RestletEndpointBuilder restlet(String path) {
        class RestletEndpointBuilderImpl extends AbstractEndpointBuilder implements RestletEndpointBuilder, AdvancedRestletEndpointBuilder {
            public RestletEndpointBuilderImpl(String path) {
                super("restlet", path);
            }
        }
        return new RestletEndpointBuilderImpl(path);
    }
}