/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import javax.annotation.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * The paxlogging component can be used in an OSGi environment to receive
 * PaxLogging events and process them.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface PaxLoggingEndpointBuilderFactory {


    /**
     * Builder for endpoint for the OSGi PAX Logging component.
     */
    public interface PaxLoggingEndpointBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedPaxLoggingEndpointBuilder advanced() {
            return (AdvancedPaxLoggingEndpointBuilder) this;
        }
    }

    /**
     * Advanced builder for endpoint for the OSGi PAX Logging component.
     */
    public interface AdvancedPaxLoggingEndpointBuilder
            extends
                EndpointConsumerBuilder {
        default PaxLoggingEndpointBuilder basic() {
            return (PaxLoggingEndpointBuilder) this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedPaxLoggingEndpointBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Whether the endpoint should use basic property binding (Camel 2.x) or
         * the newer property binding with additional capabilities.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedPaxLoggingEndpointBuilder basicPropertyBinding(
                String basicPropertyBinding) {
            setProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedPaxLoggingEndpointBuilder synchronous(
                boolean synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
        /**
         * Sets whether synchronous processing should be strictly used, or Camel
         * is allowed to use asynchronous processing (if supported).
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Group: advanced
         */
        default AdvancedPaxLoggingEndpointBuilder synchronous(String synchronous) {
            setProperty("synchronous", synchronous);
            return this;
        }
    }
    /**
     * OSGi PAX Logging (camel-paxlogging)
     * The paxlogging component can be used in an OSGi environment to receive
     * PaxLogging events and process them.
     * 
     * Category: monitoring
     * Available as of version: 2.6
     * Maven coordinates: org.apache.camel:camel-paxlogging
     * 
     * Syntax: <code>paxlogging:appender</code>
     * 
     * Path parameter: appender (required)
     * Appender is the name of the pax appender that need to be configured in
     * the PaxLogging service configuration.
     */
    default PaxLoggingEndpointBuilder paxLogging(String path) {
        class PaxLoggingEndpointBuilderImpl extends AbstractEndpointBuilder implements PaxLoggingEndpointBuilder, AdvancedPaxLoggingEndpointBuilder {
            public PaxLoggingEndpointBuilderImpl(String path) {
                super("paxlogging", path);
            }
        }
        return new PaxLoggingEndpointBuilderImpl(path);
    }
}